/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.export;

import au.com.bytecode.opencsv.CSVReader;
import au.com.bytecode.opencsv.CSVWriter;
import com.sigrity.acl.ALog;
import com.sigrity.acl.ATransformUtil;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.LayerShape;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.geom.ACircle;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.AGeomUtil;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.ui.DbDialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.factory.PartFactory;
import com.sigrity.tools.dbexplorer.DbExplorerPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;

public class TISpreadSheet {
    protected Db mDb;
    protected HashMap<String, Integer> mHeaders;
    protected String[] mCurrentRow;
    protected Device mDevice = null;
    protected String mFilePath;
    protected long mPadPitch;
    protected long mPadWidth;
    protected long mPadHeight;
    protected long mDieWidth;
    protected long mDieHeight;
    protected PadTemplate.PadShapeStyle mPadStyle = PadTemplate.PadShapeStyle.Square;
    protected DeviceTemplate.Type mDeviceType = DeviceTemplate.Type.DIE;
    protected boolean mAbsPositionProvided = false;
    protected String mBaseDieTemplateName;
    protected String mBaseDieInstanceName;
    protected ArrayList<String[]> mCSVContents = new ArrayList();
    protected ArrayList<CSVDeviceInfo> mCreatedDevices = new ArrayList();

    public static boolean readCSV(String filePath, String baseDieTemplateName, String baseDieInstanceName, double padWidth, double padHeight, double dieWidth, double dieHeight, double padPitch) {
        TISpreadSheet ss = new TISpreadSheet(filePath, baseDieTemplateName, baseDieInstanceName, padWidth, padHeight, dieWidth, dieHeight, padPitch);
        return ss.read();
    }

    public static boolean readCSV(String filePath, String baseDieTemplateName, String baseDieInstanceName, double padWidth, double padHeight, double dieWidth, double dieHeight, double padPitch, String padShapeStyle, String deviceType) {
        TISpreadSheet ss = new TISpreadSheet(filePath, baseDieTemplateName, baseDieInstanceName, padWidth, padHeight, dieWidth, dieHeight, padPitch, padShapeStyle, deviceType);
        return ss.read();
    }

    public static boolean readCSV(String filePath, String diePath, double padWidth, double padHeight) {
        assert (diePath != null);
        DevicePath dp = DevicePath.fromString((Db)OrbitIO.getCurDb(), (String)diePath);
        assert (dp != null);
        TISpreadSheet ss = new TISpreadSheet(filePath, dp, padWidth, padHeight);
        return ss.read();
    }

    public static boolean readCSV(String filePath, DevicePath diePath, double padWidth, double padHeight) {
        assert (diePath != null);
        return TISpreadSheet.readCSV(filePath, diePath, padWidth, padHeight);
    }

    protected TISpreadSheet(String filePath, DevicePath diePath, double padWidth, double padHeight) {
        assert (diePath != null && !diePath.isEmpty());
        this.mDb = diePath.getLast().getDb();
        this.mDevice = diePath.getLast();
        ARect bb = this.mDevice.getTemplate().getBB();
        this.mFilePath = filePath;
        Design cd = Design.getDesign((Db)this.mDb);
        this.mPadWidth = cd.getInternal(padWidth);
        this.mPadHeight = cd.getInternal(padWidth);
        this.mDieWidth = bb.width();
        this.mDieHeight = bb.height();
    }

    protected TISpreadSheet(String filePath, String baseDieTemplateName, String baseDieInstanceName, double cellWidth, double cellHeight, double dieWidth, double dieHeight, double padPitch) {
        this.init(filePath, baseDieTemplateName, baseDieInstanceName, cellWidth, cellHeight, dieWidth, dieHeight, padPitch);
    }

    protected TISpreadSheet(String filePath, String baseDieTemplateName, String baseDieInstanceName, double cellWidth, double cellHeight, double dieWidth, double dieHeight, double padPitch, String padShapeStyle, String deviceType) {
        this.init(filePath, baseDieTemplateName, baseDieInstanceName, cellWidth, cellHeight, dieWidth, dieHeight, padPitch);
        this.mPadStyle = PadTemplate.PadShapeStyle.valueOf((String)padShapeStyle);
        this.mDeviceType = DeviceTemplate.Type.valueOf((String)deviceType);
    }

    private void init(String filePath, String baseDieTemplateName, String baseDieInstanceName, double cellWidth, double cellHeight, double dieWidth, double dieHeight, double padPitch) {
        this.mDb = OrbitIO.getCurDb();
        this.mFilePath = filePath;
        this.mBaseDieTemplateName = baseDieTemplateName;
        this.mBaseDieInstanceName = baseDieInstanceName;
        Design cd = Design.getDesign((Db)this.mDb);
        this.mPadWidth = cd.getInternal(cellWidth);
        this.mPadHeight = cd.getInternal(cellHeight);
        this.mDieWidth = cd.getInternal(dieWidth);
        this.mDieHeight = cd.getInternal(dieHeight);
        this.mPadPitch = cd.getInternal(padPitch);
    }

    protected boolean read() {
        File file = new File(this.mFilePath);
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            ALog.logError((Throwable)e, (String)"Unable to read '%s'.", (Object[])new Object[]{this.mFilePath});
            return false;
        }
        return this.readCsv(fis);
    }

    protected boolean readCsv(FileInputStream fis) {
        if (this.mDeviceType == DeviceTemplate.Type.PACKAGE) {
            return this.readPackageCsv(fis);
        }
        return this.readDieCsv(fis);
    }

    protected boolean readPackageCsv(FileInputStream fis) {
        if (!this.createPackage()) {
            return false;
        }
        CSVReader reader = new CSVReader((Reader)new InputStreamReader(fis));
        try {
            String[] row;
            int badRows = 0;
            int goodRows = 0;
            String[] columns = reader.readNext();
            this.mHeaders = new HashMap();
            for (int i = 0; i < columns.length; ++i) {
                this.mHeaders.put(columns[i].toLowerCase(), i);
            }
            int colLocX = this.getFieldIndex("x_ctr");
            int colLocY = this.getFieldIndex("y_ctr");
            while ((row = reader.readNext()) != null) {
                this.mCSVContents.add(row);
                if (colLocX < 0 || colLocY < 0 || row[colLocX].isEmpty() || row[colLocY].isEmpty()) continue;
                this.mAbsPositionProvided = true;
            }
            reader.close();
            fis.close();
            if (!this.validateData()) {
                return false;
            }
            if (!this.mAbsPositionProvided) {
                return false;
            }
            for (int i = 0; i < this.mCSVContents.size(); ++i) {
                this.mCurrentRow = this.mCSVContents.get(i);
                boolean status = this.addBallPad(i);
                if (!status) {
                    ++badRows;
                    continue;
                }
                ++goodRows;
            }
            OrbitIO app = OrbitIO.getApp();
            app.getWorkspace().refreshCurrentView(false);
            DbExplorerPanel.refreshAll();
            ALog.logInfo((String)("There were " + goodRows + " device(s) read and " + badRows + " device(s) ignored because of problems"));
        }
        catch (IOException e) {
            ALog.logError((Throwable)e, (String)"Error reading input file.", (Object[])new Object[0]);
            return false;
        }
        return true;
    }

    protected boolean readDieCsv(FileInputStream fis) {
        if (!this.createDie()) {
            return false;
        }
        CSVReader reader = new CSVReader((Reader)new InputStreamReader(fis));
        try {
            String[] row;
            int badRows = 0;
            int goodRows = 0;
            String[] columns = reader.readNext();
            this.mHeaders = new HashMap();
            for (int i = 0; i < columns.length; ++i) {
                this.mHeaders.put(columns[i].toLowerCase(), i);
            }
            int colLocX = this.getFieldIndex("x_ctr");
            int colLocY = this.getFieldIndex("y_ctr");
            while ((row = reader.readNext()) != null) {
                this.mCSVContents.add(row);
                if (colLocX < 0 || colLocY < 0 || row[colLocX].isEmpty() || row[colLocY].isEmpty()) continue;
                this.mAbsPositionProvided = true;
            }
            reader.close();
            fis.close();
            if (!this.validateData()) {
                return false;
            }
            for (int i = 0; i < this.mCSVContents.size(); ++i) {
                this.mCurrentRow = this.mCSVContents.get(i);
                boolean status = this.addDevice(i);
                if (!status) {
                    ++badRows;
                    continue;
                }
                ++goodRows;
            }
            if (this.mAbsPositionProvided) {
                this.locateDevicesGivenAbsolutePositions();
            } else {
                this.locateDevices();
            }
            OrbitIO app = OrbitIO.getApp();
            app.getWorkspace().refreshCurrentView(false);
            DbExplorerPanel.refreshAll();
            ALog.logInfo((String)("There were " + goodRows + " device(s) read and " + badRows + " device(s) ignored because of problems"));
        }
        catch (IOException e) {
            ALog.logError((Throwable)e, (String)"Error reading input file.", (Object[])new Object[0]);
            return false;
        }
        return true;
    }

    protected boolean validateData() {
        ArrayList<Integer> invalidRows = this.getInvalidRows();
        if (invalidRows.size() > 0) {
            PinLocationUI ui = new PinLocationUI(this.mDb, OrbitIO.getMainWindow(), "", invalidRows);
            ui.setVisible(true);
            return !ui.mIsCanceled;
        }
        return true;
    }

    protected ArrayList<Integer> getInvalidRows() {
        ArrayList<Integer> invalidRows = new ArrayList<Integer>();
        int[] checkCols = this.mAbsPositionProvided ? new int[]{this.getFieldIndex("x_ctr"), this.getFieldIndex("y_ctr")} : new int[]{this.getFieldIndex("group"), this.getFieldIndex("group rel. x"), this.getFieldIndex("group rel. y")};
        block0: for (int i = 0; i < this.mCSVContents.size(); ++i) {
            String[] vs = this.mCSVContents.get(i);
            for (int j = 0; j < checkCols.length; ++j) {
                String v = vs[checkCols[j]];
                if (this.mAbsPositionProvided) {
                    if (v != null && !v.isEmpty()) continue;
                    invalidRows.add(i);
                    continue block0;
                }
                if (j == 0) {
                    if (v != null && !v.isEmpty()) continue;
                    continue block0;
                }
                if (v != null && !v.isEmpty()) continue;
                invalidRows.add(i);
                continue block0;
            }
        }
        return invalidRows;
    }

    protected boolean createPackage() {
        if (this.mDevice != null) {
            return true;
        }
        this.mDevice = PartFactory.makePackage(this.mBaseDieTemplateName, this.mBaseDieInstanceName, false, this.mDieWidth, this.mDieHeight, 0, 0, 0, 0, 0, 0L, 0L, 0L, AGeomUtil.CompassCorners.NE, 0);
        if (this.mDevice != null) {
            this.mDevice.getTemplate().setBounds((AGeom)new ARect(-this.mDieWidth / 2L, -this.mDieWidth / 2L, this.mDieWidth / 2L, this.mDieHeight / 2L));
            this.mDevice.setLoc(new APoint2D(0L, 0L));
            return true;
        }
        return false;
    }

    protected boolean addBallPad(int csvRow) {
        String pinName = this.correctName(this.getFieldValue("pin"));
        String netName = this.correctName(this.getFieldValue("net"));
        if (netName.isEmpty()) {
            netName = "NetUnused";
        }
        if (pinName.isEmpty()) {
            ALog.logWarn((String)"Ignore row %d because of the empty pin name.", (Object[])new Object[]{csvRow});
            return false;
        }
        String pinLocX = this.getFieldValue("x_ctr");
        String pinLocY = this.getFieldValue("y_ctr");
        Device parent = this.mDevice;
        DeviceTemplate dt = parent.getTemplate();
        long x = 0L;
        long y = 0L;
        if (!pinLocX.isEmpty() && !pinLocY.isEmpty()) {
            Design cd = Design.getDesign((Db)this.mDb);
            x = pinLocX.isEmpty() ? 0L : cd.getInternal(Double.parseDouble(pinLocX));
            y = pinLocY.isEmpty() ? 0L : cd.getInternal(Double.parseDouble(pinLocY));
        }
        long rad = this.mPadWidth / 2L;
        Db db = parent.getDb();
        Layer l = parent.getSubstrate().getLayer("BallLayer");
        if (l == null) {
            return false;
        }
        Net n = Net.getOrCreate((DeviceTemplate)dt, (String)netName);
        assert (n != null) : "Could not get net " + netName;
        if (!pinName.isEmpty()) {
            String padName = "PAD_" + Long.toString(rad);
            PadTemplate pt = null;
            pt = PadTemplate.get((Db)db, (Substrate)l.getSubstrate(), (String)padName);
            if (pt == null) {
                pt = PadTemplate.create((Db)db, (Substrate)l.getSubstrate(), (String)padName);
                ACircle cpad = new ACircle(new APoint2D(0L, 0L), rad);
                LayerShape.create((Db)db, (Layer)l, (DbObject)pt, (AGeom)cpad);
            }
            PinTemplate dtp = PinTemplate.create((Net)n, (String)pinName);
            dtp.setType(PinTemplate.Type.BALLPAD);
            dtp.setPadTemplate(pt);
            dtp.setLoc(new APoint2D(x, y));
            if (!n.isUnused() && NetMap.getParentNet((Device)parent, (Net)n) == null) {
                Net.getOrCreate((DeviceTemplate)parent.getTemplate(), (String)netName);
            }
        }
        return true;
    }

    protected boolean createDie() {
        if (this.mDevice != null) {
            return true;
        }
        this.mDevice = PartFactory.makeDie(this.mBaseDieTemplateName, this.mBaseDieInstanceName, this.mDieWidth, this.mDieHeight, 0, 0, 0, 0, 0L, 0L);
        if (this.mDevice != null) {
            this.mDevice.getTemplate().setBounds((AGeom)new ARect(-this.mDieWidth / 2L, -this.mDieWidth / 2L, this.mDieWidth / 2L, this.mDieHeight / 2L));
            this.mDevice.setLoc(new APoint2D(0L, 0L));
            return true;
        }
        return false;
    }

    protected boolean addDevice(int row) {
        this.createIODevice(row);
        return true;
    }

    protected int getFieldIndex(String field) {
        Integer i = this.mHeaders.get(field.toLowerCase());
        return i == null ? -1 : i;
    }

    protected String getFieldValue(String field) {
        int i = this.getFieldIndex(field);
        if (i >= 0 && i < this.mCurrentRow.length) {
            String result = this.mCurrentRow[i];
            if (result == null || result.isEmpty()) {
                return "";
            }
            return result;
        }
        return "";
    }

    protected Device createGroupParent(long csvRow) {
        String groupName = this.correctName(this.getFieldValue("group"));
        if (groupName == null || groupName.isEmpty()) {
            return null;
        }
        String sideName = this.getFieldValue("side");
        sideName = this.getSideName(sideName);
        String path = this.mDevice.getADevicePath().toString() + "/" + groupName;
        DevicePath dp = DevicePath.fromString((Db)this.mDb, (String)path);
        if (dp != null) {
            Device d = dp.getLast();
            String oldSide = d.getSide();
            if (!oldSide.equalsIgnoreCase(sideName)) {
                ALog.logWarn((String)"The group %s is referenced with both %s and %s on row %d", (Object[])new Object[]{groupName, oldSide, sideName, csvRow});
            }
            return d;
        }
        String tpName = groupName + "_template";
        DeviceTemplate dt = DeviceTemplate.getDeviceTemplate((Substrate)this.mDevice.getSubstrate(), (String)tpName);
        if (dt == null) {
            dt = DeviceTemplate.create((Substrate)this.mDevice.getSubstrate(), (String)tpName, (boolean)false);
        }
        Device d = Device.create((Db)this.mDb, (String)groupName, (DeviceTemplate)dt, (DeviceTemplate)this.mDevice.getTemplate());
        d.setValue("side", (Object)sideName);
        this.mCreatedDevices.add(new CSVDeviceInfo(csvRow, true, d));
        return d;
    }

    protected Device createIODevice(long csvRow) {
        Iterator dp;
        String ioDevName;
        String pinName = ioDevName = this.correctName(this.getFieldValue("pin"));
        String netName = this.correctName(this.getFieldValue("net"));
        if (netName.isEmpty()) {
            netName = "NetUnused";
        }
        if (ioDevName.isEmpty()) {
            ALog.logWarn((String)"Ignore row %d because of the empty pin name.", (Object[])new Object[]{csvRow});
            return null;
        }
        String typeName = this.getFieldValue("type");
        String sideName = this.getFieldValue("side");
        String groupOffsetX = this.getFieldValue("group rel. x");
        String groupOffsetY = this.getFieldValue("group rel. y");
        String pinLocX = this.getFieldValue("x_ctr");
        String pinLocY = this.getFieldValue("y_ctr");
        String diffPair = this.getFieldValue("diffpair");
        Device parent = this.createGroupParent(csvRow);
        if (parent == null) {
            parent = this.mDevice;
        }
        DeviceTemplate dt = PartFactory.makeIOPadTemplate(parent, this.mPadWidth, this.mPadHeight, pinName, false, netName, false, null);
        Device d = new Device(ioDevName, parent.getTemplate(), dt);
        this.mDb.add((DbObject)d);
        if (!groupOffsetX.isEmpty()) {
            d.setValue("gap", (Object)groupOffsetX);
        }
        if (!groupOffsetY.isEmpty()) {
            d.setValue("inset", (Object)groupOffsetY);
        }
        this.mCreatedDevices.add(new CSVDeviceInfo(csvRow, false, d));
        if (!sideName.isEmpty()) {
            d.setValue("side", (Object)this.getSideName(sideName));
        }
        if (!pinLocX.isEmpty() && !pinLocY.isEmpty()) {
            Design cd = Design.getDesign((Db)this.mDb);
            long x = pinLocX.isEmpty() ? 0L : cd.getInternal(Double.parseDouble(pinLocX));
            long y = pinLocY.isEmpty() ? 0L : cd.getInternal(Double.parseDouble(pinLocY));
            d.setLoc(new APoint2D(x, y));
        } else {
            d.setLoc(null);
        }
        Net thisNet = null;
        if (!pinName.isEmpty()) {
            Net n;
            thisNet = n = dt.getNet(netName);
            dp = PinInstance.create((Db)this.mDb, (String)pinName, (Device)d, (PinTemplate)n.getPinTemplate(pinName));
            PinTemplate dtp = dp.getPinTemplate();
            dtp.setType(PinTemplate.Type.WIREBONDPAD);
            String pinNumString = pinName.substring(pinName.indexOf(46) + 1);
            int pinNum = Integer.parseInt(pinNumString);
            dp.setPinNum(pinNum);
            if (!n.isUnused() && NetMap.getParentNet((Device)d, (Net)n) == null) {
                Device[] parents = new Device[2];
                parents[0] = parent;
                if (parent != this.mDevice) {
                    parents[1] = this.mDevice;
                }
                Device childDevice = d;
                Net childNet = n;
                for (Device pd : parents) {
                    if (pd == null) break;
                    Net parentNet = Net.getOrCreate((DeviceTemplate)pd.getTemplate(), (String)netName);
                    NetMap.mapChildNet((Device)childDevice, (Net)childNet, (Net)parentNet);
                    childDevice = pd;
                    childNet = parentNet;
                }
            }
        }
        if (!typeName.isEmpty()) {
            Personality pinPersonality = Personality.getOrCreate((DeviceTemplate)d.getTemplate(), (Personality.Type)Personality.Type.PORT, (String)typeName, p -> {
                Color c = AUtil.colorFromString((String)Personality.nextColor());
                if (c != null) {
                    p.setColor(c);
                }
            });
            for (PinInstance dp2 : d.getPins()) {
                dp2.assignToPersonality(pinPersonality);
            }
        }
        if (!diffPair.isEmpty() && thisNet != null && !thisNet.isUnused()) {
            Personality netPersonality = Personality.createDiffPair((String)diffPair, (DeviceTemplate)d.getTemplate());
            dp = new DevicePath(this.mDevice);
            if (parent != null && parent != d) {
                dp.add(parent);
            }
            dp.add(d);
            thisNet.assignToPersonality(netPersonality, (DevicePath)dp);
        }
        return d;
    }

    protected void locateDevicesGivenAbsolutePositions() {
        ArrayList<Device> groupsCreated = new ArrayList<Device>();
        for (int i = 0; i < this.mCreatedDevices.size(); ++i) {
            CSVDeviceInfo cdi = this.mCreatedDevices.get(i);
            if (cdi.mDevice.getLoc() == null) {
                cdi.mDevice.setLoc(new APoint2D());
            }
            if (!cdi.mIsGroupDevice) continue;
            groupsCreated.add(cdi.mDevice);
        }
        for (Device parent : groupsCreated) {
            ARect r = new ARect();
            boolean first = true;
            for (Device child : parent.getChildren()) {
                if (first) {
                    r = new ARect(child.getBounds());
                    first = false;
                    continue;
                }
                r.expand(child.getBounds());
            }
            ARect macroBounds = new ARect(-r.width() / 2L, -r.height() / 2L, r.width() / 2L, r.height() / 2L);
            parent.setLoc(r.center());
            APoint2D parentLoc = new APoint2D(parent.getLoc());
            parent.getTemplate().setBounds((AGeom)macroBounds);
            for (Device child : parent.getChildren()) {
                APoint2D absLoc = new APoint2D(child.getLoc());
                child.setLoc(absLoc.sub(parentLoc));
                child.setIsFixed(true);
            }
        }
    }

    protected void locateDevices() {
        Design cd = Design.getDesign((Db)this.mDb);
        HashMap<String, SideLocParam> loc = new HashMap<String, SideLocParam>();
        ARect bbDie = this.mDevice.getLocalBB();
        loc.put("left", new SideLocParam(bbDie.getUL(), 0, -1, 1, -1));
        loc.put("right", new SideLocParam(bbDie.getLR(), 0, 1, -1, 1));
        loc.put("top", new SideLocParam(bbDie.getUR(), -1, 0, -1, -1));
        loc.put("bottom", new SideLocParam(bbDie.getLL(), 1, 0, 1, 1));
        for (int i = 0; i < this.mCreatedDevices.size(); ++i) {
            CSVDeviceInfo cdi = this.mCreatedDevices.get(i);
            if (!cdi.mIsGroupDevice) continue;
            Device d = cdi.mDevice;
            String side = d.getSide();
            SideLocParam sideLocParam = (SideLocParam)loc.get(side);
            APoint2D sideLoc = sideLocParam.mLoc;
            AffineTransform t = this.getTransform(side);
            ARect bound = new ARect(0L, 0L, this.mPadWidth, this.mPadHeight);
            boolean group = false;
            ArrayList<Device> cds = new ArrayList<Device>();
            for (int j = i + 1; j < this.mCreatedDevices.size(); ++j) {
                Device child = this.mCreatedDevices.get((int)j).mDevice;
                if (child.getParent() != d.getTemplate()) continue;
                group = true;
                cds.add(child);
                String sx = (String)child.getValue("gap");
                String sy = (String)child.getValue("inset");
                long x = sx == null ? 0L : cd.getInternal(Double.parseDouble(sx));
                long y = sy == null ? 0L : cd.getInternal(Double.parseDouble(sy));
                ARect bb = new ARect(0L, 0L, x, y).transform(t).getBounds();
                APoint2D pt = new APoint2D(bb.width(), bb.height());
                APoint2D cl = new APoint2D(pt);
                cl.moveBy(this.mPadWidth / 2L, this.mPadHeight / 2L);
                child.setLoc(cl);
                child.setValue("gap", null);
                child.setValue("inset", null);
                pt.moveBy(this.mPadWidth, this.mPadHeight);
                bound.expand(pt);
            }
            long w = bound.width();
            long h = bound.height();
            bound = new ARect(-w / 2L, -h / 2L, w - w / 2L, h - h / 2L);
            if (group) {
                d.getTemplate().setBounds((AGeom)bound);
                for (Device cdd : cds) {
                    APoint2D l = cdd.getLoc();
                    l.moveBy(-w / 2L, -h / 2L);
                    cdd.setLoc(l);
                }
            }
            bound = bound.transform(t).getBounds();
            assert (d.getLoc() == null);
            APoint2D dl = new APoint2D(sideLoc);
            dl.moveBy(bound.width() / 2L * (long)sideLocParam.mOffsetX, bound.height() / 2L * (long)sideLocParam.mOffsetY);
            d.setLoc(dl);
            sideLoc.moveBy(bound.width() * (long)sideLocParam.mStepX, bound.height() * (long)sideLocParam.mStepY);
            sideLocParam.mLoc = new APoint2D(sideLoc);
            d.setRotate((float)this.getSideRotate(side));
        }
    }

    protected String correctName(String name) {
        String result = null;
        if (name != null) {
            result = name.replaceAll(" ", "");
        }
        return result;
    }

    protected int getSideRotate(String side) {
        if (side.equalsIgnoreCase("left")) {
            return 90;
        }
        if (side.equalsIgnoreCase("top")) {
            return 180;
        }
        if (side.equalsIgnoreCase("right")) {
            return 270;
        }
        return 0;
    }

    protected AffineTransform getTransform(String side) {
        return ATransformUtil.createTransform((double)0.0, (double)0.0, (float)this.getSideRotate(side), (boolean)false);
    }

    protected void sortDevices(ArrayList<DevicePath> devices, String side) {
        if (side.equals("left") || side.equals("right")) {
            Collections.sort(devices, new DevicePath.DevicePathSortV());
        } else if (side.equals("top") || side.equals("bottom")) {
            Collections.sort(devices, new DevicePath.DevicePathSortH());
        }
    }

    protected String getSideName(String side) {
        String result = null;
        if (side.equalsIgnoreCase("e")) {
            result = "right";
        } else if (side.equalsIgnoreCase("w")) {
            result = "left";
        } else if (side.equalsIgnoreCase("n")) {
            result = "top";
        } else if (side.equalsIgnoreCase("s")) {
            result = "bottom";
        } else assert (false);
        return result;
    }

    protected class SideLocParam {
        protected APoint2D mLoc;
        protected int mStepX;
        protected int mStepY;
        protected int mOffsetX;
        protected int mOffsetY;

        public SideLocParam(APoint2D loc, int stepX, int stepY, int offsetX, int offsetY) {
            this.mLoc = new APoint2D(loc);
            this.mStepX = stepX;
            this.mStepY = stepY;
            this.mOffsetX = offsetX;
            this.mOffsetY = offsetY;
        }
    }

    protected class PinLocationUI
    extends DbDialog {
        protected ArrayList<Integer> mInvalidRows;
        protected boolean mIsCanceled;
        protected int mCurrentCSVRow;
        protected JTable mTable;
        protected JCheckBox mShowAllData;
        protected JButton mBtnSave;
        protected JButton mBtnOk;
        protected JButton mBtnCancel;
        private MyTableCellRender mCellRender;

        public PinLocationUI(Db db, Component owner, String title, ArrayList<Integer> invalidRows) {
            super(db, owner, title);
            this.mIsCanceled = false;
            this.mCurrentCSVRow = -1;
            this.mTable = new JTable(new MyTableModel());
            this.mShowAllData = new JCheckBox("Display all rows");
            this.mBtnSave = new JButton("Save");
            this.mBtnOk = new JButton("Ok");
            this.mBtnCancel = new JButton("Cancel");
            this.mCellRender = new MyTableCellRender();
            this.mInvalidRows = invalidRows;
            this.init();
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MyTableModel model = (MyTableModel)PinLocationUI.this.mTable.getModel();
                    PinLocationUI.this.mBtnOk.setEnabled(model.isValid());
                }
            });
        }

        protected boolean saveToCSV(String filePath) {
            CSVWriter writer = null;
            try {
                writer = new CSVWriter((Writer)new FileWriter(filePath));
                String[] line = new String[TISpreadSheet.this.mHeaders.size()];
                for (int i = 0; i < TISpreadSheet.this.mHeaders.size(); ++i) {
                    for (Map.Entry<String, Integer> e : TISpreadSheet.this.mHeaders.entrySet()) {
                        if (e.getValue() != i) continue;
                        line[i] = e.getKey();
                    }
                }
                writer.writeNext(line);
                for (String[] vs : TISpreadSheet.this.mCSVContents) {
                    writer.writeNext(vs);
                }
                writer.close();
                ALog.logInfo((String)"Save the file %s succeed.", (Object[])new Object[]{filePath});
            }
            catch (IOException e) {
                ALog.logError((Throwable)e, (String)"Unable to write '%s'.", (Object[])new Object[]{filePath});
                return false;
            }
            return true;
        }

        protected int getCSVRow(int row) {
            if (row < 0) {
                return -1;
            }
            int csvRow = row;
            if (!this.mShowAllData.isSelected()) {
                csvRow = this.mInvalidRows.get(row);
            }
            return csvRow;
        }

        protected void selectRow(int csvRow) {
            int i = 0;
            if (csvRow >= 0) {
                for (i = 0; i < this.mTable.getRowCount() && Integer.parseInt((String)this.mTable.getValueAt(i, 0)) != csvRow; ++i) {
                }
            }
            if (i >= 0 && i < this.mTable.getRowCount()) {
                Rectangle r = this.mTable.getCellRect(i, 0, true);
                this.mTable.scrollRectToVisible(r);
                this.mTable.setRowSelectionInterval(i, i);
            }
        }

        protected void init() {
            for (int i = 0; i < this.mTable.getColumnCount(); ++i) {
                this.mTable.getColumnModel().getColumn(i).setCellRenderer(this.mCellRender);
            }
            this.mTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    PinLocationUI.this.mCurrentCSVRow = PinLocationUI.this.getCSVRow(PinLocationUI.this.mTable.getSelectedRow());
                }
            });
            if (this.mTable.getRowCount() > 0) {
                Rectangle r = this.mTable.getCellRect(0, 0, true);
                this.mTable.scrollRectToVisible(r);
                this.mTable.setRowSelectionInterval(0, 0);
            }
            this.setTitle("TI SpreadSheet reader");
            GridBagManager l = new GridBagManager(this.getContentPane());
            l.pushFill();
            l.add((Component)new JLabel("Following parameters should be specified:"), (GridBagConstraints)GridBagManager.LEFT);
            l.newline();
            JScrollPane spCanva = new JScrollPane(this.mTable);
            spCanva.setPreferredSize(new Dimension(455, 455));
            l.add((Component)spCanva, (GridBagConstraints)GridBagManager.FILLALL);
            l.pop();
            l.newline();
            l.pushFillX();
            l.add((Component)this.mShowAllData, (GridBagConstraints)GridBagManager.LEFT);
            l.addFillX();
            l.add((Component)this.mBtnSave, (GridBagConstraints)GridBagManager.RIGHT);
            l.add((Component)this.mBtnOk, (GridBagConstraints)GridBagManager.RIGHT);
            l.add((Component)this.mBtnCancel, (GridBagConstraints)GridBagManager.RIGHT_REMAINX);
            l.newline();
            l.pop();
            this.pack();
            UIUtil.center((Component)((Object)this));
            this.mBtnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PinLocationUI.this.mIsCanceled = true;
                }
            });
            this.mBtnOk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MyTableModel model = (MyTableModel)PinLocationUI.this.mTable.getModel();
                    if (model.isValid()) {
                        UIUtil.closeWindow((Window)((Object)PinLocationUI.this));
                    }
                }
            });
            this.mBtnSave.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PinLocationUI.this.saveToCSV(TISpreadSheet.this.mFilePath);
                }
            });
            this.mShowAllData.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PinLocationUI.this.mInvalidRows = TISpreadSheet.this.getInvalidRows();
                    AbstractTableModel model = (AbstractTableModel)PinLocationUI.this.mTable.getModel();
                    int csvRow = PinLocationUI.this.mCurrentCSVRow;
                    model.fireTableDataChanged();
                    PinLocationUI.this.mCurrentCSVRow = csvRow;
                    PinLocationUI.this.selectRow(PinLocationUI.this.mCurrentCSVRow);
                }
            });
            UIUtil.enableDefaultBtn((JDialog)((Object)this), (JButton)this.mBtnOk);
            UIUtil.enableEscapeClose((Window)((Object)this), (AbstractButton)this.mBtnCancel);
            this.setResizable(true);
            this.setModal(true);
        }

        class MyTableModel
        extends AbstractTableModel {
            private final String[][] columnNames = new String[][]{{"Row", "Pin", "x_ctr", "y_ctr", "DiffPair"}, {"Row", "Pin", "DiffPair", "Group rel. x", "Group rel. y"}};

            MyTableModel() {
            }

            @Override
            public int getColumnCount() {
                if (TISpreadSheet.this.mAbsPositionProvided) {
                    return this.columnNames[0].length;
                }
                return this.columnNames[1].length;
            }

            @Override
            public int getRowCount() {
                if (PinLocationUI.this.mShowAllData.isSelected()) {
                    return TISpreadSheet.this.mCSVContents.size();
                }
                return PinLocationUI.this.mInvalidRows.size();
            }

            @Override
            public String getColumnName(int col) {
                if (TISpreadSheet.this.mAbsPositionProvided) {
                    return this.columnNames[0][col];
                }
                return this.columnNames[1][col];
            }

            @Override
            public Object getValueAt(int row, int col) {
                String[] v;
                String s;
                int csvRow = PinLocationUI.this.getCSVRow(row);
                String colName = this.getColumnName(col);
                if (colName.equalsIgnoreCase("row")) {
                    return Integer.toString(csvRow);
                }
                int i = TISpreadSheet.this.getFieldIndex(colName);
                String string = s = i < (v = TISpreadSheet.this.mCSVContents.get(csvRow)).length ? v[i] : "";
                if (this.isNumericCol(colName)) {
                    if (s != null && !s.isEmpty()) {
                        return Double.parseDouble(s);
                    }
                    return null;
                }
                return s;
            }

            @Override
            public void setValueAt(Object value, int row, int col) {
                String[] v;
                int csvRow = PinLocationUI.this.getCSVRow(row);
                String colName = this.getColumnName(col);
                int i = TISpreadSheet.this.getFieldIndex(colName);
                if (i >= (v = TISpreadSheet.this.mCSVContents.get(csvRow)).length) {
                    v = this.reSizeValues(v, i + 1);
                    TISpreadSheet.this.mCSVContents.set(csvRow, v);
                }
                v[i] = this.isNumericCol(colName) ? (value != null ? Double.toString((Double)value) : null) : (String)value;
                PinLocationUI.this.mBtnOk.setEnabled(this.isValid());
            }

            @Override
            public Class<?> getColumnClass(int c) {
                String colName = this.getColumnName(c);
                if (this.isNumericCol(colName)) {
                    return Double.class;
                }
                return String.class;
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return col >= 2;
            }

            public boolean isValidData(int row, int col) {
                String colName = this.getColumnName(col);
                return this.isAllowSpaceValue(row, colName) || this.getValueAt(row, col) != null;
            }

            public boolean isValid() {
                for (int row = 0; row < this.getRowCount(); ++row) {
                    for (int col = 0; col < this.getColumnCount(); ++col) {
                        if (this.isValidData(row, col)) continue;
                        return false;
                    }
                }
                return true;
            }

            protected boolean isNumericCol(String colName) {
                return colName.equalsIgnoreCase("x_ctr") || colName.equalsIgnoreCase("y_ctr") || colName.equalsIgnoreCase("Group rel. x") || colName.equalsIgnoreCase("Group rel. y");
            }

            protected String[] reSizeValues(String[] v, int size) {
                ArrayList<String> av = new ArrayList<String>(size);
                for (String s : v) {
                    av.add(s);
                }
                while (av.size() < size) {
                    av.add("");
                }
                v = new String[size];
                av.toArray(v);
                return v;
            }

            protected boolean isAllowSpaceValue(int row, String colName) {
                if (TISpreadSheet.this.mAbsPositionProvided) {
                    return !colName.equalsIgnoreCase("x_ctr") && !colName.equalsIgnoreCase("y_ctr");
                }
                int r = PinLocationUI.this.getCSVRow(row);
                int gr = TISpreadSheet.this.getFieldIndex("group");
                String group = TISpreadSheet.this.mCSVContents.get(r)[gr];
                if (group == null || group.isEmpty()) {
                    return true;
                }
                return !colName.equalsIgnoreCase("Group rel. x") && !colName.equalsIgnoreCase("Group rel. y");
            }
        }

        class MyTableCellRender
        extends DefaultTableCellRenderer {
            MyTableCellRender() {
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
                Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
                MyTableModel model = (MyTableModel)table.getModel();
                if (!model.isValidData(row, col)) {
                    c.setBackground(isSelected ? Color.GREEN : Color.blue);
                    c.setForeground(Color.white);
                } else {
                    c.setBackground(isSelected ? Color.orange : Color.white);
                    c.setForeground(Color.black);
                }
                return c;
            }
        }
    }

    protected class CSVDeviceInfo {
        protected long mCSVRow;
        protected boolean mIsGroupDevice;
        protected Device mDevice;

        public CSVDeviceInfo(long row, boolean isGroupDevice, Device device) {
            this.mCSVRow = row;
            this.mIsGroupDevice = isGroupDevice;
            this.mDevice = device;
        }
    }
}

