/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.export;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.sigrity.acl.AAlphaNumComp;
import com.sigrity.acl.AIterableItr;
import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.ASingletonItr;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.ProcessingIterator;
import com.sigrity.acl.app.ABuildInfo;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.verilog.VerilogIdentifier;
import com.sigrity.acl.verilog.VerilogSyntax;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.NetFilters;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.export.DEFOut;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;

public class VerilogExport {
    public static boolean ReplaceSquareBracketsWithUnderscoresInInstNames = false;
    public static final String KW_MODULE = "module";
    protected static Pattern Bit0PaddingRegex = Pattern.compile("[0-9]+'b0+");
    public static final String PORTTYPE_IN = "input";
    public static final String PORTTYPE_OUT = "output";
    public static final String PORTTYPE_IO = "inout";
    public static final String OMIT_FROM_VERILOG_DEFINITION_FIELD = "omitFromVerilogDefinition";
    public static final LinkedList<APair<String, Comparator<Device>>> DeviceSort = new LinkedList();
    public static Comparator<Device> DefaultDeviceSort;
    protected Db mDb;
    protected DevicePath mStartDevicePath;
    protected DeviceTemplate mStartDeviceTemplate;
    protected String mOutFilePath;
    protected Comparator<Device> mDeviceSort = DefaultDeviceSort;
    protected boolean mUseDefOutNames = false;
    protected boolean mExportLeafDefs = true;
    protected boolean mExportLeafDefsSynth = true;
    protected boolean mExportLeafDefsLef = true;
    protected boolean mOmittedDefnInstancesUsePinNames = false;
    protected boolean mUseNetUnusedForUnconnectedPorts = false;
    protected boolean mUsePhysPinNamesForPorts = false;
    protected boolean mLeafsOmitSignalInfo = false;
    protected HashSet<DeviceTemplate> mStopTemplates = new HashSet();
    protected ExportAsPorts mExportAsPortsTop = ExportAsPorts.NetsMappedUp;
    protected ExportAsPorts mExportAsPorts = ExportAsPorts.NetsMappedUp;
    protected PrintWriter mOutput = null;
    protected VerilogIdentifier mVerilogIdentifier = new VerilogIdentifier();
    protected DeviceTemplateInfoMap mDeviceTemplateInfo = new DeviceTemplateInfoMap();
    protected static boolean GetPortTypeChecksAllDescendants;

    public VerilogExport(Db db, String outputFilePath) {
        this.mDb = db;
        this.mOutFilePath = outputFilePath;
    }

    public void setExportAsPortsTop(ExportAsPorts option) {
        this.mExportAsPortsTop = option;
    }

    public void setExportAsPorts(ExportAsPorts option) {
        this.mExportAsPorts = option;
    }

    public void setUseDefOutNames(boolean b) {
        this.mUseDefOutNames = b;
    }

    public void setExportLeafDefs(boolean b) {
        this.mExportLeafDefs = b;
    }

    public void setExportLeafDefsSynth(boolean b) {
        this.mExportLeafDefsSynth = b;
    }

    public void setExportLefDefinedLeafs(boolean b) {
        this.mExportLeafDefsLef = b;
    }

    public void setUnexportedLeafModuleInstancesUsePinNames(boolean b) {
        this.mOmittedDefnInstancesUsePinNames = b;
    }

    public void setUseNetUnusedForUnconnectedPorts(boolean b) {
        this.mUseNetUnusedForUnconnectedPorts = b;
    }

    public void setUsePhysPinNamesForPorts(boolean b) {
        this.mUsePhysPinNamesForPorts = b;
    }

    public void setLeafsOmitSignalInfo(boolean b) {
        this.mLeafsOmitSignalInfo = b;
    }

    public void setDeviceSort(Comparator<Device> sort) {
        this.mDeviceSort = sort;
    }

    public void addStopTemplate(String stopDeviceTemplateKey) {
        DeviceTemplate stopTemplate = (DeviceTemplate)this.mDb.getByKeyStr(DeviceTemplate.class, stopDeviceTemplateKey);
        if (stopTemplate == null) {
            ALog.logError((String)"Invalid DeviceTemplate key '%s' specified to VerilogExport.addStopTemplate, it is being ignored.", (Object[])new Object[]{stopDeviceTemplateKey});
        } else {
            this.addStopTemplate(stopTemplate);
        }
    }

    public void addStopTemplate(DeviceTemplate stopTemplate) {
        if (stopTemplate == null) {
            return;
        }
        this.mStopTemplates.add(stopTemplate);
    }

    public boolean write() {
        return this.write("/");
    }

    public boolean write(String startDevicePath) {
        this.mStartDevicePath = DevicePath.fromString((Db)this.mDb, (String)startDevicePath);
        if (this.mStartDevicePath == null) {
            ALog.logError((String)"Invalid device path '%s'.", (Object[])new Object[]{startDevicePath});
            return false;
        }
        File f = new File(this.mOutFilePath);
        try {
            this.mOutput = new PrintWriter(f);
        }
        catch (FileNotFoundException e) {
            ALog.logError((Throwable)e, (String)"Unable to open specified file '%s' for writing.", (Object[])new Object[]{this.mOutFilePath});
            return false;
        }
        boolean res = false;
        try {
            res = this.writeVerilog();
        }
        catch (Throwable t) {
            ALog.logError((Throwable)t, (String)"There we an unexpected exception while writing Verilog.", (Object[])new Object[0]);
        }
        if (this.mOutput.checkError()) {
            ALog.logError((String)"There was an error writing the file '%s'.", (Object[])new Object[]{this.mOutFilePath});
            res = false;
        } else {
            ALog.logInfo((String)"Verilog output complete.");
        }
        this.mOutput.close();
        return res;
    }

    protected boolean writeVerilog() {
        ALog.logInfo((String)"Writing Verilog to '%s'...", (Object[])new Object[]{this.mOutFilePath});
        this.outputln("// %s version %s", OrbitIO.getApp().getName(true), OrbitIO.getApp().getVersion());
        this.outputln("// Build: %s (%s)", ABuildInfo.getVersion(), ABuildInfo.getTimestamp());
        this.outputln("// User: %s", System.getProperty("user.name"));
        this.outputln("// Time: %s", new Date());
        String file = this.mDb.getCanonicalPath();
        this.outputln("// Source design: %s", file != null ? file : "<Unsaved Design>");
        this.mStartDeviceTemplate = this.mStartDevicePath.getDeviceTemplate();
        boolean res = this.writeModuleFor(this.mStartDevicePath);
        return res;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean writeModuleFor(DevicePath path) {
        DeviceTemplate dt = path.getDeviceTemplate();
        DeviceTemplateInfo info = this.mDeviceTemplateInfo.getInfo(dt);
        if (info.getOutput()) {
            return false;
        }
        info.setOutput(true);
        this.outputln();
        String dtName = dt instanceof Design ? ((Design)dt).getUserName() : dt.getName();
        this.output("%s %s (", KW_MODULE, this.identifier(dtName));
        LinkedList<VPort> verilogPorts = new LinkedList<VPort>();
        LinkedList<VPort> verilogWires = new LinkedList<VPort>();
        HashSet<String> processedBusses = new HashSet<String>();
        for (VPort port : info.getPorts()) {
            BusInfo busInfo = info.getBusInfo(port);
            if (busInfo != null) {
                String string = busInfo.getBusName();
                if (processedBusses.contains(string)) continue;
                if (this.exportPort(path.getLast(), AUtil.arrayList(busInfo.getPorts()))) {
                    verilogPorts.add(port);
                } else if (VerilogExport.mapsDown(busInfo.getPorts())) {
                    verilogWires.add(port);
                }
                processedBusses.add(string);
                continue;
            }
            if (this.exportPort(path.getLast(), port)) {
                verilogPorts.add(port);
                continue;
            }
            if (!VerilogExport.mapsDown(port)) continue;
            verilogWires.add(port);
        }
        HashSet<Object> idsUsed = new HashSet<Object>();
        int portOutputCount = 0;
        for (VPort vPort : verilogPorts) {
            String portName = vPort.getName();
            BusInfo busInfo = info.getBusInfo(vPort);
            if (busInfo != null) {
                String busName = busInfo.getBusName();
                portName = busName;
            }
            if (vPort.getUsePhysPinName() != null) {
                for (PinTemplate pinTemplate : vPort.getUsePhysPinName()) {
                    if (portOutputCount != 0) {
                        this.output(" ,", new Object[0]);
                    }
                    this.outputln();
                    ++portOutputCount;
                    this.output("\t%s", this.identifier(pinTemplate.getName()));
                    idsUsed.add(pinTemplate.getName());
                }
                continue;
            }
            if (portOutputCount != 0) {
                this.output(" ,", new Object[0]);
            }
            this.outputln();
            ++portOutputCount;
            this.output("\t%s", this.identifier(portName));
            idsUsed.add(portName);
        }
        if (portOutputCount > 0) {
            this.outputln();
        }
        this.outputln(");", new Object[0]);
        portOutputCount = 0;
        processedBusses = new HashSet();
        for (VPort vPort : verilogPorts) {
            BusInfo busInfo = info.getBusInfo(vPort);
            if (portOutputCount == 0) {
                this.outputln();
            }
            ++portOutputCount;
            String portName = vPort.getName();
            if (busInfo != null) {
                this.outputln("%s\t[%d:%d]\t%s ;", VerilogExport.getPortType(busInfo.getPorts()), busInfo.getRangeMax(), busInfo.getRangeMin(), this.identifier(busInfo.getBusName()));
                continue;
            }
            String portType = VerilogExport.getPortType(vPort);
            if (vPort.getUsePhysPinName() != null) {
                for (PinTemplate pinT : vPort.getUsePhysPinName()) {
                    this.outputln("%s\t%s ;", portType, this.identifier(pinT.getName()));
                }
                continue;
            }
            this.outputln("%s\t%s ;", portType, this.identifier(portName));
        }
        LinkedList<VPort> useTran = new LinkedList<VPort>();
        if (!VerilogExport.isLeaf(dt) || !this.mLeafsOmitSignalInfo) {
            for (VPort port : verilogPorts) {
                if (port.getUsePhysPinName() == null) continue;
                this.outputln("wire\t%s ;", this.identifier(port.getName()));
            }
            for (VPort port : verilogPorts) {
                if (port.getUsePhysPinName() == null) continue;
                useTran.add(port);
            }
        }
        for (VPort port : verilogWires) {
            String wireName = port.getName();
            BusInfo busInfo = info.getBusInfo(port);
            if (portOutputCount == 0) {
                this.outputln();
            }
            ++portOutputCount;
            if (busInfo != null) {
                this.outputln("wire\t[%d:%d]\t%s ;", busInfo.getRangeMax(), busInfo.getRangeMin(), this.identifier(busInfo.getBusName()));
            } else {
                this.outputln("wire\t%s ;", this.identifier(wireName));
            }
            idsUsed.add(wireName);
        }
        long l = 0L;
        for (VPort port : useTran) {
            if (l == 0L) {
                this.outputln();
            }
            for (PinTemplate pinT : port.getUsePhysPinName()) {
                this.outputln("tran %s( %s , %s );", this.identifier("u" + ++l), this.identifier(pinT.getName()), this.identifier(port.getName()));
            }
        }
        LinkedList devices = AUtil.linkedList((Iterator)dt.getChildren());
        Collections.sort(devices, this.mDeviceSort);
        LinkedList<DevicePath> childrenOutput = new LinkedList<DevicePath>();
        boolean bl = false;
        for (Device d : devices) {
            String deviceName;
            void var15_31;
            if (portOutputCount > 0 && var15_31 == false) {
                this.outputln();
            }
            ++var15_31;
            DevicePath childPath = new DevicePath(path, d);
            String string = deviceName = this.mUseDefOutNames ? DEFOut.getDefOutName(childPath, this.mStartDevicePath.getRelativePath(childPath)) : d.getName();
            if (ReplaceSquareBracketsWithUnderscoresInInstNames) {
                deviceName = deviceName.replace('[', '_').replace(']', '_');
            }
            int i = 0;
            while (idsUsed.contains(deviceName)) {
                deviceName = String.format("%sInst%s", d.getName(), i == 0 ? "" : Integer.valueOf(i));
                ++i;
            }
            idsUsed.add(deviceName);
            this.writeChildDevice(d, deviceName);
            childrenOutput.add(childPath);
        }
        this.outputln("endmodule", new Object[0]);
        for (DevicePath childPath : childrenOutput) {
            DeviceTemplate childTemplate = childPath.getDeviceTemplate();
            if (this.mDeviceTemplateInfo.getInfo(childTemplate).getOmitDefn()) continue;
            this.writeModuleFor(childPath);
        }
        return true;
    }

    protected boolean exportPort(Device d, VPort p) {
        ExportAsPorts exportAsPorts = d.getTemplate() == this.mStartDeviceTemplate ? this.mExportAsPortsTop : this.mExportAsPorts;
        return exportAsPorts == ExportAsPorts.AllNets || VerilogExport.mapsUp(d, p) || exportAsPorts == ExportAsPorts.NetsWithExternalPorts && VerilogExport.hasExternalPorts(p) || exportAsPorts == ExportAsPorts.NetsWithExternalPortsOnSubstrate && VerilogExport.hasExternalPortsOnSubstrate(p);
    }

    protected boolean exportPort(Device d, List<VPort> ports) {
        boolean isStartDevT = d.getTemplate() == this.mStartDeviceTemplate;
        ExportAsPorts exportAsPorts = isStartDevT ? this.mExportAsPortsTop : this.mExportAsPorts;
        return exportAsPorts == ExportAsPorts.AllNets || (!isStartDevT || exportAsPorts == ExportAsPorts.NetsMappedUp) && VerilogExport.mapsUp(d, ports) || exportAsPorts == ExportAsPorts.NetsWithExternalPorts && VerilogExport.hasExternalPorts(ports) || exportAsPorts == ExportAsPorts.NetsWithExternalPortsOnSubstrate && VerilogExport.hasExternalPortsOnSubstrate(ports);
    }

    protected boolean writeChildDevice(Device d, String outputName) {
        String unconnectedPortParameter = this.mUseNetUnusedForUnconnectedPorts ? "NetUnused" : "";
        DeviceTemplate dt = d.getTemplate();
        DeviceTemplateInfo info = this.mDeviceTemplateInfo.getInfo(dt);
        LinkedList ports = AUtil.linkedList(info.getPorts().iterator());
        BusConnections busConnections = new BusConnections(d, (String)outputName);
        for (String ibd : busConnections.getIntermediateBusLines()) {
            this.outputln(ibd, new Object[0]);
        }
        if (((String)(outputName = this.identifier((String)outputName))).contains("[") && !((String)outputName).startsWith("\\")) {
            outputName = "\\" + (String)outputName;
        }
        this.output("\t%s %s (", this.identifier(dt.getName()), outputName);
        int portCount = 0;
        for (String entry : busConnections.getVerilogEntries()) {
            if (portCount == 0) {
                this.outputln();
            }
            if (++portCount != 1) {
                this.outputln(" ,", new Object[0]);
            }
            this.output("\t\t%s", entry);
        }
        for (VPort port : ports) {
            String parentName;
            if (info.getBusInfo(port) != null || !info.getOmitDefn() && !this.exportPort(d, port) || this.mStopTemplates.contains(d.getTemplate()) && !this.exportPort(d, port)) continue;
            VPort parentPort = this.getParentVPort(d, port);
            String string = parentName = parentPort == null ? unconnectedPortParameter : this.identifier(parentPort.getName());
            if (parentName.length() > 0) {
                parentName = String.format(" %s ", parentName);
            }
            if (port.getUsePhysPinName() != null) {
                for (PinTemplate pinT : port.getUsePhysPinName()) {
                    if (portCount == 0) {
                        this.outputln();
                    }
                    if (++portCount != 1) {
                        this.outputln(" ,", new Object[0]);
                    }
                    this.output("\t\t.%s (%s)", this.identifier(pinT.getName()), parentName);
                }
                continue;
            }
            if (portCount == 0) {
                this.outputln();
            }
            if (++portCount != 1) {
                this.outputln(" ,", new Object[0]);
            }
            this.output("\t\t.%s (%s)", this.identifier(port.getName()), parentName);
        }
        if (portCount > 0) {
            this.outputln();
            this.output("\t", new Object[0]);
        }
        this.outputln(");", new Object[0]);
        return true;
    }

    protected void output(String fmt, Object ... args) {
        this.mOutput.format(fmt, args);
    }

    protected void outputln() {
        this.mOutput.println();
    }

    protected void outputln(String fmt, Object ... args) {
        this.output(fmt, args);
        this.outputln();
    }

    public static String getPortType(VPort port) {
        return VerilogExport.getPortType((Iterable<VPort>)ASingletonItr.create((Object)port));
    }

    static String getDriverVPortDirection(PinTemplate pt) {
        PinTemplate.Direction dir = pt.getDirection();
        if (dir != null) {
            if (dir == PinTemplate.Direction.IN) {
                return PORTTYPE_IN;
            }
            if (dir == PinTemplate.Direction.OUT) {
                return PORTTYPE_OUT;
            }
            if (dir == PinTemplate.Direction.INOUT) {
                return PORTTYPE_IO;
            }
        }
        ALog.logWarn((String)"Pin '%s' on DeviceTemplate '%s' is marked as a driver pin but it's direction is set to %s; therefore, its direction is being ignored.");
        return null;
    }

    public static String getPortType(Iterable<VPort> ports) {
        LinkedList portList = AUtil.linkedList(ports.iterator());
        String type = null;
        for (VPort port : portList) {
            String thisPortType = null;
            ProcessingIterator<HierInst<PinTemplate>, PinTemplate> pins = GetPortTypeChecksAllDescendants ? new ProcessingIterator<HierInst<PinTemplate>, PinTemplate>((Iterator)port.getNet().getDescendantPins()){

                protected PinTemplate process(HierInst<PinTemplate> hpt) {
                    return (PinTemplate)hpt.getDbObject();
                }
            } : port.getNet().getPinTemplates();
            for (PinTemplate pt : pins) {
                String vdir;
                Boolean isDriver = (Boolean)pt.getValue("tech.driver");
                if (isDriver == null || !isDriver.booleanValue() || (vdir = VerilogExport.getDriverVPortDirection(pt)) == null) continue;
                thisPortType = vdir;
                break;
            }
            if (PORTTYPE_IO.equals(thisPortType)) {
                return PORTTYPE_IO;
            }
            if (PORTTYPE_OUT.equals(thisPortType) && PORTTYPE_IO.equals(type)) {
                return PORTTYPE_IO;
            }
            if (PORTTYPE_IN.equals(thisPortType) && PORTTYPE_OUT.equals(type)) {
                return PORTTYPE_IO;
            }
            type = thisPortType;
        }
        if (type != null) {
            return type;
        }
        for (VPort port : portList) {
            ProcessingIterator<HierInst<PinTemplate>, PinTemplate> pins = GetPortTypeChecksAllDescendants ? new ProcessingIterator<HierInst<PinTemplate>, PinTemplate>((Iterator)port.getNet().getDescendantPins()){

                protected PinTemplate process(HierInst<PinTemplate> hpt) {
                    return (PinTemplate)hpt.getDbObject();
                }
            } : port.getNet().getPinTemplates();
            for (PinTemplate pt : pins) {
                PinTemplate.Direction dir = pt.getDirection();
                if (dir == PinTemplate.Direction.IN) {
                    if (PORTTYPE_OUT.equals(type)) {
                        return PORTTYPE_IO;
                    }
                    type = PORTTYPE_IN;
                    continue;
                }
                if (dir == PinTemplate.Direction.OUT) {
                    if (PORTTYPE_IN.equals(type)) {
                        return PORTTYPE_IO;
                    }
                    type = PORTTYPE_OUT;
                    continue;
                }
                return PORTTYPE_IO;
            }
        }
        if (type == null) {
            return PORTTYPE_IO;
        }
        return type;
    }

    public static boolean mapsUp(Device device, Iterable<VPort> ports) {
        for (VPort port : ports) {
            if (NetMap.getParentNet((Device)device, (Net)port.getNet()) == null) continue;
            return true;
        }
        return false;
    }

    public static boolean mapsUp(Device device, VPort port) {
        return NetMap.getParentNet((Device)device, (Net)port.getNet()) != null;
    }

    public static boolean mapsDown(Iterable<VPort> ports) {
        for (VPort port : ports) {
            if (!NetMap.getChildNets((Net)port.getNet()).hasNext()) continue;
            return true;
        }
        return false;
    }

    public static boolean mapsDown(VPort port) {
        return NetMap.getChildNets((Net)port.getNet()).hasNext();
    }

    public static boolean hasExternalPorts(Iterable<VPort> ports) {
        for (VPort port : ports) {
            if (!NetFilters.EXTERNAL_PORTS.include(port.getNet())) continue;
            return true;
        }
        return false;
    }

    public static boolean hasExternalPorts(VPort port) {
        return NetFilters.EXTERNAL_PORTS.include(port.getNet());
    }

    public static boolean hasExternalPortsOnSubstrate(Iterable<VPort> ports) {
        for (VPort port : ports) {
            if (!NetFilters.EXTERNAL_PORTS_ON_SUBSTRATE.include(port.getNet())) continue;
            return true;
        }
        return false;
    }

    public static boolean hasExternalPortsOnSubstrate(VPort port) {
        return NetFilters.EXTERNAL_PORTS_ON_SUBSTRATE.include(port.getNet());
    }

    protected VPort getParentVPort(Device device, VPort port) {
        if (device == null || port == null || port == BusInfo.NOPORT) {
            return null;
        }
        Net parentNet = NetMap.getParentNet((Device)device, (Net)port.getNet());
        if (parentNet == null) {
            return null;
        }
        DeviceTemplateInfo info = this.mDeviceTemplateInfo.getInfo(parentNet.getDeviceTemplate());
        return info.getPort(parentNet);
    }

    protected String identifier(String in) {
        return this.mVerilogIdentifier.identifier(in);
    }

    protected static boolean isLeaf(DeviceTemplate dt) {
        return !dt.getChildren().hasNext();
    }

    public static boolean isLefLeaf(DeviceTemplate dt) {
        return dt.getSourceType() == DeviceTemplate.SourceType.LEFDEF && VerilogExport.isLeaf(dt);
    }

    public static boolean isSynthLeaf(DeviceTemplate dt) {
        return dt.getIsSynthesized() && VerilogExport.isLeaf(dt);
    }

    static {
        DeviceSort.add((APair<String, Comparator<Device>>)APair.create((Object)"<Default>", (Object)null));
        DefaultDeviceSort = null;
        GetPortTypeChecksAllDescendants = true;
    }

    protected class BusConnections {
        protected LinkedList<String> mIntermediateBusLines = new LinkedList();
        protected LinkedList<String> mVerilogConnectionEntries = new LinkedList();

        public BusConnections(Device device, String deviceOutputName) {
            DeviceTemplate dt = device.getTemplate();
            DeviceTemplateInfo info = VerilogExport.this.mDeviceTemplateInfo.getInfo(dt);
            String noConnectId = VerilogExport.this.identifier(String.format("%s_NetUnused", deviceOutputName));
            for (BusInfo busInfo : info.getBuses()) {
                BusAssignments assignments = new BusAssignments(device, busInfo, noConnectId);
                if (assignments.getConnected() == 0L) continue;
                this.mVerilogConnectionEntries.add(String.format(".%s ( %s )", busInfo.getBusName(), assignments.getVerilog()));
                LinkedList<String> intBusDefs = assignments.getIntermediatBusDefintions();
                if (intBusDefs == null) continue;
                this.mIntermediateBusLines.addAll(intBusDefs);
                this.mIntermediateBusLines.add("");
            }
        }

        public IterableIterator<String> getIntermediateBusLines() {
            return AIterableItr.itr(this.mIntermediateBusLines);
        }

        public IterableIterator<String> getVerilogEntries() {
            return AIterableItr.itr(this.mVerilogConnectionEntries);
        }
    }

    protected class BusAssignments {
        protected LinkedList<String> mIntermediateBusDefns = null;
        protected LinkedList<BusAssignment> mAssignments = new LinkedList();
        protected long mConnected = 0L;
        protected long mNotConnected = 0L;
        protected String mCurSrcName = null;
        protected Long mCurSrcRangeStart = null;
        protected Long mCurSrcRangeEnd = null;
        protected Long mTgtRangeStart = null;
        protected Long mTgtRangeEnd = null;

        public BusAssignments(Device device, BusInfo busInfo, String noConnectId) {
            int usedIntermediateWireCount = 0;
            int usedIOPaddingWireCount = 0;
            Long lastIdx = null;
            int curUnAssignGrpSize = 0;
            for (APair<Long, VPort> aPair : busInfo.getIndexedPorts()) {
                String parentName;
                if (this.mTgtRangeStart == null) {
                    this.mTgtRangeStart = (Long)aPair.first;
                    this.mTgtRangeEnd = (Long)aPair.first;
                }
                if (lastIdx != null && lastIdx + 1L < (Long)aPair.first) {
                    if (curUnAssignGrpSize == 0) {
                        this.outputAndReset();
                    }
                    long l = (Long)aPair.first - lastIdx - 1L;
                    curUnAssignGrpSize = (int)((long)curUnAssignGrpSize + l);
                    this.mNotConnected += l;
                    this.mTgtRangeEnd = this.mTgtRangeEnd + (l - 1L);
                }
                lastIdx = (Long)aPair.first;
                VPort vPort = (VPort)aPair.second;
                VPort parentPort = VerilogExport.this.getParentVPort(device, vPort);
                if (vPort == BusInfo.NOPORT || parentPort == null && !VerilogExport.this.mUseNetUnusedForUnconnectedPorts) {
                    if (curUnAssignGrpSize == 0) {
                        this.outputAndReset();
                    }
                    ++curUnAssignGrpSize;
                    ++this.mNotConnected;
                    continue;
                }
                if (parentPort == null) {
                    if (curUnAssignGrpSize == 0) {
                        this.outputAndReset();
                    } else {
                        this.outputAndResetUnassigned(curUnAssignGrpSize);
                        curUnAssignGrpSize = 0;
                    }
                    ++this.mNotConnected;
                    this.mAssignments.addFirst(new BusAssignment(noConnectId, (Long)aPair.first, (Long)aPair.first));
                    this.mTgtRangeStart = null;
                    this.mTgtRangeEnd = null;
                    continue;
                }
                if (curUnAssignGrpSize > 0) {
                    this.outputAndResetUnassigned(curUnAssignGrpSize);
                    curUnAssignGrpSize = 0;
                }
                ++this.mConnected;
                String string = parentName = parentPort == null ? null : parentPort.getName();
                if (VerilogSyntax.isBusName((String)parentName)) {
                    APair busNetInfo = VerilogSyntax.parseBusName((String)parentName);
                    String name = (String)busNetInfo.first;
                    Long bit = (Long)busNetInfo.second;
                    if (!name.equals(this.mCurSrcName)) {
                        this.outputAndReset();
                    }
                    if (this.mCurSrcName == null) {
                        this.mCurSrcName = name;
                        this.mCurSrcRangeStart = bit;
                    } else {
                        boolean contRange;
                        boolean bl = this.mCurSrcRangeEnd == null ? bit == this.mCurSrcRangeStart + 1L || bit == this.mCurSrcRangeStart - 1L : (contRange = bit == this.mCurSrcRangeEnd + (long)Long.signum(this.mCurSrcRangeEnd - this.mCurSrcRangeStart));
                        if (contRange) {
                            this.mCurSrcRangeEnd = bit;
                        } else {
                            this.outputAndReset();
                            this.mCurSrcName = name;
                            this.mCurSrcRangeStart = bit;
                        }
                    }
                    this.mTgtRangeEnd = (Long)aPair.first;
                    continue;
                }
                this.outputAndReset();
                this.mAssignments.addFirst(new BusAssignment(parentName, (Long)aPair.first, (Long)aPair.first));
                this.mTgtRangeStart = null;
                this.mTgtRangeEnd = null;
            }
            if (curUnAssignGrpSize == 0) {
                this.outputAndReset();
            } else {
                this.outputAndResetUnassigned(curUnAssignGrpSize);
                curUnAssignGrpSize = 0;
            }
            if (this.mNotConnected > 0L) {
                this.mIntermediateBusDefns = new LinkedList();
                String busPortType = VerilogExport.getPortType(busInfo.getPorts());
                if (VerilogExport.PORTTYPE_IO.equals(busPortType)) {
                    for (BusAssignment busAssignment : this.mAssignments) {
                        if (!Bit0PaddingRegex.matcher(busAssignment.src).matches()) continue;
                        String padWireName = String.format("%s_%s%s_padded_%d", device.getName(), busInfo.getBusName(), usedIOPaddingWireCount == 0 ? "" : Integer.valueOf(usedIOPaddingWireCount), busAssignment.tgtRangeEnd - busAssignment.tgtRangeStart + 1L);
                        ++usedIOPaddingWireCount;
                        this.mIntermediateBusDefns.add(busAssignment.tgtRangeStart == busAssignment.tgtRangeEnd ? String.format("wire %s;", padWireName) : String.format("wire [%d:%d] %s;", busAssignment.tgtRangeEnd - busAssignment.tgtRangeStart, 0, padWireName));
                        busAssignment.src = padWireName;
                    }
                } else {
                    String string = String.format("%s_%s%s", device.getName(), busInfo.getBusName(), usedIntermediateWireCount == 0 ? "" : Integer.valueOf(usedIntermediateWireCount));
                    ++usedIntermediateWireCount;
                    this.mIntermediateBusDefns.add(String.format("wire [%d:%d] %s;", busInfo.getRangeMax(), busInfo.getRangeMin(), string));
                    for (BusAssignment a : this.mAssignments) {
                        if (Bit0PaddingRegex.matcher(a.src).matches() && !VerilogExport.PORTTYPE_IN.equals(busPortType)) continue;
                        if (VerilogExport.PORTTYPE_IN.equals(busPortType)) {
                            this.mIntermediateBusDefns.add(String.format("assign %s[%d:%d] = %s;", string, a.tgtRangeEnd, a.tgtRangeStart, a.src));
                            continue;
                        }
                        this.mIntermediateBusDefns.add(String.format("assign %s = %s[%d:%d];", a.src, string, a.tgtRangeEnd, a.tgtRangeStart));
                    }
                    this.mAssignments.clear();
                    String string2 = String.format("%s[%d:%d]", string, busInfo.getRangeMax(), busInfo.getRangeMin());
                    this.mAssignments.add(new BusAssignment(string2, busInfo.getRangeMin(), busInfo.getRangeMax()));
                }
            }
        }

        public long getNotConnected() {
            return this.mNotConnected;
        }

        public long getConnected() {
            return this.mConnected;
        }

        public LinkedList<String> getIntermediatBusDefintions() {
            return this.mIntermediateBusDefns;
        }

        public String getVerilog() {
            StringBuffer buf = new StringBuffer();
            for (BusAssignment a : this.mAssignments) {
                if (buf.length() > 0) {
                    buf.append(" , ");
                }
                buf.append(a.getSrc());
            }
            String fmt = this.mAssignments.size() > 1 ? "{ %s }" : "%s";
            return String.format(fmt, buf.toString());
        }

        protected void outputAndReset() {
            if (this.mCurSrcName == null) {
                return;
            }
            String src = this.mCurSrcRangeEnd == null ? String.format("%s[%d]", this.mCurSrcName, this.mCurSrcRangeStart) : String.format("%s[%d:%d]", this.mCurSrcName, this.mCurSrcRangeEnd, this.mCurSrcRangeStart);
            this.mAssignments.addFirst(new BusAssignment(src, this.mTgtRangeStart, this.mTgtRangeEnd));
            this.mCurSrcName = null;
            this.mCurSrcRangeStart = null;
            this.mCurSrcRangeEnd = null;
            this.mTgtRangeStart = this.mTgtRangeEnd = Long.valueOf(this.mTgtRangeEnd + 1L);
        }

        protected void outputAndResetUnassigned(int curUnAssignGrpSize) {
            this.mTgtRangeEnd = this.mTgtRangeStart + (long)curUnAssignGrpSize - 1L;
            StringBuilder sb = new StringBuilder(3 + curUnAssignGrpSize);
            sb.append(curUnAssignGrpSize);
            sb.append("'b");
            for (int i = 0; i < curUnAssignGrpSize; ++i) {
                sb.append('0');
            }
            this.mAssignments.addFirst(new BusAssignment(sb.toString(), this.mTgtRangeStart, this.mTgtRangeEnd));
            this.mTgtRangeStart = this.mTgtRangeEnd = Long.valueOf(this.mTgtRangeEnd + 1L);
        }
    }

    protected static class BusAssignment {
        protected String src;
        protected long tgtRangeStart;
        protected long tgtRangeEnd;

        protected BusAssignment(String src, long tgtRangeStart, long tgtRangeEnd) {
            this.src = src;
            this.tgtRangeStart = tgtRangeStart;
            this.tgtRangeEnd = tgtRangeEnd;
        }

        public String getSrc() {
            return this.src;
        }

        public long getTgtRangeStart() {
            return this.tgtRangeStart;
        }

        public long getTgtRangeEnd() {
            return this.tgtRangeEnd;
        }
    }

    protected static class BusInfo {
        public static final VPort NOPORT = new VPort(null, null);
        protected String mBusName;
        protected LinkedList<APair<Long, VPort>> mPorts = new LinkedList();
        protected boolean mSorted = false;

        public BusInfo(String busName) {
            this.mBusName = busName;
        }

        public void addPort(VPort port) {
            this.addPort(port, null);
        }

        public void addPort(VPort port, APair<String, Long> nameAndNum) {
            if (nameAndNum == null) {
                nameAndNum = VerilogSyntax.parseBusName((String)port.getName());
            }
            assert (((String)nameAndNum.first).equals(this.mBusName));
            this.mPorts.add((APair<Long, VPort>)new APair((Object)((Long)nameAndNum.second), (Object)port));
            this.mSorted = false;
        }

        public String getBusName() {
            return this.mBusName;
        }

        public long getRangeMin() {
            if (!this.mSorted) {
                this.sort();
            }
            return (Long)this.mPorts.getFirst().first;
        }

        public long getRangeMax() {
            if (!this.mSorted) {
                this.sort();
            }
            return (Long)this.mPorts.getLast().first;
        }

        public IterableIterator<VPort> getPorts() {
            if (!this.mSorted) {
                this.sort();
            }
            return new ProcessingIterator<APair<Long, VPort>, VPort>(this.mPorts.iterator()){

                protected VPort process(APair<Long, VPort> p) {
                    return (VPort)p.second;
                }
            };
        }

        public Iterable<APair<Long, VPort>> getIndexedPorts() {
            if (!this.mSorted) {
                this.sort();
            }
            return AIterableItr.itr(this.mPorts);
        }

        protected void sort() {
            Collections.sort(this.mPorts, new Comparator<APair<Long, VPort>>(){

                @Override
                public int compare(APair<Long, VPort> a, APair<Long, VPort> b) {
                    return ((Long)a.first).compareTo((Long)b.first);
                }
            });
            this.mSorted = true;
        }
    }

    protected static class Buses {
        protected LinkedHashMap<String, BusInfo> mName2BusInfo = new LinkedHashMap();
        protected HashMap<VPort, BusInfo> mPort2BusInfo = new HashMap();

        protected Buses() {
        }

        public void add(VPort port) {
            APair nameAndNum = VerilogSyntax.parseBusName((String)port.getName());
            BusInfo busInfo = this.mName2BusInfo.get(nameAndNum.first);
            if (busInfo == null) {
                busInfo = new BusInfo((String)nameAndNum.first);
                this.mName2BusInfo.put((String)nameAndNum.first, busInfo);
            }
            busInfo.addPort(port);
            this.mPort2BusInfo.put(port, busInfo);
        }

        public BusInfo getBus(VPort port) {
            return this.mPort2BusInfo.get(port);
        }

        public IterableIterator<BusInfo> itr() {
            return AIterableItr.itr(this.mName2BusInfo.values());
        }
    }

    protected class DeviceTemplateInfo {
        protected DeviceTemplate mDeviceTemplate;
        protected boolean mOmitDefn = false;
        protected LinkedList<VPort> mPorts = Lists.newLinkedList();
        protected HashMap<Net, VPort> mNet2Port = Maps.newHashMap();
        protected Buses mBuses;
        protected boolean mOutput = false;

        public DeviceTemplateInfo(DeviceTemplate dt) {
            this.mDeviceTemplate = dt;
            if (!VerilogExport.this.mExportLeafDefs && VerilogExport.isLeaf(dt)) {
                this.mOmitDefn = true;
            } else {
                if (!VerilogExport.this.mExportLeafDefsSynth && VerilogExport.isSynthLeaf(dt)) {
                    this.mOmitDefn = true;
                }
                if (!VerilogExport.this.mExportLeafDefsLef && VerilogExport.isLefLeaf(dt)) {
                    this.mOmitDefn = true;
                }
            }
            Boolean omit = (Boolean)this.mDeviceTemplate.getValue(VerilogExport.OMIT_FROM_VERILOG_DEFINITION_FIELD);
            if (omit != null && omit.booleanValue()) {
                this.mOmitDefn = true;
            }
            if (VerilogExport.this.mStopTemplates.contains(dt)) {
                this.mOmitDefn = true;
            }
            for (Net net : dt.getNets()) {
                LinkedList pins;
                if (net.isUnused()) continue;
                String portName = net.getName();
                if (VerilogExport.this.mOmittedDefnInstancesUsePinNames && this.getOmitDefn() && (pins = AUtil.linkedList((Iterator)net.getPinTemplates())).size() > 0) {
                    Collections.sort(pins);
                    portName = ((PinTemplate)pins.get(0)).getName();
                }
                VPort port = VPort.create(portName, net);
                if (VerilogExport.this.mUsePhysPinNamesForPorts) {
                    LinkedList pins2 = AUtil.linkedList((Iterator)net.getPinTemplates());
                    Collections.sort(pins2);
                    if (pins2.size() > 0) {
                        port.setUsePhysPinNames(pins2);
                    }
                }
                this.mPorts.add(port);
                this.mNet2Port.put(net, port);
            }
            Collections.sort(this.mPorts);
            this.mBuses = new Buses();
            for (VPort port : this.mPorts) {
                String name;
                if (VerilogExport.this.mUsePhysPinNamesForPorts && port.getUsePhysPinName() != null || !VerilogSyntax.isBusName((String)(name = port.getName()))) continue;
                this.mBuses.add(port);
            }
        }

        public boolean getOmitDefn() {
            return this.mOmitDefn;
        }

        public void setOutput(boolean b) {
            this.mOutput = b;
        }

        public boolean getOutput() {
            return this.mOutput;
        }

        public BusInfo getBusInfo(VPort port) {
            return this.mBuses.getBus(port);
        }

        public IterableIterator<BusInfo> getBuses() {
            return this.mBuses.itr();
        }

        public Iterable<VPort> getPorts() {
            return this.mPorts;
        }

        public VPort getPort(Net net) {
            return this.mNet2Port.get(net);
        }
    }

    protected static class VPort
    implements Comparable<VPort> {
        protected String mName;
        protected Net mNet;
        protected List<PinTemplate> mUsePhysPinName = null;

        public static VPort create(String name, Net net) {
            return new VPort(name, net);
        }

        protected VPort(String name, Net net) {
            this.mName = name;
            this.mNet = net;
        }

        public String getName() {
            return this.mName;
        }

        public Net getNet() {
            return this.mNet;
        }

        public void setUsePhysPinNames(List<PinTemplate> pins) {
            this.mUsePhysPinName = pins;
        }

        public List<PinTemplate> getUsePhysPinName() {
            return this.mUsePhysPinName;
        }

        @Override
        public int compareTo(VPort other) {
            return AAlphaNumComp.comp((Object)this.getName(), (Object)other.getName());
        }
    }

    protected class DeviceTemplateInfoMap {
        protected HashMap<DeviceTemplate, DeviceTemplateInfo> mTemplate2Info = new HashMap();

        protected DeviceTemplateInfoMap() {
        }

        public DeviceTemplateInfo getInfo(DeviceTemplate dt) {
            DeviceTemplateInfo info = this.mTemplate2Info.get(dt);
            if (info == null) {
                info = new DeviceTemplateInfo(dt);
                this.mTemplate2Info.put(dt, info);
            }
            return info;
        }
    }

    public static enum ExportAsPorts {
        AllNets("All Nets"),
        NetsMappedUp("Nets Mapped up"),
        NetsWithExternalPorts("Nets With External Ports"),
        NetsWithExternalPortsOnSubstrate("Nets With External Ports On Same Substrate");

        protected String mLabel;

        private ExportAsPorts(String label) {
            this.mLabel = label;
        }

        public String getLabel() {
            return this.mLabel;
        }
    }
}

