/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.factory;

import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.ATransformUtil;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.ContactLayer;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.LayerShape;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinLabel;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.PortTemplate;
import com.sigrity.acl.db.std.Scribe;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.db.std.Term;
import com.sigrity.acl.db.std.TermMap;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.topology.Binner;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.automation.pinMap.NetMapGenerator;
import com.sigrity.orbit.automation.pinMap.PinMapCsvReader;
import com.sigrity.orbit.automation.pinMap.PinMapGenerator;
import java.awt.geom.AffineTransform;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ContactDeviceFactory {
    private Db mDb;
    private ContactLayer mContactLayer;
    private DeviceTemplate mContactDevT;
    private String mContactPinPrefix = "";
    private Device mContactDev;
    private String mPinNetCsvFilePath;
    private PinMapCsvReader mImportCsvPinMap;
    private AffineTransform mTransfromRef2ContactDev;
    private Map<PadTemplate, PadTemplate> padT2ContactPadT = new HashMap<PadTemplate, PadTemplate>();
    private PadTemplate mContactPadT;
    private Map<PadTemplate, DeviceTemplate> padT2ContactPinDevT = new HashMap<PadTemplate, DeviceTemplate>();
    private DeviceTemplate mContactPinDevT;
    private DevicePath mReferenceDevPath;
    private DevicePath mContactDevPath;
    private DevicePath mContactDevPathFromSubstrateInst;
    private Layer mReferenceLayer;
    private Layer mContactPinLayer;
    private ScribeInfo mScribeInfo;
    private boolean mIsCreateOnDevPathA = false;
    private boolean mCreateConatctDev = false;
    private boolean mCreateContactPinDev = false;
    private boolean mInferDeviceHierarchy = false;
    private boolean mInfereNetMap = false;
    private boolean mOnlySelectedPins = false;
    private Set<HierInst<PinTemplate>> mSelectedPins;
    private Set<DevicePath> mSelectedPinDevs;

    public ContactDeviceFactory(Db db, String contactLayerKeyStr) {
        this(db, (ContactLayer)db.getByKeyStr(ContactLayer.class, contactLayerKeyStr));
    }

    public ContactDeviceFactory(Db db, String contactLayerKeyStr, boolean isCreateOnDevPathA) {
        this(db, (ContactLayer)db.getByKeyStr(ContactLayer.class, contactLayerKeyStr), isCreateOnDevPathA);
    }

    public ContactDeviceFactory(Db db, ContactLayer contactLayer) {
        this(db, contactLayer, false);
    }

    public ContactDeviceFactory(Db db, ContactLayer contactLayer, boolean isCreateOnDevPathA) {
        this.mDb = db;
        this.mContactLayer = contactLayer;
        this.mIsCreateOnDevPathA = isCreateOnDevPathA;
        if (isCreateOnDevPathA) {
            this.mReferenceDevPath = contactLayer.getDevicePathB();
            this.mReferenceLayer = contactLayer.getContactLayerB();
            this.mContactDevPath = contactLayer.getDevicePathA();
            this.mContactPinLayer = contactLayer.getContactLayerA();
        } else {
            this.mReferenceDevPath = contactLayer.getDevicePathA();
            this.mReferenceLayer = contactLayer.getContactLayerA();
            this.mContactDevPath = contactLayer.getDevicePathB();
            this.mContactPinLayer = contactLayer.getContactLayerB();
        }
    }

    public void setOnlySelectedPins(boolean b) {
        this.mOnlySelectedPins = b;
    }

    public void setContactPadTemplate(String padTName) {
        this.mContactPadT = PadTemplate.get((Db)this.mDb, (Substrate)this.mContactPinLayer.getSubstrate(), (String)padTName);
    }

    public void setContactPinDevT(String pinDevTKeyStr) {
        DeviceTemplate pinDevT = (DeviceTemplate)this.mDb.getByKeyStr(DeviceTemplate.class, pinDevTKeyStr);
        this.setContactPinDevT(pinDevT);
    }

    public void setContactPinPrefix(String pinPrefix) {
        this.mContactPinPrefix = pinPrefix;
    }

    public void setContactPinDevT(DeviceTemplate pinDevT) {
        this.mContactPinDevT = pinDevT;
    }

    public void setCsvPinMap(String filePath) {
        this.mPinNetCsvFilePath = filePath;
    }

    public void setCreatePinDev(boolean b) {
        this.mCreateContactPinDev = b;
    }

    public void setCreateContactDev(boolean b) {
        this.mCreateConatctDev = b;
    }

    public void setInferDeviceHierarchy(boolean b) {
        this.mInferDeviceHierarchy = b;
    }

    public void setInferNetMap(boolean b) {
        this.mInfereNetMap = b;
    }

    public void setContactDeviceScribe(long northVal, long southVal, long eastVal, long westVal) {
        this.mScribeInfo = new ScribeInfo(northVal, southVal, eastVal, westVal);
    }

    public void execute() {
        this.importPinNetCsv();
        if (this.mCreateConatctDev) {
            this.generateContactDeviceTemplate();
            this.generateContactDevice();
            this.generateContactDeviceScribe();
            this.mContactDevPath = new DevicePath(this.mContactDevPath, this.mContactDev);
        } else {
            this.mContactDevT = this.mContactDevPath.getDeviceTemplate();
            this.mContactDev = this.mContactDevPath.getDevice();
        }
        this.generateContactPins();
        this.inferDeviceHierarchy();
        this.updateContactLayer();
        this.generatePinMap();
        this.inferNetMap();
    }

    private void generateContactDeviceTemplate() {
        Substrate contactDevSubstrate = this.mContactPinLayer.getSubstrate();
        String contactDevTName = this.getRefDevT().getName();
        this.mContactDevT = DeviceTemplate.create((Substrate)contactDevSubstrate, (String)contactDevTName, (boolean)true);
        this.mContactDevT.setType(this.getRefDevT().getType());
        this.mContactDevT.setSourceType(DeviceTemplate.SourceType.ORBITIO_CONTACT);
        this.mContactDevT.setBounds(this.getContactDevTBounds());
        this.mContactDevT.setIsAbstractContactDevice(true);
    }

    private AGeom getContactDevTBounds() {
        return this.getRefDevT().getBounds();
    }

    private void generateContactDevice() {
        assert (this.mContactDevT != null);
        DeviceTemplate toDevT = this.mContactDevPath.getDeviceTemplate();
        String contactDevName = Device.getUniqueName((DeviceTemplate)toDevT, (String)(this.mContactPinPrefix + this.getContactDeviceName()));
        this.mContactDev = Device.create((String)contactDevName, (DeviceTemplate)this.mContactDevT, (DeviceTemplate)toDevT);
        this.mContactDev.setLoc(this.getContactDeviceLocation());
        this.mContactDev.setRotate(this.getContactDeviceRotation());
        this.mContactDev.setFlipped(this.getContactDeviceFlipped());
        this.mContactDev.setMirror(this.getContactDeviceMirror());
    }

    private String getContactDeviceName() {
        return this.getRefDev() == null ? this.getRefDevT().getName() : this.getRefDev().getName();
    }

    private APoint2D getContactDeviceLocation() {
        AffineTransform toOwner = this.mReferenceDevPath.getParent().getTransform();
        AffineTransform toContactDevTParent = this.mContactDevPath.getInverseTransform();
        return this.getRefDev().getLoc().transform(toOwner).transform(toContactDevTParent);
    }

    private float getContactDeviceRotation() {
        float rot = this.mReferenceDevPath.getRot() - this.mContactDevPath.getRot();
        return ATransformUtil.normRot((float)rot);
    }

    private boolean getContactDeviceFlipped() {
        return this.mReferenceDevPath.getFlipped() ^ this.mContactDevPath.getFlipped();
    }

    private boolean getContactDeviceMirror() {
        return this.mReferenceDevPath.getMirror() ^ this.mContactDevPath.getMirror();
    }

    private void generateContactPins() {
        for (HierInst hierRefPin : this.getReferencePins()) {
            PinMapCsvReader.CsvPinMap csvPinMap = this.getCsvPinMap((HierInst<PinTemplate>)hierRefPin);
            String contactPinName = this.mContactPinPrefix + this.getContactPinName(csvPinMap, (HierInst<PinTemplate>)hierRefPin);
            Term referenceTerm = this.getReferenceTerm(csvPinMap, (HierInst<PinTemplate>)hierRefPin);
            Net referenceNet = referenceTerm == null ? this.getReferenceNet(csvPinMap, (HierInst<PinTemplate>)hierRefPin) : referenceTerm.getNet();
            Term contactTerm = this.getContactTerm(csvPinMap, referenceTerm, referenceNet);
            if (this.mCreateContactPinDev) {
                this.generateContactPinDevs((HierInst<PinTemplate>)hierRefPin, contactPinName, contactTerm);
                continue;
            }
            this.generateContactPinTs((HierInst<PinTemplate>)hierRefPin, contactPinName, contactTerm);
        }
    }

    private PinMapCsvReader.CsvPinMap getCsvPinMap(HierInst<PinTemplate> hierRefPin) {
        if (this.mImportCsvPinMap == null) {
            return null;
        }
        if (this.mIsCreateOnDevPathA) {
            return this.mImportCsvPinMap.getCsvPinMapFromB(hierRefPin);
        }
        return this.mImportCsvPinMap.getCsvPinMapFromA(hierRefPin);
    }

    private void generateContactPinTs(HierInst<PinTemplate> hierRefPin, String contactPinName, Term contactTerm) {
        Net contactNet = contactTerm == null ? this.mContactDevT.getNetUnused() : contactTerm.getNet();
        PinTemplate contactPin = PinTemplate.create((Net)contactNet, (String)contactPinName);
        contactPin.setUse(((PinTemplate)hierRefPin.getSecond()).getUse());
        PinTemplate.Type pinType = this.getContactPinType(hierRefPin);
        contactPin.setType(pinType);
        float rotationOffset = this.mReferenceDevPath.getRot() + hierRefPin.getPath().getRot() - this.mContactDevPath.getRot();
        boolean mirrorOffset = this.mReferenceDevPath.getMirror() ^ hierRefPin.getPath().getMirror() ^ this.mContactDevPath.getMirror();
        ((PinTemplate)hierRefPin.getSecond()).getPortTemplates().filter(port -> port.getLayerShapesOnLayer(this.mReferenceLayer).hasNext()).forEach(referencePort -> {
            PortTemplate contactPort = PortTemplate.create((PinTemplate)contactPin);
            contactPort.setLoc(this.getLocInContactDev(hierRefPin.getPath().transformPt(referencePort.getLoc())));
            contactPort.setPadTemplate(this.getContactPadTemplate((PortTemplate)referencePort));
            contactPort.setPortNum(referencePort.getPortNum());
            float normRot = ATransformUtil.normRot((float)(referencePort.getRotate() + rotationOffset));
            contactPort.setRotate(normRot);
            if (normRot % 90.0f != 0.0f) {
                ALog.flogWarn((String)"Special rotation for pin '%s' at '%s'. Check alignment between the contact pins.", (Object[])new Object[]{contactPort.getPinTemplate().getName(), this.mContactDevPath});
            }
            this.shiftByCenteroffset((PortTemplate)referencePort, contactPort, normRot, mirrorOffset);
        });
        contactNet.getDeviceTemplate().getDeviceInstances().forEach(dev -> PinInstance.create((Db)this.mDb, null, (Device)dev, (PinTemplate)contactPin));
        if (!contactNet.isNC()) {
            this.setContactPinTLabel(contactTerm, contactPin);
        }
    }

    private PinTemplate.Type getContactPinType(HierInst<PinTemplate> hierRefPin) {
        PinTemplate.Type pinType = ((PinTemplate)hierRefPin.getSecond()).getType();
        if (pinType == PinTemplate.Type.BUMPPAD && this.mContactDevT.isPackage()) {
            pinType = PinTemplate.Type.BALLPAD;
        }
        return pinType;
    }

    private void setContactPinTLabel(Term contactTerm, PinTemplate contactPin) {
        PinLabel pinLabel = PinLabel.get((PinTemplate)contactPin);
        pinLabel.setTerm(contactTerm);
        this.setPinLabelOnSubstrate(contactTerm, contactPin);
    }

    private DevicePath getContactDevPathFromSubstrateInst() {
        if (this.mContactDevPathFromSubstrateInst == null) {
            DeviceTemplate substrateDevT = this.mContactDevPath.getSubstrateDeviceTemplate();
            this.mContactDevPathFromSubstrateInst = substrateDevT == null ? this.mContactDevPath : this.mContactDevPath.getRelativePathFromAnchor(substrateDevT);
        }
        return this.mContactDevPathFromSubstrateInst;
    }

    private void generateContactPinDevs(HierInst<PinTemplate> hierRefPin, String contactPinName, Term contactTerm) {
        Net contactNet = contactTerm == null ? this.mContactDevT.getNetUnused() : contactTerm.getNet();
        float rotationOffset = this.mReferenceDevPath.getRot() + hierRefPin.getPath().getRot() - this.mContactDevPath.getRot();
        boolean mirrorOffset = this.mReferenceDevPath.getMirror() ^ hierRefPin.getPath().getMirror() ^ this.mContactDevPath.getMirror();
        for (PortTemplate referencePort : ((PinTemplate)hierRefPin.getSecond()).getPortTemplates()) {
            if (!referencePort.getLayerShapesOnLayer(this.mReferenceLayer).hasNext()) continue;
            DeviceTemplate contactPinDevT = this.getContactPinDevT(referencePort);
            String contactPinDevName = Device.getUniqueName((DeviceTemplate)this.mContactDevT, (String)contactPinName);
            Device contactPinDevice = Device.create((String)contactPinDevName, (DeviceTemplate)contactPinDevT, (DeviceTemplate)this.mContactDevT);
            contactPinDevice.setLoc(this.getLocInContactDev(hierRefPin.getPath().transformPt(referencePort.getLoc())));
            float normRot = ATransformUtil.normRot((float)(referencePort.getRotate() + rotationOffset));
            contactPinDevice.setRotate(normRot);
            if (normRot % 90.0f != 0.0f) {
                ALog.flogWarn((String)"Special rotation for pin '%s' at '%s'. Check alignment between the contact pins.", (Object[])new Object[]{contactPinDevice.getName(), this.mContactDevPath});
            }
            this.shiftByCenteroffset(referencePort, contactPinDevice, normRot, mirrorOffset);
            Term pinTerm = contactPinDevice.getTerm();
            PinTemplate pin1 = contactPinDevice.getTemplate().getPin1();
            if (pinTerm == null) {
                Net pinNet;
                Net net = pinNet = pin1 == null ? null : pin1.getNet();
                if (pinNet != null) {
                    pinTerm = Term.getOrCreateTerm((DeviceTemplate)contactPinDevT, (String)pinNet.getName());
                }
            }
            if (pinTerm == null || contactNet.isNC()) continue;
            TermMap.mapChildTerm((Device)contactPinDevice, (Term)pinTerm, (Net)contactNet);
            this.setContactPinDevLabel(contactTerm, contactPinDevice, pin1);
        }
    }

    private void setContactPinDevLabel(Term contactTerm, Device contactPinDevice, PinTemplate pin1) {
        PinLabel pinLabel = PinLabel.get((DevicePath)new DevicePath(this.mContactDevT, contactPinDevice), (PinTemplate)pin1);
        pinLabel.setTerm(contactTerm);
        this.setPinLabelOnSubstrate(contactTerm, contactPinDevice, pin1);
    }

    private void setPinLabelOnSubstrate(Term term, PinTemplate pin) {
        this.setPinLabelOnSubstrate(term, null, pin);
    }

    private void setPinLabelOnSubstrate(Term term, Device pinDevice, PinTemplate pin) {
        if (this.mContactDevPath.isEmpty()) {
            return;
        }
        DevicePath contactDevPathFromSubstrateInst = this.getContactDevPathFromSubstrateInst();
        Net rootNet = (Net)AUtil.getIffOne((Collection)TermMap.getTopMostNet((Term)term, (DevicePath)contactDevPathFromSubstrateInst));
        if (rootNet == null || rootNet.getDeviceTemplate() != contactDevPathFromSubstrateInst.getRoot()) {
            return;
        }
        Term rootTerm = (Term)AUtil.getIffOne((Iterator)rootNet.getTerms());
        if (rootTerm == null) {
            return;
        }
        DevicePath pinPath = contactDevPathFromSubstrateInst;
        if (pinDevice != null) {
            pinPath = new DevicePath(contactDevPathFromSubstrateInst, pinDevice);
        }
        PinLabel rootPinLabel = PinLabel.get((DevicePath)pinPath, (PinTemplate)pin);
        rootPinLabel.setTerm(rootTerm);
    }

    private void shiftByCenteroffset(PortTemplate refPort, PortTemplate contactPort, float rot, boolean mirrorOffset) {
        APoint2D refCenterOffset = this.getCenterOffset(refPort, this.mReferenceLayer, rot, mirrorOffset);
        APoint2D centerOffset = this.getCenterOffset(contactPort, this.mContactPinLayer, rot, false);
        contactPort.moveBy(centerOffset.sub(refCenterOffset));
    }

    private APoint2D getCenterOffset(PortTemplate contactPort, Layer shapeLayer, float rot, boolean mirrorOffset) {
        ARect r = contactPort.getPadTemplate().getBounds(shapeLayer);
        return this.getCenterOffset(r, rot, mirrorOffset);
    }

    private void shiftByCenteroffset(PortTemplate refPort, Device contactPinDevice, float rot, boolean mirrorOffset) {
        APoint2D refCenterOffset = this.getCenterOffset(refPort, this.mReferenceLayer, rot, mirrorOffset);
        APoint2D centerOffset = this.getCenterOffset(contactPinDevice, rot, false);
        contactPinDevice.moveBy(centerOffset.sub(refCenterOffset));
    }

    private APoint2D getCenterOffset(Device contactPinDevice, float rot, boolean mirrorOffset) {
        ARect r = contactPinDevice.getTemplate().getBB();
        return this.getCenterOffset(r, rot, mirrorOffset);
    }

    private APoint2D getCenterOffset(ARect rect, float rot, boolean mirrorOffset) {
        long rectCenterX = rect.centerX();
        long rectCenterY = rect.centerY();
        float normRot = ATransformUtil.normRot((float)rot);
        long dx = rectCenterX;
        long dy = rectCenterY;
        if (normRot % 180.0f != 0.0f) {
            dx = rectCenterY;
            dy = rectCenterX;
        }
        APoint2D centerOffset = new APoint2D(dx, dy);
        if (normRot == 0.0f || normRot == 90.0f) {
            centerOffset.setX(-centerOffset.getX());
        }
        if (normRot == 0.0f || normRot == 270.0f) {
            centerOffset.setY(-centerOffset.getY());
        }
        if (mirrorOffset) {
            if (normRot % 90.0f == 0.0f) {
                centerOffset.setY(-centerOffset.getY());
            } else {
                centerOffset.setX(-centerOffset.getX());
            }
        }
        return centerOffset;
    }

    private void importPinNetCsv() {
        if (this.mPinNetCsvFilePath == null || this.mPinNetCsvFilePath.isEmpty()) {
            return;
        }
        this.mImportCsvPinMap = new PinMapCsvReader(this.mContactLayer);
        this.mImportCsvPinMap.importCsvPinMap(this.mPinNetCsvFilePath);
    }

    private IterableIterator<HierInst<PinTemplate>> getReferencePins() {
        Binner portWorldGeomIndex1 = new Binner();
        portWorldGeomIndex1.setWorld(this.mContactLayer.getOwner().getBB());
        this.getPinOnRefLayer().filter(hierPin -> !this.mOnlySelectedPins || this.isSelectedPin((HierInst<PinTemplate>)hierPin)).forEach(hierPin -> {
            ARect pinGeom = ((PinTemplate)hierPin.getDbObject()).getBounds().transform(hierPin.getPathTransform()).getBounds();
            portWorldGeomIndex1.insert(hierPin, pinGeom);
        });
        return portWorldGeomIndex1.intersects(this.mContactDevPath.getBB()).mapAndNonNull(hierPin -> HierInst.create((DevicePath)hierPin.getPath().getRelativePathFromAnchor(this.getRefDevT()), (DbObject)((PinTemplate)hierPin.getDbObject()))).sorted();
    }

    private IterableIterator<HierInst<PinTemplate>> getPinOnRefLayer() {
        if (this.mIsCreateOnDevPathA) {
            return this.mContactLayer.getPinOnContactLayerB();
        }
        return this.mContactLayer.getPinOnContactLayerA();
    }

    private boolean isSelectedPin(HierInst<PinTemplate> hierPin) {
        if (this.mSelectedPins == null) {
            this.initSelectedPins();
        }
        if (this.mSelectedPinDevs == null) {
            this.initSelectedPinDevs();
        }
        return this.mSelectedPins.contains(hierPin) || hierPin.getPath().isPin() && this.mSelectedPinDevs.contains(hierPin.getPath());
    }

    private void initSelectedPins() {
        HierInst hierInst;
        DevicePath devPath;
        Selection s = Design.getSelection((Db)this.mDb);
        this.mSelectedPins = new HashSet<HierInst<PinTemplate>>();
        for (HierInst e : s.getSelectedHierInsts(PinInstance.class)) {
            if (!((DevicePath)e.getFirst()).pathToSubstrate().containsRelative(this.mReferenceDevPath)) continue;
            devPath = ((DevicePath)e.getFirst()).getRelativePathFromAnchor(this.mContactLayer.getOwner());
            hierInst = HierInst.create((DevicePath)devPath, (DbObject)((PinInstance)e.getDbObject()).getPinTemplate());
            this.mSelectedPins.add((HierInst<PinTemplate>)hierInst);
        }
        for (HierInst e : s.getSelectedHierInsts(PinTemplate.class)) {
            if (!((DevicePath)e.getFirst()).pathToSubstrate().containsRelative(this.mReferenceDevPath)) continue;
            devPath = e.getPath().getRelativePathFromAnchor(this.mContactLayer.getOwner());
            hierInst = HierInst.create((DevicePath)devPath, (DbObject)((PinTemplate)e.getDbObject()));
            this.mSelectedPins.add((HierInst<PinTemplate>)hierInst);
        }
        ALog.logInfo((String)"Generate contact pins for %d selected pins on %s", (Object[])new Object[]{this.mSelectedPins.size(), this.mReferenceDevPath});
    }

    private void initSelectedPinDevs() {
        Selection s = Design.getSelection((Db)this.mDb);
        this.mSelectedPinDevs = new HashSet<DevicePath>();
        for (HierInst e : s.getSelectedHierInsts(Device.class)) {
            if (!e.getPath().pathToSubstrate().containsRelative(this.mReferenceDevPath) || !((Device)e.getDbObject()).isPin()) continue;
            DevicePath devPath = e.getPath().getRelativePathFromAnchor(this.mContactLayer.getOwner());
            devPath.add((Device)e.getDbObject());
            this.mSelectedPinDevs.add(devPath);
        }
        ALog.logInfo((String)"Generate contact pins for %d selected pin devices on %s", (Object[])new Object[]{this.mSelectedPinDevs.size(), this.mReferenceDevPath});
    }

    private Term getReferenceTerm(PinMapCsvReader.CsvPinMap csvPinMap, HierInst<PinTemplate> hierRefPin) {
        String csvRefTermName;
        Net topNet;
        Set topNets;
        PinTemplate referencePin = (PinTemplate)hierRefPin.getSecond();
        DevicePath referencePinPath = hierRefPin.getPath();
        PinLabel pinLabel = PinLabel.get((DevicePath)referencePinPath, (PinTemplate)referencePin, (boolean)false);
        Term referenceTerm = null;
        if (pinLabel != null) {
            referenceTerm = pinLabel.getTerm();
        }
        if (referenceTerm == null && (topNets = TermMap.getTopMostNet((Net)referencePin.getNet(), (DevicePath)referencePinPath)).size() == 1 && (topNet = (Net)topNets.iterator().next()).getDeviceTemplate() == referencePinPath.getRoot() && topNet.getTermsCount() == 1) {
            referenceTerm = (Term)topNet.getTerms().next();
        }
        if ((csvRefTermName = this.getCsvReferenceTermName(csvPinMap)) != null && !csvRefTermName.isEmpty() && referenceTerm != null && !referenceTerm.getName().equals(csvRefTermName)) {
            ALog.flogError((String)"Reference pin '%s:%s' is on term '%s', but defined on term '%s' in the config file.", (Object[])new Object[]{referencePinPath.toString(), referencePin.getName(), referenceTerm.getName(), csvRefTermName});
        }
        return referenceTerm;
    }

    private Net getReferenceNet(PinMapCsvReader.CsvPinMap csvPinMap, HierInst<PinTemplate> hierRefPin) {
        String csvReferenceNetName;
        PinTemplate referencePin = (PinTemplate)hierRefPin.getSecond();
        DevicePath referencePinPath = hierRefPin.getPath();
        Net currentNet = NetMap.getTopmostNet((Net)referencePin.getNet(), (DevicePath)referencePinPath);
        if (currentNet == null || currentNet.getDeviceTemplate() != referencePinPath.getRoot()) {
            currentNet = this.getRefDevT().getNetUnused();
        }
        if ((csvReferenceNetName = this.getCsvReferenceNetName(csvPinMap)) != null && !csvReferenceNetName.isEmpty() && !currentNet.getName().equals(csvReferenceNetName)) {
            ALog.flogError((String)"Reference pin '%s:%s' is on net '%s', but defined on net '%s' in the config file.", (Object[])new Object[]{referencePinPath.toString(), referencePin.getName(), currentNet.getName(), csvReferenceNetName});
        }
        return currentNet;
    }

    private String getCsvReferenceTermName(PinMapCsvReader.CsvPinMap csvPinMap) {
        if (csvPinMap == null) {
            return null;
        }
        if (this.mIsCreateOnDevPathA) {
            return csvPinMap.getTermB();
        }
        return csvPinMap.getTermA();
    }

    private String getCsvReferenceNetName(PinMapCsvReader.CsvPinMap csvPinMap) {
        if (csvPinMap == null) {
            return null;
        }
        if (this.mIsCreateOnDevPathA) {
            return csvPinMap.getNetB();
        }
        return csvPinMap.getNetA();
    }

    private String getContactPinName(PinMapCsvReader.CsvPinMap csvPinMap, HierInst<PinTemplate> hierPin) {
        String csvContactPinName = this.getCsvContactPinName(csvPinMap);
        if (csvContactPinName != null && !csvContactPinName.isEmpty()) {
            return csvContactPinName;
        }
        DevicePath pinPath = hierPin.getPath();
        PinTemplate pinT = (PinTemplate)hierPin.getSecond();
        return pinPath.getDeviceTemplate().amIAPin() ? pinPath.getDevice().getName() : pinT.getName();
    }

    private String getCsvContactPinName(PinMapCsvReader.CsvPinMap csvPinMap) {
        if (csvPinMap == null) {
            return null;
        }
        if (this.mIsCreateOnDevPathA) {
            return csvPinMap.getPinA();
        }
        return csvPinMap.getPinB();
    }

    private Term getContactTerm(PinMapCsvReader.CsvPinMap csvPinMap, Term referenceTerm, Net referenceNet) {
        assert (referenceNet != null);
        APair<Boolean, Term> termInfo = this.getOrCreateContactTerm(csvPinMap);
        if (termInfo == null && referenceTerm != null) {
            termInfo = this.getOrCreateContactTerm(referenceTerm);
        } else if (termInfo == null && !referenceNet.isNC()) {
            termInfo = this.getOrCreateContactTerm(referenceNet);
        }
        if (termInfo == null) {
            return null;
        }
        boolean isCreate = (Boolean)termInfo.getFirst();
        Term term = (Term)termInfo.getSecond();
        if (isCreate) {
            if (referenceTerm != null) {
                term.setUse(referenceTerm.getUse());
            }
            term.getNet().setUse(referenceNet.getUse());
        }
        return term;
    }

    private APair<Boolean, Term> getOrCreateContactTerm(PinMapCsvReader.CsvPinMap csvPinMap) {
        if (csvPinMap == null) {
            return null;
        }
        String csvContactTermName = this.getCsvContactTermName(csvPinMap);
        String csvContactNetName = this.getCsvContactNetName(csvPinMap);
        if (!ContactDeviceFactory.isNullOrEmptyString(csvContactTermName) && ContactDeviceFactory.isNullOrEmptyString(csvContactNetName)) {
            csvContactNetName = csvContactTermName;
        } else if (ContactDeviceFactory.isNullOrEmptyString(csvContactTermName) && !ContactDeviceFactory.isNullOrEmptyString(csvContactNetName)) {
            csvContactTermName = csvContactNetName;
        } else if (ContactDeviceFactory.isNullOrEmptyString(csvContactTermName) && ContactDeviceFactory.isNullOrEmptyString(csvContactNetName)) {
            return null;
        }
        return this.getOrCreateContactTerm(csvContactTermName, csvContactNetName);
    }

    private APair<Boolean, Term> getOrCreateContactTerm(Term referenceTerm) {
        Term connectedContactTerm = this.getConnectedContactTerm(referenceTerm);
        if (connectedContactTerm != null) {
            return APair.create((Object)false, (Object)connectedContactTerm);
        }
        String contactTermName = this.mContactPinPrefix + referenceTerm.getName();
        return this.getOrCreateContactTerm(contactTermName);
    }

    private APair<Boolean, Term> getOrCreateContactTerm(Net referenceNet) {
        Net contactNet = this.getOrCreateContactNet(referenceNet);
        boolean isCreate = false;
        Term term = Term.get((DeviceTemplate)this.mContactDevT, (String)contactNet.getName());
        if (term == null) {
            term = Term.create((Net)contactNet);
            isCreate = true;
        }
        return APair.create((Object)isCreate, (Object)term);
    }

    private String getCsvContactTermName(PinMapCsvReader.CsvPinMap csvPinMap) {
        if (csvPinMap == null) {
            return null;
        }
        if (this.mIsCreateOnDevPathA) {
            return csvPinMap.getTermA();
        }
        return csvPinMap.getTermB();
    }

    private String getCsvContactNetName(PinMapCsvReader.CsvPinMap csvPinMap) {
        if (csvPinMap == null) {
            return null;
        }
        if (this.mIsCreateOnDevPathA) {
            return csvPinMap.getNetA();
        }
        return csvPinMap.getNetB();
    }

    private APair<Boolean, Term> getOrCreateContactTerm(String contactTermName) {
        return this.getOrCreateContactTerm(contactTermName, contactTermName);
    }

    private APair<Boolean, Term> getOrCreateContactTerm(String contactTermName, String contactNetName) {
        Term contactTerm = this.mContactDevT.getTerm(contactTermName);
        if (contactTerm != null) {
            return APair.create((Object)false, (Object)contactTerm);
        }
        Net contactNet = Net.getOrCreate((DeviceTemplate)this.mContactDevT, (String)contactNetName);
        contactTerm = Term.create((String)contactTermName, (Net)contactNet);
        if (this.mCreateConatctDev) {
            Net parentNet = ContactDeviceFactory.getOrCreateNet(this.mContactDev.getParent(), contactNetName);
            parentNet.copyAttributeTo(contactNet);
            contactTerm.syncAttribute(contactNet);
            TermMap.mapChildTerm((Device)this.mContactDev, (Term)contactTerm, (Net)parentNet);
        }
        return APair.create((Object)true, (Object)contactTerm);
    }

    private Net getOrCreateContactNet(String contactNetName) {
        Net contactNet = this.mContactDevT.getNet(contactNetName);
        if (contactNet != null) {
            return contactNet;
        }
        contactNet = this.mContactDevT.createNet(contactNetName);
        if (this.mCreateConatctDev) {
            Net parentNet = ContactDeviceFactory.getOrCreateNet(this.mContactDev.getParent(), contactNetName);
            parentNet.copyAttributeTo(contactNet);
            NetMap.mapChildNet((Device)this.mContactDev, (Net)contactNet, (Net)parentNet);
            return contactNet;
        }
        return contactNet;
    }

    private Net getOrCreateContactNet(Net referenceNet) {
        assert (referenceNet != null && !referenceNet.isNC());
        Net connectedContactNet = this.getConnectedContactNet(referenceNet);
        if (connectedContactNet == null) {
            String contactNetName = this.mContactPinPrefix + referenceNet.getName();
            return this.getOrCreateContactNet(contactNetName);
        }
        if (this.mCreateConatctDev && connectedContactNet.getDeviceTemplate() != this.mContactDevT) {
            return this.getOrCreateContactNet(connectedContactNet.getName());
        }
        return connectedContactNet;
    }

    private Term getConnectedContactTerm(Term referenceTerm) {
        Set rootNets = TermMap.getTopMostNet((Term)referenceTerm, (DevicePath)this.mReferenceDevPath);
        Net rootNet = (Net)AUtil.getIffOne((Collection)rootNets);
        if (rootNet == null || rootNet.getDeviceTemplate() != this.mReferenceDevPath.getRoot()) {
            return null;
        }
        IterableIterator rootTermItr = rootNet.getTerms();
        if (this.mContactDevPath.isEmpty()) {
            if (rootTermItr.hasNext()) {
                return (Term)AUtil.getIffOne((Iterator)rootTermItr);
            }
            return Term.create((Net)rootNet);
        }
        IterableIterator termsOnContactDev = TermMap.getDescendantTermsAtDevice((Net)rootNet, (DevicePath)this.mContactDevPath);
        if (this.mCreateConatctDev && !termsOnContactDev.hasNext()) {
            Net netOnContactParent = null;
            String newTermName = null;
            if (this.mContactDevPath.size() == 1) {
                if (rootTermItr.hasNext()) {
                    Term t = (Term)AUtil.getIffOne((Iterator)rootTermItr);
                    if (t != null) {
                        newTermName = t.getName();
                        netOnContactParent = t.getNet();
                    }
                } else {
                    netOnContactParent = rootNet;
                    newTermName = netOnContactParent.getName();
                }
            } else {
                IterableIterator termOnContactParentItr = TermMap.getDescendantTermsAtDevice((Net)rootNet, (DevicePath)this.mContactDevPath.getParent());
                Term t = (Term)AUtil.getIffOne((Iterator)termOnContactParentItr);
                if (t != null) {
                    newTermName = t.getName();
                    netOnContactParent = t.getNet();
                }
            }
            if (newTermName != null) {
                Term term = Term.get((DeviceTemplate)this.mContactDevT, (String)newTermName);
                if (term == null) {
                    Net termNet = Net.get((DeviceTemplate)this.mContactDevT, (String)newTermName);
                    if (termNet == null) {
                        termNet = Net.create((DeviceTemplate)this.mContactDevT, (String)newTermName);
                        netOnContactParent.copyAttributeTo(termNet);
                    }
                    term = Term.create((Net)termNet);
                }
                TermMap.mapChildTerm((Device)this.mContactDev, (Term)term, (Net)netOnContactParent);
                return term;
            }
        }
        return termsOnContactDev.hasNext() ? (Term)termsOnContactDev.next() : null;
    }

    private Net getConnectedContactNet(Net referenceNet) {
        Net rootNet = NetMap.getTopmostNet((Net)referenceNet, (DevicePath)this.mReferenceDevPath);
        if (rootNet == null || rootNet.isNC() || rootNet.getDeviceTemplate() != this.mReferenceDevPath.getRoot()) {
            return null;
        }
        if (this.mContactDevPath.isEmpty()) {
            return rootNet;
        }
        HierInst startNet = HierInst.create((DevicePath)new DevicePath(this.mReferenceDevPath.getRoot()), (DbObject)rootNet);
        HierInst netOnContactDev = NetMap.getNetOnDevice((HierInst)startNet, (DevicePath)this.mContactDevPath);
        if (this.mCreateConatctDev && netOnContactDev == null) {
            netOnContactDev = NetMap.getNetOnDevice((HierInst)startNet, (DevicePath)this.mContactDevPath.getParent());
        }
        return netOnContactDev == null ? null : (Net)netOnContactDev.getDbObject();
    }

    private APoint2D getLocInContactDev(APoint2D locInReferenceDev) {
        return locInReferenceDev.transform(this.getTransformRefDev2ContactDev());
    }

    private AffineTransform getTransformRefDev2ContactDev() {
        if (this.mTransfromRef2ContactDev == null) {
            this.mTransfromRef2ContactDev = this.mContactDevPath.getInverseTransform();
            AffineTransform toRefDev = this.mReferenceDevPath.getTransform();
            this.mTransfromRef2ContactDev.concatenate(toRefDev);
        }
        return this.mTransfromRef2ContactDev;
    }

    private PadTemplate getContactPadTemplate(PortTemplate referencePort) {
        if (this.mContactPadT == null) {
            PadTemplate contactPadT = this.padT2ContactPadT.get(referencePort.getPadTemplate());
            if (contactPadT == null) {
                contactPadT = this.createContactPadT(referencePort);
                this.padT2ContactPadT.put(referencePort.getPadTemplate(), contactPadT);
            }
            return contactPadT;
        }
        return this.mContactPadT;
    }

    private DeviceTemplate getContactPinDevT(PortTemplate referencePort) {
        if (this.mContactPinDevT == null) {
            DeviceTemplate contactPinDevT = this.padT2ContactPinDevT.get(referencePort.getPadTemplate());
            if (contactPinDevT == null) {
                PadTemplate contactPadT = this.createContactPadT(referencePort);
                contactPinDevT = DeviceTemplate.create((Substrate)contactPadT.getSubstrate(), (String)"ContactPinDev", (boolean)true);
                contactPinDevT.setType(DeviceTemplate.Type.BUMP);
                contactPinDevT.setBounds((AGeom)contactPadT.getBB(null));
                Net net = Net.create((DeviceTemplate)contactPinDevT, (String)"pin");
                PinTemplate pinT = PinTemplate.create((Net)net, (String)"pin", (PadTemplate)contactPadT, (long)0L, (long)0L);
                pinT.setType(PinTemplate.Type.BUMPPAD);
                this.padT2ContactPinDevT.put(referencePort.getPadTemplate(), contactPinDevT);
            }
            return contactPinDevT;
        }
        return this.mContactPinDevT;
    }

    private PadTemplate createContactPadT(PortTemplate referencePort) {
        PadTemplate contactPadT = PadTemplate.create((Db)this.mDb, (Substrate)this.mContactPinLayer.getSubstrate(), (String)"ContactPad");
        IterableIterator geoms = referencePort.getLayerShapesOnLayer(this.mReferenceLayer).mapAndNonNull(LayerShape::getGeom);
        for (AGeom geom : geoms) {
            LayerShape.create((Layer)this.mContactPinLayer, (DbObject)contactPadT, (AGeom)geom);
        }
        return contactPadT;
    }

    private void updateContactLayer() {
        if (this.mContactLayer != null && this.mContactLayer.getDb() != null && (this.mInferDeviceHierarchy || this.mCreateConatctDev)) {
            this.mContactLayer.deleteFromDb();
        }
        if (this.mContactLayer == null || this.mContactLayer.getDb() == null) {
            this.mContactLayer = this.mIsCreateOnDevPathA ? ContactLayer.create((DevicePath)this.mContactDevPath, (Layer)this.mContactPinLayer, (DevicePath)this.mReferenceDevPath, (Layer)this.mReferenceLayer) : ContactLayer.create((DevicePath)this.mReferenceDevPath, (Layer)this.mReferenceLayer, (DevicePath)this.mContactDevPath, (Layer)this.mContactPinLayer);
        }
    }

    private void generatePinMap() {
        PinMapGenerator pinMapGenerator = new PinMapGenerator(this.mDb);
        pinMapGenerator.createFromPinPhysicalContact(this.mContactLayer);
    }

    private void generateContactDeviceScribe() {
        if (this.mScribeInfo == null) {
            return;
        }
        this.mScribeInfo.createScribe(this.mContactDevT);
    }

    private void inferDeviceHierarchy() {
        if (!this.mInferDeviceHierarchy || this.mReferenceDevPath.getParent().equals((Object)this.mContactDevPath)) {
            return;
        }
        APoint2D worldLoc = this.getRefDev().getWorldLoc(this.mReferenceDevPath);
        float worldRot = this.getRefDev().getWorldRotation(this.mReferenceDevPath);
        boolean worldMirror = this.getRefDev().getWorldMirror(this.mReferenceDevPath);
        HashMap<Net, Net> refNet2ContactNet = new HashMap<Net, Net>();
        for (Net net : this.getRefDevT().getNets()) {
            Net connectedContactNet = this.getConnectedContactNet(net);
            if (connectedContactNet == null || connectedContactNet.getDeviceTemplate() != this.mContactDevT) continue;
            refNet2ContactNet.put(net, connectedContactNet);
        }
        this.getRefDev().setParent(this.mContactDev, false);
        this.mReferenceDevPath = new DevicePath(this.mContactDevPath, this.getRefDev());
        Device.setPos((DevicePath)this.mReferenceDevPath, (APoint2D)worldLoc, (float)worldRot, (boolean)worldMirror);
        if (!this.mContactDev.getName().equals(this.getRefDev().getName())) {
            String contactDevName = Device.getUniqueName((DeviceTemplate)this.mContactDev.getParent(), (String)this.getRefDev().getName());
            this.mContactDev.setName(contactDevName);
        }
        for (Map.Entry entry : refNet2ContactNet.entrySet()) {
            Net refNet = (Net)entry.getKey();
            Net contactNet = (Net)entry.getValue();
            if (refNet == null || contactNet == null) continue;
            NetMap.mapChildNet((Device)this.getRefDev(), (Net)refNet, (Net)contactNet);
        }
    }

    private void inferNetMap() {
        if (!this.mInfereNetMap) {
            return;
        }
        NetMapGenerator netMapGenerator = new NetMapGenerator(this.mDb);
        netMapGenerator.addContactLayer(this.mContactLayer);
        netMapGenerator.createNetMapFromPinMap();
    }

    private DeviceTemplate getRefDevT() {
        return this.mReferenceDevPath.getDeviceTemplate();
    }

    private Device getRefDev() {
        return this.mReferenceDevPath.getDevice();
    }

    private static boolean isNullOrEmptyString(String string) {
        return string == null || string.isEmpty();
    }

    private static Net getOrCreateNet(DeviceTemplate devT, String netName) {
        if (ContactDeviceFactory.isNullOrEmptyString(netName)) {
            assert (false);
            return null;
        }
        Net net = devT.getNet(netName);
        if (net == null) {
            net = devT.createNet(netName);
        }
        return net;
    }

    private class ScribeInfo {
        protected long mNorth;
        protected long mSouth;
        protected long mEast;
        protected long mWest;

        public ScribeInfo(long northVal, long southVal, long eastVal, long westVal) {
            this.mNorth = northVal;
            this.mSouth = southVal;
            this.mEast = eastVal;
            this.mWest = westVal;
        }

        public void createScribe(DeviceTemplate dt) {
            Scribe.create((DeviceTemplate)dt, (long)this.mNorth, (long)this.mSouth, (long)this.mEast, (long)this.mWest);
        }
    }
}

