/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.factory;

import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.ATransformUtil;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.MutableBoolean;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbClass;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.LayerShape;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.PortTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.geom.ACircle;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.APolygon;
import com.sigrity.acl.geom.ARect;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierPort;
import com.sigrity.orbit.OrbitIO;
import java.awt.geom.AffineTransform;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class ContactPadFactory {
    public static final String FldName_FromDevice = String.format("%s.%s", ContactPadFactory.class.getName(), "FromDevice");
    public static final String FldName_FromDeviceType = String.format("%s.%s", ContactPadFactory.class.getName(), "FromDeviceType");
    protected DevicePath fromPath;
    protected String padTemplateAdoptContext;
    protected PadTemplate padTemplateToUse = null;
    protected DevicePath toPath;
    protected Device recievingDevice;
    protected Layer fromLayer;
    protected Layer toLayer;
    protected AGeom contactGeom;
    protected DeviceTemplate contactTemplate;
    protected HashSet<String> unmappedNet = new HashSet();

    public void setPadTemplateToUse(String name) {
        this.padTemplateToUse = PadTemplate.get((Db)OrbitIO.getCurDb(), (Substrate)this.fromPath.getSubstrate(), (String)name);
    }

    public DevicePath getFromPath() {
        return this.fromPath;
    }

    public void setFromPath(DevicePath fromPath) {
        this.fromPath = fromPath;
    }

    public void setFromPath(String path) {
        this.fromPath = DevicePath.fromEscapedString((Db)OrbitIO.getCurDb(), (String)path);
    }

    public DevicePath getToPath() {
        return this.toPath;
    }

    public void setToPath(DevicePath toPath) {
        this.toPath = toPath;
    }

    public void setToPath(String path) {
        this.toPath = DevicePath.fromEscapedString((Db)OrbitIO.getCurDb(), (String)path);
    }

    public Layer getFromLayer() {
        return this.fromLayer;
    }

    public void setFromLayer(Layer fromLayer) {
        this.fromLayer = fromLayer;
    }

    public void setFromLayer(String layer) {
        this.fromLayer = this.fromPath.getSubstrate().getLayer(layer);
    }

    public Layer getToLayer() {
        return this.toLayer;
    }

    public void setToLayer(Layer toLayer) {
        this.toLayer = toLayer;
    }

    public void setToLayer(String layer) {
        this.toLayer = this.toPath.getSubstrate().getLayer(layer);
    }

    public AGeom getContactGeom() {
        return this.contactGeom;
    }

    public void setContactGeom(AGeom contactGeom) {
        this.contactGeom = contactGeom;
    }

    public DeviceTemplate getContactTemplate() {
        return this.contactTemplate;
    }

    public void setContactTemplate(DeviceTemplate contactTemplate) {
        this.contactTemplate = contactTemplate;
    }

    protected String makeAContactDeviceName() {
        return "Contact-" + this.fromPath.getLast().getName();
    }

    protected Device getReceivingDevice() {
        Device d = Device.get((Db)this.toPath.getDb(), (String)this.makeAContactDeviceName(), (DeviceTemplate)this.toPath.getDeviceTemplate());
        return d;
    }

    protected void makeAContactDevice() {
        Substrate s = this.toPath.getLast().getSubstrate();
        Device fromDevice = this.fromPath.getLast();
        DeviceTemplate parent = fromDevice.getTemplate();
        ARect bounds = parent.getBB();
        DevicePath relPath = this.fromPath.getRelativePath(this.toPath.getDeviceTemplate());
        relPath.removeFirst();
        if (relPath.getMirror()) {
            AffineTransform t = new AffineTransform();
            t.scale(-1.0, 1.0);
            bounds = bounds.transform(t).getBounds();
        }
        DeviceTemplate dt = DeviceTemplate.create((Substrate)s, (String)this.makeAContactDeviceName(), (boolean)false);
        dt.setBounds((AGeom)bounds);
        dt.setType(DeviceTemplate.Type.CONTACT_DEVICE);
        dt.setIsSynthesized(true);
        DbClass dbcDevT = dt.getDb().getDbClass(DeviceTemplate.class);
        if (dbcDevT.getField(FldName_FromDevice) == null) {
            dbcDevT.addSoftField(FldName_FromDevice, Device.class);
        }
        dt.setValue(FldName_FromDevice, (Object)fromDevice);
        if (dbcDevT.getField(FldName_FromDeviceType) == null) {
            dbcDevT.addSoftField(FldName_FromDeviceType, DeviceTemplate.Type.class);
        }
        dt.setValue(FldName_FromDeviceType, (Object)fromDevice.getTemplate().getType());
        this.recievingDevice = Device.create((Db)s.getDb(), (String)this.makeAContactDeviceName(), (DeviceTemplate)dt, (DeviceTemplate)this.toPath.getDeviceTemplate());
        this.recievingDevice.moveTo(0L, 0L);
        this.recievingDevice.setRotate(relPath.getRot());
        APoint2D parentPos = this.fromPath.getBB().center();
        DevicePath path = new DevicePath(this.toPath);
        AffineTransform t = path.getTransform();
        AffineTransform tI = ATransformUtil.inverse((AffineTransform)t);
        APoint2D p = new APoint2D(parentPos);
        APoint2D o = p.transform(tI);
        this.recievingDevice.putCenterAt(o);
    }

    public static APair<LinkedList<HierPort>, LinkedList<HierPort>> getPotentialContactPins(DevicePath path) {
        LinkedList<HierPort> contactPorts = new LinkedList<HierPort>();
        LinkedList<HierPort> selectedPorts = new LinkedList<HierPort>();
        Db db = path.getDb();
        Selection s = Selection.getCurrentSelectionForDb((Db)db);
        DeviceTemplate.Type type = path.getDeviceTemplate().getType();
        for (DevicePath dp : path.getDescendants()) {
            if (!dp.getSubstrate().equals((Object)path.getSubstrate())) continue;
            for (PinInstance pi : dp.getLast().getPins()) {
                PinTemplate pit = pi.getPinTemplate();
                if ((type != DeviceTemplate.Type.DIE || pit.getType() != PinTemplate.Type.BUMPPAD && pit.getDeviceTemplate().getType() != DeviceTemplate.Type.BUMP) && (type != DeviceTemplate.Type.PACKAGE || pit.getType() != PinTemplate.Type.BALLPAD)) continue;
                for (PortTemplate pt : pit.getPortTemplates()) {
                    HierPort hp = new HierPort(dp, pt);
                    contactPorts.add(hp);
                    if (!s.contains(dp, (DbObject)pi)) continue;
                    selectedPorts.add(hp);
                }
            }
        }
        return new APair(contactPorts, selectedPorts);
    }

    public void removeInstantiatedContactPads(boolean justSelected) {
        APair<LinkedList<HierPort>, LinkedList<HierPort>> cps = ContactPadFactory.getPotentialContactPins(this.fromPath);
        HashSet list = new HashSet();
        if (justSelected) {
            list.addAll((Collection)cps.second);
        } else {
            list.addAll((Collection)cps.first);
        }
        for (HierPort hp : list) {
            DevicePath relativePath = ((DevicePath)hp.first).getRelativePathFromAnchor(this.toPath.getDeviceTemplate());
            hp.first = relativePath;
        }
        for (PinTemplate candidateContactPad : AUtil.linkedList((Iterator)this.toPath.getDeviceTemplate().getPins())) {
            Optional connected = candidateContactPad.getConnectedPin();
            if (!connected.isPresent()) continue;
            DevicePath connectedPath = ((DeviceTemplate.DescendantPin)connected.get()).getDevicePath();
            PinTemplate connectedPin = (PinTemplate)((DeviceTemplate.DescendantPin)connected.get()).second;
            for (HierPort candidate : list) {
                if (!candidate.getPath().equals((Object)connectedPath) || !candidate.getDPort().getPinTemplate().equals(connectedPin)) continue;
                candidateContactPad.deleteFromDb();
            }
        }
    }

    protected void removeInstantiatedContactPads() {
        this.removeInstantiatedContactPads(false);
    }

    public void removeCurrentContactDevice() {
        Device current = this.getReceivingDevice();
        if (current != null) {
            DeviceTemplate dt = current.getTemplate();
            current.deleteFromDb();
            dt.deleteFromDb();
        }
    }

    protected boolean validateData() {
        if (this.fromPath == null) {
            ALog.logWarn((String)"The from path is not valid");
            return false;
        }
        if (this.toPath == null) {
            ALog.logWarn((String)"The to path is not valid");
            return false;
        }
        if (this.fromLayer == null) {
            ALog.logWarn((String)"The from layer is not valid");
            return false;
        }
        if (this.toLayer == null) {
            ALog.logWarn((String)"The to layer is not valid");
            return false;
        }
        return true;
    }

    public void makePadsForBumps() {
        this.makePadsForBumps(false);
    }

    public void makePadsForBumps(boolean justSelected) {
        if (!this.validateData()) {
            return;
        }
        this.padTemplateAdoptContext = ContactPadFactory.class.getName() + this.fromPath.getLast();
        this.removeCurrentContactDevice();
        this.removeInstantiatedContactPads(justSelected);
        this.recievingDevice = this.toPath.getDeviceTemplate().getAnInstance();
        APair<LinkedList<HierPort>, LinkedList<HierPort>> pads = ContactPadFactory.getPotentialContactPins(this.fromPath);
        LinkedList list = justSelected ? (LinkedList)pads.second : (LinkedList)pads.first;
        int count = 0;
        Collections.sort(list);
        for (HierPort hp : list) {
            if (!this.makeAContactPadFor(hp, count)) continue;
            ++count;
        }
        ALog.logInfo((String)"%d contact pads created on '%s'", (Object[])new Object[]{count, this.recievingDevice.getName()});
        if (!this.unmappedNet.isEmpty()) {
            StringBuilder detail = new StringBuilder();
            detail.append(this.unmappedNet.stream().limit(20L).collect(Collectors.joining(", ")));
            if (this.unmappedNet.size() > 20) {
                detail.append("...");
            }
            ALog.logWarn((String)"There are %d nets that are not mapped to '%s'. Unmapped Net: %s", (Object[])new Object[]{this.unmappedNet.size(), this.toPath.getDeviceTemplate().getName(), detail});
        }
        PadTemplate.releaseAdoptContext((Db)this.fromPath.getDb(), (String)this.padTemplateAdoptContext);
    }

    protected AGeom getContactGeom(HierPort hp) {
        if (this.contactGeom != null) {
            return this.contactGeom;
        }
        for (AGeom g : ((PortTemplate)hp.second).getGeometriesOnLayer(this.toLayer)) {
            if (g instanceof ARect) {
                ARect rCopy = ((ARect)g).copy();
                rCopy.moveCenterTo(0L, 0L);
                return rCopy;
            }
            if (g instanceof ACircle) {
                return g.copy();
            }
            if (!(g instanceof APolygon)) continue;
            APolygon pCopy = ((APolygon)g).copy();
            pCopy.moveCenterTo(new APoint2D(0L, 0L));
            return pCopy;
        }
        for (AGeom g : ((PortTemplate)hp.second).getGeometriesOnLayer(null)) {
            if (g instanceof ARect) {
                ARect rCopy = ((ARect)g).copy();
                rCopy.moveCenterTo(0L, 0L);
                return rCopy;
            }
            if (g instanceof ACircle) {
                return g.copy();
            }
            if (!(g instanceof APolygon)) continue;
            APolygon pCopy = ((APolygon)g).copy();
            pCopy.moveCenterTo(new APoint2D(0L, 0L));
            return pCopy;
        }
        return null;
    }

    LinkedList<LayerShape> getLayerShapesFor(HierPort from, Layer fromLayer, Layer toLayer) {
        Db db = from.getDb();
        DbClass dbClass = db.getDbClass("LayerShape");
        LinkedList<LayerShape> layerShapes = new LinkedList<LayerShape>();
        for (LayerShape ls : ((PortTemplate)from.second).getPadTemplate().getLayerShapes(fromLayer)) {
            LayerShape lsCopy = (LayerShape)dbClass.createInstance();
            lsCopy.setGeom(ls.getGeom().transform(from.getPathTransform()));
            lsCopy.setLayer(toLayer);
            layerShapes.add(lsCopy);
        }
        APoint2D pathFromLoc = from.getPath().getLoc();
        AffineTransform aT1 = new AffineTransform();
        aT1.translate(pathFromLoc.getX(), pathFromLoc.getY());
        aT1 = ATransformUtil.inverse((AffineTransform)aT1);
        for (LayerShape ls1 : layerShapes) {
            ls1.setGeom(ls1.getGeom().transform(aT1));
        }
        return layerShapes;
    }

    protected boolean makeAContactPadFor(HierPort from, int i) {
        Db db = from.getDb();
        LinkedList<Object> layerShapes = new LinkedList();
        DbClass dbClass = db.getDbClass("LayerShape");
        if (this.contactGeom != null) {
            LayerShape ls = (LayerShape)dbClass.createInstance();
            ls.setGeom(this.contactGeom);
            ls.setLayer(this.toLayer);
            layerShapes.add(ls);
        } else {
            layerShapes = this.getLayerShapesFor(from, this.fromLayer, this.toLayer);
        }
        PortTemplate fromPort = (PortTemplate)from.second;
        Net topNet = NetMap.getNetAt((Net)fromPort.getPinTemplate().getNet(), (DevicePath)from.getPath(), (DeviceTemplate)this.recievingDevice.getTemplate());
        if (!topNet.getDeviceTemplate().equals(this.recievingDevice.getTemplate())) {
            DeviceTemplate fromSubstrateTemplate = ((DevicePath)from.first).getSubstrateDeviceTemplate();
            if (!topNet.isUnused() && topNet.getDeviceTemplate().equals(fromSubstrateTemplate)) {
                Net currentTopNet = topNet;
                topNet = this.recievingDevice.getTemplate().getNet(topNet.getName());
                if (topNet == null) {
                    DevicePath fromPath = new DevicePath((DevicePath)from.first);
                    Device fromDevice = null;
                    Object toDeviceTemplate = null;
                    while (!fromPath.isEmpty()) {
                        if (fromPath.getDeviceTemplate() == fromSubstrateTemplate) {
                            fromDevice = fromPath.getLast();
                            toDeviceTemplate = fromPath.getParent().getDeviceTemplate();
                            break;
                        }
                        fromPath.removeLast();
                    }
                    if (fromDevice != null && toDeviceTemplate.equals(this.recievingDevice.getTemplate())) {
                        topNet = Net.create((DeviceTemplate)this.recievingDevice.getTemplate(), (String)currentTopNet.getName());
                        NetMap.mapUpTo((DevicePath)fromPath, (Net)currentTopNet, (Net)topNet);
                        this.unmappedNet.add(topNet.getName());
                    }
                } else {
                    this.unmappedNet.add(topNet.getName());
                }
            } else {
                this.unmappedNet.add(topNet.getName());
                topNet = this.recievingDevice.getTemplate().getNetUnused();
            }
        }
        MutableBoolean created = new MutableBoolean();
        PadTemplate pt = null;
        if (this.padTemplateToUse == null) {
            Objects.requireNonNull(topNet);
            pt = PadTemplate.getEquiv((Db)db, (String)this.padTemplateAdoptContext, (Substrate)topNet.getSubstrate(), layerShapes, (String)("Bump-Contact-" + this.fromPath.getLast().getName()), (MutableBoolean)created);
        } else {
            pt = this.padTemplateToUse;
        }
        String pinName = "cp" + i;
        PinTemplate dtp = PinTemplate.create((Net)topNet, (String)pinName);
        dtp.setPadTemplate(pt);
        dtp.setType(PinTemplate.Type.CONTACT);
        dtp.setIsSynthesized(true);
        APoint2D fromLoc = from.getWorldLoc();
        APoint2D p = new APoint2D(fromLoc);
        AffineTransform aT = this.toPath.getInverseTransform();
        APoint2D pPrime = p.transform(aT);
        dtp.setLoc(pPrime);
        PinInstance createdPinInstance = PinInstance.create((Db)db, (String)pinName, (Device)this.recievingDevice, (PinTemplate)dtp);
        PinInstance fromPinInstance = from.getPin();
        DevicePath relPath = from.getPath().getRelativePathFromAnchor(createdPinInstance.getDeviceTemplate());
        if (relPath != null) {
            dtp.setConnectedPin(relPath, fromPinInstance.getPinTemplate());
        }
        return true;
    }
}

