/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.factory;

import com.sigrity.acl.AUtil;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.ContactLayer;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.PinMap;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.util.OrbitValidator;
import java.awt.geom.AffineTransform;
import java.util.Iterator;

public class ContactsRemover {
    private Db mDb;
    private ContactLayer mContactLayer;
    private boolean mIsDeleteDevPathA;
    private DevicePath mDeleteDevPath;

    public ContactsRemover(Db db, String contactLayerKeyStr, boolean isDeleteDevPathA) {
        this(db, (ContactLayer)db.getByKeyStr(ContactLayer.class, contactLayerKeyStr), isDeleteDevPathA);
    }

    public ContactsRemover(Db db, ContactLayer contactLayer, boolean isDeleteDevPathA) {
        this.mDb = db;
        this.mContactLayer = contactLayer;
        this.mIsDeleteDevPathA = isDeleteDevPathA;
        this.mDeleteDevPath = isDeleteDevPathA ? contactLayer.getDevicePathA() : contactLayer.getDevicePathB();
    }

    public void deleteContactPins() {
        for (PinMap pinMap : AUtil.arrayList((Iterator)PinMap.get((ContactLayer)this.mContactLayer))) {
            if (!pinMap.isValid()) continue;
            if (this.mIsDeleteDevPathA) {
                this.deletePin(pinMap.getPinAPath(), pinMap.getPinA());
                continue;
            }
            this.deletePin(pinMap.getPinBPath(), pinMap.getPinB());
        }
        PinMap.deleteInvalid((Db)this.mDb);
    }

    private void deletePin(DevicePath pinPath, PinTemplate pin) {
        assert (OrbitValidator.validateHierInst((DevicePath)pinPath, (DbObject)pin));
        if (pinPath != null && pinPath.isValid() && pinPath.isPin()) {
            pinPath.getDevice().deleteFromDb();
        } else {
            pin.deleteFromDb();
        }
    }

    public void deleteContactDevice() {
        this.updateDesign();
        this.deleteDevice();
    }

    private void updateDesign() {
        this.mContactLayer.getContactFullPaths().stream().forEach(fullPaths -> this.updateDesign((DevicePath)fullPaths.getFirst(), (DevicePath)fullPaths.getSecond()));
        this.mContactLayer.deleteFromDb();
    }

    private void updateDesign(DevicePath devPathA, DevicePath devPathB) {
        DevicePath parentSubstratePath;
        boolean createNewContactLayer = false;
        if (this.mIsDeleteDevPathA) {
            DevicePath parentDevPathA = devPathA.getParent();
            parentSubstratePath = parentDevPathA.pathToSubstrate();
            if (parentSubstratePath != null && parentSubstratePath.equals((Object)devPathA.pathToSubstrate())) {
                createNewContactLayer = true;
            }
            devPathA = parentDevPathA;
        } else {
            DevicePath parentDevPathB = devPathB.getParent();
            parentSubstratePath = parentDevPathB.pathToSubstrate();
            if (parentSubstratePath != null && parentSubstratePath.equals((Object)devPathB.pathToSubstrate())) {
                createNewContactLayer = true;
            }
            devPathB = parentDevPathB;
        }
        if (!this.mIsDeleteDevPathA && devPathA.containsDeviceTemplate(this.mDeleteDevPath.getDeviceTemplate())) {
            this.updateDesign(devPathA, devPathB, true, createNewContactLayer);
        } else if (this.mIsDeleteDevPathA && devPathB.containsDeviceTemplate(this.mDeleteDevPath.getDeviceTemplate())) {
            this.updateDesign(devPathB, devPathA, false, createNewContactLayer);
        } else if (createNewContactLayer) {
            Layer layerA = this.mContactLayer.getContactLayerA();
            Layer layerB = this.mContactLayer.getContactLayerB();
            ContactLayer.create((DevicePath)devPathA, (Layer)layerA, (DevicePath)devPathB, (Layer)layerB);
        }
    }

    private void updateDesign(DevicePath fromDevPath, DevicePath toParentDevPath, boolean isUpdateDevPathA, boolean createNewContactLayer) {
        DevicePath newDevPath = this.copyDev(fromDevPath, toParentDevPath);
        this.updateNetMaps(fromDevPath, toParentDevPath.getDeviceTemplate(), newDevPath.getDevice());
        if (createNewContactLayer) {
            this.updateContactLayer(newDevPath, toParentDevPath, isUpdateDevPathA);
        }
    }

    private DevicePath copyDev(DevicePath fromDevPath, DevicePath toParentDevPath) {
        Device fromDev;
        DeviceTemplate toParentDevT = toParentDevPath.getDeviceTemplate();
        Device curChildWithName = toParentDevT.getChild((fromDev = fromDevPath.getDevice()).getName());
        if (curChildWithName != null && curChildWithName.getTemplate() == this.mDeleteDevPath.getDeviceTemplate()) {
            curChildWithName.setName(String.format("%s_removing", curChildWithName.getName()));
        }
        Device newDev = fromDevPath.getDevice().copyTo(toParentDevT, false);
        newDev.setLoc(this.getNewDevLoc(fromDevPath, toParentDevPath));
        newDev.setRotate(this.getNewDevRot(fromDevPath, toParentDevPath));
        newDev.setMirror(this.getNewDevMirror(fromDevPath, toParentDevPath));
        return new DevicePath(toParentDevPath, newDev);
    }

    private APoint2D getNewDevLoc(DevicePath fromDevPath, DevicePath toDevPath) {
        APoint2D oldLoc = fromDevPath.getLoc();
        AffineTransform trans2NewParent = toDevPath.getInverseTransform();
        return oldLoc.transform(trans2NewParent);
    }

    private float getNewDevRot(DevicePath fromDevPath, DevicePath toDevPath) {
        float oldRot = fromDevPath.getRot();
        return (oldRot - toDevPath.getRot()) % 360.0f;
    }

    private boolean getNewDevMirror(DevicePath fromDevPath, DevicePath toParentDevPath) {
        return fromDevPath.getMirror() ^ toParentDevPath.getMirror();
    }

    private void updateNetMaps(DevicePath fromDevPath, DeviceTemplate newParentDevT, Device newDev) {
        for (Net net : fromDevPath.getDeviceTemplate().getNets()) {
            Net rootNet = NetMap.getNetAt((Net)net, (DevicePath)fromDevPath, (DeviceTemplate)newParentDevT);
            if (rootNet.getDeviceTemplate() != newParentDevT) continue;
            NetMap.mapChildNet((Device)newDev, (Net)net, (Net)rootNet);
        }
    }

    private void updateContactLayer(DevicePath newDevPath, DevicePath toParentDevPath, boolean isUpdateDevPathA) {
        DevicePath devPathA = isUpdateDevPathA ? newDevPath : toParentDevPath;
        DevicePath devPathB = isUpdateDevPathA ? toParentDevPath : newDevPath;
        Layer layerA = this.mContactLayer.getContactLayerA();
        Layer layerB = this.mContactLayer.getContactLayerB();
        ContactLayer.create((DevicePath)devPathA, (Layer)layerA, (DevicePath)devPathB, (Layer)layerB);
    }

    private void deleteDevice() {
        if (this.mDeleteDevPath.isEmpty()) {
            DeviceTemplate deleteDevT = this.mDeleteDevPath.getDeviceTemplate();
            deleteDevT.deleteAllTemplateInsts();
            if (deleteDevT.getSourceType() == DeviceTemplate.SourceType.ORBITIO_CONTACT) {
                deleteDevT.deleteFromDb();
            }
        } else {
            this.mDeleteDevPath.getDevice().deleteFromDb();
        }
    }
}

