/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.factory;

import com.sigrity.acl.ALog;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.LayerShape;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.PortTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.ui.AColorIcon;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitIO;
import java.awt.Color;
import java.util.Objects;
import javax.swing.Icon;

public class CoreFactory {
    protected DevicePath diePath = null;
    public static String coreName = "LCore";
    public static long coreRatio = 1L;

    public CoreFactory(DevicePath pathToDie) {
        this.diePath = pathToDie;
    }

    public CoreFactory(String pathToDieString) {
        this.diePath = DevicePath.fromString((Db)OrbitIO.getCurDb(), (String)pathToDieString);
        if (this.diePath == null) {
            ALog.logError((String)"'%s' is not a valid device path", (Object[])new Object[]{pathToDieString});
        }
    }

    public static Icon getIcon(Color color) {
        if (color == null) {
            color = new Color(255, 0, 255);
        }
        return new AColorIcon(16, 16, 9, color, Color.white);
    }

    public void setCoreName(String newName) {
        coreName = newName;
    }

    public static DevicePath getCoreDevicePath(DevicePath aDiePath) {
        Device core = aDiePath.getDeviceTemplate().getChild(coreName);
        if (core != null) {
            DevicePath corePath = aDiePath.withChild(core);
            return corePath;
        }
        return null;
    }

    public boolean pathInCore(DevicePath candidate) {
        if (this.diePath == null) {
            return false;
        }
        DevicePath corePath = CoreFactory.getCoreDevicePath(this.diePath);
        if (corePath == null) {
            return false;
        }
        DeviceTemplate templateOfCore = corePath.getDeviceTemplate();
        return candidate.hasTemplate(templateOfCore);
    }

    public DevicePath makeCore() {
        if (this.diePath == null) {
            ALog.logWarn((String)"No Valid Core Defined");
            return null;
        }
        DevicePath currentCore = CoreFactory.getCoreDevicePath(this.diePath);
        if (currentCore != null) {
            return currentCore;
        }
        Db db = OrbitIO.getCurDb();
        DeviceTemplate dt = new DeviceTemplate(coreName + "Template", this.diePath.getLast().getSubstrate());
        dt.setIsSynthesized(true);
        dt.setType(DeviceTemplate.Type.LOGICAL);
        db.add((DbObject)dt);
        Device core = Device.create((Db)db, (String)coreName, (DeviceTemplate)dt, (DeviceTemplate)this.diePath.getDeviceTemplate());
        core.setSynthesized(true);
        ARect coreBounds = new ARect(this.diePath.getLast().getTemplate().getBB());
        dt.setBounds((AGeom)coreBounds);
        DevicePath corePath = this.diePath.withChild(core);
        core.setLoc(new APoint2D(0L, 0L));
        return corePath;
    }

    public static DevicePath moveInterface(Db db, String devicePathStringFrom, String devicePathStringTo) {
        DevicePath fromInterfacePath = DevicePath.fromString((Db)OrbitIO.getCurDb(), (String)devicePathStringFrom);
        if (fromInterfacePath == null) {
            ALog.logError((String)"'%s' is not a valid device path", (Object[])new Object[]{devicePathStringFrom});
            return null;
        }
        Design parent = Design.getDesign((Db)db);
        DevicePath result = new DevicePath();
        DeviceTemplate dieTemplate = fromInterfacePath.pathToLowestOfType(DeviceTemplate.Type.DIE).getDeviceTemplate();
        Device toBeMoved = fromInterfacePath.getLast();
        for (String devName : devicePathStringTo.split("/")) {
            if (devName.length() == 0) continue;
            if (parent == null) {
                return null;
            }
            Device d = parent.getChild(devName);
            if (d == null) {
                DeviceTemplate dt = new DeviceTemplate(devName + "Template", dieTemplate.getSubstrate());
                dt.setIsSynthesized(true);
                dt.setType(DeviceTemplate.Type.LOGICAL);
                db.add((DbObject)dt);
                d = Device.create((Db)db, (String)devName, (DeviceTemplate)dt, (DeviceTemplate)parent);
                d.setSynthesized(true);
                ARect coreBounds = new ARect(dieTemplate.getBB());
                dt.setBounds((AGeom)coreBounds);
            }
            result.add(d);
            parent = d.getTemplate();
        }
        if (parent != null) {
            toBeMoved.setParent((DeviceTemplate)parent);
            result.add(toBeMoved);
        }
        return result;
    }

    public PinInstance addPinToCore(String name) {
        DevicePath path = CoreFactory.getCoreDevicePath(this.diePath);
        Objects.requireNonNull(path);
        Device device = path.getDevice();
        DeviceTemplate dt = device.getTemplate();
        Db db = OrbitIO.getCurDb();
        Layer pinLayer = dt.getSubstrate().getBottomLayer();
        ARect newR = new ARect(-100L, -100L, 100L, 100L);
        PadTemplate padTemplate = PadTemplate.create((Db)db, (Substrate)dt.getSubstrate(), (String)(name + "PadTemplate"));
        LayerShape.create((Db)db, (Layer)pinLayer, (DbObject)padTemplate, (AGeom)newR);
        PinTemplate dtp = PinTemplate.create((Net)dt.getNetUnused(), (String)name);
        dtp.setType(PinTemplate.Type.CORE);
        PinInstance dp = PinInstance.getPinInstance((Device)device, (PinTemplate)dtp);
        dp.setPinInstanceName(name);
        dtp.setLoc(new APoint2D(dt.getBounds(true).getBounds().center()));
        PortTemplate portTemplate = dtp.getFirstPortTemplate();
        portTemplate.setPadTemplate(padTemplate);
        return dp;
    }

    protected PinInstance getCorePin(String name) {
        Device d = CoreFactory.getCoreDevicePath(this.diePath).getLast();
        PinInstance p = d.getPinByName(name);
        return p;
    }

    protected DevicePath diePath(DevicePath fullPath) {
        Substrate s = fullPath.getSubstrate();
        DevicePath dp = fullPath.pathToParent(s);
        return dp;
    }

    public void connectToCore(String fromPath, String fromPinName, String corePinName, String netName, PinTemplate.Direction ioDirection) {
        if (netName.equals("NetUnused")) {
            return;
        }
        DevicePath from = DevicePath.fromString((Db)OrbitIO.getCurDb(), (String)fromPath);
        from = this.diePath(from);
        DevicePath corePath = CoreFactory.getCoreDevicePath(this.diePath);
        if (corePath == null) {
            corePath = this.makeCore();
        }
        corePath = this.diePath(corePath);
        PinInstance fromPin = from.getLast().getPinByName(fromPinName);
        PinInstance corePin = this.getCorePin(corePinName);
        if (corePin == null) {
            corePin = this.addPinToCore(corePinName);
        }
        fromPin.getPinTemplate().setDirection(ioDirection);
        if (ioDirection.equals((Object)PinTemplate.Direction.IN)) {
            corePin.getPinTemplate().setDirection(PinTemplate.Direction.OUT);
        } else if (ioDirection.equals((Object)PinTemplate.Direction.OUT)) {
            corePin.getPinTemplate().setDirection(PinTemplate.Direction.IN);
        } else if (ioDirection.equals((Object)PinTemplate.Direction.INOUT)) {
            corePin.getPinTemplate().setDirection(PinTemplate.Direction.INOUT);
        }
        NetMap.mapThroughPath((DevicePath)from, (PinInstance)fromPin, (String)netName);
        NetMap.mapThroughPath((DevicePath)corePath, (PinInstance)corePin, (String)netName);
        Net coreNet = corePin.getPinTemplate().getNet();
        if (!coreNet.getName().equals(corePin.getPinTemplate().getName())) {
            if (corePin.getPinTemplate().getDeviceTemplate().getNet(corePin.getPinTemplate().getName()) == null) {
                coreNet.setName(corePin.getPinTemplate().getName());
            } else {
                Net realCoreNet = corePin.getPinTemplate().getDeviceTemplate().getNet(netName);
                if (realCoreNet != null) {
                    corePin.setNet(realCoreNet);
                } else {
                    ALog.logInfo((String)"Unexepected situation");
                }
            }
        }
    }
}

