/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.factory;

import com.sigrity.acl.ALog;
import com.sigrity.acl.AclInfo;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.ui.ADialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.OrbitApp;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.ReplaceDeviceUI;
import com.sigrity.orbit.ui.cphelper.CpHelper;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class DeviceConflictHelper {
    static final String TEMP_NAME = "Temp_Comp_In_Progess";
    Device mParent = null;
    Device mNewDevice = null;
    String mTempltName = null;
    String mInstName = null;
    Mode mMode = Mode.CREATE;

    public static DeviceConflictHelper create(Device parent, Device newDevice) {
        return new DeviceConflictHelper(parent, newDevice);
    }

    public static String getUniqueTempNameForDev(DeviceTemplate parent) {
        return Device.getUniqueName((DeviceTemplate)parent, (String)TEMP_NAME);
    }

    public static String getUniqueTempNameForDevT(Substrate substrate) {
        return DeviceTemplate.getUniqueName((Substrate)substrate, (String)TEMP_NAME);
    }

    public static void moveToParent(Device parent, Device newDevice) {
        newDevice.setParent(parent, true);
    }

    public static DeviceTemplate getTemplate(Device device) {
        return device == null ? Design.getDesign((Db)OrbitIO.getCurDb()) : device.getTemplate();
    }

    protected DeviceConflictHelper(Device parent, Device newDevice) {
        this.mParent = parent;
        this.mNewDevice = newDevice;
    }

    public void setMode(Mode mode) {
        this.mMode = mode;
    }

    public void setPreferedTempltName(String name) {
        this.mTempltName = name;
    }

    public void setPreferedInstName(String name) {
        this.mInstName = name;
    }

    public String getPreferedTempltName() {
        return this.mTempltName == null ? this.mNewDevice.getTemplate().getName() : this.mTempltName;
    }

    public String getPreferedInstName() {
        return this.mInstName == null ? this.mNewDevice.getName() : this.mInstName;
    }

    public Device getParent() {
        return this.mParent;
    }

    public Device getNewDevice() {
        return this.mNewDevice;
    }

    public void solve() {
        block2: {
            try {
                this.solveInternal();
            }
            catch (IllegalArgumentException e) {
                if (e.getMessage() == null) break block2;
                ALog.logError((String)"%s", (Object[])new Object[]{e.getMessage()});
            }
        }
    }

    public boolean preSolve() {
        return !this.setNameToInstIfValid() || !this.setNameToTempltIfValid();
    }

    private void solveInternal() {
        Solver solver = this.mMode.getSolver();
        solver.solve(this);
    }

    private boolean setNameToInstIfValid() {
        Device existing = this.getExistingChild();
        if (existing != null && existing != this.mNewDevice) {
            return false;
        }
        DeviceConflictHelper.moveToParent(this.mParent, this.mNewDevice);
        this.mNewDevice.setName(this.getPreferedInstName());
        return true;
    }

    private boolean setNameToTempltIfValid() {
        DeviceTemplate existing = this.getExistingChildTemplate();
        if (existing != null && existing != this.mNewDevice.getTemplate()) {
            return false;
        }
        this.mNewDevice.getTemplate().setName(this.getPreferedTempltName());
        return true;
    }

    private Device getExistingChild() {
        return this.getExistingInst(this.getPreferedInstName());
    }

    public Device getExistingInst(String instName) {
        return DeviceConflictHelper.getTemplate(this.mParent).getChild(instName);
    }

    private DeviceTemplate getExistingChildTemplate() {
        return this.getExistingChildTemplate(this.getPreferedTempltName());
    }

    public DeviceTemplate getExistingChildTemplate(String templtName) {
        return DeviceTemplate.getDeviceTemplate((Substrate)this.mNewDevice.getSubstrate(), (String)templtName);
    }

    public String getUniquePreferedInstName() {
        return Device.getUniqueName((DeviceTemplate)DeviceConflictHelper.getTemplate(this.mParent), (String)this.getPreferedInstName());
    }

    public String getUniquePreferedTempltName() {
        return DeviceTemplate.getUniqueName((Substrate)this.getNewDevice().getSubstrate(), (String)this.getPreferedTempltName());
    }

    public void cpDelete(Device device, DeviceTemplate templt, Substrate subst) {
        block2: {
            try {
                this.cpDeleteDevice(device);
                this.cpDeleteTemplate(templt);
                this.cpDeleteSubstrate(subst);
            }
            catch (RuntimeException e) {
                if (e.getMessage() == null) break block2;
                ALog.logError((String)e.getMessage());
            }
        }
    }

    private void cpDeleteDevice(Device device) {
        Boolean result = (Boolean)Cp.exec((String)"%s.deleteFromDb()", (Object[])new Object[]{CpHelper.getObjCmdStr(device)});
        if (!Boolean.TRUE.equals(result)) {
            throw new DeviceConfilterException(String.format("Failed to delete device %s", device.toString()));
        }
        ALog.logInfo((String)"The device '%s' was deleted.", (Object[])new Object[]{device.getName()});
    }

    private void cpDeleteTemplate(DeviceTemplate templt) {
        if (!templt.hasNoDeviceInstance()) {
            ALog.logInfo((String)"The device template '%s' was NOT deleted as there are still existing device instances.", (Object[])new Object[]{templt.getName()});
            return;
        }
        Boolean result = (Boolean)Cp.exec((String)"%s.deleteFromDb()", (Object[])new Object[]{CpHelper.getObjCmdStr(templt)});
        if (!Boolean.TRUE.equals(result)) {
            throw new DeviceConfilterException(String.format("Failed to delete the device template '%s'.", templt.getName()));
        }
        ALog.logInfo((String)"The device template '%s' was deleted.", (Object[])new Object[]{templt.getName()});
    }

    private void cpDeleteSubstrate(Substrate subst) {
        if (subst.getDeviceTemplateCount() > 0) {
            ALog.logInfo((String)"The device substrate '%s' was NOT deleted as there are still templates referencing it.", (Object[])new Object[]{subst.getName()});
            return;
        }
        Boolean result = (Boolean)Cp.exec((String)"%s.deleteFromDb()", (Object[])new Object[]{CpHelper.getObjCmdStr(subst)});
        if (!Boolean.TRUE.equals(result)) {
            throw new DeviceConfilterException(String.format("Failed to delete the device substrate '%s'.", subst.getName()));
        }
        ALog.logInfo((String)"The device substrate '%s' was deleted.", (Object[])new Object[]{subst.getName()});
    }

    protected static class InquireSolver
    implements Solver {
        protected InquireSolver() {
        }

        @Override
        public void solve(DeviceConflictHelper helper) {
            ModeInquirer.inquire(OrbitIO.getMainWindow(), helper);
        }
    }

    public static class UpdateSolver
    implements Solver {
        boolean deleteIfUnused = false;
        boolean inheritChildren = true;

        public boolean getDeleteIfUnused() {
            return this.deleteIfUnused;
        }

        public void setDeleteIfUnused(boolean deleteIfUnused) {
            this.deleteIfUnused = deleteIfUnused;
        }

        public void setInheritChildren(boolean inheritChildren) {
            this.inheritChildren = inheritChildren;
        }

        @Override
        public void solve(DeviceConflictHelper helper) {
            Device newDevice = helper.getNewDevice();
            DeviceTemplate newTemplt = newDevice.getTemplate();
            DeviceTemplate existTemplt = helper.getExistingChildTemplate();
            if (existTemplt == null) {
                ALog.logError((String)"Cannot update to target device template. Please check the substrate of '%s'", (Object[])new Object[]{newTemplt.getName()});
            }
            if (existTemplt != null && existTemplt != newTemplt) {
                existTemplt.updateWith(newTemplt, this.inheritChildren);
            }
            if (this.getDeleteIfUnused()) {
                this.purge(helper);
            }
        }

        private void purge(DeviceConflictHelper helper) {
            Device newDevice = helper.getNewDevice();
            DeviceTemplate newTemplt = newDevice.getTemplate();
            Substrate newSubs = newTemplt.getSubstrate();
            helper.cpDelete(newDevice, newTemplt, newSubs);
        }
    }

    public static class ReplaceSolver
    implements Solver {
        @Override
        public void solve(DeviceConflictHelper helper) {
            Device newDevice = helper.getNewDevice();
            ReplaceDeviceUI.showMe(OrbitIO.getMainWindow(), helper.getExistingChild(), newDevice);
            if (!newDevice.getName().equals(helper.getPreferedInstName())) {
                String newName = Device.getUniqueName((DeviceTemplate)newDevice.getParent(), (String)helper.getPreferedInstName());
                newDevice.setName(newName);
            }
        }
    }

    public static class CreateSolver
    implements Solver {
        String instName = null;
        String templtName = null;

        public String getInstName() {
            return this.instName;
        }

        public void setInstName(String name) {
            this.instName = name;
        }

        public String getTempltName() {
            return this.templtName;
        }

        public void setTempltName(String name) {
            this.templtName = name;
        }

        protected void solveInst(DeviceConflictHelper helper) {
            Device parent = helper.getParent();
            Device newDevice = helper.getNewDevice();
            DeviceTemplate parenTemplt = DeviceConflictHelper.getTemplate(parent);
            String name = newDevice.getName();
            if (this.getInstName() != null) {
                name = this.getInstName();
            } else if (!helper.setNameToInstIfValid()) {
                name = Device.getUniqueName((DeviceTemplate)parenTemplt, (String)helper.getPreferedInstName());
            }
            newDevice.setName(name);
        }

        protected void solveTemplt(DeviceConflictHelper helper) {
            Device newDevice = helper.getNewDevice();
            DeviceTemplate newTemplate = newDevice.getTemplate();
            String name = newTemplate.getName();
            if (this.getTempltName() != null) {
                name = this.getTempltName();
            } else if (!helper.setNameToTempltIfValid()) {
                name = DeviceTemplate.getUniqueName((Substrate)newDevice.getSubstrate(), (String)helper.getPreferedTempltName());
            }
            newTemplate.setName(name);
        }

        @Override
        public void solve(DeviceConflictHelper helper) {
            Device parent = helper.getParent();
            Device newDevice = helper.getNewDevice();
            DeviceTemplate parenTemplt = DeviceConflictHelper.getTemplate(parent);
            this.solveInst(helper);
            this.solveTemplt(helper);
            DeviceConflictHelper.moveToParent(parent, newDevice);
            ALog.logInfo((String)"A new child of %s named %s is created", (Object[])new Object[]{parenTemplt.getName(), newDevice.getName()});
        }
    }

    protected static interface Solver {
        public void solve(DeviceConflictHelper var1);
    }

    public static enum Mode {
        CREATE("Create New Device"),
        REPLACE("Replace Existing Device"),
        UPDATE("Update Existing DeviceTemplate"),
        INQUIRE("Inquire");

        protected String mDesc;

        private Mode(String desc) {
            this.mDesc = desc;
        }

        public String getDesc() {
            return this.mDesc;
        }

        public Solver getSolver() {
            Solver solver;
            switch (this) {
                case CREATE: {
                    solver = new CreateSolver();
                    break;
                }
                case REPLACE: {
                    solver = new ReplaceSolver();
                    break;
                }
                case UPDATE: {
                    solver = new UpdateSolver();
                    break;
                }
                case INQUIRE: {
                    solver = new InquireSolver();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported mode");
                }
            }
            return solver;
        }
    }

    public static class ModeInquirer
    extends ADialog {
        protected JRadioButton mRbCreate;
        protected JRadioButton mRbReplace;
        protected JRadioButton mRbUpdate;
        protected JButton mBtnOk;
        protected JButton mBtnCancel;
        protected JTextField mTxtInstName;
        protected JTextField mTxtTempltName;
        protected JCheckBox mCboDel;
        protected JCheckBox mCboInheritChildren;
        DeviceConflictHelper mHelper;
        protected ActionListener mOkListener = ae -> {
            if (this.mRbCreate.isSelected()) {
                this.cpCreateSolver();
            } else if (this.mRbReplace.isSelected()) {
                this.cpReplaceSolver();
            } else if (this.mRbUpdate.isSelected()) {
                this.cpUpdateSolver();
            } else {
                throw new IllegalArgumentException("None of the RadioButton is selected");
            }
        };
        protected ActionListener mCancelListener = ae -> this.mHelper.cpDelete(this.mHelper.getNewDevice(), this.mHelper.getNewDevice().getTemplate(), this.mHelper.getNewDevice().getSubstrate());

        public static void inquire(Window owner, DeviceConflictHelper helper) {
            new ModeInquirer(owner, helper);
        }

        protected ModeInquirer(Window owner, DeviceConflictHelper helper) {
            super(owner, "Resolve the Conflict");
            this.mHelper = helper;
            GridBagManager l = GridBagManager.layout((Container)this.getContentPane());
            this.addModePanel(l);
            this.addActionButtons(l);
            this.groupRadios();
            this.setupSections();
            UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)this.mBtnCancel, (JButton)this.mBtnOk);
            this.pack();
            UIUtil.center((Component)((Object)this));
            this.setModal(true);
            this.setVisible(true);
        }

        private void addModePanel(GridBagManager l) {
            l.push("Conflict Solver", (GridBagConstraints)GridBagManager.FILLALL);
            this.addCreateSection(l);
            this.addReplaceSection(l);
            this.addUpdateSection(l);
            l.popNl();
        }

        protected void addCreateSection(GridBagManager l) {
            this.mRbCreate = new JRadioButton(Mode.CREATE.getDesc());
            l.addNl((Component)this.mRbCreate, (GridBagConstraints)GridBagManager.LEFT_REMAINX);
            this.addIdentifierSection(l);
        }

        protected JPanel addIdentifierSection(GridBagManager l) {
            l.indent();
            JPanel pnlId = l.push("Create Options", (GridBagConstraints)GridBagManager.FILLX);
            l.add((Component)new JLabel("Template Name"), (GridBagConstraints)GridBagManager.LEFT);
            this.mTxtTempltName = (JTextField)l.add((Component)new JTextField(10), (GridBagConstraints)GridBagManager.LEFT);
            l.newline();
            l.add((Component)new JLabel("Instance Name"), (GridBagConstraints)GridBagManager.LEFT);
            this.mTxtInstName = (JTextField)l.add((Component)new JTextField(10), (GridBagConstraints)GridBagManager.LEFT);
            l.addFillX();
            l.newline();
            l.popNl();
            return pnlId;
        }

        protected void addReplaceSection(GridBagManager l) {
            String desc = Mode.REPLACE.getDesc() + " \"" + this.mHelper.getPreferedInstName() + "\"";
            this.mRbReplace = new JRadioButton(desc);
        }

        protected void addUpdateSection(GridBagManager l) {
            String desc = Mode.UPDATE.getDesc() + " \"" + this.mHelper.getPreferedTempltName() + "\"";
            this.mRbUpdate = new JRadioButton(desc);
            l.addNl((Component)this.mRbUpdate, (GridBagConstraints)GridBagManager.LEFT_REMAINX);
            this.addAskDelSection(l);
        }

        protected JPanel addAskDelSection(GridBagManager l) {
            l.indent();
            JPanel pnlId = l.push("Update Options", (GridBagConstraints)GridBagManager.FILLX);
            this.mCboDel = (JCheckBox)l.add((Component)new JCheckBox("Purge unused on exit (debug only)"), (GridBagConstraints)GridBagManager.LEFT);
            this.mCboDel.setSelected(true);
            this.mCboDel.setVisible(AclInfo.getDebugMode());
            l.newline();
            this.mCboInheritChildren = (JCheckBox)l.add((Component)new JCheckBox("Inherit All Children"), (GridBagConstraints)GridBagManager.LEFT);
            this.mCboInheritChildren.setSelected(true);
            this.mCboInheritChildren.setVisible(AclInfo.getDebugMode());
            l.addFillX();
            l.newline();
            l.popNl();
            return pnlId;
        }

        protected void addActionButtons(GridBagManager l) {
            l.push((GridBagConstraints)GridBagManager.FILLX_REMAINX.noInsets());
            l.addFillX();
            this.mBtnOk = (JButton)l.add((Component)new JButton("Ok"), (GridBagConstraints)GridBagManager.CENTER);
            this.mBtnCancel = (JButton)l.add((Component)new JButton("Cancel"));
            this.mBtnOk.addActionListener(this.mOkListener);
            this.mBtnCancel.addActionListener(this.mCancelListener);
            this.mBtnOk.setPreferredSize(this.mBtnCancel.getPreferredSize());
            l.popNl();
        }

        protected void groupRadios() {
            ButtonGroup bGroup = new ButtonGroup();
            bGroup.add(this.mRbCreate);
            bGroup.add(this.mRbReplace);
            bGroup.add(this.mRbUpdate);
        }

        protected void setupSections() {
            this.mRbCreate.setSelected(true);
            this.mTxtTempltName.setText(this.mHelper.getPreferedTempltName());
            this.mTxtInstName.setText(this.mHelper.getPreferedInstName());
        }

        private void cpCreateSolver() {
            boolean templtDone = this.checkIfTempltDup();
            boolean instDone = this.checkIfInstDup();
            if (!templtDone || !instDone) {
                return;
            }
            Cp.exec((String)"unset(\"_conflictSolver\");", (Object[])new Object[0]);
            Cp.exec((String)"_conflictSolver = new com.sigrity.orbit.factory.DeviceConflictHelper.CreateSolver();", (Object[])new Object[0]);
            Cp.exec((String)"_conflictSolver.setInstName(\"%s\");", (Object[])new Object[]{this.mTxtInstName.getText()});
            Cp.exec((String)"_conflictSolver.setTempltName(\"%s\");", (Object[])new Object[]{this.mTxtTempltName.getText()});
            Cp.exec((String)"_conflictConfig = com.sigrity.orbit.factory.DeviceConflictHelper.create(%s, %s)", (Object[])new Object[]{CpHelper.getObjCmdStr(this.mHelper.getParent()), CpHelper.getObjCmdStr(this.mHelper.getNewDevice())});
            Cp.exec((String)"_conflictConfig.setPreferedTempltName(\"%s\")", (Object[])new Object[]{this.mHelper.getPreferedTempltName()});
            Cp.exec((String)"_conflictConfig.setPreferedInstName(\"%s\")", (Object[])new Object[]{this.mHelper.getPreferedInstName()});
            Cp.exec((String)"_conflictSolver.solve(_conflictConfig)", (Object[])new Object[0]);
            Cp.exec((String)"unset(\"_conflictConfig\");", (Object[])new Object[0]);
            Cp.exec((String)"unset(\"_conflictSolver\");", (Object[])new Object[0]);
            UIUtil.closeWindow((Window)((Object)this));
        }

        private void cpReplaceSolver() {
            Cp.exec((String)"unset(\"_conflictSolver\");", (Object[])new Object[0]);
            Cp.exec((String)"_conflictSolver = new com.sigrity.orbit.factory.DeviceConflictHelper.ReplaceSolver();", (Object[])new Object[0]);
            Cp.exec((String)"_conflictConfig = com.sigrity.orbit.factory.DeviceConflictHelper.create(%s, %s)", (Object[])new Object[]{CpHelper.getObjCmdStr(this.mHelper.getParent()), CpHelper.getObjCmdStr(this.mHelper.getNewDevice())});
            Cp.exec((String)"_conflictConfig.setPreferedTempltName(\"%s\")", (Object[])new Object[]{this.mHelper.getPreferedTempltName()});
            Cp.exec((String)"_conflictConfig.setPreferedInstName(\"%s\")", (Object[])new Object[]{this.mHelper.getPreferedInstName()});
            Cp.exec((String)"_conflictSolver.solve(_conflictConfig)", (Object[])new Object[0]);
            Cp.exec((String)"unset(\"_conflictConfig\");", (Object[])new Object[0]);
            Cp.exec((String)"unset(\"_conflictSolver\");", (Object[])new Object[0]);
            UIUtil.closeWindow((Window)((Object)this));
        }

        private void cpUpdateSolver() {
            Cp.exec((String)"unset(\"_conflictSolver\");", (Object[])new Object[0]);
            Cp.exec((String)"_conflictSolver = new com.sigrity.orbit.factory.DeviceConflictHelper.UpdateSolver();", (Object[])new Object[0]);
            Cp.exec((String)"_conflictConfig = com.sigrity.orbit.factory.DeviceConflictHelper.create(%s, %s)", (Object[])new Object[]{CpHelper.getObjCmdStr(this.mHelper.getParent()), CpHelper.getObjCmdStr(this.mHelper.getNewDevice())});
            Cp.exec((String)"_conflictConfig.setPreferedTempltName(\"%s\")", (Object[])new Object[]{this.mHelper.getPreferedTempltName()});
            Cp.exec((String)"_conflictConfig.setPreferedInstName(\"%s\")", (Object[])new Object[]{this.mHelper.getPreferedInstName()});
            Cp.exec((String)"_conflictSolver.setDeleteIfUnused(%b)", (Object[])new Object[]{this.mCboDel.isSelected()});
            Cp.exec((String)"_conflictSolver.setInheritChildren(%b)", (Object[])new Object[]{this.mCboInheritChildren.isSelected()});
            Cp.exec((String)"_conflictSolver.solve(_conflictConfig)", (Object[])new Object[0]);
            Cp.exec((String)"unset(\"_conflictConfig\");", (Object[])new Object[0]);
            Cp.exec((String)"unset(\"_conflictSolver\");", (Object[])new Object[0]);
            UIUtil.closeWindow((Window)((Object)this));
        }

        private boolean checkIfInstDup() {
            Device existingInst = this.mHelper.getExistingInst(this.mTxtInstName.getText());
            if (existingInst != null && existingInst != this.mHelper.getNewDevice()) {
                String msg = "Instance name '" + this.mTxtInstName.getText() + "' exists. Do you want to rename automatically?";
                if (OrbitApp.showWarningConfirmDialog((String)msg, (String)"") == 1) {
                    return false;
                }
                this.mTxtInstName.setText(this.mHelper.getUniquePreferedInstName());
            }
            return true;
        }

        private boolean checkIfTempltDup() {
            DeviceTemplate existingTemplt = this.mHelper.getExistingChildTemplate(this.mTxtTempltName.getText());
            if (existingTemplt != null && existingTemplt != this.mHelper.getNewDevice().getTemplate()) {
                String msg = "Template name '" + this.mTxtTempltName.getText() + "' exists. Do you want to rename automatically?";
                if (OrbitApp.showWarningConfirmDialog((String)msg, (String)"") == 1) {
                    return false;
                }
                this.mTxtTempltName.setText(this.mHelper.getUniquePreferedTempltName());
            }
            return true;
        }
    }

    static class DeviceConfilterException
    extends RuntimeException {
        public DeviceConfilterException(String msg) {
            super(msg);
        }
    }
}

