/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.factory;

import com.google.common.collect.Streams;
import com.sigrity.acl.ABoolean;
import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.Unit;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.LayerShape;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.db.std.Term;
import com.sigrity.acl.geom.ACircle;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.AGeomUtil;
import com.sigrity.acl.geom.AOctagon;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.parsers.CSVDOMParser;
import com.sigrity.acl.parsers.CSVDocument;
import com.sigrity.acl.xml.AXDomUtil;
import com.sigrity.orbit.CreatePinFactory;
import com.sigrity.orbit.OrbitApp;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.export.PortCSVIn;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import org.apache.commons.io.input.BOMInputStream;
import org.javatuples.Pair;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DeviceFactory {
    private static final String FIELD_X = "X";
    private static final String FIELD_Y = "Y";
    private static final String FIELD_PIN_NAME = "PIN_NAME";
    private static final String FIELD_NET_NAME = "NET_NAME";
    private static final String FIELD_PIN_NUMBER = "PIN_NUMBER";
    private static final String FIELD_PIN_USE = "PIN_USE";
    private static final String FIELD_PIN_DIRECTION = "PIN_DIRECTION";
    private static final String FIELD_PIN_PERSONALITY = "PIN_PERSONALITY";
    private static final String FIELD_PADSTACK = "PADSTACK";
    private static final String FIELD_DIFFPAIR = "DIFFPAIR";
    private static final String FIELD_FIXED = "FIXED";
    private static final String FIELD_DEVICE_PIN_DEVT = "DEVICE_PIN_TEMPLATE";
    private static final String FIELD_DEVICE_PIN_TERM = "DEVICE_PIN_TERM";
    private static final String[] PIN_FILE_HEADER = new String[]{"X", "Y", "PIN_NAME", "PIN_NUMBER"};
    public static boolean useOldNamingForDeviceTemplateAndPadTemplate = false;
    protected Db mDb;
    protected Db templateDb;
    protected Design mDesign;
    protected Unit mUnit;
    protected boolean mInstantiateAsDevices = true;
    protected String mSubstrateName = null;
    protected long mWidth = 0L;
    protected long mHeight = 0L;
    protected String mLayerName = null;
    protected String mPinFilePath = null;
    protected String mPinFromTemplateName = null;
    protected String mPinParamPadTName = null;
    protected String mPinParamDevTName = null;
    protected Long mPinSize = null;
    protected Long mPinSizeB = null;
    protected Float mPinRot = null;
    protected PadTemplate.PadShapeStyle mPadShape = PadTemplate.PadShapeStyle.Circle;
    protected HashMap<PadTemplate, DeviceTemplate> mPadtoDevT = new HashMap();
    protected DeviceTemplate mParentDevice;
    boolean mDoneSetPreferredNames = false;
    String mPreferredSubstrateName;
    String mPreferredDeviceTemplateName;
    BiFunction<String, String, String> mPreferredPadTemplateName;
    int mPreferredDeviceNameStartIndex;
    String mPreferredDeviceNameMiddle;
    String fieldX;
    String fieldY;
    String fieldPinName;
    String fieldPinUse;
    String fieldPinDirection;
    String fieldNetName;
    String fieldPinNumber;
    String fieldPadStack;
    String fieldDiffPair;
    String fieldFixed;

    public static DeviceFactory create(Db db) {
        return new DeviceFactory(db);
    }

    protected Db getTemplateDb() {
        return this.templateDb;
    }

    public void setTemplateDb(Db db) {
        this.templateDb = db;
    }

    public DeviceFactory(Db db) {
        this.mDb = db;
        this.mDesign = Design.getDesign((Db)this.mDb);
        this.mUnit = this.mDesign != null ? this.mDesign.getUnit() : Design.getDefaultUnitDist();
    }

    public void setInstantiateAsDevices(boolean flag) {
        this.mInstantiateAsDevices = flag;
    }

    public boolean getInstantiateAsDevices() {
        return this.mInstantiateAsDevices;
    }

    public void setSubstrateName(String name) {
        this.mSubstrateName = name;
    }

    public void setWidth(long w) {
        this.mWidth = w;
    }

    public void setHeight(long h) {
        this.mHeight = h;
    }

    public void setLayerName(String name) {
        this.mLayerName = name;
    }

    public void setPinSize(long size) {
        this.mPinSize = size;
    }

    public void setPinSizeB(long size) {
        this.mPinSizeB = size;
    }

    public void setPinRotation(float rot) {
        this.mPinRot = Float.valueOf(rot);
    }

    public void setPadShape(PadTemplate.PadShapeStyle shape) {
        this.mPadShape = shape;
    }

    public void setPinFile(String filePath) {
        this.mPinFilePath = filePath;
    }

    public void setPinSize(double userSize) {
        this.mPinSize = this.mUnit == null ? (long)userSize : this.mUnit.fromUser(userSize);
    }

    public void setParentDevice(String deviceTemplateKeyStr) {
        DeviceTemplate dev = (DeviceTemplate)this.mDb.getByKeyStr(DeviceTemplate.class, deviceTemplateKeyStr);
        if (dev == null) {
            ALog.logError((String)"Cannot find device from '%s'", (Object[])new Object[]{deviceTemplateKeyStr});
            return;
        }
        this.mParentDevice = dev;
    }

    public void setDeviceTemplateName(String name) {
        this.setPinFromTemplateName(name);
    }

    public void setPinFromTemplateName(String name) {
        this.mPinFromTemplateName = name;
    }

    public void setPinParamPadTName(String pinParamPadTName) {
        this.mPinParamPadTName = pinParamPadTName;
    }

    public void setPinParamDevTName(String pinParamDevTName) {
        this.mPinParamDevTName = pinParamDevTName;
    }

    private String getOldStyleDeviceTemplateName(String name, DeviceTemplate.Type type) {
        String templateName;
        switch (type) {
            case BOARD: {
                templateName = "Brd_UserComponent_" + name;
                break;
            }
            case PACKAGE: {
                templateName = "Pkg_UserComponent_" + name;
                break;
            }
            case INTERPOSER: {
                templateName = "Inter_UserComponent_" + name;
                break;
            }
            case DIE: {
                templateName = "Die_UserComponent_" + name;
                break;
            }
            case CORE: 
            case MACRO: {
                templateName = "Macro_UserComponent_" + name;
                break;
            }
            case COVER: {
                templateName = "Cover_UserComponent_" + name;
                break;
            }
            case PACKAGEDDIE: {
                templateName = "Comp_UserComponent_" + name;
                break;
            }
            case PAD: {
                templateName = "Pad_" + name;
                break;
            }
            case BUMP: {
                templateName = "Bump_" + name;
                break;
            }
            case PERSONALITY: {
                templateName = "Personality_" + name;
                break;
            }
            case GROUP: {
                templateName = "Group_" + name;
                break;
            }
            default: {
                String msg = String.format("Do not support device template type : %s", type.toString());
                ALog.logError((String)msg);
                throw new IllegalArgumentException(msg);
            }
        }
        return templateName;
    }

    private void setPreferredNames(String name, DeviceTemplate.Type type) {
        if (useOldNamingForDeviceTemplateAndPadTemplate) {
            this.mPreferredDeviceTemplateName = this.getOldStyleDeviceTemplateName(name, type);
            this.mPreferredPadTemplateName = (deviceTemplateName, deviceName) -> "PadTemplate_" + deviceName;
            this.mPreferredDeviceNameStartIndex = 0;
            this.mPreferredDeviceNameMiddle = "_";
        } else {
            this.mPreferredDeviceTemplateName = name;
            this.mPreferredPadTemplateName = (deviceTemplateName, deviceName) -> this.mPinParamPadTName != null ? this.mPinParamPadTName : deviceTemplateName;
            this.mPreferredDeviceNameStartIndex = 1;
            this.mPreferredDeviceNameMiddle = null;
        }
        this.mPreferredSubstrateName = name + "_Substrate";
        this.mDoneSetPreferredNames = true;
    }

    public Device createDevice(String name, DeviceTemplate.Type type) {
        this.setPreferredNames(name, type);
        String deviceTemplateName = this.mPreferredDeviceTemplateName;
        return this.createDevice(deviceTemplateName, name, type);
    }

    private CSVDocument getCsvDoc(String pinFilePath) {
        CSVDocument csvDoc = null;
        if (pinFilePath != null && !pinFilePath.isEmpty()) {
            BOMInputStream fis = null;
            try {
                fis = new BOMInputStream((InputStream)new FileInputStream(new File(pinFilePath)));
            }
            catch (FileNotFoundException e) {
                ALog.logError((Throwable)e, (String)"Unable to read '%s'.", (Object[])new Object[]{pinFilePath});
                return null;
            }
            CSVDOMParser parser2 = new CSVDOMParser(true, null);
            parser2.setDataSepExpression(",");
            try {
                csvDoc = parser2.parse((InputStream)fis);
                csvDoc.setPath(pinFilePath);
            }
            catch (CSVDOMParser.CSVDOMException e) {
                ALog.logError((Throwable)e, (String)"Error parsing input file '%s'.", (Object[])new Object[]{pinFilePath});
                return null;
            }
            if (!parser2.validateHeader(PIN_FILE_HEADER)) {
                ALog.logError((String)"Unexpected header in input file %s.", (Object[])new Object[]{pinFilePath});
                ALog.logError((String)"Header should be %s", (Object[])new Object[]{Arrays.toString(PIN_FILE_HEADER)});
                return null;
            }
        }
        return csvDoc;
    }

    private ARect getPinBoundBox(CSVDocument csvDoc) {
        ARect box = ARect.createAFaultyRect();
        if (csvDoc != null) {
            int line = 0;
            for (line = 0; line < csvDoc.getItemCount(); ++line) {
                String sx = csvDoc.getItemValue(line, FIELD_X);
                String sy = csvDoc.getItemValue(line, FIELD_Y);
                if (sx.isEmpty() && sy.isEmpty()) continue;
                try {
                    long x = this.mUnit.fromUser(Double.parseDouble(sx));
                    long y = this.mUnit.fromUser(Double.parseDouble(sy));
                    box.expand(new APoint2D(x, y));
                    continue;
                }
                catch (NumberFormatException e) {
                    this.logAndShowWarningForMissingXY(e, csvDoc.getPath(), line + 1);
                    return null;
                }
            }
        }
        return box;
    }

    private void logAndShowWarningForMissingXY(NumberFormatException e, String pinFilePath, int line) {
        Object msg = String.format("Invalid string format : %s on line %d %n", e.getMessage(), line);
        msg = (String)msg + String.format("Expect fileds of 'x' and 'y' from file '%s'", pinFilePath);
        OrbitApp.logAndDisplayWarningDialog((String)msg, (String)"Invalid CSV Row. Skip.");
    }

    private void logAndShowWarningForMissingField(String field, String pinFilePath, int line) {
        Object msg = String.format("Missing field: %s on line %d %n", field, line);
        msg = (String)msg + String.format("In file '%s'", pinFilePath);
        OrbitApp.logAndDisplayWarningDialog((String)msg, (String)"Invalid CSV File Content");
    }

    private Pair<Substrate, Boolean> getOrCreateSubstrate(DeviceTemplate.Type type) {
        boolean substrateCreated = false;
        Substrate s = null;
        if (this.mSubstrateName != null && !this.mSubstrateName.isEmpty()) {
            s = Substrate.getSubstrate((Db)this.mDb, (String)this.mSubstrateName);
        }
        if (s == null) {
            substrateCreated = true;
            this.mSubstrateName = Substrate.getUniqueName((Db)this.mDb, (String)this.mPreferredSubstrateName);
            s = Substrate.create((Db)this.mDb, (String)this.mSubstrateName);
            DeviceFactory.createDefaultLayers(type, s, this.mDb, this.mUnit);
            s.setSourceType(DeviceTemplate.SourceType.USER);
        }
        return new Pair(s, (Object)substrateCreated);
    }

    private ARect getBoundary(DeviceTemplate devTmplt, AGeom padGeom, PadTemplate defaultPadT, boolean pinInfoFromTemplate, CSVDocument csvDoc, ARect pinBoundBox, DeviceTemplate.Type type, Substrate s) {
        ARect r = new ARect(0L, 0L, this.mUnit.fromUser(5.0), this.mUnit.fromUser(5.0));
        if (this.mWidth <= 0L || this.mHeight <= 0L) {
            if (devTmplt != null) {
                ARect baseBounds;
                r = baseBounds = devTmplt.getBounds(true).getBounds();
            } else if (padGeom == null && defaultPadT != null && defaultPadT.getBB(null) != null) {
                r = this.computeBoundByCsv(csvDoc, s, defaultPadT);
            } else if (!pinInfoFromTemplate && this.mPadShape != null) {
                r = this.computeBoundByCsv(csvDoc, s, null);
            }
            if (!r.hasArea()) {
                r.setWidth(this.mUnit.fromUser(5.0));
                r.setHeight(this.mUnit.fromUser(5.0));
            }
            this.mWidth = r.width();
            this.mHeight = r.height();
        } else {
            r = pinBoundBox.left() < 0L || pinBoundBox.bottom() < 0L || type == DeviceTemplate.Type.PACKAGE || type == DeviceTemplate.Type.INTERPOSER ? new ARect(-this.mWidth / 2L, -this.mHeight / 2L, this.mWidth - this.mWidth / 2L, this.mHeight - this.mHeight / 2L) : new ARect(0L, 0L, this.mWidth, this.mHeight);
        }
        return r;
    }

    private ARect computeBoundByCsv(CSVDocument csvDoc, Substrate s, PadTemplate defaultPadT) {
        if (csvDoc == null) {
            return new ARect();
        }
        ARect bound = null;
        for (int line = 0; line < csvDoc.getItemCount(); ++line) {
            PadTemplate padT;
            long y;
            long x;
            String pad = csvDoc.getItemValue(line, FIELD_PADSTACK);
            String sx = csvDoc.getItemValue(line, FIELD_X);
            String sy = csvDoc.getItemValue(line, FIELD_Y);
            try {
                x = this.mUnit.fromUser(Double.parseDouble(sx));
                y = this.mUnit.fromUser(Double.parseDouble(sy));
            }
            catch (NumberFormatException e) {
                this.logAndShowWarningForMissingXY(e, csvDoc.getPath(), line + 1);
                return new ARect();
            }
            Object placeShape = null;
            placeShape = defaultPadT != null ? defaultPadT.getBounds(null) : (pad.isBlank() ? PadTemplate.PadShapeStyle.createShape((PadTemplate.PadShapeStyle)this.mPadShape, (Object[])new Object[]{this.mPinSize, this.mPinSizeB}) : ((padT = PadTemplate.get((Db)this.mDb, (Substrate)s, (String)pad)) != null ? padT.getBounds(null) : PadTemplate.PadShapeStyle.createShape((PadTemplate.PadShapeStyle)this.mPadShape, (Object[])new Object[]{this.mPinSize, this.mPinSizeB})));
            ARect placeBound = new ARect(x, y, x, y);
            if (placeShape != null) {
                placeBound = placeShape.getBounds();
                placeBound.moveBy(x, y);
            }
            if (bound == null) {
                bound = placeBound;
                continue;
            }
            bound.expand(placeBound);
        }
        return bound == null ? new ARect() : bound;
    }

    private PadTemplate getDefaultPad(Substrate s) {
        PadTemplate defFromPadT = null;
        defFromPadT = this.getTemplateDb() != null ? PadTemplate.get((Db)this.getTemplateDb(), (Substrate)s, (String)this.mPinFromTemplateName) : PadTemplate.get((Db)this.mDb, (Substrate)s, (String)this.mPinFromTemplateName);
        if (defFromPadT == null) {
            Substrate tryS;
            Iterator iterator = this.mDb.getObjects(Substrate.class).iterator();
            while (iterator.hasNext() && (defFromPadT = PadTemplate.get((Db)this.mDb, (Substrate)(tryS = (Substrate)iterator.next()), (String)this.mPinFromTemplateName)) == null) {
            }
        }
        if (defFromPadT == null) {
            return null;
        }
        if (defFromPadT.getSubstrate() != s) {
            ALog.flogWarn((String)"Copy Pad '%s' from '%s' to '%s'", (Object[])new Object[]{this.mPinFromTemplateName, defFromPadT.getSubstrate(), s});
            defFromPadT = defFromPadT.copyToSubstrate(s);
        }
        return defFromPadT;
    }

    public Device createDevice(String deviceTempltName, String deviceName, DeviceTemplate.Type type) {
        CSVDocument csvDoc;
        ARect pinBoundBox;
        if (!this.mDoneSetPreferredNames) {
            this.setPreferredNames(deviceName, type);
        }
        if ((pinBoundBox = this.getPinBoundBox(csvDoc = this.getCsvDoc(this.mPinFilePath))) == null) {
            return null;
        }
        if (this.mPinSize == null) {
            this.mPinSize = 0L;
        }
        if (this.mPinSizeB == null) {
            this.mPinSizeB = this.mPinSize;
        }
        Pair<Substrate, Boolean> subsInfo = this.getOrCreateSubstrate(type);
        boolean substrateCreated = (Boolean)subsInfo.getValue1();
        Substrate s = (Substrate)subsInfo.getValue0();
        Layer l = s.getLayer(this.mLayerName);
        if (substrateCreated && l == null) {
            l = type.equals((Object)DeviceTemplate.Type.PACKAGE) ? s.getBottomLayer() : s.getTopLayer();
        }
        boolean pinInfoFromTemplate = this.mPinFromTemplateName != null;
        AGeom padGeom = null;
        PadTemplate defFromPadT = null;
        DeviceTemplate defFromDevT = null;
        if (pinInfoFromTemplate) {
            if (this.mInstantiateAsDevices) {
                defFromDevT = DeviceTemplate.getDeviceTemplate((Substrate)s, (String)this.mPinFromTemplateName);
                if (defFromDevT == null) {
                    ALog.logError((String)"There is no DeviceTemplate named '%s'.", (Object[])new Object[]{this.mPinFromTemplateName});
                    return null;
                }
                if (this.getTemplateDb() != null) {
                    padGeom = defFromDevT.getBounds(true);
                    defFromPadT = PadTemplate.create((Db)this.mDb, (Substrate)s, (String)deviceTempltName);
                    LayerShape.create((Db)this.mDb, (Layer)l, (DbObject)defFromPadT, (AGeom)padGeom);
                }
            } else {
                defFromPadT = this.getDefaultPad(s);
                if (defFromPadT == null) {
                    ALog.flogError((String)"There is no PadTemplate named '%s' in any substrate", (Object[])new Object[]{this.mPinFromTemplateName});
                    return null;
                }
            }
        }
        ARect r = this.getBoundary(defFromDevT, padGeom, defFromPadT, pinInfoFromTemplate, csvDoc, pinBoundBox, type, s);
        DeviceTemplate devT = DeviceTemplate.create((Substrate)s, (String)deviceTempltName, (boolean)true);
        devT.setBounds((AGeom)r);
        devT.setIsSynthesized(true);
        devT.setType(type);
        if (csvDoc != null && csvDoc.getPath() != null) {
            devT.setSourceType(DeviceTemplate.SourceType.SPREADSHEET);
            devT.setSourceFile(csvDoc.getPath());
            File file = new File(csvDoc.getPath());
            devT.setSourceFileModifiedTime(file.lastModified());
        } else {
            devT.setSourceType(DeviceTemplate.SourceType.USER);
        }
        Design parentDevice = this.mParentDevice == null ? this.mDesign : this.mParentDevice;
        deviceName = this.insureUniqueDeviceName((DeviceTemplate)parentDevice, deviceName, this.mPreferredDeviceNameStartIndex, this.mPreferredDeviceNameMiddle);
        Device device = Device.create((String)deviceName, (DeviceTemplate)devT, (DeviceTemplate)parentDevice);
        device.setLoc(new APoint2D(0L, 0L));
        device.setIsPlaced(true);
        device.placeOnTopSide();
        device.setSynthesized(true);
        if (type != DeviceTemplate.Type.BUMP && this.mPinFilePath == null) {
            return device;
        }
        if (pinInfoFromTemplate) {
            APair result = null;
            PadTemplate largestGeoPad = null;
            if (this.mInstantiateAsDevices) {
                if (defFromDevT == null) {
                    return null;
                }
                Stream<PadTemplate> geoms = defFromDevT.getPins().stream().map(PinTemplate::getPadTemplate).filter(Objects::nonNull).filter(p -> p.getLargestGeom(null) != null);
                largestGeoPad = Streams.findLast(geoms).orElse(null);
                if (largestGeoPad == null) {
                    ALog.logError((String)"There is no geometry on DeviceTemplate '%s'.", (Object[])new Object[]{defFromDevT});
                    return null;
                }
                result = largestGeoPad.getLargestGeom(null);
                if (this.getTemplateDb() == null) {
                    defFromPadT = largestGeoPad;
                }
            } else {
                if (defFromPadT == null) {
                    return null;
                }
                result = defFromPadT.getLargestGeom(null);
            }
            if (result == null) {
                ALog.logError((String)"There is no geometry on PadTemplate '%s'.", (Object[])new Object[]{this.mPinFromTemplateName});
                return null;
            }
            if (substrateCreated) {
                defFromPadT = PadTemplate.create((Db)this.mDb, (Substrate)s, (String)("PseudoCopyOf_" + this.mPinFromTemplateName));
                LayerShape.create((Db)this.mDb, (Layer)l, (DbObject)defFromPadT, (AGeom)((LayerShape)result.first).getGeom());
            }
        } else {
            defFromPadT = PadTemplate.create((Db)this.mDb, (Substrate)s, (String)this.mPreferredPadTemplateName.apply(deviceTempltName, deviceName));
            padGeom = PadTemplate.PadShapeStyle.createShape((PadTemplate.PadShapeStyle)this.mPadShape, (Object[])new Object[]{this.mPinSize, this.mPinSizeB});
            LayerShape.create((Db)this.mDb, (Layer)l, (DbObject)defFromPadT, (AGeom)padGeom);
        }
        CreatePinFactory pinF = new CreatePinFactory();
        if (this.mInstantiateAsDevices) {
            pinF.setType(CreatePinFactory.Type.BUMP);
        } else {
            pinF.setType(CreatePinFactory.Type.PIN);
        }
        if (csvDoc == null) {
            this.createDeviceWithOnePin(defFromPadT, device, pinF);
        } else {
            this.createDeviceWithCSV(csvDoc, defFromPadT, device, l, pinF);
        }
        pinF.createPins();
        if (!defFromPadT.getPortTemplates().hasNext()) {
            defFromPadT.deleteFromDb();
        }
        device.moveToClearArea();
        return device;
    }

    private void createDeviceWithOnePin(final PadTemplate defaultPadT, final Device parent, CreatePinFactory pinF) {
        final String pinName = "PAD";
        pinF.addPin(new CreatePinFactory.PinData(){

            public Net.Use getNetUse() {
                return Net.Use.SIGNAL;
            }

            public Net.Direction getNetDir() {
                return Net.Direction.INOUT;
            }

            public Term.Use getTermUse() {
                return Term.Use.SIGNAL;
            }

            public Term.Type getTermType() {
                return Term.Type.INOUT;
            }

            public PinTemplate.Use getPinUse() {
                return PinTemplate.Use.SIGNAL;
            }

            public PinTemplate.Direction getPinDir() {
                return PinTemplate.Direction.INOUT;
            }

            public Device getDev() {
                return parent;
            }

            public DeviceTemplate getDevT() {
                return parent.getTemplate();
            }

            public Db getDb() {
                return DeviceFactory.this.mDb;
            }

            public Unit getUnit() {
                return Design.getUnit((Db)DeviceFactory.this.mDb);
            }

            public String getPinNum() {
                return pinName;
            }

            public String getTermName() {
                return pinName;
            }

            public String getNetName() {
                return pinName;
            }

            public String getPinPersonality() {
                return null;
            }

            public String getPadTemplate() {
                return defaultPadT.getName();
            }

            public String getDiffPair() {
                return null;
            }

            public boolean getFixed() {
                return false;
            }

            public long getX() {
                return 0L;
            }

            public long getY() {
                return 0L;
            }

            public float getRotate() {
                return (float)(DeviceFactory.this.mPinRot == null ? 0.0 : (double)DeviceFactory.this.mPinRot.floatValue());
            }

            public String getDevicePinTemplate() {
                return null;
            }

            public String getDevicePinTerm() {
                return null;
            }
        });
    }

    private boolean readRow(CSVDocument csvDoc, int rowIndex) {
        this.fieldX = AUtil.deSpace((String)csvDoc.getItemValue(rowIndex, FIELD_X));
        this.fieldY = AUtil.deSpace((String)csvDoc.getItemValue(rowIndex, FIELD_Y));
        this.fieldPinName = AUtil.deSpace((String)csvDoc.getItemValue(rowIndex, FIELD_PIN_NAME));
        this.fieldPinUse = AUtil.deSpace((String)csvDoc.getItemValue(rowIndex, FIELD_PIN_USE));
        this.fieldPinDirection = AUtil.deSpace((String)csvDoc.getItemValue(rowIndex, FIELD_PIN_DIRECTION));
        this.fieldNetName = AUtil.deSpace((String)csvDoc.getItemValue(rowIndex, FIELD_NET_NAME));
        this.fieldPinNumber = AUtil.deSpace((String)csvDoc.getItemValue(rowIndex, FIELD_PIN_NUMBER));
        this.fieldPadStack = AUtil.deSpace((String)csvDoc.getItemValue(rowIndex, FIELD_PADSTACK));
        this.fieldDiffPair = AUtil.deSpace((String)csvDoc.getItemValue(rowIndex, FIELD_DIFFPAIR));
        this.fieldFixed = AUtil.deSpace((String)csvDoc.getItemValue(rowIndex, FIELD_FIXED));
        return !this.fieldX.isEmpty() || !this.fieldY.isEmpty() || !this.fieldPinName.isEmpty() || !this.fieldPinNumber.isEmpty() || !this.fieldPadStack.isEmpty() || !this.fieldDiffPair.isEmpty();
    }

    private void createDeviceFromCSVRow(final CSVDocument csvDoc, final int rowIndex, final PadTemplate defaultPadT, final Device parent, final float rotation, final DeviceTemplate parentDevT, final Layer l, CreatePinFactory pinF) {
        pinF.addPin(new CreatePinFactory.PinData(){

            public Net.Use getNetUse() {
                return PortCSVIn.getNetUseBy(csvDoc.getItemValue(rowIndex, DeviceFactory.FIELD_PIN_USE));
            }

            public Net.Direction getNetDir() {
                return PortCSVIn.getNetDirBy(csvDoc.getItemValue(rowIndex, DeviceFactory.FIELD_PIN_DIRECTION));
            }

            public Term.Use getTermUse() {
                return PortCSVIn.getTermUseBy(csvDoc.getItemValue(rowIndex, DeviceFactory.FIELD_PIN_USE));
            }

            public Term.Type getTermType() {
                return PortCSVIn.getTermTypeBy(csvDoc.getItemValue(rowIndex, DeviceFactory.FIELD_PIN_DIRECTION));
            }

            public PinTemplate.Use getPinUse() {
                return PortCSVIn.getPinUseBy(csvDoc.getItemValue(rowIndex, DeviceFactory.FIELD_PIN_USE));
            }

            public PinTemplate.Direction getPinDir() {
                return PortCSVIn.getPinDirBy(csvDoc.getItemValue(rowIndex, DeviceFactory.FIELD_PIN_DIRECTION));
            }

            public Device getDev() {
                return parent;
            }

            public DeviceTemplate getDevT() {
                return parentDevT;
            }

            public Db getDb() {
                return DeviceFactory.this.mDb;
            }

            public Unit getUnit() {
                return DeviceFactory.this.mUnit;
            }

            public String getPinNum() {
                String pinNum = csvDoc.getItemValue(rowIndex, DeviceFactory.FIELD_PIN_NUMBER);
                if (pinNum.isEmpty()) {
                    DeviceFactory.this.logAndShowWarningForMissingField(DeviceFactory.FIELD_PIN_NUMBER, csvDoc.getPath(), rowIndex + 1);
                    return null;
                }
                return pinNum;
            }

            public String getTermName() {
                return csvDoc.getItemValue(rowIndex, DeviceFactory.FIELD_PIN_NAME);
            }

            public String getNetName() {
                return csvDoc.getItemValue(rowIndex, DeviceFactory.FIELD_NET_NAME).isEmpty() ? csvDoc.getItemValue(rowIndex, DeviceFactory.FIELD_PIN_NAME) : csvDoc.getItemValue(rowIndex, DeviceFactory.FIELD_NET_NAME);
            }

            public String getPinPersonality() {
                return csvDoc.getItemValue(rowIndex, DeviceFactory.FIELD_PIN_PERSONALITY);
            }

            public String getPadTemplate() {
                if (!csvDoc.getItemValue(rowIndex, DeviceFactory.FIELD_PADSTACK).isBlank()) {
                    PadTemplate pt = PadTemplate.get((Db)this.getDb(), (Substrate)this.getDevT().getSubstrate(), (String)csvDoc.getItemValue(rowIndex, DeviceFactory.FIELD_PADSTACK));
                    if (pt == null) {
                        pt = PadTemplate.create((Db)this.getDb(), (Substrate)this.getDevT().getSubstrate(), (String)csvDoc.getItemValue(rowIndex, DeviceFactory.FIELD_PADSTACK));
                        LayerShape.create((Db)this.getDb(), (Layer)l, (DbObject)pt, (AGeom)PadTemplate.PadShapeStyle.createShape((PadTemplate.PadShapeStyle)DeviceFactory.this.mPadShape, (Object[])new Object[]{DeviceFactory.this.mPinSize, DeviceFactory.this.mPinSizeB}));
                    }
                    return pt.getName();
                }
                return defaultPadT.getName();
            }

            public boolean getFixed() {
                return ABoolean.fromString((String)csvDoc.getItemValue(rowIndex, DeviceFactory.FIELD_FIXED));
            }

            public long getX() {
                long x = 0L;
                try {
                    x = DeviceFactory.this.mUnit.fromUser(Double.parseDouble(csvDoc.getItemValue(rowIndex, DeviceFactory.FIELD_X)));
                }
                catch (NumberFormatException e) {
                    DeviceFactory.this.logAndShowWarningForMissingXY(e, csvDoc.getPath(), rowIndex + 1);
                }
                return x;
            }

            public long getY() {
                long y = 0L;
                try {
                    y = DeviceFactory.this.mUnit.fromUser(Double.parseDouble(csvDoc.getItemValue(rowIndex, DeviceFactory.FIELD_Y)));
                }
                catch (NumberFormatException e) {
                    DeviceFactory.this.logAndShowWarningForMissingXY(e, csvDoc.getPath(), rowIndex + 1);
                }
                return y;
            }

            public float getRotate() {
                return rotation;
            }

            public String getDiffPair() {
                return csvDoc.getItemValue(rowIndex, DeviceFactory.FIELD_DIFFPAIR);
            }

            public String getDevicePinTemplate() {
                if (csvDoc.getItemValue(rowIndex, DeviceFactory.FIELD_DEVICE_PIN_DEVT) == null || csvDoc.getItemValue(rowIndex, DeviceFactory.FIELD_DEVICE_PIN_DEVT).isBlank()) {
                    if (!csvDoc.getItemValue(rowIndex, DeviceFactory.FIELD_PADSTACK).isBlank()) {
                        return this.getPadTemplate();
                    }
                    return DeviceFactory.this.mPinParamDevTName != null ? DeviceFactory.this.mPinParamDevTName : "Bump";
                }
                return csvDoc.getItemValue(rowIndex, DeviceFactory.FIELD_DEVICE_PIN_DEVT);
            }

            public String getDevicePinTerm() {
                if (csvDoc.getItemValue(rowIndex, DeviceFactory.FIELD_DEVICE_PIN_TERM) == null || csvDoc.getItemValue(rowIndex, DeviceFactory.FIELD_DEVICE_PIN_TERM).isBlank()) {
                    return "pin";
                }
                return csvDoc.getItemValue(rowIndex, DeviceFactory.FIELD_DEVICE_PIN_TERM);
            }
        });
    }

    private void createDeviceWithCSV(CSVDocument csvDoc, PadTemplate defaultPadT, Device parent, Layer l, CreatePinFactory pinF) {
        float rotation = (float)(this.mPinRot == null ? 0.0 : (double)this.mPinRot.floatValue());
        DeviceTemplate parentDevT = parent.getTemplate();
        try {
            for (int row = 0; row < csvDoc.getItemCount(); ++row) {
                if (!this.readRow(csvDoc, row)) {
                    ALog.flogInfo((String)"Skip line %d", (Object[])new Object[]{row});
                    continue;
                }
                this.createDeviceFromCSVRow(csvDoc, row, defaultPadT, parent, rotation, parentDevT, l, pinF);
            }
        }
        catch (Exception e) {
            ALog.logError((Throwable)e, (String)"Exception:'%s' when reading '%s'.", (Object[])new Object[]{csvDoc.getPath(), e.getMessage()});
        }
    }

    public static Layer createDefaultLayers(String typeName, String substrateName, Db db) {
        Unit unit = Design.getUnit((Db)db);
        return DeviceFactory.createDefaultLayers(DeviceTemplate.Type.valueOf((String)typeName), Substrate.getSubstrate((Db)db, (String)substrateName), db, unit);
    }

    @Deprecated
    public static Element getDefaultConfigData(String name) {
        return Substrate.getDefaultLayerConfig((String)name);
    }

    @Deprecated
    public static Layer createDefaultLayers(DeviceTemplate.Type type, Substrate s, Db db, Unit unit) {
        Layer l = null;
        s.setSourceType(DeviceTemplate.SourceType.USER);
        Element e = Substrate.getDefaultLayerConfig((String)type.name());
        if (e == null) {
            Layer.create((Substrate)s, (String)"Top", (int)1, (long)unit.fromUser(150.0), (Layer.LayerType)Layer.LayerType.Signal);
            Layer.create((Substrate)s, (String)"Bottom", (int)0, (long)unit.fromUser(150.0), (Layer.LayerType)Layer.LayerType.Signal);
            s.setHeight(Design.micronToInternal((Db)db, (double)300.0));
        } else {
            int i = 0;
            for (Element el : AXDomUtil.getChildElems((Node)e, (String)"Layer")) {
                String lName = el.getAttribute("name");
                Layer.create((Substrate)s, (String)lName, (int)i++, (long)unit.fromUser(50.0), (Layer.LayerType)Layer.LayerType.Signal);
            }
            long aLayerThickness = 50L;
            if (type == DeviceTemplate.Type.DIE) {
                aLayerThickness = 50L;
            }
            s.setHeight(Design.micronToInternal((Db)db, (double)((double)i * (double)aLayerThickness)));
        }
        l = s.getTopLayer();
        if (type.equals((Object)DeviceTemplate.Type.PACKAGE)) {
            l = s.getBottomLayer();
        }
        return l;
    }

    private String insureUniqueDeviceName(DeviceTemplate devT, String name, int startIndex, String middle) {
        String deviceName = name;
        int i = startIndex;
        while (devT.getChild(deviceName) != null) {
            deviceName = middle == null || middle.isEmpty() ? String.format("%s%d", name, i) : String.format("%s%s%d", name, middle, i);
            ++i;
        }
        return deviceName;
    }

    public void setPinSizeB(double userSize) {
        this.mPinSizeB = this.mUnit == null ? (long)userSize : this.mUnit.fromUser(userSize);
    }

    public static Device startPackage(String baseTemplateName, String baseInstanceName, long w, long h) {
        Db db = OrbitIO.getCurDb();
        Design currentDesign = Design.getDesign((Db)db);
        Unit.Distance unit = currentDesign.getUnit();
        String substrateName = Substrate.getUniqueName((Db)db, (String)(baseTemplateName + "_Substrate"));
        Substrate s = Substrate.create((Db)db, (String)substrateName);
        s.setSourceType(DeviceTemplate.SourceType.USER);
        s.setHeight(Design.micronToInternal((Db)db, (double)200.0));
        Layer lBall = null;
        s.setSourceType(DeviceTemplate.SourceType.USER);
        Element e = Substrate.getDefaultLayerConfig((String)"package");
        if (e == null) {
            Layer.create((Substrate)s, (String)"WireBondLayer", (int)2, (long)unit.fromUser(25.0)).setType(Layer.LayerType.Jumper);
            Layer.create((Substrate)s, (String)"BondFingerLayer", (int)1, (long)unit.fromUser(50.0)).setType(Layer.LayerType.Signal);
            lBall = Layer.create((Substrate)s, (String)"BallLayer", (int)0, (long)unit.fromUser(50.0));
            lBall.setType(Layer.LayerType.Signal);
        } else {
            int i = 0;
            for (Element el : AXDomUtil.getChildElems((Node)e, (String)"Layer")) {
                String lName = el.getAttribute("name");
                Layer.create((Substrate)s, (String)lName, (int)i++, (long)unit.fromUser(50.0), (Layer.LayerType)Layer.LayerType.Signal);
            }
            s.setHeight(Design.micronToInternal((Db)db, (double)(i * 50)));
            s.getBottomLayer();
        }
        return DeviceFactory.startPackage(s, baseTemplateName, baseInstanceName, w, h);
    }

    public static Device startPackage(Substrate s, String baseTemplateName, String baseInstanceName, long w, long h) {
        Db db = OrbitIO.getCurDb();
        Design currentDesign = Design.getDesign((Db)db);
        Object templateName = baseTemplateName;
        int i = 0;
        boolean changedName = false;
        while (DeviceTemplate.getDeviceTemplate((Substrate)s, (String)templateName) != null) {
            templateName = baseTemplateName + i++;
            changedName = true;
        }
        DeviceTemplate t = new DeviceTemplate((String)templateName, s);
        ARect r = new ARect(-w / 2L, -h / 2L, w - w / 2L, h - h / 2L);
        t.setBounds((AGeom)r);
        t.setSourceType(DeviceTemplate.SourceType.USER);
        t.setIsSynthesized(true);
        t.setType(DeviceTemplate.Type.PACKAGE);
        db.add((DbObject)t);
        Object deviceName = baseInstanceName;
        i = 0;
        changedName = false;
        while (Device.getChildDevice((DeviceTemplate)currentDesign, (String)deviceName) != null) {
            deviceName = baseInstanceName + i++;
            changedName = true;
        }
        if (changedName) {
            ALog.logInfo((String)("Package name changed to " + (String)deviceName));
        }
        Device d = new Device((String)deviceName, (DeviceTemplate)currentDesign, t);
        d.setLoc(new APoint2D(0L, 0L));
        d.setIsPlaced(true);
        d.setSynthesized(true);
        db.add((DbObject)d);
        return d;
    }

    public static void addArrayToPackage(Db db, String deviceKeyStr, long llX, long llY, long pitchX, long pitchY, long xCount, long yCount, String shapeStr, long pinSize, long pinSizeB, long numRings, boolean stagger) {
        DeviceFactory.addArrayToPackage(db, deviceKeyStr, llX, llY, pitchX, pitchY, xCount, yCount, shapeStr, pinSize, pinSizeB, numRings, stagger, 0.0f);
    }

    public static void addArrayToPackage(Db db, String deviceKeyStr, long llX, long llY, long pitchX, long pitchY, long xCount, long yCount, String shapeStr, long pinSize, long pinSizeB, long numRings, boolean stagger, float rotation) {
        Device device = (Device)db.getByKeyStr(Device.class, deviceKeyStr);
        long pinNum = device.getTemplate().getPinCount();
        Net unusedNet = Net.getOrCreate((DeviceTemplate)device.getTemplate(), (String)"NetUnused");
        PadTemplate padT = PadTemplate.create((Db)db, (Substrate)device.getSubstrate(), (String)("PadTemplate_" + device.getName()));
        AOctagon padGeom = null;
        if (shapeStr.equals("Square")) {
            ARect spad = new ARect(0L, 0L, pinSize, pinSize);
            spad.moveCenterTo(0L, 0L);
            padGeom = spad;
        } else if (shapeStr.equals("Octagon")) {
            padGeom = new AOctagon(pinSize / 2L);
        } else if (shapeStr.equals("Rect")) {
            ARect rpad = new ARect(0L, 0L, pinSize, pinSizeB);
            rpad.moveCenterTo(0L, 0L);
            padGeom = rpad;
        } else {
            padGeom = new ACircle(0L, 0L, pinSize / 2L);
        }
        Layer lBall = device.getSubstrate().getBottomLayer();
        LayerShape.create((Db)db, (Layer)lBall, (DbObject)padT, (AGeom)padGeom);
        long maxRingX = xCount - numRings;
        long maxRingY = yCount - numRings;
        long x = llX;
        long y = llY;
        int i = 0;
        while ((long)i < xCount) {
            y = llY + (stagger && i % 2 != 0 ? pitchY : 0L);
            int j = 0;
            while ((long)j < yCount) {
                int jActual = j + (stagger && i % 2 == 1 ? 1 : 0);
                if (numRings <= 0L || (long)i < numRings || (long)i >= maxRingX || (long)jActual < numRings || (long)jActual >= maxRingY) {
                    String pinName = Long.toString(pinNum++);
                    PinTemplate dtp = PinTemplate.create((Net)unusedNet, (String)pinName);
                    dtp.setPadTemplate(padT);
                    dtp.setLoc(new APoint2D(x, y));
                    dtp.setType(PinTemplate.Type.BALLPAD);
                    if ((double)rotation != 0.0) {
                        dtp.setRotate(rotation);
                    }
                    device.getPin(dtp);
                }
                y += pitchY;
                if (stagger) {
                    y += pitchY;
                    if (i % 2 == 1 && (long)(++j) == yCount - 2L) break;
                }
                ++j;
            }
            x += pitchX;
            ++i;
        }
    }

    public static Device makePackage(String baseTemplateName, String baseInstanceName, boolean byNumber, long w, long h, int numRows, int numCols, int rings, int centerRows, int centerCols, long pinSize, long pinDx, long pinDy, AGeomUtil.CompassCorners pinStart, Integer perimeter) {
        return DeviceFactory.makePackage(baseTemplateName, baseInstanceName, byNumber, w, h, numRows, numCols, rings, centerRows, centerCols, pinSize, pinDx, pinDy, pinStart, perimeter, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Device makePackage(String baseTemplateName, String baseInstanceName, boolean byNumber, long w, long h, int numRows, int numCols, int rings, int centerRows, int centerCols, long pinSize, long pinDx, long pinDy, AGeomUtil.CompassCorners pinStart, Integer perimeter, boolean fc) {
        int[] nArray;
        long y;
        long x;
        long startX;
        long edgeY;
        long edgeX;
        long dy;
        long dx;
        int i;
        int pinCount = 0;
        Db db = OrbitIO.getCurDb();
        Design currentDesign = Design.getDesign((Db)db);
        Unit.Distance unit = currentDesign.getUnit();
        String substrateName = Substrate.getUniqueName((Db)db, (String)(baseTemplateName + "_Substrate"));
        Substrate s = Substrate.create((Db)db, (String)substrateName);
        s.setSourceType(DeviceTemplate.SourceType.USER);
        s.setHeight(Design.micronToInternal((Db)db, (double)200.0));
        Layer lBall = null;
        if (fc) {
            Layer.create((Substrate)s, (String)"Bump", (int)4, (long)Design.micronToInternal((Db)db, (double)10.0));
            Layer.create((Substrate)s, (String)"Route1", (int)3, (long)Design.micronToInternal((Db)db, (double)10.0));
            Layer.create((Substrate)s, (String)"Route2", (int)2, (long)Design.micronToInternal((Db)db, (double)10.0));
            Layer.create((Substrate)s, (String)"Route3", (int)1, (long)Design.micronToInternal((Db)db, (double)10.0));
            lBall = Layer.create((Substrate)s, (String)"BallLayer", (int)0, (long)Design.micronToInternal((Db)db, (double)10.0));
        } else {
            s.setSourceType(DeviceTemplate.SourceType.USER);
            Element e = Substrate.getDefaultLayerConfig((String)"package");
            if (e == null) {
                Layer.create((Substrate)s, (String)"WireBondLayer", (int)2, (long)unit.fromUser(25.0)).setType(Layer.LayerType.Jumper);
                Layer.create((Substrate)s, (String)"BondFingerLayer", (int)1, (long)unit.fromUser(50.0)).setType(Layer.LayerType.Signal);
                lBall = Layer.create((Substrate)s, (String)"BallLayer", (int)0, (long)unit.fromUser(50.0));
                lBall.setType(Layer.LayerType.Signal);
            } else {
                i = 0;
                for (Element el : AXDomUtil.getChildElems((Node)e, (String)"Layer")) {
                    String lName = el.getAttribute("name");
                    Layer.create((Substrate)s, (String)lName, (int)i++, (long)unit.fromUser(50.0), (Layer.LayerType)Layer.LayerType.Signal);
                }
                s.setHeight(Design.micronToInternal((Db)db, (double)((double)i * 50.0)));
                lBall = s.getBottomLayer();
            }
        }
        Object templateName = baseTemplateName;
        i = 0;
        boolean changedName = false;
        while (DeviceTemplate.getDeviceTemplate((Substrate)s, (String)templateName) != null) {
            templateName = baseTemplateName + i++;
            changedName = true;
        }
        DeviceTemplate t = new DeviceTemplate((String)templateName, s);
        ARect r = new ARect(-w / 2L, -h / 2L, w - w / 2L, h - h / 2L);
        t.setBounds((AGeom)r);
        t.setSourceType(DeviceTemplate.SourceType.USER);
        t.setIsSynthesized(true);
        t.setType(DeviceTemplate.Type.PACKAGE);
        db.add((DbObject)t);
        Object deviceName = baseInstanceName;
        i = 0;
        changedName = false;
        while (Device.getChildDevice((DeviceTemplate)currentDesign, (String)deviceName) != null) {
            deviceName = baseInstanceName + i++;
            changedName = true;
        }
        if (changedName) {
            ALog.logInfo((String)("Package name changed to " + (String)deviceName));
        }
        Device d = new Device((String)deviceName, (DeviceTemplate)currentDesign, t);
        d.setLoc(new APoint2D(0L, 0L));
        d.setIsPlaced(true);
        d.setSynthesized(true);
        db.add((DbObject)d);
        PadTemplate pt = PadTemplate.create((Db)db, (Substrate)d.getSubstrate(), (String)("PackagePadTemplate" + Long.toString(pinSize)));
        ACircle cpad = new ACircle(0L, 0L, pinSize);
        LayerShape.create((Db)db, (Layer)lBall, (DbObject)pt, (AGeom)cpad);
        if (numRows == 0 && numCols == 0) {
            return d;
        }
        if (!byNumber) {
            if (pinDx == 0L || pinDy == 0L) return d;
            if (perimeter == null) {
                numRows = (int)(h / pinDy);
                numCols = (int)(w / pinDx);
                dx = pinDx;
                dy = pinDy;
                edgeX = (w - (long)(numCols - 1) * dx) / 2L;
                edgeY = (h - (long)(numRows - 1) * dy) / 2L;
            } else {
                numRows = (int)((h - ((long)perimeter.intValue() - pinSize / 2L) * 2L) / pinDy);
                numCols = (int)((w - ((long)perimeter.intValue() - pinSize / 2L) * 2L) / pinDx);
                dx = pinDx;
                dy = pinDy;
                edgeX = (long)perimeter.intValue() + pinSize;
                edgeY = (long)perimeter.intValue() + pinSize;
            }
            ALog.logInfo((String)("There are " + numRows + " rows and " + numCols + " columns"));
        } else {
            dx = w / (long)(numCols + 1);
            dy = h / (long)(numRows + 1);
            dx = unit.fromUser((double)((long)unit.toUser(dx)));
            dy = unit.fromUser((double)((long)unit.toUser(dy)));
            if (perimeter == null) {
                edgeX = dx;
                edgeY = dy;
            } else {
                edgeX = perimeter.intValue();
                edgeY = perimeter.intValue();
            }
            ALog.logInfo((String)("Ball spacing: " + dx / Design.micronToInternal((Db)db, (double)1.0) + " by " + dy / Design.micronToInternal((Db)db, (double)1.0)));
        }
        if (rings >= 0 && numCols < rings * 2 + centerCols) {
            ALog.logError((String)"Column count is less than %d needed to create %d rings and %d center columns.", (Object[])new Object[]{rings * 2 + centerCols, rings, centerCols});
            return d;
        }
        if (rings >= 0 && numRows < rings * 2 + centerRows) {
            ALog.logError((String)"Row count is less than %d needed to create %d rings and %d center rows.", (Object[])new Object[]{rings * 2 + centerRows, rings, centerRows});
            return d;
        }
        if (pinStart == AGeomUtil.CompassCorners.NW) {
            dy = -dy;
            x = startX = -w / 2L + edgeX;
            y = h - h / 2L - edgeY;
        } else if (pinStart == AGeomUtil.CompassCorners.NE) {
            dx = -dx;
            dy = -dy;
            x = startX = w - w / 2L - edgeX;
            y = h - h / 2L - edgeY;
        } else if (pinStart == AGeomUtil.CompassCorners.SE) {
            dx = -dx;
            x = startX = w - w / 2L - edgeX;
            y = -h / 2L + edgeY;
        } else {
            if (pinStart != AGeomUtil.CompassCorners.SW) return d;
            x = startX = -w / 2L + edgeX;
            y = -h / 2L + edgeY;
        }
        if (byNumber) {
            long offset = startX + dx * (long)(numCols / 2 - 1);
            offset = numCols % 2 == 0 ? (offset += dx / 2L) : (offset += dx);
            x -= offset;
            startX -= offset;
            offset = y + dy * (long)(numRows / 2 - 1);
            offset = numRows % 2 == 0 ? (offset += dy / 2L) : (offset += dy);
            y -= offset;
        }
        Net unusedNet = Net.getOrCreate((DeviceTemplate)t, (String)"NetUnused");
        String jedecAlphabet = "ABCDEFGHJKLMNPRTUVWY";
        long alphabetLen = jedecAlphabet.length();
        Object rowBase = "";
        Object rowString = "";
        int rowChar = 0;
        if (rings < 0) {
            nArray = null;
        } else {
            int[] nArray2 = new int[4];
            nArray2[0] = (numRows - centerRows + 1) / 2 + 1;
            nArray2[1] = (numRows - centerRows + 1) / 2 + centerRows;
            nArray2[2] = (numCols - centerCols + 1) / 2 + 1;
            nArray = nArray2;
            nArray2[3] = (numCols - centerCols + 1) / 2 + centerCols;
        }
        int[] centerRang = nArray;
        long[] centerOffset = new long[]{(numRows - centerRows) % 2 == 0 ? 0L : dy / 2L, (numCols - centerCols) % 2 == 0 ? 0L : dx / 2L};
        for (int row = 1; row <= numRows; ++row) {
            rowString = (String)rowBase + jedecAlphabet.charAt(rowChar);
            boolean centerPort = false;
            for (int col = 1; col <= numCols; ++col) {
                int thisOuterRow = Math.min(row, numRows - row + 1);
                int thisOuterCol = Math.min(col, numCols - col + 1);
                int thisOuterRing = Math.min(thisOuterRow, thisOuterCol);
                centerPort = centerRang != null && row >= centerRang[0] && row <= centerRang[1] && col >= centerRang[2] && col <= centerRang[3];
                if (rings == -1 || thisOuterRing <= rings || centerPort) {
                    String pinName = (String)rowString + Integer.toString(col);
                    PinTemplate dtp = PinTemplate.create((Net)unusedNet, (String)pinName);
                    dtp.setPadTemplate(pt);
                    if (centerPort) {
                        dtp.setLoc(new APoint2D(x - centerOffset[1], y - centerOffset[0]));
                    } else {
                        dtp.setLoc(new APoint2D(x, y));
                    }
                    dtp.setType(PinTemplate.Type.BALLPAD);
                    PinInstance dp = PinInstance.getPinInstance((Device)d, (PinTemplate)dtp);
                    dp.setPinInstanceName(pinName);
                    ++pinCount;
                }
                x += dx;
            }
            if ((long)(++rowChar) >= alphabetLen) {
                rowChar = 0;
                int index = (int)((long)row / alphabetLen) - 1;
                rowBase = index >= jedecAlphabet.length() ? "" + row : "" + jedecAlphabet.charAt(index);
            }
            x = startX;
            y += dy;
        }
        ALog.logInfo((String)"%d pins were created", (Object[])new Object[]{pinCount});
        return d;
    }
}

