/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.factory;

import bsh.EvalError;
import bsh.Interpreter;
import com.sigrity.acl.AGridUtil;
import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.ATransformUtil;
import com.sigrity.acl.FilteringIterator;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.StreamIterableIterator;
import com.sigrity.acl.app.Settings;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.AGeomUtil;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.topology.Binner;
import com.sigrity.acl.xml.AXDomUtil;
import com.sigrity.lic.LSession;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.Personalities;
import com.sigrity.orbit.automation.BumpFactoryData;
import com.sigrity.orbit.automation.BumpRatioOptimizer;
import com.sigrity.orbit.automation.placement.PlaceableFactory;
import com.sigrity.orbit.automation.placement.PlaceableItem;
import com.sigrity.orbit.ui.DeleteDeviceUI;
import com.sigrity.orbit.ui.ExternalDeviceUpdateListener;
import java.awt.geom.AffineTransform;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DeviceMatrixFactory {
    public static final String FLD_FACTORY_CREATED = "DeviceMatrixFactory.created";
    public static final String SettingSection = DeviceMatrixFactory.class.getName();
    public static final String SettingShortNames = "UseShortNames";
    public static boolean SettingShortNamesDflt = true;
    public static final String DEFAULT_BUMP_BASENAME = "Bump";
    public static final String DEFAULT_BALL_BASENAME = "Ball";
    public static final String DEFAULT_PIN_BASENAME = "Pin";
    public static final String RatioDriveShorted = "RatioDrivenShorted";
    protected DeviceTemplate mMatrixOwner;
    protected PlaceableFactory<DbObject> mPlaceableFactory;
    protected String mBumpBaseName = "Bump";
    protected boolean mBumpNameIsScript = false;
    protected float mItemRotation = 0.0f;
    protected boolean mItemMirror = false;
    protected boolean mStagger = false;
    protected long mCornerKeepoutX = 0L;
    protected long mCornerKeepoutY = 0L;
    protected ARect[] mCornerKeepouts = null;
    protected long mShiftL = 0L;
    protected long mShiftR = 0L;
    protected long mShiftT = 0L;
    protected long mShiftB = 0L;
    protected float mRotateL = 0.0f;
    protected float mRotateR = 0.0f;
    protected float mRotateT = 0.0f;
    protected float mRotateB = 0.0f;
    protected long mPadR = 0L;
    protected long mPadT = 0L;
    protected long mPadL = 0L;
    protected long mPadB = 0L;
    protected Interpreter mInterpreter = null;
    protected PlaceableItem<DbObject> mLastPlacedBumpDevice = null;
    private final Map<Layer, Binner<APair<ARect, HierInst<?>>>> mPlacedBumpMap = new HashMap();
    protected int mNumIO;
    protected long width;
    protected long height;
    protected String ratioInstructions;
    protected String customName;
    protected String coverDeviceKeyStr = null;
    protected long minPitch;
    protected long xPitch;
    protected long yPitch;
    protected int totalBumps;
    protected boolean optimize;
    protected long leftKeepout;
    protected long rightKeepout;
    protected long bottomKeepout;
    protected long topKeepout;
    protected int mNextBumpNameSuffix = 0;
    protected long mNextSuffix = -1L;

    public DeviceMatrixFactory(Db db, String ownerTemplateKeyStr) throws LSession.NoLicenseException {
        this.mMatrixOwner = (DeviceTemplate)db.getByKeyStr(DeviceTemplate.class, ownerTemplateKeyStr);
        if (this.mMatrixOwner == null) {
            ALog.logError((String)"There is no DeviceTemplate named '%s'.", (Object[])new Object[]{ownerTemplateKeyStr});
        }
        this.preparePlacedBumps();
    }

    private void preparePlacedBumps() {
        if (this.mMatrixOwner == null) {
            return;
        }
        Db db = this.mMatrixOwner.getDb();
        ARect localBound = this.mMatrixOwner.getBounds(true).getBounds();
        for (Layer l : db.getObjects(Layer.class)) {
            Binner binner = new Binner();
            binner.setWorld(localBound);
            this.mPlacedBumpMap.put(l, binner);
        }
        int load = 0;
        for (DevicePath relPath : this.mMatrixOwner.getDescendantOnSubstrate()) {
            DeviceTemplate dt = relPath.getDeviceTemplate();
            if (dt.getType() != DeviceTemplate.Type.BUMP) continue;
            ARect relBB = relPath.getBB();
            for (Layer layer : new StreamIterableIterator(dt.getLayersInUse())) {
                Binner<APair<ARect, HierInst<?>>> binner = this.mPlacedBumpMap.get(layer);
                binner.insert((Object)new APair((Object)relBB, (Object)new HierInst(relPath.getParent(), (DbObject)relPath.getDevice())), new ARect(relBB.center(), relBB.center()));
            }
            ++load;
        }
        for (HierInst hierPinT : this.mMatrixOwner.getPinsAndDescendants(true)) {
            PinTemplate pinT = (PinTemplate)hierPinT.getDbObject();
            if (pinT.getType() != PinTemplate.Type.BUMPPAD) continue;
            DevicePath relPath = hierPinT.getPath();
            ARect relBB = relPath.getBBOfChildObj(hierPinT.getDbObject(), false);
            for (Layer layer : new StreamIterableIterator(pinT.getLayersInUse())) {
                Binner<APair<ARect, HierInst<?>>> binner = this.mPlacedBumpMap.get(layer);
                binner.insert((Object)new APair((Object)relBB, (Object)hierPinT), new ARect(relBB.center(), relBB.center()));
            }
            ++load;
        }
        ALog.logDebug((String)"Load %d placed bumps", (Object[])new Object[]{load});
    }

    public void setPlaceableFactory(PlaceableFactory<DbObject> placeableFactory) {
        this.mPlaceableFactory = placeableFactory;
    }

    public void setBumpBaseName(String baseName) {
        this.mBumpBaseName = baseName;
    }

    public void setBumpNameIsScript(boolean b) {
        this.mBumpNameIsScript = b;
    }

    public void setItemRotation(float f) {
        this.mItemRotation = f;
    }

    public void setItemMirror(boolean mirror) {
        this.mItemMirror = mirror;
    }

    public void setCornerKeepouts(long x, long y) {
        this.mCornerKeepoutX = x;
        this.mCornerKeepoutY = y;
    }

    public void setStagger(boolean b) {
        this.mStagger = b;
    }

    public void setShift(long left, long right, long top, long bottom) {
        this.mShiftL = left;
        this.mShiftR = right;
        this.mShiftT = top;
        this.mShiftB = bottom;
    }

    public void setRotate(float left, float right, float top, float bottom) {
        this.mRotateL = left;
        this.mRotateR = right;
        this.mRotateT = top;
        this.mRotateB = bottom;
    }

    public void setPadding(long left, long right, long top, long bottom) {
        this.mPadL = left;
        this.mPadR = right;
        this.mPadT = top;
        this.mPadB = bottom;
    }

    private BumpFactoryData createCenterMatrixBumpFactoryData(DeviceTemplate groupTmplt, int cols, int rows, long dx, long dy) {
        BumpFactoryData bfd = BumpFactoryData.getForTemplate((DeviceTemplate)groupTmplt, (boolean)true);
        bfd.setFactoryType(BumpFactoryData.BumpFactoryType.CENTER_MATRIX);
        bfd.setBumpBaseName(this.mBumpBaseName);
        bfd.setBumpNameIsScript(this.mBumpNameIsScript);
        bfd.setCornerKeepoutX(this.mCornerKeepoutX);
        bfd.setCornerKeepoutY(this.mCornerKeepoutY);
        bfd.setPaddingR(this.mPadR);
        bfd.setPaddingT(this.mPadT);
        bfd.setPaddingL(this.mPadL);
        bfd.setPaddingB(this.mPadB);
        bfd.setDx(dx);
        bfd.setDy(dy);
        bfd.setRows(rows);
        bfd.setCols(cols);
        bfd.setStagger(this.mStagger);
        bfd.setMinPitch(this.minPitch);
        return bfd;
    }

    public Device createCenterMatrix(int cols, int rows, long dx, long dy) {
        if (this.mPlaceableFactory == null) {
            ALog.logError((String)"PlaceableFactory not set in DeviceMatrix factory before calling createCenterMatrix().");
            return null;
        }
        ARect itemBounds = this.mPlaceableFactory.getTransformedItemBounds(this.mItemMirror, this.mItemRotation);
        long bw = itemBounds.width();
        long bh = itemBounds.height();
        long w = (long)(cols - 1) * dx + bw;
        long h = (long)(rows - 1) * dy + bh;
        ARect bounds = new ARect(-w / 2L, -h / 2L, w / 2L, h / 2L);
        if (this.mStagger) {
            bounds.expandBy(dx / 4L, 0L, dx / 4L, 0L);
        }
        APoint2D loc = new APoint2D(this.mMatrixOwner.getBB().center());
        boolean shortNames = (Boolean)Settings.get((String)SettingSection, (String)SettingShortNames, (Object)SettingShortNamesDflt);
        Device groupDevice = this.prepareToPlaceBumps(loc, bounds, shortNames ? "Center" : "CenterMatrix");
        DeviceTemplate groupTmplt = groupDevice.getTemplate();
        ARect btbounds = this.mPlaceableFactory.getTransformedItemBounds(this.mItemMirror, this.mItemRotation);
        long startX = -btbounds.getLL().getX() - w / 2L - (this.mStagger ? dx / 4L : 0L);
        long startY = -btbounds.getLL().getY() - h / 2L;
        int placed = 0;
        for (int row = 0; row < rows; ++row) {
            long y = startY + (long)row * dy;
            long stagger = this.mStagger ? (long)(row % 2) * dx / 2L : 0L;
            for (int col = 0; col < cols; ++col) {
                long x = startX + (long)col * dx + stagger;
                if (!this.placeBump(groupDevice, groupTmplt, x, y, 0.0f, placed, this.mMatrixOwner.getType())) continue;
                ++placed;
            }
        }
        this.addPadding(groupDevice);
        ALog.logInfo((String)"Placed %d %ss.", (Object[])new Object[]{placed, this.mPlaceableFactory.getItemDescription()});
        this.donePlacingBumps();
        BumpFactoryData bfd = this.createCenterMatrixBumpFactoryData(groupTmplt, cols, rows, dx, dy);
        this.mPlaceableFactory.storeParameters(bfd);
        OrbitIO.refreshViewsOf((DbObject)groupDevice);
        return groupDevice;
    }

    public Device createCenterMatrix(long clearL, long clearR, long clearT, long clearB, long dx, long dy) {
        ARect dieBounds = this.mMatrixOwner.getBB();
        ARect clearBounds = dieBounds.copy();
        APoint2D dieCenter = clearBounds.center();
        for (Device bumpCoverCell : DeviceMatrixFactory.getBumpCoverCells(this.mMatrixOwner)) {
            DeviceTemplate dt = bumpCoverCell.getTemplate();
            BumpFactoryData bfd = BumpFactoryData.getForTemplate((DeviceTemplate)dt, (boolean)false);
            if (!bfd.isPeripheral()) continue;
            DevicePath die2Cover = new DevicePath(this.mMatrixOwner, bumpCoverCell);
            block7: for (Device d : dt.getChildren()) {
                ARect r = d.getBB().transform(die2Cover.getTransform()).getBounds();
                switch (AGeomUtil.getQuadrant((APoint2D)r.center(), (ARect)dieBounds)) {
                    case 0: {
                        if (r.left() >= clearBounds.right()) continue block7;
                        clearBounds.right(r.left());
                        continue block7;
                    }
                    case 1: {
                        if (r.bottom() >= clearBounds.top()) continue block7;
                        clearBounds.top(r.bottom());
                        continue block7;
                    }
                    case 2: {
                        if (r.right() <= clearBounds.left()) continue block7;
                        clearBounds.left(r.right());
                        continue block7;
                    }
                    case 3: {
                        if (r.top() <= clearBounds.bottom()) continue block7;
                        clearBounds.bottom(r.top());
                        continue block7;
                    }
                }
                assert (false);
            }
        }
        long staggerAdj = this.mStagger ? dx / 2L : 0L;
        ARect itemBounds = this.mPlaceableFactory.getTransformedItemBounds(this.mItemMirror, this.mItemRotation);
        long itemWidth = itemBounds.width();
        long itemHeight = itemBounds.height();
        long xBorder = clearL + clearR;
        long xCount = (clearBounds.width() - xBorder - itemWidth - staggerAdj) / dx + 1L;
        long width = dx * (xCount - 1L) + itemWidth + staggerAdj;
        long yBorder = clearT + clearB;
        long yCount = (clearBounds.height() - yBorder - itemHeight) / dy + 1L;
        long height = dy * (yCount - 1L) + itemHeight;
        long xExtra = clearBounds.width() - width - xBorder;
        long xExtraL = (long)((double)xExtra * ((double)clearL / (double)xBorder));
        long left = clearL + xExtraL;
        long yExtra = clearBounds.height() - height - yBorder;
        long yExtraB = (long)((double)yExtra * ((double)clearB / (double)yBorder));
        long bottom = clearB + yExtraB;
        long l = -clearBounds.width() / 2L + left;
        long b = -clearBounds.height() / 2L + bottom;
        ARect bounds = new ARect(l, b, l + width, b + height);
        boolean shortNames = (Boolean)Settings.get((String)SettingSection, (String)SettingShortNames, (Object)SettingShortNamesDflt);
        Device groupDevice = this.prepareToPlaceBumps(dieCenter, bounds, shortNames ? "Center" : "CenterMatrix");
        DeviceTemplate groupTmplt = groupDevice.getTemplate();
        ARect btbounds = this.mPlaceableFactory.getTransformedItemBounds(this.mItemMirror, this.mItemRotation);
        long startX = -btbounds.getLL().getX();
        long startY = -btbounds.getLL().getY();
        int placed = 0;
        int row = 0;
        while ((long)row < yCount) {
            long y = bounds.bottom() + startY + (long)row * dy;
            long stagger = this.mStagger ? (long)(row % 2) * dx / 2L : 0L;
            int col = 0;
            while ((long)col < xCount) {
                long x = bounds.left() + startX + (long)col * dx + stagger;
                if (this.placeBump(groupDevice, groupTmplt, x, y, 0.0f, placed, this.mMatrixOwner.getType())) {
                    ++placed;
                }
                ++col;
            }
            ++row;
        }
        this.addPadding(groupDevice);
        ALog.logInfo((String)"Placed %d center %ss in %d columns and %d rows.", (Object[])new Object[]{placed, this.mPlaceableFactory.getItemDescription(), xCount, yCount});
        this.donePlacingBumps();
        BumpFactoryData bfd = this.createCenterMatrixBumpFactoryData(groupTmplt, -1, -1, dx, dy);
        bfd.setEdgeClearL(clearL);
        bfd.setEdgeClearR(clearR);
        bfd.setEdgeClearT(clearT);
        bfd.setEdgeClearB(clearB);
        this.mPlaceableFactory.storeParameters(bfd);
        OrbitIO.refreshViewsOf((DbObject)groupDevice);
        return groupDevice;
    }

    public Device createPeripheralMatrix(int rings, long dieEdgeClearL, long dieEdgeClearR, long dieEdgeClearT, long dieEdgeClearB, long dx, long dy) {
        ARect dieBB = this.mMatrixOwner.getBB();
        ARect itemBounds = this.mPlaceableFactory.getTransformedItemBounds(this.mItemMirror, this.mItemRotation);
        long itemWidth = itemBounds.width();
        long itemHeight = itemBounds.height();
        long staggerAdj = this.mStagger ? dx / 2L : 0L;
        long xBorder = dieEdgeClearL + dieEdgeClearR;
        long xCount = (dieBB.width() - xBorder - itemWidth - staggerAdj) / dx + 1L;
        long width = dx * (xCount - 1L) + itemWidth + staggerAdj;
        long yBorder = dieEdgeClearT + dieEdgeClearB;
        long yCount = (dieBB.height() - yBorder - itemHeight) / dy + 1L;
        long height = dy * (yCount - 1L) + itemHeight;
        long xExtra = dieBB.width() - width - xBorder;
        long xExtraL = (long)((double)xExtra * ((double)dieEdgeClearL / (double)xBorder));
        long left = dieEdgeClearL + xExtraL;
        long yExtra = dieBB.height() - height - yBorder;
        long yExtraB = (long)((double)yExtra * ((double)dieEdgeClearB / (double)yBorder));
        long bottom = dieEdgeClearB + yExtraB;
        long l = -dieBB.width() / 2L + left;
        long b = -dieBB.height() / 2L + bottom;
        ARect bounds = new ARect(l, b, l + width, b + height);
        APoint2D loc = dieBB.center();
        boolean shortNames = (Boolean)Settings.get((String)SettingSection, (String)SettingShortNames, (Object)SettingShortNamesDflt);
        Device groupDevice = this.prepareToPlaceBumps(loc, bounds, shortNames ? "PeriMatrix" : "PeripheralMatrix");
        DeviceTemplate groupTmplt = groupDevice.getTemplate();
        ARect btbounds = this.mPlaceableFactory.getTransformedItemBounds(this.mItemMirror, this.mItemRotation);
        long startX = -btbounds.getLL().getX();
        long startY = -btbounds.getLL().getY();
        int placed = 0;
        int row = 0;
        while ((long)row < yCount) {
            long y = bounds.bottom() + startY + (long)row * dy;
            long stagger = this.mStagger ? (long)(row % 2) * dx / 2L : 0L;
            int col = 0;
            while ((long)col < xCount) {
                long x = bounds.left() + startX + (long)col * dx + stagger;
                if ((col < rings || (long)col >= xCount - (long)rings || row < rings || (long)row >= yCount - (long)rings) && this.placeBump(groupDevice, groupTmplt, x, y, 0.0f, placed, this.mMatrixOwner.getType())) {
                    ++placed;
                }
                ++col;
            }
            ++row;
        }
        this.addPadding(groupDevice);
        ALog.logInfo((String)"Placed %d peripheral matrix %ss.", (Object[])new Object[]{placed, this.mPlaceableFactory.getItemDescription()});
        this.donePlacingBumps();
        BumpFactoryData bfd = BumpFactoryData.getForTemplate((DeviceTemplate)groupTmplt, (boolean)true);
        bfd.setFactoryType(BumpFactoryData.BumpFactoryType.PERIPHERAL_MATRIX);
        this.mPlaceableFactory.storeParameters(bfd);
        bfd.setBumpBaseName(this.mBumpBaseName);
        bfd.setBumpNameIsScript(this.mBumpNameIsScript);
        bfd.setCornerKeepoutX(this.mCornerKeepoutX);
        bfd.setCornerKeepoutY(this.mCornerKeepoutY);
        bfd.setPaddingR(this.mPadR);
        bfd.setPaddingT(this.mPadT);
        bfd.setPaddingL(this.mPadL);
        bfd.setPaddingB(this.mPadB);
        bfd.setDx(dx);
        bfd.setDy(dy);
        bfd.setRows(0);
        bfd.setCols(rings);
        bfd.setEdgeClearL(dieEdgeClearL);
        bfd.setEdgeClearR(dieEdgeClearR);
        bfd.setEdgeClearT(dieEdgeClearT);
        bfd.setEdgeClearB(dieEdgeClearB);
        bfd.setStagger(this.mStagger);
        OrbitIO.refreshViewsOf((DbObject)groupDevice);
        return groupDevice;
    }

    public Device createPeripheralRings(int rings, long dieEdgeClearL, long dieEdgeClearR, long dieEdgeClearT, long dieEdgeClearB, long bumpPitch, long ringPitch) {
        ARect bounds = new ARect(this.mMatrixOwner.getBB());
        bounds.expandBy(dieEdgeClearL, dieEdgeClearB, dieEdgeClearR, dieEdgeClearT);
        APoint2D loc = new APoint2D(0L, 0L);
        boolean shortNames = (Boolean)Settings.get((String)SettingSection, (String)SettingShortNames, (Object)SettingShortNamesDflt);
        Device groupDevice = this.prepareToPlaceBumps(loc, bounds, shortNames ? "PeriRings" : "PeripheralRings");
        DeviceTemplate groupTmplt = groupDevice.getTemplate();
        int placed = 0;
        for (int ring = 0; ring < rings; ++ring) {
            long x;
            long start;
            long y;
            long start2;
            long stagger = this.mStagger ? bumpPitch / (long)rings * (long)ring : 0L;
            Object first = null;
            Object previous = null;
            ARect bb = this.mPlaceableFactory.getTransformedItemBounds(this.mItemMirror, this.mItemRotation + this.mRotateB);
            for (long x2 = start2 = AGridUtil.getValidSpacingGTE((long)(bounds.left() - bb.getLL().getX()), (long)bumpPitch, (long)(bounds.centerX() + stagger + this.mShiftB)); x2 < bounds.right() - bb.width(); x2 += bumpPitch) {
                long y2 = bounds.bottom() - bb.getLL().getY();
                if (this.placeBump(groupDevice, groupTmplt, x2, y2, this.mRotateB, placed, this.mMatrixOwner.getType())) {
                    ++placed;
                }
                if (first != null) continue;
                first = previous;
            }
            bb = this.mPlaceableFactory.getTransformedItemBounds(this.mItemMirror, this.mItemRotation + this.mRotateR);
            boolean checkPrev = true;
            for (y = start = AGridUtil.getValidSpacingGTE((long)bounds.bottom(), (long)bumpPitch, (long)(bounds.centerY() + stagger + this.mShiftR)); y < bounds.top() - bb.height(); y += bumpPitch) {
                x = bounds.right() - bb.getLL().getX() - bb.width();
                if (checkPrev) {
                    if (previous != null && previous.getLoc().distance(x, y) < bumpPitch) continue;
                    checkPrev = false;
                }
                if (!this.placeBump(groupDevice, groupTmplt, x, y, this.mRotateR, placed, this.mMatrixOwner.getType())) continue;
                ++placed;
            }
            bb = this.mPlaceableFactory.getTransformedItemBounds(this.mItemMirror, this.mItemRotation + this.mRotateT);
            checkPrev = true;
            for (long x3 = start = AGridUtil.getValidSpacingGTE((long)(bounds.right() - bb.width() - bb.getLL().getX()), (long)bumpPitch, (long)(bounds.centerX() - stagger - this.mShiftT)); x3 > bounds.left() + bb.width(); x3 -= bumpPitch) {
                long y3 = bounds.top() - bb.getLL().getY() - bb.height();
                if (checkPrev) {
                    if (previous != null && previous.getLoc().distance(x3, y3) < bumpPitch) continue;
                    checkPrev = false;
                }
                if (!this.placeBump(groupDevice, groupTmplt, x3, y3, this.mRotateT, placed, this.mMatrixOwner.getType())) continue;
                ++placed;
            }
            bb = this.mPlaceableFactory.getTransformedItemBounds(this.mItemMirror, this.mItemRotation + this.mRotateL);
            checkPrev = true;
            for (y = start = AGridUtil.getValidSpacingGTE((long)(bounds.top() - bb.height() - bb.getLL().getY()), (long)bumpPitch, (long)(bounds.centerY() - stagger - this.mShiftL)); y > bounds.bottom() + bb.height(); y -= bumpPitch) {
                x = bounds.left() - bb.getLL().getX();
                if (checkPrev) {
                    if (previous != null && previous.getLoc().distance(x, y) < bumpPitch) continue;
                    checkPrev = false;
                }
                if (first != null && first.getLoc().distance(x, y) < bumpPitch || !this.placeBump(groupDevice, groupTmplt, x, y, this.mRotateL, placed, this.mMatrixOwner.getType())) continue;
                ++placed;
            }
            bounds.grow(-ringPitch);
        }
        this.addPadding(groupDevice);
        ALog.logInfo((String)"Placed %d peripheral ring %ss.", (Object[])new Object[]{placed, this.mPlaceableFactory.getItemDescription()});
        this.donePlacingBumps();
        BumpFactoryData bfd = BumpFactoryData.getForTemplate((DeviceTemplate)groupTmplt, (boolean)true);
        bfd.setFactoryType(BumpFactoryData.BumpFactoryType.PERIPHERAL_RINGS);
        this.mPlaceableFactory.storeParameters(bfd);
        bfd.setDx(bumpPitch);
        bfd.setDy(ringPitch);
        bfd.setRows(0);
        bfd.setCols(rings);
        bfd.setEdgeClearL(dieEdgeClearL);
        bfd.setEdgeClearR(dieEdgeClearR);
        bfd.setEdgeClearT(dieEdgeClearT);
        bfd.setEdgeClearB(dieEdgeClearB);
        bfd.setStagger(this.mStagger);
        bfd.setShiftL(this.mShiftL);
        bfd.setShiftR(this.mShiftR);
        bfd.setShiftT(this.mShiftT);
        bfd.setShiftB(this.mShiftB);
        bfd.setRotateL(this.mRotateL);
        bfd.setRotateR(this.mRotateR);
        bfd.setRotateT(this.mRotateT);
        bfd.setRotateB(this.mRotateB);
        OrbitIO.refreshViewsOf((DbObject)groupDevice);
        return groupDevice;
    }

    public long getLeftKeepout() {
        return this.leftKeepout;
    }

    public void setLeftKeepout(long leftKeepout) {
        this.leftKeepout = leftKeepout;
    }

    public long getRightKeepout() {
        return this.rightKeepout;
    }

    public void setRightKeepout(long rightKeepout) {
        this.rightKeepout = rightKeepout;
    }

    public long getBottomKeepout() {
        return this.bottomKeepout;
    }

    public void setBottomKeepout(long bottomKeepout) {
        this.bottomKeepout = bottomKeepout;
    }

    public long getTopKeepout() {
        return this.topKeepout;
    }

    public void setTopKeepout(long topKeepout) {
        this.topKeepout = topKeepout;
    }

    public long getWidth() {
        return this.width;
    }

    public void setWidth(long width) {
        this.width = width;
    }

    public void setNumIO(int numIO) {
        this.mNumIO = numIO;
    }

    public long getHeight() {
        return this.height;
    }

    public void setHeight(long height) {
        this.height = height;
    }

    public String getRatioInstructions() {
        return this.ratioInstructions;
    }

    public void setRatioInstructions(String ratioInstructions) {
        this.ratioInstructions = ratioInstructions;
    }

    public void setCustomName(String name) {
        this.customName = name;
    }

    public void setDeviceKeyStr(String name) {
        this.coverDeviceKeyStr = name;
    }

    public void setMinPitch(long pitch) {
        this.minPitch = pitch;
    }

    public void setXPitch(long pitch) {
        this.xPitch = pitch;
    }

    public void setYPitch(long pitch) {
        this.yPitch = pitch;
    }

    public void setTotalBumps(int num) {
        this.totalBumps = num;
    }

    public void setOptimize(boolean optimize) {
        this.optimize = optimize;
    }

    public Long calcXPitch() {
        long startPitch;
        Db db = this.mMatrixOwner.getDb();
        long lastPitch = startPitch = Design.micronToInternal((Db)db, (double)5.0);
        long pitchMax = Design.micronToInternal((Db)db, (double)1000.0);
        long pitchIncr = Design.micronToInternal((Db)db, (double)1.0);
        for (long xPitch = startPitch; xPitch < pitchMax; xPitch += pitchIncr) {
            if (this.canFit(this.totalBumps, this.leftKeepout, this.rightKeepout, this.bottomKeepout, this.topKeepout, xPitch, this.yPitch, this.width, this.height) == null) {
                return lastPitch;
            }
            lastPitch = xPitch;
        }
        return lastPitch;
    }

    public Long calcYPitch() {
        long startPitch;
        Db db = this.mMatrixOwner.getDb();
        long lastPitch = startPitch = Design.micronToInternal((Db)db, (double)5.0);
        long pitchMax = Design.micronToInternal((Db)db, (double)1000.0);
        long pitchIncr = Design.micronToInternal((Db)db, (double)1.0);
        for (long yPitch = startPitch; yPitch < pitchMax; yPitch += pitchIncr) {
            if (this.canFit(this.totalBumps, this.leftKeepout, this.rightKeepout, this.bottomKeepout, this.topKeepout, this.xPitch, yPitch, this.width, this.height) == null) {
                return lastPitch;
            }
            lastPitch = yPitch;
        }
        return lastPitch;
    }

    public Integer calcTotalBumps() {
        int maxBumps = 100000;
        int lastBumpCount = 0;
        int bumpCount = 0;
        while (bumpCount < maxBumps) {
            if (this.canFit(bumpCount, this.leftKeepout, this.rightKeepout, this.bottomKeepout, this.topKeepout, this.xPitch, this.yPitch, this.width, this.height) == null) {
                return lastBumpCount;
            }
            lastBumpCount = bumpCount++;
        }
        return lastBumpCount;
    }

    public Boolean canFit() {
        return this.canFit(this.totalBumps, this.leftKeepout, this.rightKeepout, this.bottomKeepout, this.topKeepout, this.xPitch, this.yPitch, this.width, this.height) != null;
    }

    protected List<APoint2D> canFit(long bumpCount, long leftKeepout, long rightKeepout, long bottomKeepout, long topKeepout, long xPitch, long yPitch, long width, long height) {
        ARect pinBounds = this.mPlaceableFactory.getTransformedItemBounds(this.mItemMirror, this.mItemRotation);
        long right = width - rightKeepout - pinBounds.width() / 2L;
        long top = height - pinBounds.height() / 2L - topKeepout;
        long initialX = pinBounds.width() / 2L + leftKeepout;
        long initialY = pinBounds.height() / 2L + bottomKeepout;
        long x = initialX;
        long y = initialY;
        int row = 0;
        LinkedList<APoint2D> points = new LinkedList<APoint2D>();
        int i = 1;
        while ((long)i <= bumpCount) {
            if (x > right) {
                if ((y += yPitch) > top) {
                    return null;
                }
                x = initialX;
                if (!this.mStagger || ++row % 2 == 0) continue;
                x += xPitch / 2L;
                continue;
            }
            points.add(new APoint2D(x, y));
            x += xPitch;
            ++i;
        }
        return points;
    }

    public Long calcHeight() {
        Db db = this.mMatrixOwner.getDb();
        long startHeight = Design.micronToInternal((Db)db, (double)5.0);
        long maxHeight = Design.micronToInternal((Db)db, (double)10000.0);
        long heightIncr = Design.micronToInternal((Db)db, (double)1.0);
        for (long h = startHeight; h < maxHeight; h += heightIncr) {
            if (this.canFit(this.totalBumps, this.leftKeepout, this.rightKeepout, this.bottomKeepout, this.topKeepout, this.xPitch, this.yPitch, this.width, h) == null) continue;
            return h;
        }
        return null;
    }

    public Long calcWidth() {
        Db db = this.mMatrixOwner.getDb();
        long startWidth = Design.micronToInternal((Db)db, (double)5.0);
        long maxWidth = Design.micronToInternal((Db)db, (double)10000.0);
        long widthIncr = Design.micronToInternal((Db)db, (double)1.0);
        for (long w = startWidth; w < maxWidth; w += widthIncr) {
            if (this.canFit(this.totalBumps, this.leftKeepout, this.rightKeepout, this.bottomKeepout, this.topKeepout, this.xPitch, this.yPitch, w, this.height) == null) continue;
            return w;
        }
        return null;
    }

    private LinkedList<BumpRatioOptimizer.RatioInstruction> instructionsFromString(String ratioInstructionsString) {
        LinkedList<BumpRatioOptimizer.RatioInstruction> instructions = new LinkedList<BumpRatioOptimizer.RatioInstruction>();
        if (ratioInstructionsString == null) {
            return instructions;
        }
        byte[] currentXMLBytes = ratioInstructionsString.getBytes();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(currentXMLBytes);
        Element root = AXDomUtil.getDocumentElement((InputStream)byteArrayInputStream);
        if (root == null) {
            return instructions;
        }
        for (Element ratioData : AXDomUtil.getChildElems((Node)root, (String)"RatioData")) {
            String netName = ratioData.getAttribute("net");
            String ratio = ratioData.getAttribute("ratio");
            String bias = ratioData.getAttribute("bias");
            String created = ratioData.getAttribute("created");
            String locked = ratioData.getAttribute("locked");
            String netUseS = ratioData.getAttribute("netType");
            String shorted = ratioData.getAttribute("shorted");
            Net.Use netUse = Net.Use.POWER;
            netUse = netUseS == null || netUseS.isEmpty() ? Net.Use.POWER : Net.Use.valueOf((String)netUseS);
            if (created == null || created.isEmpty()) {
                created = "0";
            }
            if (locked == null || locked.isEmpty()) {
                locked = "false";
            }
            if (shorted == null || shorted.isEmpty()) {
                shorted = "false";
            }
            BumpRatioOptimizer.RatioInstruction rtr = new BumpRatioOptimizer.RatioInstruction(netName, netUse, Boolean.parseBoolean(shorted), Integer.parseInt(ratio), BumpFactoryData.BumpBiasType.valueOf((String)bias), Integer.parseInt(created), Boolean.parseBoolean(locked));
            instructions.add(rtr);
        }
        return instructions;
    }

    private String stringFromInstructions(List<BumpRatioOptimizer.RatioInstruction> instructions) {
        StringBuilder returnString = new StringBuilder("<RatioData>\n");
        for (BumpRatioOptimizer.RatioInstruction instruction : instructions) {
            returnString.append(String.format("\t<RatioData net=\"%s\" netType= \"%s\" shorted = \"%b\" ratio=\"%d\" bias=\"%s\" created=\"%d\" locked=\"%b\"/>\n", instruction.name, instruction.netUse.toString(), instruction.shorted, instruction.ratio, instruction.type.toString(), instruction.created, instruction.locked));
        }
        returnString.append("</RatioData>\n");
        return returnString.toString();
    }

    public String calcRequired() {
        Substrate s = this.mMatrixOwner.getSubstrate();
        this.getOrCreatePersonalityForSignalBump();
        LinkedList<BumpRatioOptimizer.RatioInstruction> instructions = this.instructionsFromString(this.ratioInstructions);
        if (instructions.isEmpty()) {
            return "";
        }
        for (BumpRatioOptimizer.RatioInstruction instruction : instructions) {
            Personality p;
            int thisAdd = this.mNumIO / instruction.ratio;
            if (instruction.locked) {
                thisAdd = instruction.created;
            }
            instruction.created = thisAdd;
            this.totalBumps += thisAdd;
            instruction.p = p = Personality.getOrCreate((DeviceTemplate)this.mMatrixOwner, (Personality.Type)Personality.Type.PORT, (String)instruction.name, newPers -> {
                newPers.setColor(Personalities.getDefaultPersonalityColor((Personality)newPers));
                Personality.setColor((int)((int)s.getPersonalitiesStream(Personality.Type.PORT).count()));
            });
        }
        return this.stringFromInstructions(instructions);
    }

    public Device createRatioDriven() {
        if (this.mMatrixOwner == null) {
            return null;
        }
        ARect bounds = new ARect(0L, 0L, this.width, this.height);
        APoint2D loc = new APoint2D(0L, 0L);
        Device groupDevice = this.prepareToPlaceBumps(loc, bounds, this.customName, this.customName);
        DeviceTemplate groupTmplt = groupDevice.getTemplate();
        this.mPlaceableFactory.storeParameters(this.createRatioDrivenBumpFactoryData(groupTmplt));
        int totalSignaleBumps = this.totalBumps = this.mNumIO;
        LinkedList<BumpRatioOptimizer.RatioInstruction> instructions = this.instructionsFromString(this.ratioInstructions);
        if (instructions.isEmpty()) {
            return groupDevice;
        }
        Personality psnSignalBump = this.getOrCreatePersonalityForSignalBump();
        ArrayList<Personality> psnsAllBumps = new ArrayList<Personality>(Collections.nCopies(totalSignaleBumps, psnSignalBump));
        this.totalBumps += this.addPersonalities4PGBumps(instructions, totalSignaleBumps, psnsAllBumps);
        List<APoint2D> bumpLocations = this.canFit(this.totalBumps, this.leftKeepout, this.rightKeepout, this.bottomKeepout, this.topKeepout, this.xPitch, this.yPitch, this.width, this.height);
        if (bumpLocations == null) {
            ALog.logWarn((String)"Can not place all the bumps with the current constraints");
            return null;
        }
        LinkedList<PlaceableItem<DbObject>> bumps = this.createBumps(bumpLocations, groupTmplt, groupDevice, psnsAllBumps);
        this.ratioInstructions = this.stringFromInstructions(instructions);
        if (!instructions.isEmpty()) {
            BumpRatioOptimizer opt = new BumpRatioOptimizer();
            opt.setDevice(groupDevice);
            opt.setBumps(bumps);
            opt.setBumpLocations(bumps);
            opt.setInstructions(instructions);
            opt.setPitch(this.minPitch);
            if (this.optimize) {
                opt.optimize();
            } else {
                opt.greedy();
            }
        }
        OrbitIO.refreshViewsOf((DbObject)groupDevice);
        ExternalDeviceUpdateListener.fireExternalDeviceUpdated(groupDevice);
        return groupDevice;
    }

    private BumpFactoryData createRatioDrivenBumpFactoryData(DeviceTemplate groupTmplt) {
        BumpFactoryData bfd = BumpFactoryData.getForTemplate((DeviceTemplate)groupTmplt, (boolean)true);
        bfd.setFactoryType(BumpFactoryData.BumpFactoryType.RATIO_DRIVEN);
        bfd.setBumpBaseName(this.mBumpBaseName);
        bfd.setBumpNameIsScript(this.mBumpNameIsScript);
        bfd.setNumIO(this.mNumIO);
        bfd.setWidth(this.width);
        bfd.setHeight(this.height);
        bfd.setMinPitch(this.minPitch);
        bfd.setXPitch(this.xPitch);
        bfd.setYPitch(this.yPitch);
        bfd.setRatioInstructions(this.ratioInstructions);
        bfd.setCornerKeepoutX(this.mCornerKeepoutX);
        bfd.setCornerKeepoutY(this.mCornerKeepoutY);
        bfd.setStagger(this.mStagger);
        bfd.setLeftKeepout(this.leftKeepout);
        bfd.setRightKeepout(this.rightKeepout);
        bfd.setBottomKeepout(this.bottomKeepout);
        bfd.setTopKeepout(this.topKeepout);
        return bfd;
    }

    private Personality getOrCreatePersonalityForSignalBump() {
        return Personality.getOrCreate((DeviceTemplate)this.mMatrixOwner, (Personality.Type)Personality.Type.PORT, (String)"signal", newPers -> newPers.setColor(Personalities.getDefaultPersonalityColor((Personality)newPers)));
    }

    private LinkedList<PlaceableItem<DbObject>> createBumps(List<APoint2D> locations, DeviceTemplate groupTmplt, Device groupDevice, ArrayList<Personality> psnsAllBumps) {
        LinkedList<PlaceableItem<DbObject>> bumps = new LinkedList<PlaceableItem<DbObject>>();
        int i = 0;
        for (APoint2D loc : locations) {
            String bumpName = this.generateBumpName(groupTmplt, i);
            PlaceableItem<DbObject> placeable = this.createPlaceable(groupTmplt, bumpName, loc);
            bumps.add(placeable);
            this.assignPinPersonality(placeable, groupDevice, psnsAllBumps.get(i));
            ++i;
        }
        return bumps;
    }

    private int addPersonalities4PGBumps(List<BumpRatioOptimizer.RatioInstruction> instructions, int nTotalSignalBumps, ArrayList<Personality> psnsAllBumps) {
        int totalPGBumps = 0;
        for (BumpRatioOptimizer.RatioInstruction instruction : instructions) {
            Personality psnPGBump;
            int thisAdd;
            instruction.created = thisAdd = instruction.locked ? instruction.created : nTotalSignalBumps / instruction.ratio;
            totalPGBumps += thisAdd;
            instruction.p = psnPGBump = this.getOrCreatePersonlaityForPGBump(instruction.name, instruction.shorted);
            psnsAllBumps.addAll(Collections.nCopies(thisAdd, psnPGBump));
        }
        return totalPGBumps;
    }

    private Personality getOrCreatePersonlaityForPGBump(String name, boolean shorted) {
        Personality psnPGBump = Personality.getOrCreate((DeviceTemplate)this.mMatrixOwner, (Personality.Type)Personality.Type.PORT, (String)name, newPers -> newPers.setColor(Personalities.getDefaultPersonalityColor((Personality)newPers)));
        psnPGBump.setValue(RatioDriveShorted, (Object)shorted);
        return psnPGBump;
    }

    private PlaceableItem<DbObject> createPlaceable(DeviceTemplate groupTmplt, String bumpName, APoint2D loc) {
        PlaceableItem<DbObject> placeable = this.mPlaceableFactory.create(groupTmplt, bumpName, this.mMatrixOwner.getType());
        placeable.getDbObject().setValue(FLD_FACTORY_CREATED, (Object)true);
        placeable.place(new APoint2D(loc), this.mItemRotation, this.mItemMirror);
        return placeable;
    }

    private void assignPinPersonality(PlaceableItem<DbObject> placeable, Device groupDevice, Personality psn) {
        PinTemplate pinTemplate = placeable.getConnectionPin();
        if (placeable.getDbObject() instanceof PinTemplate) {
            PinInstance pi = groupDevice.getPin(pinTemplate);
            pi.assignToPersonality(psn);
        } else {
            Device bumpDevice = (Device)placeable.getDbObject();
            PinInstance pi = bumpDevice.getPin(pinTemplate);
            pi.assignToPersonality(psn);
        }
    }

    protected Device prepareToPlaceBumps(APoint2D loc, ARect bounds, String groupName) {
        boolean shortNames = (Boolean)Settings.get((String)SettingSection, (String)SettingShortNames, (Object)SettingShortNamesDflt);
        String devTName = String.format("%s_%s", this.mMatrixOwner.getName(), groupName);
        String devName = shortNames ? groupName : devTName;
        return this.prepareToPlaceBumps(loc, bounds, devTName, devName);
    }

    protected Device prepareToPlaceBumps(APoint2D loc, ARect bounds, String coverDevTName, String coverDevName) {
        DeviceTemplate groupTmplt;
        boolean usingCurrentDevice;
        Db db = this.mMatrixOwner.getDb();
        Device groupDevice = null;
        boolean bl = usingCurrentDevice = this.coverDeviceKeyStr != null && !this.coverDeviceKeyStr.isEmpty();
        if (usingCurrentDevice) {
            groupDevice = (Device)db.getByKeyStr(Device.class, this.coverDeviceKeyStr);
            groupTmplt = groupDevice.getTemplate();
            List toBeDeletedPinTemplates = groupTmplt.getPins().stream().collect(Collectors.toList());
            List toBeDeletedDevices = groupTmplt.getChildren().stream().filter(d -> d.getDeviceType().equals((Object)DeviceTemplate.Type.BUMP)).collect(Collectors.toList());
            groupTmplt.removeNets();
            for (PinTemplate pt : toBeDeletedPinTemplates) {
                pt.deleteFromDb();
            }
            for (Device dt : toBeDeletedDevices) {
                dt.deleteFromDb(true, false);
            }
        } else {
            groupTmplt = DeviceTemplate.create((Substrate)this.mMatrixOwner.getSubstrate(), (String)coverDevTName, (boolean)true);
            groupDevice = Device.create((Db)db, (String)Device.getUniqueName((DeviceTemplate)this.mMatrixOwner, (String)coverDevName), (DeviceTemplate)groupTmplt, (DeviceTemplate)this.mMatrixOwner);
        }
        groupTmplt.setIsSynthesized(true);
        groupTmplt.setType(DeviceTemplate.Type.COVER);
        groupTmplt.setSourceType(DeviceTemplate.SourceType.BUMPFACTORY);
        groupTmplt.setBounds((AGeom)bounds.copy());
        groupTmplt.setSubstrate(this.mMatrixOwner.getSubstrate());
        if (!usingCurrentDevice) {
            groupDevice.setLoc(loc.copy());
        }
        if (this.mCornerKeepoutX == 0L || this.mCornerKeepoutY == 0L) {
            this.mCornerKeepouts = null;
        } else {
            ARect dieBBRel2Cover = this.mMatrixOwner.getBB().transform(ATransformUtil.inverse((AffineTransform)groupDevice.getLocalTransformMatrix())).getBounds();
            this.mCornerKeepouts = new ARect[]{new ARect(dieBBRel2Cover.left(), dieBBRel2Cover.bottom(), dieBBRel2Cover.left() + this.mCornerKeepoutX, dieBBRel2Cover.bottom() + this.mCornerKeepoutY), new ARect(dieBBRel2Cover.right() - this.mCornerKeepoutX, dieBBRel2Cover.bottom(), dieBBRel2Cover.right(), dieBBRel2Cover.bottom() + this.mCornerKeepoutY), new ARect(dieBBRel2Cover.right() - this.mCornerKeepoutX, dieBBRel2Cover.top() - this.mCornerKeepoutY, dieBBRel2Cover.right(), dieBBRel2Cover.top()), new ARect(dieBBRel2Cover.left(), dieBBRel2Cover.top() - this.mCornerKeepoutY, dieBBRel2Cover.left() + this.mCornerKeepoutX, dieBBRel2Cover.top())};
        }
        this.mInterpreter = Cp.getCp().getInterpreter();
        try {
            this.mInterpreter.set("dmf", (Object)this);
            this.mInterpreter.set("dmfDie", (Object)this.mMatrixOwner);
        }
        catch (EvalError e) {
            ALog.logWarn((Throwable)e, (String)"Unexpected exception while preparing to place bumps.", (Object[])new Object[0]);
        }
        return groupDevice;
    }

    protected void donePlacingBumps() {
        try {
            this.mInterpreter.unset("dmf");
            this.mInterpreter.unset("dmfDie");
        }
        catch (EvalError e) {
            ALog.logDebug((Throwable)e, (String)"Unexpected exception while uninitializing bump placement.", (Object[])new Object[0]);
        }
        this.mInterpreter = null;
        if (this.mLastPlacedBumpDevice != null) {
            ALog.logInfo((String)"The last item placed was named '%s'.", (Object[])new Object[]{this.mLastPlacedBumpDevice.getName()});
        }
    }

    protected void addPadding(Device groupDevice) {
        DeviceTemplate devT = groupDevice.getTemplate();
        AGeom bounds = devT.getBounds();
        if (bounds instanceof ARect) {
            ARect newBounds = ((ARect)bounds).copy();
            newBounds.expandBy(this.mPadL, this.mPadB, this.mPadR, this.mPadT);
            devT.setBounds((AGeom)newBounds);
        } else {
            ALog.logWarn((String)"Unable to pad cover cell DeviceTemplate '%s' as it is not a rectangular.", (Object[])new Object[]{groupDevice.getKeyStr()});
        }
    }

    protected boolean inCornerKeepout(long x, long y, float addRotation) {
        if (this.mCornerKeepouts == null) {
            return false;
        }
        ARect bounds = this.mPlaceableFactory.getTransformedItemBounds(this.mItemMirror, this.mItemRotation + addRotation);
        bounds.moveBy(x, y);
        for (ARect ko : this.mCornerKeepouts) {
            if (!ko.intersects(bounds)) continue;
            return true;
        }
        return false;
    }

    private boolean checkBumpPitch(IterableIterator<Layer> layers, ARect placeBB) {
        ARect search = new ARect(placeBB.center(), placeBB.center());
        search = search.expandBy(this.minPitch);
        APoint2D loc = placeBB.center();
        for (Layer layer : layers) {
            Binner binner = this.mPlacedBumpMap.computeIfAbsent(layer, l -> {
                Binner b = new Binner();
                b.setWorld(this.mMatrixOwner.getBounds(true).getBounds());
                return b;
            });
            for (APair b : binner.intersects(search)) {
                long dist = ((ARect)b.getFirst()).center().distance(loc);
                if (dist >= this.minPitch) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected boolean placeBump(Device groupDevice, DeviceTemplate groupTmplt, long x, long y, float addRotation, int bumpNum, DeviceTemplate.Type type) {
        if (this.inCornerKeepout(x, y, addRotation)) {
            return false;
        }
        String bumpName = this.generateBumpName(groupTmplt, bumpNum);
        PlaceableItem<DbObject> placeable = this.mPlaceableFactory.create(groupTmplt, bumpName, type);
        placeable.place(new APoint2D(x, y), this.mItemRotation + addRotation, this.mItemMirror);
        placeable.getDbObject().setValue(FLD_FACTORY_CREATED, (Object)true);
        DevicePath relPlacePath = DevicePath.fromList(List.of(groupDevice));
        ARect placeBB = relPlacePath.getBBOfChildObj(placeable.getDbObject(), false);
        DbObject dbo = placeable.getDbObject();
        if (dbo instanceof Device) {
            Device bump = (Device)dbo;
            if (!this.checkBumpPitch((IterableIterator<Layer>)new StreamIterableIterator(bump.getTemplate().getLayersInUse()), placeBB)) {
                bump.deleteFromDb();
                --this.mNextBumpNameSuffix;
                return false;
            }
            for (Layer l : new StreamIterableIterator(bump.getTemplate().getLayersInUse())) {
                Binner<APair<ARect, HierInst<?>>> binner = this.mPlacedBumpMap.get(l);
                binner.insert((Object)new APair((Object)placeBB, (Object)new HierInst(relPlacePath, (DbObject)bump)), new ARect(placeBB.center(), placeBB.center()));
            }
        } else if (dbo instanceof PinTemplate) {
            PinTemplate bump = (PinTemplate)dbo;
            if (!this.checkBumpPitch((IterableIterator<Layer>)new StreamIterableIterator(bump.getLayersInUse()), placeBB)) {
                bump.deleteFromDb();
                --this.mNextBumpNameSuffix;
                return false;
            }
            for (Layer l : new StreamIterableIterator(bump.getLayersInUse())) {
                Binner<APair<ARect, HierInst<?>>> binner = this.mPlacedBumpMap.get(l);
                binner.insert((Object)new APair((Object)placeBB, (Object)new HierInst(relPlacePath, (DbObject)bump)), new ARect(placeBB.center(), placeBB.center()));
            }
        } else assert (false) : "Unimplemented" + dbo.getClass();
        this.mLastPlacedBumpDevice = placeable;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String generateBumpName(DeviceTemplate owner, int bumpNum) {
        if (!this.mBumpNameIsScript) {
            String name;
            while (owner.getChild(name = String.format("%s%d", this.mBumpBaseName, this.mNextBumpNameSuffix++)) != null) {
            }
            return name;
        }
        Object name = "";
        try {
            this.mInterpreter.set("dmfBumpNum", bumpNum);
            this.mInterpreter.set("dmfBumpOwner", (Object)owner);
            name = "" + this.mInterpreter.eval(this.mBumpBaseName);
        }
        catch (EvalError e) {
            ALog.logError((Throwable)e, (String)"Error getting DEF output name using commnd:\n\t%s", (Object[])new Object[]{this.mBumpBaseName});
        }
        catch (Throwable e) {
            ALog.logError((Throwable)e, (String)"Unexpected error getting DEF output name using commnd:\n\t%s", (Object[])new Object[]{this.mBumpBaseName});
        }
        finally {
            try {
                this.mInterpreter.unset("dmfBumpNum");
                this.mInterpreter.unset("dmfBumpOwner");
            }
            catch (Throwable t) {
                ALog.logError((Throwable)t, (String)"Unexpected error.", (Object[])new Object[0]);
            }
        }
        Object genName = name;
        long uniquificationSuffix = 0L;
        while (owner.getChild((String)name) != null) {
            name = (String)genName + uniquificationSuffix++;
        }
        return name;
    }

    public void deleteBumpCoverCell(String deviceName) {
        Device coverCellDevice = this.mMatrixOwner.getChild(deviceName);
        if (coverCellDevice == null) {
            ALog.logWarn((String)"The specified cover cell '%s' was not found as a child of '%s'.", (Object[])new Object[]{deviceName, this.mMatrixOwner.getName()});
            return;
        }
        if (coverCellDevice.getTemplate().hasMoreThanOneDeviceInstance()) {
            DeleteDeviceUI.deleteDevice(coverCellDevice, false, false, false);
        } else {
            DeleteDeviceUI.deleteDevice(coverCellDevice, true, true, false);
        }
    }

    public long nextSuffix() {
        if (this.mNextSuffix < 0L) {
            for (Device bumpCover : DeviceMatrixFactory.getBumpCoverCells(this.mMatrixOwner)) {
                for (PlaceableItem placeable : this.mPlaceableFactory.getPlacedItems(bumpCover.getTemplate())) {
                    char c;
                    String name = placeable.getName();
                    Object numericSuffix = "";
                    for (int i = name.length() - 1; i >= 0 && Character.isDigit(c = name.charAt(i)); --i) {
                        numericSuffix = c + (String)numericSuffix;
                    }
                    if (((String)numericSuffix).length() == 0) continue;
                    long suffix = Long.parseLong((String)numericSuffix);
                    this.mNextSuffix = Math.max(this.mNextSuffix, suffix);
                }
            }
            ++this.mNextSuffix;
        }
        return this.mNextSuffix++;
    }

    public static IterableIterator<Device> getBumpCoverCells(DeviceTemplate die) {
        return new FilteringIterator<Device>((Iterator)die.getChildren()){

            protected boolean include(Device child) {
                DeviceTemplate dt = child.getTemplate();
                return dt.getSourceType() == DeviceTemplate.SourceType.BUMPFACTORY && BumpFactoryData.getForTemplate((DeviceTemplate)dt, (boolean)false) != null;
            }
        };
    }

    protected static class MatrixParms {
        protected PadTemplate.PadShapeStyle mShape;
        protected long mSize;
        protected long mSize2;
        protected String mLayer;

        public MatrixParms(String shape, long size, String layer) {
            this.mShape = PadTemplate.PadShapeStyle.valueOf((String)shape);
            this.mSize = size;
            this.mLayer = layer;
        }

        public MatrixParms(String shape, long size, long size2, String layer) {
            this.mShape = PadTemplate.PadShapeStyle.valueOf((String)shape);
            this.mSize = size;
            this.mSize2 = size2;
            this.mLayer = layer;
        }

        public PadTemplate.PadShapeStyle getShape() {
            return this.mShape;
        }

        public void setShape(PadTemplate.PadShapeStyle shape) {
            this.mShape = shape;
        }

        public long getSize() {
            return this.mSize;
        }

        public long getSize2() {
            return this.mSize2;
        }

        public void setSize(long size) {
            this.mSize = size;
        }

        public void setSize2(long size) {
            this.mSize2 = size;
        }

        public String getLayer() {
            return this.mLayer;
        }

        public void setLayer(String layer) {
            this.mLayer = layer;
        }
    }
}

