/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.factory;

import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.Metal;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.Obstacle;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.db.std.Wire;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public class ECO {
    private Db mSrcDb;
    private Db mDstDb;
    private HashMap<DeviceTemplate, DeviceTemplate> mDevTFromTo = new HashMap();

    public static ECO create(Db srcDb, Db dstDb) {
        return new ECO(srcDb, dstDb);
    }

    private ECO(Db srcDb, Db dstDb) {
        this.mSrcDb = srcDb;
        this.mDstDb = dstDb;
    }

    private void scaleToMatchTargetDbuPerMicron(Substrate s) {
        double scale = (double)Design.getUnitDistDbuPerMicron((Db)this.mDstDb) / (double)Design.getUnitDistDbuPerMicron((Db)this.mSrcDb);
        if (s.getScale() != scale) {
            s.scaleDependents(scale);
        }
    }

    public void deviceTemplateReplaceExisting(String srcDtName, String srcSubsName, String dstSubsName) {
        DeviceTemplate srcDt = DeviceTemplate.get((Db)this.mSrcDb, (String)srcSubsName, (String)srcDtName);
        if (srcDt == null) {
            ALog.logError((String)"Db:%s does not have template called:%s in substrate:%s", (Object[])new Object[]{this.mSrcDb, srcDtName, srcSubsName});
            return;
        }
        this.deviceTemplateReplaceExisting(srcDt, srcDt.getName(), srcSubsName, dstSubsName);
    }

    public void deviceTemplateReplaceExisting(DeviceTemplate srcDt, String dstDtName, String srcSubsName, String dstSubsName) {
        Substrate targetSubs = Substrate.getSubstrate((Db)this.mDstDb, (String)dstSubsName) == null ? Substrate.create((Db)this.mDstDb, (String)dstSubsName) : Substrate.getSubstrate((Db)this.mDstDb, (String)dstSubsName);
        Substrate s = Substrate.getSubstrate((Db)this.mSrcDb, (String)srcSubsName);
        this.scaleToMatchTargetDbuPerMicron(s);
        s.getLayers().stream().forEachOrdered(l -> {
            Layer targetL = targetSubs.getLayer(l.getName());
            if (targetL == null) {
                targetL = Layer.create((Substrate)targetSubs, (String)l.getName(), (int)l.getOrder(), (long)l.getHeight(), (Layer.LayerType)l.getType());
            }
        });
        DeviceTemplate targetDt = DeviceTemplate.get((Db)this.mDstDb, (String)dstSubsName, (String)dstDtName);
        this.deviceTemplateFullReplace(srcDt, targetDt, targetSubs);
    }

    private void deviceTemplateFullReplace(DeviceTemplate srcDt, DeviceTemplate originalDstDt, Substrate dstSubstrate) {
        if (this.mDevTFromTo.get(srcDt) != null) {
            return;
        }
        if (originalDstDt != null) {
            originalDstDt.setName(originalDstDt.getName() + "_to_be_deleted");
        }
        DeviceTemplate dstDt = DeviceTemplate.create((Substrate)dstSubstrate, (String)srcDt.getName(), (boolean)true);
        this.mDevTFromTo.put(srcDt, dstDt);
        if (originalDstDt != null) {
            this.mDevTFromTo.put(originalDstDt, null);
        }
        if (srcDt.getBounds() != null) {
            dstDt.setBounds(srcDt.getBounds().copy());
        }
        dstDt.setType(srcDt.getType());
        for (Object sn : srcDt.getNets()) {
            if (dstDt.getNet(sn.getName()) != null) continue;
            sn.copyTo(dstDt);
        }
        List scs = srcDt.getChildren().stream().collect(Collectors.toList());
        for (Object sc : scs) {
            DeviceTemplate childDt = sc.getTemplate();
            DeviceTemplate childTargetDt = DeviceTemplate.get((Db)this.mDstDb, (String)dstSubstrate.getName(), (String)childDt.getName());
            this.deviceTemplateFullReplace(childDt, childTargetDt, dstSubstrate);
            sc.reincarnateTo(this.mDevTFromTo.get(childDt), dstDt, false);
        }
        if (originalDstDt != null) {
            List tcs = originalDstDt.getDeviceInstances().stream().collect(Collectors.toList());
            for (Device tc : tcs) {
                this.changeTemplateAndReNetmap(tc, dstDt);
            }
            originalDstDt.deleteFromDb();
        }
        for (PinTemplate sp : srcDt.getPins()) {
            sp.copyTo(dstDt);
        }
        for (Wire sw : srcDt.getWires()) {
            sw.copyTo(dstDt);
        }
        for (Metal sm : srcDt.getMetals()) {
            sm.copyTo(dstDt);
        }
        for (Obstacle so : srcDt.getObstacles()) {
            so.copyTo(dstDt);
        }
    }

    private void changeTemplateAndReNetmap(Device d, DeviceTemplate template) {
        LinkedList<APair> changeSet = new LinkedList<APair>();
        for (NetMap nm : NetMap.getParentMappings((Device)d)) {
            changeSet.add(new APair((Object)nm.getChildNet().getName(), (Object)nm.getParentNet()));
        }
        d.setTemplate(template);
        for (APair change : changeSet) {
            NetMap.mapChildNet((Device)d, (Net)template.getNet((String)change.first), (Net)((Net)change.second));
        }
    }
}

