/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.factory;

import com.sigrity.acl.ALog;
import com.sigrity.acl.Unit;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.LayerShape;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.geom.ACircle;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.AGeomUtil;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.xml.AXDomUtil;
import com.sigrity.orbit.JedecAlphabet;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.factory.DeviceFactory;
import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PartFactory {
    public static boolean mQuiet = false;

    private PartFactory() {
    }

    public static DeviceTemplate makeIOPadTemplate(Device parent, long w, long h, String pinName, boolean verbose, String netName, boolean bounds, String templateName) {
        return PartFactory.makeIOPadTemplate(parent, w, h, pinName, verbose, netName, bounds, templateName, DeviceTemplate.Type.PAD);
    }

    public static DeviceTemplate makeIOPadTemplate(Device parent, long w, long h, String pinName, boolean verbose, String netName, boolean bounds, String templateName, DeviceTemplate.Type dType) {
        LinkedList<String> pinNames = new LinkedList<String>();
        if (pinName != null) {
            pinNames.add(pinName);
        }
        LinkedList<String> netNames = new LinkedList<String>();
        if (netName != null) {
            netNames.add(netName);
        }
        return PartFactory.makeIOPadTemplate(parent, w, h, pinNames, verbose, netNames, bounds, templateName, DeviceTemplate.Type.PAD);
    }

    public static DeviceTemplate makeIOPadTemplate(Device parent, long w, long h, List<String> pinNames, boolean verbose, List<String> netNames, boolean bounds, String templateName, DeviceTemplate.Type dType) {
        DeviceTemplate dt;
        Db db = OrbitIO.getCurDb();
        Object deviceTemplateName = templateName;
        if (deviceTemplateName == null || ((String)deviceTemplateName).isEmpty()) {
            deviceTemplateName = "IOPad_" + w + "x" + h + pinNames.stream().collect(Collectors.joining("_"));
        }
        if ((dt = DeviceTemplate.getDeviceTemplate((Substrate)parent.getSubstrate(), (String)deviceTemplateName)) != null) {
            return dt;
        }
        if (verbose) {
            ALog.logInfo((String)("Creating Template " + (String)deviceTemplateName));
        }
        dt = new DeviceTemplate((String)deviceTemplateName, parent.getSubstrate());
        ARect r = bounds ? new ARect(0L, 0L, w, h) : new ARect(-w / 2L, -h / 2L, w / 2L, h / 2L);
        dt.setBounds((AGeom)r);
        dt.setSourceType(DeviceTemplate.SourceType.USER);
        dt.setIsSynthesized(true);
        dt.setType(dType);
        db.add((DbObject)dt);
        long numPins = pinNames.size();
        PadTemplate padT = PartFactory.getOrCreatePadTemplate(dt, db, bounds, numPins);
        PartFactory.makeIOPadPinTemplate(db, dt, padT, pinNames, netNames, bounds);
        return dt;
    }

    private static PadTemplate getOrCreatePadTemplate(DeviceTemplate deviceTemplate, Db db, boolean bounds, long numPins) {
        Substrate s = deviceTemplate.getSubstrate();
        ARect r = deviceTemplate.getBounds().getBounds();
        Layer l = s.getBump();
        if (l != null) {
            PadTemplate pt;
            String padName = "PAD_" + Long.toString(r.width()) + "x" + Long.toString(r.height());
            if (numPins > 1L) {
                padName = padName + "_" + Long.toString(numPins);
            }
            if ((pt = PadTemplate.get((Db)db, (Substrate)s, (String)padName)) == null) {
                pt = PadTemplate.create((Db)db, (Substrate)s, (String)padName);
                ARect rpad = bounds ? new ARect(0L, 0L, r.width() / (2L * numPins), r.height() / 4L) : new ARect(-r.width() / (2L * numPins), -r.height() / 2L, r.width() / (2L * numPins), r.height() / 2L);
                rpad.moveCenterTo(0L, 0L);
                LayerShape.create((Db)db, (Layer)l, (DbObject)pt, (AGeom)rpad);
            }
            return pt;
        }
        return null;
    }

    public static PinTemplate makeIOPadPinTemplate(DeviceTemplate deviceTemplate, String pinName, boolean verbose, String netName, boolean bounds) {
        List pins;
        long numPins;
        if (pinName.isEmpty()) {
            return null;
        }
        Db db = deviceTemplate.getDb();
        PadTemplate pt = PartFactory.getOrCreatePadTemplate(deviceTemplate, db, bounds, numPins = (long)(pins = deviceTemplate.getPins().stream().collect(Collectors.toList())).size() + 1L);
        if (pt != null) {
            if (netName == null || netName.isEmpty()) {
                netName = "NetUnused";
            }
            Net n = Net.getOrCreate((DeviceTemplate)deviceTemplate, (String)netName);
            assert (n != null) : "Could not get net " + netName;
            PinTemplate dtp = PinTemplate.create((Net)n, (String)pinName);
            dtp.setType(PinTemplate.Type.IOPAD);
            pins.add(dtp);
            ARect r = (ARect)deviceTemplate.getBounds();
            long xinc = r.width() / numPins;
            long i = 0L;
            for (PinTemplate p : pins) {
                p.setPadTemplate(pt);
                if (bounds) {
                    p.setLoc(new APoint2D(i * xinc + xinc / 2L, r.height() / 8L));
                } else {
                    p.setLoc(new APoint2D(i * xinc, 0L));
                }
                ++i;
            }
            return dtp;
        }
        return null;
    }

    private static List<PinTemplate> makeIOPadPinTemplate(Db db, DeviceTemplate deviceTemplate, PadTemplate pt, List<String> pinNames, List<String> netNames, boolean bounds) {
        long numPins = pinNames.size();
        LinkedList<PinTemplate> pins = new LinkedList<PinTemplate>();
        int i = 0;
        while ((long)i < numPins) {
            String pinName = pinNames.get(i);
            String netName = netNames == null || netNames.isEmpty() ? "NetUnused" : netNames.get(i);
            Net n = Net.getOrCreate((DeviceTemplate)deviceTemplate, (String)netName);
            assert (n != null) : "Could not get net " + netName;
            PinTemplate dtp = PinTemplate.create((Net)n, (String)pinName);
            dtp.setType(PinTemplate.Type.IOPAD);
            pins.add(dtp);
            ++i;
        }
        ARect r = (ARect)deviceTemplate.getBounds();
        long xinc = r.width() / numPins;
        long i2 = 0L;
        for (PinTemplate p : pins) {
            p.setPadTemplate(pt);
            if (bounds) {
                p.setLoc(new APoint2D(i2 * xinc + xinc / 2L, r.height() / 8L));
            } else {
                p.setLoc(new APoint2D(i2 * xinc, 0L));
            }
            ++i2;
        }
        return pins;
    }

    public static void makeMacro(String name, String parent, long w, long h, int sPins, int nPins, int wPins, int ePins, String pinLayer, long pinSize, String substrateKey) {
        Db db = OrbitIO.getCurDb();
        Substrate s = (Substrate)db.getByKeyStr(Substrate.class, substrateKey);
        DeviceTemplate p = DeviceTemplate.getDeviceTemplate((Substrate)s, (String)parent);
        if (p == null) {
            ALog.logError((String)"There is no DeviceTemplate named '%s' is in current database.", (Object[])new Object[]{parent});
            boolean found = false;
            for (DeviceTemplate dto : db.getObjects(DeviceTemplate.class)) {
                if (!dto.getName().equals(parent)) continue;
                found = true;
                break;
            }
            if (!found) {
                return;
            }
        }
        DeviceTemplate t = new DeviceTemplate(name + "Template", s);
        ARect r = new ARect(0L, 0L, w, h);
        t.setBounds((AGeom)r);
        t.setSourceType(DeviceTemplate.SourceType.USER);
        t.setIsSynthesized(true);
        db.add((DbObject)t);
        Device d = new Device(name, p, t);
        d.setLoc(new APoint2D(0L, 0L));
        d.setIsPlaced(true);
        db.add((DbObject)d);
        Design currentDesign = Design.getDesign((Db)db);
        PadTemplate pt = PadTemplate.create((Db)db, (Substrate)s, (String)(name + "PadTemplate"));
        ARect rpad = new ARect(0L, 0L, pinSize, pinSize);
        rpad.moveCenterTo(0L, 0L);
        Layer l = s.getLayer(pinLayer);
        LayerShape.create((Db)db, (Layer)l, (DbObject)pt, (AGeom)rpad);
        for (int side = 0; side < 4; ++side) {
            long yIncr;
            long xIncr;
            long y;
            long x;
            long pinSep;
            int numPins;
            if (side == 0) {
                numPins = sPins;
                pinSep = w / (long)(numPins + 1);
                x = 0L;
                y = 0L;
                x += pinSep;
                xIncr = pinSep;
                yIncr = 0L;
            } else if (side == 1) {
                numPins = nPins;
                pinSep = w / (long)(numPins + 1);
                x = 0L;
                y = h;
                x += pinSep;
                xIncr = pinSep;
                yIncr = 0L;
            } else if (side == 2) {
                numPins = wPins;
                pinSep = h / (long)(numPins + 1);
                x = 0L;
                y = pinSep;
                xIncr = 0L;
                yIncr = pinSep;
            } else {
                numPins = ePins;
                pinSep = h / (long)(numPins + 1);
                x = w;
                y = pinSep;
                xIncr = 0L;
                yIncr = pinSep;
            }
            for (int i = 0; i < numPins; ++i) {
                String pinName = "P." + side + "_" + i;
                Net n = new Net(t, pinName);
                db.add((DbObject)n);
                PinTemplate dtp = PinTemplate.create((Net)n, (String)(name + "PinTemplate" + side + "_" + i));
                dtp.setPadTemplate(pt);
                dtp.setLoc(new APoint2D(x, y));
                PinInstance dp = PinInstance.getPinInstance((Device)d, (PinTemplate)dtp);
                dp.setPinInstanceName(name + pinName);
                x += xIncr;
                y += yIncr;
            }
        }
        currentDesign.binAllDevices();
        OrbitIO.getApp().refreshCurrentView(false);
    }

    public static void makeBoard(String baseTemplateName, String baseInstanceName, long w, long h) {
        Db db = OrbitIO.getCurDb();
        String substrateName = Substrate.getUniqueName((Db)db, (String)(baseTemplateName + "_Substrate"));
        Substrate s = Substrate.create((Db)db, (String)substrateName);
        s.setSourceType(DeviceTemplate.SourceType.USER);
        Layer.create((Substrate)s, (String)"UserLayer");
        Object templateName = baseTemplateName;
        int i = 0;
        boolean changedName = false;
        while (DeviceTemplate.getDeviceTemplate((Substrate)s, (String)templateName) != null) {
            templateName = baseTemplateName + i++;
            changedName = true;
        }
        DeviceTemplate t = new DeviceTemplate((String)templateName, s);
        ARect r = new ARect(-w / 2L, -h / 2L, w - w / 2L, h - h / 2L);
        t.setBounds((AGeom)r);
        t.setSourceType(DeviceTemplate.SourceType.USER);
        t.setIsSynthesized(true);
        t.setType(DeviceTemplate.Type.BOARD);
        db.add((DbObject)t);
        Object deviceName = baseInstanceName;
        i = 0;
        changedName = false;
        Design currentDesign = Design.getDesign((Db)db);
        while (Device.getChildDevice((DeviceTemplate)currentDesign, (String)deviceName) != null) {
            deviceName = baseInstanceName + i++;
            changedName = true;
        }
        if (changedName) {
            ALog.logInfo((String)("Board name changed to " + (String)deviceName));
        }
        Device d = new Device((String)deviceName, (DeviceTemplate)currentDesign, t);
        db.add((DbObject)d);
        d.setLoc(new APoint2D(0L, 0L));
        d.setIsPlaced(true);
        d.setSynthesized(true);
    }

    public static Device makeDie(String baseTemplateName, String baseInstanceName, long w, long h, int sPins, int nPins, int wPins, int ePins, long wPin, long hPin) {
        return PartFactory.makeDie(baseTemplateName, baseInstanceName, w, h, sPins, nPins, wPins, ePins, wPin, hPin, true);
    }

    public static Device makeDie(String baseTemplateName, String baseInstanceName, long w, long h, int sPins, int nPins, int wPins, int ePins, long wPin, long hPin, boolean createNewTemplate) {
        int i;
        int[] numPins = new int[]{nPins, sPins, wPins, ePins};
        long[] stepPins = new long[]{w / (long)(numPins[0] + 3), w / (long)(numPins[1] + 3), h / (long)(numPins[2] + 1), h / (long)(numPins[3] + 1)};
        long minStepX = Math.min(stepPins[0], stepPins[1]);
        long minStepY = Math.min(stepPins[2], stepPins[3]);
        long[] xs = new long[]{-w / 2L + stepPins[0] * 2L, -w / 2L + stepPins[1] * 2L, -w / 2L + minStepX, w - w / 2L - minStepX};
        long[] ys = new long[]{h - h / 2L - minStepY, -h / 2L + minStepY, h - h / 2L - stepPins[2], h - h / 2L - stepPins[3]};
        long[] xIncrs = new long[]{stepPins[0], stepPins[1], 0L, 0L};
        long[] yIncrs = new long[]{0L, 0L, -stepPins[2], -stepPins[3]};
        assert (numPins.length == stepPins.length);
        assert (numPins.length == xs.length);
        assert (numPins.length == ys.length);
        assert (numPins.length == xIncrs.length);
        assert (numPins.length == yIncrs.length);
        Db db = OrbitIO.getCurDb();
        Substrate dieSubstrate = null;
        if (dieSubstrate == null) {
            String substrateName = Substrate.getUniqueName((Db)db, (String)(baseTemplateName + "_Substrate"));
            dieSubstrate = Substrate.create((Db)db, (String)substrateName);
            dieSubstrate.setSourceType(DeviceTemplate.SourceType.USER);
            dieSubstrate.setHeight(Design.micronToInternal((Db)db, (double)100.0));
            for (i = 1; i <= 6; ++i) {
                Layer.create((Substrate)dieSubstrate, (String)("M" + i));
            }
            ALog.logWarn((String)"No existing die substrate was found, created new substrate '%s'.", (Object[])new Object[]{dieSubstrate.getName()});
        }
        Object templateName = baseTemplateName;
        DeviceTemplate t = DeviceTemplate.getDeviceTemplate(dieSubstrate, (String)templateName);
        if (createNewTemplate) {
            t = null;
            i = 0;
            while (DeviceTemplate.getDeviceTemplate((Substrate)dieSubstrate, (String)templateName) != null) {
                templateName = baseTemplateName + i;
                ++i;
            }
        }
        if (t == null) {
            t = new DeviceTemplate((String)templateName, dieSubstrate);
            ARect rc = new ARect(-w / 2L, -h / 2L, w - w / 2L, h - h / 2L);
            t.setBounds((AGeom)rc);
            t.setSourceType(DeviceTemplate.SourceType.USER);
            t.setIsSynthesized(true);
            t.setType(DeviceTemplate.Type.DIE);
            db.add((DbObject)t);
        }
        Design design = Design.getDesign((Db)db);
        Object deviceName = baseInstanceName;
        i = 0;
        while (Device.getChildDevice((DeviceTemplate)design, (String)deviceName) != null) {
            deviceName = baseInstanceName + i;
            ++i;
        }
        Device d = new Device((String)deviceName, (DeviceTemplate)design, t);
        d.setLoc(new APoint2D(0L, 0L));
        d.setIsPlaced(true);
        d.setSynthesized(true);
        db.add((DbObject)d);
        PadTemplate pt = PadTemplate.create((Db)db, (Substrate)dieSubstrate, (String)("DiePadTemplate" + Long.toString(wPin) + "x" + Long.toString(hPin)));
        ARect rpad = new ARect(0L, 0L, wPin, hPin);
        rpad.moveCenterTo(0L, 0L);
        LayerShape.create((Db)db, (Layer)dieSubstrate.getM1(), (DbObject)pt, (AGeom)rpad);
        Net unusedNet = Net.getOrCreate((DeviceTemplate)t, (String)"NetUnused");
        char sideChar = 'A';
        for (i = 0; i < numPins.length; ++i) {
            long x = xs[i];
            long y = ys[i];
            for (int j = 0; j < numPins[i]; ++j) {
                String pinName = sideChar + Integer.toString(j);
                PinTemplate dtp = PinTemplate.create((Net)unusedNet, (String)pinName);
                dtp.setPadTemplate(pt);
                dtp.setLoc(new APoint2D(x, y));
                dtp.setType(PinTemplate.Type.BALLPAD);
                PinInstance dp = new PinInstance(pinName, d, dtp);
                db.add((DbObject)dp);
                x += xIncrs[i];
                y += yIncrs[i];
            }
            sideChar = (char)(sideChar + 1);
        }
        return d;
    }

    public static Device makePackage(String baseTemplateName, String baseInstanceName, boolean byNumber, long w, long h, int numRows, int numCols, int rings, int centerRows, int centerCols, long pinSize, long pinDx, long pinDy, AGeomUtil.CompassCorners pinStart, Integer perimeter) {
        return PartFactory.makePackage(baseTemplateName, baseInstanceName, byNumber, w, h, numRows, numCols, rings, centerRows, centerCols, pinSize, pinDx, pinDy, pinStart, perimeter, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Device makePackage(String baseTemplateName, String baseInstanceName, boolean byNumber, long w, long h, int numRows, int numCols, int rings, int centerRows, int centerCols, long pinSize, long pinDx, long pinDy, AGeomUtil.CompassCorners pinStart, Integer perimeter, boolean fc) {
        int[] nArray;
        long y;
        long x;
        long startX;
        long edgeY;
        long edgeX;
        long dy;
        long dx;
        int i;
        int pinCount = 0;
        Db db = OrbitIO.getCurDb();
        Design currentDesign = Design.getDesign((Db)db);
        Unit.Distance unit = currentDesign.getUnit();
        String substrateName = Substrate.getUniqueName((Db)db, (String)(baseTemplateName + "_Substrate"));
        Substrate s = Substrate.create((Db)db, (String)substrateName);
        s.setSourceType(DeviceTemplate.SourceType.USER);
        s.setHeight(Design.micronToInternal((Db)db, (double)200.0));
        Layer lBall = null;
        if (fc) {
            Layer.create((Substrate)s, (String)"Bump", (int)4, (long)Design.micronToInternal((Db)db, (double)10.0));
            Layer.create((Substrate)s, (String)"Route1", (int)3, (long)Design.micronToInternal((Db)db, (double)10.0));
            Layer.create((Substrate)s, (String)"Route2", (int)2, (long)Design.micronToInternal((Db)db, (double)10.0));
            Layer.create((Substrate)s, (String)"Route3", (int)1, (long)Design.micronToInternal((Db)db, (double)10.0));
            lBall = Layer.create((Substrate)s, (String)"BallLayer", (int)0, (long)Design.micronToInternal((Db)db, (double)10.0));
        } else {
            s.setSourceType(DeviceTemplate.SourceType.USER);
            Element e = Substrate.getDefaultLayerConfig((String)"package");
            if (e == null) {
                Layer.create((Substrate)s, (String)"WireBondLayer", (int)2, (long)unit.fromUser(25.0)).setType(Layer.LayerType.Jumper);
                Layer.create((Substrate)s, (String)"BondFingerLayer", (int)1, (long)unit.fromUser(50.0)).setType(Layer.LayerType.Signal);
                lBall = Layer.create((Substrate)s, (String)"BallLayer", (int)0, (long)unit.fromUser(50.0));
                lBall.setType(Layer.LayerType.Signal);
            } else {
                i = 0;
                for (Element el : AXDomUtil.getChildElems((Node)e, (String)"Layer")) {
                    String lName = el.getAttribute("name");
                    Layer.create((Substrate)s, (String)lName, (int)i++, (long)unit.fromUser(50.0), (Layer.LayerType)Layer.LayerType.Signal);
                }
                s.setHeight(Design.micronToInternal((Db)db, (double)((double)i * 50.0)));
                lBall = s.getBottomLayer();
            }
        }
        Object templateName = baseTemplateName;
        i = 0;
        boolean changedName = false;
        while (DeviceTemplate.getDeviceTemplate((Substrate)s, (String)templateName) != null) {
            templateName = baseTemplateName + i++;
            changedName = true;
        }
        DeviceTemplate t = new DeviceTemplate((String)templateName, s);
        ARect r = new ARect(-w / 2L, -h / 2L, w - w / 2L, h - h / 2L);
        t.setBounds((AGeom)r);
        t.setSourceType(DeviceTemplate.SourceType.USER);
        t.setIsSynthesized(true);
        t.setType(DeviceTemplate.Type.PACKAGE);
        db.add((DbObject)t);
        Object deviceName = baseInstanceName;
        i = 0;
        changedName = false;
        while (Device.getChildDevice((DeviceTemplate)currentDesign, (String)deviceName) != null) {
            deviceName = baseInstanceName + i++;
            changedName = true;
        }
        if (changedName) {
            ALog.logInfo((String)("Package name changed to " + (String)deviceName));
        }
        Device d = new Device((String)deviceName, (DeviceTemplate)currentDesign, t);
        d.setLoc(new APoint2D(0L, 0L));
        d.setIsPlaced(true);
        d.setSynthesized(true);
        db.add((DbObject)d);
        PadTemplate pt = PadTemplate.create((Db)db, (Substrate)t.getSubstrate(), (String)("PackagePadTemplate" + Long.toString(pinSize)));
        ACircle cpad = new ACircle(0L, 0L, pinSize);
        LayerShape.create((Db)db, (Layer)lBall, (DbObject)pt, (AGeom)cpad);
        if (numRows == 0 && numCols == 0) {
            return d;
        }
        if (!byNumber) {
            if (pinDx == 0L || pinDy == 0L) return d;
            if (perimeter == null) {
                numRows = (int)(h / pinDy);
                numCols = (int)(w / pinDx);
                dx = pinDx;
                dy = pinDy;
                edgeX = (w - (long)(numCols - 1) * dx) / 2L;
                edgeY = (h - (long)(numRows - 1) * dy) / 2L;
            } else {
                numRows = (int)((h - ((long)perimeter.intValue() - pinSize / 2L) * 2L) / pinDy);
                numCols = (int)((w - ((long)perimeter.intValue() - pinSize / 2L) * 2L) / pinDx);
                dx = pinDx;
                dy = pinDy;
                edgeX = (long)perimeter.intValue() + pinSize;
                edgeY = (long)perimeter.intValue() + pinSize;
            }
            ALog.logInfo((String)("There are " + numRows + " rows and " + numCols + " columns"));
        } else {
            dx = w / (long)(numCols + 1);
            dy = h / (long)(numRows + 1);
            dx = unit.fromUser((double)((long)unit.toUser(dx)));
            dy = unit.fromUser((double)((long)unit.toUser(dy)));
            if (perimeter == null) {
                edgeX = dx;
                edgeY = dy;
            } else {
                edgeX = perimeter.intValue();
                edgeY = perimeter.intValue();
            }
            ALog.logInfo((String)("Ball spacing: " + dx / Design.micronToInternal((Db)db, (double)1.0) + " by " + dy / Design.micronToInternal((Db)db, (double)1.0)));
        }
        if (rings >= 0 && numCols < rings * 2 + centerCols) {
            ALog.logError((String)"Column count is less than %d needed to create %d rings and %d center columns.", (Object[])new Object[]{rings * 2 + centerCols, rings, centerCols});
            return d;
        }
        if (rings >= 0 && numRows < rings * 2 + centerRows) {
            ALog.logError((String)"Row count is less than %d needed to create %d rings and %d center rows.", (Object[])new Object[]{rings * 2 + centerRows, rings, centerRows});
            return d;
        }
        if (pinStart == AGeomUtil.CompassCorners.NW) {
            dy = -dy;
            x = startX = -w / 2L + edgeX;
            y = h - h / 2L - edgeY;
        } else if (pinStart == AGeomUtil.CompassCorners.NE) {
            dx = -dx;
            dy = -dy;
            x = startX = w - w / 2L - edgeX;
            y = h - h / 2L - edgeY;
        } else if (pinStart == AGeomUtil.CompassCorners.SE) {
            dx = -dx;
            x = startX = w - w / 2L - edgeX;
            y = -h / 2L + edgeY;
        } else {
            if (pinStart != AGeomUtil.CompassCorners.SW) return d;
            x = startX = -w / 2L + edgeX;
            y = -h / 2L + edgeY;
        }
        if (byNumber) {
            long offset = startX + dx * (long)(numCols / 2 - 1);
            offset = numCols % 2 == 0 ? (offset += dx / 2L) : (offset += dx);
            x -= offset;
            startX -= offset;
            offset = y + dy * (long)(numRows / 2 - 1);
            offset = numRows % 2 == 0 ? (offset += dy / 2L) : (offset += dy);
            y -= offset;
        }
        Net unusedNet = Net.getOrCreate((DeviceTemplate)t, (String)"NetUnused");
        String jedecAlphabet = "ABCDEFGHJKLMNPRTUVWY";
        long alphabetLen = JedecAlphabet.getLength();
        Object rowBase = "";
        Object rowString = "";
        int rowChar = 0;
        if (rings < 0) {
            nArray = null;
        } else {
            int[] nArray2 = new int[4];
            nArray2[0] = (numRows - centerRows + 1) / 2 + 1;
            nArray2[1] = (numRows - centerRows + 1) / 2 + centerRows;
            nArray2[2] = (numCols - centerCols + 1) / 2 + 1;
            nArray = nArray2;
            nArray2[3] = (numCols - centerCols + 1) / 2 + centerCols;
        }
        int[] centerRang = nArray;
        long[] centerOffset = new long[]{(numRows - centerRows) % 2 == 0 ? 0L : dy / 2L, (numCols - centerCols) % 2 == 0 ? 0L : dx / 2L};
        for (int row = 1; row <= numRows; ++row) {
            rowString = (String)rowBase + jedecAlphabet.charAt(rowChar);
            boolean centerPort = false;
            for (int col = 1; col <= numCols; ++col) {
                int thisOuterRow = Math.min(row, numRows - row + 1);
                int thisOuterCol = Math.min(col, numCols - col + 1);
                int thisOuterRing = Math.min(thisOuterRow, thisOuterCol);
                centerPort = rings >= 0 && row >= centerRang[0] && row <= centerRang[1] && col >= centerRang[2] && col <= centerRang[3];
                if (rings == -1 || thisOuterRing <= rings || centerPort) {
                    String pinName = (String)rowString + Integer.toString(col);
                    PinTemplate dtp = PinTemplate.create((Net)unusedNet, (String)pinName);
                    dtp.setPadTemplate(pt);
                    if (centerPort) {
                        dtp.setLoc(new APoint2D(x - centerOffset[1], y - centerOffset[0]));
                    } else {
                        dtp.setLoc(new APoint2D(x, y));
                    }
                    dtp.setType(PinTemplate.Type.BALLPAD);
                    PinInstance dp = PinInstance.getPinInstance((Device)d, (PinTemplate)dtp);
                    dp.setPinInstanceName(pinName);
                    ++pinCount;
                }
                x += dx;
            }
            if ((long)(++rowChar) >= alphabetLen) {
                rowChar = 0;
                int index = (int)((long)row / alphabetLen) - 1;
                rowBase = index >= jedecAlphabet.length() ? "" + row : "" + jedecAlphabet.charAt(index);
            }
            x = startX;
            y += dy;
        }
        ALog.logInfo((String)(pinCount + " pins were created"));
        return d;
    }

    protected static String getColumnData(String colName, ArrayList<String> headers, String[] rowData) {
        int c = headers.indexOf(colName);
        if (c >= 0 && c < rowData.length) {
            return rowData[c];
        }
        return "";
    }

    public static void makeDevice(String name, String dType, String csvPath, double pinSize, String substrate, String layer, String padShapeStyle) {
        PartFactory.makeDevice(name, csvPath, pinSize, substrate, layer, padShapeStyle, dType, 0L, 0L);
    }

    public static void makeDevice(String name, String dType, String csvPath, double pinSize, String substrate, String layer, String padShapeStyle, long width, long height) {
        PartFactory.makeDevice(name, csvPath, pinSize, substrate, layer, padShapeStyle, dType, width, height);
    }

    public static void makeDevice(String name, String dType, long width, long height) {
        PartFactory.makeDevice(name, null, 0.0, null, null, null, dType, width, height);
    }

    public static void makeDevice(String name, String dType, String substrate) {
        PartFactory.makeDevice(name, null, 0.0, substrate, null, null, dType, 0L, 0L);
    }

    public static void makeDevice(String name, String dType, String substrate, long width, long height) {
        PartFactory.makeDevice(name, null, 0.0, substrate, null, null, dType, width, height);
    }

    public static void makeDevice(String name, String csvPath, double pinSize, String substrate, String layer, boolean squarePad, String dType) {
        PartFactory.makeDevice(name, csvPath, pinSize, substrate, layer, squarePad ? PadTemplate.PadShapeStyle.Square.name() : PadTemplate.PadShapeStyle.Circle.name(), dType, 0L, 0L);
    }

    public static void makeDevice(String name, String csvPath, double pinSize, String substrate, String layer, boolean squarePad, String dType, long width, long height) {
        PartFactory.makeDevice(name, csvPath, pinSize, substrate, layer, squarePad ? PadTemplate.PadShapeStyle.Square.name() : PadTemplate.PadShapeStyle.Circle.name(), dType, width, height);
    }

    public static Device makeDevice(String name, String csvPath, double pinSize, String substrate, String layer, String padShapeStyle, String dType) {
        return PartFactory.makeDevice(name, csvPath, pinSize, substrate, layer, padShapeStyle, dType, 0L, 0L);
    }

    public static Device makeDevice(String name, String csvPath, double pinSize, String substrate, String layer, String padShapeStyle, String dType, long width, long height) {
        DeviceTemplate.Type type = DeviceTemplate.Type.valueOf((String)dType);
        return PartFactory.makeDevice(name, csvPath, pinSize, substrate, layer, padShapeStyle, type, width, height);
    }

    public static Device makeDevice(String name, String csvPath, double pinSize, String substrate, String layer, boolean squarePad, DeviceTemplate.Type type) {
        return PartFactory.makeDevice(name, csvPath, pinSize, substrate, layer, squarePad ? PadTemplate.PadShapeStyle.Square.name() : PadTemplate.PadShapeStyle.Circle.name(), type);
    }

    public static Device makeDevice(String name, String csvPath, double pinSize, String substrate, String layer, String padShapeStyle, DeviceTemplate.Type type, long width, long height) {
        DeviceFactory f = new DeviceFactory(OrbitIO.getCurDb());
        if (substrate != null) {
            f.setSubstrateName(substrate);
        }
        if (layer != null) {
            f.setLayerName(layer);
        }
        if (csvPath != null) {
            f.setPinFile(csvPath);
        }
        if (pinSize != 0.0) {
            f.setPinSize(pinSize);
        }
        if (padShapeStyle != null) {
            f.setPadShape(PadTemplate.PadShapeStyle.valueOf((String)padShapeStyle));
        }
        if (width > 0L && height > 0L) {
            f.setWidth(width);
            f.setHeight(height);
        }
        return f.createDevice(name, type);
    }

    public static Device makeDevice(String name, String csvPath, double pinSize, double pinSize2, String padShapeStyle, String dType) {
        DeviceFactory f = new DeviceFactory(OrbitIO.getCurDb());
        DeviceTemplate.Type type = DeviceTemplate.Type.valueOf((String)dType);
        if (csvPath != null) {
            f.setPinFile(csvPath);
        }
        if (pinSize != 0.0) {
            f.setPinSize(pinSize);
        }
        if (pinSize2 != 0.0) {
            f.setPinSizeB(pinSize2);
        }
        if (padShapeStyle != null) {
            f.setPadShape(PadTemplate.PadShapeStyle.valueOf((String)padShapeStyle));
        }
        return f.createDevice(name, type);
    }

    public static Device makeDevice(String name, String csvPath, double pinSize, String substrate, String layer, String padShapeStyle, DeviceTemplate.Type type) {
        DeviceFactory f = new DeviceFactory(OrbitIO.getCurDb());
        if (substrate != null) {
            f.setSubstrateName(substrate);
        }
        if (layer != null) {
            f.setLayerName(layer);
        }
        if (csvPath != null) {
            f.setPinFile(csvPath);
        }
        if (pinSize != 0.0) {
            f.setPinSize(pinSize);
        }
        if (padShapeStyle != null) {
            f.setPadShape(PadTemplate.PadShapeStyle.valueOf((String)padShapeStyle));
        }
        return f.createDevice(name, type);
    }

    public static Color getPersonalityColor(Db db, String personalityName, Personality.Type type) {
        for (DeviceTemplate t : db.getObjects(DeviceTemplate.class)) {
            Optional<Personality> personality = Personality.getPersonalities((DeviceTemplate)t, (Personality.Type)type).filter(p -> p.getName().equalsIgnoreCase(personalityName)).findFirst();
            if (!personality.isPresent()) continue;
            return personality.get().getColor();
        }
        return null;
    }
}

