/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.factory;

import com.sigrity.acl.ALog;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.LayerShape;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.geom.ACircle;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.APolygon;
import com.sigrity.acl.geom.ARect;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitIO;
import java.awt.geom.AffineTransform;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PinToDevice {
    private final Db db;
    protected DeviceTemplate deviceTemplate;
    protected PadTemplate padTemplate;
    protected DeviceTemplate deviceTemplateOfNewPin;
    protected String substrateName;
    protected PinTemplate pinTemplate;
    protected boolean justSelected = false;
    protected boolean removePreviouslyCreated = false;
    private String instNamePrefix;
    private boolean hasInstRotation = false;
    private float instRotation = 0.0f;
    private String pinName = "PAD";
    private String netName = "PAD";
    private boolean originAtLL = false;
    private Map<PadTemplate, DeviceTemplate> pad2PinDevT = new HashMap<PadTemplate, DeviceTemplate>();
    private Map<DeviceTemplate, APoint2D> devOffset = new HashMap<DeviceTemplate, APoint2D>();

    public PinToDevice() {
        this(OrbitIO.getCurDb());
    }

    public PinToDevice(Db db) {
        this.db = db;
    }

    public void loadTemplate(DeviceTemplate deviceTemplate) {
        this.deviceTemplate = deviceTemplate;
    }

    public void setJustSelected(boolean justSelected) {
        this.justSelected = justSelected;
    }

    public void setRemovePreviouslyCreated(boolean removePreviouslyCreated) {
        this.removePreviouslyCreated = removePreviouslyCreated;
    }

    public void loadTemplate(String substrateName, String templateName) {
        this.substrateName = substrateName;
        this.deviceTemplate = DeviceTemplate.get((Db)this.db, (String)substrateName, (String)templateName);
        if (this.deviceTemplate == null) {
            ALog.logError((String)"Can not find a device template called %s on substrate %s.", (Object[])new Object[]{templateName, substrateName});
        }
    }

    public void loadPadTemplate(String padTemplateName) {
        this.padTemplate = PadTemplate.get((Db)this.db, (Substrate)this.deviceTemplate.getSubstrate(), (String)padTemplateName);
        if (this.padTemplate == null) {
            ALog.logError((String)"Can not find a pad template called %s.", (Object[])new Object[]{padTemplateName});
        }
    }

    public void loadDevice(String deviceTemplateOfNewPinString) {
        DeviceTemplate pinDevT = DeviceTemplate.get((Db)this.db, (String)this.substrateName, (String)deviceTemplateOfNewPinString);
        if (pinDevT == null) {
            ALog.logError((String)("Can not find a pin device template called " + deviceTemplateOfNewPinString));
        } else {
            this.loadDevice(pinDevT);
        }
    }

    public void loadDeviceByKeyStr(String devTKeyStr) {
        DeviceTemplate devT = (DeviceTemplate)this.db.getByKeyStr(DeviceTemplate.class, devTKeyStr);
        this.loadDevice(devT);
    }

    public void loadDevice(DeviceTemplate deviceTemplateOfNewPin) {
        this.deviceTemplateOfNewPin = deviceTemplateOfNewPin;
    }

    public void loadPin(String pinName) {
        if (this.deviceTemplateOfNewPin != null) {
            this.pinTemplate = this.deviceTemplateOfNewPin.getPinByName(pinName);
        }
        if (this.pinTemplate == null) {
            String pinDtName = this.deviceTemplateOfNewPin == null ? "" : this.deviceTemplateOfNewPin.getName();
            ALog.logError((String)"Can not find a pin called %s on a pin device template %s", (Object[])new Object[]{pinName, pinDtName});
        }
    }

    public void setInstNamePrefix(String instNamePrefix) {
        this.instNamePrefix = instNamePrefix;
    }

    public void setInstRotation(float rot) {
        this.hasInstRotation = true;
        this.instRotation = rot;
    }

    public void setPinName(String pinName) {
        this.pinName = pinName;
    }

    public void setNetName(String netName) {
        this.netName = netName;
    }

    public void setOriginAtLL(boolean originAtLL) {
        this.originAtLL = originAtLL;
    }

    @Deprecated
    public void pinsToDevices(boolean setAsPinRotation) {
        this.hasInstRotation = !setAsPinRotation;
        this.pinsToDevices();
    }

    private APoint2D getOffsetCausedByRotationAndMirror(Device dev, APoint2D offset) {
        float rotate = dev.getRotate();
        if (dev.getMirror()) {
            offset = new APoint2D(-offset.getX(), offset.getY());
        }
        if (rotate != 0.0f) {
            AffineTransform transform = new AffineTransform();
            transform.rotate(-Math.toRadians(rotate));
            offset = offset.transform(transform);
        }
        return offset;
    }

    public void pinsToDevices() {
        List processed = this.getTargetPins().stream().filter(this::isSelectedPad).collect(Collectors.toList());
        processed.stream().forEach(pinT -> {
            DeviceTemplate pinDevT = this.getDeviceTemplateofNewPin((PinTemplate)pinT);
            String deviceName = this.getPinDeviceName((PinTemplate)pinT);
            Device device = Device.create((Db)this.db, (String)deviceName, (DeviceTemplate)pinDevT, (DeviceTemplate)pinT.getDeviceTemplate());
            if (this.hasInstRotation) {
                device.setRotate(this.instRotation);
            } else {
                device.setRotate(pinT.getRotate());
                device.setMirror(pinT.getMirror());
            }
            APoint2D loc = pinT.getLoc();
            APoint2D offset = this.devOffset.get(pinDevT);
            if (offset != null) {
                loc = loc.add(this.getOffsetCausedByRotationAndMirror(device, offset));
            }
            device.setLoc(loc);
            if (!pinT.getNet().isNC()) {
                Net pinNet = this.getNetofNewPin((PinTemplate)pinT);
                NetMap.mapChildNet((Device)device, (Net)pinNet, (Net)pinT.getNet());
            }
        });
        processed.stream().forEach(PinTemplate::deleteFromDb);
    }

    private String getPinDeviceName(PinTemplate pinTemplate) {
        String name = pinTemplate.getName();
        if (this.instNamePrefix != null) {
            name = String.format("%s%s", this.instNamePrefix, name);
        }
        return Device.getUniqueName((DeviceTemplate)pinTemplate.getDeviceTemplate(), (String)name);
    }

    private DeviceTemplate createDeviceTemplate(PadTemplate padT, boolean bCentered) {
        DeviceTemplate pinDevT = DeviceTemplate.create((Substrate)padT.getSubstrate(), (String)padT.getName(), (boolean)true);
        pinDevT.setType(DeviceTemplate.Type.BUMP);
        ARect padBB = padT.getBB(null);
        APoint2D devicePinOffset = bCentered ? padBB.center() : padBB.getLL();
        this.devOffset.put(pinDevT, new APoint2D(devicePinOffset));
        APoint2D moveOffset = devicePinOffset.multiply(-1.0);
        padBB.moveBy(moveOffset);
        pinDevT.setBounds((AGeom)padBB);
        Net net = Net.create((DeviceTemplate)pinDevT, (String)this.netName);
        PinTemplate pinT = PinTemplate.create((Net)net, (String)this.pinName, (PadTemplate)padT, (long)moveOffset.getX(), (long)moveOffset.getY());
        pinT.setType(PinTemplate.Type.BUMPPAD);
        return pinDevT;
    }

    private DeviceTemplate getDeviceTemplateofNewPin(PinTemplate targetPin) {
        if (this.deviceTemplateOfNewPin == null) {
            PadTemplate padT = targetPin.getPadTemplate();
            DeviceTemplate pinDevT = this.pad2PinDevT.get(padT);
            if (pinDevT == null) {
                pinDevT = this.createDeviceTemplate(padT, !this.originAtLL);
                this.pad2PinDevT.put(targetPin.getPadTemplate(), pinDevT);
            }
            return pinDevT;
        }
        return this.deviceTemplateOfNewPin;
    }

    private Net getNetofNewPin(PinTemplate targetPin) {
        if (this.pinTemplate == null) {
            DeviceTemplate pinDevT = this.getDeviceTemplateofNewPin(targetPin);
            PinTemplate pin = pinDevT.getPin1();
            Net net = pin.getNet();
            if (net == null || net.isUnused()) {
                net = pinDevT.createNet(pin.getName(), true);
                pin.setNet(net);
            }
            return net;
        }
        Net net = this.pinTemplate.getNet();
        if (net == null || net.isUnused()) {
            net = this.deviceTemplateOfNewPin.createNet(this.pinTemplate.getName(), true);
            this.pinTemplate.setNet(net);
        }
        return net;
    }

    private List<PinTemplate> getTargetPins() {
        if (this.justSelected) {
            return this.getSelectedPins();
        }
        return this.getAllPins();
    }

    private List<PinTemplate> getSelectedPins() {
        Selection selection = Design.getSelection((Db)this.db);
        Stream<PinTemplate> selPinInsts = selection.get(PinInstance.class).stream().map(PinInstance::getPinTemplate);
        Stream selPinTs = selection.get(PinTemplate.class).stream();
        Stream<PinTemplate> selPins = Stream.concat(selPinInsts, selPinTs).distinct();
        if (this.deviceTemplate != null) {
            selPins = selPins.filter(pin -> pin.getDeviceTemplate() == this.deviceTemplate);
        }
        return selPins.collect(Collectors.toList());
    }

    private List<PinTemplate> getAllPins() {
        if (this.deviceTemplate == null) {
            return AUtil.arrayList((Iterator)this.db.getObjects(PinTemplate.class));
        }
        return AUtil.arrayList((Iterator)this.deviceTemplate.getPins());
    }

    private boolean isSelectedPad(PinTemplate pinT) {
        if (this.padTemplate == null) {
            return true;
        }
        return pinT.getPadTemplate() == this.padTemplate;
    }

    public void makePadsOnSubstrate(String substratePathName, String pathName, String substrateLayerName, String deviceLayerName) {
        DevicePath sp = DevicePath.fromString((Db)this.db, (String)substratePathName);
        Device sd = sp.getLast();
        Substrate s = sd.getSubstrate();
        Layer sl = s.getLayer(substrateLayerName);
        int count = 0;
        for (DevicePath dp : DevicePath.listFromString((Db)this.db, (String)pathName)) {
            count += this.makeContactPad(this.db, sp, dp, deviceLayerName, sl);
        }
        ALog.logInfo((String)(count + " pins were created on " + sp.toString() + " from " + pathName));
    }

    public int makeContactPad(Db db, DevicePath toDevicePath, DevicePath fromDevicePath, String fromLayerName, Layer toLayerName) {
        DevicePath upperPath;
        Device toDevice = toDevicePath.getLast();
        DeviceTemplate toDeviceTemplate = toDevice.getTemplate();
        Device fromDevice = fromDevicePath.getLast();
        Substrate fromSubstrate = fromDevice.getSubstrate();
        Layer fromLayer = fromSubstrate.getLayer(fromLayerName);
        if (fromLayer == null) {
            return 0;
        }
        int count = 0;
        boolean toIsUpper = toDevicePath.size() < fromDevicePath.size();
        DevicePath lowerPath = toIsUpper ? fromDevicePath : toDevicePath;
        DevicePath relPath = lowerPath.getRelativePathFromAnchor((upperPath = toIsUpper ? toDevicePath : fromDevicePath).getDeviceTemplate());
        if (relPath == null) {
            ALog.logWarn((String)"Unable to determine relative path from '%s' to '%s', created pins will not be marked as \"connected\".", (Object[])new Object[]{upperPath, lowerPath});
        }
        Selection selection = Design.getSelection((Db)db);
        for (PinInstance fromPin : AUtil.arrayList((Iterator)fromDevice.getPins())) {
            if (this.justSelected && !selection.contains((DbObject)fromPin)) continue;
            PinTemplate fromPinT = fromPin.getPinTemplate();
            boolean foundGeom = false;
            String contactPadName = "Contact" + fromPinT.getPadTemplate().getName();
            PadTemplate pt = PadTemplate.create((Db)db, (Substrate)fromPinT.getSubstrate(), (String)contactPadName);
            for (AGeom g : fromPinT.getGeometriesOnLayer(fromLayer)) {
                if (g instanceof ARect) {
                    pt = PadTemplate.create((Db)db, (Substrate)toLayerName.getSubstrate(), (String)contactPadName);
                    ARect rCopy = ((ARect)g).copy();
                    rCopy.moveCenterTo(0L, 0L);
                    LayerShape.create((Db)db, (Layer)toLayerName, (DbObject)pt, (AGeom)rCopy);
                    foundGeom = true;
                    break;
                }
                if (g instanceof ACircle) {
                    pt = PadTemplate.create((Db)db, (Substrate)toLayerName.getSubstrate(), (String)contactPadName);
                    ACircle cCopy = ((ACircle)g).copy();
                    LayerShape.create((Db)db, (Layer)toLayerName, (DbObject)pt, (AGeom)cCopy);
                    foundGeom = true;
                    break;
                }
                if (!(g instanceof APolygon)) continue;
                pt = PadTemplate.create((Db)db, (Substrate)toLayerName.getSubstrate(), (String)contactPadName);
                APolygon pCopy = ((APolygon)g).copy();
                pCopy.moveCenterTo(new APoint2D(0L, 0L));
                LayerShape.create((Db)db, (Layer)toLayerName, (DbObject)pt, (AGeom)pCopy);
                foundGeom = true;
                break;
            }
            if (!foundGeom) continue;
            Net topNet = NetMap.getTopmostNet((Net)fromPinT.getNet(), (DevicePath)fromDevicePath);
            Net n = toDeviceTemplate.getNet(topNet.getName());
            if (n == null) {
                n = Net.create((DeviceTemplate)toDeviceTemplate, (String)topNet.getName());
            }
            String pinName = n.getName();
            PinTemplate toPinT = PinTemplate.create((Net)n, (String)pinName);
            toPinT.setPadTemplate(pt);
            toPinT.setType(PinTemplate.Type.UNKNOWN);
            APoint2D worldLoc = fromPinT.getWorldLoc(fromDevicePath);
            toPinT.setLoc(new APoint2D(worldLoc));
            PinInstance.getPinInstance((Device)toDevice, (PinTemplate)toPinT);
            if (this.removePreviouslyCreated && relPath != null) {
                if (toIsUpper) {
                    toPinT.getConnectedPin().ifPresent(hPin -> {
                        if (hPin.getPinInstance().getDevice() == toDevice) {
                            ((PinTemplate)hPin.getDbObject()).deleteFromDb();
                        }
                    });
                } else {
                    fromPinT.getConnectedPin().ifPresent(hPin -> {
                        if (hPin.getPinInstance().getDevice() == fromDevice) {
                            ((PinTemplate)hPin.getDbObject()).deleteFromDb();
                        }
                    });
                }
            }
            if (relPath != null) {
                if (toIsUpper) {
                    toPinT.setConnectedPin(relPath, fromPinT);
                } else {
                    fromPinT.setConnectedPin(relPath, toPinT);
                }
            }
            ++count;
        }
        return count;
    }
}

