/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.factory;

import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierPin;
import com.sigrity.orbit.iov.IOView;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Set;

public class RDLViaPlacementFactory {
    int nth = 0;
    static int RDL_VIA_NUM_LAMBDA = 100;
    static double RDL_VIA_LAMBDA_FACTOR = 1.0;
    static int RDL_VIA_LOC_ROWS = 3;
    static boolean RDL_VIA_ALLOW_IN_IO = false;

    public void start() {
        this.nth = 0;
    }

    protected LinkedList<APoint2D> pointGenerator(APoint2D seed, HierPin via, HierPin bump, HierPin ioPad) {
        LinkedList<APoint2D> pts = new LinkedList<APoint2D>();
        pts.add(seed);
        ARect r = via.getWorldBounds();
        long lambda = (long)((double)r.width() * RDL_VIA_LAMBDA_FACTOR);
        int numLamda = RDL_VIA_NUM_LAMBDA;
        long x = seed.getX() - lambda * (long)numLamda / 2L;
        long y = seed.getY() - lambda * (long)numLamda / 2L;
        for (int row = 0; row < numLamda; ++row) {
            x = seed.getX() - lambda * (long)numLamda / 2L;
            for (int col = 0; col < numLamda; ++col) {
                pts.add(new APoint2D(x, y));
                x += lambda;
            }
            y += lambda;
        }
        Collections.sort(pts, new PointSorter(seed));
        return pts;
    }

    public APoint2D findRDLViaLoc(HierPin via, HierPin bump, HierPin ioPad, long clr) {
        int offset;
        APoint2D loc;
        ++this.nth;
        ARect r = via.getWorldBounds();
        long lamda = r.width() * 2L;
        int rows = RDL_VIA_LOC_ROWS;
        DevicePath die = via.getPath();
        ARect dieR = die.getDeviceTemplate().getBB();
        int side = IOView.determineQuadrant(ioPad.getPath(), die);
        if (side == 0) {
            loc = new APoint2D(ioPad.getPath().getBB().left(), (ioPad.getSubstrateLoc().getY() + bump.getSubstrateLoc().getY()) / 2L);
            offset = this.nth % rows + 1;
            loc.setX(loc.getX() - lamda * (long)offset);
        } else if (side == 1) {
            loc = new APoint2D((ioPad.getSubstrateLoc().getX() + bump.getSubstrateLoc().getX()) / 2L, ioPad.getPath().getBB().bottom());
            offset = this.nth % rows + 1;
            loc.setY(loc.getY() - lamda * (long)offset);
        } else if (side == 2) {
            loc = new APoint2D(ioPad.getPath().getBB().right(), (ioPad.getSubstrateLoc().getY() + bump.getSubstrateLoc().getY()) / 2L);
            offset = this.nth % rows + 1;
            loc.setX(loc.getX() + lamda * (long)offset);
        } else {
            loc = new APoint2D((ioPad.getSubstrateLoc().getX() + bump.getSubstrateLoc().getX()) / 2L, ioPad.getPath().getBB().top());
            offset = this.nth % rows + 1;
            loc.setY(loc.getY() + lamda * (long)offset);
        }
        LinkedList<APoint2D> pts = this.pointGenerator(loc, via, bump, ioPad);
        Set layers = ((PinInstance)via.second).getPinTemplate().getPadTemplate().getLayers();
        for (APoint2D c : pts) {
            r.moveCenterTo(c);
            if (!dieR.inOrOnRect(r)) continue;
            boolean safe = true;
            for (DevicePath d : die.getDescendants()) {
                if (!RDL_VIA_ALLOW_IN_IO) {
                    if (d.getDeviceTemplate().getType().equals((Object)DeviceTemplate.Type.PAD) && d.getBB().intersects(r)) {
                        safe = false;
                    }
                    if (!safe) break;
                }
                ARect newR = r.transform(d.getInverseTransform()).getBounds();
                newR.expandBy(clr, clr, clr, clr);
                for (Layer layer : layers) {
                    if (d.getDeviceTemplate().getIntersects(layer, (AGeom)newR).stream().anyMatch(Objects::nonNull)) {
                        safe = false;
                    }
                    if (safe) continue;
                    break;
                }
                if (safe) continue;
                break;
            }
            if (!safe) continue;
            return c.transform(die.getInverseTransform());
        }
        return null;
    }

    static class PointSorter
    implements Comparator<APoint2D> {
        APoint2D anchor;

        public PointSorter(APoint2D anchor) {
            this.anchor = new APoint2D(anchor);
        }

        @Override
        public int compare(APoint2D p0, APoint2D p1) {
            long d0 = p0.distance(this.anchor);
            long d1 = p1.distance(this.anchor);
            return Long.compare(d0, d1);
        }
    }
}

