/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.factory;

import com.sigrity.acl.ALog;
import com.sigrity.acl.Unit;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.LayerShape;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.PortTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.parsers.CSVDOMParser;
import com.sigrity.acl.parsers.CSVDocument;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.DiffPairUI;
import com.sigrity.orbit.HierPin;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.core.DesignView2D;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;

public class SchematicFactory {
    public static Device makeSchematicSymbol(String parentPath, Double d, String netListFile, String name, DeviceTemplate.Type partType, String hints) {
        Db db = OrbitIO.getCurDb();
        DevicePath devicePath = DevicePath.fromString((Db)OrbitIO.getCurDb(), (String)parentPath);
        if (devicePath == null) {
            ALog.logWarn((String)"DevicePath '%s' does not exist", (Object[])new Object[]{parentPath});
            return null;
        }
        DeviceTemplate parentTemplate = devicePath.getDeviceTemplate();
        Substrate s = Substrate.create((Db)db, (String)(name + "_substrate"));
        s.createDefaultLayers(partType);
        DeviceTemplate schemTemplate = DeviceTemplate.create((Substrate)s, (String)name, (boolean)true);
        Unit unit = Design.getUnit((Db)db);
        long dim = unit.fromUser(d.doubleValue());
        schemTemplate.setBounds((AGeom)new ARect(-dim / 2L, -dim / 2L, dim / 2L, dim / 2L));
        schemTemplate.setType(partType);
        Device schemDevice = Device.create((String)name, (DeviceTemplate)schemTemplate, (DeviceTemplate)parentTemplate);
        APoint2D p = SchematicFactory.getFreeLoc();
        p = p.add(dim / 2L, dim / 2L);
        schemDevice.setLoc(p);
        PadTemplate padTemplate = PadTemplate.create((Db)db, (Substrate)s, (String)"schemPadTemplate");
        LayerShape.create((Db)db, (Layer)s.getTopLayer(), (DbObject)padTemplate, (AGeom)new ARect(-dim / 50L, -dim / 50L, dim / 50L, dim / 50L));
        ArrayList<String> headers = new ArrayList<String>();
        headers.add("netname");
        headers.add("instancename");
        headers.add("pinname");
        headers.add("macroname");
        String[] h = headers != null ? headers.toArray(new String[0]) : null;
        CSVDOMParser parser2 = new CSVDOMParser(false, h);
        parser2.setDataSepExpression(",|\\s+");
        try {
            CSVDocument doc = CSVDocument.newInstance((String[])h);
            doc.setPath(netListFile);
            doc = parser2.parse(netListFile);
            LinkedList<PortTemplate> portTemplates = new LinkedList<PortTemplate>();
            for (int i = 0; i < doc.getItemCount(); ++i) {
                if (i == 0 || i == doc.getItemCount() - 1) continue;
                String nName = doc.getItemValue(i, "netname");
                String pName = doc.getItemValue(i, "pinname");
                String dName = doc.getItemValue(i, "instancename");
                String pinName = dName + ":" + pName;
                Device instance = schemTemplate.getChild(dName);
                DeviceTemplate instanceTemplate = null;
                if (instance == null) {
                    instanceTemplate = DeviceTemplate.create((Substrate)s, (String)dName, (boolean)true);
                    instanceTemplate.setBounds((AGeom)new ARect(-dim / 2L, -dim / 2L, dim / 2L, dim / 2L));
                    instanceTemplate.setType(DeviceTemplate.Type.PACKAGEDDIE);
                    instance = Device.create((String)dName, (DeviceTemplate)instanceTemplate, (DeviceTemplate)schemTemplate);
                    instance.setLoc(new APoint2D(0L, 0L));
                } else {
                    instanceTemplate = instance.getTemplate();
                }
                Net childNet = instanceTemplate.getNet(nName);
                if (childNet == null) {
                    childNet = instanceTemplate.createNet(nName);
                }
                PinTemplate pinTemplate = PinTemplate.create((Net)childNet, (String)pinName);
                PinInstance.create((Db)db, (String)pinName, (Device)instance, (PinTemplate)pinTemplate);
                PortTemplate portTemplate = PortTemplate.create((PinTemplate)pinTemplate);
                portTemplate.setPadTemplate(padTemplate);
                portTemplate.setLoc(new APoint2D(0L, 0L));
                Net parentNet = schemTemplate.getNet(nName);
                if (parentNet == null) {
                    parentNet = Net.create((DeviceTemplate)schemTemplate, (String)nName);
                }
                NetMap.mapChildNet((Device)instance, (Net)childNet, (Net)parentNet);
                portTemplates.add(portTemplate);
            }
            int numChildren = schemTemplate.childCount();
            long xWidth = dim / (long)numChildren;
            long lastX = schemTemplate.getBB().left() + xWidth / 2L;
            for (Device child : schemTemplate.getChildren()) {
                DeviceTemplate childTemplate = child.getTemplate();
                ARect r = new ARect(-xWidth / 2L, -dim / 2L, xWidth / 2L, dim / 2L);
                childTemplate.setBounds((AGeom)r);
                child.setLoc(new APoint2D(lastX, 0L));
                lastX += xWidth;
                LinkedList<Net> netsOnChild = new LinkedList<Net>();
                int numPins = 0;
                for (PinTemplate pinTemplate : childTemplate.getPins()) {
                    Net net = pinTemplate.getNet();
                    if (!netsOnChild.contains(net)) {
                        netsOnChild.add(net);
                    }
                    ++numPins;
                }
                Collections.sort(netsOnChild);
                long yDiv = dim / (long)(numPins + 1);
                long lastY = -dim / 2L + yDiv;
                for (Net n : netsOnChild) {
                    for (PortTemplate portTemplate : n.getPortTemplates()) {
                        portTemplate.setLoc(new APoint2D(0L, lastY));
                        lastY += yDiv;
                    }
                }
            }
        }
        catch (CSVDOMParser.CSVDOMException doc) {
            // empty catch block
        }
        DiffPairUI.createDiffPairs(db, schemTemplate.getKeyStr(), "N/P Suffixes", false);
        DesignView2D v = (DesignView2D)OrbitIO.getCurView();
        OrbitIO.getCurDesign().getCurSelection().clear();
        v.getCanvas().zoomFit();
        return schemDevice;
    }

    protected static APoint2D getFreeLoc() {
        ARect r = null;
        for (DevicePath p : Design.getDesign((Db)OrbitIO.getCurDb()).getDescendantDevices()) {
            if (r == null) {
                r = p.getBB();
                continue;
            }
            r = r.expandBy(p.getBB());
        }
        if (r == null) {
            return new APoint2D(0L, 0L);
        }
        return r.getLR().add(r.width() / 10L, 0L);
    }

    public static void writeTopLevelNetlist(String filePath) {
        Db db = OrbitIO.getCurDb();
        try (FileWriter fw = new FileWriter(filePath);){
            Design top = Design.getDesign((Db)db);
            LinkedList<Net> topNets = new LinkedList<Net>();
            for (Object n : top.getNets()) {
                if (n.isUnused()) continue;
                topNets.add((Net)n);
            }
            Collections.sort(topNets);
            LinkedList<Device> topChildren = new LinkedList<Device>();
            for (Device child : top.getChildren()) {
                topChildren.add(child);
            }
            if (topNets.size() > 0) {
                DevicePath topPath = new DevicePath();
                fw.write("net");
                for (Device topChild : topChildren) {
                    fw.write(",");
                    fw.write(topChild.getName());
                }
                fw.write("\n");
                for (Net topNet : topNets) {
                    HashMap<Device, LinkedList<HierPin>> dtToHP = new HashMap<Device, LinkedList<HierPin>>();
                    for (HierPin hp : NetMap.getConnectedDevicePathPorts((Net)topNet, (DevicePath)topPath)) {
                        Device topDevice = ((DevicePath)hp.first).getFirst();
                        LinkedList<HierPin> ports = (LinkedList<HierPin>)dtToHP.get(topDevice);
                        if (ports == null) {
                            ports = new LinkedList<HierPin>();
                            dtToHP.put(topDevice, ports);
                        }
                        ports.add(hp);
                    }
                    fw.write(topNet.getName() + ",");
                    for (Device topChild : topChildren) {
                        LinkedList ports = (LinkedList)dtToHP.get(topChild);
                        if (ports != null) {
                            for (HierPin hp : ports) {
                                fw.write(hp.toString() + " ");
                            }
                        }
                        fw.write(",");
                    }
                    fw.write("\n");
                }
            } else {
                ALog.logWarn((String)"There are not top level nets");
            }
            fw.flush();
        }
        catch (IOException e) {
            ALog.logWarn((String)"Problem writing to %s ", (Object[])new Object[]{filePath});
        }
    }
}

