/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.factory;

import com.sigrity.acl.ALog;
import com.sigrity.acl.FilteringIterator;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.Unit;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbClass;
import com.sigrity.acl.db.DbFieldDef;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.LayerShape;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.PortTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierPin;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.factory.ViaPattern;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.regex.Pattern;

public class ViaFactory {
    public static final String FLDNAME_VIAMAKER = "ViaFactory.ViaMaker";
    public static final String FLDNAME_VIAINSTANTIATOR = "ViaFactory.ViaInstantiator";
    public static final String FLDNAME_VIANAME = "ViaFactory.ViaName";
    public static final String FLDNAME_DEFREGULAR = "ViaFactory.DEFRegular";
    public static final String FLDNAME_CORRELATED_VIA = "ViaFactory.CorrelatedVia";
    public static final String FLDNAME_CORRELATED_VIA_OFFSET = "ViaFactory.CorrelatedViaOffset";
    public static final String FLDNAME_CORRELATED_VIA_OFFSETORIGIN = "ViaFactory.CorrelatedViaOffsetOrigin";
    public static final long DEFAULT_VIA_SIZE = Design.micronToInternal(null, (double)5.0);
    private static final String UNKNOWN_VIA_NAME = "Unknown";
    protected String topLayer;
    String cutLayer;
    String botLayer;
    long oX;
    long oY;
    long eX;
    long eY;
    long cutDx;
    long cutDy;
    boolean offsetFromOrigin = true;
    long xOffset = 0L;
    long yOffset = 0L;
    long xBotOffset = 0L;
    long yBotOffset = 0L;
    long xTopOffset = 0L;
    long yTopOffset = 0L;
    long xBotEnc = 0L;
    long yBotEnc = 0L;
    long xTopEnc = 0L;
    long yTopEnc = 0L;
    long nRow = 1L;
    long nCol = 1L;
    ArrayList<VDesc> rows = new ArrayList();
    ViaPattern viaPattern = null;

    static PadTemplate.ViaMakerType getViaMaker(PadTemplate pt) {
        PadTemplate.ViaMakerType t = (PadTemplate.ViaMakerType)pt.getValue(FLDNAME_VIAMAKER);
        if (t == null) {
            t = PadTemplate.ViaMakerType.Unknown;
        }
        return t;
    }

    public static void setViaMaker(PadTemplate pt, PadTemplate.ViaMakerType t) {
        pt.setValue(FLDNAME_VIAMAKER, (Object)t);
    }

    static ViaInstantiatorType getViaInstantiator(PinTemplate pinTemplate) {
        ViaInstantiatorType t = (ViaInstantiatorType)((Object)pinTemplate.getValue(FLDNAME_VIAINSTANTIATOR));
        if (t == null) {
            t = ViaInstantiatorType.Unknown;
        }
        return t;
    }

    public static void setViaInstantiator(PinTemplate pinTemplate, ViaInstantiatorType t) {
        pinTemplate.setValue(FLDNAME_VIAINSTANTIATOR, (Object)t);
    }

    public static void setViaName(PinTemplate pt, String s) {
        ViaFactory.setViaInfo(pt, s, true);
    }

    public static void setViaInfo(PinTemplate pt, String name, boolean isSpecial) {
        pt.setValue(FLDNAME_VIANAME, (Object)name);
        if (!isSpecial) {
            pt.setValue(FLDNAME_DEFREGULAR, (Object)true);
        }
    }

    public static String getViaName(PinTemplate pinTemplate) {
        String s = (String)pinTemplate.getValue(FLDNAME_VIANAME);
        if (s == null) {
            s = UNKNOWN_VIA_NAME;
        }
        return s;
    }

    public static String getViaNameByPadTemplate(PinTemplate pinTemplate) {
        String s = null;
        PadTemplate pt = pinTemplate.getPadTemplate();
        if (pt != null) {
            s = pt.getName();
        }
        return s == null ? UNKNOWN_VIA_NAME : s;
    }

    public static void setCorrelatedViaName(PinTemplate pt, String s) {
        pt.setValue(FLDNAME_CORRELATED_VIA, (Object)s);
    }

    public static String getCorrelatedViaName(PinTemplate pinTemplate) {
        DbClass clazz = OrbitIO.getCurDb().getDbClass(PinTemplate.class);
        DbFieldDef c = clazz.getField(FLDNAME_CORRELATED_VIA);
        if (c == null) {
            return null;
        }
        return (String)pinTemplate.getValue(FLDNAME_CORRELATED_VIA);
    }

    public static void setCorrelatedViaOffset(PinTemplate pt, APoint2D offset) {
        pt.setValue(FLDNAME_CORRELATED_VIA_OFFSET, (Object)offset);
    }

    public static void setCorrelatedViaOffsetOrigin(PinTemplate pt, boolean state) {
        pt.setValue(FLDNAME_CORRELATED_VIA_OFFSETORIGIN, (Object)state);
    }

    public static APoint2D getCorrelatedViaOffset(PinTemplate pinTemplate) {
        DbClass clazz = OrbitIO.getCurDb().getDbClass(PinTemplate.class);
        DbFieldDef c = clazz.getField(FLDNAME_CORRELATED_VIA_OFFSET);
        if (c == null) {
            return new APoint2D(0L, 0L);
        }
        return (APoint2D)pinTemplate.getValue(FLDNAME_CORRELATED_VIA_OFFSET);
    }

    public static boolean getCorrelatedViaOffsetOrigin(PinTemplate pinTemplate) {
        DbClass clazz = OrbitIO.getCurDb().getDbClass(PinTemplate.class);
        DbFieldDef c = clazz.getField(FLDNAME_CORRELATED_VIA_OFFSETORIGIN);
        if (c == null) {
            return true;
        }
        Boolean p = (Boolean)pinTemplate.getValue(FLDNAME_CORRELATED_VIA_OFFSETORIGIN);
        if (p == null) {
            return true;
        }
        return p;
    }

    public static PadTemplate getCorrelatedVia(PinTemplate pt) {
        String viaName = ViaFactory.getCorrelatedViaName(pt);
        if (viaName != null) {
            Db db = pt.getDb();
            return PadTemplate.get((Db)db, (Substrate)pt.getSubstrate(), (String)viaName);
        }
        return null;
    }

    public static void makeParentVias(String packagePathString, String padTemplateName, double ds, double angle) {
        Db db = OrbitIO.getCurDb();
        DevicePath packagePath = DevicePath.fromString((Db)db, (String)packagePathString);
        if (packagePath == null) {
            ALog.logWarn((String)"DevicePath '%s' does not exist.", (Object[])new Object[]{packagePathString});
            return;
        }
        PadTemplate padT = PadTemplate.get((Db)db, (Substrate)packagePath.getSubstrate(), (String)padTemplateName);
        if (padT == null) {
            ALog.logWarn((String)"Padstack '%s' does not exist.", (Object[])new Object[]{padTemplateName});
            return;
        }
        Design design = Design.getDesign((Db)db);
        Unit.Distance unit = design.getUnit();
        Selection s = design.getCurSelection();
        DeviceTemplate pkgDevT = packagePath.getDeviceTemplate();
        HashSet<HierPin> pins = new HashSet<HierPin>();
        for (PinInstance o : s.get(PinInstance.class)) {
            for (DevicePath dp : s.getSelectedPaths((DbObject)o)) {
                pins.add(new HierPin(dp, o));
            }
        }
        ALog.logInfo((String)("Number of pins selected " + pins.size()));
        AffineTransform t = packagePath.getInverseTransform();
        long dx = (long)((double)unit.fromUser(ds) * Math.cos(Math.toRadians(angle)));
        long dy = (long)((double)unit.fromUser(ds) * Math.sin(Math.toRadians(angle)));
        for (HierPin hp : pins) {
            APoint2D wP = hp.getWorldLoc();
            APoint2D pP = wP.transform(t);
            pP = pP.add(dx, dy);
            Net n = NetMap.getNetAt((Net)hp.getNet(), (DevicePath)hp.getPath(), (DeviceTemplate)pkgDevT);
            if (n.getDeviceTemplate() != packagePath.getLast().getTemplate()) {
                ALog.logWarn((String)("The pin " + hp.toString() + " does not map to " + packagePath.toString() + ", NetUnused will be used."));
                n = packagePath.getDeviceTemplate().getNetUnused();
            }
            PinTemplate dtp = PinTemplate.create((Net)n, (String)"ct");
            dtp.setPadTemplate(padT);
            dtp.setType(PinTemplate.Type.VIA);
            PinInstance dp = new PinInstance("CP", packagePath.getLast(), dtp);
            db.add((DbObject)dp);
            dtp.setLoc(new APoint2D(pP));
            DevicePath relPath = ((DevicePath)hp.first).getRelativePath(pkgDevT);
            if (relPath.getRoot() != pkgDevT) continue;
            dtp.setConnectedPin(relPath, ((PinInstance)hp.second).getPinTemplate());
        }
    }

    public static HierPin instantiateAVia(DevicePath substratePath, HierPin dpp, Layer contactLayer, Layer secondaryLayer, PadTemplate padTemplate, Long defaultWidth) {
        String viaName;
        Db db = contactLayer.getDb();
        APoint2D offset = new APoint2D(0L, 0L);
        boolean fromOrigin = false;
        if (padTemplate == null && (viaName = ViaFactory.getCorrelatedViaName(dpp.getPinTemplate())) != null) {
            padTemplate = PadTemplate.get((Db)db, (Substrate)contactLayer.getSubstrate(), (String)viaName);
            offset = ViaFactory.getCorrelatedViaOffset(dpp.getPinTemplate());
            fromOrigin = ViaFactory.getCorrelatedViaOffsetOrigin(dpp.getPinTemplate());
        }
        boolean synthesizedVia = false;
        if (padTemplate == null) {
            ARect newR = new ARect(-DEFAULT_VIA_SIZE, -DEFAULT_VIA_SIZE, DEFAULT_VIA_SIZE, DEFAULT_VIA_SIZE);
            if (defaultWidth != null) {
                newR = new ARect(-defaultWidth.longValue() / 2L, -defaultWidth.longValue() / 2L, defaultWidth / 2L, defaultWidth / 2L);
            }
            padTemplate = PadTemplate.create((Db)db, (Substrate)contactLayer.getSubstrate(), (String)"SynVia");
            LayerShape.create((Db)db, (Layer)contactLayer, (DbObject)padTemplate, (AGeom)newR);
            if (secondaryLayer != null) {
                LayerShape.create((Db)db, (Layer)secondaryLayer, (DbObject)padTemplate, (AGeom)newR);
            }
            synthesizedVia = true;
        }
        PinTemplate dtp = PinTemplate.create((Net)dpp.getSubstrateNet(), (String)"IOVia");
        dtp.setType(PinTemplate.Type.VIA);
        Device d = null;
        d = substratePath.getIsAbsolute() ? substratePath.getLast() : (substratePath.isEmpty() ? substratePath.getRoot().getAnInstance() : substratePath.getLast());
        PinInstance dp = new PinInstance("IOVia", d, dtp);
        db.add((DbObject)dp);
        if (synthesizedVia) {
            dtp.setLoc(new APoint2D(dpp.getSubstrateLoc()));
        } else {
            DevicePath pathToSubstrate = dpp.getSubstratePath();
            AffineTransform t = pathToSubstrate.getTransform();
            APoint2D p = fromOrigin ? new APoint2D(0L, 0L) : new APoint2D(pathToSubstrate.getDeviceTemplate().getBB().center());
            p.moveBy(offset);
            dtp.setLoc(p.transform(t));
        }
        PortTemplate portTemplate = dtp.getFirstPortTemplate();
        portTemplate.setPadTemplate(padTemplate);
        ViaFactory.setViaInstantiator(dtp, ViaInstantiatorType.Router);
        ViaFactory.setViaName(dtp, padTemplate.getName());
        DevicePath path = substratePath.pathToLowestDie();
        return new HierPin(path, dp);
    }

    public static IterableIterator<PadTemplate> getViaTemplates(Substrate s) {
        return ViaFactory.getViaTemplates(s.getDb()).filter(pt -> pt.getSubstrate() == s);
    }

    public static IterableIterator<PadTemplate> getViaTemplates(Db db) {
        return new FilteringIterator<PadTemplate>((Iterator)db.getObjects(PadTemplate.class)){

            protected boolean include(PadTemplate pt) {
                if (ViaFactory.getViaMaker(pt) == PadTemplate.ViaMakerType.Unknown) {
                    return false;
                }
                return pt.getLayers().size() > 1;
            }
        };
    }

    public void setOffsetFromOrigin(boolean state) {
        this.offsetFromOrigin = state;
    }

    public void setLayers(String topLayer, String cutLayer, String botLayer) {
        this.topLayer = topLayer;
        this.cutLayer = cutLayer;
        this.botLayer = botLayer;
    }

    public void setCutDxDy(long dx, long dy) {
        this.cutDx = dx;
        this.cutDy = dy;
    }

    @Deprecated
    public void addCol(long dx, long numOpenings) {
        VDesc v = new VDesc();
        v.ds = dx;
        v.numOpenings = numOpenings;
        this.rows.add(v);
    }

    public void setOpening(long x, long y) {
        this.oX = x;
        this.oY = y;
    }

    public void setOrigin(long xOffset, long yOffset) {
        this.xOffset = xOffset;
        this.yOffset = yOffset;
    }

    public void setOffset(long xBotOffset, long yBotOffset, long xTopOffset, long yTopOffset) {
        this.xBotOffset = xBotOffset;
        this.yBotOffset = yBotOffset;
        this.xTopOffset = xTopOffset;
        this.yTopOffset = yTopOffset;
    }

    public void setPattern(String pattern) {
        this.viaPattern = ViaPattern.newViaPattern(pattern);
    }

    public void setRowCol(long row, long col) {
        this.nRow = row;
        this.nCol = col;
    }

    @Deprecated
    public void setExtents(long x, long y) {
        this.eX = x;
        this.eY = y;
    }

    public void setEnclosure(long xBotEnc, long yBotEnc, long xTopEnc, long yTopEnc) {
        this.xBotEnc = xBotEnc;
        this.yBotEnc = yBotEnc;
        this.xTopEnc = xTopEnc;
        this.yTopEnc = yTopEnc;
    }

    public PadTemplate makeViaFromFactoryByColLEFDEF(Substrate s, String viaName) {
        Layer top = s.getLayer(this.topLayer);
        Layer cut = s.getLayer(this.cutLayer);
        Layer bot = s.getLayer(this.botLayer);
        if (top == null || cut == null || bot == null) {
            ALog.logDebug((String)"Top layer:'%s' exist:%b. Cut layer:'%s' exist:%b. Bottom layer:'%s' exist:%b.", (Object[])new Object[]{this.topLayer, top != null, this.cutLayer, cut != null, this.botLayer, bot != null});
            return null;
        }
        PadTemplate padTemplate = PadTemplate.create((Db)OrbitIO.getCurDb(), (Substrate)s, (String)viaName);
        ViaFactory.setViaMaker(padTemplate, PadTemplate.ViaMakerType.User);
        long width = this.nCol * this.oX + (this.nCol - 1L) * this.cutDx;
        long height = this.nRow * this.oY + (this.nRow - 1L) * this.cutDy;
        long llx = -width / 2L;
        long lly = -height / 2L;
        long x = llx + this.xOffset;
        int col = 0;
        while ((long)col < this.nCol) {
            long y = lly + this.yOffset;
            int row = 0;
            while ((long)row < this.nRow) {
                ARect opening = new ARect(x, y, x + this.oX, y + this.oY);
                if (this.viaPattern == null || this.viaPattern.shouldCut(row, col)) {
                    LayerShape.create((Db)OrbitIO.getCurDb(), (Layer)cut, (DbObject)padTemplate, (AGeom)opening);
                }
                y += this.oY + this.cutDy;
                ++row;
            }
            x += this.oX + this.cutDx;
            ++col;
        }
        long minX = -width / 2L + this.xOffset + this.xTopOffset;
        long maxX = width / 2L + this.xOffset + this.yTopOffset;
        long minY = -height / 2L + this.yOffset + this.xBotOffset;
        long maxY = height / 2L + this.yOffset + this.yBotOffset;
        ARect topRect = new ARect(minX - this.xTopEnc, minY - this.yTopEnc, maxX + this.xTopEnc, maxY + this.yTopEnc);
        ARect botRect = new ARect(minX - this.xBotEnc, minY - this.yBotEnc, maxX + this.xBotEnc, maxY + this.yBotEnc);
        LayerShape.create((Db)OrbitIO.getCurDb(), (Layer)top, (DbObject)padTemplate, (AGeom)topRect);
        LayerShape.create((Db)OrbitIO.getCurDb(), (Layer)bot, (DbObject)padTemplate, (AGeom)botRect);
        return padTemplate;
    }

    @Deprecated
    public PadTemplate makeViaFromFactoryByCol(Substrate s, String viaName) {
        Layer top = s.getLayer(this.topLayer);
        if (top == null) {
            ALog.logError((String)("No such layer " + this.topLayer));
            return null;
        }
        Layer cut = s.getLayer(this.cutLayer);
        if (cut == null) {
            ALog.logError((String)("No such layer " + this.cutLayer));
            return null;
        }
        Layer bot = s.getLayer(this.botLayer);
        if (bot == null) {
            ALog.logError((String)("No such layer" + this.botLayer));
            return null;
        }
        PadTemplate padTemplate = PadTemplate.create((Db)OrbitIO.getCurDb(), (Substrate)s, (String)viaName);
        ViaFactory.setViaMaker(padTemplate, PadTemplate.ViaMakerType.User);
        long x = 0L;
        long y = 0L;
        LinkedList<ARect> cuts = new LinkedList<ARect>();
        for (VDesc vDesc : this.rows) {
            x += vDesc.ds;
            x += this.cutDx;
            int col = 0;
            while ((long)col < vDesc.numOpenings) {
                ARect opening = new ARect(-this.oX / 2L, -this.oY / 2L, this.oX / 2L, this.oY / 2L);
                opening.moveCenterTo(new APoint2D(x, y));
                cuts.add(opening);
                LayerShape.create((Db)OrbitIO.getCurDb(), (Layer)cut, (DbObject)padTemplate, (AGeom)opening);
                y -= this.cutDy;
                ++col;
            }
            y = 0L;
        }
        if (cuts.size() > 0) {
            ARect bounds = new ARect((ARect)cuts.get(0));
            for (ARect aCut : cuts) {
                bounds.expand(aCut);
            }
            APoint2D aPoint2D = bounds.center();
            for (ARect aCut : cuts) {
                aCut.moveBy(-aPoint2D.getX(), -aPoint2D.getY());
            }
            bounds = new ARect((ARect)cuts.get(0));
            for (ARect aCut : cuts) {
                bounds.expand(aCut);
            }
            bounds = bounds.expandBy(this.eX, this.eY);
            LayerShape.create((Db)OrbitIO.getCurDb(), (Layer)top, (DbObject)padTemplate, (AGeom)bounds);
            LayerShape.create((Db)OrbitIO.getCurDb(), (Layer)bot, (DbObject)padTemplate, (AGeom)bounds);
        }
        return padTemplate;
    }

    @Deprecated
    public PadTemplate makeViaFromFactoryByCol(String dp, String viaName) {
        DevicePath devicePath = DevicePath.fromString((Db)OrbitIO.getCurDb(), (String)dp);
        if (devicePath == null) {
            ALog.logError((String)"'%s' is not a valid device path", (Object[])new Object[]{dp});
            return null;
        }
        Substrate s = devicePath.getSubstrate();
        return this.makeViaFromFactoryByCol(s, viaName);
    }

    public void correlateViaToAllPins(String devicePathString, String deviceTemplateName, String viaName, boolean replace, long dx, long dy) {
        DevicePath devicePath = DevicePath.fromString((Db)OrbitIO.getCurDb(), (String)devicePathString);
        Device d = devicePath.getLast();
        if (d == null) {
            ALog.logError((String)"Device '%s' does not exist", (Object[])new Object[]{devicePathString});
            return;
        }
        int count = 0;
        Substrate s = devicePath.getSubstrate();
        DeviceTemplate dt = DeviceTemplate.getDeviceTemplate((Substrate)s, (String)deviceTemplateName);
        for (PinTemplate pt : dt.getPins()) {
            if (ViaFactory.getCorrelatedVia(pt) != null && !replace) continue;
            ViaFactory.setCorrelatedViaName(pt, viaName);
            ViaFactory.setCorrelatedViaOffset(pt, new APoint2D(dx, dy));
            ViaFactory.setCorrelatedViaOffsetOrigin(pt, this.offsetFromOrigin);
            ++count;
        }
        ALog.logInfo((String)("There were " + count + " pins associated with the via named " + viaName));
    }

    public void correlateVia(String devicePathString, String deviceTemplateNamePattern, String portName, String viaName, boolean replace) {
        this.correlateVia(devicePathString, deviceTemplateNamePattern, portName, viaName, replace, 0L, 0L);
    }

    public void correlateVia(String devicePathString, String deviceTemplateNameExpr, String portNameExpr, String viaName, boolean replace, long dx, long dy) {
        DevicePath devicePath = DevicePath.fromString((Db)OrbitIO.getCurDb(), (String)devicePathString);
        Device d = devicePath.getLast();
        if (d == null) {
            ALog.logWarn((String)"Device '%s' does not exist", (Object[])new Object[]{devicePathString});
            return;
        }
        int count = 0;
        Substrate s = devicePath.getSubstrate();
        Pattern templatePattern = Pattern.compile(deviceTemplateNameExpr);
        Pattern portNamePattern = Pattern.compile(portNameExpr);
        for (DeviceTemplate dt : s.getDeviceTemplates()) {
            if (!templatePattern.matcher(dt.getName()).matches()) continue;
            boolean portFound = false;
            for (PinTemplate pt : dt.getPins()) {
                if (!portNamePattern.matcher(pt.getName()).matches() || ViaFactory.getCorrelatedVia(pt) != null && !replace) continue;
                ViaFactory.setCorrelatedViaName(pt, viaName);
                ViaFactory.setCorrelatedViaOffset(pt, new APoint2D(dx, dy));
                ViaFactory.setCorrelatedViaOffsetOrigin(pt, this.offsetFromOrigin);
                ++count;
                portFound = true;
            }
            if (portFound) continue;
            ALog.logWarn((String)("There is no pin matching " + portNameExpr + " on " + dt.getName()));
        }
        ALog.logInfo((String)("There were " + count + " pins associated with the via named " + viaName));
    }

    class VDesc {
        long ds;
        long numOpenings;

        VDesc() {
        }
    }

    public static enum ViaInstantiatorType {
        User,
        Def,
        Router,
        Unknown;

    }
}

