/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.factory;

import com.sigrity.acl.ALog;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Pattern;

class ViaPattern {
    static Pattern mDefViaPattern = Pattern.compile("_?([0-9A-Fa-f]+)_(R[0-9A-Fa-f])*([0-9A-Fa-f]+)");
    ArrayList<BigInteger> bitmask = new ArrayList();
    static Map<Character, Character> mReverseBits = Map.ofEntries(Map.entry(Character.valueOf('0'), Character.valueOf('0')), Map.entry(Character.valueOf('1'), Character.valueOf('8')), Map.entry(Character.valueOf('2'), Character.valueOf('4')), Map.entry(Character.valueOf('3'), Character.valueOf('C')), Map.entry(Character.valueOf('4'), Character.valueOf('2')), Map.entry(Character.valueOf('5'), Character.valueOf('A')), Map.entry(Character.valueOf('6'), Character.valueOf('6')), Map.entry(Character.valueOf('7'), Character.valueOf('E')), Map.entry(Character.valueOf('8'), Character.valueOf('1')), Map.entry(Character.valueOf('9'), Character.valueOf('9')), Map.entry(Character.valueOf('A'), Character.valueOf('5')), Map.entry(Character.valueOf('B'), Character.valueOf('D')), Map.entry(Character.valueOf('C'), Character.valueOf('3')), Map.entry(Character.valueOf('D'), Character.valueOf('B')), Map.entry(Character.valueOf('E'), Character.valueOf('7')), Map.entry(Character.valueOf('F'), Character.valueOf('F')));

    static ViaPattern newViaPattern(String pattern) {
        ViaPattern vp = new ViaPattern();
        vp.expand(pattern);
        return vp;
    }

    private ViaPattern() {
    }

    private String reverse(String numberInHex) {
        numberInHex = numberInHex.toUpperCase();
        StringBuilder rev = new StringBuilder();
        try {
            for (int i = numberInHex.length() - 1; i >= 0; --i) {
                rev.append(mReverseBits.get(Character.valueOf(numberInHex.charAt(i))));
            }
        }
        catch (Exception e) {
            ALog.logWarn((Throwable)e, (String)"Unable to reverse hex number string: %s", (Object[])new Object[]{numberInHex});
            rev.setLength(0);
        }
        return rev.toString();
    }

    private String getHexDigits(String rowDefinition) {
        StringBuilder hexDigits = new StringBuilder();
        for (int index = 0; index < rowDefinition.length(); ++index) {
            int repeat = 1;
            if (rowDefinition.startsWith("R", index)) {
                repeat = Character.digit(rowDefinition.charAt(index + 1), 16);
                index += 2;
            }
            char hex = rowDefinition.charAt(index);
            for (int i = 0; i < repeat; ++i) {
                hexDigits.append(hex);
            }
        }
        return hexDigits.toString();
    }

    private void expand(String pattern) {
        try {
            String[] cutPattern = pattern.split("_");
            for (int i = 0; i < cutPattern.length && !"MC".equals(cutPattern[i]) && !"MR".equals(cutPattern[i]); i += 2) {
                int numRows = Integer.parseInt(cutPattern[i], 16);
                String hexDigits = this.getHexDigits(cutPattern[i + 1]);
                hexDigits = this.reverse(hexDigits);
                BigInteger bi = new BigInteger(hexDigits, 16);
                for (int nr = 0; nr < numRows; ++nr) {
                    this.bitmask.add(bi);
                }
            }
        }
        catch (Exception e) {
            ALog.logWarn((Throwable)e, (String)"Unable to parse pattern: %s in DEF VIA.", (Object[])new Object[]{pattern});
        }
    }

    boolean shouldCut(int rowIndex, int colIndex) {
        BigInteger bi = BigInteger.ZERO;
        try {
            bi = bi.setBit(colIndex);
            BigInteger test = bi.and(this.bitmask.get(rowIndex));
            return !test.equals(BigInteger.ZERO);
        }
        catch (Exception e) {
            ALog.logWarn((Throwable)e, (String)"Unable to get maskbit for row: %d, column: %d.", (Object[])new Object[]{rowIndex, colIndex});
            return false;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (BigInteger bm : this.bitmask) {
            sb.append(bm.toString(16));
            sb.append(System.lineSeparator());
        }
        return sb.toString();
    }

    public String toHexString() {
        StringBuilder sb = new StringBuilder();
        for (BigInteger bm : this.bitmask) {
            sb.append(bm.toString(16));
        }
        return sb.toString();
    }
}

