/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.flowDev;

import com.sigrity.acl.ALog;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.PortTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.optimizer.PortPairOpt;
import com.sigrity.acl.optimizer.RoomFinder;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.UserCommands;
import com.sigrity.orbit.ui.FixedFreePinSelection;
import com.sigrity.orbit.ui.PersonalityUI;
import java.util.Optional;

public class FlowUtils {
    public static void transformDieCommand(String packagePathString, String devicePathString) {
        Cp.exec((String)"com.sigrity.orbit.flowDev.FlowUtils.transformDie (\"%s\", \"%s\");", (Object[])new Object[]{packagePathString, devicePathString});
    }

    public static void analyzePersonalitiesCommand(String diePathString) {
        Cp.exec((String)"com.sigrity.orbit.flowDev.FlowUtils.analyzePersonalities ( \"%s\");", (Object[])new Object[]{diePathString});
    }

    public static void mapDieToPackageCommand(String diePathString) {
        Cp.exec((String)"com.sigrity.orbit.flowDev.FlowUtils.mapDieToPackage ( \"%s\");", (Object[])new Object[]{diePathString});
    }

    public static void mapDieToPackage(String diePathString) {
        Db db = OrbitIO.getCurDb();
        DevicePath diePath = DevicePath.fromString((Db)db, (String)diePathString);
        if (diePath == null) {
            ALog.logWarn((String)"DevicePath '%s' does not exist", (Object[])new Object[]{diePathString});
            return;
        }
        Cp.exec((String)"NetMap.bulkMap(OrbitIO.getCurDb(), \"%s\",  \"(.*)\", 0, \"%s\", 0, com.sigrity.orbit.NetFilters.ALL,com.sigrity.orbit.NetFilters.ALL);", (Object[])new Object[]{diePath.getLast().getKeyStr(), "%1"});
    }

    public static void optFromBallToBumpCommand(String diePathString) {
        Cp.exec((String)"com.sigrity.orbit.flowDev.FlowUtils.optFromBallToBump ( \"%s\");", (Object[])new Object[]{diePathString});
    }

    public static void optFromBumpToBallCommand(String diePathString) {
        Cp.exec((String)"com.sigrity.orbit.flowDev.FlowUtils.optFromBumpToBall ( \"%s\");", (Object[])new Object[]{diePathString});
    }

    public static void optFromBallToBump(String diePathString) {
        Db db = OrbitIO.getCurDb();
        DevicePath diePath = DevicePath.fromString((Db)db, (String)diePathString);
        if (diePath == null) {
            ALog.logWarn((String)"DevicePath '%s' does not exist", (Object[])new Object[]{diePathString});
            return;
        }
        DevicePath packagePath = diePath.getParent();
        UserCommands.unselectAll();
        UserCommands.createConnections();
        OrbitIO.getCurDesign().getCurSelection().clear();
        DeviceTemplate dieDeviceTemplate = diePath.getDeviceTemplate();
        DeviceTemplate packageDeviceTemplate = packagePath.getDeviceTemplate();
        Optional fixedSignalPersonality = Personality.getPersonality((DeviceTemplate)packageDeviceTemplate, (Personality.Type)Personality.Type.PORT, (String)"signal");
        Optional freeSignalPersonality = Personality.getPersonality((DeviceTemplate)dieDeviceTemplate, (Personality.Type)Personality.Type.PORT, (String)"signal");
        if (fixedSignalPersonality.isPresent()) {
            FixedFreePinSelection.selectPortOnPersonality(packagePath, (Personality)fixedSignalPersonality.get());
        }
        FixedFreePinSelection.retrieveSelectedPathObjectsOnA();
        OrbitIO.getCurDesign().getCurSelection().clear();
        if (freeSignalPersonality.isPresent()) {
            FixedFreePinSelection.selectPortOnPersonality(diePath, (Personality)freeSignalPersonality.get());
        }
        FixedFreePinSelection.retrieveSelectedPathObjectsOnB();
        PortPairOpt.getActive().setCanConnectFunction("any");
        PortPairOpt.setRemoveNetMappingOnToSide(true);
        PortPairOpt.setTreatFromAsIndividuals(false);
        PortPairOpt.getActive().setUseOnlyUsedPortsOnFixedSide(false);
        PortPairOpt.getActive().setUseOnlyUnusedPortsOnFreeSide(false);
        PortPairOpt.getActive().optimize(false);
        OrbitIO.getApp().refreshCurrentView(true);
    }

    public static void optFromBumpToBall(String diePathString) {
        Db db = OrbitIO.getCurDb();
        DevicePath diePath = DevicePath.fromString((Db)db, (String)diePathString);
        if (diePath == null) {
            ALog.logWarn((String)"DevicePath '%s' does not exist", (Object[])new Object[]{diePathString});
            return;
        }
        DevicePath packagePath = diePath.getParent();
        UserCommands.unselectAll();
        UserCommands.createConnections();
        OrbitIO.getCurDesign().getCurSelection().clear();
        DeviceTemplate dieDeviceTemplate = diePath.getDeviceTemplate();
        DeviceTemplate packageDeviceTemplate = packagePath.getDeviceTemplate();
        Optional fixedSignalPersonality = Personality.getPersonality((DeviceTemplate)packageDeviceTemplate, (Personality.Type)Personality.Type.PORT, (String)"signal");
        Optional freeSignalPersonality = Personality.getPersonality((DeviceTemplate)dieDeviceTemplate, (Personality.Type)Personality.Type.PORT, (String)"signal");
        if (fixedSignalPersonality.isPresent()) {
            FixedFreePinSelection.selectPortOnPersonality(packagePath, (Personality)fixedSignalPersonality.get());
        }
        FixedFreePinSelection.retrieveSelectedPathObjectsOnB();
        OrbitIO.getCurDesign().getCurSelection().clear();
        if (freeSignalPersonality.isPresent()) {
            FixedFreePinSelection.selectPortOnPersonality(diePath, (Personality)freeSignalPersonality.get());
        }
        FixedFreePinSelection.retrieveSelectedPathObjectsOnA();
        PortPairOpt.getActive().setCanConnectFunction("any");
        PortPairOpt.setRemoveNetMappingOnToSide(true);
        PortPairOpt.setTreatFromAsIndividuals(false);
        PortPairOpt.getActive().setUseOnlyUsedPortsOnFixedSide(false);
        PortPairOpt.getActive().setUseOnlyUnusedPortsOnFreeSide(false);
        PortPairOpt.getActive().optimize(false);
        OrbitIO.getApp().refreshCurrentView(true);
    }

    public static void analyzePersonalities(String diePathString) {
        Db db = OrbitIO.getCurDb();
        DevicePath diePath = DevicePath.fromString((Db)db, (String)diePathString);
        if (diePath == null) {
            ALog.logWarn((String)"DevicePath '%s' does not exist", (Object[])new Object[]{diePathString});
            return;
        }
        PersonalityUI.assignBumpsToPersonalities(diePathString);
    }

    public static boolean hasPersonalities(String devicePath) {
        return false;
    }

    public static void transformDie(String packagePathString, String devicePathString) {
        Db db = OrbitIO.getCurDb();
        DevicePath diePath = DevicePath.fromString((Db)db, (String)devicePathString);
        if (diePath == null) {
            ALog.logWarn((String)"DevicePath '%s' does not exist", (Object[])new Object[]{devicePathString});
            return;
        }
        DevicePath packagePath = DevicePath.fromString((Db)db, (String)packagePathString);
        if (packagePath == null) {
            ALog.logWarn((String)"DevicePath '%s' does not exist", (Object[])new Object[]{packagePathString});
            return;
        }
        Device d = diePath.getLast();
        Device p = packagePath.getLast();
        boolean flipMe = false;
        if (d.getTemplate().getType() == DeviceTemplate.Type.DIE && p.getTemplate().getType() == DeviceTemplate.Type.PACKAGE) {
            Substrate s = d.getSubstrate();
            int topLayer = s.getTopLayer().getOrder();
            block0: for (DevicePath descendent : diePath.getDescendants()) {
                if (flipMe) break;
                if (!descendent.getSubstrate().equals((Object)d.getSubstrate())) continue;
                DeviceTemplate dt = descendent.getDeviceTemplate();
                for (PinTemplate pt : dt.getPins()) {
                    PortTemplate portTemplate;
                    PadTemplate padTemplate;
                    int topLayerOrder;
                    if (!pt.getType().equals((Object)PinTemplate.Type.BUMPPAD) || (topLayerOrder = (padTemplate = (portTemplate = pt.getFirstPortTemplate()).getPadTemplate()).getTopLayerOrder()) != topLayer) continue;
                    flipMe = true;
                    continue block0;
                }
            }
        }
        if (flipMe) {
            d.setFlipped(true);
        }
        diePath.getLast().setParent(packagePath.getLast(), false);
        DevicePath newDiePath = d.getADevicePath();
        RoomFinder.findCenter(newDiePath);
    }
}

