/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.inter_substrate_checks;

import com.sigrity.acl.ALog;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.ContactLayer;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.PinMap;
import com.sigrity.orbit.inter_substrate_checks.PinMapCheck;
import java.util.List;
import java.util.stream.Collectors;

public class DesignNetNameCheck
extends PinMapCheck.Check {
    public DesignNetNameCheck(Db db) {
        super(db);
        this.mName = "Design Net Name";
        this.mCheckType = PinMapCheck.CheckType.DESIGN_NET_NAME;
    }

    @Override
    public void execute() {
        this.checkNetName();
        ALog.logDebug((String)"Design net name checking complete.");
    }

    protected void checkNetName() {
        List pinMaps = this.getContactLayers().stream().flatMap(contactLayer -> PinMap.get((ContactLayer)contactLayer).stream()).collect(Collectors.toList());
        for (PinMap pinMap : pinMaps) {
            if (DesignNetNameCheck.isDesignNetNameMatch(pinMap)) {
                this.mValidations.add(new DesignNetNameResult(pinMap, true));
                continue;
            }
            this.mViolations.add(new DesignNetNameViolation(pinMap));
        }
    }

    private static boolean isDesignNetNameMatch(PinMap pinMap) {
        Net netA = pinMap.getNetAtSubstrateInstA();
        Net netB = pinMap.getNetAtSubstrateInstB();
        if (netA == null && netB == null) {
            return true;
        }
        if (netA == null || netB == null) {
            return false;
        }
        String netNameA = netA.getName();
        String netNameB = netB.getName();
        return netNameA.equals(netNameB);
    }

    public class DesignNetNameViolation
    extends DesignNetNameResult
    implements PinMapCheck.Violation {
        DesignNetNameViolation(PinMap pinMap) {
            super(pinMap, false);
        }

        @Override
        public boolean isFixed() {
            return DesignNetNameCheck.isDesignNetNameMatch(this.pinMap);
        }
    }

    public class DesignNetNameResult
    implements PinMapCheck.CheckResult {
        PinMap pinMap;
        protected boolean isValidated;

        DesignNetNameResult(PinMap pinMap, boolean isValidated) {
            this.pinMap = pinMap;
            this.isValidated = isValidated;
        }

        public PinMap getPinMap() {
            return this.pinMap;
        }

        @Override
        public String getText() {
            return this.pinMap.toString();
        }

        @Override
        public boolean isValidated() {
            return this.isValidated;
        }
    }
}

