/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.inter_substrate_checks;

import com.sigrity.acl.ALog;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.ContactLayer;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.PinMap;
import com.sigrity.orbit.inter_substrate_checks.PinMapCheck;
import java.util.List;
import java.util.stream.Collectors;

public class LocalNetNameCheck
extends PinMapCheck.Check {
    public LocalNetNameCheck(Db db) {
        super(db);
        this.mName = "Local Net Name";
        this.mCheckType = PinMapCheck.CheckType.LOCAL_NET_NAME;
    }

    @Override
    public void execute() {
        this.checkLocalNetName();
        ALog.logDebug((String)"Local net name checking complete.");
    }

    protected void checkLocalNetName() {
        List pinMaps = this.getContactLayers().stream().flatMap(contactLayer -> PinMap.get((ContactLayer)contactLayer).stream()).collect(Collectors.toList());
        for (PinMap pinMap : pinMaps) {
            if (LocalNetNameCheck.isLocalNetNameMatch(pinMap)) {
                this.mValidations.add(new LocalNetNameResult(pinMap, true));
                continue;
            }
            this.mViolations.add(new LocalNetNameViolation(pinMap));
        }
    }

    private static boolean isLocalNetNameMatch(PinMap pinMap) {
        Net netAtContactDevA = pinMap.getNetAtContactDevA();
        Net netAtContactDevB = pinMap.getNetAtContactDevB();
        if (netAtContactDevA == null && netAtContactDevB == null) {
            return true;
        }
        if (netAtContactDevA == null || netAtContactDevB == null) {
            return false;
        }
        String netNameA = netAtContactDevA.getName();
        String netNameB = netAtContactDevB.getName();
        return netNameA.equals(netNameB);
    }

    public class LocalNetNameViolation
    extends LocalNetNameResult
    implements PinMapCheck.Violation {
        LocalNetNameViolation(PinMap pinMap) {
            super(pinMap, false);
        }

        @Override
        public boolean isFixed() {
            return LocalNetNameCheck.isLocalNetNameMatch(this.pinMap);
        }
    }

    public class LocalNetNameResult
    implements PinMapCheck.CheckResult {
        PinMap pinMap;
        protected boolean isValidated;

        LocalNetNameResult(PinMap pinMap, boolean isValidated) {
            this.pinMap = pinMap;
            this.isValidated = isValidated;
        }

        public PinMap getPinMap() {
            return this.pinMap;
        }

        @Override
        public String getText() {
            return this.pinMap.toString();
        }

        @Override
        public boolean isValidated() {
            return this.isValidated;
        }
    }
}

