/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.inter_substrate_checks;

import com.sigrity.acl.ALog;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.ContactLayer;
import com.sigrity.acl.db.std.PinMap;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.inter_substrate_checks.PinMapCheck;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.Action;

public class NetMappingCheck
extends PinMapCheck.Check {
    public static Action getAction() {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NetMappingCheck.checkNetMapsOfPinMaps();
            }

            @Override
            public boolean isEnabled() {
                return super.isEnabled() && OrbitIO.getCurDb() != null;
            }
        };
    }

    public static void checkNetMapsOfPinMaps() {
        Db curDb = OrbitIO.getCurDb();
        if (curDb == null) {
            ALog.logWarn((String)"Open an orbit design before runing this command.");
            return;
        }
        PinMapCheck checker = new PinMapCheck(curDb);
        checker.addCheck(PinMapCheck.CheckType.NET_MAPPING);
        checker.execute();
        checker.showResultUI();
    }

    public NetMappingCheck(Db db) {
        super(db);
        this.mName = "Net Mapping";
        this.mCheckType = PinMapCheck.CheckType.NET_MAPPING;
    }

    @Override
    public void execute() {
        this.check();
        ALog.logDebug((String)"Net mapping checking complete.");
    }

    public void check() {
        List pinMaps = this.getContactLayers().stream().flatMap(contactLayer -> PinMap.get((ContactLayer)contactLayer).stream()).collect(Collectors.toList());
        for (PinMap pinMap : pinMaps) {
            if (pinMap.hasNetMapping()) {
                this.mValidations.add(new NetMappingResult(pinMap, true));
                continue;
            }
            this.mViolations.add(new NetMappingViolation(pinMap));
        }
    }

    public class NetMappingViolation
    extends NetMappingResult
    implements PinMapCheck.Violation {
        NetMappingViolation(PinMap pinMap) {
            super(pinMap, false);
        }

        @Override
        public boolean isFixed() {
            return this.pinMap.hasNetMapping();
        }
    }

    public class NetMappingResult
    implements PinMapCheck.CheckResult {
        PinMap pinMap;
        protected boolean isValidated;

        NetMappingResult(PinMap pinMap, boolean isValidated) {
            this.pinMap = pinMap;
            this.isValidated = isValidated;
        }

        public PinMap getPinMap() {
            return this.pinMap;
        }

        public ContactLayer getContactLayer() {
            return this.pinMap.getContactLayer();
        }

        @Override
        public String getText() {
            return this.pinMap.toString();
        }

        @Override
        public boolean isValidated() {
            return this.isValidated;
        }
    }
}

