/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.inter_substrate_checks;

import com.sigrity.acl.ALog;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Constraint;
import com.sigrity.acl.db.std.ContactLayer;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.PersonalityMap;
import com.sigrity.acl.db.std.PinMap;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.inter_substrate_checks.PinMapCheck;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class NetPersonalityCheck
extends PinMapCheck.Check {
    public NetPersonalityCheck(Db db) {
        super(db);
        this.mName = "Net Personality";
        this.mCheckType = PinMapCheck.CheckType.NET_PERSONALITY;
    }

    @Override
    public void execute() {
        this.check();
        ALog.logDebug((String)"Net personality checking complete.");
    }

    public void check() {
        List pinMaps = this.getContactLayers().stream().flatMap(contactLayer -> PinMap.get((ContactLayer)contactLayer).stream()).collect(Collectors.toList());
        for (PinMap pinMap : pinMaps) {
            if (NetPersonalityCheck.matchPersonality(pinMap)) {
                this.mValidations.add(new NetPersonalityResult(pinMap, true));
                continue;
            }
            this.mViolations.add(this.createViolation(pinMap));
        }
    }

    private PinMapCheck.Violation createViolation(PinMap pinMap) {
        boolean isPowerA = NetPersonalityCheck.getPinMapNetPersonalityA(pinMap).anyMatch(this::isPower);
        boolean isPowerB = NetPersonalityCheck.getPinMapNetPersonalityB(pinMap).anyMatch(this::isPower);
        if (isPowerA && isPowerB) {
            return new PowerNetPersonalityViolation(pinMap);
        }
        if (!isPowerA && !isPowerB) {
            return new SignalNetPersonalityViolation(pinMap);
        }
        return new PowerSignalNetPersonalityViolation(pinMap);
    }

    private boolean isPower(Personality personality) {
        Boolean isPower = (Boolean)Constraint.getValue((Db)this.mDb, (DbObject)personality, (Constraint.Descriptor)Constraint.IS_POWER);
        return isPower != null && isPower != false;
    }

    private static boolean matchPersonality(PinMap pinMap) {
        Set personalityNameASet = NetPersonalityCheck.getPinMapNetPersonalityA(pinMap).map(Personality::getName).collect(Collectors.toSet());
        return NetPersonalityCheck.getPinMapNetPersonalityB(pinMap).anyMatch(p -> personalityNameASet.contains(p.getName()));
    }

    private static Stream<Personality> getPinMapNetPersonalityA(PinMap pinMap) {
        Net net = pinMap.getNetAtContactDevA();
        DevicePath path = pinMap.getContactDevPathA();
        return NetPersonalityCheck.getPersonality(path, net);
    }

    private static Stream<Personality> getPinMapNetPersonalityB(PinMap pinMap) {
        Net net = pinMap.getNetAtContactDevB();
        DevicePath path = pinMap.getContactDevPathB();
        return NetPersonalityCheck.getPersonality(path, net);
    }

    private static Stream<Personality> getPersonality(DevicePath path, Net net) {
        return PersonalityMap.getPersonalities((Personality.Type)Personality.Type.NET, (DbObject)net, (DevicePath)path).map(PersonalityMap::getPersonality);
    }

    public class NetPersonalityViolation
    extends NetPersonalityResult
    implements PinMapCheck.Violation {
        public final ViolationType mViolationType;

        NetPersonalityViolation(ViolationType vType, PinMap pinMap) {
            super(pinMap, false);
            this.mViolationType = vType;
        }

        public ViolationType getViolationType() {
            return this.mViolationType;
        }

        @Override
        public boolean isFixed() {
            return NetPersonalityCheck.matchPersonality(this.pinMap);
        }

        @Override
        public String getText() {
            return this.mViolationType.getName();
        }
    }

    public class NetPersonalityResult
    implements PinMapCheck.CheckResult {
        PinMap pinMap;
        List<Personality> personalityA;
        List<Personality> personalityB;
        protected boolean isValidated;

        NetPersonalityResult(PinMap pinMap, boolean isValidated) {
            this.pinMap = pinMap;
            this.isValidated = isValidated;
        }

        public PinMap getPinMap() {
            return this.pinMap;
        }

        public ContactLayer getContactLayer() {
            return this.pinMap.getContactLayer();
        }

        public List<Personality> getPersonalityA() {
            if (this.personalityA == null) {
                this.personalityA = NetPersonalityCheck.getPinMapNetPersonalityA(this.pinMap).collect(Collectors.toList());
            }
            return this.personalityA;
        }

        public List<Personality> getPersonalityB() {
            if (this.personalityB == null) {
                this.personalityB = NetPersonalityCheck.getPinMapNetPersonalityB(this.pinMap).collect(Collectors.toList());
            }
            return this.personalityB;
        }

        @Override
        public String getText() {
            return this.pinMap.toString();
        }

        @Override
        public boolean isValidated() {
            return this.isValidated;
        }
    }

    public class PowerSignalNetPersonalityViolation
    extends NetPersonalityViolation {
        PowerSignalNetPersonalityViolation(PinMap pinMap) {
            super(ViolationType.POWER_SIGNAL, pinMap);
        }
    }

    public class SignalNetPersonalityViolation
    extends NetPersonalityViolation {
        SignalNetPersonalityViolation(PinMap pinMap) {
            super(ViolationType.SIGNAL, pinMap);
        }
    }

    public class PowerNetPersonalityViolation
    extends NetPersonalityViolation {
        PowerNetPersonalityViolation(PinMap pinMap) {
            super(ViolationType.POWER, pinMap);
        }
    }

    public static enum ViolationType {
        POWER("Power"),
        SIGNAL("Signal"),
        POWER_SIGNAL("Power-Signal");

        String name;

        private ViolationType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

