/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.inter_substrate_checks;

import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.ContactLayer;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.PinMap;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.inter_substrate_checks.PinMapCheck;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PinCountMismatchCheck
extends PinMapCheck.Check {
    public PinCountMismatchCheck(Db db) {
        super(db);
        this.mName = "Pin Count Mismatch";
        this.mCheckType = PinMapCheck.CheckType.PIN_COUNT_MISMATCH;
    }

    @Override
    public void execute() {
        this.checkAPortWithAWire();
        ALog.logDebug((String)"Pin count mismatch checking complete.");
    }

    protected void checkAPortWithAWire() {
        Map hierPin2PinMap = this.getContactLayers().stream().flatMap(contactLayer -> PinMap.get((ContactLayer)contactLayer).stream()).distinct().flatMap(pm -> Stream.of(APair.create((Object)pm.getHierPinA(), (Object)pm), APair.create((Object)pm.getHierPinB(), (Object)pm))).collect(Collectors.groupingBy(APair::getFirst, Collectors.mapping(APair::getSecond, Collectors.toList())));
        for (Map.Entry entry : hierPin2PinMap.entrySet()) {
            HierInst hierPin = entry.getKey();
            List<PinMap> pinMaps = entry.getValue();
            if (pinMaps.size() > 1) {
                this.addPinCountMismatchResult(false, (HierInst<PinTemplate>)hierPin, pinMaps);
                continue;
            }
            if (pinMaps.size() != 1) continue;
            this.addPinCountMismatchResult(true, (HierInst<PinTemplate>)hierPin, pinMaps);
        }
    }

    protected void addPinCountMismatchResult(boolean isValidated, HierInst<PinTemplate> hierPin, List<PinMap> pinMaps) {
        if (isValidated) {
            PinCountMismatchResult v = new PinCountMismatchResult(hierPin.getPath(), (PinTemplate)hierPin.getSecond(), pinMaps, true);
            this.mValidations.add(v);
        } else {
            PinCountMismatchViolation v = new PinCountMismatchViolation(hierPin.getPath(), (PinTemplate)hierPin.getSecond(), pinMaps);
            this.mViolations.add(v);
        }
    }

    public class PinCountMismatchViolation
    extends PinCountMismatchResult
    implements PinMapCheck.Violation {
        PinCountMismatchViolation(DevicePath pinPath, PinTemplate pin, List<PinMap> pinMaps) {
            super(pinPath, pin, pinMaps, false);
        }

        @Override
        public boolean isFixed() {
            return false;
        }
    }

    public class PinCountMismatchResult
    implements PinMapCheck.CheckResult {
        DevicePath devPath;
        Layer layer;
        DevicePath pinPath;
        PinTemplate pin;
        List<PinMap> pinMaps;
        protected boolean isValidated;

        PinCountMismatchResult(DevicePath pinPath, PinTemplate pin, List<PinMap> pinMaps, boolean isValidated) {
            this.pinPath = pinPath;
            this.pin = pin;
            this.pinMaps = pinMaps;
            this.isValidated = isValidated;
            this.setContactDevPathAndLayer();
        }

        private void setContactDevPathAndLayer() {
            ContactLayer contactLayer = this.pinMaps.get(0).getContactLayer();
            if (this.isPinOnContactLayerPathB(contactLayer)) {
                this.devPath = contactLayer.getDevicePathB();
                this.layer = contactLayer.getContactLayerB();
            } else {
                this.devPath = contactLayer.getDevicePathA();
                this.layer = contactLayer.getContactLayerA();
            }
        }

        private boolean isPinOnContactLayerPathB(ContactLayer contactLayer) {
            DevicePath substrateContactLayerPathB = contactLayer.getDevicePathB().pathToSubstrate();
            DevicePath pinPathToSubstrate = this.pinPath.pathToSubstrate();
            if (pinPathToSubstrate == null) {
                return substrateContactLayerPathB == null;
            }
            return pinPathToSubstrate.equals((Object)substrateContactLayerPathB);
        }

        @Override
        public String getText() {
            return String.format("%s.%s", this.pinPath.getDevice().getName(), this.pin.getName());
        }

        @Override
        public boolean isValidated() {
            return this.isValidated;
        }

        public DevicePath getDevPath() {
            return this.devPath;
        }

        public Layer getLayer() {
            return this.layer;
        }

        public DevicePath getPinPath() {
            return this.pinPath;
        }

        public DevicePath getPinPathFromContactDev() {
            return this.pinPath.getRelativePathFromAnchor(this.devPath.getDeviceTemplate());
        }

        public PinTemplate getPin() {
            return this.pin;
        }

        public List<PinMap> getPinMaps() {
            return this.pinMaps;
        }
    }
}

