/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.inter_substrate_checks;

import com.sigrity.acl.ALog;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.ContactLayer;
import com.sigrity.acl.db.std.PinMap;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.orbit.inter_substrate_checks.PinMapCheck;
import java.util.List;
import java.util.stream.Collectors;

public class PinDirectionCheck
extends PinMapCheck.Check {
    public PinDirectionCheck(Db db) {
        super(db);
        this.mName = "Pin Direction";
        this.mCheckType = PinMapCheck.CheckType.PIN_DIRECTION;
    }

    @Override
    public void execute() {
        this.checkPinsHaveOppositeDirection();
        ALog.logDebug((String)"Pin direction checking complete.");
    }

    protected void checkPinsHaveOppositeDirection() {
        List pinMaps = this.getContactLayers().stream().flatMap(contactLayer -> PinMap.get((ContactLayer)contactLayer).stream()).collect(Collectors.toList());
        for (PinMap pinMap : pinMaps) {
            PinTemplate.Direction pinADirection = pinMap.getPinA().getDirection();
            PinTemplate.Direction pinBDirection = pinMap.getPinB().getDirection();
            if (pinADirection == PinTemplate.Direction.IN && pinBDirection == PinTemplate.Direction.IN || pinADirection == PinTemplate.Direction.OUT && pinBDirection == PinTemplate.Direction.OUT) {
                PinDirectionViolation violation = new PinDirectionViolation(pinMap);
                this.mViolations.add(violation);
                continue;
            }
            PinDirectionResult validation = new PinDirectionResult(pinMap, true);
            this.mValidations.add(validation);
        }
    }

    public class PinDirectionViolation
    extends PinDirectionResult
    implements PinMapCheck.Violation {
        PinDirectionViolation(PinMap pinMap) {
            super(pinMap, false);
        }

        @Override
        public boolean isFixed() {
            PinTemplate.Direction pinADirection = this.pinMap.getPinA().getDirection();
            PinTemplate.Direction pinBDirection = this.pinMap.getPinB().getDirection();
            return !(pinADirection == PinTemplate.Direction.IN && pinBDirection == PinTemplate.Direction.IN || pinADirection == PinTemplate.Direction.OUT && pinBDirection == PinTemplate.Direction.OUT);
        }
    }

    public class PinDirectionResult
    implements PinMapCheck.CheckResult {
        PinMap pinMap;
        protected boolean isValidated;

        PinDirectionResult(PinMap pinMap, boolean isValidated) {
            this.pinMap = pinMap;
            this.isValidated = isValidated;
        }

        public PinMap getPinMap() {
            return this.pinMap;
        }

        @Override
        public String getText() {
            return this.pinMap.toString();
        }

        @Override
        public boolean isValidated() {
            return this.isValidated;
        }
    }
}

