/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.inter_substrate_checks;

import com.sigrity.acl.AUtil;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.ContactLayer;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.inter_substrate_checks.DesignNetNameCheck;
import com.sigrity.orbit.inter_substrate_checks.LocalNetNameCheck;
import com.sigrity.orbit.inter_substrate_checks.NetMappingCheck;
import com.sigrity.orbit.inter_substrate_checks.NetPersonalityCheck;
import com.sigrity.orbit.inter_substrate_checks.PinCountMismatchCheck;
import com.sigrity.orbit.inter_substrate_checks.PinDirectionCheck;
import com.sigrity.orbit.inter_substrate_checks.PinNameCheck;
import com.sigrity.orbit.inter_substrate_checks.PinOffsetCheck;
import com.sigrity.orbit.inter_substrate_checks.PinUnmappedCheck;
import com.sigrity.orbit.inter_substrate_checks.PortContactCheck;
import com.sigrity.orbit.inter_substrate_checks.ui.PinMapCheckEngineUI;
import com.sigrity.orbit.inter_substrate_checks.ui.PinMapCheckResultCsv;
import com.sigrity.orbit.inter_substrate_checks.ui.PinMapCheckResultXml;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public class PinMapCheck {
    protected Db mDb;
    protected LinkedList<Check> mChecks = new LinkedList();

    public PinMapCheck(Db db) {
        this.mDb = db;
    }

    public void addCheck(Check check) {
        this.mChecks.add(check);
    }

    public void addCheck(CheckType checkType) {
        Check newCheck = null;
        switch (checkType) {
            case PORT_CONTACT: {
                newCheck = new PortContactCheck(this.mDb);
                break;
            }
            case PIN_UNMAPPED: {
                newCheck = new PinUnmappedCheck(this.mDb);
                break;
            }
            case NET_MAPPING: {
                newCheck = new NetMappingCheck(this.mDb);
                break;
            }
            case NET_PERSONALITY: {
                newCheck = new NetPersonalityCheck(this.mDb);
                break;
            }
            case PIN_DIRECTION: {
                newCheck = new PinDirectionCheck(this.mDb);
                break;
            }
            case PIN_COUNT_MISMATCH: {
                newCheck = new PinCountMismatchCheck(this.mDb);
                break;
            }
            case PIN_NAME: {
                newCheck = new PinNameCheck(this.mDb);
                break;
            }
            case DESIGN_NET_NAME: {
                newCheck = new DesignNetNameCheck(this.mDb);
                break;
            }
            case LOCAL_NET_NAME: {
                newCheck = new LocalNetNameCheck(this.mDb);
                break;
            }
            default: {
                newCheck = null;
            }
        }
        assert (newCheck != null);
        this.mChecks.add(newCheck);
    }

    public void addContactLayer(ContactLayer contactLayer) {
        this.mChecks.forEach(check -> check.addContactLayer(contactLayer));
    }

    public void execute() {
        this.clearResult();
        this.mChecks.forEach(Check::execute);
    }

    public void execute(CheckType checkType) {
        for (Check check : this.mChecks) {
            if (check.getType() != checkType) continue;
            check.reset();
            check.execute();
        }
    }

    public void clearResult() {
        this.mChecks.forEach(Check::reset);
    }

    public List<Check> getChecks() {
        return this.mChecks;
    }

    public int getViolationCount() {
        int count = 0;
        for (Check check : this.mChecks) {
            count += check.getViolationCount();
        }
        return count;
    }

    public void showResultUI() {
        PinMapCheckEngineUI.createDialog(OrbitIO.getMainWindow(), this.mDb, this);
    }

    public void exportResultXML(String filePath) {
        PinMapCheckResultXml printer = new PinMapCheckResultXml(this.getChecks());
        printer.exportXml(filePath);
    }

    public void exportResultCSV(String dirPath) {
        PinMapCheckResultCsv printer = new PinMapCheckResultCsv(this.getChecks());
        printer.exportCsv(dirPath);
    }

    public static PinMapCheck executeChecking(boolean checkConnectivityCount, boolean checkNetMapping, boolean checkPinDirection, boolean checkPortContact, boolean checkUnmappedPin, boolean checkPinPinOffset, int checkPinPinMaxOffset) {
        PinMapCheck pmc = new PinMapCheck(OrbitIO.getCurDb());
        if (checkConnectivityCount) {
            pmc.addCheck(CheckType.PIN_COUNT_MISMATCH);
        }
        if (checkNetMapping) {
            pmc.addCheck(CheckType.NET_MAPPING);
        }
        if (checkPinDirection) {
            pmc.addCheck(CheckType.PIN_DIRECTION);
        }
        if (checkPortContact) {
            pmc.addCheck(CheckType.PORT_CONTACT);
        }
        if (checkUnmappedPin) {
            pmc.addCheck(CheckType.PIN_UNMAPPED);
        }
        if (checkPinPinOffset && checkPinPinMaxOffset != -1) {
            PinOffsetCheck ppoc = new PinOffsetCheck(OrbitIO.getCurDb());
            ppoc.setMaxOffset(checkPinPinMaxOffset);
            pmc.addCheck(ppoc);
        }
        pmc.execute();
        return pmc;
    }

    public static interface Violation
    extends CheckResult {
        public boolean isFixed();
    }

    public static interface CheckResult {
        public String getText();

        public boolean isValidated();
    }

    public static abstract class Check {
        protected Db mDb;
        protected String mName;
        protected CheckType mCheckType;
        protected List<ContactLayer> mContactLayers;
        protected List<Violation> mViolations = new LinkedList<Violation>();
        protected List<CheckResult> mValidations = new LinkedList<CheckResult>();

        public Check(Db db) {
            this.mDb = db;
        }

        public String getName() {
            return this.mName;
        }

        public CheckType getType() {
            return this.mCheckType;
        }

        public void addContactLayer(ContactLayer contactLayer) {
            if (this.mContactLayers == null) {
                this.mContactLayers = new LinkedList<ContactLayer>();
            }
            this.mContactLayers.add(contactLayer);
        }

        public abstract void execute();

        public List<ContactLayer> getContactLayers() {
            if (this.mContactLayers == null) {
                this.mContactLayers = AUtil.arrayList((Iterator)ContactLayer.getValid((Db)this.mDb));
            }
            return this.mContactLayers;
        }

        public List<CheckResult> getValidations() {
            return this.mValidations;
        }

        public List<Violation> getViolations() {
            return this.mViolations;
        }

        public void removeFixedViolations() {
            List fixedViolations = this.mViolations.stream().filter(Violation::isFixed).collect(Collectors.toList());
            this.mViolations.removeAll(fixedViolations);
        }

        public void removeIfFix(Violation violation) {
            if (violation.isFixed()) {
                this.removeViolation(violation);
            }
        }

        public void removeViolation(Violation violation) {
            this.mViolations.remove(violation);
        }

        public int getValidationCount() {
            return this.mValidations.size();
        }

        public int getViolationCount() {
            return this.mViolations.size();
        }

        public void reset() {
            this.mViolations.clear();
            this.mValidations.clear();
        }
    }

    public static enum CheckType {
        PORT_CONTACT("Pin Contact"),
        PIN_UNMAPPED("Pin Unmapped"),
        PIN_OFFSET("Pin Offset"),
        PIN_COUNT_MISMATCH("Pin Count Mismatch"),
        PIN_DIRECTION("Pin Direction"),
        PIN_NAME("Pin Name"),
        DESIGN_NET_NAME("Design Net Name"),
        LOCAL_NET_NAME("Local Net Name"),
        NET_MAPPING("Net Mapping"),
        NET_PERSONALITY("Net Personality"),
        REFERENCE_COMPARE("Reference Compare");

        String name;

        private CheckType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

