/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.inter_substrate_checks;

import com.sigrity.acl.ALog;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.ContactLayer;
import com.sigrity.acl.db.std.PinMap;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.inter_substrate_checks.PinMapCheck;
import java.util.List;
import java.util.stream.Collectors;

public class PinNameCheck
extends PinMapCheck.Check {
    public PinNameCheck(Db db) {
        super(db);
        this.mName = "Pin Name";
        this.mCheckType = PinMapCheck.CheckType.PIN_NAME;
    }

    @Override
    public void execute() {
        this.checkPinName();
        ALog.logDebug((String)"Pin name checking complete.");
    }

    protected void checkPinName() {
        List pinMaps = this.getContactLayers().stream().flatMap(contactLayer -> PinMap.get((ContactLayer)contactLayer).stream()).collect(Collectors.toList());
        for (PinMap pinMap : pinMaps) {
            if (PinNameCheck.isPinNameMatch(pinMap)) {
                this.mValidations.add(new PinNameResult(pinMap, true));
                continue;
            }
            this.mViolations.add(new PinNameViolation(pinMap));
        }
    }

    private static boolean isPinNameMatch(PinMap pinMap) {
        String pinNameA = PinNameCheck.getPinName((HierInst<PinTemplate>)pinMap.getHierPinA());
        String pinNameB = PinNameCheck.getPinName((HierInst<PinTemplate>)pinMap.getHierPinB());
        return pinNameA.equals(pinNameB);
    }

    private static String getPinName(HierInst<PinTemplate> hierPin) {
        DevicePath pinPath = hierPin.getPath();
        if (!pinPath.isEmpty() && pinPath.isPin()) {
            return pinPath.getDevice().getName();
        }
        return ((PinTemplate)hierPin.getDbObject()).getName();
    }

    public class PinNameViolation
    extends PinNameResult
    implements PinMapCheck.Violation {
        PinNameViolation(PinMap pinMap) {
            super(pinMap, false);
        }

        @Override
        public boolean isFixed() {
            return PinNameCheck.isPinNameMatch(this.pinMap);
        }
    }

    public class PinNameResult
    implements PinMapCheck.CheckResult {
        PinMap pinMap;
        protected boolean isValidated;

        PinNameResult(PinMap pinMap, boolean isValidated) {
            this.pinMap = pinMap;
            this.isValidated = isValidated;
        }

        public PinMap getPinMap() {
            return this.pinMap;
        }

        @Override
        public String getText() {
            return this.pinMap.toString();
        }

        @Override
        public boolean isValidated() {
            return this.isValidated;
        }
    }
}

