/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.inter_substrate_checks;

import com.sigrity.acl.ALog;
import com.sigrity.acl.Unit;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.ContactLayer;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.PortTemplate;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.topology.Binner;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.inter_substrate_checks.PinMapCheck;
import com.sigrity.orbit.inter_substrate_checks.PortContactCheck;
import java.util.List;

public class PinOffsetCheck
extends PinMapCheck.Check {
    protected double mOffset;
    protected Unit mUnit;

    public PinOffsetCheck(Db db) {
        super(db);
        this.mName = "Pin Offset";
        this.mCheckType = PinMapCheck.CheckType.PIN_OFFSET;
        this.mUnit = Design.getUnit((Db)db);
    }

    public void setMaxOffset(double offset) {
        this.mOffset = offset;
    }

    @Override
    public void execute() {
        this.checkPinOffset();
        ALog.logDebug((String)"Pin offset checking complete.");
    }

    protected void checkPinOffset() {
        this.getContactLayers().forEach(contactLayer -> {
            PortContactCheck.CandidateContactPortInfo mContactPortInfo = new PortContactCheck.CandidateContactPortInfo((ContactLayer)contactLayer);
            this.checkPinOffset((ContactLayer)contactLayer, mContactPortInfo.portWorldGeoms1, mContactPortInfo.portWorldGeomIndex2);
        });
    }

    protected void checkPinOffset(ContactLayer contactLayer, List<PortContactCheck.PortWorldGeom> fromGeoms, Binner<PortContactCheck.PortWorldGeom> toGeomIndex) {
        for (PortContactCheck.PortWorldGeom fromGeom : fromGeoms) {
            for (PortContactCheck.PortWorldGeom toGeom : toGeomIndex.intersects(fromGeom.getWorldGeomBounds())) {
                if (!fromGeom.intersects(toGeom)) continue;
                APoint2D locA = fromGeom.getWorldGeomCenter();
                APoint2D locB = toGeom.getWorldGeomCenter();
                long orbitDx = locA.getX() - locB.getX();
                long orbitDy = locA.getY() - locB.getY();
                double curOffset = this.mUnit.toUser(locA.distance(locB));
                if (curOffset > this.mOffset) {
                    this.mViolations.add(new PinOffsetViolation(contactLayer, this.mOffset, curOffset, fromGeom.getHierPort(), toGeom.getHierPort(), orbitDx, orbitDy));
                    continue;
                }
                this.mValidations.add(new PinOffsetResult(contactLayer, this.mOffset, curOffset, fromGeom.getHierPort(), toGeom.getHierPort(), orbitDx, orbitDy, true));
            }
        }
    }

    public class PinOffsetViolation
    extends PinOffsetResult
    implements PinMapCheck.Violation {
        PinOffsetViolation(ContactLayer contactLayer, double maxOffset, double curOffset, HierInst<PortTemplate> hierPortA, HierInst<PortTemplate> hierPortB, long orbitDx, long orbitDy) {
            super(contactLayer, maxOffset, curOffset, hierPortA, hierPortB, orbitDx, orbitDy, false);
        }

        @Override
        public boolean isFixed() {
            APoint2D worldLocB;
            APoint2D worldLocA = ((PortTemplate)this.hierPortA.getSecond()).getWorldLoc(this.hierPortA.getPath());
            return (double)worldLocA.distance(worldLocB = ((PortTemplate)this.hierPortB.getSecond()).getWorldLoc(this.hierPortB.getPath())) <= this.maxOffset;
        }
    }

    public class PinOffsetResult
    implements PinMapCheck.CheckResult {
        final ContactLayer contactLayer;
        final HierInst<PortTemplate> hierPortA;
        final HierInst<PortTemplate> hierPortB;
        final double maxOffset;
        final double curOffset;
        final long orbitDx;
        final long orbitDy;
        protected boolean isValidated;

        PinOffsetResult(ContactLayer contactLayer, double maxOffset, double curOffset, HierInst<PortTemplate> hierPortA, HierInst<PortTemplate> hierPortB, long orbitDx, long orbitDy, boolean isValidated) {
            this.contactLayer = contactLayer;
            this.maxOffset = maxOffset;
            this.curOffset = curOffset;
            this.hierPortA = hierPortA;
            this.hierPortB = hierPortB;
            this.orbitDx = orbitDx;
            this.orbitDy = orbitDy;
            this.isValidated = isValidated;
        }

        @Override
        public String getText() {
            return String.format("%s_%s", ((PortTemplate)this.hierPortA.getSecond()).getPinTemplate().getName(), ((PortTemplate)this.hierPortB.getSecond()).getPinTemplate().getName());
        }

        @Override
        public boolean isValidated() {
            return this.isValidated;
        }

        public ContactLayer getContactLayer() {
            return this.contactLayer;
        }

        public double getMaxOffset() {
            return this.maxOffset;
        }

        public double getCurOffset() {
            return this.curOffset;
        }

        public HierInst<PortTemplate> getHierPortA() {
            return this.hierPortA;
        }

        public HierInst<PortTemplate> getHierPortB() {
            return this.hierPortB;
        }

        public long getOrbitDx() {
            return this.orbitDx;
        }

        public long getOrbitDy() {
            return this.orbitDy;
        }

        public DevicePath getDevPathA() {
            return this.contactLayer.getDevicePathA();
        }

        public Layer getLayerA() {
            return this.contactLayer.getContactLayerA();
        }

        public DevicePath getPinPathAFromOwner() {
            return this.hierPortA.getPath();
        }

        public DevicePath getPinPathAFromContactDev() {
            return this.getPinPathAFromOwner().getRelativePathFromAnchor(this.getDevPathA().getDeviceTemplate());
        }

        public PinTemplate getPinTA() {
            return ((PortTemplate)this.hierPortA.getSecond()).getPinTemplate();
        }

        public PortTemplate getPortTA() {
            return (PortTemplate)this.hierPortA.getSecond();
        }

        public DevicePath getDevPathB() {
            return this.contactLayer.getDevicePathB();
        }

        public Layer getLayerB() {
            return this.contactLayer.getContactLayerB();
        }

        public DevicePath getPinPathBFromOwner() {
            return this.hierPortB.getPath();
        }

        public DevicePath getPinPathBFromContactDev() {
            return this.getPinPathBFromOwner().getRelativePathFromAnchor(this.getDevPathB().getDeviceTemplate());
        }

        public PinTemplate getPinTB() {
            return ((PortTemplate)this.hierPortB.getSecond()).getPinTemplate();
        }

        public PortTemplate getPortTB() {
            return (PortTemplate)this.hierPortB.getSecond();
        }
    }
}

