/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.inter_substrate_checks;

import com.sigrity.acl.ALog;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.ContactLayer;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.PinMap;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.ARect;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.inter_substrate_checks.PinMapCheck;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PinUnmappedCheck
extends PinMapCheck.Check {
    public PinUnmappedCheck(Db db) {
        super(db);
        this.mName = "Pin Unmapped";
        this.mCheckType = PinMapCheck.CheckType.PIN_UNMAPPED;
    }

    @Override
    public void execute() {
        this.checkUnmappedPinOnContactLayer();
        ALog.logDebug((String)"Pin unmapped checking complete.");
    }

    protected void checkUnmappedPinOnContactLayer() {
        Set pinMapPins = this.getContactLayers().stream().flatMap(contactLayer -> PinMap.get((ContactLayer)contactLayer).stream()).flatMap(pm -> Stream.of(pm.getHierPinA(), pm.getHierPinB())).distinct().collect(Collectors.toSet());
        this.getContactLayers().forEach(contactLayer -> {
            contactLayer.getPinOnContactLayerA().stream().filter(dPin -> !pinMapPins.contains(dPin)).filter(dPin -> this.isPinIntersectDevice(contactLayer.getDevicePathB(), (HierInst<PinTemplate>)dPin)).forEach(dPin -> this.addUnmapPinResult((ContactLayer)contactLayer, (HierInst<PinTemplate>)dPin, true));
            contactLayer.getPinOnContactLayerB().stream().filter(dPin -> !pinMapPins.contains(dPin)).filter(dPin -> this.isPinIntersectDevice(contactLayer.getDevicePathA(), (HierInst<PinTemplate>)dPin)).forEach(dPin -> this.addUnmapPinResult((ContactLayer)contactLayer, (HierInst<PinTemplate>)dPin, false));
        });
        this.getContactLayers().forEach(contactLayer -> PinMap.get((ContactLayer)contactLayer).stream().forEach(this::addMapPinResult));
    }

    protected boolean isPinIntersectDevice(DevicePath devPath, HierInst<PinTemplate> hierPin) {
        ARect devGeom = devPath.getExtent();
        ARect pinGeom = ((PinTemplate)hierPin.getSecond()).getWorldBoundsForDP(hierPin.getPath());
        return devGeom.intersects((AGeom)pinGeom);
    }

    protected void addUnmapPinResult(ContactLayer contactLayer, HierInst<PinTemplate> dPin, boolean isPinA) {
        ReferencePinMap refPinMap = null;
        refPinMap = isPinA ? new ReferencePinMap(contactLayer, dPin.getPath(), (PinTemplate)dPin.getSecond(), null, null) : new ReferencePinMap(contactLayer, null, null, dPin.getPath(), (PinTemplate)dPin.getSecond());
        PinUnmappedViolation v = new PinUnmappedViolation(refPinMap);
        this.mViolations.add(v);
    }

    protected void addMapPinResult(PinMap pinMap) {
        ReferencePinMap refPinMap = new ReferencePinMap(pinMap.getContactLayer(), pinMap.getPinAPath(), pinMap.getPinA(), pinMap.getPinBPath(), pinMap.getPinB());
        PinUnmappedResult v = new PinUnmappedResult(refPinMap, true);
        this.mValidations.add(v);
    }

    public class PinUnmappedViolation
    extends PinUnmappedResult
    implements PinMapCheck.Violation {
        PinUnmappedViolation(ReferencePinMap refPinMap) {
            super(refPinMap, false);
        }

        @Override
        public boolean isFixed() {
            if (this.refPinMap.getPinA() != null) {
                if (this.refPinMap.getPinA().getDb() == null || !this.refPinMap.getPinPathA().isValid()) {
                    return true;
                }
                return PinMap.get((DevicePath)this.refPinMap.getPinPathA(), (PinTemplate)this.refPinMap.getPinA()).stream().anyMatch(pm -> pm.getContactLayer() == this.refPinMap.getContactLayer());
            }
            if (this.refPinMap.getPinB() != null) {
                if (this.refPinMap.getPinB().getDb() == null || !this.refPinMap.getPinPathB().isValid()) {
                    return true;
                }
                return PinMap.get((DevicePath)this.refPinMap.getPinPathB(), (PinTemplate)this.refPinMap.getPinB()).stream().anyMatch(pm -> pm.getContactLayer() == this.refPinMap.getContactLayer());
            }
            return true;
        }
    }

    public class PinUnmappedResult
    implements PinMapCheck.CheckResult {
        ReferencePinMap refPinMap;
        String text;
        protected boolean isValidated;

        PinUnmappedResult(ReferencePinMap refPinMap, boolean isValidated) {
            this.refPinMap = refPinMap;
            this.isValidated = isValidated;
        }

        @Override
        public String getText() {
            this.text = this.refPinMap.getPinA() != null ? String.format("%s", this.refPinMap.getPinA().getName()) : String.format("%s", this.refPinMap.getPinB().getName());
            return this.text;
        }

        @Override
        public boolean isValidated() {
            return this.isValidated;
        }

        public DevicePath getPinPath() {
            return this.refPinMap.getPinPathA();
        }

        public PinTemplate getPin() {
            return this.refPinMap.getPinA();
        }

        public ContactLayer getContactLayer() {
            return this.refPinMap.getContactLayer();
        }

        public boolean isPinA() {
            return this.refPinMap.getPinA() != null;
        }

        public DevicePath getDevPathA() {
            return this.refPinMap.getContactLayer().getDevicePathA();
        }

        public Layer getLayerA() {
            return this.refPinMap.getContactLayer().getContactLayerA();
        }

        public DevicePath getPinPathA() {
            return this.refPinMap.getPinPathA();
        }

        public DevicePath getPinPathAFromContactDev() {
            DevicePath pinPathA = this.getPinPathA();
            if (pinPathA == null || pinPathA.getRoot() == this.getDevPathA().getDeviceTemplate()) {
                return pinPathA;
            }
            return pinPathA.getRelativePathFromAnchor(this.getDevPathA().getDeviceTemplate());
        }

        public PinTemplate getPinTA() {
            return this.refPinMap.getPinA();
        }

        public DevicePath getDevPathB() {
            return this.refPinMap.getContactLayer().getDevicePathB();
        }

        public Layer getLayerB() {
            return this.refPinMap.getContactLayer().getContactLayerB();
        }

        public DevicePath getPinPathB() {
            return this.refPinMap.getPinPathB();
        }

        public DevicePath getPinPathBFromContactDev() {
            DevicePath pinPathB = this.getPinPathB();
            if (pinPathB == null || pinPathB.getRoot() == this.getDevPathB().getDeviceTemplate()) {
                return pinPathB;
            }
            return pinPathB.getRelativePathFromAnchor(this.getDevPathB().getDeviceTemplate());
        }

        public PinTemplate getPinTB() {
            return this.refPinMap.getPinB();
        }
    }

    public static class ReferencePinMap {
        ContactLayer contactLayer;
        DevicePath pinPathA;
        PinTemplate pinA;
        DevicePath pinPathB;
        PinTemplate pinB;

        public ReferencePinMap(ContactLayer contactLayer, DevicePath pinPathA, PinTemplate pinA, DevicePath pinPathB, PinTemplate pinB) {
            this.contactLayer = contactLayer;
            this.pinPathA = pinPathA;
            this.pinA = pinA;
            this.pinPathB = pinPathB;
            this.pinB = pinB;
        }

        public ContactLayer getContactLayer() {
            return this.contactLayer;
        }

        public DevicePath getPinPathA() {
            return this.pinPathA;
        }

        public PinTemplate getPinA() {
            return this.pinA;
        }

        public DevicePath getPinPathB() {
            return this.pinPathB;
        }

        public PinTemplate getPinB() {
            return this.pinB;
        }
    }
}

