/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.inter_substrate_checks;

import com.sigrity.acl.ALog;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.ContactLayer;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.LayerShape;
import com.sigrity.acl.db.std.PinMap;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.PortTemplate;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.topology.Binner;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.inter_substrate_checks.PinMapCheck;
import java.awt.geom.AffineTransform;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PortContactCheck
extends PinMapCheck.Check {
    public PortContactCheck(Db db) {
        super(db);
        this.mName = "Pin Contact";
        this.mCheckType = PinMapCheck.CheckType.PORT_CONTACT;
    }

    @Override
    public void execute() {
        this.checkPortPhysicalContact();
    }

    private void checkPortPhysicalContact() {
        this.getContactLayers().forEach(contactLayer -> {
            this.checkPortPhysicalContact((ContactLayer)contactLayer);
            ALog.logDebug((String)"Port contact checking complete for %s.", (Object[])new Object[]{contactLayer});
        });
    }

    private void checkPortPhysicalContact(ContactLayer contactLayer) {
        CandidateContactPortInfo mContactPortInfo = new CandidateContactPortInfo(contactLayer);
        List<PortMap> portMaps = mContactPortInfo.getContactPortMaps();
        Set portMapPorts = portMaps.stream().flatMap(pm -> Stream.of(pm.getPortA(), pm.getPortB())).distinct().collect(Collectors.toSet());
        mContactPortInfo.portWorldGeoms1.stream().forEach(portGeom -> {
            HierInst portA = HierInst.create((DevicePath)portGeom.devicePath, (DbObject)portGeom.port);
            if (!portMapPorts.contains(portA)) {
                this.mViolations.add(new PortContactViolation(new PortMap(contactLayer, (HierInst<PortTemplate>)portA, null)));
            }
        });
        mContactPortInfo.portWorldGeoms2.stream().forEach(portGeom -> {
            HierInst portB = HierInst.create((DevicePath)portGeom.devicePath, (DbObject)portGeom.port);
            if (!portMapPorts.contains(portB)) {
                this.mViolations.add(new PortContactViolation(new PortMap(contactLayer, null, (HierInst<PortTemplate>)portB)));
            }
        });
        portMaps.stream().forEach(pm -> this.mValidations.add(new PortContactResult((PortMap)pm, true)));
    }

    public class PortContactViolation
    extends PortContactResult
    implements PinMapCheck.Violation {
        PortContactViolation(PortMap portMap) {
            super(portMap, false);
        }

        @Override
        public boolean isFixed() {
            if (this.getHierPort().getSecond() == null || ((PortTemplate)this.getHierPort().getSecond()).getDb() == null || !this.getHierPort().isValid()) {
                return true;
            }
            if (PinMap.getContactPin((DevicePath)this.getPortPath(), (PinTemplate)this.getPin()).hasNext()) {
                return false;
            }
            AGeom worldBounds = ((PortTemplate)this.getHierPort().getSecond()).getBounds(this.getPortLayer()).transform(this.getHierPort().getPath().getTransform());
            AGeom boundsInContactDev = worldBounds.transform(this.getContactDevPath().getInverseTransform());
            return this.hasContactPort(this.getContactDevPath().getDeviceTemplate(), boundsInContactDev);
        }
    }

    public class PortContactResult
    implements PinMapCheck.CheckResult {
        protected final PortMap portMap;
        protected String text;
        protected boolean isValidated;

        PortContactResult(PortMap portMap, boolean isValidated) {
            this.portMap = portMap;
            this.isValidated = isValidated;
        }

        @Override
        public String getText() {
            if (this.text == null) {
                this.text = String.format("%s.%s.%s", this.getPortPath().toString(), this.getPin().getName(), this.getPort().getPortNum());
            }
            return this.text;
        }

        @Override
        public boolean isValidated() {
            return this.isValidated;
        }

        public boolean isPortA() {
            return this.portMap.getPortA() != null;
        }

        public ContactLayer getContactLayer() {
            return this.portMap.getContactLayer();
        }

        public DevicePath getPortPath() {
            return this.portMap.getPortA() != null ? this.portMap.getPortA().getPath() : this.portMap.getPortB().getPath();
        }

        public HierInst<PortTemplate> getHierPort() {
            return this.portMap.getPortA() != null ? this.portMap.getPortA() : this.portMap.getPortB();
        }

        public PortTemplate getPort() {
            return this.portMap.getPortA() != null ? (PortTemplate)this.portMap.getPortA().getSecond() : (PortTemplate)this.portMap.getPortB().getSecond();
        }

        public PinTemplate getPin() {
            return this.getPort().getPinTemplate();
        }

        protected DevicePath getContactDevPath() {
            if (this.isPortA()) {
                return this.getDevPathB();
            }
            return this.getDevPathA();
        }

        protected boolean hasContactPort(DeviceTemplate devT, AGeom portbounds) {
            ARect bbInContactDev = portbounds.getBounds();
            Optional<PortTemplate> contactPort = devT.getPinSpatialIndex().intersects(bbInContactDev).stream().flatMap(pinT -> pinT.getPortTemplates().stream()).filter(portT -> this.intersects(portbounds, (PortTemplate)portT)).findAny();
            if (contactPort.isPresent()) {
                return true;
            }
            return devT.getChildSpatialIndex().intersects(bbInContactDev).stream().anyMatch(dev -> {
                DevicePath path = new DevicePath(dev);
                return this.hasContactPort(dev.getTemplate(), portbounds.transform(path.getInverseTransform()));
            });
        }

        protected boolean intersects(AGeom boundsInContactDev, PortTemplate portT) {
            ARect bounds = portT.getBounds(this.getPortContactLayer());
            return bounds != null && bounds.intersects(boundsInContactDev);
        }

        protected Layer getPortLayer() {
            return this.getContactLayer().getDevicePathA().equals((Object)this.getContactDevPath()) ? this.getContactLayer().getContactLayerB() : this.getContactLayer().getContactLayerA();
        }

        protected Layer getPortContactLayer() {
            return this.getContactLayer().getDevicePathA().equals((Object)this.getContactDevPath()) ? this.getContactLayer().getContactLayerA() : this.getContactLayer().getContactLayerB();
        }

        public DevicePath getDevPathA() {
            return this.getContactLayer().getDevicePathA();
        }

        public Layer getLayerA() {
            return this.getContactLayer().getContactLayerA();
        }

        public DevicePath getPinPathAFromOwner() {
            return this.portMap.getPortA() != null ? this.portMap.getPortA().getPath() : null;
        }

        public DevicePath getPinPathAFromContactDev() {
            DevicePath pinPath = this.getPinPathAFromOwner();
            if (pinPath == null || pinPath.getRoot() == this.getDevPathA().getDeviceTemplate()) {
                return pinPath;
            }
            return pinPath.getRelativePath(this.getDevPathA().getDeviceTemplate());
        }

        public PinTemplate getPinTA() {
            return this.portMap.getPortA() != null ? ((PortTemplate)this.portMap.getPortA().getSecond()).getPinTemplate() : null;
        }

        public PortTemplate getPortTA() {
            return this.portMap.getPortA() != null ? (PortTemplate)this.portMap.getPortA().getSecond() : null;
        }

        public DevicePath getDevPathB() {
            return this.portMap.getContactLayer().getDevicePathB();
        }

        public Layer getLayerB() {
            return this.portMap.getContactLayer().getContactLayerB();
        }

        public DevicePath getPinPathBFromOwner() {
            return this.portMap.getPortB() != null ? this.portMap.getPortB().getPath() : null;
        }

        public DevicePath getPinPathBFromContactDev() {
            DevicePath pinPath = this.getPinPathBFromOwner();
            if (pinPath == null || pinPath.getRoot() == this.getDevPathB().getDeviceTemplate()) {
                return pinPath;
            }
            return pinPath.getRelativePath(this.getDevPathB().getDeviceTemplate());
        }

        public PinTemplate getPinTB() {
            return this.portMap.getPortB() != null ? ((PortTemplate)this.portMap.getPortB().getSecond()).getPinTemplate() : null;
        }

        public PortTemplate getPortTB() {
            return this.portMap.getPortB() != null ? (PortTemplate)this.portMap.getPortB().getSecond() : null;
        }
    }

    public static class PortWorldGeom
    implements Comparable<PortWorldGeom> {
        private DevicePath devicePath;
        private PortTemplate port;
        private AGeom worldGeom;

        PortWorldGeom(HierInst<PortTemplate> hierPort, AGeom worldGeom) {
            this((DevicePath)hierPort.getFirst(), (PortTemplate)hierPort.getSecond(), worldGeom);
        }

        PortWorldGeom(DevicePath devicePath, PortTemplate port, AGeom worldGeom) {
            this.devicePath = devicePath;
            this.port = port;
            this.worldGeom = worldGeom;
        }

        public APoint2D getWorldGeomCenter() {
            return this.getWorldGeomBounds().center();
        }

        public ARect getWorldGeomBounds() {
            return this.worldGeom.getBounds();
        }

        public PinTemplate getPinTemplate() {
            return this.port.getPinTemplate();
        }

        public DevicePath getPinPath() {
            return this.devicePath;
        }

        public HierInst<PinTemplate> getHierPinT() {
            return HierInst.create((DevicePath)this.devicePath, (DbObject)this.getPinTemplate());
        }

        public HierInst<PortTemplate> getHierPort() {
            return HierInst.create((DevicePath)this.devicePath, (DbObject)this.port);
        }

        public boolean intersects(PortWorldGeom portGeom) {
            if (this.worldGeom instanceof ARect && portGeom.worldGeom instanceof ARect) {
                ARect myRect = (ARect)this.worldGeom;
                ARect otherRect = (ARect)portGeom.worldGeom;
                return myRect.overlaps(otherRect);
            }
            return this.worldGeom.intersects(portGeom.worldGeom);
        }

        @Override
        public int compareTo(PortWorldGeom o) {
            return this.port.getLoc().compareTo(o.port.getLoc());
        }
    }

    public static class CandidateContactPortInfo {
        ContactLayer mContactLayer;
        List<PortWorldGeom> portWorldGeoms1;
        List<PortWorldGeom> portWorldGeoms2;
        Binner<PortWorldGeom> portWorldGeomIndex1 = new Binner();
        Binner<PortWorldGeom> portWorldGeomIndex2 = new Binner();
        List<PortMap> mContactPortMaps = null;

        public CandidateContactPortInfo(ContactLayer contactLayer) {
            this.mContactLayer = contactLayer;
            AffineTransform deviceWorldXform1 = contactLayer.getDevicePathA().getTransform();
            AffineTransform deviceWorldXform2 = contactLayer.getDevicePathB().getTransform();
            AGeom geomDevice1 = contactLayer.getDevicePathA().getDeviceTemplate().getBB().transform(deviceWorldXform1);
            AGeom geomDevice2 = contactLayer.getDevicePathB().getDeviceTemplate().getBB().transform(deviceWorldXform2);
            this.portWorldGeomIndex1.setWorld(contactLayer.getOwner().getExtent());
            contactLayer.getPortOnContactLayerA().forEach(hierPort -> {
                for (LayerShape shape : ((PortTemplate)hierPort.getSecond()).getLayerShapesOnLayer(contactLayer.getContactLayerA())) {
                    AGeom worldGeom = shape.getGeom().transform(((PortTemplate)hierPort.getSecond()).getTransform()).transform(((DevicePath)hierPort.getFirst()).getTransform());
                    PortWorldGeom portWorldGeom = new PortWorldGeom((HierInst<PortTemplate>)hierPort, worldGeom);
                    this.portWorldGeomIndex1.insert((Object)portWorldGeom, worldGeom.getBounds());
                }
            });
            this.portWorldGeoms1 = this.portWorldGeomIndex1.intersects(geomDevice2.getBounds()).stream().collect(Collectors.toList());
            Collections.sort(this.portWorldGeoms1);
            this.portWorldGeomIndex2.setWorld(contactLayer.getOwner().getExtent());
            contactLayer.getPortOnContactLayerB().forEach(hierPort -> {
                for (LayerShape shape : ((PortTemplate)hierPort.getSecond()).getLayerShapesOnLayer(contactLayer.getContactLayerB())) {
                    AGeom worldGeom = shape.getGeom().transform(((PortTemplate)hierPort.getSecond()).getTransform()).transform(((DevicePath)hierPort.getFirst()).getTransform());
                    PortWorldGeom portWorldGeom = new PortWorldGeom((HierInst<PortTemplate>)hierPort, worldGeom);
                    this.portWorldGeomIndex2.insert((Object)portWorldGeom, worldGeom.getBounds());
                }
            });
            this.portWorldGeoms2 = this.portWorldGeomIndex2.intersects(geomDevice1.getBounds()).stream().collect(Collectors.toList());
            Collections.sort(this.portWorldGeoms2);
            this.mContactPortMaps = this.setContactPortMaps();
        }

        private List<PortMap> setContactPortMaps() {
            LinkedList<PortMap> contactPortMaps = new LinkedList<PortMap>();
            for (PortWorldGeom portGeom : this.portWorldGeoms1) {
                this.portWorldGeomIndex2.intersects(portGeom.worldGeom.getBounds()).forEach(portGeom2 -> contactPortMaps.add(new PortMap(this.mContactLayer, (HierInst<PortTemplate>)HierInst.create((DevicePath)portGeom.devicePath, (DbObject)portGeom.port), (HierInst<PortTemplate>)HierInst.create((DevicePath)portGeom2.devicePath, (DbObject)portGeom2.port))));
            }
            return contactPortMaps;
        }

        public List<PortMap> getContactPortMaps() {
            return this.mContactPortMaps;
        }

        public Stream<HierInst<PinTemplate>> getCandidatePin1() {
            return this.portWorldGeoms1.stream().map(p -> HierInst.create((DevicePath)p.devicePath, (DbObject)p.getPinTemplate())).distinct();
        }

        public Stream<PortWorldGeom> getPortWorldGeom1(HierInst<PinTemplate> hierPin) {
            return this.portWorldGeoms1.stream().filter(p -> p.getHierPinT().equals((Object)hierPin));
        }

        public List<PortWorldGeom> getPortWorldGeom1() {
            return this.portWorldGeoms1;
        }

        public IterableIterator<PortWorldGeom> getIntersectGeom2(PortWorldGeom portGeom1) {
            return this.portWorldGeomIndex2.intersects(portGeom1.worldGeom.getBounds());
        }
    }

    public static class PortMap {
        ContactLayer contactLayer;
        HierInst<PortTemplate> portA;
        HierInst<PortTemplate> portB;

        public PortMap(ContactLayer contactLayer, HierInst<PortTemplate> portA, HierInst<PortTemplate> portB) {
            this.contactLayer = contactLayer;
            this.portA = portA;
            this.portB = portB;
        }

        public ContactLayer getContactLayer() {
            return this.contactLayer;
        }

        public HierInst<PortTemplate> getPortA() {
            return this.portA;
        }

        public HierInst<PortTemplate> getPortB() {
            return this.portB;
        }
    }
}

