/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.inter_substrate_checks;

import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.ContactLayer;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.PinMap;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.ARect;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.automation.pinMap.PinMapCsvReader;
import com.sigrity.orbit.inter_substrate_checks.PinMapCheck;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class ReferenceCsvCheck
extends PinMapCheck.Check {
    private List<ContactLayerCsvPinMap> mContactLayerCsvPinMap = new LinkedList<ContactLayerCsvPinMap>();

    public ReferenceCsvCheck(Db db) {
        super(db);
        this.mName = "Reference Compare";
        this.mCheckType = PinMapCheck.CheckType.REFERENCE_COMPARE;
    }

    public void addCsvFile(ContactLayer contactLayer, String fileName) {
        this.mContactLayerCsvPinMap.add(new ContactLayerCsvPinMap(contactLayer, fileName));
    }

    @Override
    public void reset() {
        super.reset();
        this.mContactLayerCsvPinMap.forEach(ContactLayerCsvPinMap::reset);
    }

    @Override
    public List<ContactLayer> getContactLayers() {
        return this.mContactLayerCsvPinMap.stream().map(ContactLayerCsvPinMap::getContactLayer).collect(Collectors.toList());
    }

    @Override
    public void execute() {
        this.checkInput();
        this.checkPinCountMismatch();
        this.checkFloatingPin();
        this.checkPinContactLayer();
        this.checkPinNet();
        this.checkRefVsDb();
        ALog.logDebug((String)"Reference compare checking complete.");
    }

    protected void checkInput() {
        for (ContactLayerCsvPinMap contactLayerCsvPinMap : this.mContactLayerCsvPinMap) {
            contactLayerCsvPinMap.importCsvPinMap();
            DevicePath contactDevPathA = contactLayerCsvPinMap.getContactDevPathA();
            DevicePath contactDevPathB = contactLayerCsvPinMap.getContactDevPathB();
            for (PinMapCsvReader.CsvPinMap t : contactLayerCsvPinMap.getCsvPinMaps()) {
                Net netB;
                HierInst<PinTemplate> hierPinB;
                Net netA;
                boolean violated = false;
                CsvInputResult result = new CsvInputResult(t, true);
                HierInst<PinTemplate> hierPinA = this.findHierPin(contactDevPathA, t.getPinPathA(), t.getPinA());
                if (hierPinA == null) {
                    violated = true;
                    result.addErrorPath(t.getPinPathA());
                    result.setPinPathAError(true);
                } else if (hierPinA.getSecond() == null) {
                    violated = true;
                    result.addErrorPinOnPath(t.getPinA(), t.getPinPathA());
                    result.setPinAError(true);
                }
                String netAName = t.getNetA();
                DeviceTemplate contactDevTA = contactDevPathA.getDeviceTemplate();
                boolean isEmptyNetA = netAName == null || netAName.isEmpty() || netAName.isBlank();
                Net net = netA = isEmptyNetA ? null : contactDevTA.getNet(netAName);
                if (!isEmptyNetA && netA == null) {
                    violated = true;
                    result.setNetAError(true);
                }
                if ((hierPinB = this.findHierPin(contactDevPathB, t.getPinPathB(), t.getPinB())) == null) {
                    violated = true;
                    result.addErrorPath(t.getPinPathB());
                    result.setPinPathBError(true);
                } else if (hierPinB.getSecond() == null) {
                    violated = true;
                    result.addErrorPinOnPath(t.getPinB(), t.getPinPathB());
                    result.setPinBError(true);
                }
                String netBName = t.getNetB();
                DeviceTemplate contactDevTB = contactDevPathB.getDeviceTemplate();
                boolean isEmptyNetB = netBName == null || netBName.isEmpty() || netBName.isBlank();
                Net net2 = netB = isEmptyNetB ? null : contactDevTB.getNet(netBName);
                if (!isEmptyNetB && netB == null) {
                    violated = true;
                    result.setNetBError(true);
                }
                if (violated) {
                    this.mViolations.add(new CsvInputViolation(t, result));
                    continue;
                }
                this.mValidations.add(result);
                contactLayerCsvPinMap.addReferencePinMap(hierPinA, netA, hierPinB, netB);
            }
        }
    }

    private HierInst<PinTemplate> findHierPin(DevicePath contactDevPath, String pinPathStr, String pinName) {
        DevicePath pinPath = contactDevPath;
        if (pinPathStr != null && !pinPathStr.isEmpty() && (pinPath = contactDevPath.addPath(pinPathStr)) == null) {
            return null;
        }
        HierInst<PinTemplate> hierPin = this.getPin(pinPath.getDeviceTemplate(), pinName);
        if (hierPin == null) {
            return HierInst.create((DevicePath)pinPath, null);
        }
        if (!hierPin.getPath().isEmpty()) {
            pinPath = pinPath.addPath(hierPin.getPath());
        }
        return HierInst.create((DevicePath)pinPath, (DbObject)((PinTemplate)hierPin.getSecond()));
    }

    private HierInst<PinTemplate> getPin(DeviceTemplate devT, String pinName) {
        HierInst<PinTemplate> hierPin = this.getPinFromPinTemplate(devT, pinName);
        if (hierPin == null) {
            hierPin = this.getPinFromDevice(devT, pinName);
        }
        if (hierPin == null) {
            hierPin = this.getPinFromDescendantPin(devT, pinName);
        }
        if (hierPin == null) {
            hierPin = this.getPinFromDescendantDevice(devT, pinName);
        }
        return hierPin;
    }

    private HierInst<PinTemplate> getPinFromPinTemplate(DeviceTemplate devT, String pinName) {
        PinTemplate pin = devT.getPinByName(pinName);
        if (pin == null) {
            return null;
        }
        return HierInst.create((DevicePath)new DevicePath(devT), (DbObject)pin);
    }

    private HierInst<PinTemplate> getPinFromDevice(DeviceTemplate devT, String pinName) {
        Device pinDev = devT.getChild(pinName);
        if (pinDev == null || !pinDev.isPin()) {
            return null;
        }
        PinTemplate pin = pinDev.getTemplate().getPin1();
        if (pin == null) {
            return null;
        }
        return HierInst.create((DevicePath)new DevicePath(devT, pinDev), (DbObject)pin);
    }

    private HierInst<PinTemplate> getPinFromDescendantPin(DeviceTemplate devT, String pinName) {
        return devT.getDescendantOnSubstrate().stream().map(path -> {
            DeviceTemplate dt = path.getDeviceTemplate();
            PinTemplate pt = dt.getPinByName(pinName);
            return pt == null ? null : new HierInst(path, (DbObject)pt);
        }).filter(Objects::nonNull).findAny().orElse(null);
    }

    private HierInst<PinTemplate> getPinFromDescendantDevice(DeviceTemplate devT, String pinName) {
        return devT.getDescendantOnSubstrate().stream().filter(devPath -> devPath.isPin() && devPath.getDevice().getName().equals(pinName) && devPath.getDeviceTemplate().getPin1() != null).map(devPath -> HierInst.create((DevicePath)devPath, (DbObject)devPath.getDeviceTemplate().getPin1())).findAny().orElse(null);
    }

    protected void checkPinCountMismatch() {
        HashMap<HierInst<PinTemplate>, LinkedList<ReferencePinMap>> pin2TestedPinMap = new HashMap<HierInst<PinTemplate>, LinkedList<ReferencePinMap>>();
        for (ContactLayerCsvPinMap contactLayerCsvPinMap : this.mContactLayerCsvPinMap) {
            for (ReferencePinMap refPinMap : contactLayerCsvPinMap.getReferencePinMaps()) {
                HierInst<PinTemplate> hierPinA = refPinMap.getHierPinA();
                LinkedList<ReferencePinMap> pinMapWithPinA = (LinkedList<ReferencePinMap>)pin2TestedPinMap.get(hierPinA);
                if (pinMapWithPinA == null) {
                    pinMapWithPinA = new LinkedList<ReferencePinMap>();
                    pin2TestedPinMap.put(hierPinA, pinMapWithPinA);
                }
                pinMapWithPinA.add(refPinMap);
                HierInst<PinTemplate> hierPinB = refPinMap.getHierPinB();
                LinkedList<ReferencePinMap> pinMapWithPinB = (LinkedList<ReferencePinMap>)pin2TestedPinMap.get(hierPinB);
                if (pinMapWithPinB == null) {
                    pinMapWithPinB = new LinkedList<ReferencePinMap>();
                    pin2TestedPinMap.put(hierPinB, pinMapWithPinB);
                }
                pinMapWithPinB.add(refPinMap);
            }
        }
        for (Map.Entry entry : pin2TestedPinMap.entrySet()) {
            LinkedList pinMapWithPin = (LinkedList)entry.getValue();
            if (pinMapWithPin.size() >= 2) {
                this.mViolations.add(new CsvPinCountMismatchViolation((HierInst<PinTemplate>)((HierInst)entry.getKey()), pinMapWithPin));
                continue;
            }
            if (pinMapWithPin.size() != 1) continue;
            this.mValidations.add(new CsvPinCountMismatchResult((HierInst<PinTemplate>)((HierInst)entry.getKey()), pinMapWithPin, true));
        }
    }

    protected void checkFloatingPin() {
        HashSet csvPinMap = new HashSet();
        List<ContactLayerCsvPinMap> clPinMaps = this.mContactLayerCsvPinMap.stream().collect(Collectors.toList());
        clPinMaps.forEach(clPinMap -> {
            ContactLayer contactLayer = clPinMap.getContactLayer();
            Set pinsOnContactLayerA = contactLayer.getPinOnContactLayerA().stream().collect(Collectors.toSet());
            Set pinsOnContactLayerB = contactLayer.getPinOnContactLayerB().stream().collect(Collectors.toSet());
            List<ReferencePinMap> refPinMaps = clPinMap.getReferencePinMaps();
            for (ReferencePinMap refPinMap : refPinMaps) {
                if (!pinsOnContactLayerA.contains(refPinMap.getHierPinA()) && !pinsOnContactLayerB.contains(refPinMap.getHierPinB())) continue;
                this.mValidations.add(new CsvFloatingPinResult(refPinMap, true));
            }
        });
        clPinMaps.forEach(clPinMap -> clPinMap.getReferencePinMaps().stream().forEach(refPinMap -> {
            csvPinMap.add(refPinMap.getHierPinA());
            csvPinMap.add(refPinMap.getHierPinB());
        }));
        for (ContactLayer contactLayer : this.getContactLayers()) {
            contactLayer.getPinOnContactLayerA().stream().filter(hierPin -> !csvPinMap.contains(hierPin)).filter(hierPin -> this.isPinIntersectDevice(contactLayer.getDevicePathB(), (HierInst<PinTemplate>)hierPin)).forEach(hierPin -> this.mViolations.add(new CsvFloatingPinViolation(new ReferencePinMap(contactLayer, (HierInst<PinTemplate>)hierPin, null, null, null))));
            contactLayer.getPinOnContactLayerB().stream().filter(hierPin -> !csvPinMap.contains(hierPin)).filter(hierPin -> this.isPinIntersectDevice(contactLayer.getDevicePathA(), (HierInst<PinTemplate>)hierPin)).forEach(hierPin -> this.mViolations.add(new CsvFloatingPinViolation(new ReferencePinMap(contactLayer, null, null, (HierInst<PinTemplate>)hierPin, null))));
        }
    }

    protected boolean isPinIntersectDevice(DevicePath devPath, HierInst<PinTemplate> hierPin) {
        ARect devGeom = devPath.getExtent();
        ARect pinGeom = ((PinTemplate)hierPin.getSecond()).getWorldBoundsForDP(hierPin.getPath());
        return devGeom.intersects((AGeom)pinGeom);
    }

    protected void checkPinContactLayer() {
        for (ContactLayerCsvPinMap contactLayerCsvPinMap : this.mContactLayerCsvPinMap) {
            for (ReferencePinMap refPinMap : contactLayerCsvPinMap.getReferencePinMaps()) {
                if (!this.isPinOnContactLayer(refPinMap)) {
                    this.mViolations.add(new CsvPinLayerViolation(refPinMap));
                    continue;
                }
                this.mValidations.add(new CsvPinLayerResult(refPinMap, true));
            }
        }
    }

    protected boolean isPinOnContactLayer(ReferencePinMap refPinMap) {
        Layer layerA = refPinMap.getLayerA();
        Layer layerB = refPinMap.getLayerB();
        return refPinMap.getPinA().getShapesOnLayer(layerA).hasNext() && refPinMap.getPinB().getShapesOnLayer(layerB).hasNext();
    }

    private void checkPinNet() {
        List refPinMaps = this.mContactLayerCsvPinMap.stream().flatMap(clPinMap -> clPinMap.getReferencePinMaps().stream()).collect(Collectors.toList());
        for (ReferencePinMap refPinMap : refPinMaps) {
            if (refPinMap.getPinNetA() != refPinMap.getRefNetA() || refPinMap.getPinNetB() != refPinMap.getRefNetB()) {
                this.mViolations.add(new CsvPinNetViolation(refPinMap));
                continue;
            }
            this.mValidations.add(new CsvPinNetResult(refPinMap, true));
        }
    }

    protected void checkRefVsDb() {
        Map<ReferencePinMap, PinMap> ref2dbPinMaps = this.getContactLayers().stream().flatMap(contactLayer -> PinMap.get((ContactLayer)contactLayer).stream()).collect(Collectors.toMap(pm -> new ReferencePinMap((HierInst<PinTemplate>)pm.getHierPinA(), (HierInst<PinTemplate>)pm.getHierPinB()), pm -> pm));
        Set<ReferencePinMap> refPinMaps = this.mContactLayerCsvPinMap.stream().flatMap(clPinMap -> clPinMap.getReferencePinMaps().stream()).collect(Collectors.toSet());
        this.checkRefVsDbRemoved(ref2dbPinMaps, refPinMaps);
        this.checkRefVsDbAdded(ref2dbPinMaps, refPinMaps);
    }

    protected void checkRefVsDbRemoved(Map<ReferencePinMap, PinMap> dbPinMaps, Set<ReferencePinMap> refPinMaps) {
        for (Map.Entry<ReferencePinMap, PinMap> entry : dbPinMaps.entrySet()) {
            ReferencePinMap pm = entry.getKey();
            if (refPinMaps.contains(pm)) {
                this.mValidations.add(new CsvRemovedResult(dbPinMaps.get(pm), true));
                continue;
            }
            this.mViolations.add(new CsvRemovedViolation(dbPinMaps.get(pm)));
        }
    }

    protected void checkRefVsDbAdded(Map<ReferencePinMap, PinMap> dbPinMaps, Set<ReferencePinMap> refPinMaps) {
        for (ReferencePinMap pm : refPinMaps) {
            if (dbPinMaps.containsKey(pm)) {
                this.mValidations.add(new CsvAddedResult(pm, true));
                continue;
            }
            this.mViolations.add(new CsvAddedViolation(pm));
        }
    }

    public static class CsvAddedViolation
    extends CsvAddedResult
    implements PinMapCheck.Violation {
        CsvAddedViolation(ReferencePinMap pinMap) {
            super(pinMap, false);
        }

        @Override
        public boolean isFixed() {
            return false;
        }
    }

    public static class CsvAddedResult
    extends CsvResult {
        ReferencePinMap refPinMap;
        protected boolean isValidated;

        CsvAddedResult(ReferencePinMap pinMap, boolean isValidated) {
            this.mViolationType = ViolationType.ADDED;
            this.refPinMap = pinMap;
            this.isValidated = isValidated;
        }

        @Override
        public boolean isValidated() {
            return this.isValidated;
        }

        public ReferencePinMap getPinMap() {
            return this.refPinMap;
        }
    }

    public static class CsvRemovedViolation
    extends CsvRemovedResult
    implements PinMapCheck.Violation {
        CsvRemovedViolation(PinMap pinMap) {
            super(pinMap, false);
        }

        @Override
        public boolean isFixed() {
            return false;
        }
    }

    public static class CsvRemovedResult
    extends CsvResult {
        PinMap pinMap;
        protected boolean isValidated;

        CsvRemovedResult(PinMap pinMap, boolean isValidated) {
            this.mViolationType = ViolationType.REMOVED;
            this.pinMap = pinMap;
            this.isValidated = isValidated;
        }

        @Override
        public boolean isValidated() {
            return this.isValidated;
        }

        public PinMap getPinMap() {
            return this.pinMap;
        }
    }

    public static class CsvPinNetViolation
    extends CsvPinNetResult
    implements PinMapCheck.Violation {
        CsvPinNetViolation(ReferencePinMap refPinMap) {
            super(refPinMap, false);
        }

        @Override
        public boolean isFixed() {
            return false;
        }
    }

    public static class CsvPinNetResult
    extends CsvResult {
        ReferencePinMap refPinMap;
        protected boolean isValidated;

        CsvPinNetResult(ReferencePinMap refPinMap, boolean isValidated) {
            this.mViolationType = ViolationType.PIN_NET;
            this.refPinMap = refPinMap;
            this.isValidated = isValidated;
        }

        @Override
        public boolean isValidated() {
            return this.isValidated;
        }

        public ReferencePinMap getPinMap() {
            return this.refPinMap;
        }

        public Net getRefNetA() {
            return this.refPinMap.getRefNetA();
        }

        public Net getRefNetB() {
            return this.refPinMap.getRefNetB();
        }

        public boolean isNetAError() {
            return this.refPinMap.getPinNetA() != this.refPinMap.getRefNetA();
        }

        public boolean isNetBError() {
            return this.refPinMap.getPinNetB() != this.refPinMap.getRefNetB();
        }
    }

    public static class CsvPinLayerViolation
    extends CsvPinLayerResult
    implements PinMapCheck.Violation {
        CsvPinLayerViolation(ReferencePinMap pinMap) {
            super(pinMap, false);
        }

        @Override
        public boolean isFixed() {
            return false;
        }
    }

    public static class CsvPinLayerResult
    extends CsvResult {
        ReferencePinMap refPinMap;
        protected boolean isValdated;

        CsvPinLayerResult(ReferencePinMap pinMap, boolean isValidated) {
            this.mViolationType = ViolationType.PIN_LAYER;
            this.refPinMap = pinMap;
            this.isValdated = isValidated;
        }

        @Override
        public boolean isValidated() {
            return this.isValdated;
        }

        public ReferencePinMap getPinMap() {
            return this.refPinMap;
        }
    }

    public static class CsvPinCountMismatchViolation
    extends CsvPinCountMismatchResult
    implements PinMapCheck.Violation {
        CsvPinCountMismatchViolation(HierInst<PinTemplate> hierPin, LinkedList<ReferencePinMap> refPinMaps) {
            super(hierPin, refPinMaps, false);
        }

        @Override
        public boolean isFixed() {
            return false;
        }
    }

    public static class CsvPinCountMismatchResult
    extends CsvResult {
        private final HierInst<PinTemplate> hierPin;
        private final LinkedList<ReferencePinMap> refPinMaps;
        private final DevicePath contactDevPath;
        private final Layer contactLayer;
        protected boolean isValidated;

        CsvPinCountMismatchResult(HierInst<PinTemplate> hierPin, LinkedList<ReferencePinMap> refPinMaps, boolean isValidated) {
            this.mViolationType = ViolationType.PIN_COUNT_MISMATCH;
            this.hierPin = hierPin;
            this.refPinMaps = refPinMaps;
            this.isValidated = isValidated;
            ReferencePinMap refPinMap = refPinMaps.getFirst();
            if (refPinMap.getHierPinA().equals(hierPin)) {
                this.contactDevPath = refPinMap.getContactDevPathA();
                this.contactLayer = refPinMap.getLayerA();
            } else {
                this.contactDevPath = refPinMap.getContactDevPathB();
                this.contactLayer = refPinMap.getLayerB();
            }
        }

        @Override
        public boolean isValidated() {
            return this.isValidated;
        }

        public HierInst<PinTemplate> getHierPin() {
            return this.hierPin;
        }

        public List<ReferencePinMap> getPinMaps() {
            return this.refPinMaps;
        }

        public DevicePath getDevPath() {
            return this.contactDevPath;
        }

        public Layer getLayer() {
            return this.contactLayer;
        }

        public DevicePath getPinPath() {
            return this.hierPin.getPath();
        }

        public DevicePath getPinPathFromContactDev() {
            return this.getPinPath().getRelativePathFromAnchor(this.getDevPath().getDeviceTemplate());
        }

        public PinTemplate getPin() {
            return (PinTemplate)this.hierPin.getSecond();
        }
    }

    public static class CsvFloatingPinViolation
    extends CsvFloatingPinResult
    implements PinMapCheck.Violation {
        CsvFloatingPinViolation(ReferencePinMap refPinMap) {
            super(refPinMap, false);
        }

        @Override
        public boolean isFixed() {
            return false;
        }
    }

    public static class CsvFloatingPinResult
    extends CsvResult {
        ReferencePinMap refPinMap;
        protected boolean isValidated;

        CsvFloatingPinResult(ReferencePinMap refPinMap, boolean isValidated) {
            this.mViolationType = ViolationType.FLOATING_PIN;
            this.refPinMap = refPinMap;
            this.isValidated = isValidated;
        }

        @Override
        public boolean isValidated() {
            return this.isValidated;
        }

        public HierInst<PinTemplate> getHierPin() {
            return this.refPinMap.getHierPinA() != null ? this.refPinMap.getHierPinA() : this.refPinMap.getHierPinB();
        }

        public ContactLayer getContactLayer() {
            return this.refPinMap.getContactLayer();
        }

        public DevicePath getDevPathA() {
            return this.getContactLayer().getDevicePathA();
        }

        public Layer getLayerA() {
            return this.getContactLayer().getContactLayerA();
        }

        public DevicePath getPinPathA() {
            return this.refPinMap.getHierPinA() != null ? this.refPinMap.getHierPinA().getPath() : null;
        }

        public DevicePath getPinPathAFromContactDev() {
            DevicePath pinPath = this.getPinPathA();
            if (pinPath == null || pinPath.getRoot() == this.getDevPathA().getDeviceTemplate()) {
                return pinPath;
            }
            return pinPath.getRelativePathFromAnchor(this.getDevPathA().getDeviceTemplate());
        }

        public PinTemplate getPinA() {
            return this.refPinMap.getHierPinA() != null ? (PinTemplate)this.refPinMap.getHierPinA().getSecond() : null;
        }

        public DevicePath getDevPathB() {
            return this.getContactLayer().getDevicePathB();
        }

        public Layer getLayerB() {
            return this.getContactLayer().getContactLayerB();
        }

        public DevicePath getPinPathB() {
            return this.refPinMap.getHierPinB() != null ? this.refPinMap.getHierPinB().getPath() : null;
        }

        public DevicePath getPinPathBFromContactDev() {
            DevicePath pinPath = this.getPinPathB();
            if (pinPath == null || pinPath.getRoot() == this.getDevPathB().getDeviceTemplate()) {
                return pinPath;
            }
            return pinPath.getRelativePathFromAnchor(this.getDevPathB().getDeviceTemplate());
        }

        public PinTemplate getPinB() {
            return this.refPinMap.getHierPinB() != null ? (PinTemplate)this.refPinMap.getHierPinB().getSecond() : null;
        }
    }

    public static class CsvInputViolation
    extends CsvInputResult
    implements PinMapCheck.Violation {
        CsvInputViolation(PinMapCsvReader.CsvPinMap e) {
            super(e, false);
        }

        CsvInputViolation(PinMapCsvReader.CsvPinMap e, CsvInputResult result) {
            super(e, false);
            this.isNetAError = result.isNetAError;
            this.isNetBError = result.isNetBError;
            this.isPinAError = result.isPinAError;
            this.isPinBError = result.isPinBError;
            this.isPinPathAError = result.isPinPathAError;
            this.isPinPathBError = result.isPinPathBError;
        }

        @Override
        public boolean isFixed() {
            return false;
        }
    }

    public static class CsvInputResult
    extends CsvResult {
        PinMapCsvReader.CsvPinMap csvPinMap;
        boolean isPinPathAError = false;
        boolean isPinAError = false;
        boolean isNetAError = false;
        boolean isPinPathBError = false;
        boolean isPinBError = false;
        boolean isNetBError = false;
        LinkedList<String> errorPath = new LinkedList();
        LinkedList<APair<String, String>> errorPinOnPath = new LinkedList();
        protected boolean isValidated;

        CsvInputResult(PinMapCsvReader.CsvPinMap e, boolean isValidated) {
            this.mViolationType = ViolationType.INPUT;
            this.csvPinMap = e;
            this.isValidated = isValidated;
        }

        void addErrorPath(String pathStr) {
            this.errorPath.add(pathStr);
        }

        void addErrorPinOnPath(String pinStr, String pathStr) {
            this.errorPinOnPath.add((APair<String, String>)new APair((Object)pinStr, (Object)pathStr));
        }

        void setPinPathAError(boolean b) {
            this.isPinPathAError = b;
        }

        void setPinAError(boolean b) {
            this.isPinAError = b;
        }

        void setNetAError(boolean b) {
            this.isNetAError = b;
        }

        void setPinPathBError(boolean b) {
            this.isPinPathBError = b;
        }

        void setPinBError(boolean b) {
            this.isPinBError = b;
        }

        void setNetBError(boolean b) {
            this.isNetBError = b;
        }

        @Override
        public boolean isValidated() {
            return this.isValidated;
        }

        public PinMapCsvReader.CsvPinMap getPinMap() {
            return this.csvPinMap;
        }

        public List<String> getErrorPath() {
            return this.errorPath;
        }

        public List<APair<String, String>> getErrorPinOnPath() {
            return this.errorPinOnPath;
        }

        public Boolean isPinPathAError() {
            return this.isPinPathAError;
        }

        public Boolean isPinAError() {
            return this.isPinAError;
        }

        public Boolean isNetAError() {
            return this.isNetAError;
        }

        public Boolean isPinPathBrror() {
            return this.isPinPathBError;
        }

        public Boolean isPinBError() {
            return this.isPinBError;
        }

        public Boolean isNetBError() {
            return this.isNetBError;
        }
    }

    public static abstract class CsvResult
    implements PinMapCheck.CheckResult {
        ViolationType mViolationType;

        public ViolationType getViolationType() {
            return this.mViolationType;
        }

        @Override
        public String getText() {
            return this.mViolationType.getName();
        }
    }

    public static class ReferencePinMap {
        private final ContactLayer contactLayer;
        private final HierInst<PinTemplate> hierPinA;
        private final Net netA;
        private final HierInst<PinTemplate> hierPinB;
        private final Net netB;

        ReferencePinMap(HierInst<PinTemplate> hierPinA, HierInst<PinTemplate> hierPinB) {
            this(null, hierPinA, null, hierPinB, null);
        }

        public ReferencePinMap(ContactLayer contactLayer, HierInst<PinTemplate> hierPinA, Net netA, HierInst<PinTemplate> hierPinB, Net netB) {
            this.contactLayer = contactLayer;
            this.hierPinA = hierPinA;
            this.netA = netA;
            this.hierPinB = hierPinB;
            this.netB = netB;
        }

        public ContactLayer getContactLayer() {
            return this.contactLayer;
        }

        public DevicePath getContactDevPathA() {
            return this.contactLayer.getDevicePathA();
        }

        public Layer getLayerA() {
            return this.contactLayer.getContactLayerA();
        }

        public DevicePath getContactDevPathB() {
            return this.contactLayer.getDevicePathB();
        }

        public Layer getLayerB() {
            return this.contactLayer.getContactLayerB();
        }

        public DevicePath getPinPathA() {
            return this.hierPinA.getPath();
        }

        public DevicePath getPinPathB() {
            return this.hierPinB.getPath();
        }

        public PinTemplate getPinA() {
            return (PinTemplate)this.hierPinA.getSecond();
        }

        public PinTemplate getPinB() {
            return (PinTemplate)this.hierPinB.getSecond();
        }

        public HierInst<PinTemplate> getHierPinA() {
            return this.hierPinA;
        }

        public HierInst<PinTemplate> getHierPinB() {
            return this.hierPinB;
        }

        public Net getRefNetA() {
            return this.netA;
        }

        public Net getRefNetB() {
            return this.netB;
        }

        public Net getPinNetA() {
            DevicePath pinPathFromContactDev = this.getPinPathAFromContactDev();
            Net topmostNet = NetMap.getTopmostNet((Net)this.getPinA().getNet(), (DevicePath)pinPathFromContactDev);
            return topmostNet.getDeviceTemplate() == pinPathFromContactDev.getRoot() ? topmostNet : null;
        }

        public DevicePath getPinPathAFromContactDev() {
            return this.getPinPathA().getRoot() == this.getContactDevPathA().getDeviceTemplate() ? this.getPinPathA() : this.getPinPathA().getRelativePathFromAnchor(this.getContactDevPathA().getDeviceTemplate());
        }

        public Net getPinNetB() {
            DevicePath pinPathFromContactDev = this.getPinPathBFromContactDev();
            Net topmostNet = NetMap.getTopmostNet((Net)this.getPinB().getNet(), (DevicePath)pinPathFromContactDev);
            return topmostNet.getDeviceTemplate() == pinPathFromContactDev.getRoot() ? topmostNet : null;
        }

        public DevicePath getPinPathBFromContactDev() {
            return this.getPinPathB().getRoot() == this.getContactDevPathB().getDeviceTemplate() ? this.getPinPathB() : this.getPinPathB().getRelativePathFromAnchor(this.getContactDevPathB().getDeviceTemplate());
        }

        public String toString() {
            return String.format("%s.%s - %s.%s", this.getPinPathA().getAFullPath(), this.getPinA().getName(), this.getPinPathB().toString(), this.getPinB().getName());
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ReferencePinMap)) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            ReferencePinMap refPinMap = (ReferencePinMap)obj;
            return this.hierPinA.equals(refPinMap.hierPinA) && this.hierPinB.equals(refPinMap.hierPinB) || this.hierPinA.equals(refPinMap.hierPinB) && this.hierPinB.equals(refPinMap.hierPinA);
        }

        public int hashCode() {
            return this.hierPinA.hashCode() ^ this.hierPinB.hashCode();
        }
    }

    public static class ContactLayerCsvPinMap {
        private final ContactLayer mContactLayer;
        private final String mFileName;
        private List<PinMapCsvReader.CsvPinMap> mCsvPinMaps;
        private List<ReferencePinMap> mReferencePinMaps = new LinkedList<ReferencePinMap>();

        public ContactLayerCsvPinMap(ContactLayer contactLayer, String fileName) {
            this.mContactLayer = contactLayer;
            this.mFileName = fileName;
        }

        public void reset() {
            this.mReferencePinMaps.clear();
        }

        public void addReferencePinMap(HierInst<PinTemplate> hierPinA, Net netA, HierInst<PinTemplate> hierPinB, Net netB) {
            this.mReferencePinMaps.add(new ReferencePinMap(this.mContactLayer, hierPinA, netA, hierPinB, netB));
        }

        private void importCsvPinMap() {
            PinMapCsvReader reader = new PinMapCsvReader(this.mContactLayer);
            reader.importCsvPinMap(this.mFileName);
            this.mCsvPinMaps = reader.getCsvPinMaps();
        }

        public ContactLayer getContactLayer() {
            return this.mContactLayer;
        }

        public DevicePath getContactDevPathA() {
            return this.mContactLayer.getDevicePathA();
        }

        public DevicePath getContactDevPathB() {
            return this.mContactLayer.getDevicePathB();
        }

        public DeviceTemplate getContactDevTA() {
            return this.mContactLayer.getDeviceTemplateA();
        }

        public DeviceTemplate getContactDevTB() {
            return this.mContactLayer.getDeviceTemplateB();
        }

        public List<PinMapCsvReader.CsvPinMap> getCsvPinMaps() {
            return this.mCsvPinMaps;
        }

        public List<ReferencePinMap> getReferencePinMaps() {
            return this.mReferencePinMaps;
        }
    }

    public static enum ViolationType {
        INPUT("Error Input"),
        FLOATING_PIN("Pin Unmapped"),
        PIN_COUNT_MISMATCH("Pin Count Mismatch"),
        PIN_LAYER("Pin Layer"),
        PIN_NET("Pin Net"),
        REMOVED("Pin Map Removed"),
        ADDED("Pin Map Added");

        String name;

        private ViolationType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

