/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.inter_substrate_checks.auto_fix;

import com.sigrity.acl.ALog;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.PortTemplate;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.util.OrbitValidator;
import java.awt.geom.AffineTransform;

public class PinOffsetAutoFix {
    private Db mDb;
    private DeviceTemplate mOwner;

    public PinOffsetAutoFix(Db db, String ownerKeyStr) {
        this(db, (DeviceTemplate)db.getByKeyStr(DeviceTemplate.class, ownerKeyStr));
    }

    public PinOffsetAutoFix(Db db, DeviceTemplate owner) {
        this.mDb = db;
        this.mOwner = owner;
    }

    public void fixHierPort(String targetDevPathStr, String targetPinName, int targetPortNum, String refDevPathStr, String refPinName, int refPortNum) {
        HierInst<PortTemplate> targetHierPort = this.getHierPort(targetDevPathStr, targetPinName, targetPortNum);
        HierInst<PortTemplate> refHierPort = this.getHierPort(refDevPathStr, refPinName, refPortNum);
        if (targetHierPort == null || refHierPort == null) {
            return;
        }
        this.movePort(targetHierPort, refHierPort);
    }

    public void fixHierPort(DevicePath targetDevPath, PortTemplate targetPort, DevicePath refDevPath, PortTemplate refPort) {
        OrbitValidator.validateHierInst((DevicePath)targetDevPath, (DbObject)targetPort);
        OrbitValidator.validateHierInst((DevicePath)refDevPath, (DbObject)refPort);
        this.movePort((HierInst<PortTemplate>)HierInst.create((DevicePath)targetDevPath, (DbObject)targetPort), (HierInst<PortTemplate>)HierInst.create((DevicePath)refDevPath, (DbObject)refPort));
    }

    private HierInst<PortTemplate> getHierPort(String devPathStr, String pinName, int portNum) {
        DevicePath devPath = DevicePath.fromString((Db)this.mDb, (String)devPathStr, (DeviceTemplate)this.mOwner);
        if (devPath == null) {
            ALog.logWarn((String)"DevicePath, %s, do not exist.", (Object[])new Object[]{devPathStr});
            return null;
        }
        PinTemplate pinT = devPath.getDeviceTemplate().getPinByName(pinName);
        if (pinT == null) {
            ALog.logWarn((String)"Pin, %s.%s, do not exist.", (Object[])new Object[]{devPathStr, pinName});
            return null;
        }
        PortTemplate port = pinT.getPortTemplate(portNum);
        if (port == null) {
            ALog.logWarn((String)"Port, %s.%s.%s, do not exist.", (Object[])new Object[]{devPathStr, pinName, portNum});
            return null;
        }
        return HierInst.create((DevicePath)devPath, (DbObject)port);
    }

    private void movePort(HierInst<PortTemplate> targetHierPort, HierInst<PortTemplate> refHierPort) {
        APoint2D refWorldLoc = ((PortTemplate)refHierPort.getSecond()).getCenterLoc(refHierPort.getPath());
        if (this.isDevicePin(targetHierPort)) {
            this.moveDevPinToLoc(targetHierPort, refWorldLoc);
        } else {
            this.movePortToLoc(targetHierPort, refWorldLoc);
        }
    }

    private boolean isDevicePin(HierInst<PortTemplate> hierPort) {
        return hierPort.getPath().getDeviceTemplate().amIAPin();
    }

    private void moveDevPinToLoc(HierInst<PortTemplate> targetHierPort, APoint2D refWorldLoc) {
        AffineTransform xform = targetHierPort.getPath().getParent().getInverseTransform();
        APoint2D devCenterLoc = refWorldLoc.transform(xform);
        Device dev = targetHierPort.getPath().getDevice();
        APoint2D devLoc = devCenterLoc.sub(dev.getCenterOffset());
        dev.setLoc(devLoc);
    }

    private void movePortToLoc(HierInst<PortTemplate> targetHierPort, APoint2D refWorldLoc) {
        AffineTransform xform = targetHierPort.getPath().getInverseTransform();
        APoint2D portCenterLoc = refWorldLoc.transform(xform);
        PortTemplate port = (PortTemplate)targetHierPort.getSecond();
        APoint2D portLoc = portCenterLoc.sub(port.getCenterOffset());
        port.setLoc(portLoc);
    }
}

