/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.inter_substrate_checks.auto_fix;

import com.sigrity.acl.ALog;
import com.sigrity.acl.ATransformUtil;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.ContactLayer;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.LayerShape;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.db.std.PinMap;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.PortTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import java.awt.geom.AffineTransform;
import java.util.List;
import java.util.stream.Collectors;

public class PortContactAutoFix {
    private final Db mDb;
    private final ContactLayer mContactLayer;
    private final boolean mIsTargetPortA;
    private final DevicePath mTargetDevPath;
    private final DevicePath mReferenceDevPath;
    private final HierInst<PinTemplate> mHierPin;
    private AffineTransform mTransfromRoot2TargetDev;
    private PadTemplate mContactPadT;

    public PortContactAutoFix(Db db, ContactLayer contactLayer, boolean isTargetPortA, String pinPathStr, String pinName) {
        this.mDb = db;
        this.mContactLayer = contactLayer;
        this.mIsTargetPortA = isTargetPortA;
        this.mTargetDevPath = isTargetPortA ? contactLayer.getDevicePathA() : contactLayer.getDevicePathB();
        this.mReferenceDevPath = isTargetPortA ? contactLayer.getDevicePathB() : contactLayer.getDevicePathA();
        this.mHierPin = this.getHierPin(pinPathStr, pinName);
        assert (this.mHierPin != null);
    }

    private HierInst<PinTemplate> getHierPin(String pinPathStr, String pinName) {
        DevicePath devPath = DevicePath.fromString((Db)this.mDb, (String)pinPathStr, (DeviceTemplate)this.mContactLayer.getOwner());
        if (devPath == null) {
            ALog.logWarn((String)"DevicePath, %s, do not exist.", (Object[])new Object[]{pinPathStr});
            return null;
        }
        PinTemplate pinT = devPath.getDeviceTemplate().getPinByName(pinName);
        if (pinT == null) {
            ALog.logWarn((String)"Pin, %s.%s, do not exist.", (Object[])new Object[]{pinPathStr, pinName});
            return null;
        }
        return HierInst.create((DevicePath)devPath, (DbObject)pinT);
    }

    public void addContactPort(int portNum) {
        this.addContactPort(this.mHierPin.getPath(), ((PinTemplate)this.mHierPin.getSecond()).getPortTemplate(portNum));
    }

    public void deletePort(int portNum) {
        this.deletePort(this.mHierPin.getPath(), ((PinTemplate)this.mHierPin.getSecond()).getPortTemplate(portNum));
        PinMap.deleteInvalid((Db)this.mDb);
    }

    private void addContactPort(DevicePath devPath, PortTemplate port) {
        HierInst contactHierPin = PinMap.getContactPin((DevicePath)devPath, (PinTemplate)port.getPinTemplate()).stream().filter(hierPin -> this.isTargetDevPath(hierPin.getPath())).findAny().orElseGet(() -> this.createContactPin(devPath, port));
        PinTemplate contactPin = (PinTemplate)contactHierPin.getSecond();
        contactPin.setUse(port.getPinTemplate().getUse());
        PortTemplate contactPort = PortTemplate.create((PinTemplate)contactPin);
        contactPort.setLoc(this.getPortLoc(port.getLoc(), devPath, contactHierPin.getPath()));
        contactPort.setPadTemplate(this.getContactPadTemplate(port));
        contactPort.setRotate(this.getRotInContactDev(devPath, port));
    }

    private APoint2D getPortLoc(APoint2D locInReferenceDev, DevicePath devPath, DevicePath portPath) {
        AffineTransform trans = this.getTransform2ContactDevPath(devPath, portPath);
        return locInReferenceDev.transform(trans);
    }

    private float getRotInContactDev(DevicePath devPath, PortTemplate port) {
        float rot = port.getRotate();
        float rotOfPortPath = devPath.getRot();
        float rotOfTargetDev = this.getTargetDevPath().getRot();
        rot = rot + rotOfPortPath - rotOfTargetDev;
        return ATransformUtil.normRot((float)rot);
    }

    private HierInst<PinTemplate> createContactPin(DevicePath devPath, PortTemplate port) {
        Net contactNet = this.getContactNet(devPath, port.getPinTemplate());
        PinTemplate pinT = port.getPinTemplate();
        String contactPinName = port.getDeviceTemplate().amIAPin() ? devPath.getDevice().getName() : pinT.getName();
        PinTemplate contactPin = PinTemplate.create((Net)contactNet, (String)contactPinName);
        PinMap.create((ContactLayer)this.mContactLayer, (PinTemplate)pinT, (DevicePath)devPath, (PinTemplate)contactPin, (DevicePath)this.getTargetDevPath());
        return HierInst.create((DevicePath)this.getTargetDevPath(), (DbObject)contactPin);
    }

    private Net getContactNet(DevicePath devPath, PinTemplate pinT) {
        DeviceTemplate targetDevT = this.getTargetDevPath().getDeviceTemplate();
        Net refNet = NetMap.getTopmostNet((Net)pinT.getNet(), (DevicePath)devPath.getRelativePathFromAnchor(this.getReferenceDevPath().getDeviceTemplate()));
        if (refNet.isUnused()) {
            return targetDevT.getNetUnused();
        }
        String contactNetName = refNet.getName();
        Net contactNet = Net.getOrCreate((DeviceTemplate)targetDevT, (String)contactNetName);
        return contactNet;
    }

    private PadTemplate getContactPadTemplate(PortTemplate port) {
        if (this.mContactPadT == null) {
            this.mContactPadT = this.getOrCreateContactPadT(port);
        }
        return this.mContactPadT;
    }

    private PadTemplate getOrCreateContactPadT(PortTemplate port) {
        PadTemplate padT = this.getContactPadTemplateFromPinMap();
        if (padT == null) {
            padT = this.createContactPadT(port);
        }
        return padT;
    }

    private PadTemplate createContactPadT(PortTemplate port) {
        PadTemplate padT = PadTemplate.create((Db)this.mDb, (Substrate)this.getTargetLayer().getSubstrate(), (String)"ContactPad");
        List contactGeoms = port.getLayerShapesOnLayer(this.getReferenceLayer()).stream().map(layerShape -> layerShape.getGeom()).collect(Collectors.toList());
        if (contactGeoms.size() == 0) {
            ALog.logWarn((String)"No layer shape on the contact layer");
        } else {
            for (AGeom geom : contactGeoms) {
                LayerShape.create((Layer)this.getTargetLayer(), (DbObject)padT, (AGeom)geom);
            }
        }
        return padT;
    }

    private PadTemplate getContactPadTemplateFromPinMap() {
        IterableIterator contactPins = this.mIsTargetPortA ? this.mContactLayer.getPinOnContactLayerA() : this.mContactLayer.getPinOnContactLayerB();
        return contactPins.stream().map(hierPin -> ((PinTemplate)hierPin.getSecond()).getPadTemplate()).filter(padT -> padT != null).findAny().orElse(null);
    }

    private AffineTransform getTransform2ContactDevPath(DevicePath devPath, DevicePath portPath) {
        AffineTransform xformPin2Owner = devPath.getTransform();
        AffineTransform xform2Contact = portPath.getRelativePathFromAnchor(this.getTargetDevPath().getDeviceTemplate()).getInverseTransform();
        xform2Contact.concatenate(this.getTransfromRoot2TargetDev());
        xform2Contact.concatenate(xformPin2Owner);
        return xform2Contact;
    }

    private AffineTransform getTransfromRoot2TargetDev() {
        if (this.mTransfromRoot2TargetDev == null) {
            this.mTransfromRoot2TargetDev = this.mTargetDevPath.getInverseTransform();
        }
        return this.mTransfromRoot2TargetDev;
    }

    private Layer getTargetLayer() {
        return this.mIsTargetPortA ? this.mContactLayer.getContactLayerA() : this.mContactLayer.getContactLayerB();
    }

    private Layer getReferenceLayer() {
        return this.mIsTargetPortA ? this.mContactLayer.getContactLayerB() : this.mContactLayer.getContactLayerA();
    }

    private DevicePath getReferenceDevPath() {
        assert (this.mReferenceDevPath != null);
        return this.mReferenceDevPath;
    }

    private DevicePath getTargetDevPath() {
        assert (this.mTargetDevPath != null);
        return this.mTargetDevPath;
    }

    private boolean isTargetDevPath(DevicePath devPath) {
        DevicePath substrateDevPath = devPath.pathToSubstrate();
        DevicePath substrateTargetDevPath = this.mTargetDevPath.pathToSubstrate();
        if (substrateDevPath == null) {
            return substrateTargetDevPath == null;
        }
        return substrateDevPath.equals((Object)substrateTargetDevPath);
    }

    private void deletePort(DevicePath devPath, PortTemplate port) {
        if (devPath.getDeviceTemplate().amIAPin()) {
            devPath.getDevice().deleteFromDb();
        } else {
            PinTemplate pinT = port.getPinTemplate();
            port.deleteFromDb();
            if (!pinT.getPortTemplates().hasNext()) {
                pinT.deleteFromDb();
            }
        }
    }
}

