/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.inter_substrate_checks.ui;

import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.AValidator;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.PinMap;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.PortTemplate;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.jfxui.AJFXButton;
import com.sigrity.acl.jfxui.AJFXDesignDialog;
import com.sigrity.acl.jfxui.AJFXDirectoryChooser;
import com.sigrity.acl.jfxui.AJFXPanel;
import com.sigrity.acl.jfxui.CloseHBox;
import com.sigrity.acl.jfxui.SlowOperationAlert;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.NetGraphPanel;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ShowMeTheWay;
import com.sigrity.orbit.inter_substrate_checks.NetPersonalityCheck;
import com.sigrity.orbit.inter_substrate_checks.PinCountMismatchCheck;
import com.sigrity.orbit.inter_substrate_checks.PinMapCheck;
import com.sigrity.orbit.inter_substrate_checks.ReferenceCsvCheck;
import com.sigrity.orbit.inter_substrate_checks.ui.PinMapCheckResultCsv;
import com.sigrity.orbit.inter_substrate_checks.ui.PinMapPortMapInfo;
import com.sigrity.orbit.jfxui.OrbitJFXImages;
import com.sigrity.orbit.ui.core.DesignView2D;
import com.sigrity.orbit.ui.cphelper.CpHelper;
import java.awt.Dimension;
import java.awt.Window;
import java.io.File;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.CacheHint;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ButtonType;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Separator;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTablePosition;
import javafx.scene.control.TreeTableView;
import javafx.scene.control.TreeView;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import javax.swing.SwingUtilities;

public class PinMapCheckEngineUI
extends AJFXDesignDialog {
    private static boolean mDebugAutoFix = false;
    private List<PinMapCheck> mPinMapChecks = new LinkedList<PinMapCheck>();

    public static void debugAutoFix(boolean debug) {
        mDebugAutoFix = debug;
    }

    public static PinMapCheckEngineUI createDialog(Window owner, Db db, PinMapCheck pinMapCheck) {
        AValidator.validateNotNull((Object)db);
        LinkedList<PinMapCheck> pinMapChecks = new LinkedList<PinMapCheck>();
        pinMapChecks.add(pinMapCheck);
        PinMapCheckEngineUI dlg = new PinMapCheckEngineUI(owner, db, pinMapChecks);
        dlg.setVisible(true);
        return dlg;
    }

    public static PinMapCheckEngineUI createDialog(Window owner, Db db, List<PinMapCheck> pinMapChecks) {
        if (db == null) {
            return null;
        }
        PinMapCheckEngineUI dlg = new PinMapCheckEngineUI(owner, db, pinMapChecks);
        dlg.setVisible(true);
        return dlg;
    }

    private PinMapCheckEngineUI(Window owner, Db db, List<PinMapCheck> pinMapChecks) {
        super(db, owner, "Inter-Substrate Connectivity Check");
        this.mPinMapChecks.addAll(pinMapChecks);
        this.init();
    }

    protected AJFXPanel createJfxPanel() {
        return new CheckFXPanel();
    }

    private class CheckFXPanel
    extends AJFXPanel {
        private static final int PANEL_WIDTH = 1400;
        private static final int PANEL_HEIGHT = 300;
        private Toolbar mToolbar;
        private CheckTreeView mCheckTreeView;
        private ViolationTreeTableView mViolationTreeTableView;
        private EventHandler<ActionEvent> mAutoFixEventHandler = new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                TreeItem selectedCheckItem = (TreeItem)CheckFXPanel.this.mCheckTreeView.getSelectionModel().getSelectedItem();
                if (selectedCheckItem == null) {
                    return;
                }
                PinMapPortMapInfo.TypeInfo typeInfo = (PinMapPortMapInfo.TypeInfo)selectedCheckItem.getValue();
                if (typeInfo instanceof PinMapPortMapInfo.CheckTypeInfo) {
                    this.autoFix((PinMapPortMapInfo.CheckTypeInfo)typeInfo);
                }
            }

            private void autoFix(PinMapPortMapInfo.CheckTypeInfo checkInfo) {
                PinMapCheck.CheckType checkType = checkInfo.getCheckType();
                switch (checkType) {
                    case PORT_CONTACT: {
                        this.autoFixPortContact();
                        break;
                    }
                    case PIN_UNMAPPED: {
                        this.autoFixPinUnmapped();
                        break;
                    }
                    case PIN_OFFSET: {
                        this.autoFixPinOffset();
                        break;
                    }
                    case NET_MAPPING: {
                        this.autoFixNetMap();
                        break;
                    }
                    default: {
                        ALog.logWarn((Throwable)new UnsupportedOperationException(), (String)"Auto-fix is not available for %s.", (Object[])new Object[]{checkType.getName()});
                    }
                }
            }

            private void autoFixPortContact() {
                List selectedCells = CheckFXPanel.this.mViolationTreeTableView.getSelectionModel().getSelectedCells().stream().filter(cell -> cell.getTreeItem().getValue() instanceof PinMapPortMapInfo.PortContactViolationInfo).collect(Collectors.toList());
                if (selectedCells.isEmpty()) {
                    return;
                }
                SwingUtilities.invokeLater(() -> {
                    this.cpAutoFixPortContact(selectedCells);
                    OrbitIO.refreshViewsOf(PinMapCheckEngineUI.this.getDb());
                    this.refreshTableLater(selectedCells.stream().map(TreeTablePosition::getTreeItem).collect(Collectors.toList()));
                });
            }

            private void cpAutoFixPortContact(List<TreeTablePosition<PinMapPortMapInfo.Info, ?>> selectedCells) {
                String actionName = "Auto-fix port contact";
                try (DbHistory.DbTransaction dbT = DbHistory.newDbTransaction((Db)PinMapCheckEngineUI.this.getDb(), (String)actionName);){
                    selectedCells.forEach(this::cpAutoFixPortContact);
                }
            }

            private void cpAutoFixPortContact(TreeTablePosition<PinMapPortMapInfo.Info, ?> cellPos) {
                TreeItem treeItem = cellPos.getTreeItem();
                PinMapPortMapInfo.PortContactViolationInfo info = (PinMapPortMapInfo.PortContactViolationInfo)treeItem.getValue();
                if (info.isFixed()) {
                    return;
                }
                TargetObject targetObj = CheckFXPanel.this.mViolationTreeTableView.getTargetObject(cellPos);
                if (targetObj == TargetObject.BOTH) {
                    return;
                }
                boolean fixPortA = targetObj == TargetObject.PINA;
                Cp.exec((String)"unset(\"_contactLayer\");", (Object[])new Object[0]);
                Cp.exec((String)"_contactLayer = curDb().getByKeyStr(ContactLayer.class, \"%s\")", (Object[])new Object[]{info.getContactLayer().getKeyStr()});
                Cp.exec((String)"unset(\"_autoFix\");", (Object[])new Object[0]);
                Cp.exec((String)"_autoFix = new com.sigrity.orbit.inter_substrate_checks.auto_fix.PortContactAutoFix(curDb(), _contactLayer, %b, \"%s\", \"%s\")", (Object[])new Object[]{fixPortA, info.getPortPath(), info.getPort().getPinTemplate().getName()});
                if (fixPortA == info.isPortA()) {
                    Cp.exec((String)"_autoFix.deletePort(%d)", (Object[])new Object[]{info.getPort().getPortNum()});
                } else {
                    Cp.exec((String)"_autoFix.addContactPort(%d)", (Object[])new Object[]{info.getPort().getPortNum()});
                }
                Cp.exec((String)"unset(\"_autoFix\");", (Object[])new Object[0]);
                Cp.exec((String)"unset(\"_contactLayer\");", (Object[])new Object[0]);
            }

            private void autoFixPinUnmapped() {
                List selectedCells = CheckFXPanel.this.mViolationTreeTableView.getSelectionModel().getSelectedCells().stream().filter(cell -> cell.getTreeItem().getValue() instanceof PinMapPortMapInfo.PinUnmappedViolationInfo).collect(Collectors.toList());
                if (selectedCells.isEmpty()) {
                    return;
                }
                SwingUtilities.invokeLater(() -> {
                    this.cpAutoFixPinUnmapped(selectedCells);
                    OrbitIO.refreshViewsOf(PinMapCheckEngineUI.this.getDb());
                    this.refreshTableLater(selectedCells.stream().map(TreeTablePosition::getTreeItem).collect(Collectors.toList()));
                });
            }

            private void cpAutoFixPinUnmapped(List<TreeTablePosition<PinMapPortMapInfo.Info, ?>> selectedCells) {
                String actionName = "Auto-fix pin unmapped";
                try (DbHistory.DbTransaction dbT = DbHistory.newDbTransaction((Db)PinMapCheckEngineUI.this.getDb(), (String)actionName);){
                    selectedCells.forEach(this::cpAutoFixPinUnmapped);
                }
            }

            private void cpAutoFixPinUnmapped(TreeTablePosition<PinMapPortMapInfo.Info, ?> cellPos) {
                TreeItem treeItem = cellPos.getTreeItem();
                PinMapPortMapInfo.PinUnmappedViolationInfo info = (PinMapPortMapInfo.PinUnmappedViolationInfo)treeItem.getValue();
                if (info.isFixed()) {
                    return;
                }
                TargetObject targetObj = CheckFXPanel.this.mViolationTreeTableView.getTargetObject(cellPos);
                if (targetObj == TargetObject.BOTH) {
                    return;
                }
                boolean fixPortA = targetObj == TargetObject.PINA;
                Cp.exec((String)"unset(\"_contactLayer\");", (Object[])new Object[0]);
                Cp.exec((String)"_contactLayer = curDb().getByKeyStr(ContactLayer.class, \"%s\")", (Object[])new Object[]{info.getContactLayer().getKeyStr()});
                Cp.exec((String)"unset(\"_autoFix\");", (Object[])new Object[0]);
                DevicePath pinPath = info.getPinPath();
                PinTemplate pin = info.getPin();
                Cp.exec((String)"_autoFix = new com.sigrity.orbit.inter_substrate_checks.auto_fix.PortContactAutoFix(curDb(), _contactLayer, %b, \"%s\", \"%s\")", (Object[])new Object[]{fixPortA, pinPath, pin.getName()});
                for (PortTemplate port : pin.getPortTemplates()) {
                    if (fixPortA == info.isPinA()) {
                        Cp.exec((String)"_autoFix.deletePort(%d)", (Object[])new Object[]{port.getPortNum()});
                    } else {
                        Cp.exec((String)"_autoFix.addContactPort(%d)", (Object[])new Object[]{port.getPortNum()});
                    }
                    Cp.exec((String)"unset(\"_autoFix\");", (Object[])new Object[0]);
                    Cp.exec((String)"unset(\"_contactLayer\");", (Object[])new Object[0]);
                }
            }

            private void autoFixPinOffset() {
                List selectedCells = CheckFXPanel.this.mViolationTreeTableView.getSelectionModel().getSelectedCells().stream().filter(cell -> cell.getTreeItem().getValue() instanceof PinMapPortMapInfo.PinOffsetViolationInfo).collect(Collectors.toList());
                if (selectedCells.isEmpty()) {
                    return;
                }
                SwingUtilities.invokeLater(() -> {
                    this.cpAutoFixPinOffset(selectedCells);
                    OrbitIO.refreshViewsOf(PinMapCheckEngineUI.this.mDb);
                    this.refreshTableLater(selectedCells.stream().map(TreeTablePosition::getTreeItem).collect(Collectors.toList()));
                });
            }

            private void cpAutoFixPinOffset(List<TreeTablePosition<PinMapPortMapInfo.Info, ?>> selectedCells) {
                String actionName = "Auto-fix pin offset";
                try (DbHistory.DbTransaction dbT = DbHistory.newDbTransaction((Db)PinMapCheckEngineUI.this.getDb(), (String)actionName);){
                    selectedCells.forEach(this::cpAutoFixPinOffset);
                }
            }

            private void cpAutoFixPinOffset(TreeTablePosition<PinMapPortMapInfo.Info, ?> cellPos) {
                TreeItem treeItem = cellPos.getTreeItem();
                PinMapPortMapInfo.PinOffsetViolationInfo info = (PinMapPortMapInfo.PinOffsetViolationInfo)treeItem.getValue();
                if (info.isFixed()) {
                    return;
                }
                TargetObject targetObj = CheckFXPanel.this.mViolationTreeTableView.getTargetObject(cellPos);
                if (targetObj == TargetObject.BOTH) {
                    return;
                }
                boolean isSelectA = targetObj == TargetObject.PINA;
                DevicePath targetPortPath = isSelectA ? info.getPortPathAFromOwner() : info.getPortPathBFromOwner();
                DevicePath refPortPath = isSelectA ? info.getPortPathBFromOwner() : info.getPortPathAFromOwner();
                PortTemplate targetPort = isSelectA ? info.getPortA() : info.getPortB();
                PortTemplate refPort = isSelectA ? info.getPortB() : info.getPortA();
                Cp.exec((String)"unset(\"_autoFix\");", (Object[])new Object[0]);
                Cp.exec((String)"_autoFix = new com.sigrity.orbit.inter_substrate_checks.auto_fix.PinOffsetAutoFix(curDb(), \"%s\");", (Object[])new Object[]{targetPortPath.getRoot().getKeyStr()});
                Cp.exec((String)"_autoFix.fixHierPort(\"%s\", \"%s\", %d, \"%s\", \"%s\", %d)", (Object[])new Object[]{targetPortPath, targetPort.getPinTemplate().getName(), targetPort.getPortNum(), refPortPath, refPort.getPinTemplate().getName(), refPort.getPortNum()});
                Cp.exec((String)"unset(\"_autoFix\");", (Object[])new Object[0]);
            }

            private void autoFixNetMap() {
                List selectedTreeItems = CheckFXPanel.this.mViolationTreeTableView.getSelectionModel().getSelectedItems().stream().filter(treeItem -> treeItem.getValue() instanceof PinMapPortMapInfo.NetMapViolationInfo).collect(Collectors.toList());
                if (selectedTreeItems.isEmpty()) {
                    return;
                }
                SwingUtilities.invokeLater(() -> {
                    this.cpAutoFixNetMap(selectedTreeItems);
                    this.refreshTableLater(selectedTreeItems);
                });
            }

            private void cpAutoFixNetMap(List<TreeItem<PinMapPortMapInfo.Info>> selectedTreeItems) {
                String actionName = "Auto-fix net mapping";
                try (DbHistory.DbTransaction dbT = DbHistory.newDbTransaction((Db)PinMapCheckEngineUI.this.getDb(), (String)actionName);){
                    selectedTreeItems.forEach(this::cpAutoFixNetMap);
                }
            }

            private void cpAutoFixNetMap(TreeItem<PinMapPortMapInfo.Info> treeItem) {
                PinMapPortMapInfo.NetMapViolationInfo violationInfo = (PinMapPortMapInfo.NetMapViolationInfo)treeItem.getValue();
                if (!violationInfo.isFixed()) {
                    Cp.exec((String)"%s.createNetMapping()", (Object[])new Object[]{CpHelper.getObjCmdStr(violationInfo.getPinMap())});
                }
            }

            private void refreshTableLater(List<TreeItem<PinMapPortMapInfo.Info>> selectedTreeItems) {
                Platform.runLater(() -> this.refreshTable(selectedTreeItems));
            }

            private void refreshTable(List<TreeItem<PinMapPortMapInfo.Info>> selectedTreeItems) {
                PinMapPortMapInfo.CheckTypeInfo checkInfo = (PinMapPortMapInfo.CheckTypeInfo)((TreeItem)CheckFXPanel.this.mCheckTreeView.getSelectionModel().getSelectedItem()).getValue();
                selectedTreeItems.forEach(treeItem -> {
                    PinMapPortMapInfo.ViolationInfo violationInfo = (PinMapPortMapInfo.ViolationInfo)treeItem.getValue();
                    if (violationInfo.isFixed()) {
                        PinMapCheck.Violation violation = violationInfo.getViolation();
                        if (violation != null) {
                            checkInfo.getChecks().forEach(check -> check.removeViolation(violation));
                        }
                        CheckFXPanel.this.mViolationTreeTableView.removeItem((TreeItem<PinMapPortMapInfo.Info>)treeItem);
                    }
                });
                CheckFXPanel.this.mViolationTreeTableView.getSelectionModel().clearSelection();
                CheckFXPanel.this.mViolationTreeTableView.requestFocus();
                CheckFXPanel.this.mCheckTreeView.refresh();
            }
        };
        private EventHandler<ActionEvent> mExportCsvEventHandler = e -> {
            String title = "Select directory to export CSV";
            AJFXDirectoryChooser dirChooser = new AJFXDirectoryChooser(title);
            File dir = dirChooser.showDialog((Window)((Object)PinMapCheckEngineUI.this));
            if (dir != null) {
                String dirPath = dir.getPath();
                LinkedList checks = new LinkedList();
                PinMapCheckEngineUI.this.mPinMapChecks.forEach(pinMapCheck -> checks.addAll(pinMapCheck.getChecks()));
                SwingUtilities.invokeLater(() -> {
                    PinMapCheckResultCsv printer = new PinMapCheckResultCsv(checks);
                    printer.exportCsv(dirPath);
                });
            }
        };

        public CheckFXPanel() {
            this.setPreferredSize(new Dimension(1400, 300));
        }

        protected Parent initSceneGraph() {
            VBox root = new VBox(5.0);
            root.setCache(true);
            root.setCacheHint(CacheHint.SPEED);
            this.mToolbar = new Toolbar();
            VBox.setVgrow((Node)this.mToolbar, (Priority)Priority.NEVER);
            root.getChildren().add((Object)this.mToolbar);
            HBox checkInfoHBox = new HBox(2.0);
            this.mCheckTreeView = new CheckTreeView();
            this.mCheckTreeView.init();
            HBox.setHgrow((Node)this.mCheckTreeView, (Priority)Priority.NEVER);
            checkInfoHBox.getChildren().add((Object)this.mCheckTreeView);
            this.mViolationTreeTableView = new ViolationTreeTableView();
            this.mViolationTreeTableView.init();
            HBox.setHgrow((Node)this.mViolationTreeTableView, (Priority)Priority.ALWAYS);
            checkInfoHBox.getChildren().add((Object)this.mViolationTreeTableView);
            VBox.setVgrow((Node)checkInfoHBox, (Priority)Priority.ALWAYS);
            root.getChildren().add((Object)checkInfoHBox);
            CloseHBox closeBox = new CloseHBox((Window)((Object)PinMapCheckEngineUI.this));
            root.getChildren().add((Object)closeBox);
            return root;
        }

        private class CheckTreeView
        extends TreeView<PinMapPortMapInfo.TypeInfo> {
            private static final int PANEL_WIDTH_INT = 202;
            private static final int PANEL_HEIGHT_INT = 200;
            private final TreeItem<PinMapPortMapInfo.TypeInfo> mRoot;
            private EnumMap<PinMapCheck.CheckType, TreeItem<PinMapPortMapInfo.TypeInfo>> checkType2TreeItem = new EnumMap(PinMapCheck.CheckType.class);
            private EnumMap<NetPersonalityCheck.ViolationType, TreeItem<PinMapPortMapInfo.TypeInfo>> netViolationType2TreeItem = new EnumMap(NetPersonalityCheck.ViolationType.class);
            private EnumMap<ReferenceCsvCheck.ViolationType, TreeItem<PinMapPortMapInfo.TypeInfo>> refCsvViolationType2TreeItem = new EnumMap(ReferenceCsvCheck.ViolationType.class);
            private HashMap<Class<? extends PinMapCheck.CheckResult>, TreeItem<PinMapPortMapInfo.TypeInfo>> validatedResultType2TreeItem = new HashMap();
            private HashMap<Class<? extends PinMapCheck.Violation>, TreeItem<PinMapPortMapInfo.TypeInfo>> violatedResultType2TreeItem = new HashMap();

            public CheckTreeView() {
                this.mRoot = new TreeItem((Object)new PinMapPortMapInfo.RootInfo());
                this.mRoot.setExpanded(true);
                this.setRoot(this.mRoot);
                this.setShowRoot(false);
                this.setMaxWidth(202.0);
                this.setMinSize(202.0, 200.0);
            }

            public void init() {
                this.loadChecks();
                this.setCellFactory(this.getTypeInfoCellFactory());
                this.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new CheckTableListener());
            }

            private Callback<TreeView<PinMapPortMapInfo.TypeInfo>, TreeCell<PinMapPortMapInfo.TypeInfo>> getTypeInfoCellFactory() {
                return param -> new TreeCell<PinMapPortMapInfo.TypeInfo>(){

                    protected void updateItem(PinMapPortMapInfo.TypeInfo info, boolean empty) {
                        super.updateItem((Object)info, empty);
                        if (empty) {
                            this.setText(null);
                            this.setGraphic(null);
                            return;
                        }
                        if (info instanceof PinMapPortMapInfo.CheckTypeInfo) {
                            if (((PinMapPortMapInfo.CheckTypeInfo)info).hasViolation()) {
                                CheckTreeView.this.setIcon(this, OrbitJFXImages.EXCLAMATION);
                            } else {
                                CheckTreeView.this.setIcon(this, OrbitJFXImages.CHECK);
                            }
                        } else if (info instanceof PinMapPortMapInfo.RefCsvViolationTypeInfo) {
                            if (((PinMapPortMapInfo.RefCsvViolationTypeInfo)info).hasViolation()) {
                                CheckTreeView.this.setIcon(this, OrbitJFXImages.EXCLAMATION);
                            } else {
                                CheckTreeView.this.setIcon(this, OrbitJFXImages.CHECK);
                            }
                        } else if (info instanceof PinMapPortMapInfo.ValidatedResultTypeInfo) {
                            CheckTreeView.this.setIcon(this, OrbitJFXImages.CHECK);
                        } else if (info instanceof PinMapPortMapInfo.ViolatedResultTypeInfo) {
                            CheckTreeView.this.setIcon(this, OrbitJFXImages.EXCLAMATION);
                        }
                        if (info != null) {
                            this.setText(info.getTypeStr());
                        }
                    }
                };
            }

            private void setIcon(TreeCell<PinMapPortMapInfo.TypeInfo> treeItem, Image image) {
                ImageView imageView = new ImageView(image);
                treeItem.setGraphic((Node)imageView);
            }

            private void loadChecks() {
                LinkedList checks = new LinkedList();
                PinMapCheckEngineUI.this.mPinMapChecks.forEach(pinMapCheck -> checks.addAll(pinMapCheck.getChecks()));
                for (PinMapCheck.Check check : checks) {
                    TreeItem checkTreeItem = this.checkType2TreeItem.get((Object)check.getType());
                    if (checkTreeItem == null) {
                        checkTreeItem = new TreeItem((Object)new PinMapPortMapInfo.CheckTypeInfo(check.getType()));
                        this.checkType2TreeItem.put(check.getType(), (TreeItem<PinMapPortMapInfo.TypeInfo>)checkTreeItem);
                        this.mRoot.getChildren().add((Object)checkTreeItem);
                    }
                    PinMapPortMapInfo.TypeInfo info = (PinMapPortMapInfo.TypeInfo)checkTreeItem.getValue();
                    PinMapPortMapInfo.CheckTypeInfo checkTypeInfo = null;
                    if (!(info instanceof PinMapPortMapInfo.CheckTypeInfo)) {
                        ALog.logError((String)"PinMapCheckEngineUI: Not a CheckTypeInfo node exception.");
                        return;
                    }
                    checkTypeInfo = (PinMapPortMapInfo.CheckTypeInfo)info;
                    checkTypeInfo.addCheck(check);
                    if (check instanceof NetPersonalityCheck) {
                        this.loadValidatedResultType((TreeItem<PinMapPortMapInfo.TypeInfo>)checkTreeItem, check.getType(), check.getValidations());
                        this.loadNetPersonalityViolationType((TreeItem<PinMapPortMapInfo.TypeInfo>)checkTreeItem, check.getViolations());
                        continue;
                    }
                    if (check instanceof ReferenceCsvCheck) {
                        this.loadRefCsvViolationTypeInfo((TreeItem<PinMapPortMapInfo.TypeInfo>)checkTreeItem, check.getValidations(), check.getViolations());
                        continue;
                    }
                    this.loadValidatedResultType((TreeItem<PinMapPortMapInfo.TypeInfo>)checkTreeItem, check.getType(), check.getValidations());
                    this.loadViolatedResultType((TreeItem<PinMapPortMapInfo.TypeInfo>)checkTreeItem, check.getType(), check.getViolations());
                }
            }

            private void loadValidatedResultType(TreeItem<PinMapPortMapInfo.TypeInfo> treeItem, PinMapCheck.CheckType checkType, List<PinMapCheck.CheckResult> validations) {
                if (validations == null || validations.isEmpty()) {
                    return;
                }
                TreeItem vResultTreeItem = this.validatedResultType2TreeItem.get(validations.get(0).getClass());
                if (vResultTreeItem == null) {
                    vResultTreeItem = new TreeItem((Object)new PinMapPortMapInfo.ValidatedResultTypeInfo(checkType, validations.get(0).getClass()));
                    this.validatedResultType2TreeItem.put(validations.get(0).getClass(), (TreeItem<PinMapPortMapInfo.TypeInfo>)vResultTreeItem);
                    treeItem.getChildren().add((Object)vResultTreeItem);
                }
                PinMapPortMapInfo.ValidatedResultTypeInfo vResultTypeInfo = (PinMapPortMapInfo.ValidatedResultTypeInfo)vResultTreeItem.getValue();
                vResultTypeInfo.addValidations(validations);
            }

            private void loadViolatedResultType(TreeItem<PinMapPortMapInfo.TypeInfo> treeItem, PinMapCheck.CheckType checkType, List<PinMapCheck.Violation> violations) {
                if (violations == null || violations.isEmpty()) {
                    return;
                }
                TreeItem vResultTreeItem = this.violatedResultType2TreeItem.get(violations.get(0).getClass());
                if (vResultTreeItem == null) {
                    vResultTreeItem = new TreeItem((Object)new PinMapPortMapInfo.ViolatedResultTypeInfo(checkType, violations.get(0).getClass()));
                    this.violatedResultType2TreeItem.put(violations.get(0).getClass(), (TreeItem<PinMapPortMapInfo.TypeInfo>)vResultTreeItem);
                    treeItem.getChildren().add((Object)vResultTreeItem);
                }
                PinMapPortMapInfo.ViolatedResultTypeInfo vResultTypeInfo = (PinMapPortMapInfo.ViolatedResultTypeInfo)vResultTreeItem.getValue();
                vResultTypeInfo.addViolations(violations);
            }

            private void loadNetPersonalityViolationType(TreeItem<PinMapPortMapInfo.TypeInfo> treeItem, List<PinMapCheck.Violation> allV) {
                if (allV == null || allV.isEmpty()) {
                    return;
                }
                Map vMap = allV.stream().map(v -> (NetPersonalityCheck.NetPersonalityViolation)v).collect(Collectors.groupingBy(NetPersonalityCheck.NetPersonalityViolation::getViolationType, LinkedHashMap::new, Collectors.toList()));
                vMap.forEach((vType, violations) -> {
                    TreeItem vTypeTreeItem = this.netViolationType2TreeItem.get(vType);
                    if (vTypeTreeItem == null) {
                        vTypeTreeItem = new TreeItem((Object)new PinMapPortMapInfo.NetPersonalityViolationTypeInfo(((NetPersonalityCheck.NetPersonalityViolation)violations.get(0)).getClass()));
                        this.netViolationType2TreeItem.put((NetPersonalityCheck.ViolationType)((Object)vType), (TreeItem<PinMapPortMapInfo.TypeInfo>)vTypeTreeItem);
                        treeItem.getChildren().add((Object)vTypeTreeItem);
                    }
                    PinMapPortMapInfo.NetPersonalityViolationTypeInfo npTypeInfo = (PinMapPortMapInfo.NetPersonalityViolationTypeInfo)vTypeTreeItem.getValue();
                    npTypeInfo.addNetPersonalityViolations((List<NetPersonalityCheck.NetPersonalityViolation>)violations);
                });
            }

            private void loadRefCsvViolationTypeInfo(TreeItem<PinMapPortMapInfo.TypeInfo> treeItem, List<PinMapCheck.CheckResult> allValidations, List<PinMapCheck.Violation> allViolations) {
                Map vMap = allValidations.stream().map(v -> (ReferenceCsvCheck.CsvResult)v).collect(Collectors.groupingBy(ReferenceCsvCheck.CsvResult::getViolationType, LinkedHashMap::new, Collectors.toList()));
                vMap.forEach((vType, validations) -> {
                    TreeItem vTypeTreeItem = this.refCsvViolationType2TreeItem.get(vType);
                    if (vTypeTreeItem == null) {
                        vTypeTreeItem = new TreeItem((Object)new PinMapPortMapInfo.RefCsvViolationTypeInfo((ReferenceCsvCheck.ViolationType)((Object)vType)));
                        this.refCsvViolationType2TreeItem.put((ReferenceCsvCheck.ViolationType)((Object)vType), (TreeItem<PinMapPortMapInfo.TypeInfo>)vTypeTreeItem);
                        treeItem.getChildren().add((Object)vTypeTreeItem);
                    }
                    if (validations != null && !validations.isEmpty()) {
                        PinMapPortMapInfo.RefCsvViolationTypeInfo refCsvViolationTypeInfo = (PinMapPortMapInfo.RefCsvViolationTypeInfo)vTypeTreeItem.getValue();
                        refCsvViolationTypeInfo.addValidations((List<ReferenceCsvCheck.CsvResult>)validations);
                        this.loadValidatedResultType((TreeItem<PinMapPortMapInfo.TypeInfo>)vTypeTreeItem, PinMapCheck.CheckType.REFERENCE_COMPARE, validations.stream().map(v -> v).collect(Collectors.toList()));
                    }
                });
                vMap = allViolations.stream().map(v -> (ReferenceCsvCheck.CsvResult)((Object)v)).collect(Collectors.groupingBy(ReferenceCsvCheck.CsvResult::getViolationType, LinkedHashMap::new, Collectors.toList()));
                vMap.forEach((vType, violations) -> {
                    TreeItem vTypeTreeItem = this.refCsvViolationType2TreeItem.get(vType);
                    if (vTypeTreeItem == null) {
                        vTypeTreeItem = new TreeItem((Object)new PinMapPortMapInfo.RefCsvViolationTypeInfo((ReferenceCsvCheck.ViolationType)((Object)vType)));
                        this.refCsvViolationType2TreeItem.put((ReferenceCsvCheck.ViolationType)((Object)vType), (TreeItem<PinMapPortMapInfo.TypeInfo>)vTypeTreeItem);
                        treeItem.getChildren().add((Object)vTypeTreeItem);
                    }
                    if (violations != null && !violations.isEmpty()) {
                        PinMapPortMapInfo.RefCsvViolationTypeInfo refCsvViolationTypeInfo = (PinMapPortMapInfo.RefCsvViolationTypeInfo)vTypeTreeItem.getValue();
                        refCsvViolationTypeInfo.addViolations((List<ReferenceCsvCheck.CsvResult>)violations);
                        this.loadViolatedResultType((TreeItem<PinMapPortMapInfo.TypeInfo>)vTypeTreeItem, PinMapCheck.CheckType.REFERENCE_COMPARE, violations.stream().map(v -> (PinMapCheck.Violation)((Object)v)).collect(Collectors.toList()));
                    }
                });
            }

            private class CheckTableListener
            implements ChangeListener<TreeItem<PinMapPortMapInfo.TypeInfo>> {
                private CheckTableListener() {
                }

                public void changed(ObservableValue<? extends TreeItem<PinMapPortMapInfo.TypeInfo>> obs, TreeItem<PinMapPortMapInfo.TypeInfo> oldSelection, TreeItem<PinMapPortMapInfo.TypeInfo> newSelection) {
                    PinMapPortMapInfo.TypeInfo info = (PinMapPortMapInfo.TypeInfo)((TreeItem)obs.getValue()).getValue();
                    CheckFXPanel.this.mViolationTreeTableView.clear();
                    if (info instanceof PinMapPortMapInfo.ValidatedResultTypeInfo) {
                        PinMapPortMapInfo.ValidatedResultTypeInfo validatedResultTypeInfo = (PinMapPortMapInfo.ValidatedResultTypeInfo)info;
                        CheckFXPanel.this.mViolationTreeTableView.setVisibleColumn(validatedResultTypeInfo.getCheckType());
                        CheckFXPanel.this.mViolationTreeTableView.setVisibleColumn(validatedResultTypeInfo.getValidatedResultClass());
                        CheckFXPanel.this.mViolationTreeTableView.loadValidations(validatedResultTypeInfo.getValidatedResults());
                    } else if (info instanceof PinMapPortMapInfo.ViolatedResultTypeInfo) {
                        PinMapPortMapInfo.ViolatedResultTypeInfo violatedResultTypeInfo = (PinMapPortMapInfo.ViolatedResultTypeInfo)info;
                        CheckFXPanel.this.mViolationTreeTableView.setVisibleColumn(violatedResultTypeInfo.getCheckType());
                        CheckFXPanel.this.mViolationTreeTableView.setVisibleColumn(violatedResultTypeInfo.getViolatedResultClass());
                        CheckFXPanel.this.mViolationTreeTableView.loadViolations(violatedResultTypeInfo.getViolatedResults());
                    }
                    CheckFXPanel.this.mToolbar.refreshBtnDisable();
                }
            }
        }

        private class ViolationTreeTableView
        extends TreeTableView<PinMapPortMapInfo.Info> {
            private static final int PANEL_WIDTH_INT = 1100;
            private static final int PANEL_HEIGHT_INT = 200;
            private final TreeItem<PinMapPortMapInfo.Info> mRoot = new TreeItem((Object)new PinMapPortMapInfo.RootInfo());
            private TreeTableColumn<PinMapPortMapInfo.Info, String> mContactDevAColumn;
            private TreeTableColumn<PinMapPortMapInfo.Info, String> mContactDevBColumn;
            private TreeTableColumn<PinMapPortMapInfo.Info, String> mMaxOffsetColumn;
            private TreeTableColumn<PinMapPortMapInfo.Info, String> mCurOffsetColumn;
            private TreeTableColumn<PinMapPortMapInfo.Info, APair<String, Boolean>> mNetAColumn;
            private TreeTableColumn<PinMapPortMapInfo.Info, String> mDesignNetAColumn;
            private TreeTableColumn<PinMapPortMapInfo.Info, String> mRefNetAColumn;
            private TreeTableColumn<PinMapPortMapInfo.Info, String> mPortAColumn;
            private TreeTableColumn<PinMapPortMapInfo.Info, String> mDirectionAColumn;
            private TreeTableColumn<PinMapPortMapInfo.Info, String> mNetAPersonalityColumn;
            private TreeTableColumn<PinMapPortMapInfo.Info, APair<String, Boolean>> mNetBColumn;
            private TreeTableColumn<PinMapPortMapInfo.Info, String> mDesignNetBColumn;
            private TreeTableColumn<PinMapPortMapInfo.Info, String> mRefNetBColumn;
            private TreeTableColumn<PinMapPortMapInfo.Info, String> mPortBColumn;
            private TreeTableColumn<PinMapPortMapInfo.Info, String> mDirectionBColumn;
            private TreeTableColumn<PinMapPortMapInfo.Info, String> mNetBPersonalityColumn;

            public ViolationTreeTableView() {
                this.mRoot.setExpanded(true);
                this.mContactDevAColumn = new TreeTableColumn("Contact Device A");
                this.mContactDevBColumn = new TreeTableColumn("Contact Device B");
                this.setRoot(this.mRoot);
                this.setShowRoot(false);
                this.setColumnResizePolicy(TreeTableView.UNCONSTRAINED_RESIZE_POLICY);
                this.setPrefSize(1100.0, 200.0);
                this.setSelectionModel();
            }

            public void init() {
                TreeTableColumn numberColumn = new TreeTableColumn("#");
                numberColumn.setPrefWidth(25.0);
                numberColumn.setCellFactory(column -> this.getRowNumCellFactory());
                numberColumn.getStyleClass().add((Object)"row-number-column");
                numberColumn.setSortable(false);
                this.getColumns().add((Object)numberColumn);
                TreeTableColumn devPathAColumn = new TreeTableColumn("DevicePath");
                devPathAColumn.setPrefWidth(120.0);
                devPathAColumn.setCellValueFactory(param -> new ReadOnlyStringWrapper(((PinMapPortMapInfo.Info)param.getValue().getValue()).getDevPathAStr()));
                devPathAColumn.setCellFactory(column -> this.getTreeTableCellFactory());
                this.mContactDevAColumn.getColumns().add((Object)devPathAColumn);
                TreeTableColumn layerAColumn = new TreeTableColumn("Layer");
                layerAColumn.setPrefWidth(80.0);
                layerAColumn.setCellValueFactory(param -> new ReadOnlyStringWrapper(((PinMapPortMapInfo.Info)param.getValue().getValue()).getLayerAName()));
                layerAColumn.setCellFactory(column -> this.getTreeTableCellFactory());
                this.mContactDevAColumn.getColumns().add((Object)layerAColumn);
                TreeTableColumn pinPathAColumn = new TreeTableColumn("PinPath");
                pinPathAColumn.setPrefWidth(100.0);
                pinPathAColumn.setCellValueFactory(this.getPinPathACellValueFactory());
                pinPathAColumn.setCellFactory(column -> this.getCellFactoryWithHighlight());
                this.mContactDevAColumn.getColumns().add((Object)pinPathAColumn);
                TreeTableColumn pinNameAColumn = new TreeTableColumn("Pin");
                pinNameAColumn.setPrefWidth(100.0);
                pinNameAColumn.setCellValueFactory(this.getPinACellValueFactory());
                pinNameAColumn.setCellFactory(column -> this.getCellFactoryWithHighlight());
                this.mContactDevAColumn.getColumns().add((Object)pinNameAColumn);
                this.mNetAColumn = new TreeTableColumn("Net");
                this.mNetAColumn.setPrefWidth(100.0);
                this.mNetAColumn.setCellValueFactory(this.getNetACellValueFactory());
                this.mNetAColumn.setCellFactory(column -> this.getCellFactoryWithHighlight());
                this.mContactDevAColumn.getColumns().add(this.mNetAColumn);
                this.mDesignNetAColumn = new TreeTableColumn("Design Net");
                this.mDesignNetAColumn.setPrefWidth(100.0);
                this.mDesignNetAColumn.setCellValueFactory(param -> new ReadOnlyStringWrapper(((PinMapPortMapInfo.Info)param.getValue().getValue()).getDesignNetAName()));
                this.mDesignNetAColumn.setCellFactory(column -> this.getTreeTableCellFactory());
                this.mContactDevAColumn.getColumns().add(this.mDesignNetAColumn);
                this.mRefNetAColumn = new TreeTableColumn("Reference Net");
                this.mRefNetAColumn.setPrefWidth(100.0);
                this.mRefNetAColumn.setCellValueFactory(param -> new ReadOnlyStringWrapper(((PinMapPortMapInfo.Info)param.getValue().getValue()).getRefNetAName()));
                this.mRefNetAColumn.setCellFactory(column -> this.getTreeTableCellFactory());
                this.mContactDevAColumn.getColumns().add(this.mRefNetAColumn);
                this.mPortAColumn = new TreeTableColumn("Port");
                this.mPortAColumn.setPrefWidth(80.0);
                this.mPortAColumn.setCellValueFactory(param -> new ReadOnlyStringWrapper(((PinMapPortMapInfo.Info)param.getValue().getValue()).getPortNumAStr()));
                this.mPortAColumn.setCellFactory(column -> this.getTreeTableCellFactory());
                this.mContactDevAColumn.getColumns().add(this.mPortAColumn);
                this.mDirectionAColumn = new TreeTableColumn("Direction");
                this.mDirectionAColumn.setPrefWidth(100.0);
                this.mDirectionAColumn.setCellValueFactory(param -> new ReadOnlyStringWrapper(((PinMapPortMapInfo.Info)param.getValue().getValue()).getPinADirationStr()));
                this.mDirectionAColumn.setCellFactory(column -> this.getTreeTableCellFactory());
                this.mContactDevAColumn.getColumns().add(this.mDirectionAColumn);
                this.mNetAPersonalityColumn = new TreeTableColumn("Net Personality");
                this.mNetAPersonalityColumn.setPrefWidth(100.0);
                this.mNetAPersonalityColumn.setCellValueFactory(param -> new ReadOnlyStringWrapper(((PinMapPortMapInfo.Info)param.getValue().getValue()).getNetAPersonalityStr()));
                this.mNetAPersonalityColumn.setCellFactory(column -> this.getTreeTableCellFactory());
                this.mContactDevAColumn.getColumns().add(this.mNetAPersonalityColumn);
                TreeTableColumn devPathBColumn = new TreeTableColumn("DevicePath");
                devPathBColumn.setPrefWidth(120.0);
                devPathBColumn.setCellValueFactory(param -> new ReadOnlyStringWrapper(((PinMapPortMapInfo.Info)param.getValue().getValue()).getDevPathBStr()));
                devPathBColumn.setCellFactory(column -> this.getTreeTableCellFactory());
                this.mContactDevBColumn.getColumns().add((Object)devPathBColumn);
                TreeTableColumn layerBColumn = new TreeTableColumn("Layer");
                layerBColumn.setPrefWidth(80.0);
                layerBColumn.setCellValueFactory(param -> new ReadOnlyStringWrapper(((PinMapPortMapInfo.Info)param.getValue().getValue()).getLayerBName()));
                layerBColumn.setCellFactory(column -> this.getTreeTableCellFactory());
                this.mContactDevBColumn.getColumns().add((Object)layerBColumn);
                TreeTableColumn pinPathBColumn = new TreeTableColumn("PinPath");
                pinPathBColumn.setPrefWidth(100.0);
                pinPathBColumn.setCellValueFactory(this.getPinPathBCellValueFactory());
                pinPathBColumn.setCellFactory(column -> this.getCellFactoryWithHighlight());
                this.mContactDevBColumn.getColumns().add((Object)pinPathBColumn);
                TreeTableColumn pinNameBColumn = new TreeTableColumn("Pin");
                pinNameBColumn.setPrefWidth(100.0);
                pinNameBColumn.setCellValueFactory(this.getPinBCellValueFactory());
                pinNameBColumn.setCellFactory(column -> this.getCellFactoryWithHighlight());
                this.mContactDevBColumn.getColumns().add((Object)pinNameBColumn);
                this.mNetBColumn = new TreeTableColumn("Net");
                this.mNetBColumn.setPrefWidth(100.0);
                this.mNetBColumn.setCellValueFactory(this.getNetBCellValueFactory());
                this.mNetBColumn.setCellFactory(column -> this.getCellFactoryWithHighlight());
                this.mContactDevBColumn.getColumns().add(this.mNetBColumn);
                this.mDesignNetBColumn = new TreeTableColumn("Design Net");
                this.mDesignNetBColumn.setPrefWidth(100.0);
                this.mDesignNetBColumn.setCellValueFactory(param -> new ReadOnlyStringWrapper(((PinMapPortMapInfo.Info)param.getValue().getValue()).getDesignNetBName()));
                this.mDesignNetBColumn.setCellFactory(column -> this.getTreeTableCellFactory());
                this.mContactDevBColumn.getColumns().add(this.mDesignNetBColumn);
                this.mRefNetBColumn = new TreeTableColumn("Reference Net");
                this.mRefNetBColumn.setPrefWidth(100.0);
                this.mRefNetBColumn.setCellValueFactory(param -> new ReadOnlyStringWrapper(((PinMapPortMapInfo.Info)param.getValue().getValue()).getRefNetBName()));
                this.mRefNetBColumn.setCellFactory(column -> this.getTreeTableCellFactory());
                this.mContactDevBColumn.getColumns().add(this.mRefNetBColumn);
                this.mPortBColumn = new TreeTableColumn("Port");
                this.mPortBColumn.setPrefWidth(50.0);
                this.mPortBColumn.setCellValueFactory(param -> new ReadOnlyStringWrapper(((PinMapPortMapInfo.Info)param.getValue().getValue()).getPortNumBStr()));
                this.mPortBColumn.setCellFactory(column -> this.getTreeTableCellFactory());
                this.mContactDevBColumn.getColumns().add(this.mPortBColumn);
                this.mDirectionBColumn = new TreeTableColumn("Direction");
                this.mDirectionBColumn.setPrefWidth(100.0);
                this.mDirectionBColumn.setCellValueFactory(param -> new ReadOnlyStringWrapper(((PinMapPortMapInfo.Info)param.getValue().getValue()).getPinBDirationStr()));
                this.mDirectionBColumn.setCellFactory(column -> this.getTreeTableCellFactory());
                this.mContactDevBColumn.getColumns().add(this.mDirectionBColumn);
                this.mNetBPersonalityColumn = new TreeTableColumn("Net Personality");
                this.mNetBPersonalityColumn.setPrefWidth(100.0);
                this.mNetBPersonalityColumn.setCellValueFactory(param -> new ReadOnlyStringWrapper(((PinMapPortMapInfo.Info)param.getValue().getValue()).getNetBPersonalityStr()));
                this.mNetBPersonalityColumn.setCellFactory(column -> this.getTreeTableCellFactory());
                this.mContactDevBColumn.getColumns().add(this.mNetBPersonalityColumn);
                this.mMaxOffsetColumn = new TreeTableColumn("Max Offset");
                this.mMaxOffsetColumn.setPrefWidth(50.0);
                this.mMaxOffsetColumn.setCellValueFactory(param -> new ReadOnlyStringWrapper(((PinMapPortMapInfo.Info)param.getValue().getValue()).getMaxOffsetStr()));
                this.mMaxOffsetColumn.setCellFactory(column -> this.getTreeTableCellFactory());
                this.getColumns().add(this.mMaxOffsetColumn);
                this.mCurOffsetColumn = new TreeTableColumn("Current Offset");
                this.mCurOffsetColumn.setPrefWidth(50.0);
                this.mCurOffsetColumn.setCellValueFactory(param -> new ReadOnlyStringWrapper(((PinMapPortMapInfo.Info)param.getValue().getValue()).getCurOffsetStr()));
                this.mCurOffsetColumn.setCellFactory(column -> this.getTreeTableCellFactory());
                this.getColumns().add(this.mCurOffsetColumn);
                this.getColumns().add(this.mContactDevAColumn);
                this.getColumns().add(this.mContactDevBColumn);
                this.setOffsetColumnVisible(false);
                this.setContactDevColumnVisible(false);
            }

            private void setSelectionModel() {
                TreeTableView.TreeTableViewSelectionModel selectionModel = this.getSelectionModel();
                selectionModel.setSelectionMode(SelectionMode.MULTIPLE);
                selectionModel.setCellSelectionEnabled(true);
            }

            private TreeTableCell<PinMapPortMapInfo.Info, String> getRowNumCellFactory() {
                return new TreeTableCell<PinMapPortMapInfo.Info, String>(){

                    protected void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setText(null);
                        } else {
                            int rowNum = this.getTreeTableRow().getIndex();
                            this.setText(Integer.toString(rowNum));
                            this.setAlignment(Pos.CENTER_LEFT);
                        }
                    }
                };
            }

            private TreeTableCell<PinMapPortMapInfo.Info, String> getTreeTableCellFactory() {
                return new TreeTableCell<PinMapPortMapInfo.Info, String>(){

                    protected void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item == null && !empty) {
                            this.setText(null);
                            this.setStyle("-fx-background-color: lightyellow;");
                        } else {
                            this.setText(item);
                            this.setStyle("-fx-background-color: transparent;");
                        }
                        this.setAlignment(Pos.CENTER_LEFT);
                    }
                };
            }

            private Callback<TreeTableColumn.CellDataFeatures<PinMapPortMapInfo.Info, APair<String, Boolean>>, ObservableValue<APair<String, Boolean>>> getPinPathACellValueFactory() {
                return param -> {
                    PinMapPortMapInfo.Info info = (PinMapPortMapInfo.Info)param.getValue().getValue();
                    return new SimpleObjectProperty((Object)APair.create((Object)info.getPinPathAStr(), (Object)info.highLightPinPathA()));
                };
            }

            private Callback<TreeTableColumn.CellDataFeatures<PinMapPortMapInfo.Info, APair<String, Boolean>>, ObservableValue<APair<String, Boolean>>> getPinPathBCellValueFactory() {
                return param -> {
                    PinMapPortMapInfo.Info info = (PinMapPortMapInfo.Info)param.getValue().getValue();
                    return new SimpleObjectProperty((Object)APair.create((Object)info.getPinPathBStr(), (Object)info.highLightPinPathB()));
                };
            }

            private Callback<TreeTableColumn.CellDataFeatures<PinMapPortMapInfo.Info, APair<String, Boolean>>, ObservableValue<APair<String, Boolean>>> getPinACellValueFactory() {
                return param -> {
                    PinMapPortMapInfo.Info info = (PinMapPortMapInfo.Info)param.getValue().getValue();
                    return new SimpleObjectProperty((Object)APair.create((Object)info.getPinAName(), (Object)info.highLightPinA()));
                };
            }

            private Callback<TreeTableColumn.CellDataFeatures<PinMapPortMapInfo.Info, APair<String, Boolean>>, ObservableValue<APair<String, Boolean>>> getPinBCellValueFactory() {
                return param -> {
                    PinMapPortMapInfo.Info info = (PinMapPortMapInfo.Info)param.getValue().getValue();
                    return new SimpleObjectProperty((Object)APair.create((Object)info.getPinBName(), (Object)info.highLightPinB()));
                };
            }

            private Callback<TreeTableColumn.CellDataFeatures<PinMapPortMapInfo.Info, APair<String, Boolean>>, ObservableValue<APair<String, Boolean>>> getNetACellValueFactory() {
                return param -> {
                    PinMapPortMapInfo.Info info = (PinMapPortMapInfo.Info)param.getValue().getValue();
                    return new SimpleObjectProperty((Object)APair.create((Object)info.getNetAName(), (Object)info.highLightNetA()));
                };
            }

            private Callback<TreeTableColumn.CellDataFeatures<PinMapPortMapInfo.Info, APair<String, Boolean>>, ObservableValue<APair<String, Boolean>>> getNetBCellValueFactory() {
                return param -> {
                    PinMapPortMapInfo.Info info = (PinMapPortMapInfo.Info)param.getValue().getValue();
                    return new SimpleObjectProperty((Object)APair.create((Object)info.getNetBName(), (Object)info.highLightNetB()));
                };
            }

            private TreeTableCell<PinMapPortMapInfo.Info, APair<String, Boolean>> getCellFactoryWithHighlight() {
                return new TreeTableCell<PinMapPortMapInfo.Info, APair<String, Boolean>>(){

                    protected void updateItem(APair<String, Boolean> item, boolean empty) {
                        super.updateItem(item, empty);
                        if (item == null || item.getFirst() == null) {
                            this.setText(null);
                            if (empty) {
                                this.setStyle("-fx-background-color: transparent;");
                            } else {
                                this.setStyle("-fx-background-color: lightyellow;");
                            }
                        } else {
                            this.setText((String)item.getFirst());
                            if (((Boolean)item.getSecond()).booleanValue()) {
                                this.setStyle("-fx-background-color: transparent; -fx-text-fill: red;");
                            } else {
                                this.setStyle("-fx-background-color: transparent; -fx-text-fill: black;");
                            }
                        }
                        this.setAlignment(Pos.CENTER_LEFT);
                    }
                };
            }

            public void setVisibleColumn(PinMapCheck.CheckType checkType) {
                this.setContactDevColumnVisible(true);
                this.setDesignNetColumnVisible(false);
                this.setRefNetColumnVisible(false);
                switch (checkType) {
                    case PIN_OFFSET: {
                        this.setOffsetColumnVisible(true);
                        this.setNetColumnVisible(false);
                        this.setDesignNetColumnVisible(false);
                        this.setPortColumnVisible(true);
                        this.setDirectionColumnVisible(false);
                        this.setPersonalityColumnVisible(false);
                        break;
                    }
                    case PORT_CONTACT: {
                        this.setOffsetColumnVisible(false);
                        this.setNetColumnVisible(false);
                        this.setDesignNetColumnVisible(false);
                        this.setPortColumnVisible(true);
                        this.setDirectionColumnVisible(false);
                        this.setPersonalityColumnVisible(false);
                        break;
                    }
                    case PIN_DIRECTION: {
                        this.setOffsetColumnVisible(false);
                        this.setNetColumnVisible(true);
                        this.setDesignNetColumnVisible(false);
                        this.setPortColumnVisible(false);
                        this.setDirectionColumnVisible(true);
                        this.setPersonalityColumnVisible(false);
                        break;
                    }
                    case NET_PERSONALITY: {
                        this.setOffsetColumnVisible(false);
                        this.setNetColumnVisible(true);
                        this.setDesignNetColumnVisible(false);
                        this.setPortColumnVisible(false);
                        this.setDirectionColumnVisible(false);
                        this.setPersonalityColumnVisible(true);
                        break;
                    }
                    case DESIGN_NET_NAME: {
                        this.setOffsetColumnVisible(false);
                        this.setNetColumnVisible(false);
                        this.setDesignNetColumnVisible(true);
                        this.setPortColumnVisible(false);
                        this.setDirectionColumnVisible(false);
                        this.setPersonalityColumnVisible(false);
                        break;
                    }
                    default: {
                        this.setOffsetColumnVisible(false);
                        this.setNetColumnVisible(true);
                        this.setDesignNetColumnVisible(false);
                        this.setPortColumnVisible(false);
                        this.setDirectionColumnVisible(false);
                        this.setPersonalityColumnVisible(false);
                    }
                }
            }

            public void setVisibleColumn(Class<?> violationClass) {
                if (violationClass == ReferenceCsvCheck.CsvPinNetViolation.class) {
                    this.setRefNetColumnVisible(true);
                }
            }

            private void setOffsetColumnVisible(boolean b) {
                this.mMaxOffsetColumn.setVisible(b);
                this.mCurOffsetColumn.setVisible(b);
            }

            private void setContactDevColumnVisible(boolean b) {
                this.mContactDevAColumn.setVisible(b);
                this.mContactDevBColumn.setVisible(b);
            }

            private void setNetColumnVisible(boolean b) {
                this.mNetAColumn.setVisible(b);
                this.mNetBColumn.setVisible(b);
            }

            private void setDesignNetColumnVisible(boolean b) {
                this.mDesignNetAColumn.setVisible(b);
                this.mDesignNetBColumn.setVisible(b);
            }

            private void setRefNetColumnVisible(boolean b) {
                this.mRefNetAColumn.setVisible(b);
                this.mRefNetBColumn.setVisible(b);
            }

            private void setPortColumnVisible(boolean b) {
                this.mPortAColumn.setVisible(b);
                this.mPortBColumn.setVisible(b);
            }

            private void setDirectionColumnVisible(boolean b) {
                this.mDirectionAColumn.setVisible(b);
                this.mDirectionBColumn.setVisible(b);
            }

            private void setPersonalityColumnVisible(boolean b) {
                this.mNetAPersonalityColumn.setVisible(b);
                this.mNetBPersonalityColumn.setVisible(b);
            }

            public void clear() {
                this.getRoot().getChildren().clear();
            }

            public void removeItem(TreeItem<PinMapPortMapInfo.Info> fixedItem) {
                this.getRoot().getChildren().remove(fixedItem);
                super.refresh();
            }

            private void loadViolations(List<PinMapCheck.Violation> violations) {
                for (PinMapCheck.Violation v : violations) {
                    this.loadCheckResult(v);
                }
            }

            private void loadValidations(List<PinMapCheck.CheckResult> validations) {
                for (PinMapCheck.CheckResult v : validations) {
                    this.loadCheckResult(v);
                }
            }

            private void loadCheckResult(PinMapCheck.CheckResult result) {
                TreeItem resultTreeItem = null;
                if (result instanceof PinCountMismatchCheck.PinCountMismatchResult) {
                    List<PinMap> pinMaps = ((PinCountMismatchCheck.PinCountMismatchResult)result).getPinMaps();
                    if (pinMaps.size() == 1) {
                        resultTreeItem = new TreeItem((Object)PinMapPortMapInfo.create(pinMaps.get(0)));
                    } else {
                        resultTreeItem = new TreeItem((Object)PinMapPortMapInfo.create(result));
                        for (PinMap pinMap : pinMaps) {
                            TreeItem pinMapTreeItem = new TreeItem((Object)PinMapPortMapInfo.create(pinMap));
                            resultTreeItem.getChildren().add((Object)pinMapTreeItem);
                        }
                    }
                } else if (result instanceof ReferenceCsvCheck.CsvPinCountMismatchResult) {
                    List<ReferenceCsvCheck.ReferencePinMap> refPinMaps = ((ReferenceCsvCheck.CsvPinCountMismatchResult)result).getPinMaps();
                    if (refPinMaps.size() == 1) {
                        resultTreeItem = new TreeItem((Object)PinMapPortMapInfo.create(refPinMaps.get(0)));
                    } else {
                        resultTreeItem = new TreeItem((Object)PinMapPortMapInfo.create(result));
                        for (ReferenceCsvCheck.ReferencePinMap refPinMap : refPinMaps) {
                            TreeItem pinMapTreeItem = new TreeItem((Object)PinMapPortMapInfo.create(refPinMap));
                            resultTreeItem.getChildren().add((Object)pinMapTreeItem);
                        }
                    }
                } else {
                    resultTreeItem = new TreeItem((Object)PinMapPortMapInfo.create(result));
                }
                this.mRoot.getChildren().add((Object)resultTreeItem);
            }

            private TargetObject getTargetObject(TreeTablePosition<PinMapPortMapInfo.Info, ?> cell) {
                TableColumnBase parentColumn = cell.getTableColumn().getParentColumn();
                if (parentColumn == this.mContactDevAColumn) {
                    return TargetObject.PINA;
                }
                if (parentColumn == this.mContactDevBColumn) {
                    return TargetObject.PINB;
                }
                return TargetObject.BOTH;
            }
        }

        private class Toolbar
        extends HBox {
            private AJFXButton mZoomToBtn;
            private AJFXButton mShowMeBtn;
            private AJFXButton mSelectBtn;
            private AJFXButton mNetGraphBtn;
            private AJFXButton mExportCsvBtn;
            private AJFXButton mAutoFixBtn;

            private Toolbar() {
                HBox pinToolBar = new HBox();
                this.mZoomToBtn = new AJFXButton(OrbitJFXImages.ZOOM_FIT, "Zoom to");
                this.mZoomToBtn.transparentBorder();
                this.mZoomToBtn.setOnAction(this.newZoomToAction());
                pinToolBar.getChildren().add((Object)this.mZoomToBtn);
                this.mShowMeBtn = new AJFXButton(OrbitJFXImages.SHOW_ME, "Show me");
                this.mShowMeBtn.transparentBorder();
                this.mShowMeBtn.setOnAction(this.newShowMeAction());
                pinToolBar.getChildren().add((Object)this.mShowMeBtn);
                this.mSelectBtn = new AJFXButton(OrbitJFXImages.SELECT_PORT, "Select");
                this.mSelectBtn.transparentBorder();
                this.mSelectBtn.setOnAction(this.newSelectAction());
                pinToolBar.getChildren().add((Object)this.mSelectBtn);
                this.getChildren().add((Object)pinToolBar);
                this.mNetGraphBtn = new AJFXButton(OrbitJFXImages.GRAPHNET, "Graph net");
                this.mNetGraphBtn.transparentBorder();
                this.mNetGraphBtn.setOnAction(this.newShowGraphNetAction());
                this.getChildren().add((Object)this.newSeparator());
                this.getChildren().add((Object)this.mNetGraphBtn);
                this.mExportCsvBtn = new AJFXButton(OrbitJFXImages.EXPORT, "Export to CSV");
                this.mExportCsvBtn.transparentBorder();
                this.mExportCsvBtn.setOnAction(CheckFXPanel.this.mExportCsvEventHandler);
                this.getChildren().add((Object)this.newSeparator());
                this.getChildren().add((Object)this.mExportCsvBtn);
                if (mDebugAutoFix) {
                    this.mAutoFixBtn = new AJFXButton(OrbitJFXImages.WRENCH, "Auto-fix");
                    this.mAutoFixBtn.transparentBorder();
                    this.mAutoFixBtn.setOnAction(CheckFXPanel.this.mAutoFixEventHandler);
                    this.mAutoFixBtn.setDisable(true);
                    this.getChildren().add((Object)this.newSeparator());
                    this.getChildren().add((Object)this.mAutoFixBtn);
                }
                this.setAlignment(Pos.CENTER_LEFT);
                this.refreshBtnDisable();
            }

            public void refreshBtnDisable() {
                if (CheckFXPanel.this.mCheckTreeView == null) {
                    return;
                }
                TreeItem selectedCheckItem = (TreeItem)CheckFXPanel.this.mCheckTreeView.getSelectionModel().getSelectedItem();
                if (selectedCheckItem == null) {
                    return;
                }
                boolean isDisable = true;
                PinMapPortMapInfo.TypeInfo typeInfo = (PinMapPortMapInfo.TypeInfo)selectedCheckItem.getValue();
                if (typeInfo instanceof PinMapPortMapInfo.CheckTypeInfo) {
                    PinMapCheck.CheckType checkType = ((PinMapPortMapInfo.CheckTypeInfo)typeInfo).getCheckType();
                    boolean bl = isDisable = checkType != PinMapCheck.CheckType.PORT_CONTACT && checkType != PinMapCheck.CheckType.PIN_UNMAPPED && checkType != PinMapCheck.CheckType.PIN_OFFSET && checkType != PinMapCheck.CheckType.NET_MAPPING;
                }
                if (this.mAutoFixBtn != null) {
                    this.mAutoFixBtn.setDisable(isDisable);
                }
            }

            private Separator newSeparator() {
                Separator separator = new Separator();
                separator.setOrientation(Orientation.VERTICAL);
                separator.setMaxHeight(20.0);
                return separator;
            }

            private EventHandler<ActionEvent> newZoomToAction() {
                return e -> {
                    TreeItem treeItem = (TreeItem)CheckFXPanel.this.mViolationTreeTableView.getSelectionModel().getSelectedItem();
                    if (treeItem == null) {
                        return;
                    }
                    TreeTablePosition cell = (TreeTablePosition)CheckFXPanel.this.mViolationTreeTableView.getSelectionModel().getSelectedCells().get(0);
                    PinMapPortMapInfo.Info info = (PinMapPortMapInfo.Info)treeItem.getValue();
                    TargetObject targetObj = CheckFXPanel.this.mViolationTreeTableView.getTargetObject(cell);
                    if (info instanceof PinMapPortMapInfo.PinsInfo) {
                        if (targetObj == TargetObject.PINA) {
                            this.zoomToA((PinMapPortMapInfo.PinsInfo)info);
                        } else if (targetObj == TargetObject.PINB) {
                            this.zoomToB((PinMapPortMapInfo.PinsInfo)info);
                        }
                    } else if (info instanceof PinMapPortMapInfo.PortsInfo) {
                        if (targetObj == TargetObject.PINA) {
                            this.zoomToA((PinMapPortMapInfo.PortsInfo)info);
                        } else if (targetObj == TargetObject.PINB) {
                            this.zoomToB((PinMapPortMapInfo.PortsInfo)info);
                        }
                    }
                };
            }

            private void zoomToA(PinMapPortMapInfo.PinsInfo pinsInfo) {
                DevicePath pinPath = pinsInfo.getPinPathAFromOwner();
                PinTemplate pinT = pinsInfo.getPinA();
                Layer layer = pinsInfo.getLayerA();
                this.zoomToLater(pinPath, pinT, layer);
            }

            private void zoomToB(PinMapPortMapInfo.PinsInfo pinsInfo) {
                DevicePath pinPath = pinsInfo.getPinPathBFromOwner();
                PinTemplate pinT = pinsInfo.getPinB();
                Layer layer = pinsInfo.getLayerB();
                this.zoomToLater(pinPath, pinT, layer);
            }

            private void zoomToA(PinMapPortMapInfo.PortsInfo portsInfo) {
                DevicePath portPath = portsInfo.getPortPathAFromOwner();
                PortTemplate port = portsInfo.getPortA();
                Layer layer = portsInfo.getLayerA();
                this.zoomToLater(portPath, port, layer);
            }

            private void zoomToB(PinMapPortMapInfo.PortsInfo portsInfo) {
                DevicePath portPath = portsInfo.getPortPathBFromOwner();
                PortTemplate port = portsInfo.getPortB();
                Layer layer = portsInfo.getLayerB();
                this.zoomToLater(portPath, port, layer);
            }

            private void zoomToLater(DevicePath pinPath, PinTemplate pinT, Layer layer) {
                SwingUtilities.invokeLater(() -> {
                    this.setOnlyOneLayerVisible(layer);
                    this.zoomTo(pinPath, pinT);
                });
            }

            private void zoomToLater(DevicePath portPath, PortTemplate port, Layer layer) {
                SwingUtilities.invokeLater(() -> {
                    this.setOnlyOneLayerVisible(layer);
                    this.zoomTo(portPath, port);
                });
            }

            private void setOnlyOneLayerVisible(Layer layer) {
                Cp.exec((String)"com.sigrity.orbit.cmd.LayerCommands.setAllLayersVisible(curDb(), false);", (Object[])new Object[0]);
                Cp.exec((String)"com.sigrity.orbit.cmd.LayerCommands.setLayerVisible(%s, true)", (Object[])new Object[]{CpHelper.getObjCmdStr(layer)});
            }

            private void zoomTo(DevicePath pinPath, PinTemplate pin) {
                ARect bounds = pin.getBounds().transform(pinPath.getAFullPath().getTransform()).getBounds();
                if (bounds == null) {
                    return;
                }
                this.zoomToArea(bounds);
            }

            private void zoomTo(DevicePath portPath, PortTemplate port) {
                ARect bounds = port.getBounds().transform(portPath.getAFullPath().getTransform()).getBounds();
                if (bounds == null) {
                    return;
                }
                this.zoomToArea(bounds);
            }

            private void zoomToArea(ARect bounds) {
                DesignView2D v = (DesignView2D)OrbitIO.getCurView();
                bounds.changeSizeBy(0.1);
                v.getCanvas().getXForm().setWorld(bounds);
                v.getCanvas().refresh();
            }

            private EventHandler<ActionEvent> newShowMeAction() {
                return e -> {
                    Set<HierInst<PortTemplate>> hierPorts = this.getSelectedHierPorts();
                    if (hierPorts.isEmpty()) {
                        return;
                    }
                    SwingUtilities.invokeLater(() -> hierPorts.forEach(hierPort -> this.showMe(hierPort.getPath(), (PortTemplate)hierPort.getDbObject())));
                };
            }

            private EventHandler<ActionEvent> newSelectAction() {
                return e -> {
                    Set<HierInst<PortTemplate>> hierPorts = this.getSelectedHierPorts();
                    if (hierPorts.isEmpty()) {
                        return;
                    }
                    SwingUtilities.invokeLater(() -> hierPorts.forEach(hierPort -> this.select(hierPort.getPath(), (PortTemplate)hierPort.getDbObject())));
                };
            }

            private void showMe(DevicePath portPath, PortTemplate port) {
                for (DevicePath path : (List)portPath.getAllFullPaths().collect(Collectors.toList())) {
                    ShowMeTheWay.addHierPort(path, port);
                }
            }

            private void select(DevicePath portPath, PortTemplate port) {
                Selection curSelection = Selection.getCurrentSelectionForDb((Db)PinMapCheckEngineUI.this.mDb);
                portPath.getAllFullPaths().filter(path -> !curSelection.contains(path, (DbObject)port)).forEach(path -> {
                    curSelection.add(path, (DbObject)port.getPinTemplate());
                    curSelection.add(path, (DbObject)port);
                });
            }

            private EventHandler<ActionEvent> newShowGraphNetAction() {
                return e -> {
                    Optional result;
                    Set<HierInst<Net>> hierNets = this.getSelectedHierNets();
                    if (hierNets.isEmpty()) {
                        return;
                    }
                    int netCount = hierNets.size();
                    if (netCount > 10 && ((result = SlowOperationAlert.showLargeNumUIAlert((Window)((Object)PinMapCheckEngineUI.this), (int)netCount)).isEmpty() || result.get() != ButtonType.OK)) {
                        return;
                    }
                    SwingUtilities.invokeLater(() -> {
                        for (HierInst hierNet : hierNets) {
                            NetGraphPanel.showNetGraph((Window)((Object)PinMapCheckEngineUI.this), hierNet.getPath(), (Net)hierNet.getDbObject());
                        }
                    });
                };
            }

            private Set<HierInst<PortTemplate>> getSelectedHierPorts() {
                HashSet<HierInst<PortTemplate>> hierPorts = new HashSet<HierInst<PortTemplate>>();
                for (TreeTablePosition cell : CheckFXPanel.this.mViolationTreeTableView.getSelectionModel().getSelectedCells()) {
                    PortTemplate port;
                    DevicePath portPath;
                    PinMapPortMapInfo.Info pinsInfo;
                    TreeItem treeItem = cell.getTreeItem();
                    if (treeItem == null) continue;
                    PinMapPortMapInfo.Info info = (PinMapPortMapInfo.Info)treeItem.getValue();
                    TargetObject targetObj = CheckFXPanel.this.mViolationTreeTableView.getTargetObject(cell);
                    if (info instanceof PinMapPortMapInfo.PinsInfo) {
                        PinTemplate pin;
                        DevicePath pinPath;
                        pinsInfo = (PinMapPortMapInfo.PinsInfo)info;
                        if (targetObj == TargetObject.PINA) {
                            pinPath = pinsInfo.getPinPathAFromOwner();
                            pin = pinsInfo.getPinA();
                            for (PortTemplate port2 : pin.getPortTemplates()) {
                                hierPorts.add((HierInst<PortTemplate>)HierInst.create((DevicePath)pinPath, (DbObject)port2));
                            }
                        }
                        if (targetObj != TargetObject.PINB) continue;
                        pinPath = pinsInfo.getPinPathBFromOwner();
                        pin = pinsInfo.getPinB();
                        for (PortTemplate port2 : pin.getPortTemplates()) {
                            hierPorts.add((HierInst<PortTemplate>)HierInst.create((DevicePath)pinPath, (DbObject)port2));
                        }
                        continue;
                    }
                    if (!(info instanceof PinMapPortMapInfo.PortsInfo)) continue;
                    pinsInfo = (PinMapPortMapInfo.PortsInfo)info;
                    if (targetObj == TargetObject.PINA) {
                        portPath = pinsInfo.getPortPathAFromOwner();
                        port = pinsInfo.getPortA();
                        hierPorts.add((HierInst<PortTemplate>)HierInst.create((DevicePath)portPath, (DbObject)port));
                    }
                    if (targetObj != TargetObject.PINB) continue;
                    portPath = pinsInfo.getPortPathBFromOwner();
                    port = pinsInfo.getPortB();
                    hierPorts.add((HierInst<PortTemplate>)HierInst.create((DevicePath)portPath, (DbObject)port));
                }
                return hierPorts;
            }

            private Set<HierInst<Net>> getSelectedHierNets() {
                HashSet<HierInst<Net>> hierNets = new HashSet<HierInst<Net>>();
                for (TreeTablePosition cell : CheckFXPanel.this.mViolationTreeTableView.getSelectionModel().getSelectedCells()) {
                    PinMapPortMapInfo.Info pinsInfo;
                    TreeItem treeItem = cell.getTreeItem();
                    if (treeItem == null) continue;
                    PinMapPortMapInfo.Info info = (PinMapPortMapInfo.Info)treeItem.getValue();
                    TargetObject targetObj = CheckFXPanel.this.mViolationTreeTableView.getTargetObject(cell);
                    if (info instanceof PinMapPortMapInfo.PinsInfo) {
                        pinsInfo = (PinMapPortMapInfo.PinsInfo)info;
                        if (targetObj == TargetObject.PINA) {
                            hierNets.add((HierInst<Net>)HierInst.create((DevicePath)pinsInfo.getPinPathAFromOwner(), (DbObject)pinsInfo.getPinA().getNet()));
                        }
                        if (targetObj != TargetObject.PINB) continue;
                        hierNets.add((HierInst<Net>)HierInst.create((DevicePath)pinsInfo.getPinPathBFromOwner(), (DbObject)pinsInfo.getPinB().getNet()));
                        continue;
                    }
                    if (!(info instanceof PinMapPortMapInfo.PortsInfo)) continue;
                    pinsInfo = (PinMapPortMapInfo.PortsInfo)info;
                    if (targetObj == TargetObject.PINA) {
                        hierNets.add((HierInst<Net>)HierInst.create((DevicePath)pinsInfo.getPortPathAFromOwner(), (DbObject)pinsInfo.getPortA().getNet()));
                    }
                    if (targetObj != TargetObject.PINB) continue;
                    hierNets.add((HierInst<Net>)HierInst.create((DevicePath)pinsInfo.getPortPathBFromOwner(), (DbObject)pinsInfo.getPortB().getNet()));
                }
                return hierNets;
            }
        }
    }

    private static enum TargetObject {
        BOTH,
        PINA,
        PINB;

    }
}

