/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.inter_substrate_checks.ui;

import com.sigrity.acl.MutableDouble;
import com.sigrity.acl.app.AApp;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.ContactLayer;
import com.sigrity.acl.ui.AFieldValidator;
import com.sigrity.acl.ui.DbDialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.OrbitApp;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.inter_substrate_checks.ui.RefPinMapCsvEditorUI;
import com.sigrity.orbit.ui.OrbitIcons;
import com.sigrity.orbit.ui.table_editor.EditContactLayerUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class PinMapCheckOptionUI
extends DbDialog {
    protected CheckingOptionsPanel mCheckingOptionsPnl;
    protected JButton mBtnOk;
    private ActionListener mEditContactLayer = e -> EditContactLayerUI.createDialog((Window)((Object)this), this.getDb());
    private ActionListener mOK = e -> {
        if (this.hasContactLayer()) {
            UIUtil.closeWindow((Window)((Object)this));
            PinMapCheckOptionUI.cpGeneratePinMaps(false);
            PinMapCheckOptionUI.cpExecuteChecking(this.mDb, this.mCheckingOptionsPnl);
        } else if (AApp.getApp().getMainWin() != null && !OrbitApp.suppressWaringDialogs()) {
            String message = "No contact layer defined in the design. Set the contact layer before running the check";
            OrbitApp.logAndDisplayWarningDialog((String)message, (String)"Invalid Settings");
        }
    };

    public static Action getAction() {
        return new AbstractAction("Check Inter-Substrate Connectivity"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PinMapCheckOptionUI.showUI(OrbitIO.getMainWindow());
            }

            @Override
            public boolean isEnabled() {
                return super.isEnabled() && OrbitIO.getCurDb() != null;
            }
        };
    }

    public static void showUI(Window owner) {
        PinMapCheckOptionUI dlg = new PinMapCheckOptionUI(OrbitIO.getApp().getCurrentDb(), owner);
        dlg.setVisible(true);
    }

    protected PinMapCheckOptionUI(Db db, Window owner) {
        super(db, (Component)owner, "Check Inter-Substrate Connectivity", Dialog.ModalityType.APPLICATION_MODAL);
        GridBagManager l = GridBagManager.layout((JDialog)((Object)this));
        JButton mBtnEditContactLayer = (JButton)l.add((Component)new JButton("Contact Layer"), (GridBagConstraints)GridBagManager.LEFT);
        l.newline();
        this.mCheckingOptionsPnl = new CheckingOptionsPanel(this.mDb, (Window)((Object)this));
        l.add((Component)this.mCheckingOptionsPnl, (GridBagConstraints)GridBagManager.FILLX_REMAINX);
        l.newline();
        mBtnEditContactLayer.addActionListener(this.mEditContactLayer);
        l.pushFillXRemainX();
        l.addFillX();
        this.mBtnOk = (JButton)l.add((Component)new JButton("OK"));
        this.mBtnOk.addActionListener(this.mOK);
        JButton btnCancel = (JButton)l.add((Component)new JButton("Cancel"));
        l.pop();
        UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnCancel, (JButton)this.mBtnOk);
        this.pack();
        this.setMinimumSize(this.getMinimumSize());
        UIUtil.center((Component)((Object)this));
    }

    private boolean hasContactLayer() {
        return ContactLayer.getValid((Db)this.mDb).hasNext();
    }

    public static void cpGeneratePinMaps(boolean createNetMaps) {
        Cp.exec((String)"unset(\"_pinMapGenerator\");", (Object[])new Object[0]);
        Cp.exec((String)"_pinMapGenerator = new com.sigrity.orbit.automation.pinMap.PinMapGenerator(curDb());", (Object[])new Object[0]);
        Cp.exec((String)"_pinMapGenerator.deleteAllPinMap()", (Object[])new Object[0]);
        Cp.exec((String)"_pinMapGenerator.generatePinMaps()", (Object[])new Object[0]);
        if (createNetMaps) {
            Cp.exec((String)"_pinMapGenerator.createNetMaps()", (Object[])new Object[0]);
        }
        Cp.exec((String)"unset(\"_pinMapGenerator\");", (Object[])new Object[0]);
    }

    public static void cpExecuteChecking(Db db, CheckingOptionsPanel checkingOptionsPnl) {
        Cp.exec((String)"unset(\"_pinMapCheck\");", (Object[])new Object[0]);
        Cp.exec((String)"_pinMapCheck = new com.sigrity.orbit.inter_substrate_checks.PinMapCheck(curDb());", (Object[])new Object[0]);
        if (checkingOptionsPnl.checkPortContact()) {
            Cp.exec((String)"_pinMapCheck.addCheck(com.sigrity.orbit.inter_substrate_checks.PinMapCheck.CheckType.PORT_CONTACT);", (Object[])new Object[0]);
        }
        if (checkingOptionsPnl.checkPinPinOffset() && checkingOptionsPnl.getMaxOffset() != -1.0) {
            Cp.exec((String)"_pinOffsetCheck = new com.sigrity.orbit.inter_substrate_checks.PinOffsetCheck(curDb());", (Object[])new Object[0]);
            Cp.exec((String)"_pinOffsetCheck.setMaxOffset(%f);", (Object[])new Object[]{checkingOptionsPnl.getMaxOffset()});
            Cp.exec((String)"_pinMapCheck.addCheck(_pinOffsetCheck);", (Object[])new Object[0]);
        }
        if (checkingOptionsPnl.checkConnectivityCount()) {
            Cp.exec((String)"_pinMapCheck.addCheck(com.sigrity.orbit.inter_substrate_checks.PinMapCheck.CheckType.PIN_COUNT_MISMATCH);", (Object[])new Object[0]);
        }
        if (checkingOptionsPnl.checkpinDirection()) {
            Cp.exec((String)"_pinMapCheck.addCheck(com.sigrity.orbit.inter_substrate_checks.PinMapCheck.CheckType.PIN_DIRECTION);", (Object[])new Object[0]);
        }
        if (checkingOptionsPnl.checkPinName()) {
            Cp.exec((String)"_pinMapCheck.addCheck(com.sigrity.orbit.inter_substrate_checks.PinMapCheck.CheckType.PIN_NAME);", (Object[])new Object[0]);
        }
        if (checkingOptionsPnl.checkDesignNetName()) {
            Cp.exec((String)"_pinMapCheck.addCheck(com.sigrity.orbit.inter_substrate_checks.PinMapCheck.CheckType.DESIGN_NET_NAME);", (Object[])new Object[0]);
        }
        if (checkingOptionsPnl.checkLocalNetName()) {
            Cp.exec((String)"_pinMapCheck.addCheck(com.sigrity.orbit.inter_substrate_checks.PinMapCheck.CheckType.LOCAL_NET_NAME);", (Object[])new Object[0]);
        }
        if (checkingOptionsPnl.checkNetMapping()) {
            Cp.exec((String)"_pinMapCheck.addCheck(com.sigrity.orbit.inter_substrate_checks.PinMapCheck.CheckType.NET_MAPPING);", (Object[])new Object[0]);
        }
        if (checkingOptionsPnl.checkNetPersonality()) {
            Cp.exec((String)"_pinMapCheck.addCheck(com.sigrity.orbit.inter_substrate_checks.PinMapCheck.CheckType.NET_PERSONALITY);", (Object[])new Object[0]);
        }
        if (checkingOptionsPnl.checkExternalCsv()) {
            Cp.exec((String)"_referenceCsvCheck = new com.sigrity.orbit.inter_substrate_checks.ReferenceCsvCheck(curDb());", (Object[])new Object[0]);
            PinMapCheckOptionUI.addReferenceCsv(db);
            Cp.exec((String)"_pinMapCheck.addCheck(_referenceCsvCheck);", (Object[])new Object[0]);
        }
        Cp.exec((String)"_pinMapCheck.execute();", (Object[])new Object[0]);
        Cp.exec((String)"_pinMapCheck.showResultUI();", (Object[])new Object[0]);
        Cp.exec((String)"unset(\"_pinMapCheck\");", (Object[])new Object[0]);
    }

    private static void addReferenceCsv(Db db) {
        for (ContactLayer contactLayer : ContactLayer.getValid((Db)db)) {
            String csvFile = (String)contactLayer.getValue("ReferenceCompareFile", String.class);
            if (csvFile == null || csvFile.isEmpty()) continue;
            String contactLayerKeyStr = String.format("curDb().getByKeyStr(ContactLayer.class, \"%s\")", contactLayer.getKeyStr());
            Cp.exec((String)"_referenceCsvCheck.addCsvFile(%s, \"%s\")", (Object[])new Object[]{contactLayerKeyStr, csvFile});
        }
    }

    public static class CheckingOptionsPanel
    extends JPanel {
        private Db mDb;
        private Window mOwner;
        protected JCheckBox connectivityCountButton;
        protected JCheckBox netMappingButton;
        protected JCheckBox netPersonalityButton;
        protected JCheckBox pinNameButton;
        protected JCheckBox designNetNameButton;
        protected JCheckBox localNetNameButton;
        protected JCheckBox pinDirectionButton;
        protected JCheckBox portContactButton;
        protected JCheckBox pinpinOffsetButton;
        protected JTextField mTxtMaxOffset;
        protected JCheckBox refCsvCheckBox;
        protected ActionListener mEditRefCsv = e -> RefPinMapCsvEditorUI.showUI(this.mDb, this.mOwner);

        public CheckingOptionsPanel(Db db, Window owner) {
            this.mDb = db;
            this.mOwner = owner;
            this.init();
        }

        private void init() {
            this.setBorder(BorderFactory.createTitledBorder("Checking options"));
            GridBagManager l = new GridBagManager((Container)this);
            this.portContactButton = new JCheckBox("Pin contact");
            this.portContactButton.setToolTipText("Check if the port on the contact layer has a contact pad.");
            this.portContactButton.setSelected(true);
            l.add((Component)this.portContactButton, (GridBagConstraints)GridBagManager.LEFT);
            l.newline();
            JPanel pinOffsetPanel = new JPanel();
            this.pinpinOffsetButton = new JCheckBox("Pin offset");
            this.pinpinOffsetButton.setToolTipText("Check the offset of contact pin based on center of pad.");
            this.pinpinOffsetButton.setSelected(true);
            this.mTxtMaxOffset = new JTextField("0.0", 5);
            pinOffsetPanel.add((Component)this.pinpinOffsetButton, GridBagManager.LEFT.noInsets());
            pinOffsetPanel.add((Component)this.mTxtMaxOffset, GridBagManager.LEFT.noInsets());
            l.add((Component)pinOffsetPanel, (GridBagConstraints)GridBagManager.LEFT.noInsets());
            l.newline();
            this.connectivityCountButton = new JCheckBox("Pin count mismatch");
            this.connectivityCountButton.setToolTipText("Check if a pin has only one contact pin.");
            this.connectivityCountButton.setSelected(true);
            l.add((Component)this.connectivityCountButton, (GridBagConstraints)GridBagManager.LEFT);
            l.newline();
            this.pinDirectionButton = new JCheckBox("Pin direction");
            this.pinDirectionButton.setToolTipText("Check if dircetion of two contact pins.");
            this.pinDirectionButton.setSelected(true);
            l.add((Component)this.pinDirectionButton, (GridBagConstraints)GridBagManager.LEFT);
            l.newline();
            this.pinNameButton = new JCheckBox("Pin name");
            this.pinNameButton.setToolTipText("Check if the pin name of contact pins match.");
            this.pinNameButton.setSelected(true);
            l.add((Component)this.pinNameButton, (GridBagConstraints)GridBagManager.LEFT);
            l.newline();
            this.designNetNameButton = new JCheckBox("Design net name");
            this.designNetNameButton.setToolTipText("Check the name of the net at the design (substrate instance) level.");
            this.designNetNameButton.setSelected(true);
            l.add((Component)this.designNetNameButton, (GridBagConstraints)GridBagManager.LEFT);
            l.newline();
            this.localNetNameButton = new JCheckBox("Local net name");
            this.localNetNameButton.setToolTipText("Check the name of the net at the contact device level.");
            this.localNetNameButton.setSelected(true);
            l.add((Component)this.localNetNameButton, (GridBagConstraints)GridBagManager.LEFT);
            l.newline();
            this.netMappingButton = new JCheckBox("Net mapping");
            this.netMappingButton.setToolTipText("Check if physical connectivity match to logic connectivity.");
            this.netMappingButton.setSelected(true);
            l.add((Component)this.netMappingButton, (GridBagConstraints)GridBagManager.LEFT);
            l.newline();
            this.netPersonalityButton = new JCheckBox("Net personality");
            l.add((Component)this.netPersonalityButton, (GridBagConstraints)GridBagManager.LEFT);
            l.newline();
            JPanel refCsvPanel = new JPanel();
            this.refCsvCheckBox = new JCheckBox("Reference pin map");
            this.refCsvCheckBox.setToolTipText("Compare the csv file with the current design");
            refCsvPanel.add((Component)this.refCsvCheckBox, GridBagManager.LEFT.noInsets());
            JButton refCsvButton = new JButton(OrbitIcons.COG_EDIT);
            refCsvButton.setToolTipText("Edit reference pin map csv");
            refCsvButton.setPreferredSize(new Dimension(25, 25));
            refCsvButton.setOpaque(false);
            refCsvButton.setBorderPainted(false);
            refCsvButton.setBackground(Color.WHITE);
            refCsvButton.addActionListener(this.mEditRefCsv);
            refCsvPanel.add((Component)refCsvButton, GridBagManager.LEFT.noInsets());
            l.add((Component)refCsvPanel, (GridBagConstraints)GridBagManager.LEFT.noInsets());
            l.newline();
            l.addFillX();
            this.setMinimumSize(this.getPreferredSize());
        }

        public boolean checkConnectivityCount() {
            return this.connectivityCountButton.isSelected();
        }

        public boolean checkNetMapping() {
            return this.netMappingButton.isSelected();
        }

        public boolean checkNetPersonality() {
            return this.netPersonalityButton.isSelected();
        }

        public boolean checkDesignNetName() {
            return this.designNetNameButton.isSelected();
        }

        public boolean checkLocalNetName() {
            return this.localNetNameButton.isSelected();
        }

        public boolean checkPinName() {
            return this.pinNameButton.isSelected();
        }

        public boolean checkpinDirection() {
            return this.pinDirectionButton.isSelected();
        }

        public boolean checkPortContact() {
            return this.portContactButton.isSelected();
        }

        public boolean checkPinPinOffset() {
            return this.pinpinOffsetButton.isSelected();
        }

        public double getMaxOffset() {
            double maxOffset = 0.0;
            try {
                MutableDouble d = new MutableDouble();
                String s = AFieldValidator.validateDouble((String)this.mTxtMaxOffset.getText(), (Component)this.mTxtMaxOffset, (MutableDouble)d);
                if (d.getValue() < 0.0) {
                    throw AFieldValidator.createException((String)s, (String)"non-negative", null, (Component)this.mTxtMaxOffset);
                }
                maxOffset = Double.parseDouble(this.mTxtMaxOffset.getText());
            }
            catch (AFieldValidator.AFieldValidationException e) {
                return -1.0;
            }
            return maxOffset;
        }

        public boolean checkExternalCsv() {
            return this.refCsvCheckBox.isSelected();
        }
    }
}

