/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.inter_substrate_checks.ui;

import com.sigrity.acl.ACsvWriter;
import com.sigrity.acl.ALog;
import com.sigrity.acl.app.ABuildInfo;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.inter_substrate_checks.NetPersonalityCheck;
import com.sigrity.orbit.inter_substrate_checks.PinCountMismatchCheck;
import com.sigrity.orbit.inter_substrate_checks.PinMapCheck;
import com.sigrity.orbit.inter_substrate_checks.ReferenceCsvCheck;
import com.sigrity.orbit.inter_substrate_checks.ui.PinMapPortMapInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class PinMapCheckResultCsv {
    protected String mDirPath;
    private EnumMap<PinMapCheck.CheckType, CheckTypeCsv> mEnumMap = new EnumMap(PinMapCheck.CheckType.class);

    public PinMapCheckResultCsv(List<PinMapCheck.Check> checks) {
        checks.forEach(this::classifyCheck);
    }

    public void exportCsv(String dirPath) {
        this.mDirPath = dirPath;
        File dirFile = new File(this.mDirPath);
        if (!dirFile.exists()) {
            boolean isCreateFile = dirFile.mkdir();
            if (isCreateFile) {
                this.mDirPath = dirFile.getAbsolutePath();
            } else {
                ALog.logError((String)"Failed to create inter-substrate connectivity check folder.");
                return;
            }
        }
        for (PinMapCheck.CheckType checkType : this.mEnumMap.keySet()) {
            CheckTypeCsv checkTypeCsv = this.mEnumMap.get((Object)checkType);
            if (checkTypeCsv == null) {
                ALog.logWarn((Throwable)new UnsupportedOperationException(), (String)"Inter-Substrate Connectivity Check (%s) to CSV file is not supported.", (Object[])new Object[]{checkType.getName()});
                continue;
            }
            String checkFileName = checkType.getName().replaceAll(" ", "");
            String filePath = String.format("%s/%s", this.mDirPath, checkFileName);
            this.exportCheckResult2Csv(filePath, checkTypeCsv, false);
            this.exportCheckResult2Csv(filePath, checkTypeCsv, true);
        }
    }

    private void exportCheckResult2Csv(String filePath, CheckTypeCsv checkTypeCsv, boolean isValidatedResult) {
        String checkFilePath = String.format("%s_%s.csv", filePath, isValidatedResult ? "validation" : "violation");
        try (ACsvWriter out = ACsvWriter.open((String)checkFilePath);){
            checkTypeCsv.writeCsv(out, isValidatedResult);
            ALog.logInfo((String)"Export to csv file (%s) complete.", (Object[])new Object[]{checkFilePath});
        }
        catch (Exception excep) {
            ALog.logError((Throwable)excep, (String)"There was an unecpected exception while writing csv file.", (Object[])new Object[0]);
        }
    }

    private void classifyCheck(PinMapCheck.Check check) {
        CheckTypeCsv checkTypeCsv = this.mEnumMap.get((Object)check.getType());
        if (checkTypeCsv == null) {
            checkTypeCsv = this.createCheckCsv(check.getType());
            this.mEnumMap.put(check.getType(), checkTypeCsv);
        }
        if (checkTypeCsv != null) {
            checkTypeCsv.addCheck(check);
        }
    }

    private CheckTypeCsv createCheckCsv(PinMapCheck.CheckType checkType) {
        CheckTypeCsv reTypeCsv = null;
        switch (checkType) {
            case NET_MAPPING: {
                reTypeCsv = new NetMappingCheckCsv();
                break;
            }
            case PIN_UNMAPPED: {
                reTypeCsv = new PinUnmappedCheckCsv();
                break;
            }
            case PORT_CONTACT: {
                reTypeCsv = new PortContactCheckCsv();
                break;
            }
            case PIN_DIRECTION: {
                reTypeCsv = new PinDirectionCheckCsv();
                break;
            }
            case PIN_NAME: {
                reTypeCsv = new PinNameCheckCsv();
                break;
            }
            case DESIGN_NET_NAME: {
                reTypeCsv = new DesignNetNameCheckCsv();
                break;
            }
            case LOCAL_NET_NAME: {
                reTypeCsv = new LocalNetNameCheckCsv();
                break;
            }
            case PIN_OFFSET: {
                reTypeCsv = new PinOffsetCheckCsv();
                break;
            }
            case NET_PERSONALITY: {
                reTypeCsv = new NetPersonalityCheckCsv();
                break;
            }
            case PIN_COUNT_MISMATCH: {
                reTypeCsv = new PinCountMisMatchCheckCsv();
                break;
            }
            case REFERENCE_COMPARE: {
                reTypeCsv = new ReferenceCompareCheckCsv();
                break;
            }
        }
        return reTypeCsv;
    }

    private class ReferenceCompareCheckCsv
    extends CheckTypeCsv {
        public ReferenceCompareCheckCsv() {
            this.mCheckType = PinMapCheck.CheckType.REFERENCE_COMPARE;
            this.mHeader = Arrays.asList(HeaderType.S_TYPE, HeaderType.S_DEVICE_PATH, HeaderType.S_PIN_PATH, HeaderType.S_PIN, HeaderType.DEVICE_PATH_A, HeaderType.LAYER_A, HeaderType.PIN_PATH_A, HeaderType.PIN_A, HeaderType.NET_A, HeaderType.REF_NET_A, HeaderType.DEVICE_PATH_B, HeaderType.LAYER_B, HeaderType.PIN_PATH_B, HeaderType.PIN_B, HeaderType.NET_B, HeaderType.REF_NET_B);
        }

        @Override
        protected void writeChecks(boolean isWriteValidation) {
            List allV = isWriteValidation ? this.mChecks.stream().flatMap(check -> check.getValidations().stream()).collect(Collectors.toList()) : this.mChecks.stream().flatMap(check -> check.getViolations().stream()).collect(Collectors.toList());
            Map vMap = allV.stream().map(v -> (ReferenceCsvCheck.CsvResult)v).collect(Collectors.groupingBy(ReferenceCsvCheck.CsvResult::getViolationType, LinkedHashMap::new, Collectors.toList()));
            vMap.forEach(this::writeSpecialCheckResults);
        }

        private void writeSpecialCheckResults(ReferenceCsvCheck.ViolationType vType, List<ReferenceCsvCheck.CsvResult> results) {
            for (ReferenceCsvCheck.CsvResult r : results) {
                this.writeSpecialInfo(vType, r);
            }
        }

        private void writeSpecialInfo(ReferenceCsvCheck.ViolationType vType, ReferenceCsvCheck.CsvResult r) {
            if (vType == ReferenceCsvCheck.ViolationType.PIN_COUNT_MISMATCH) {
                PinMapPortMapInfo.Info sInfo = PinMapPortMapInfo.create(r);
                ReferenceCsvCheck.CsvPinCountMismatchResult cpcmR = (ReferenceCsvCheck.CsvPinCountMismatchResult)r;
                cpcmR.getPinMaps().forEach(pm -> {
                    this.mCsvWriter.colData(vType.getName().replace(" ", ""));
                    this.mCsvWriter.colData(sInfo.getDevPathAStr());
                    this.mCsvWriter.colData(sInfo.getPinPathAStr());
                    this.mCsvWriter.colData(sInfo.getPinAName());
                    this.writeInfo(PinMapPortMapInfo.create(pm));
                });
            } else {
                PinMapPortMapInfo.Info info = PinMapPortMapInfo.create(r);
                this.mCsvWriter.colData(vType.getName().replace(" ", ""));
                this.mCsvWriter.colData("");
                this.mCsvWriter.colData("");
                this.mCsvWriter.colData("");
                this.writeInfo(info);
            }
        }
    }

    private class NetPersonalityCheckCsv
    extends CheckTypeCsv {
        public NetPersonalityCheckCsv() {
            this.mCheckType = PinMapCheck.CheckType.NET_PERSONALITY;
            this.mHeader = Arrays.asList(HeaderType.S_TYPE, HeaderType.DEVICE_PATH_A, HeaderType.LAYER_A, HeaderType.PIN_PATH_A, HeaderType.PIN_A, HeaderType.NET_A, HeaderType.NET_PERSONALITY_A, HeaderType.DEVICE_PATH_B, HeaderType.LAYER_B, HeaderType.PIN_PATH_B, HeaderType.PIN_B, HeaderType.NET_B, HeaderType.NET_PERSONALITY_B);
        }

        @Override
        protected void writeChecks(boolean isWriteValidation) {
            if (isWriteValidation) {
                List<PinMapCheck.CheckResult> validations = this.mChecks.stream().flatMap(check -> check.getValidations().stream()).collect(Collectors.toList());
                this.writeValidations(validations);
            } else {
                List allV = this.mChecks.stream().flatMap(check -> check.getViolations().stream()).collect(Collectors.toList());
                Map vMap = allV.stream().map(v -> (NetPersonalityCheck.NetPersonalityViolation)v).collect(Collectors.groupingBy(NetPersonalityCheck.NetPersonalityViolation::getViolationType, LinkedHashMap::new, Collectors.toList()));
                vMap.forEach(this::writeViolations);
            }
        }

        private void writeValidations(List<PinMapCheck.CheckResult> validations) {
            for (PinMapCheck.CheckResult v : validations) {
                PinMapPortMapInfo.Info info = PinMapPortMapInfo.create(v);
                this.mCsvWriter.colData("");
                this.writeInfo(info);
            }
        }

        private void writeViolations(NetPersonalityCheck.ViolationType vType, List<NetPersonalityCheck.NetPersonalityViolation> violations) {
            for (NetPersonalityCheck.NetPersonalityViolation v : violations) {
                PinMapPortMapInfo.Info info = PinMapPortMapInfo.create((PinMapCheck.Violation)v);
                this.writeSpecialInfo(vType);
                this.writeInfo(info);
            }
        }

        private void writeSpecialInfo(NetPersonalityCheck.ViolationType vType) {
            this.mCsvWriter.colData(vType.getName().replace(" ", ""));
        }
    }

    private class PinOffsetCheckCsv
    extends CheckTypeCsv {
        public PinOffsetCheckCsv() {
            this.mCheckType = PinMapCheck.CheckType.PIN_OFFSET;
            this.mHeader = Arrays.asList(HeaderType.MAX_OFFSET, HeaderType.CURRENT_OFFSET, HeaderType.DEVICE_PATH_A, HeaderType.LAYER_A, HeaderType.PIN_PATH_A, HeaderType.PIN_A, HeaderType.PORT_A, HeaderType.DEVICE_PATH_B, HeaderType.LAYER_B, HeaderType.PIN_PATH_B, HeaderType.PIN_B, HeaderType.PORT_B);
        }
    }

    private class LocalNetNameCheckCsv
    extends CheckTypeCsv {
        public LocalNetNameCheckCsv() {
            this.mCheckType = PinMapCheck.CheckType.LOCAL_NET_NAME;
            this.mHeader = Arrays.asList(HeaderType.DEVICE_PATH_A, HeaderType.LAYER_A, HeaderType.PIN_PATH_A, HeaderType.PIN_A, HeaderType.NET_A, HeaderType.DEVICE_PATH_B, HeaderType.LAYER_B, HeaderType.PIN_PATH_B, HeaderType.PIN_B, HeaderType.NET_B);
        }
    }

    private class DesignNetNameCheckCsv
    extends CheckTypeCsv {
        public DesignNetNameCheckCsv() {
            this.mCheckType = PinMapCheck.CheckType.DESIGN_NET_NAME;
            this.mHeader = Arrays.asList(HeaderType.DEVICE_PATH_A, HeaderType.LAYER_A, HeaderType.PIN_PATH_A, HeaderType.PIN_A, HeaderType.DESIGN_NET_A, HeaderType.DEVICE_PATH_B, HeaderType.LAYER_B, HeaderType.PIN_PATH_B, HeaderType.PIN_B, HeaderType.DESIGN_NET_B);
        }
    }

    private class PinNameCheckCsv
    extends CheckTypeCsv {
        public PinNameCheckCsv() {
            this.mCheckType = PinMapCheck.CheckType.PIN_NAME;
            this.mHeader = Arrays.asList(HeaderType.DEVICE_PATH_A, HeaderType.LAYER_A, HeaderType.PIN_PATH_A, HeaderType.PIN_A, HeaderType.NET_A, HeaderType.DEVICE_PATH_B, HeaderType.LAYER_B, HeaderType.PIN_PATH_B, HeaderType.PIN_B, HeaderType.NET_B);
        }
    }

    private class PinDirectionCheckCsv
    extends CheckTypeCsv {
        public PinDirectionCheckCsv() {
            this.mCheckType = PinMapCheck.CheckType.PIN_DIRECTION;
            this.mHeader = Arrays.asList(HeaderType.DEVICE_PATH_A, HeaderType.LAYER_A, HeaderType.PIN_PATH_A, HeaderType.PIN_A, HeaderType.NET_A, HeaderType.PIN_DIRECTION_A, HeaderType.DEVICE_PATH_B, HeaderType.LAYER_B, HeaderType.PIN_PATH_B, HeaderType.PIN_B, HeaderType.NET_B, HeaderType.PIN_DIRECTION_B);
        }
    }

    private class PortContactCheckCsv
    extends CheckTypeCsv {
        public PortContactCheckCsv() {
            this.mCheckType = PinMapCheck.CheckType.PORT_CONTACT;
            this.mHeader = Arrays.asList(HeaderType.DEVICE_PATH_A, HeaderType.LAYER_A, HeaderType.PIN_PATH_A, HeaderType.PIN_A, HeaderType.PORT_A, HeaderType.DEVICE_PATH_B, HeaderType.LAYER_B, HeaderType.PIN_PATH_B, HeaderType.PIN_B, HeaderType.PORT_B);
        }
    }

    private class PinUnmappedCheckCsv
    extends CheckTypeCsv {
        public PinUnmappedCheckCsv() {
            this.mCheckType = PinMapCheck.CheckType.PIN_UNMAPPED;
            this.mHeader = Arrays.asList(HeaderType.DEVICE_PATH_A, HeaderType.LAYER_A, HeaderType.PIN_PATH_A, HeaderType.PIN_A, HeaderType.NET_A, HeaderType.DEVICE_PATH_B, HeaderType.LAYER_B, HeaderType.PIN_PATH_B, HeaderType.PIN_B, HeaderType.NET_B);
        }
    }

    private class NetMappingCheckCsv
    extends CheckTypeCsv {
        public NetMappingCheckCsv() {
            this.mCheckType = PinMapCheck.CheckType.NET_MAPPING;
            this.mHeader = Arrays.asList(HeaderType.DEVICE_PATH_A, HeaderType.LAYER_A, HeaderType.PIN_PATH_A, HeaderType.PIN_A, HeaderType.NET_A, HeaderType.DEVICE_PATH_B, HeaderType.LAYER_B, HeaderType.PIN_PATH_B, HeaderType.PIN_B, HeaderType.NET_B);
        }
    }

    private class PinCountMisMatchCheckCsv
    extends CheckTypeCsv {
        public PinCountMisMatchCheckCsv() {
            this.mCheckType = PinMapCheck.CheckType.PIN_COUNT_MISMATCH;
            this.mHeader = Arrays.asList(HeaderType.S_DEVICE_PATH, HeaderType.S_PIN_PATH, HeaderType.S_PIN, HeaderType.DEVICE_PATH_A, HeaderType.LAYER_A, HeaderType.PIN_PATH_A, HeaderType.PIN_A, HeaderType.NET_A, HeaderType.DEVICE_PATH_B, HeaderType.LAYER_B, HeaderType.PIN_PATH_B, HeaderType.PIN_B, HeaderType.NET_B);
        }

        @Override
        protected void writeCheckResults(List<? extends PinMapCheck.CheckResult> results) {
            for (PinMapCheck.CheckResult checkResult : results) {
                PinCountMismatchCheck.PinCountMismatchResult r = (PinCountMismatchCheck.PinCountMismatchResult)checkResult;
                PinMapPortMapInfo.Info sInfo = PinMapPortMapInfo.create((PinMapCheck.CheckResult)r);
                r.getPinMaps().forEach(pm -> {
                    this.writeSpecialInfo(sInfo);
                    this.writeInfo(PinMapPortMapInfo.create(pm));
                });
            }
        }

        private void writeSpecialInfo(PinMapPortMapInfo.Info info) {
            this.mCsvWriter.colData(info.getDevPathAStr());
            this.mCsvWriter.colData(info.getPinPathAStr());
            this.mCsvWriter.colData(info.getPinAName());
        }
    }

    private abstract class CheckTypeCsv {
        protected LinkedList<PinMapCheck.Check> mChecks = new LinkedList();
        protected PinMapCheck.CheckType mCheckType;
        protected List<HeaderType> mHeader;
        protected ACsvWriter mCsvWriter;

        private CheckTypeCsv() {
        }

        protected void writeCsv(ACsvWriter csvWriter, boolean isWriteValidation) {
            this.mCsvWriter = csvWriter;
            this.writeDesignInfo();
            this.writeCheckInfo();
            this.writeHeader();
            this.writeChecks(isWriteValidation);
        }

        protected void writeDesignInfo() {
            assert (this.mCsvWriter != null);
            this.mCsvWriter.row(new String[]{String.format("#. %s version %s", OrbitIO.getApp().getName(true), OrbitIO.getApp().getVersion())});
            this.mCsvWriter.row(new String[]{String.format("#. Build: %s (%s)", ABuildInfo.getVersion(), ABuildInfo.getTimestamp())});
            this.mCsvWriter.row(new String[]{String.format("#. User: %s", System.getProperty("user.name"))});
            this.mCsvWriter.row(new String[]{String.format("#. Time: %s", new Date())});
            String file = OrbitIO.getCurDb().getCanonicalPath();
            this.mCsvWriter.row(new String[]{String.format("#. Source design: %s", file != null ? file : "<Unsaved Design>")});
            this.mCsvWriter.row(new String[]{"#."});
        }

        protected void writeCheckInfo() {
            this.mCsvWriter.row(new String[]{String.format("#. Pin Map Check Type: %s", this.mCheckType.getName())});
            this.mCsvWriter.row(new String[]{"#."});
        }

        protected void writeHeader() {
            ArrayList<String> headerStrings = new ArrayList<String>(this.mHeader.size());
            for (HeaderType headerType : this.mHeader) {
                headerStrings.add(headerType.getString());
            }
            String[] tmp = new String[]{};
            this.mCsvWriter.header(headerStrings.toArray(tmp));
        }

        protected void writeChecks(boolean isWriteValidation) {
            if (isWriteValidation) {
                this.mChecks.forEach(check -> this.writeCheckResults(check.getValidations()));
            } else {
                this.mChecks.forEach(check -> this.writeCheckResults(check.getViolations()));
            }
        }

        protected void writeCheckResults(List<? extends PinMapCheck.CheckResult> results) {
            for (PinMapCheck.CheckResult checkResult : results) {
                PinMapPortMapInfo.Info info = PinMapPortMapInfo.create(checkResult);
                this.writeInfo(info);
            }
        }

        protected void writeInfo(PinMapPortMapInfo.Info info) {
            block25: for (HeaderType headerType : this.mHeader) {
                String writeString;
                switch (headerType) {
                    case S_DEVICE_PATH: 
                    case S_PIN_PATH: 
                    case S_PIN: 
                    case S_TYPE: {
                        continue block25;
                    }
                    case DEVICE_PATH_A: {
                        writeString = info.getDevPathAStr();
                        break;
                    }
                    case DEVICE_PATH_B: {
                        writeString = info.getDevPathBStr();
                        break;
                    }
                    case LAYER_A: {
                        writeString = info.getLayerAName();
                        break;
                    }
                    case LAYER_B: {
                        writeString = info.getLayerBName();
                        break;
                    }
                    case PIN_PATH_A: {
                        writeString = info.getPinPathAStr();
                        break;
                    }
                    case PIN_PATH_B: {
                        writeString = info.getPinPathBStr();
                        break;
                    }
                    case PIN_A: {
                        writeString = info.getPinAName();
                        break;
                    }
                    case PIN_B: {
                        writeString = info.getPinBName();
                        break;
                    }
                    case NET_A: {
                        writeString = info.getNetAName();
                        break;
                    }
                    case NET_B: {
                        writeString = info.getNetBName();
                        break;
                    }
                    case NET_PERSONALITY_A: {
                        writeString = info.getNetAPersonalityStr();
                        break;
                    }
                    case NET_PERSONALITY_B: {
                        writeString = info.getNetBPersonalityStr();
                        break;
                    }
                    case REF_NET_A: {
                        writeString = info.getRefNetAName();
                        break;
                    }
                    case REF_NET_B: {
                        writeString = info.getRefNetBName();
                        break;
                    }
                    case DESIGN_NET_A: {
                        writeString = info.getDesignNetAName();
                        break;
                    }
                    case DESIGN_NET_B: {
                        writeString = info.getDesignNetBName();
                        break;
                    }
                    case PORT_A: {
                        writeString = info.getPortNumAStr();
                        break;
                    }
                    case PORT_B: {
                        writeString = info.getPortNumBStr();
                        break;
                    }
                    case PIN_DIRECTION_A: {
                        writeString = info.getPinADirationStr();
                        break;
                    }
                    case PIN_DIRECTION_B: {
                        writeString = info.getPinBDirationStr();
                        break;
                    }
                    case MAX_OFFSET: {
                        writeString = info.getMaxOffsetStr();
                        break;
                    }
                    case CURRENT_OFFSET: {
                        writeString = info.getCurOffsetStr();
                        break;
                    }
                    default: {
                        writeString = null;
                    }
                }
                this.mCsvWriter.colData(writeString);
            }
            this.mCsvWriter.endRow();
        }

        protected void addCheck(PinMapCheck.Check check) {
            this.mChecks.add(check);
        }
    }

    protected static enum HeaderType {
        DEVICE_PATH_A("DevicePathA"),
        DEVICE_PATH_B("DevicePathB"),
        LAYER_A("LayerA"),
        LAYER_B("LayerB"),
        PIN_PATH_A("PinPathA"),
        PIN_PATH_B("PinPathB"),
        PIN_A("PinA"),
        PIN_B("PinB"),
        PIN_DIRECTION_A("DirectionA"),
        PIN_DIRECTION_B("DirectionB"),
        NET_A("NetA"),
        NET_B("NetB"),
        NET_PERSONALITY_A("NetPersonalityA"),
        NET_PERSONALITY_B("NetPersonalityB"),
        REF_NET_A("ReferenceNetA"),
        REF_NET_B("ReferenceNetB"),
        DESIGN_NET_A("DesignNetA"),
        DESIGN_NET_B("DesignNetB"),
        PORT_A("PortA"),
        PORT_B("PortB"),
        MAX_OFFSET("MaxOffset"),
        CURRENT_OFFSET("Current Offset"),
        S_DEVICE_PATH("DevicePath"),
        S_PIN_PATH("PinPath"),
        S_PIN("Pin"),
        S_TYPE("Type");

        String mString;

        private HeaderType(String string2) {
            this.mString = string2;
        }

        public String getString() {
            return this.mString;
        }
    }
}

