/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.inter_substrate_checks.ui;

import com.sigrity.acl.AFileFilter;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.ui.AFileChooser;
import com.sigrity.acl.ui.ASplitPane;
import com.sigrity.acl.ui.DbDialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.acl.ui.atree.ALazyTreeNode;
import com.sigrity.acl.ui.atree.ATree;
import com.sigrity.acl.ui.atree.ATreeModel;
import com.sigrity.acl.ui.atree.ATreeNode;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.inter_substrate_checks.PinMapCheck;
import com.sigrity.orbit.inter_substrate_checks.ReferenceCsvCheck;
import com.sigrity.orbit.inter_substrate_checks.ui.PinMapCheckResultXml;
import com.sigrity.orbit.inter_substrate_checks.ui.ViolationPanel;
import com.sigrity.orbit.ui.OrbitIcons;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.TreeNode;

public class PinMapCheckResultUI
extends DbDialog {
    protected List<PinMapCheck.Check> mChecks;
    protected JTree mTree;
    protected JScrollPane mRight;
    protected ActionListener mExportXML = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            AFileChooser fc = new AFileChooser();
            fc.addChoosableFileFilter((FileFilter)AFileFilter.XML);
            fc.setFileFilter((FileFilter)AFileFilter.XML);
            fc.setFileSelectionMode(0);
            fc.setMultiSelectionEnabled(false);
            fc.setDialogTitle("Export Checking Result");
            if (fc.showSaveDialog((Component)OrbitIO.getMainWindow()) != 0) {
                return;
            }
            File fRuleFile = fc.getSelectedFile();
            if (fRuleFile == null) {
                return;
            }
            String fileName = fRuleFile.getPath();
            if (!fileName.contains(".xml")) {
                fileName = String.format("%s.xml", fileName);
            }
            PinMapCheckResultXml printer = new PinMapCheckResultXml(PinMapCheckResultUI.this.mChecks);
            printer.exportXml(fileName);
        }
    };

    public static PinMapCheckResultUI showUI(Db db, Window owner, List<PinMapCheck.Check> checks) {
        PinMapCheckResultUI ui = new PinMapCheckResultUI(db, owner, checks);
        ui.setVisible(true);
        return ui;
    }

    public PinMapCheckResultUI(Db db, Window owner, List<PinMapCheck.Check> checks) {
        super(db, (Component)owner, "Check Inter-Substrate Connectivity");
        this.inti(checks);
    }

    public void inti(List<PinMapCheck.Check> checks) {
        this.mChecks = checks;
        GridBagManager l = GridBagManager.layout((JDialog)((Object)this));
        ATreeModel treeModel = new ATreeModel();
        treeModel.setRoot((TreeNode)((Object)new RootNode(treeModel)));
        this.mTree = new ATree(treeModel);
        this.mTree.setShowsRootHandles(true);
        this.mTree.setRootVisible(false);
        UIUtil.expandTreeLevels((JTree)this.mTree, (int)1);
        this.mRight = new JScrollPane();
        this.mRight.setMinimumSize(new Dimension(700, 200));
        JScrollPane left = new JScrollPane(this.mTree);
        left.setMinimumSize(new Dimension(200, 200));
        ASplitPane splitter = new ASplitPane(1, left, this.mRight);
        l.add((Component)splitter, (GridBagConstraints)GridBagManager.FILLALL_REMAINX);
        l.newline();
        l.pushFillXRemainX();
        l.addFillX();
        JButton btnExportXML = (JButton)l.add((Component)new JButton("Export XML"));
        btnExportXML.addActionListener(this.mExportXML);
        JButton btnClose = (JButton)l.add((Component)new JButton("Close"));
        l.pop();
        UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnClose, null);
        this.pack();
        UIUtil.center((Component)((Object)this));
        this.mTree.getSelectionModel().setSelectionMode(1);
        this.mTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                DescriptiveNode node = (DescriptiveNode)((Object)PinMapCheckResultUI.this.mTree.getLastSelectedPathComponent());
                if (node instanceof ViolationNode) {
                    PinMapCheckResultUI.this.mRight.setViewportView(((ViolationNode)node).getViolationPanel());
                }
            }
        });
    }

    protected class ViolationNode
    extends DescriptiveNode {
        protected PinMapCheck.Violation mViolation;

        public ViolationNode(ATreeNode parent, PinMapCheck.Violation v) {
            super(parent);
            this.mViolation = v;
        }

        public JPanel getViolationPanel() {
            return ViolationPanel.getViolationPanel(this.mViolation);
        }

        public boolean isLeaf() {
            return true;
        }

        public boolean getAllowsChildren() {
            return false;
        }

        public ArrayList<? extends ATreeNode> populateChildren() {
            return null;
        }

        public Icon getIcon() {
            return OrbitIcons.DRC_ERROR;
        }

        public String getText() {
            return this.mViolation.getText();
        }
    }

    protected class ViolationTypeNode
    extends DescriptiveNode {
        protected LinkedList<PinMapCheck.Violation> mViolations;

        public ViolationTypeNode(CheckNode parent, LinkedList<PinMapCheck.Violation> violations) {
            super((ATreeNode)parent);
            this.setSortChildren(false);
            this.mViolations = violations;
        }

        public ArrayList<? extends ATreeNode> populateChildren() {
            ArrayList<ViolationNode> list = new ArrayList<ViolationNode>();
            for (PinMapCheck.Violation v : this.mViolations) {
                list.add(new ViolationNode((ATreeNode)this, v));
            }
            return list;
        }

        public String getText() {
            return String.format("%s (%d)", this.mViolations.get(0).getText(), this.getChildCount());
        }
    }

    protected class CheckNode
    extends DescriptiveNode {
        protected PinMapCheck.Check mCheck;

        public CheckNode(RootNode parent, PinMapCheck.Check check) {
            super((ATreeNode)parent);
            this.mCheck = check;
        }

        public ArrayList<? extends ATreeNode> populateChildren() {
            if (this.mCheck instanceof ReferenceCsvCheck) {
                return this.populateExternalCsvCheckChildren();
            }
            ArrayList<ViolationNode> list = new ArrayList<ViolationNode>();
            for (PinMapCheck.Violation v : this.mCheck.getViolations()) {
                list.add(new ViolationNode((ATreeNode)this, v));
            }
            return list;
        }

        protected ArrayList<? extends ATreeNode> populateExternalCsvCheckChildren() {
            HashMap type2violation = new HashMap(10);
            HashMap type2typeNode = new HashMap(10);
            for (PinMapCheck.Violation v : this.mCheck.getViolations()) {
                Class<?> vType = v.getClass();
                LinkedList<PinMapCheck.Violation> list = (LinkedList<PinMapCheck.Violation>)type2violation.get(vType);
                ViolationTypeNode vTypeNode = (ViolationTypeNode)((Object)type2typeNode.get(vType));
                if (list == null) {
                    list = new LinkedList<PinMapCheck.Violation>();
                    vTypeNode = new ViolationTypeNode(this, list);
                    type2violation.put(vType, list);
                    type2typeNode.put(vType, vTypeNode);
                }
                list.add(v);
            }
            return AUtil.arrayList(type2typeNode.values());
        }

        public String getText() {
            return String.format("%s (%d)", this.mCheck.getName(), this.getChildCount());
        }

        public boolean isLeaf() {
            return this.getChildCount() == 0;
        }

        public Icon getIcon() {
            if (this.getChildCount() == 0) {
                return OrbitIcons.CHECK;
            }
            return OrbitIcons.EXCLAMATION;
        }
    }

    protected class RootNode
    extends ALazyTreeNode {
        public RootNode(ATreeModel model) {
            super(model);
            this.setSortChildren(false);
        }

        public ArrayList<? extends ATreeNode> populateChildren() {
            ArrayList<CheckNode> list = new ArrayList<CheckNode>();
            for (PinMapCheck.Check c : PinMapCheckResultUI.this.mChecks) {
                list.add(new CheckNode(this, c));
            }
            return list;
        }

        public String getText() {
            return "Checks and Violations";
        }
    }

    protected abstract class DescriptiveNode
    extends ALazyTreeNode {
        public DescriptiveNode(ATreeNode parent) {
            super(parent);
        }
    }
}

