/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.inter_substrate_checks.ui;

import com.sigrity.acl.ALog;
import com.sigrity.acl.app.ABuildInfo;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.ContactLayer;
import com.sigrity.acl.db.std.PinMap;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.PortTemplate;
import com.sigrity.acl.xml.AXmlUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.automation.pinMap.PinMapCsvReader;
import com.sigrity.orbit.inter_substrate_checks.NetMappingCheck;
import com.sigrity.orbit.inter_substrate_checks.NetPersonalityCheck;
import com.sigrity.orbit.inter_substrate_checks.PinCountMismatchCheck;
import com.sigrity.orbit.inter_substrate_checks.PinDirectionCheck;
import com.sigrity.orbit.inter_substrate_checks.PinMapCheck;
import com.sigrity.orbit.inter_substrate_checks.PinOffsetCheck;
import com.sigrity.orbit.inter_substrate_checks.PinUnmappedCheck;
import com.sigrity.orbit.inter_substrate_checks.PortContactCheck;
import com.sigrity.orbit.inter_substrate_checks.ReferenceCsvCheck;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class PinMapCheckResultXml {
    static final String LINE_SEPARATOR = System.lineSeparator();
    protected List<PinMapCheck.Check> mChecks;
    protected String mFilePath;
    protected XMLStreamWriter mXmlWriter;

    public PinMapCheckResultXml(List<PinMapCheck.Check> checks) {
        this.mChecks = checks;
    }

    public void exportXml(String filePath) {
        this.mFilePath = filePath;
        try (FileOutputStream fileOutputStream = new FileOutputStream(filePath);){
            this.mXmlWriter = AXmlUtil.createXmlStreamWriter((OutputStream)fileOutputStream);
            this.writeXml();
            ALog.logInfo((String)"Export xml complete.");
        }
        catch (Exception e) {
            ALog.logError((Throwable)e, (String)"There was an unexpected exception while writing %s.", (Object[])new Object[]{filePath});
        }
    }

    private void writeXml() throws XMLStreamException {
        this.mXmlWriter.writeStartDocument();
        this.writeComment();
        this.writeCheckResult();
        this.mXmlWriter.writeEndDocument();
        this.mXmlWriter.flush();
        this.mXmlWriter.close();
    }

    private void writeComment() throws XMLStreamException {
        this.writeComment(String.format(" %s version %s ", OrbitIO.getApp().getName(true), OrbitIO.getApp().getVersion()));
        this.writeComment(String.format(" Build: %s (%s) ", ABuildInfo.getVersion(), ABuildInfo.getTimestamp()));
        this.writeComment(String.format(" User: %s ", System.getProperty("user.name")));
        this.writeComment(String.format(" Time: %s ", new Date()));
        String file = OrbitIO.getCurDb().getCanonicalPath();
        this.writeComment(String.format(" Source design: %s ", file != null ? file : "<Unsaved Design>"));
        this.writeNewline();
    }

    private void writeCheckResult() throws XMLStreamException {
        this.mXmlWriter.writeStartElement("CheckingResult");
        for (PinMapCheck.Check check : this.mChecks) {
            if (check instanceof PinOffsetCheck) {
                this.writePinOffsetCheckResult(check);
            } else if (check instanceof PortContactCheck) {
                this.writePortContactCheckResult(check);
            } else if (check instanceof PinUnmappedCheck) {
                this.writePinUnmappedCheckResult(check);
            } else if (check instanceof PinCountMismatchCheck) {
                this.writePinCountMismatchCheckResult(check);
            } else if (check instanceof NetMappingCheck) {
                this.writeNetMappingCheckResult(check);
            } else if (check instanceof NetPersonalityCheck) {
                this.writeNetPersonalityCheckResult(check);
            } else if (check instanceof PinDirectionCheck) {
                this.writePinDirectionCheckResult(check);
            } else if (check instanceof ReferenceCsvCheck) {
                this.writeReferenceCsvCheckResult(check);
            }
            this.writeNewline();
        }
        this.mXmlWriter.writeEndElement();
    }

    private void writePinOffsetCheckResult(PinMapCheck.Check check) throws XMLStreamException {
        this.mXmlWriter.writeStartElement(this.getCheckElementName(check));
        this.writeViolationCountAtrribute(check.getViolationCount());
        this.writePinOffsetViolations(check);
        this.mXmlWriter.writeEndElement();
    }

    private void writePinOffsetViolations(PinMapCheck.Check check) throws XMLStreamException {
        for (PinMapCheck.Violation v : check.getViolations()) {
            PinOffsetCheck.PinOffsetViolation violation = (PinOffsetCheck.PinOffsetViolation)v;
            this.mXmlWriter.writeStartElement("Violation");
            this.mXmlWriter.writeAttribute("MaxOffset", Double.toString(violation.getMaxOffset()));
            this.mXmlWriter.writeAttribute("CurOffset", Double.toString(violation.getCurOffset()));
            this.writeHierPort(violation.getHierPortA());
            this.writeHierPort(violation.getHierPortB());
            this.mXmlWriter.writeEndElement();
        }
    }

    private void writePortContactCheckResult(PinMapCheck.Check check) throws XMLStreamException {
        this.mXmlWriter.writeStartElement(this.getCheckElementName(check));
        this.writeViolationCountAtrribute(check.getViolationCount());
        this.writePortContactViolations(check);
        this.mXmlWriter.writeEndElement();
    }

    private void writePortContactViolations(PinMapCheck.Check check) throws XMLStreamException {
        for (PinMapCheck.Violation v : check.getViolations()) {
            PortContactCheck.PortContactViolation violation = (PortContactCheck.PortContactViolation)v;
            this.mXmlWriter.writeStartElement("Violation");
            this.writeHierPort(violation.getHierPort());
            this.writeContactLayer(violation.getContactLayer());
            this.mXmlWriter.writeEndElement();
        }
    }

    private void writePinUnmappedCheckResult(PinMapCheck.Check check) throws XMLStreamException {
        this.mXmlWriter.writeStartElement(this.getCheckElementName(check));
        this.writeViolationCountAtrribute(check.getViolationCount());
        this.writePinUnmappedViolations(check);
        this.mXmlWriter.writeEndElement();
    }

    private void writePinUnmappedViolations(PinMapCheck.Check check) throws XMLStreamException {
        for (PinMapCheck.Violation v : check.getViolations()) {
            PinUnmappedCheck.PinUnmappedViolation violation = (PinUnmappedCheck.PinUnmappedViolation)v;
            this.mXmlWriter.writeStartElement("Violation");
            this.writeHierPin((HierInst<PinTemplate>)HierInst.create((DevicePath)violation.getPinPath(), (DbObject)violation.getPin()));
            this.writeContactLayer(violation.getContactLayer());
            this.mXmlWriter.writeEndElement();
        }
    }

    private void writePinCountMismatchCheckResult(PinMapCheck.Check check) throws XMLStreamException {
        this.mXmlWriter.writeStartElement(this.getCheckElementName(check));
        this.writeViolationCountAtrribute(check.getViolationCount());
        this.writePinCountMismatchViolations(check);
        this.mXmlWriter.writeEndElement();
    }

    private void writePinCountMismatchViolations(PinMapCheck.Check check) throws XMLStreamException {
        for (PinMapCheck.Violation v : check.getViolations()) {
            PinCountMismatchCheck.PinCountMismatchViolation violation = (PinCountMismatchCheck.PinCountMismatchViolation)v;
            this.mXmlWriter.writeStartElement("Violation");
            this.writeHierPin((HierInst<PinTemplate>)HierInst.create((DevicePath)violation.getPinPath(), (DbObject)violation.getPin()));
            for (PinMap pinMap : violation.getPinMaps()) {
                this.writePinMapInfo(pinMap);
            }
            this.mXmlWriter.writeEndElement();
        }
    }

    private void writeNetMappingCheckResult(PinMapCheck.Check check) throws XMLStreamException {
        this.mXmlWriter.writeStartElement(this.getCheckElementName(check));
        this.writeViolationCountAtrribute(check.getViolationCount());
        this.writeNetMappingViolations(check);
        this.mXmlWriter.writeEndElement();
    }

    private void writeNetMappingViolations(PinMapCheck.Check check) throws XMLStreamException {
        for (PinMapCheck.Violation v : check.getViolations()) {
            NetMappingCheck.NetMappingViolation violation = (NetMappingCheck.NetMappingViolation)v;
            this.mXmlWriter.writeStartElement("Violation");
            this.writePinMapInfo(violation.getPinMap());
            this.mXmlWriter.writeEndElement();
        }
    }

    private void writeNetPersonalityCheckResult(PinMapCheck.Check check) throws XMLStreamException {
        this.mXmlWriter.writeStartElement(this.getCheckElementName(check));
        this.writeViolationCountAtrribute(check.getViolationCount());
        this.writeNetPersonalityViolations(check);
        this.mXmlWriter.writeEndElement();
    }

    private void writeNetPersonalityViolations(PinMapCheck.Check check) throws XMLStreamException {
        for (PinMapCheck.Violation v : check.getViolations()) {
            NetPersonalityCheck.NetPersonalityViolation violation = (NetPersonalityCheck.NetPersonalityViolation)v;
            this.mXmlWriter.writeStartElement("Violation");
            this.mXmlWriter.writeAttribute("type", v.getText());
            this.writePinMapInfo(violation.getPinMap());
            this.mXmlWriter.writeEndElement();
        }
    }

    private void writePinDirectionCheckResult(PinMapCheck.Check check) throws XMLStreamException {
        this.mXmlWriter.writeStartElement(this.getCheckElementName(check));
        this.writeViolationCountAtrribute(check.getViolationCount());
        this.writePinDirectionViolations(check);
        this.mXmlWriter.writeEndElement();
    }

    private void writePinDirectionViolations(PinMapCheck.Check check) throws XMLStreamException {
        for (PinMapCheck.Violation v : check.getViolations()) {
            PinDirectionCheck.PinDirectionViolation violation = (PinDirectionCheck.PinDirectionViolation)v;
            this.mXmlWriter.writeStartElement("Violation");
            this.writePinMapInfo(violation.getPinMap());
            this.mXmlWriter.writeEndElement();
        }
    }

    private void writeReferenceCsvCheckResult(PinMapCheck.Check check) throws XMLStreamException {
        this.mXmlWriter.writeStartElement(this.getCheckElementName(check));
        this.writeViolationCountAtrribute(check.getViolationCount());
        this.writeReferenceCsvViolations(check);
        this.mXmlWriter.writeEndElement();
    }

    private void writeReferenceCsvViolations(PinMapCheck.Check check) throws XMLStreamException {
        for (PinMapCheck.Violation v : check.getViolations()) {
            this.mXmlWriter.writeStartElement("Violation");
            this.mXmlWriter.writeAttribute("Name", v.getText());
            this.writeReferenceCsvViolation(v);
            this.mXmlWriter.writeEndElement();
        }
    }

    protected void writeReferenceCsvViolation(PinMapCheck.Violation v) throws XMLStreamException {
        if (v instanceof ReferenceCsvCheck.CsvInputViolation) {
            this.writeCsvInputViolation((ReferenceCsvCheck.CsvInputViolation)v);
        } else if (v instanceof ReferenceCsvCheck.CsvFloatingPinViolation) {
            this.writeCsvFloatingPinViolation((ReferenceCsvCheck.CsvFloatingPinViolation)v);
        } else if (v instanceof ReferenceCsvCheck.CsvPinCountMismatchViolation) {
            this.writeCsvPinCountMismatchViolation((ReferenceCsvCheck.CsvPinCountMismatchViolation)v);
        } else if (v instanceof ReferenceCsvCheck.CsvPinLayerViolation) {
            this.writeCsvPinLayerViolation((ReferenceCsvCheck.CsvPinLayerViolation)v);
        } else if (v instanceof ReferenceCsvCheck.CsvRemovedViolation) {
            this.writeCsvRemovedViolation((ReferenceCsvCheck.CsvRemovedViolation)v);
        } else if (v instanceof ReferenceCsvCheck.CsvAddedViolation) {
            this.writeCsvAddedViolation((ReferenceCsvCheck.CsvAddedViolation)v);
        }
    }

    private void writeCsvInputViolation(ReferenceCsvCheck.CsvInputViolation v) throws XMLStreamException {
        this.writeCsvPinMapInfo(v.getPinMap());
    }

    private void writeCsvFloatingPinViolation(ReferenceCsvCheck.CsvFloatingPinViolation v) throws XMLStreamException {
        this.writeHierPin(v.getHierPin());
        this.writeContactLayer(v.getContactLayer());
    }

    private void writeCsvPinCountMismatchViolation(ReferenceCsvCheck.CsvPinCountMismatchViolation v) throws XMLStreamException {
        this.writeHierPin(v.getHierPin());
    }

    private void writeCsvPinLayerViolation(ReferenceCsvCheck.CsvPinLayerViolation v) throws XMLStreamException {
        this.writeRefPinMapInfo(v.getPinMap());
    }

    private void writeCsvRemovedViolation(ReferenceCsvCheck.CsvRemovedViolation v) throws XMLStreamException {
        this.writePinMapInfo(v.getPinMap());
    }

    private void writeCsvAddedViolation(ReferenceCsvCheck.CsvAddedViolation v) throws XMLStreamException {
        this.writeRefPinMapInfo(v.getPinMap());
    }

    private void writeRefPinMapInfo(ReferenceCsvCheck.ReferencePinMap pm) throws XMLStreamException {
        this.mXmlWriter.writeStartElement("CsvPinMap");
        this.writeHierPin(pm.getHierPinA());
        this.writeHierPin(pm.getHierPinB());
        this.mXmlWriter.writeEndElement();
    }

    private void writeCsvPinMapInfo(PinMapCsvReader.CsvPinMap csvPinMap) throws XMLStreamException {
        this.mXmlWriter.writeStartElement("CsvPinMap");
        this.writeHierPin(csvPinMap.getPinPathA(), csvPinMap.getPinA());
        this.writeHierPin(csvPinMap.getPinPathA(), csvPinMap.getPinB());
        this.mXmlWriter.writeEndElement();
    }

    private void writePinMapInfo(PinMap pinMap) throws XMLStreamException {
        this.mXmlWriter.writeStartElement("PinMap");
        this.mXmlWriter.writeAttribute("Owner", pinMap.getOwner().getName());
        this.writeHierPin((HierInst<PinTemplate>)pinMap.getHierPinA());
        this.writeHierPin((HierInst<PinTemplate>)pinMap.getHierPinB());
        this.mXmlWriter.writeEndElement();
    }

    private void writeHierPin(HierInst<PinTemplate> hierPin) throws XMLStreamException {
        this.mXmlWriter.writeEmptyElement("Pin");
        this.mXmlWriter.writeAttribute("Name", ((PinTemplate)hierPin.getSecond()).getName());
        this.mXmlWriter.writeAttribute("DevicePath", hierPin.getPath().getString());
        this.mXmlWriter.writeAttribute("Direction", ((PinTemplate)hierPin.getSecond()).getDirection().toString());
    }

    private void writeHierPin(String devPathStr, String pinName) throws XMLStreamException {
        this.mXmlWriter.writeEmptyElement("Pin");
        this.mXmlWriter.writeAttribute("DevicePath", devPathStr);
        this.mXmlWriter.writeAttribute("Port", pinName);
    }

    private void writeHierPort(HierInst<PortTemplate> hierPort) throws XMLStreamException {
        this.mXmlWriter.writeEmptyElement("Port");
        this.mXmlWriter.writeAttribute("PinName", ((PortTemplate)hierPort.getSecond()).getPinTemplate().getName());
        this.mXmlWriter.writeAttribute("PortNum", Integer.toString(((PortTemplate)hierPort.getSecond()).getPortNum()));
        this.mXmlWriter.writeAttribute("DevicePath", hierPort.getPath().getString());
    }

    private void writeContactLayer(ContactLayer contactLayer) throws XMLStreamException {
        this.mXmlWriter.writeEmptyElement("ContactLayer");
        this.mXmlWriter.writeAttribute("Owner", contactLayer.getOwner().getName());
        this.mXmlWriter.writeAttribute("DevicePathA", contactLayer.getDevicePathA().getString());
        this.mXmlWriter.writeAttribute("LayerA", contactLayer.getContactLayerA().getName());
        this.mXmlWriter.writeAttribute("DevicePathB", contactLayer.getDevicePathB().getString());
        this.mXmlWriter.writeAttribute("LayerB", contactLayer.getContactLayerB().getName());
    }

    protected void writeComment(String comment) throws XMLStreamException {
        this.mXmlWriter.writeComment(comment);
        this.writeNewline();
    }

    protected void writeNewline() throws XMLStreamException {
        this.mXmlWriter.writeCharacters(LINE_SEPARATOR);
    }

    private void writeViolationCountAtrribute(int count) throws XMLStreamException {
        this.mXmlWriter.writeAttribute("Count", Integer.toString(count));
    }

    private String getCheckElementName(PinMapCheck.Check check) {
        return check.getName().replaceAll("\\s", "");
    }
}

