/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.inter_substrate_checks.ui;

import com.sigrity.acl.db.std.ContactLayer;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.PinMap;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.PortTemplate;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.automation.pinMap.PinMapCsvReader;
import com.sigrity.orbit.inter_substrate_checks.DesignNetNameCheck;
import com.sigrity.orbit.inter_substrate_checks.LocalNetNameCheck;
import com.sigrity.orbit.inter_substrate_checks.NetMappingCheck;
import com.sigrity.orbit.inter_substrate_checks.NetPersonalityCheck;
import com.sigrity.orbit.inter_substrate_checks.PinCountMismatchCheck;
import com.sigrity.orbit.inter_substrate_checks.PinDirectionCheck;
import com.sigrity.orbit.inter_substrate_checks.PinMapCheck;
import com.sigrity.orbit.inter_substrate_checks.PinNameCheck;
import com.sigrity.orbit.inter_substrate_checks.PinOffsetCheck;
import com.sigrity.orbit.inter_substrate_checks.PinUnmappedCheck;
import com.sigrity.orbit.inter_substrate_checks.PortContactCheck;
import com.sigrity.orbit.inter_substrate_checks.ReferenceCsvCheck;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public class PinMapPortMapInfo {
    public static Info create(PinMapCheck.Violation v) {
        if (v instanceof PortContactCheck.PortContactViolation) {
            return PinMapPortMapInfo.create((PortContactCheck.PortContactViolation)v);
        }
        if (v instanceof PinUnmappedCheck.PinUnmappedViolation) {
            return PinMapPortMapInfo.create((PinUnmappedCheck.PinUnmappedViolation)v);
        }
        if (v instanceof PinOffsetCheck.PinOffsetViolation) {
            return PinMapPortMapInfo.create((PinOffsetCheck.PinOffsetViolation)v);
        }
        if (v instanceof PinCountMismatchCheck.PinCountMismatchViolation) {
            return PinMapPortMapInfo.create((PinCountMismatchCheck.PinCountMismatchViolation)v);
        }
        if (v instanceof PinDirectionCheck.PinDirectionViolation) {
            return PinMapPortMapInfo.create((PinDirectionCheck.PinDirectionViolation)v);
        }
        if (v instanceof PinNameCheck.PinNameViolation) {
            return PinMapPortMapInfo.create((PinNameCheck.PinNameViolation)v);
        }
        if (v instanceof DesignNetNameCheck.DesignNetNameViolation) {
            return PinMapPortMapInfo.create((DesignNetNameCheck.DesignNetNameViolation)v);
        }
        if (v instanceof LocalNetNameCheck.LocalNetNameViolation) {
            return PinMapPortMapInfo.create((LocalNetNameCheck.LocalNetNameViolation)v);
        }
        if (v instanceof NetMappingCheck.NetMappingViolation) {
            return PinMapPortMapInfo.create((NetMappingCheck.NetMappingViolation)v);
        }
        if (v instanceof NetPersonalityCheck.NetPersonalityViolation) {
            return PinMapPortMapInfo.create((NetPersonalityCheck.NetPersonalityViolation)v);
        }
        if (v instanceof ReferenceCsvCheck.CsvPinCountMismatchViolation) {
            return PinMapPortMapInfo.create((ReferenceCsvCheck.CsvPinCountMismatchViolation)v);
        }
        if (v instanceof ReferenceCsvCheck.CsvInputViolation) {
            return PinMapPortMapInfo.create((ReferenceCsvCheck.CsvInputViolation)v);
        }
        if (v instanceof ReferenceCsvCheck.CsvAddedViolation) {
            return PinMapPortMapInfo.create((ReferenceCsvCheck.CsvAddedViolation)v);
        }
        if (v instanceof ReferenceCsvCheck.CsvFloatingPinViolation) {
            return PinMapPortMapInfo.create((ReferenceCsvCheck.CsvFloatingPinViolation)v);
        }
        if (v instanceof ReferenceCsvCheck.CsvPinLayerViolation) {
            return PinMapPortMapInfo.create((ReferenceCsvCheck.CsvPinLayerViolation)v);
        }
        if (v instanceof ReferenceCsvCheck.CsvRemovedViolation) {
            return PinMapPortMapInfo.create((ReferenceCsvCheck.CsvRemovedViolation)v);
        }
        if (v instanceof ReferenceCsvCheck.CsvPinNetViolation) {
            return PinMapPortMapInfo.create((ReferenceCsvCheck.CsvPinNetViolation)v);
        }
        assert (false);
        return null;
    }

    public static Info create(PinMapCheck.CheckResult r) {
        if (r instanceof PortContactCheck.PortContactResult) {
            return PinMapPortMapInfo.create((PortContactCheck.PortContactResult)r);
        }
        if (r instanceof PinUnmappedCheck.PinUnmappedResult) {
            return PinMapPortMapInfo.create((PinUnmappedCheck.PinUnmappedResult)r);
        }
        if (r instanceof PinOffsetCheck.PinOffsetResult) {
            return PinMapPortMapInfo.create((PinOffsetCheck.PinOffsetResult)r);
        }
        if (r instanceof PinCountMismatchCheck.PinCountMismatchResult) {
            return PinMapPortMapInfo.create((PinCountMismatchCheck.PinCountMismatchResult)r);
        }
        if (r instanceof PinDirectionCheck.PinDirectionResult) {
            return PinMapPortMapInfo.create((PinDirectionCheck.PinDirectionResult)r);
        }
        if (r instanceof PinNameCheck.PinNameResult) {
            return PinMapPortMapInfo.create((PinNameCheck.PinNameResult)r);
        }
        if (r instanceof DesignNetNameCheck.DesignNetNameResult) {
            return PinMapPortMapInfo.create((DesignNetNameCheck.DesignNetNameResult)r);
        }
        if (r instanceof LocalNetNameCheck.LocalNetNameResult) {
            return PinMapPortMapInfo.create((LocalNetNameCheck.LocalNetNameResult)r);
        }
        if (r instanceof NetMappingCheck.NetMappingResult) {
            return PinMapPortMapInfo.create((NetMappingCheck.NetMappingResult)r);
        }
        if (r instanceof NetPersonalityCheck.NetPersonalityResult) {
            return PinMapPortMapInfo.create((NetPersonalityCheck.NetPersonalityResult)r);
        }
        if (r instanceof ReferenceCsvCheck.CsvPinCountMismatchResult) {
            return PinMapPortMapInfo.create((ReferenceCsvCheck.CsvPinCountMismatchResult)r);
        }
        if (r instanceof ReferenceCsvCheck.CsvInputResult) {
            return PinMapPortMapInfo.create((ReferenceCsvCheck.CsvInputResult)r);
        }
        if (r instanceof ReferenceCsvCheck.CsvAddedResult) {
            return PinMapPortMapInfo.create((ReferenceCsvCheck.CsvAddedResult)r);
        }
        if (r instanceof ReferenceCsvCheck.CsvFloatingPinResult) {
            return PinMapPortMapInfo.create((ReferenceCsvCheck.CsvFloatingPinResult)r);
        }
        if (r instanceof ReferenceCsvCheck.CsvPinLayerResult) {
            return PinMapPortMapInfo.create((ReferenceCsvCheck.CsvPinLayerResult)r);
        }
        if (r instanceof ReferenceCsvCheck.CsvRemovedResult) {
            return PinMapPortMapInfo.create((ReferenceCsvCheck.CsvRemovedResult)r);
        }
        if (r instanceof ReferenceCsvCheck.CsvPinNetResult) {
            return PinMapPortMapInfo.create((ReferenceCsvCheck.CsvPinNetResult)r);
        }
        assert (false);
        return null;
    }

    private static Info create(PortContactCheck.PortContactResult r) {
        return new PortContactResultInfo(r);
    }

    private static Info create(PortContactCheck.PortContactViolation v) {
        return new PortContactViolationInfo(v);
    }

    private static Info create(PinUnmappedCheck.PinUnmappedResult r) {
        return new PinUnmappedResultInfo(r);
    }

    private static Info create(PinUnmappedCheck.PinUnmappedViolation v) {
        return new PinUnmappedViolationInfo(v);
    }

    private static Info create(PinOffsetCheck.PinOffsetResult r) {
        return new PinOffsetResultInfo(r);
    }

    private static Info create(PinOffsetCheck.PinOffsetViolation v) {
        return new PinOffsetViolationInfo(v);
    }

    private static Info create(PinCountMismatchCheck.PinCountMismatchResult r) {
        return new PinCountMismatchResultInfo(r);
    }

    private static Info create(PinCountMismatchCheck.PinCountMismatchViolation v) {
        return new PinCountMismatchViolationInfo(v);
    }

    private static Info create(PinDirectionCheck.PinDirectionResult r) {
        return new PinDirectionResultInfo(r);
    }

    private static Info create(PinDirectionCheck.PinDirectionViolation v) {
        return new PinDirectionViolationInfo(v);
    }

    private static Info create(PinNameCheck.PinNameResult r) {
        return PinMapPortMapInfo.create(r.getPinMap());
    }

    private static Info create(PinNameCheck.PinNameViolation v) {
        return PinMapPortMapInfo.create(v.getPinMap());
    }

    private static Info create(DesignNetNameCheck.DesignNetNameResult r) {
        return PinMapPortMapInfo.create(r.getPinMap());
    }

    private static Info create(DesignNetNameCheck.DesignNetNameViolation v) {
        return PinMapPortMapInfo.create(v.getPinMap());
    }

    private static Info create(LocalNetNameCheck.LocalNetNameResult r) {
        return PinMapPortMapInfo.create(r.getPinMap());
    }

    private static Info create(LocalNetNameCheck.LocalNetNameViolation v) {
        return PinMapPortMapInfo.create(v.getPinMap());
    }

    private static Info create(NetMappingCheck.NetMappingResult r) {
        return new NetMapResultInfo(r);
    }

    private static Info create(NetMappingCheck.NetMappingViolation v) {
        return new NetMapViolationInfo(v);
    }

    private static Info create(NetPersonalityCheck.NetPersonalityResult r) {
        return new NetPersonalityResultInfo(r);
    }

    private static Info create(NetPersonalityCheck.NetPersonalityViolation v) {
        return new NetPersonalityViolationInfo(v);
    }

    private static Info create(ReferenceCsvCheck.CsvInputResult r) {
        return new CsvInputResultInfo(r);
    }

    private static Info create(ReferenceCsvCheck.CsvInputViolation v) {
        return new CsvInputViolationInfo(v);
    }

    private static Info create(ReferenceCsvCheck.CsvAddedResult r) {
        return new CsvAddedResultInfo(r);
    }

    private static Info create(ReferenceCsvCheck.CsvAddedViolation v) {
        return new CsvAddedViolationInfo(v);
    }

    private static Info create(ReferenceCsvCheck.CsvFloatingPinResult r) {
        return new CsvFloatingPinResultInfo(r);
    }

    private static Info create(ReferenceCsvCheck.CsvFloatingPinViolation v) {
        return new CsvFloatingPinViolationInfo(v);
    }

    private static Info create(ReferenceCsvCheck.CsvPinLayerResult r) {
        return new CsvPinLayerResultInfo(r);
    }

    private static Info create(ReferenceCsvCheck.CsvPinLayerViolation v) {
        return new CsvPinLayerViolationInfo(v);
    }

    private static Info create(ReferenceCsvCheck.CsvPinNetResult r) {
        return new CsvPinNetResultInfo(r);
    }

    private static Info create(ReferenceCsvCheck.CsvPinNetViolation v) {
        return new CsvPinNetViolationInfo(v);
    }

    private static Info create(ReferenceCsvCheck.CsvRemovedResult r) {
        return new CsvRemovedResultInfo(r);
    }

    private static Info create(ReferenceCsvCheck.CsvRemovedViolation v) {
        return new CsvRemovedViolationInfo(v);
    }

    private static Info create(ReferenceCsvCheck.CsvPinCountMismatchResult r) {
        return new CsvPinCountMismatchResultInfo(r);
    }

    private static Info create(ReferenceCsvCheck.CsvPinCountMismatchViolation v) {
        return new CsvPinCountMismatchViolationInfo(v);
    }

    protected static Info create(PinMap pinMap) {
        return new PinMapInfo(pinMap);
    }

    protected static Info create(ReferenceCsvCheck.ReferencePinMap refPinMap) {
        return new RefPinMapInfo(refPinMap);
    }

    private PinMapPortMapInfo() {
    }

    private static Net getNetAtContactDev(DeviceTemplate contactDevT, DevicePath pinPath, Net bottomNet) {
        return NetMap.getNetAt((Net)bottomNet, (DevicePath)pinPath, (DeviceTemplate)contactDevT, null);
    }

    private static String getFullPathsString(DevicePath devPath) {
        if (devPath == null) {
            return null;
        }
        return devPath.getAllFullPaths().mapAndNonNull(DevicePath::toString).reduce((pathStr1, pathStr2) -> String.format("%s%n%s", pathStr1, pathStr2)).orElse(null);
    }

    protected static class RootInfo
    implements Info,
    TypeInfo {
        protected RootInfo() {
        }

        @Override
        public String getTypeStr() {
            return null;
        }
    }

    protected static class RefCsvViolationTypeInfo
    implements TypeInfo {
        static final PinMapCheck.CheckType mCheckType = PinMapCheck.CheckType.REFERENCE_COMPARE;
        ReferenceCsvCheck.ViolationType mViolationType;
        List<ReferenceCsvCheck.CsvResult> mValidations;
        List<ReferenceCsvCheck.CsvResult> mViolations;

        public RefCsvViolationTypeInfo(ReferenceCsvCheck.ViolationType violationType) {
            this.mViolationType = violationType;
        }

        public PinMapCheck.CheckType getCheckType() {
            return mCheckType;
        }

        public void addValidations(List<ReferenceCsvCheck.CsvResult> validations) {
            if (this.mValidations == null) {
                this.mValidations = new LinkedList<ReferenceCsvCheck.CsvResult>();
            }
            this.mValidations.addAll(validations);
        }

        public void addViolations(List<ReferenceCsvCheck.CsvResult> violations) {
            if (this.mViolations == null) {
                this.mViolations = new LinkedList<ReferenceCsvCheck.CsvResult>();
            }
            this.mViolations.addAll(violations);
        }

        public boolean hasViolation() {
            return this.mViolations != null && !this.mViolations.isEmpty();
        }

        @Override
        public String getTypeStr() {
            return this.mViolationType.getName();
        }
    }

    protected static class NetPersonalityViolationTypeInfo
    extends ViolatedResultTypeInfo {
        public NetPersonalityViolationTypeInfo(Class<? extends PinMapCheck.Violation> resultClass) {
            super(PinMapCheck.CheckType.NET_PERSONALITY, resultClass);
        }

        public void addNetPersonalityViolations(List<NetPersonalityCheck.NetPersonalityViolation> violations) {
            this.addViolations(violations.stream().map(v -> v).collect(Collectors.toList()));
        }

        @Override
        public String getTypeStr() {
            return ((PinMapCheck.Violation)this.mResults.get(0)).getText() + " (" + this.mResults.size() + ")";
        }
    }

    protected static class ViolatedResultTypeInfo
    implements TypeInfo {
        PinMapCheck.CheckType mCheckType;
        Class<? extends PinMapCheck.Violation> mResultClass;
        List<PinMapCheck.Violation> mResults;

        public ViolatedResultTypeInfo(PinMapCheck.CheckType checkType, Class<? extends PinMapCheck.Violation> resultClass) {
            this.mCheckType = checkType;
            this.mResultClass = resultClass;
        }

        public void addViolations(List<PinMapCheck.Violation> violations) {
            if (this.mResults == null) {
                this.mResults = new LinkedList<PinMapCheck.Violation>();
            }
            this.mResults.addAll(violations);
        }

        public List<PinMapCheck.Violation> getViolatedResults() {
            return this.mResults;
        }

        public PinMapCheck.CheckType getCheckType() {
            return this.mCheckType;
        }

        public Class<? extends PinMapCheck.Violation> getViolatedResultClass() {
            return this.mResultClass;
        }

        @Override
        public String getTypeStr() {
            return "Violation (" + this.mResults.size() + ")";
        }
    }

    protected static class ValidatedResultTypeInfo
    implements TypeInfo {
        PinMapCheck.CheckType mCheckType;
        Class<? extends PinMapCheck.CheckResult> mResultClass;
        List<PinMapCheck.CheckResult> mResults;

        public ValidatedResultTypeInfo(PinMapCheck.CheckType checkType, Class<? extends PinMapCheck.CheckResult> resultClass) {
            this.mCheckType = checkType;
            this.mResultClass = resultClass;
        }

        public void addValidations(List<PinMapCheck.CheckResult> validations) {
            if (this.mResults == null) {
                this.mResults = new LinkedList<PinMapCheck.CheckResult>();
            }
            this.mResults.addAll(validations);
        }

        public List<PinMapCheck.CheckResult> getValidatedResults() {
            return this.mResults;
        }

        public PinMapCheck.CheckType getCheckType() {
            return this.mCheckType;
        }

        public Class<? extends PinMapCheck.CheckResult> getValidatedResultClass() {
            return this.mResultClass;
        }

        @Override
        public String getTypeStr() {
            return "Validation (" + this.mResults.size() + ")";
        }
    }

    protected static class CheckTypeInfo
    implements TypeInfo {
        PinMapCheck.CheckType mCheckType;
        List<PinMapCheck.Check> mChecks;

        public CheckTypeInfo(PinMapCheck.CheckType checkType) {
            this.mCheckType = checkType;
        }

        public void addCheck(PinMapCheck.Check check) {
            if (this.mCheckType != check.getType()) {
                return;
            }
            if (this.mChecks == null) {
                this.mChecks = new LinkedList<PinMapCheck.Check>();
            }
            this.mChecks.add(check);
        }

        public PinMapCheck.CheckType getCheckType() {
            return this.mCheckType;
        }

        public List<PinMapCheck.Check> getChecks() {
            return this.mChecks;
        }

        public boolean hasValidation() {
            for (PinMapCheck.Check check : this.mChecks) {
                if (check.getValidationCount() == 0) continue;
                return true;
            }
            return false;
        }

        public boolean hasViolation() {
            for (PinMapCheck.Check check : this.mChecks) {
                if (check.getViolationCount() == 0) continue;
                return true;
            }
            return false;
        }

        @Override
        public String getTypeStr() {
            return this.mCheckType.getName();
        }
    }

    protected static interface TypeInfo {
        public String getTypeStr();
    }

    protected static class CsvPinMapInfo
    implements Info {
        private final PinMapCsvReader.CsvPinMap mCsvPinMap;

        private CsvPinMapInfo(PinMapCsvReader.CsvPinMap csvPinMap) {
            this.mCsvPinMap = csvPinMap;
        }

        @Override
        public String getDevPathAStr() {
            return PinMapPortMapInfo.getFullPathsString(this.mCsvPinMap.getContactDevPathA());
        }

        @Override
        public String getLayerAName() {
            return this.mCsvPinMap.getLayerA().getName();
        }

        @Override
        public String getPinPathAStr() {
            return this.mCsvPinMap.getPinPathA();
        }

        @Override
        public String getPinAName() {
            return this.mCsvPinMap.getPinA();
        }

        @Override
        public String getNetAName() {
            return this.mCsvPinMap.getNetA();
        }

        @Override
        public String getDevPathBStr() {
            return PinMapPortMapInfo.getFullPathsString(this.mCsvPinMap.getContactDevPathB());
        }

        @Override
        public String getLayerBName() {
            return this.mCsvPinMap.getLayerB().getName();
        }

        @Override
        public String getPinPathBStr() {
            return this.mCsvPinMap.getPinPathB();
        }

        @Override
        public String getPinBName() {
            return this.mCsvPinMap.getPinB();
        }

        @Override
        public String getNetBName() {
            return this.mCsvPinMap.getNetB();
        }
    }

    protected static class CsvFloatingPinViolationInfo
    extends CsvFloatingPinResultInfo
    implements ViolationInfo {
        public CsvFloatingPinViolationInfo(ReferenceCsvCheck.CsvFloatingPinViolation violation) {
            super(violation);
        }

        @Override
        public PinMapCheck.Violation getViolation() {
            return (ReferenceCsvCheck.CsvFloatingPinViolation)this.mResult;
        }
    }

    protected static class CsvFloatingPinResultInfo
    implements PinsInfo {
        protected ReferenceCsvCheck.CsvFloatingPinResult mResult;

        public CsvFloatingPinResultInfo(ReferenceCsvCheck.CsvFloatingPinResult result) {
            this.mResult = result;
        }

        @Override
        public DevicePath getPinPathAFromOwner() {
            return this.mResult.getPinPathA();
        }

        @Override
        public PinTemplate getPinA() {
            return this.mResult.getPinA();
        }

        @Override
        public DevicePath getPinPathBFromOwner() {
            return this.mResult.getPinPathB();
        }

        @Override
        public PinTemplate getPinB() {
            return this.mResult.getPinB();
        }

        @Override
        public String getDevPathAStr() {
            return PinMapPortMapInfo.getFullPathsString(this.mResult.getDevPathA());
        }

        @Override
        public String getLayerAName() {
            return this.mResult.getLayerA().getName();
        }

        @Override
        public String getPinPathAStr() {
            DevicePath pinPath = this.mResult.getPinPathAFromContactDev();
            return pinPath == null ? null : pinPath.toString();
        }

        @Override
        public String getPinAName() {
            PinTemplate pin = this.getPinA();
            return pin == null ? null : pin.getName();
        }

        @Override
        public String getNetAName() {
            if (this.getPinA() == null) {
                return null;
            }
            DeviceTemplate contactDevT = this.mResult.getDevPathA().getDeviceTemplate();
            Net bottomNet = this.getPinA().getNet();
            DevicePath pinPath = this.mResult.getPinPathAFromContactDev();
            Net net = PinMapPortMapInfo.getNetAtContactDev(contactDevT, pinPath, bottomNet);
            return net == null ? null : net.getName();
        }

        @Override
        public String getDevPathBStr() {
            return PinMapPortMapInfo.getFullPathsString(this.mResult.getDevPathB());
        }

        @Override
        public String getLayerBName() {
            return this.mResult.getLayerB().getName();
        }

        @Override
        public String getPinPathBStr() {
            DevicePath pinPath = this.mResult.getPinPathBFromContactDev();
            return pinPath == null ? null : pinPath.toString();
        }

        @Override
        public String getPinBName() {
            PinTemplate pin = this.getPinB();
            return pin == null ? null : pin.getName();
        }

        @Override
        public String getNetBName() {
            if (this.getPinB() == null) {
                return null;
            }
            DeviceTemplate contactDevT = this.mResult.getDevPathB().getDeviceTemplate();
            Net bottomNet = this.getPinB().getNet();
            DevicePath pinPath = this.mResult.getPinPathBFromContactDev();
            Net net = PinMapPortMapInfo.getNetAtContactDev(contactDevT, pinPath, bottomNet);
            return net == null ? null : net.getName();
        }

        @Override
        public Layer getLayerA() {
            return this.mResult.getLayerA();
        }

        @Override
        public Layer getLayerB() {
            return this.mResult.getLayerB();
        }

        @Override
        public PinMapCheck.CheckResult getResult() {
            return this.mResult;
        }
    }

    protected static class CsvPinCountMismatchViolationInfo
    extends CsvPinCountMismatchResultInfo
    implements ViolationInfo {
        public CsvPinCountMismatchViolationInfo(ReferenceCsvCheck.CsvPinCountMismatchViolation violation) {
            super(violation);
        }

        @Override
        public PinMapCheck.Violation getViolation() {
            return (ReferenceCsvCheck.CsvPinCountMismatchViolation)this.mResult;
        }
    }

    protected static class CsvPinCountMismatchResultInfo
    implements PinsInfo {
        protected ReferenceCsvCheck.CsvPinCountMismatchResult mResult;

        public CsvPinCountMismatchResultInfo(ReferenceCsvCheck.CsvPinCountMismatchResult result) {
            this.mResult = result;
        }

        @Override
        public DevicePath getPinPathAFromOwner() {
            return this.mResult.getPinPath();
        }

        @Override
        public PinTemplate getPinA() {
            return this.mResult.getPin();
        }

        @Override
        public String getDevPathAStr() {
            return PinMapPortMapInfo.getFullPathsString(this.mResult.getDevPath());
        }

        @Override
        public String getLayerAName() {
            return this.mResult.getLayer().getName();
        }

        @Override
        public String getPinPathAStr() {
            return this.mResult.getPinPathFromContactDev().toString();
        }

        @Override
        public String getPinAName() {
            return this.getPinA().getName();
        }

        @Override
        public String getNetAName() {
            DeviceTemplate contactDevT = this.mResult.getDevPath().getDeviceTemplate();
            Net bottomNet = this.getPinA().getNet();
            DevicePath pinPath = this.mResult.getPinPathFromContactDev();
            Net net = PinMapPortMapInfo.getNetAtContactDev(contactDevT, pinPath, bottomNet);
            return net == null ? null : net.getName();
        }

        @Override
        public Layer getLayerA() {
            return this.mResult.getLayer();
        }

        @Override
        public Layer getLayerB() {
            return null;
        }

        @Override
        public PinMapCheck.CheckResult getResult() {
            return this.mResult;
        }
    }

    protected static class CsvInputViolationInfo
    extends CsvInputResultInfo
    implements ViolationInfo {
        public CsvInputViolationInfo(ReferenceCsvCheck.CsvInputViolation violation) {
            super(violation);
        }

        @Override
        public PinMapCheck.Violation getViolation() {
            return (ReferenceCsvCheck.CsvInputViolation)this.mResult;
        }
    }

    protected static class CsvInputResultInfo
    extends CsvPinMapInfo {
        protected ReferenceCsvCheck.CsvInputResult mResult;

        public CsvInputResultInfo(ReferenceCsvCheck.CsvInputResult result) {
            super(result.getPinMap());
            this.mResult = result;
        }

        @Override
        public Boolean highLightPinPathA() {
            return this.mResult.isPinPathAError();
        }

        @Override
        public Boolean highLightPinA() {
            return this.mResult.isPinAError();
        }

        @Override
        public Boolean highLightNetA() {
            return this.mResult.isNetAError();
        }

        @Override
        public Boolean highLightPinPathB() {
            return this.mResult.isPinPathBrror();
        }

        @Override
        public Boolean highLightPinB() {
            return this.mResult.isPinBError();
        }

        @Override
        public Boolean highLightNetB() {
            return this.mResult.isNetBError();
        }

        @Override
        public PinMapCheck.CheckResult getResult() {
            return this.mResult;
        }
    }

    protected static class CsvPinNetViolationInfo
    extends CsvPinNetResultInfo
    implements ViolationInfo {
        public CsvPinNetViolationInfo(ReferenceCsvCheck.CsvPinNetViolation violation) {
            super(violation);
        }

        @Override
        public PinMapCheck.Violation getViolation() {
            return (ReferenceCsvCheck.CsvPinNetViolation)this.mResult;
        }
    }

    protected static class CsvPinNetResultInfo
    extends RefPinMapInfo {
        protected ReferenceCsvCheck.CsvPinNetResult mResult;

        public CsvPinNetResultInfo(ReferenceCsvCheck.CsvPinNetResult result) {
            super(result.getPinMap());
            this.mResult = result;
        }

        @Override
        public String getRefNetAName() {
            Net refNetA = this.mResult.getRefNetA();
            return refNetA == null ? "" : refNetA.getName();
        }

        @Override
        public String getRefNetBName() {
            Net refNetB = this.mResult.getRefNetB();
            return refNetB == null ? "" : refNetB.getName();
        }

        @Override
        public Boolean highLightNetA() {
            return this.mResult.isNetAError();
        }

        @Override
        public Boolean highLightNetB() {
            return this.mResult.isNetBError();
        }

        @Override
        public PinMapCheck.CheckResult getResult() {
            return this.mResult;
        }
    }

    protected static class CsvPinLayerViolationInfo
    extends CsvPinLayerResultInfo
    implements ViolationInfo {
        public CsvPinLayerViolationInfo(ReferenceCsvCheck.CsvPinLayerViolation violation) {
            super(violation);
        }

        @Override
        public PinMapCheck.Violation getViolation() {
            return (ReferenceCsvCheck.CsvPinLayerViolation)this.mResult;
        }
    }

    protected static class CsvPinLayerResultInfo
    extends RefPinMapInfo {
        protected ReferenceCsvCheck.CsvPinLayerResult mResult;

        public CsvPinLayerResultInfo(ReferenceCsvCheck.CsvPinLayerResult result) {
            super(result.getPinMap());
            this.mResult = result;
        }

        @Override
        public PinMapCheck.CheckResult getResult() {
            return this.mResult;
        }
    }

    protected static class CsvRemovedViolationInfo
    extends CsvRemovedResultInfo
    implements ViolationInfo {
        public CsvRemovedViolationInfo(ReferenceCsvCheck.CsvRemovedViolation violation) {
            super(violation);
        }

        @Override
        public PinMapCheck.Violation getViolation() {
            return (ReferenceCsvCheck.CsvRemovedViolation)this.mResult;
        }
    }

    protected static class CsvRemovedResultInfo
    extends PinMapInfo {
        protected ReferenceCsvCheck.CsvRemovedResult mResult;

        public CsvRemovedResultInfo(ReferenceCsvCheck.CsvRemovedResult result) {
            super(result.getPinMap());
            this.mResult = result;
        }

        @Override
        public PinMapCheck.CheckResult getResult() {
            return this.mResult;
        }
    }

    protected static class CsvAddedViolationInfo
    extends CsvAddedResultInfo
    implements ViolationInfo {
        public CsvAddedViolationInfo(ReferenceCsvCheck.CsvAddedViolation violation) {
            super(violation);
        }

        @Override
        public PinMapCheck.Violation getViolation() {
            return (ReferenceCsvCheck.CsvAddedViolation)this.mResult;
        }
    }

    protected static class CsvAddedResultInfo
    extends RefPinMapInfo {
        protected ReferenceCsvCheck.CsvAddedResult mResult;

        public CsvAddedResultInfo(ReferenceCsvCheck.CsvAddedResult result) {
            super(result.getPinMap());
            this.mResult = result;
        }

        @Override
        public PinMapCheck.CheckResult getResult() {
            return this.mResult;
        }
    }

    protected static class RefPinMapInfo
    implements PinsInfo {
        private final ReferenceCsvCheck.ReferencePinMap mRefPinMap;

        private RefPinMapInfo(ReferenceCsvCheck.ReferencePinMap refPinMap) {
            this.mRefPinMap = refPinMap;
        }

        @Override
        public DevicePath getPinPathAFromOwner() {
            return this.mRefPinMap.getPinPathA();
        }

        @Override
        public DevicePath getPinPathBFromOwner() {
            return this.mRefPinMap.getPinPathB();
        }

        @Override
        public PinTemplate getPinA() {
            return this.mRefPinMap.getPinA();
        }

        @Override
        public PinTemplate getPinB() {
            return this.mRefPinMap.getPinB();
        }

        @Override
        public String getDevPathAStr() {
            return PinMapPortMapInfo.getFullPathsString(this.mRefPinMap.getContactDevPathA());
        }

        @Override
        public String getLayerAName() {
            return this.mRefPinMap.getLayerA().getName();
        }

        @Override
        public String getPinPathAStr() {
            return this.mRefPinMap.getPinPathAFromContactDev().toString();
        }

        @Override
        public String getPinAName() {
            return this.getPinA().getName();
        }

        @Override
        public String getNetAName() {
            Net pinNetA = this.mRefPinMap.getPinNetA();
            return pinNetA == null ? "" : pinNetA.getName();
        }

        @Override
        public String getDevPathBStr() {
            return PinMapPortMapInfo.getFullPathsString(this.mRefPinMap.getContactDevPathB());
        }

        @Override
        public String getLayerBName() {
            return this.mRefPinMap.getLayerB().getName();
        }

        @Override
        public String getPinPathBStr() {
            return this.mRefPinMap.getPinPathBFromContactDev().toString();
        }

        @Override
        public String getPinBName() {
            return this.getPinB().getName();
        }

        @Override
        public String getNetBName() {
            Net pinNetB = this.mRefPinMap.getPinNetB();
            return pinNetB == null ? "" : pinNetB.getName();
        }

        @Override
        public Layer getLayerA() {
            return this.mRefPinMap.getLayerA();
        }

        @Override
        public Layer getLayerB() {
            return this.mRefPinMap.getLayerB();
        }
    }

    protected static class PinMapInfo
    implements PinsInfo {
        private final PinMap mPinMap;

        public PinMapInfo(PinMap pinMap) {
            this.mPinMap = pinMap;
        }

        @Override
        public DevicePath getPinPathAFromOwner() {
            return this.mPinMap.getPinAPath();
        }

        @Override
        public DevicePath getPinPathBFromOwner() {
            return this.mPinMap.getPinBPath();
        }

        @Override
        public PinTemplate getPinA() {
            return this.mPinMap.getPinA();
        }

        @Override
        public PinTemplate getPinB() {
            return this.mPinMap.getPinB();
        }

        @Override
        public String getDevPathAStr() {
            return PinMapPortMapInfo.getFullPathsString(this.mPinMap.getContactDevPathA());
        }

        @Override
        public String getLayerAName() {
            return this.mPinMap.getContactLayerA().getName();
        }

        @Override
        public String getPinPathAStr() {
            return this.mPinMap.getPinAPathFromContactDev().toString();
        }

        @Override
        public String getPinAName() {
            return this.getPinA().getName();
        }

        @Override
        public String getNetAName() {
            Net netAtContactDevA = this.mPinMap.getNetAtContactDevA();
            return netAtContactDevA == null || netAtContactDevA.isUnused() ? null : netAtContactDevA.getName();
        }

        @Override
        public String getDesignNetAName() {
            Net net = this.mPinMap.getNetAtSubstrateInstA();
            return net == null || net.isUnused() ? null : net.getName();
        }

        @Override
        public String getDevPathBStr() {
            return PinMapPortMapInfo.getFullPathsString(this.mPinMap.getContactDevPathB());
        }

        @Override
        public String getLayerBName() {
            return this.mPinMap.getContactLayerB().getName();
        }

        @Override
        public String getPinPathBStr() {
            return this.mPinMap.getPinBPathFromContactDev().toString();
        }

        @Override
        public String getPinBName() {
            return this.getPinB().getName();
        }

        @Override
        public String getNetBName() {
            Net netAtContactDevB = this.mPinMap.getNetAtContactDevB();
            return netAtContactDevB == null || netAtContactDevB.isUnused() ? null : netAtContactDevB.getName();
        }

        @Override
        public String getDesignNetBName() {
            Net net = this.mPinMap.getNetAtSubstrateInstB();
            return net == null || net.isUnused() ? null : net.getName();
        }

        @Override
        public Layer getLayerA() {
            return this.mPinMap.getContactLayerA();
        }

        @Override
        public Layer getLayerB() {
            return this.mPinMap.getContactLayerB();
        }
    }

    protected static class NetPersonalityViolationInfo
    extends NetPersonalityResultInfo
    implements ViolationInfo {
        private NetPersonalityViolationInfo(NetPersonalityCheck.NetPersonalityViolation violation) {
            super(violation);
        }

        @Override
        public boolean isFixed() {
            NetPersonalityCheck.NetPersonalityViolation v = (NetPersonalityCheck.NetPersonalityViolation)this.mResult;
            return v.isFixed();
        }

        @Override
        public PinMapCheck.Violation getViolation() {
            return (NetPersonalityCheck.NetPersonalityViolation)this.mResult;
        }
    }

    protected static class NetPersonalityResultInfo
    extends PinMapInfo {
        protected final NetPersonalityCheck.NetPersonalityResult mResult;

        private NetPersonalityResultInfo(NetPersonalityCheck.NetPersonalityResult result) {
            super(result.getPinMap());
            this.mResult = result;
        }

        public PinMap getPinMap() {
            return this.mResult.getPinMap();
        }

        @Override
        public String getNetAPersonalityStr() {
            return this.mResult.getPersonalityA().stream().map(Personality::getName).reduce((str1, str2) -> String.format("%s%n%s", str1, str2)).orElse(null);
        }

        @Override
        public String getNetBPersonalityStr() {
            return this.mResult.getPersonalityB().stream().map(Personality::getName).reduce((str1, str2) -> String.format("%s%n%s", str1, str2)).orElse(null);
        }

        @Override
        public PinMapCheck.CheckResult getResult() {
            return this.mResult;
        }
    }

    protected static class NetMapViolationInfo
    extends NetMapResultInfo
    implements ViolationInfo {
        private NetMapViolationInfo(NetMappingCheck.NetMappingViolation violation) {
            super(violation);
        }

        @Override
        public boolean isFixed() {
            NetMappingCheck.NetMappingViolation v = (NetMappingCheck.NetMappingViolation)this.mResult;
            return v.isFixed();
        }

        @Override
        public PinMapCheck.Violation getViolation() {
            return (NetMappingCheck.NetMappingViolation)this.mResult;
        }
    }

    protected static class NetMapResultInfo
    extends PinMapInfo {
        protected final NetMappingCheck.NetMappingResult mResult;

        private NetMapResultInfo(NetMappingCheck.NetMappingResult result) {
            super(result.getPinMap());
            this.mResult = result;
        }

        public PinMap getPinMap() {
            return this.mResult.getPinMap();
        }

        @Override
        public PinMapCheck.CheckResult getResult() {
            return this.mResult;
        }
    }

    protected static class PinDirectionViolationInfo
    extends PinDirectionResultInfo
    implements ViolationInfo {
        private PinDirectionViolationInfo(PinDirectionCheck.PinDirectionViolation violation) {
            super(violation);
        }

        @Override
        public PinMapCheck.Violation getViolation() {
            return (PinDirectionCheck.PinDirectionViolation)this.mResult;
        }
    }

    protected static class PinDirectionResultInfo
    extends PinMapInfo {
        protected final PinDirectionCheck.PinDirectionResult mResult;

        private PinDirectionResultInfo(PinDirectionCheck.PinDirectionResult result) {
            super(result.getPinMap());
            this.mResult = result;
        }

        @Override
        public String getPinADirationStr() {
            return this.getPinA().getDirection().toString();
        }

        @Override
        public String getPinBDirationStr() {
            return this.getPinB().getDirection().toString();
        }

        @Override
        public PinMapCheck.CheckResult getResult() {
            return this.mResult;
        }
    }

    protected static class PinCountMismatchViolationInfo
    extends PinCountMismatchResultInfo
    implements ViolationInfo {
        private PinCountMismatchViolationInfo(PinCountMismatchCheck.PinCountMismatchViolation violation) {
            super(violation);
        }

        @Override
        public PinMapCheck.Violation getViolation() {
            return (PinCountMismatchCheck.PinCountMismatchViolation)this.mResult;
        }
    }

    protected static class PinCountMismatchResultInfo
    implements PinsInfo {
        protected final PinCountMismatchCheck.PinCountMismatchResult mResult;

        private PinCountMismatchResultInfo(PinCountMismatchCheck.PinCountMismatchResult result) {
            this.mResult = result;
        }

        @Override
        public DevicePath getPinPathAFromOwner() {
            return this.mResult.getPinPath();
        }

        @Override
        public PinTemplate getPinA() {
            return this.mResult.getPin();
        }

        @Override
        public String getDevPathAStr() {
            return PinMapPortMapInfo.getFullPathsString(this.mResult.getDevPath());
        }

        @Override
        public String getLayerAName() {
            return this.mResult.getLayer().getName();
        }

        @Override
        public String getPinPathAStr() {
            return this.mResult.getPinPathFromContactDev().toString();
        }

        @Override
        public String getPinAName() {
            return this.getPinA().getName();
        }

        @Override
        public String getNetAName() {
            DeviceTemplate contactDevT = this.mResult.getDevPath().getDeviceTemplate();
            Net bottomNet = this.getPinA().getNet();
            DevicePath pinPath = this.mResult.getPinPathFromContactDev();
            Net net = PinMapPortMapInfo.getNetAtContactDev(contactDevT, pinPath, bottomNet);
            return net == null ? null : net.getName();
        }

        @Override
        public Layer getLayerA() {
            return this.mResult.getLayer();
        }

        @Override
        public Layer getLayerB() {
            return null;
        }

        @Override
        public PinMapCheck.CheckResult getResult() {
            return this.mResult;
        }
    }

    protected static class PinOffsetViolationInfo
    extends PinOffsetResultInfo
    implements ViolationInfo {
        private PinOffsetViolationInfo(PinOffsetCheck.PinOffsetViolation violation) {
            super(violation);
        }

        @Override
        public boolean isFixed() {
            PinOffsetCheck.PinOffsetViolation v = (PinOffsetCheck.PinOffsetViolation)this.mResult;
            return v.isFixed();
        }

        @Override
        public PinMapCheck.Violation getViolation() {
            return (PinOffsetCheck.PinOffsetViolation)this.mResult;
        }
    }

    protected static class PinOffsetResultInfo
    implements PortsInfo {
        protected final PinOffsetCheck.PinOffsetResult mResult;

        private PinOffsetResultInfo(PinOffsetCheck.PinOffsetResult result) {
            this.mResult = result;
        }

        public ContactLayer getContactLayer() {
            return this.mResult.getContactLayer();
        }

        @Override
        public DevicePath getPortPathAFromOwner() {
            return this.mResult.getPinPathAFromOwner();
        }

        @Override
        public DevicePath getPortPathBFromOwner() {
            return this.mResult.getPinPathBFromOwner();
        }

        @Override
        public PortTemplate getPortA() {
            return this.mResult.getPortTA();
        }

        @Override
        public PortTemplate getPortB() {
            return this.mResult.getPortTB();
        }

        @Override
        public String getDevPathAStr() {
            return PinMapPortMapInfo.getFullPathsString(this.mResult.getDevPathA());
        }

        @Override
        public String getLayerAName() {
            return this.mResult.getLayerA().getName();
        }

        @Override
        public String getPinPathAStr() {
            return this.mResult.getPinPathAFromContactDev().toString();
        }

        @Override
        public String getPinAName() {
            return this.mResult.getPinTA().getName();
        }

        @Override
        public String getPortNumAStr() {
            return Integer.toString(this.getPortA().getPortNum());
        }

        @Override
        public String getDevPathBStr() {
            return PinMapPortMapInfo.getFullPathsString(this.mResult.getDevPathB());
        }

        @Override
        public String getLayerBName() {
            return this.mResult.getLayerB().getName();
        }

        @Override
        public String getPinPathBStr() {
            return this.mResult.getPinPathBFromContactDev().toString();
        }

        @Override
        public String getPinBName() {
            return this.mResult.getPinTB().getName();
        }

        @Override
        public String getPortNumBStr() {
            return Integer.toString(this.getPortB().getPortNum());
        }

        @Override
        public String getMaxOffsetStr() {
            return Double.toString(this.mResult.getMaxOffset());
        }

        @Override
        public String getCurOffsetStr() {
            return Double.toString(this.mResult.getCurOffset());
        }

        @Override
        public Layer getLayerA() {
            return this.mResult.getLayerA();
        }

        @Override
        public Layer getLayerB() {
            return this.mResult.getLayerB();
        }

        @Override
        public PinMapCheck.CheckResult getResult() {
            return this.mResult;
        }
    }

    protected static class PinUnmappedViolationInfo
    extends PinUnmappedResultInfo
    implements ViolationInfo {
        private PinUnmappedViolationInfo(PinUnmappedCheck.PinUnmappedViolation violation) {
            super(violation);
        }

        @Override
        public boolean isFixed() {
            PinUnmappedCheck.PinUnmappedViolation v = (PinUnmappedCheck.PinUnmappedViolation)this.mResult;
            return v.isFixed();
        }

        @Override
        public PinMapCheck.Violation getViolation() {
            return (PinUnmappedCheck.PinUnmappedViolation)this.mResult;
        }
    }

    protected static class PinUnmappedResultInfo
    implements PinsInfo {
        protected final PinUnmappedCheck.PinUnmappedResult mResult;

        private PinUnmappedResultInfo(PinUnmappedCheck.PinUnmappedResult mResult) {
            this.mResult = mResult;
        }

        public boolean isPinA() {
            return this.mResult.isPinA();
        }

        public PinTemplate getPin() {
            return this.mResult.getPin();
        }

        public DevicePath getPinPath() {
            return this.mResult.getPinPath();
        }

        public ContactLayer getContactLayer() {
            return this.mResult.getContactLayer();
        }

        @Override
        public DevicePath getPinPathAFromOwner() {
            return this.mResult.getPinPathA();
        }

        @Override
        public DevicePath getPinPathBFromOwner() {
            return this.mResult.getPinPathB();
        }

        @Override
        public PinTemplate getPinA() {
            return this.mResult.getPinTA();
        }

        @Override
        public PinTemplate getPinB() {
            return this.mResult.getPinTB();
        }

        @Override
        public String getDevPathAStr() {
            return PinMapPortMapInfo.getFullPathsString(this.mResult.getDevPathA());
        }

        @Override
        public String getLayerAName() {
            return this.mResult.getLayerA().getName();
        }

        @Override
        public String getPinPathAStr() {
            DevicePath pinPath = this.mResult.getPinPathAFromContactDev();
            return pinPath == null ? null : pinPath.toString();
        }

        @Override
        public String getPinAName() {
            PinTemplate pin = this.getPinA();
            return pin == null ? null : pin.getName();
        }

        @Override
        public String getNetAName() {
            PinTemplate pin = this.getPinA();
            if (pin == null) {
                return null;
            }
            DeviceTemplate contactDevT = this.mResult.getDevPathA().getDeviceTemplate();
            Net bottomNet = pin.getNet();
            DevicePath pinPath = this.mResult.getPinPathAFromContactDev();
            Net net = PinMapPortMapInfo.getNetAtContactDev(contactDevT, pinPath, bottomNet);
            return net == null ? null : net.getName();
        }

        @Override
        public String getDevPathBStr() {
            return PinMapPortMapInfo.getFullPathsString(this.mResult.getDevPathB());
        }

        @Override
        public String getLayerBName() {
            return this.mResult.getLayerB().getName();
        }

        @Override
        public String getPinPathBStr() {
            DevicePath pinPath = this.mResult.getPinPathBFromContactDev();
            return pinPath == null ? null : pinPath.toString();
        }

        @Override
        public String getPinBName() {
            PinTemplate pin = this.getPinB();
            return pin == null ? null : pin.getName();
        }

        @Override
        public String getNetBName() {
            PinTemplate pin = this.getPinB();
            if (pin == null) {
                return null;
            }
            DeviceTemplate contactDevT = this.mResult.getDevPathB().getDeviceTemplate();
            Net bottomNet = pin.getNet();
            DevicePath pinPath = this.mResult.getPinPathBFromContactDev();
            Net net = PinMapPortMapInfo.getNetAtContactDev(contactDevT, pinPath, bottomNet);
            return net == null ? null : net.getName();
        }

        @Override
        public Layer getLayerA() {
            return this.mResult.getLayerA();
        }

        @Override
        public Layer getLayerB() {
            return this.mResult.getLayerB();
        }

        @Override
        public PinMapCheck.CheckResult getResult() {
            return this.mResult;
        }
    }

    protected static class PortContactViolationInfo
    extends PortContactResultInfo
    implements ViolationInfo {
        private PortContactViolationInfo(PortContactCheck.PortContactViolation portContactViolation) {
            super(portContactViolation);
        }

        @Override
        public boolean isFixed() {
            PortContactCheck.PortContactViolation v = (PortContactCheck.PortContactViolation)this.mResult;
            return v.isFixed();
        }

        @Override
        public PinMapCheck.Violation getViolation() {
            return (PortContactCheck.PortContactViolation)this.mResult;
        }
    }

    protected static class PortContactResultInfo
    implements PortsInfo {
        protected final PortContactCheck.PortContactResult mResult;

        private PortContactResultInfo(PortContactCheck.PortContactResult portContactResult) {
            this.mResult = portContactResult;
        }

        public ContactLayer getContactLayer() {
            return this.mResult.getContactLayer();
        }

        public boolean isPortA() {
            return this.mResult.isPortA();
        }

        public DevicePath getPortPath() {
            return this.mResult.getPortPath();
        }

        public PortTemplate getPort() {
            return this.mResult.getPort();
        }

        @Override
        public DevicePath getPortPathAFromOwner() {
            return this.mResult.getPinPathAFromOwner();
        }

        @Override
        public DevicePath getPortPathBFromOwner() {
            return this.mResult.getPinPathBFromOwner();
        }

        @Override
        public PortTemplate getPortA() {
            return this.mResult.getPortTA();
        }

        @Override
        public PortTemplate getPortB() {
            return this.mResult.getPortTB();
        }

        @Override
        public String getDevPathAStr() {
            return PinMapPortMapInfo.getFullPathsString(this.mResult.getDevPathA());
        }

        @Override
        public String getLayerAName() {
            return this.mResult.getLayerA().getName();
        }

        @Override
        public String getPinPathAStr() {
            DevicePath pinPath = this.mResult.getPinPathAFromContactDev();
            return pinPath == null ? null : pinPath.toString();
        }

        @Override
        public String getPinAName() {
            PinTemplate pin = this.mResult.getPinTA();
            return pin == null ? null : pin.getName();
        }

        @Override
        public String getPortNumAStr() {
            PortTemplate port = this.getPortA();
            return port == null ? null : Integer.toString(port.getPortNum());
        }

        @Override
        public String getDevPathBStr() {
            return PinMapPortMapInfo.getFullPathsString(this.mResult.getDevPathB());
        }

        @Override
        public String getLayerBName() {
            return this.mResult.getLayerB().getName();
        }

        @Override
        public String getPinPathBStr() {
            DevicePath pinPath = this.mResult.getPinPathBFromContactDev();
            return pinPath == null ? null : pinPath.toString();
        }

        @Override
        public String getPinBName() {
            PinTemplate pin = this.mResult.getPinTB();
            return pin == null ? null : pin.getName();
        }

        @Override
        public String getPortNumBStr() {
            PortTemplate port = this.getPortB();
            return port == null ? null : Integer.toString(port.getPortNum());
        }

        @Override
        public Layer getLayerA() {
            return this.mResult.getLayerA();
        }

        @Override
        public Layer getLayerB() {
            return this.mResult.getLayerB();
        }

        @Override
        public PinMapCheck.CheckResult getResult() {
            return this.mResult;
        }
    }

    protected static interface ViolationInfo
    extends Info {
        default public boolean isFixed() {
            return false;
        }

        default public PinMapCheck.Violation getViolation() {
            return null;
        }
    }

    protected static interface PortsInfo
    extends Info {
        default public DevicePath getPortPathAFromOwner() {
            return null;
        }

        default public DevicePath getPortPathBFromOwner() {
            return null;
        }

        default public PortTemplate getPortA() {
            return null;
        }

        default public PortTemplate getPortB() {
            return null;
        }

        public Layer getLayerA();

        public Layer getLayerB();
    }

    protected static interface PinsInfo
    extends Info {
        default public DevicePath getPinPathAFromOwner() {
            return null;
        }

        default public DevicePath getPinPathBFromOwner() {
            return null;
        }

        default public PinTemplate getPinA() {
            return null;
        }

        default public PinTemplate getPinB() {
            return null;
        }

        public Layer getLayerA();

        public Layer getLayerB();
    }

    protected static interface Info {
        default public String getDevPathAStr() {
            return "";
        }

        default public String getLayerAName() {
            return "";
        }

        default public String getPinPathAStr() {
            return "";
        }

        default public String getPinAName() {
            return "";
        }

        default public String getNetAName() {
            return "";
        }

        default public String getDesignNetAName() {
            return "";
        }

        default public String getRefNetAName() {
            return "";
        }

        default public String getPortNumAStr() {
            return "";
        }

        default public String getPinADirationStr() {
            return "";
        }

        default public String getNetAPersonalityStr() {
            return "";
        }

        default public String getDevPathBStr() {
            return "";
        }

        default public String getLayerBName() {
            return "";
        }

        default public String getPinPathBStr() {
            return "";
        }

        default public String getPinBName() {
            return "";
        }

        default public String getNetBName() {
            return "";
        }

        default public String getDesignNetBName() {
            return "";
        }

        default public String getRefNetBName() {
            return "";
        }

        default public String getPortNumBStr() {
            return "";
        }

        default public String getPinBDirationStr() {
            return "";
        }

        default public String getNetBPersonalityStr() {
            return "";
        }

        default public String getMaxOffsetStr() {
            return "";
        }

        default public String getCurOffsetStr() {
            return "";
        }

        default public Boolean highLightPinPathA() {
            return Boolean.FALSE;
        }

        default public Boolean highLightPinA() {
            return Boolean.FALSE;
        }

        default public Boolean highLightNetA() {
            return Boolean.FALSE;
        }

        default public Boolean highLightPinPathB() {
            return Boolean.FALSE;
        }

        default public Boolean highLightPinB() {
            return Boolean.FALSE;
        }

        default public Boolean highLightNetB() {
            return Boolean.FALSE;
        }

        default public PinMapCheck.CheckResult getResult() {
            return null;
        }
    }
}

