/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.inter_substrate_checks.ui;

import com.sigrity.acl.AFileFilter;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.ContactLayer;
import com.sigrity.acl.ui.AFileChooser;
import com.sigrity.acl.ui.DbDialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.cphelper.CpHelper;
import com.sigrity.tools.dbexplorer.DbExplorerPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class RefPinMapCsvEditorUI
extends DbDialog {
    private static final int COLUMN_WIDTH_UNIT = 20;
    private static final int TABLE_WIDTH = 720;
    private static final int TABLE_HEIGHT = 180;
    private JTable mTable = new JTable();
    private ContactLayerList mContactLayerListModel = new ContactLayerList();

    public static void showUI() {
        Db curDb = OrbitIO.getCurDb();
        Window owner = OrbitIO.getMainWindow();
        RefPinMapCsvEditorUI.showUI(curDb, owner);
    }

    public static void showUI(Db db, Window owner) {
        RefPinMapCsvEditorUI dlg = new RefPinMapCsvEditorUI(db, owner);
        dlg.setVisible(true);
    }

    public RefPinMapCsvEditorUI(Db db, Window owner) {
        super(db, (Component)owner, "Reference PinMap Csv Editor", Dialog.ModalityType.DOCUMENT_MODAL);
        this.loadDb();
        this.init();
    }

    private void init() {
        this.mTable = new JTable();
        JTableHeader tableHeader = this.mTable.getTableHeader();
        tableHeader.setReorderingAllowed(false);
        this.mTable.setRowSelectionAllowed(false);
        this.mTable.setSelectionMode(0);
        this.mTable.setModel(this.mContactLayerListModel);
        this.mTable.setRowHeight(this.mTable.getRowHeight() + 8);
        TableColumn devPathACol = this.mTable.getColumnModel().getColumn(TableHeader.DEVICEPATHA.ordinal());
        devPathACol.setMinWidth(160);
        devPathACol.setIdentifier((Object)TableHeader.DEVICEPATHA);
        devPathACol.setResizable(true);
        TableColumn layerACol = this.mTable.getColumnModel().getColumn(TableHeader.LAYERA.ordinal());
        layerACol.setMinWidth(80);
        layerACol.setIdentifier((Object)TableHeader.LAYERA);
        layerACol.setResizable(true);
        TableColumn devPathBCol = this.mTable.getColumnModel().getColumn(TableHeader.DEVICEPATHB.ordinal());
        devPathBCol.setMinWidth(160);
        devPathBCol.setIdentifier((Object)TableHeader.DEVICEPATHB);
        devPathBCol.setResizable(true);
        TableColumn layerBCol = this.mTable.getColumnModel().getColumn(TableHeader.LAYERB.ordinal());
        layerBCol.setMinWidth(80);
        layerBCol.setIdentifier((Object)TableHeader.LAYERB);
        layerBCol.setResizable(true);
        TableColumn refCsvCol = this.mTable.getColumnModel().getColumn(TableHeader.REFCSV.ordinal());
        refCsvCol.setMinWidth(200);
        refCsvCol.setIdentifier((Object)TableHeader.REFCSV);
        refCsvCol.setResizable(true);
        this.mTable.setDefaultRenderer(Object.class, new ContactLayerRowRenderer());
        this.mTable.addMouseListener(new TableButtonMouseListener());
        GridBagManager l = GridBagManager.layout((JDialog)((Object)this));
        JScrollPane scrollPane = new JScrollPane(this.mTable);
        scrollPane.setMinimumSize(new Dimension(720, 180));
        scrollPane.setPreferredSize(scrollPane.getMinimumSize());
        l.add((Component)scrollPane, (GridBagConstraints)GridBagManager.FILLALL);
        l.newline();
        l.pushFillXRemainX();
        l.addFillX();
        JButton btnClose = (JButton)l.add((Component)new JButton("Close"));
        l.pop();
        UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnClose, null);
        this.pack();
        this.setPreferredSize(this.getMinimumSize());
        UIUtil.center((Component)((Object)this));
    }

    private void loadDb() {
        ArrayList contactLayers = AUtil.arrayList((Iterator)ContactLayer.getValid((Db)this.mDb));
        Collections.sort(contactLayers);
        this.mContactLayerListModel.setContactLayers(contactLayers);
    }

    class TableButtonMouseListener
    extends MouseAdapter {
        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.showPopUpMenu(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.showPopUpMenu(e);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.showPopUpMenu(e);
            }
        }

        private int getRow(MouseEvent e) {
            return e.getY() / RefPinMapCsvEditorUI.this.mTable.getRowHeight();
        }

        private int getCol(MouseEvent e) {
            TableColumnModel columnModel = RefPinMapCsvEditorUI.this.mTable.getColumnModel();
            int column = columnModel.getColumnIndexAtX(e.getX());
            return column;
        }

        private void showPopUpMenu(MouseEvent e) {
            int mouseRow = this.getRow(e);
            if (mouseRow >= RefPinMapCsvEditorUI.this.mTable.getRowCount()) {
                return;
            }
            int mouseCol = this.getCol(e);
            if (TableHeader.get(mouseCol) == TableHeader.REFCSV) {
                JPopupMenu pop = this.getRefCsvPopupMenu(mouseRow, mouseCol);
                this.showPopupMenu(e, pop);
            }
        }

        private JPopupMenu getRefCsvPopupMenu(int mouseRow, int mouseCol) {
            final ContactLayer contactLayer = RefPinMapCsvEditorUI.this.mContactLayerListModel.getContactLayer(mouseRow);
            JPopupMenu pop = new JPopupMenu();
            JMenuItem refreshMenu = new JMenuItem(new AbstractAction("Select file"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AFileChooser fc = new AFileChooser();
                    fc.addChoosableFileFilter((FileFilter)AFileFilter.CSV);
                    fc.setFileFilter((FileFilter)AFileFilter.CSV);
                    fc.setFileSelectionMode(0);
                    fc.setMultiSelectionEnabled(false);
                    fc.setDialogTitle("Reference PinMap Csv");
                    if (fc.showOpenDialog((Component)OrbitIO.getMainWindow()) != 0) {
                        return;
                    }
                    File fRuleFile = fc.getSelectedFile();
                    if (fRuleFile == null) {
                        return;
                    }
                    Cp.exec((String)"_contactLayer = %s", (Object[])new Object[]{CpHelper.getObjCmdStr(contactLayer)});
                    Cp.exec((String)"_contactLayer.setRefPinMapCsv(%s);", (Object[])new Object[]{Cp.getFileAsArgument((File)fRuleFile)});
                    RefPinMapCsvEditorUI.this.mTable.revalidate();
                    RefPinMapCsvEditorUI.this.mTable.repaint();
                }
            });
            pop.add(refreshMenu);
            if (contactLayer.getRefPinMapCsv() != null) {
                JMenuItem optionsMenu = new JMenuItem(new AbstractAction("Delete"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Cp.exec((String)"_contactLayer = %s", (Object[])new Object[]{CpHelper.getObjCmdStr(contactLayer)});
                        Cp.exec((String)"_contactLayer.setRefPinMapCsv(null);", (Object[])new Object[0]);
                        RefPinMapCsvEditorUI.this.mTable.revalidate();
                        RefPinMapCsvEditorUI.this.mTable.repaint();
                    }
                });
                pop.add(optionsMenu);
            }
            return pop;
        }

        private void showPopupMenu(MouseEvent e, JPopupMenu pop) {
            if (pop == null) {
                return;
            }
            pop.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    public class ContactLayerRowRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object o, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, o, isSelected, hasFocus, row, column);
            ContactLayer def = RefPinMapCsvEditorUI.this.mContactLayerListModel.getContactLayer(row);
            this.setIcon(null);
            this.setText(null);
            this.setForeground(Color.black);
            this.setBackground(Color.white);
            this.setToolTipText(null);
            this.setHorizontalAlignment(2);
            if (isSelected) {
                this.setBackground(Color.orange);
            }
            switch (TableHeader.get(column)) {
                case DEVICEPATHA: {
                    this.setText(def.getDevicePathA().getAFullPath().toString());
                    this.setIcon(DbExplorerPanel.getIconForTemplate(def.getDeviceTemplateA()));
                    break;
                }
                case LAYERA: {
                    this.setText(def.getContactLayerA().getName());
                    break;
                }
                case DEVICEPATHB: {
                    this.setText(def.getDevicePathB().getAFullPath().toString());
                    this.setIcon(DbExplorerPanel.getIconForTemplate(def.getDeviceTemplateB()));
                    break;
                }
                case LAYERB: {
                    this.setText(def.getContactLayerB().getName());
                    break;
                }
                case REFCSV: {
                    this.setText(def.getRefPinMapCsv());
                }
            }
            return this;
        }
    }

    class ContactLayerList
    extends AbstractTableModel {
        private List<ContactLayer> contactLayerRows;

        public ContactLayer getContactLayer(int row) {
            if (row < this.contactLayerRows.size()) {
                return this.contactLayerRows.get(row);
            }
            return null;
        }

        public void setContactLayers(List<ContactLayer> contactLayer) {
            this.contactLayerRows = contactLayer;
        }

        @Override
        public String getColumnName(int col) {
            return TableHeader.get(col).getName();
        }

        @Override
        public int getColumnCount() {
            return TableHeader.values().length;
        }

        @Override
        public int getRowCount() {
            return this.contactLayerRows.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return null;
        }
    }

    public static final class TableHeader
    extends Enum<TableHeader> {
        public static final /* enum */ TableHeader DEVICEPATHA = new TableHeader("DevicePath A");
        public static final /* enum */ TableHeader LAYERA = new TableHeader("Layer A");
        public static final /* enum */ TableHeader DEVICEPATHB = new TableHeader("DevicePath B");
        public static final /* enum */ TableHeader LAYERB = new TableHeader("Layer B");
        public static final /* enum */ TableHeader REFCSV = new TableHeader("Reference Csv");
        private String name;
        private static final /* synthetic */ TableHeader[] $VALUES;

        public static TableHeader[] values() {
            return (TableHeader[])$VALUES.clone();
        }

        public static TableHeader valueOf(String name) {
            return Enum.valueOf(TableHeader.class, name);
        }

        static TableHeader get(int i) {
            assert (i < TableHeader.values().length);
            TableHeader[] instructionHeader = TableHeader.values();
            return instructionHeader[i];
        }

        private TableHeader(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        static {
            $VALUES = new TableHeader[]{DEVICEPATHA, LAYERA, DEVICEPATHB, LAYERB, REFCSV};
        }
    }
}

