/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.inter_substrate_checks.ui;

import com.sigrity.acl.Unit;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.ContactLayer;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.PinMap;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.PortTemplate;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ShowMeTheWay;
import com.sigrity.orbit.automation.pinMap.PinMapCsvReader;
import com.sigrity.orbit.inter_substrate_checks.NetMappingCheck;
import com.sigrity.orbit.inter_substrate_checks.PinCountMismatchCheck;
import com.sigrity.orbit.inter_substrate_checks.PinDirectionCheck;
import com.sigrity.orbit.inter_substrate_checks.PinMapCheck;
import com.sigrity.orbit.inter_substrate_checks.PinOffsetCheck;
import com.sigrity.orbit.inter_substrate_checks.PinUnmappedCheck;
import com.sigrity.orbit.inter_substrate_checks.PortContactCheck;
import com.sigrity.orbit.inter_substrate_checks.ReferenceCsvCheck;
import com.sigrity.orbit.ui.OrbitIcons;
import com.sigrity.orbit.ui.core.DesignView2D;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

public class ViolationPanel {
    public static JPanel getViolationPanel(PinMapCheck.Violation violation) {
        if (violation instanceof NetMappingCheck.NetMappingViolation) {
            return ViolationPanel.getNetMappingViolationPanel(violation);
        }
        if (violation instanceof PinDirectionCheck.PinDirectionViolation) {
            return ViolationPanel.getPinDirectionViolationPanel(violation);
        }
        if (violation instanceof PinCountMismatchCheck.PinCountMismatchViolation) {
            return ViolationPanel.getPinCountMismatchViolationPanel(violation);
        }
        if (violation instanceof PinUnmappedCheck.PinUnmappedViolation) {
            return ViolationPanel.getPinUnmappedViolationPanel(violation);
        }
        if (violation instanceof PortContactCheck.PortContactViolation) {
            return ViolationPanel.getPortContactViolationPanel(violation);
        }
        if (violation instanceof ReferenceCsvCheck.CsvInputViolation) {
            return ViolationPanel.getCsvInputViolationPanel(violation);
        }
        if (violation instanceof ReferenceCsvCheck.CsvFloatingPinViolation) {
            return ViolationPanel.getCsvFloatingPinViolationPanel(violation);
        }
        if (violation instanceof ReferenceCsvCheck.CsvPinCountMismatchViolation) {
            return ViolationPanel.getCsvPinCountMismatchViolationPanel(violation);
        }
        if (violation instanceof ReferenceCsvCheck.CsvPinLayerViolation) {
            return ViolationPanel.getCsvPinLayerViolationPanel(violation);
        }
        if (violation instanceof ReferenceCsvCheck.CsvRemovedViolation) {
            return ViolationPanel.getCsvRemovedViolationPanel(violation);
        }
        if (violation instanceof ReferenceCsvCheck.CsvAddedViolation) {
            return ViolationPanel.getCsvAddedViolationPanel(violation);
        }
        if (violation instanceof PinOffsetCheck.PinOffsetViolation) {
            return ViolationPanel.getPinOffsetViolationPanel(violation);
        }
        return null;
    }

    protected static JPanel getNetMappingViolationPanel(PinMapCheck.Violation violation) {
        assert (violation instanceof NetMappingCheck.NetMappingViolation);
        return new NetMappingViolationPanel((NetMappingCheck.NetMappingViolation)violation);
    }

    protected static JPanel getPinDirectionViolationPanel(PinMapCheck.Violation violation) {
        assert (violation instanceof PinDirectionCheck.PinDirectionViolation);
        return new PinDirectionViolationPanel((PinDirectionCheck.PinDirectionViolation)violation);
    }

    protected static JPanel getPinCountMismatchViolationPanel(PinMapCheck.Violation violation) {
        assert (violation instanceof PinCountMismatchCheck.PinCountMismatchViolation);
        return new PinCountMismatchViolationPanel((PinCountMismatchCheck.PinCountMismatchViolation)violation);
    }

    protected static JPanel getPinUnmappedViolationPanel(PinMapCheck.Violation violation) {
        assert (violation instanceof PinUnmappedCheck.PinUnmappedViolation);
        return new PinUnmappedViolationPanel((PinUnmappedCheck.PinUnmappedViolation)violation);
    }

    protected static JPanel getPortContactViolationPanel(PinMapCheck.Violation violation) {
        assert (violation instanceof PortContactCheck.PortContactViolation);
        return PortContactViolationPanel.get((PortContactCheck.PortContactViolation)violation);
    }

    private static JPanel getCsvInputViolationPanel(PinMapCheck.Violation violation) {
        assert (violation instanceof ReferenceCsvCheck.CsvInputViolation);
        return new CsvInputViolationPanel((ReferenceCsvCheck.CsvInputViolation)violation);
    }

    private static JPanel getCsvFloatingPinViolationPanel(PinMapCheck.Violation violation) {
        assert (violation instanceof ReferenceCsvCheck.CsvFloatingPinViolation);
        return new CsvFloatingPinViolationPanel((ReferenceCsvCheck.CsvFloatingPinViolation)violation);
    }

    private static JPanel getCsvPinCountMismatchViolationPanel(PinMapCheck.Violation violation) {
        assert (violation instanceof ReferenceCsvCheck.CsvPinCountMismatchViolation);
        return new CsvPinCountMismatchViolationPanel((ReferenceCsvCheck.CsvPinCountMismatchViolation)violation);
    }

    private static JPanel getCsvPinLayerViolationPanel(PinMapCheck.Violation violation) {
        assert (violation instanceof ReferenceCsvCheck.CsvPinLayerViolation);
        return new CsvPinLayerViolationPanel((ReferenceCsvCheck.CsvPinLayerViolation)violation);
    }

    private static JPanel getCsvRemovedViolationPanel(PinMapCheck.Violation violation) {
        assert (violation instanceof ReferenceCsvCheck.CsvRemovedViolation);
        return new CsvRemovedViolationPanel((ReferenceCsvCheck.CsvRemovedViolation)violation);
    }

    private static JPanel getCsvAddedViolationPanel(PinMapCheck.Violation violation) {
        assert (violation instanceof ReferenceCsvCheck.CsvAddedViolation);
        return new CsvAddedViolationPanel((ReferenceCsvCheck.CsvAddedViolation)violation);
    }

    private static JPanel getPinOffsetViolationPanel(PinMapCheck.Violation violation) {
        assert (violation instanceof PinOffsetCheck.PinOffsetViolation);
        return new PinOffsetViolationPanel((PinOffsetCheck.PinOffsetViolation)violation);
    }

    public static class PortInformationPanel
    extends JPanel {
        static HashMap<HierInst<PortTemplate>, PortInformationPanel> portInformationPanels = new HashMap();
        DevicePath portPath;
        PortTemplate port;
        JPanel toolBarPanel;

        static PortInformationPanel getPanel(DevicePath portPath, PortTemplate port) {
            HierInst hierPin = HierInst.create((DevicePath)portPath, (DbObject)port);
            return PortInformationPanel.getPanel((HierInst<PortTemplate>)hierPin);
        }

        static PortInformationPanel getPanel(HierInst<PortTemplate> hierPin) {
            if (portInformationPanels.containsKey(hierPin)) {
                return portInformationPanels.get(hierPin);
            }
            PortInformationPanel pinPanel = new PortInformationPanel(hierPin.getPath(), (PortTemplate)hierPin.getSecond());
            portInformationPanels.put(hierPin, pinPanel);
            return pinPanel;
        }

        private PortInformationPanel(DevicePath pinPath, PortTemplate pin) {
            this.portPath = pinPath;
            this.port = pin;
            this.initPanel();
        }

        void initPanel() {
            this.setBorder(BorderFactory.createTitledBorder("Port"));
            GridBagManager l = new GridBagManager((Container)this);
            InfoPanel infoPanel = new InfoPanel();
            l.add((Component)infoPanel, (GridBagConstraints)GridBagManager.LEFT);
            this.toolBarPanel = new JPanel();
            ActionPanel actionPanel = new ActionPanel();
            this.toolBarPanel.add((Component)actionPanel, GridBagManager.LEFT_REMAINX);
            l.add((Component)this.toolBarPanel);
            l.addFillX();
            this.setMinimumSize(this.getPreferredSize());
        }

        private boolean isSelectedPin() {
            if (this.port.getDb() == null) {
                return false;
            }
            Selection curSelection = Selection.getCurrentSelectionForDb((Db)this.port.getDb());
            return this.portPath.getAllFullPaths().noneMatch(path -> curSelection.contains(path, (DbObject)this.port));
        }

        protected class ZoomToBtn
        extends JButton
        implements ActionListener {
            protected ZoomToBtn() {
                this.addActionListener(this);
                this.setIcon(OrbitIcons.ZOOM_FIT);
                this.setPreferredSize(new Dimension(25, 25));
                this.setToolTipText("Zoom To");
                this.setOpaque(false);
                this.setBackground(Color.WHITE);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ARect bounds = PortInformationPanel.this.port.getBounds().transform(PortInformationPanel.this.portPath.getAFullPath().getTransform()).getBounds();
                if (bounds == null) {
                    return;
                }
                DesignView2D v = (DesignView2D)OrbitIO.getCurView();
                bounds.changeSizeBy(0.1);
                v.getCanvas().getXForm().setWorld(bounds);
                v.getCanvas().refresh();
                OrbitIO.getApp().refreshCurrentView(false);
            }

            @Override
            public void paint(Graphics g) {
                super.paint(g);
            }
        }

        protected class ShowMeBtn
        extends JButton
        implements ActionListener {
            protected ShowMeBtn() {
                this.addActionListener(this);
                this.setIcon(OrbitIcons.SHOW_ME);
                this.setPreferredSize(new Dimension(25, 25));
                this.setToolTipText("Show Me");
                this.setOpaque(false);
                this.setBackground(Color.WHITE);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                PortInformationPanel.this.portPath.getAllFullPaths().forEach(path -> ShowMeTheWay.addHierPort(path, PortInformationPanel.this.port));
            }

            @Override
            public void paint(Graphics g) {
                super.paint(g);
            }
        }

        protected class SelectedToggleBtn
        extends JToggleButton
        implements ActionListener {
            Db curDb;
            Selection curSelection;

            protected SelectedToggleBtn() {
                this.curDb = PortInformationPanel.this.port.getDb();
                this.curSelection = Selection.getCurrentSelectionForDb((Db)this.curDb);
                this.addActionListener(this);
                this.setIcon(OrbitIcons.SELECT_PORT);
                this.setPreferredSize(new Dimension(25, 25));
                this.setToolTipText("Selected");
                this.setOpaque(false);
                this.setBackground(Color.WHITE);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PortInformationPanel.this.isSelectedPin()) {
                    this.removeSelected();
                } else {
                    this.addSelected();
                }
                OrbitIO.getApp().refreshCurrentView();
                this.setSelected(PortInformationPanel.this.isSelectedPin());
                this.repaint();
            }

            @Override
            public void paint(Graphics g) {
                this.setSelected(PortInformationPanel.this.isSelectedPin());
                super.paint(g);
            }

            private void removeSelected() {
                PortInformationPanel.this.portPath.getAllFullPaths().forEach(path -> this.curSelection.remove(path, (DbObject)PortInformationPanel.this.port));
            }

            private void addSelected() {
                PortInformationPanel.this.portPath.getAllFullPaths().filter(path -> !this.curSelection.contains(path, (DbObject)PortInformationPanel.this.port)).forEach(path -> this.curSelection.add(path, (DbObject)PortInformationPanel.this.port));
            }
        }

        private class ActionPanel
        extends JPanel {
            private ActionPanel() {
                GridBagManager l = new GridBagManager((Container)this);
                l.add((Component)new SelectedToggleBtn(), (GridBagConstraints)GridBagManager.TOPRIGHT.noInsets());
                l.add((Component)new ShowMeBtn(), (GridBagConstraints)GridBagManager.TOPRIGHT.noInsets());
                l.add((Component)new ZoomToBtn(), (GridBagConstraints)GridBagManager.TOPRIGHT.noInsets());
                l.newline();
            }
        }

        private class InfoPanel
        extends JPanel {
            private InfoPanel() {
                GridBagManager l = new GridBagManager((Container)this);
                JLabel nameLabel = new JLabel(String.format("Pin Name: %s", PortInformationPanel.this.port.getPinTemplate().getName()));
                l.add((Component)nameLabel);
                l.newline();
                JLabel portNumLabel = new JLabel(String.format("Port Num: %s", PortInformationPanel.this.port.getPortNum()));
                l.add((Component)portNumLabel);
                l.newline();
                JLabel devicePathLabel = new JLabel(String.format("DevicePath: %s", PortInformationPanel.this.portPath.toString()));
                l.add((Component)devicePathLabel);
                l.newline();
            }
        }
    }

    public static class PinInformationPanel
    extends JPanel {
        static HashMap<HierInst<PinTemplate>, JPanel> pinInformationPanels = new HashMap();
        DevicePath pinPath;
        PinTemplate pin;

        static JPanel getPanel(DevicePath pinPath, PinTemplate pin) {
            HierInst hierPin = HierInst.create((DevicePath)pinPath, (DbObject)pin);
            return PinInformationPanel.getPanel((HierInst<PinTemplate>)hierPin);
        }

        static JPanel getPanel(HierInst<PinTemplate> hierPin) {
            if (pinInformationPanels.containsKey(hierPin)) {
                return pinInformationPanels.get(hierPin);
            }
            PinInformationPanel pinPanel = new PinInformationPanel(hierPin.getPath(), (PinTemplate)hierPin.getSecond());
            pinInformationPanels.put(hierPin, pinPanel);
            return pinPanel;
        }

        private PinInformationPanel(DevicePath pinPath, PinTemplate pin) {
            this.pinPath = pinPath;
            this.pin = pin;
            this.initPanel();
        }

        private void initPanel() {
            this.setBorder(BorderFactory.createTitledBorder("Pin"));
            GridBagManager l = new GridBagManager((Container)this);
            InfoPanel infoPanel = new InfoPanel();
            l.add((Component)infoPanel, (GridBagConstraints)GridBagManager.LEFT);
            ActionPanel actionPanel = new ActionPanel();
            l.add((Component)actionPanel, (GridBagConstraints)GridBagManager.LEFT_REMAINX);
            l.addFillX();
            this.setMinimumSize(this.getPreferredSize());
        }

        private boolean isSelectedPin() {
            Db db = this.pin.getDb();
            if (db == null) {
                return false;
            }
            Selection curSelection = Selection.getCurrentSelectionForDb((Db)db);
            return this.pinPath.getAllFullPaths().noneMatch(path -> curSelection.contains(path, (DbObject)this.pin.getPinInstance(path)));
        }

        protected class ZoomToBtn
        extends JButton
        implements ActionListener {
            protected ZoomToBtn() {
                this.addActionListener(this);
                this.setIcon(OrbitIcons.ZOOM_FIT);
                this.setPreferredSize(new Dimension(25, 25));
                this.setToolTipText("Zoom To");
                this.setOpaque(false);
                this.setBackground(Color.WHITE);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ARect bounds = PinInformationPanel.this.pin.getBounds().transform(PinInformationPanel.this.pinPath.getAFullPath().getTransform()).getBounds();
                if (bounds == null) {
                    return;
                }
                DesignView2D v = (DesignView2D)OrbitIO.getCurView();
                bounds.changeSizeBy(0.1);
                v.getCanvas().getXForm().setWorld(bounds);
                v.getCanvas().refresh();
                OrbitIO.getApp().refreshCurrentView(false);
            }

            @Override
            public void paint(Graphics g) {
                super.paint(g);
            }
        }

        protected class ShowMeBtn
        extends JButton
        implements ActionListener {
            protected ShowMeBtn() {
                this.addActionListener(this);
                this.setIcon(OrbitIcons.SHOW_ME);
                this.setPreferredSize(new Dimension(25, 25));
                this.setToolTipText("Show Me");
                this.setOpaque(false);
                this.setBackground(Color.WHITE);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                PinInformationPanel.this.pinPath.getAllFullPaths().forEach(path -> PinInformationPanel.this.pin.getPortTemplates().forEach(port -> ShowMeTheWay.addHierPort(path, port)));
            }

            @Override
            public void paint(Graphics g) {
                super.paint(g);
            }
        }

        protected class SelectedCheckBox
        extends JToggleButton
        implements ActionListener {
            Db curDb;
            Selection curSelection;

            protected SelectedCheckBox() {
                this.curDb = PinInformationPanel.this.pin.getDb();
                this.curSelection = Selection.getCurrentSelectionForDb((Db)this.curDb);
                this.addActionListener(this);
                this.setIcon(OrbitIcons.SELECT_PORT);
                this.setPreferredSize(new Dimension(25, 25));
                this.setToolTipText("Selected");
                this.setOpaque(false);
                this.setBackground(Color.WHITE);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PinInformationPanel.this.isSelectedPin()) {
                    this.removeSelected();
                } else {
                    this.addSelected();
                }
                OrbitIO.getApp().refreshCurrentView();
                this.setSelected(PinInformationPanel.this.isSelectedPin());
                this.repaint();
            }

            @Override
            public void paint(Graphics g) {
                this.setSelected(PinInformationPanel.this.isSelectedPin());
                super.paint(g);
            }

            private void removeSelected() {
                PinInformationPanel.this.pinPath.getAllFullPaths().forEach(path -> this.curSelection.remove(path, (DbObject)PinInformationPanel.this.pin.getPinInstance(path)));
            }

            private void addSelected() {
                PinInformationPanel.this.pinPath.getAllFullPaths().filter(path -> !this.curSelection.contains(path, (DbObject)PinInformationPanel.this.pin.getPinInstance(path))).forEach(path -> this.curSelection.add(path, (DbObject)PinInformationPanel.this.pin.getPinInstance(path)));
            }
        }

        private class ActionPanel
        extends JPanel {
            private ActionPanel() {
                GridBagManager l = new GridBagManager((Container)this);
                l.add((Component)new SelectedCheckBox(), (GridBagConstraints)GridBagManager.TOPRIGHT.noInsets());
                l.add((Component)new ShowMeBtn(), (GridBagConstraints)GridBagManager.TOPRIGHT.noInsets());
                l.add((Component)new ZoomToBtn(), (GridBagConstraints)GridBagManager.TOPRIGHT.noInsets());
                l.newline();
            }
        }

        private class InfoPanel
        extends JPanel {
            private InfoPanel() {
                GridBagManager l = new GridBagManager((Container)this);
                JLabel nameLabel = new JLabel(String.format("Name: %s", PinInformationPanel.this.pin.getName()));
                l.add((Component)nameLabel);
                l.newline();
                JLabel devicePathLabel = new JLabel(String.format("DevicePath: %s", PinInformationPanel.this.pinPath.toString()));
                l.add((Component)devicePathLabel);
                l.newline();
                Net substrateNet = null;
                DevicePath pathToSubstrate = PinInformationPanel.this.pinPath.pathToSubstrate();
                substrateNet = pathToSubstrate == null ? NetMap.getTopmostNet((Net)PinInformationPanel.this.pin.getNet(), (DevicePath)PinInformationPanel.this.pinPath) : NetMap.getTopmostNet((Net)PinInformationPanel.this.pin.getNet(), (DevicePath)PinInformationPanel.this.pinPath.getRelativePathFromAnchor(PinInformationPanel.this.pinPath.pathToSubstrate().getDeviceTemplate()));
                JLabel netLabel = new JLabel(String.format("Net: %s", substrateNet.getName()));
                l.add((Component)netLabel);
                l.newline();
                JLabel directionLabel = new JLabel(String.format("Direction: %s", PinInformationPanel.this.pin.getDirection()));
                l.add((Component)directionLabel);
                l.newline();
            }
        }
    }

    public static class ContactLayerInfoPanel
    extends JPanel {
        public ContactLayerInfoPanel(ContactLayer contactLayer) {
            this.setBorder(BorderFactory.createTitledBorder("Contact Layer"));
            GridBagManager l = new GridBagManager((Container)this);
            JLabel ownerLabel = new JLabel(String.format("Owner: %s", contactLayer.getOwner().getName()));
            l.add((Component)ownerLabel);
            l.newline();
            JLabel devicePathALabel = new JLabel(String.format("DevicePathA: %s", contactLayer.getDevicePathA().getRelativePathFromRoot().toString()));
            l.add((Component)devicePathALabel);
            l.newline();
            JLabel layerALabel = new JLabel(String.format("LayerA: %s", contactLayer.getContactLayerA().getName()));
            l.add((Component)layerALabel);
            l.newline();
            JLabel devicePathBLabel = new JLabel(String.format("DevicePathB: %s", contactLayer.getDevicePathB().getRelativePathFromRoot().toString()));
            l.add((Component)devicePathBLabel);
            l.newline();
            JLabel layerBLabel = new JLabel(String.format("LayerB: %s", contactLayer.getContactLayerB().getName()));
            l.add((Component)layerBLabel);
            l.newline();
            l.addFillX();
            this.setMinimumSize(this.getPreferredSize());
        }
    }

    public static class CsvPinMapInfoPanel
    extends JPanel {
        public CsvPinMapInfoPanel(PinMapCsvReader.CsvPinMap csvPinMap) {
            this.setBorder(BorderFactory.createTitledBorder("Csv Pin Map"));
            GridBagManager l = new GridBagManager((Container)this);
            JPanel pinAPanel = CsvPinInformationPanel.getPanel(csvPinMap.getPinPathA(), csvPinMap.getPinA());
            l.add((Component)pinAPanel, (GridBagConstraints)GridBagManager.FILLALL_REMAINX);
            l.newline();
            JPanel pinBPanel = CsvPinInformationPanel.getPanel(csvPinMap.getPinPathB(), csvPinMap.getPinB());
            l.add((Component)pinBPanel, (GridBagConstraints)GridBagManager.FILLALL_REMAINX);
            l.newline();
            l.addFillX();
            this.setMinimumSize(this.getPreferredSize());
        }

        public static class CsvPinInformationPanel
        extends JPanel {
            String pinPath;
            String pin;

            static JPanel getPanel(String pinPath, String pin) {
                CsvPinInformationPanel pinPanel = new CsvPinInformationPanel(pinPath, pin);
                return pinPanel;
            }

            private CsvPinInformationPanel(String pinPath, String pin) {
                this.pinPath = pinPath;
                this.pin = pin;
                this.initPanel();
            }

            private void initPanel() {
                this.setBorder(BorderFactory.createTitledBorder("Pin"));
                GridBagManager l = new GridBagManager((Container)this);
                JLabel devicePathLabel = new JLabel(String.format("DevicePath: %s", this.pinPath));
                l.add((Component)devicePathLabel);
                l.newline();
                JLabel directionLabel = new JLabel(String.format("Port: %s", this.pin));
                l.add((Component)directionLabel);
                l.newline();
                l.addFillX();
                this.setMinimumSize(this.getPreferredSize());
            }
        }
    }

    public static class RefPinMapInfoPanel
    extends JPanel {
        public RefPinMapInfoPanel(ReferenceCsvCheck.ReferencePinMap refPinMap) {
            this.setBorder(BorderFactory.createTitledBorder(String.format("Csv Pin Map", new Object[0])));
            GridBagManager l = new GridBagManager((Container)this);
            JPanel pinAPanel = PinInformationPanel.getPanel(refPinMap.getPinPathA(), refPinMap.getPinA());
            l.add((Component)pinAPanel, (GridBagConstraints)GridBagManager.FILLALL_REMAINX);
            l.newline();
            JPanel pinBPanel = PinInformationPanel.getPanel(refPinMap.getPinPathB(), refPinMap.getPinB());
            l.add((Component)pinBPanel, (GridBagConstraints)GridBagManager.FILLALL_REMAINX);
            l.newline();
            l.addFillX();
            this.setMinimumSize(this.getPreferredSize());
        }
    }

    public static class PinMapInfoPanel
    extends JPanel {
        JPanel toolsBarPanel;

        public PinMapInfoPanel(PinMap pinMap) {
            this.setBorder(BorderFactory.createTitledBorder("Pin Map"));
            GridBagManager l = new GridBagManager((Container)this);
            JPanel headerPanel = new JPanel();
            GridBagManager headerL = new GridBagManager((Container)headerPanel);
            JLabel ownerLabel = new JLabel(String.format("Owner: %s", pinMap.getOwner().getName()));
            headerL.add((Component)ownerLabel);
            headerL.newline();
            l.add((Component)headerPanel);
            this.toolsBarPanel = new JPanel();
            l.add((Component)this.toolsBarPanel);
            l.newline();
            JPanel pinAPanel = PinInformationPanel.getPanel(pinMap.getPinAPath(), pinMap.getPinA());
            l.add((Component)pinAPanel, (GridBagConstraints)GridBagManager.FILLX);
            l.newline();
            JPanel pinBPanel = PinInformationPanel.getPanel(pinMap.getPinBPath(), pinMap.getPinB());
            l.add((Component)pinBPanel, (GridBagConstraints)GridBagManager.FILLX);
            l.newline();
            l.addFillX();
            this.setMinimumSize(this.getPreferredSize());
        }

        public void addAutoFixPanel(JPanel autoFixPanel) {
            this.toolsBarPanel.add(autoFixPanel);
        }
    }

    public static class PinOffsetViolationPanel
    extends JPanel {
        PinOffsetCheck.PinOffsetViolation mViolation;
        Unit mUnit;

        PinOffsetViolationPanel(PinOffsetCheck.PinOffsetViolation violation) {
            this.mViolation = violation;
            this.initPanel();
        }

        private void initPanel() {
            GridBagManager l = new GridBagManager((Container)this);
            l.add((Component)new JLabel(String.format("Maximum offset: %f", this.mViolation.getMaxOffset())));
            l.newline();
            l.add((Component)new JLabel(String.format("Current offset: %f", this.mViolation.getCurOffset())));
            l.newline();
            PortInformationPanel portPanelA = PortInformationPanel.getPanel(this.mViolation.getHierPortA());
            l.add((Component)portPanelA, (GridBagConstraints)GridBagManager.FILLX);
            l.newline();
            PortInformationPanel portPanelB = PortInformationPanel.getPanel(this.mViolation.getHierPortB());
            l.add((Component)portPanelB, (GridBagConstraints)GridBagManager.FILLX);
            l.newline();
            l.addFillX();
            this.setMinimumSize(this.getPreferredSize());
        }
    }

    public static class CsvAddedViolationPanel
    extends JPanel {
        ReferenceCsvCheck.CsvAddedViolation mViolation;

        CsvAddedViolationPanel(ReferenceCsvCheck.CsvAddedViolation violation) {
            this.mViolation = violation;
            this.initPanel();
        }

        private void initPanel() {
            GridBagManager l = new GridBagManager((Container)this);
            l.add((Component)new JLabel("The pin map in the csv file is not exist in the design"));
            l.newline();
            l.add((Component)new RefPinMapInfoPanel(this.mViolation.getPinMap()), (GridBagConstraints)GridBagManager.LEFT_REMAINX);
            l.newline();
            l.addFillX();
            this.setMinimumSize(this.getPreferredSize());
        }
    }

    public static class CsvRemovedViolationPanel
    extends JPanel {
        ReferenceCsvCheck.CsvRemovedViolation mViolation;

        CsvRemovedViolationPanel(ReferenceCsvCheck.CsvRemovedViolation violation) {
            this.mViolation = violation;
            this.initPanel();
        }

        private void initPanel() {
            GridBagManager l = new GridBagManager((Container)this);
            l.add((Component)new JLabel("The pin map in the design is not exist in the csv file"));
            l.newline();
            l.add((Component)new PinMapInfoPanel(this.mViolation.getPinMap()), (GridBagConstraints)GridBagManager.LEFT_REMAINX);
            l.newline();
            l.addFillX();
            this.setMinimumSize(this.getPreferredSize());
        }
    }

    public static class CsvPinLayerViolationPanel
    extends JPanel {
        ReferenceCsvCheck.CsvPinLayerViolation mViolation;

        CsvPinLayerViolationPanel(ReferenceCsvCheck.CsvPinLayerViolation violation) {
            this.mViolation = violation;
            this.initPanel();
        }

        private void initPanel() {
            GridBagManager l = new GridBagManager((Container)this);
            l.add((Component)new JLabel("Two connected pins in csv file are not on the contact layer"));
            l.newline();
            l.add((Component)new RefPinMapInfoPanel(this.mViolation.getPinMap()), (GridBagConstraints)GridBagManager.LEFT_REMAINX);
            l.newline();
            l.addFillX();
            this.setMinimumSize(this.getPreferredSize());
        }
    }

    public static class CsvPinCountMismatchViolationPanel
    extends JPanel {
        ReferenceCsvCheck.CsvPinCountMismatchViolation mViolation;

        CsvPinCountMismatchViolationPanel(ReferenceCsvCheck.CsvPinCountMismatchViolation violation) {
            this.mViolation = violation;
            this.initPanel();
        }

        private void initPanel() {
            GridBagManager l = new GridBagManager((Container)this);
            l.add((Component)new JLabel("A pin has multiple contact pins in the csv file."));
            l.newline();
            l.add((Component)PinInformationPanel.getPanel(this.mViolation.getHierPin()), (GridBagConstraints)GridBagManager.LEFT_REMAINX);
            l.newline();
            l.addFillX();
            this.setMinimumSize(this.getPreferredSize());
        }
    }

    public static class CsvFloatingPinViolationPanel
    extends JPanel {
        ReferenceCsvCheck.CsvFloatingPinViolation mViolation;

        CsvFloatingPinViolationPanel(ReferenceCsvCheck.CsvFloatingPinViolation violation) {
            this.mViolation = violation;
            this.initPanel();
        }

        private void initPanel() {
            GridBagManager l = new GridBagManager((Container)this);
            l.add((Component)new JLabel("The pin is on the contact layer but does not define in the csv file."));
            l.newline();
            l.add((Component)PinInformationPanel.getPanel(this.mViolation.getHierPin()), (GridBagConstraints)GridBagManager.LEFT_REMAINX);
            l.newline();
            l.add((Component)new ContactLayerInfoPanel(this.mViolation.getContactLayer()), (GridBagConstraints)GridBagManager.LEFT_REMAINX);
            l.newline();
            l.addFillX();
            this.setMinimumSize(this.getPreferredSize());
        }
    }

    public static class CsvInputViolationPanel
    extends JPanel {
        ReferenceCsvCheck.CsvInputViolation mViolation;

        CsvInputViolationPanel(ReferenceCsvCheck.CsvInputViolation violation) {
            this.mViolation = violation;
            this.initPanel();
        }

        private void initPanel() {
            GridBagManager l = new GridBagManager((Container)this);
            l.add((Component)new ErrorInputPanel(), (GridBagConstraints)GridBagManager.LEFT_REMAINX);
            l.newline();
            l.add((Component)new CsvPinMapInfoPanel(this.mViolation.getPinMap()), (GridBagConstraints)GridBagManager.LEFT_REMAINX);
            l.newline();
            l.addFillX();
            this.setMinimumSize(this.getPreferredSize());
        }

        class ErrorInputPanel
        extends JPanel {
            ErrorInputPanel() {
                this.setBorder(BorderFactory.createTitledBorder("Error input"));
                GridBagManager l = new GridBagManager((Container)this);
                CsvInputViolationPanel.this.mViolation.getErrorPath().forEach(path -> {
                    l.add((Component)new JLabel(String.format("Cannot find a devicePath %s", path)));
                    l.newline();
                });
                CsvInputViolationPanel.this.mViolation.getErrorPinOnPath().forEach(pinAndPath -> {
                    l.add((Component)new JLabel(String.format("Cannot find a pin %s on the devicePath %s", pinAndPath.first, pinAndPath.second)));
                    l.newline();
                });
                l.addFillX();
                this.setMinimumSize(this.getPreferredSize());
            }
        }
    }

    public static class PortContactViolationPanel
    extends JPanel {
        private static HashMap<PortContactCheck.PortContactViolation, PortContactViolationPanel> violation2Panel = new HashMap();
        PortContactCheck.PortContactViolation mViolation;

        public static PortContactViolationPanel get(PortContactCheck.PortContactViolation violation) {
            PortContactViolationPanel panel = violation2Panel.get(violation);
            if (panel == null) {
                panel = new PortContactViolationPanel(violation);
                violation2Panel.put(violation, panel);
            }
            return panel;
        }

        private PortContactViolationPanel(PortContactCheck.PortContactViolation violation) {
            this.mViolation = violation;
            this.initPanel();
        }

        private void initPanel() {
            GridBagManager l = new GridBagManager((Container)this);
            l.add((Component)new JLabel("A port is on contact layer, but does not have a contact port."));
            l.newline();
            PortInformationPanel portPanel = PortInformationPanel.getPanel(this.mViolation.getHierPort());
            l.add((Component)portPanel, (GridBagConstraints)GridBagManager.FILLX);
            l.newline();
            l.add((Component)new ContactLayerInfoPanel(this.mViolation.getContactLayer()), (GridBagConstraints)GridBagManager.FILLX);
            l.newline();
            l.addFillX();
            this.setMinimumSize(this.getPreferredSize());
        }
    }

    public static class PinUnmappedViolationPanel
    extends JPanel {
        PinUnmappedCheck.PinUnmappedViolation mViolation;

        PinUnmappedViolationPanel(PinUnmappedCheck.PinUnmappedViolation violation) {
            this.mViolation = violation;
            this.initPanel();
        }

        private void initPanel() {
            GridBagManager l = new GridBagManager((Container)this);
            l.add((Component)new JLabel("A pin on the contact layer but does not have a contact pin."));
            l.newline();
            JPanel pinPanel = PinInformationPanel.getPanel(this.mViolation.getPinPath(), this.mViolation.getPin());
            l.add((Component)pinPanel, (GridBagConstraints)GridBagManager.FILLX);
            l.newline();
            ContactLayerInfoPanel contactLayerPanel = new ContactLayerInfoPanel(this.mViolation.getContactLayer());
            l.add((Component)contactLayerPanel, (GridBagConstraints)GridBagManager.FILLX);
            l.newline();
            l.addFillX();
            this.setMinimumSize(this.getPreferredSize());
        }
    }

    public static class PinCountMismatchViolationPanel
    extends JPanel {
        PinCountMismatchCheck.PinCountMismatchViolation mViolation;

        PinCountMismatchViolationPanel(PinCountMismatchCheck.PinCountMismatchViolation violation) {
            this.mViolation = violation;
            this.initPanel();
        }

        private void initPanel() {
            GridBagManager l = new GridBagManager((Container)this);
            l.add((Component)new JLabel("A pin has multiple contact pins."));
            l.newline();
            LinkedList pinMapInfoPanels = new LinkedList();
            this.mViolation.getPinMaps().forEach(pm -> pinMapInfoPanels.add(new PinMapInfoPanel((PinMap)pm)));
            JPanel pinPanel = PinInformationPanel.getPanel(this.mViolation.getPinPath(), this.mViolation.getPin());
            l.add((Component)pinPanel, (GridBagConstraints)GridBagManager.FILLX_REMAINX);
            l.newline();
            JPanel pinMapsPanel = new JPanel();
            pinMapInfoPanels.forEach(panel -> pinMapsPanel.add((Component)panel, GridBagManager.LEFT.noInsets()));
            l.add((Component)pinMapsPanel, (GridBagConstraints)GridBagManager.LEFT_REMAINX);
            l.newline();
            l.addFillX();
            this.setMinimumSize(this.getPreferredSize());
        }
    }

    public static class PinDirectionViolationPanel
    extends JPanel {
        PinDirectionCheck.PinDirectionViolation mViolation;

        PinDirectionViolationPanel(PinDirectionCheck.PinDirectionViolation violation) {
            this.mViolation = violation;
            this.initPanel();
        }

        private void initPanel() {
            GridBagManager l = new GridBagManager((Container)this);
            l.add((Component)new JLabel("Two pins contact each other but do not have opposite directions"));
            l.newline();
            l.add((Component)new PinMapInfoPanel(this.mViolation.getPinMap()), (GridBagConstraints)GridBagManager.LEFT_REMAINX);
            l.newline();
            l.addFillX();
            this.setMinimumSize(this.getPreferredSize());
        }
    }

    public static class NetMappingViolationPanel
    extends JPanel {
        static HashMap<NetMappingCheck.NetMappingViolation, NetMappingViolationPanel> violation2Panel = new HashMap();
        NetMappingCheck.NetMappingViolation mViolation;

        static NetMappingViolationPanel get(NetMappingCheck.NetMappingViolation violation) {
            NetMappingViolationPanel panel = violation2Panel.get(violation);
            if (panel == null) {
                panel = new NetMappingViolationPanel(violation);
                violation2Panel.put(violation, panel);
            }
            return panel;
        }

        NetMappingViolationPanel(NetMappingCheck.NetMappingViolation violation) {
            this.mViolation = violation;
            this.initPanel();
        }

        private void initPanel() {
            GridBagManager l = new GridBagManager((Container)this);
            l.add((Component)new JLabel("Two pins contact each other but do not have a net mapping"));
            l.newline();
            PinMapInfoPanel pinMapInfoPanel = new PinMapInfoPanel(this.mViolation.getPinMap());
            l.add((Component)pinMapInfoPanel, (GridBagConstraints)GridBagManager.LEFT_REMAINX);
            l.newline();
            l.addFillX();
            this.setMinimumSize(this.getPreferredSize());
        }
    }
}

