/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.iov;

import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.orbit.iov.Dim2D;
import com.sigrity.orbit.iov.IOView;
import com.sigrity.orbit.iov.IOViewBlock;
import com.sigrity.orbit.iov.IOViewDlg;
import com.sigrity.orbit.iov.LayoutManager;
import java.util.List;

abstract class AbstractLayoutManager
implements LayoutManager {
    private IOView mIOV;

    AbstractLayoutManager() {
    }

    public IOView getIOV() {
        return this.mIOV;
    }

    public void setIOV(IOView iOV) {
        this.mIOV = iOV;
    }

    @Override
    public void reset(IOView iov) {
        this.setIOV(iov);
    }

    void clearIOCellGap() {
        for (int side = 0; side < 4; ++side) {
            this.mIOV.mBlocks.get(side).parallelStream().flatMap(personality -> personality.children.parallelStream()).forEach(b -> {
                b.gap = 0L;
            });
        }
    }

    void clearIOCellGapInset() {
        for (int side = 0; side < 4; ++side) {
            this.mIOV.mBlocks.get(side).parallelStream().flatMap(personality -> personality.children.parallelStream()).forEach(b -> {
                b.gap = 0L;
                b.inset = 0L;
            });
        }
    }

    void clearPersonalityGap() {
        for (int side = 0; side < 4; ++side) {
            this.mIOV.mBlocks.get(side).parallelStream().forEach(b -> {
                b.gap = 0L;
            });
        }
    }

    void clearPersonalityGapInset() {
        for (int side = 0; side < 4; ++side) {
            this.mIOV.mBlocks.get(side).parallelStream().forEach(b -> {
                b.gap = 0L;
                b.inset = 0L;
            });
        }
    }

    void clearPersonalityGapInsetMargins() {
        for (int side = 0; side < 4; ++side) {
            this.mIOV.mBlocks.get(side).parallelStream().forEach(b -> {
                b.gap = 0L;
                b.inset = 0L;
                b.marginLead = 0L;
                b.marginTrail = 0L;
            });
        }
    }

    void layoutMinimumDieSize(boolean allowCornerOverlap) {
        this.mIOV.setDelayBuilding(true);
        Dim2D top = this.getIOViewSideDimension(1);
        Dim2D left = this.getIOViewSideDimension(2);
        Dim2D bottom = this.getIOViewSideDimension(3);
        Dim2D right = this.getIOViewSideDimension(0);
        ARect bbStartingCornerRight = this.getFirstIOCellBB(0);
        ARect bbStartingCornerTop = this.getFirstIOCellBB(1);
        ARect bbStartingCornerLeft = this.getFirstIOCellBB(2);
        ARect bbStartingCornerBottom = this.getFirstIOCellBB(3);
        top = allowCornerOverlap ? top : new Dim2D(top.getWidth() + bbStartingCornerLeft.height(), top.getHeight());
        bottom = allowCornerOverlap ? bottom : new Dim2D(bottom.getWidth() + bbStartingCornerRight.height(), bottom.getHeight());
        right = allowCornerOverlap ? right : new Dim2D(right.getWidth() + bbStartingCornerTop.height(), right.getHeight());
        left = allowCornerOverlap ? left : new Dim2D(left.getWidth() + bbStartingCornerBottom.height(), left.getHeight());
        long width = Math.max(Math.max(top.getWidth(), bottom.getWidth()), Math.max(right.getHeight(), left.getHeight()));
        long height = Math.max(Math.max(right.getWidth(), left.getWidth()), Math.max(top.getHeight(), bottom.getHeight()));
        DeviceTemplate t = this.getIOV().getRootDevicePath().getDeviceTemplate();
        t.setBounds((AGeom)new ARect(0L, 0L, width, height));
        ARect bounds = this.mIOV.getRootDevicePath().getLast().getBB();
        bounds = new ARect(0L, 0L, bounds.width(), bounds.height());
        IOView.debugOutputPlacementDetails("LayoutManager before deriving placements");
        for (int side = 0; side < 4; ++side) {
            LayoutManager.deriveIOViewPlacement(this.mIOV.mBlocks.get(side));
        }
        IOView.debugOutputPlacementDetails("LayoutManager after deriving placements");
        LayoutManager.placement((APoint2D)IOViewDlg.Side.getSideInterfaceNameLoc((int)1, (ARect)bounds).second, 1, (List<IOViewBlock>)this.mIOV.mBlocks.get(1));
        LayoutManager.placement((APoint2D)IOViewDlg.Side.getSideInterfaceNameLoc((int)3, (ARect)bounds).second, 3, (List<IOViewBlock>)this.mIOV.mBlocks.get(3));
        LayoutManager.placement((APoint2D)IOViewDlg.Side.getSideInterfaceNameLoc((int)2, (ARect)bounds).second, 2, (List<IOViewBlock>)this.mIOV.mBlocks.get(2));
        LayoutManager.placement((APoint2D)IOViewDlg.Side.getSideInterfaceNameLoc((int)0, (ARect)bounds).second, 0, (List<IOViewBlock>)this.mIOV.mBlocks.get(0));
        this.mIOV.setDelayBuilding(false);
        IOView.somethingChanged();
    }

    private ARect getFirstIOCellBB(int side) {
        ARect rect;
        List sideBlocks = this.mIOV.mBlocks.get(side);
        try {
            IOViewBlock b = ((IOViewBlock)sideBlocks.get(0)).getChildren().stream().filter(iovb -> !iovb.isInPlacementGroup1()).findFirst().orElseThrow(() -> new IllegalArgumentException("No iopad child"));
            rect = b.devicePath.getLocalBB();
        }
        catch (Exception e) {
            rect = new ARect(0L, 0L, 0L, 0L);
        }
        return rect;
    }

    private Dim2D getIOViewSideDimension(int side) {
        LayoutManager.Placement sidePlacement = LayoutManager.deriveIOViewPlacement(this.mIOV.mBlocks.get(side));
        return new Dim2D(sidePlacement.getArea().width(), sidePlacement.getArea().height());
    }
}

