/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.iov;

import com.sigrity.acl.ALog;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitIO;

public class IOConnectionUtil {
    public static DevicePath getCoverCellForIOCell(DevicePath ioCellPath) {
        DevicePath interfacePath = ioCellPath.getParent();
        if (interfacePath == null) {
            return null;
        }
        ARect ioRect = ioCellPath.getBB();
        APoint2D ioCenter = ioRect.center();
        DevicePath coverPath = null;
        for (DevicePath candidatePath : interfacePath.getDescendants()) {
            ARect coverRect;
            Device candidate = candidatePath.getLast();
            if (!candidate.getIsOverlay() || !(coverRect = candidatePath.getBB()).contains(ioCenter)) continue;
            if (coverPath == null) {
                coverPath = candidatePath;
                continue;
            }
            ALog.logWarn((String)("More than on cover cell occludes " + ioCellPath.toString()));
        }
        return coverPath;
    }

    public static DevicePath getCoverCellForIOCell(String ioCellPathString) {
        DevicePath ioCellPath = DevicePath.fromString((Db)OrbitIO.getCurDb(), (String)ioCellPathString);
        if (ioCellPath == null) {
            return null;
        }
        DevicePath ret = IOConnectionUtil.getCoverCellForIOCell(ioCellPath);
        ALog.logInfo((String)ret.getString());
        return ret;
    }

    public static void mapIOPinsToCoverCell(Db db, String startPath) {
        if (db == null) {
            db = OrbitIO.getCurDb();
        }
        DevicePath path = DevicePath.fromString((Db)db, (String)startPath);
        IOConnectionUtil.mapIOPinsToCoverCell(path);
    }

    public static void mapIOPinsToCoverCell(DevicePath startPath) {
        if (startPath == null || startPath.isEmpty()) {
            ALog.logError((String)"A startPath Device must be specified.");
            return;
        }
        DevicePath diePath = startPath;
        while (!diePath.isEmpty() && diePath.getDeviceTemplate().getType() != DeviceTemplate.Type.DIE) {
            diePath = diePath.getParent();
        }
        if (diePath.isEmpty()) {
            ALog.logWarn((String)"Did not find Die device in specified starting path '%s', will map Nets to starting path.", (Object[])new Object[]{startPath.toString()});
            diePath = startPath;
        }
        block1: for (DevicePath curPath : startPath.getDescendants()) {
            DevicePath relPathToDie = curPath.getRelativePath(diePath.getDeviceTemplate());
            Device curDevice = curPath.getDevice();
            DevicePath coverPath = null;
            Device coverDev = null;
            DevicePath relPathCoverToDie = null;
            for (PinInstance curPin : curDevice.getPins()) {
                PinInstance coverPin;
                PinTemplate curPinTempl = curPin.getPinTemplate();
                if (curPinTempl.getType() != PinTemplate.Type.IOPAD) continue;
                if (coverPath == null) {
                    coverPath = IOConnectionUtil.getCoverCellForIOCell(curPath);
                    if (coverPath == null) {
                        ALog.logWarn((String)"Can not find cover cell for device '%s', not setting Nets or connecting pins for the device.", (Object[])new Object[]{curPath});
                        continue block1;
                    }
                    coverDev = coverPath.getDevice();
                    relPathCoverToDie = coverPath.getRelativePath(diePath.getDeviceTemplate());
                }
                if ((coverPin = coverDev.getPinByName(curPin.getName())) == null) {
                    ALog.logWarn((String)"Cover pin not found for device '%s' pin '%s', no Net will be set or cover pin connected.", (Object[])new Object[]{curPath, curPin.getName()});
                    continue;
                }
                Net net = curDevice.getTemplate().getNet(curPin.getName());
                if (net == null) {
                    net = curDevice.getTemplate().createNet(curPin.getName());
                }
                if (curPin.getNet() != net) {
                    curPin.setNet(net);
                }
                String parentNetName = String.format("%s_%s", curDevice.getName(), curPin.getName());
                NetMap.mapThroughPath((DevicePath)relPathToDie, (Net)net, (String)parentNetName);
                String coverNetName = coverPin.getName();
                Net coverNet = coverPin.getDeviceTemplate().getNet(coverNetName);
                if (coverNet == null) {
                    coverNet = coverPin.getDeviceTemplate().createNet(coverNetName);
                }
                if (coverPin.getNet() != coverNet) {
                    coverPin.setNet(coverNet);
                }
                NetMap.mapThroughPath((DevicePath)relPathCoverToDie, (Net)coverNet, (String)parentNetName);
                ALog.logInfo((String)("Connecting " + relPathToDie.toString() + " " + curPin.getName() + " to " + relPathCoverToDie.toString() + " " + coverPin.getName() + " with net " + parentNetName));
            }
        }
    }
}

