/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.iov;

import bsh.EvalError;
import bsh.Interpreter;
import com.sigrity.acl.AGridUtil;
import com.sigrity.acl.ALog;
import com.sigrity.acl.ANameCloner;
import com.sigrity.acl.APair;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.app.AAppView;
import com.sigrity.acl.app.ViewAdapter;
import com.sigrity.acl.app.ViewListener;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.DbRelationDef;
import com.sigrity.acl.db.std.Constraint;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.NamedGrid;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.PortTemplate;
import com.sigrity.acl.db.std.StoredPath;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.AGrid;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.HierPort;
import com.sigrity.orbit.OrbitApp;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.iov.IOViewBlock;
import com.sigrity.orbit.iov.IOViewDlg;
import com.sigrity.orbit.iov.IOViewInterface;
import com.sigrity.orbit.iov.LayoutManager;
import com.sigrity.orbit.iov.LayoutManagerMinimumDieSize;
import com.sigrity.orbit.iov.LayoutManagerMinimumDieSizeClearIOCellGapPersonalityGap;
import com.sigrity.orbit.iov.ProgramableTilePlacer;
import com.sigrity.orbit.ui.PersonalityUI;
import com.sigrity.orbit.ui.core.OrbitGuiWS;
import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Function;
import java.util.function.ToIntBiFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.javatuples.Pair;

public class IOView {
    public static final String FLDNAME_MODES = "IOView.Modes";
    public static final String FLDNAME_MODE = "IOView.Mode";
    public static final String FLDNAME_DECPASS = "IOView.DecorationPass";
    public static final String FLDNAME_SEQ = "IOView.SeqNum";
    public static final String FLDNAME_PTILESXML = "IOView.PTilesXML";
    public static final String FLDNAME_PTILESFILENAME = "IOView.PTilesFileName";
    public static final String FLDNAME_AUTOSIZE = "IOView.AutoSize";
    public static final String FLDNAME_AVOIDOVERLAPS = "IOView.AvoidOverlaps";
    public static final String FLDNAME_CREATEDEFAULTNETSWHENCLONING = "IOView.CreateDefaultNets";
    public static final String FLDNAME_ADDINTERFACENAMESTONET = "IOView.AddInterfaceNames";
    public static final String FLDNAME_SHOWTEMPLATENAMES = "IOView.ShowTemplateNames";
    public static final String FLDNAME_SHOWDEVICENAMES = "IOView.ShowDeviceNames";
    public static final String FLDNAME_COLORBYPASS = "IOView.ColorByPass";
    public static final String FLDNAME_CRC = "IOView.CRC";
    public static final String FLDNAME_CREATOR = "IOView.Creator";
    public static final String FLDNAME_ORDER = "IOView.UndecoratedOrder";
    public static final String FLDNAME_HIDE_CONNECTIONS_OUTSIDE_SUBSTRATE = "IOView.HideConnectionsOutside";
    public static final String FLDNAME_EXCLUDE_NOT_EDGE_ALIGNED_COVER_DEVICES = "IOView.ExcludeNotEdgeAlignedCoverDevices";
    public static final String FLDNAME_EXCLUDE_NOT_EDGE_ALIGNED_BUMP_DEVICES = "IOView.ExcludeNotEdgeAlignedBumpDevices";
    public static final String FLDNAME_SHOWBYDEFINITIONORDER = "IOView.ShowByDefinitionOrder";
    public static final String FLDNAME_DISPLAY_PINS_IN_TECHNOLOGY_ORDER = "IOView.DisplayPinsInTechnologyOrder";
    public static final String FLDNAME_SHOW_TOP_LEVEL_NET_ICON = "IOView.ShowTopLevelNetIcon";
    public static final String FLDNAME_PARENT_INTERFACE = "IOView.parentInterface";
    public static final String FLDNAME_INTERFACE_SIDE = "side";
    public static final String FLDNAME_INTERFACE_GAP = "gap";
    public static final String FLDNAME_INTERFACE_INSET = "inset";
    public static final String FLDNAME_INTERFACE_MARGIN_LEAD = "marginLead";
    public static final String FLDNAME_INTERFACE_MARGIN_TRAIL = "marginTrail";
    public static final String FLDNAME_FIRST_CHILD_GAP = "firstChildGap";
    public static final String FLDNAME_FIRST_CHILD_INSET = "firstChildInset";
    private DevicePath mRootDevicePath;
    private Substrate mSubstrate;
    private Db mDb;
    boolean delayBuilding = false;
    boolean avoidOverlap = false;
    boolean autoSize;
    public static IOView theIOView;
    private static boolean isRegistered;
    private static ViewListener theViewListener;
    private static Db.DbListener theDbListener;
    private static WeakHashMap<Db, IOView> db2view;
    private boolean fromCanvasByIOCellRotationWithInterfaceReset = false;
    protected List<SideBlocks> mBlocks = new ArrayList<SideBlocks>();
    protected List<IOViewBlock> cpBuffer = new ArrayList<IOViewBlock>();
    protected static boolean ALLOW_LOGICAL_CORE_DEVICES;
    private List<DeviceState> mDeviceStateStack = new LinkedList<DeviceState>();
    private List<IOViewState> mIOViewStateStack = new LinkedList<IOViewState>();
    protected static boolean debugPlacementDetails;
    static ArrayList<DevicePath> interfacePathsToGroup;
    static String newGroupName;
    protected ArrayList<Listener> mListeners = new ArrayList();
    protected ArrayList<ExternalListener> mExternalListeners = new ArrayList();

    public static void registerIOView() {
        if (isRegistered) {
            return;
        }
        isRegistered = true;
        theViewListener = new ViewAdapter(){

            public void activeViewChanged(AAppView oldView, AAppView newView) {
                IOView.notifyViewChange(newView == null ? null : newView.getDb());
            }

            public void viewOpened(AAppView view) {
                IOView.notifyViewChange(view.getDb());
            }
        };
        theDbListener = new Db.DbListenerAdapter(){

            public void dbObjectListenerStateChange(Db db, boolean listenersEnabled) {
                if (listenersEnabled) {
                    IOView.notifyViewChange(db);
                }
            }

            public void dbLoaded(Db db) {
                IOView.notifyViewChange(db);
            }
        };
        OrbitIO app = OrbitIO.getApp();
        OrbitGuiWS ws = app.getWorkspace();
        ws.addViewListener(theViewListener);
        Db.addDbListener((Db.DbListener)theDbListener);
    }

    public static void notifyViewChange(Db db) {
        theIOView = db2view.get(db);
    }

    public static void dbgWriteDeviceLocations(String parentDevicePath, String pathName) {
        if (pathName == null) {
            ALog.logInfo((String)"Pleaes specify path name");
            return;
        }
        try (FileWriter fileWriter = new FileWriter(pathName);){
            fileWriter.write("DevicePath, lower left x, lower left y, upper right x, upper right y\n");
            DevicePath parent = DevicePath.fromString((Db)OrbitApp.getCurDb(), (String)parentDevicePath);
            parent.getDescendants(true).stream().sorted().forEach(dp -> {
                ARect rect = dp.getBB();
                APoint2D ll = rect.getLL();
                APoint2D ur = rect.getUR();
                String str = String.format("%d, %d, %d, %d%n", ll.getX(), ll.getY(), ur.getX(), ur.getY());
                try {
                    fileWriter.write(dp.getString());
                    fileWriter.write(", ");
                    fileWriter.write(str);
                }
                catch (IOException e) {
                    ALog.logError((String)"%s, %s", (Object[])new Object[]{dp.getString(), str});
                }
            });
        }
        catch (IOException e) {
            ALog.logError((String)"Can not open %s for writing", (Object[])new Object[]{pathName});
        }
        ALog.logInfo((String)"Done dbgWriteDeviceLocations");
    }

    public Substrate getSubstrate() {
        return this.mSubstrate;
    }

    public DevicePath getRootDevicePath() {
        return this.mRootDevicePath;
    }

    public static DeviceTemplate.DefTransform createOrientForOrbit(float r, boolean m) {
        if ((r %= 360.0f) < 0.0f) {
            r += 360.0f;
        }
        return DeviceTemplate.DefTransform.getDefTransform((float)r, (boolean)m);
    }

    public void setFromCanvasByRotation(boolean fromCanvasByRotation) {
        this.fromCanvasByIOCellRotationWithInterfaceReset = fromCanvasByRotation;
    }

    public IOView(DevicePath diePath) {
        this.mRootDevicePath = new DevicePath(diePath);
        this.mDb = diePath.getDb();
        this.mSubstrate = this.mRootDevicePath.getSubstrate();
        IOView.setup(this);
        this.mBlocks.add(new SideBlocks());
        this.mBlocks.add(new SideBlocks());
        this.mBlocks.add(new SideBlocks());
        this.mBlocks.add(new SideBlocks());
        this.mBlocks.add(new SideBlocks());
        IOViewDlg.synchToNewIOView(this);
    }

    public Db getDb() {
        return this.mDb;
    }

    public void setDelayBuilding(boolean d) {
        this.delayBuilding = d;
    }

    protected List<IOViewBlock> getCPBuffer() {
        return new ArrayList<IOViewBlock>(this.cpBuffer);
    }

    protected boolean isInCPBuffer(DevicePath dp) {
        return this.cpBuffer.stream().anyMatch(b -> b.getDevicePath().equals((Object)dp));
    }

    protected void clear() {
        this.clearIOViewBlocks();
        this.mBlocks.add(new SideBlocks());
        this.mBlocks.add(new SideBlocks());
        this.mBlocks.add(new SideBlocks());
        this.mBlocks.add(new SideBlocks());
        this.mBlocks.add(new SideBlocks());
    }

    protected boolean getSubstrateBooleanValue(String field, boolean defaultValue) {
        Substrate s = this.getSubstrate();
        boolean rtnValue = defaultValue;
        Object b = s.getValue(field);
        return b == null ? rtnValue : (Boolean)b;
    }

    public boolean getAutoSize() {
        return this.getSubstrateBooleanValue(FLDNAME_AUTOSIZE, false);
    }

    public boolean getAvoidOverlap() {
        return this.getSubstrateBooleanValue(FLDNAME_AVOIDOVERLAPS, true);
    }

    public boolean getCreateDefaultNetNames() {
        return this.getSubstrateBooleanValue(FLDNAME_CREATEDEFAULTNETSWHENCLONING, false);
    }

    public boolean getAddInterfaceNames() {
        return this.getSubstrateBooleanValue(FLDNAME_ADDINTERFACENAMESTONET, false);
    }

    public boolean getShowTemplateNames() {
        return this.getSubstrateBooleanValue(FLDNAME_SHOWTEMPLATENAMES, false);
    }

    public boolean getShowDeviceNames() {
        return this.getSubstrateBooleanValue(FLDNAME_SHOWDEVICENAMES, true);
    }

    public boolean getColorByPass() {
        return this.getSubstrateBooleanValue(FLDNAME_COLORBYPASS, true);
    }

    public boolean getShowByDefinitionOrder() {
        return this.getSubstrateBooleanValue(FLDNAME_SHOWBYDEFINITIONORDER, false);
    }

    public boolean getShowTopLevelNetIcon() {
        return this.getSubstrateBooleanValue(FLDNAME_SHOW_TOP_LEVEL_NET_ICON, false);
    }

    public boolean getDisplayInTechnologyOrder() {
        return this.getSubstrateBooleanValue(FLDNAME_DISPLAY_PINS_IN_TECHNOLOGY_ORDER, false);
    }

    public boolean getHideOutsideSubstrate() {
        return this.getSubstrateBooleanValue(FLDNAME_HIDE_CONNECTIONS_OUTSIDE_SUBSTRATE, false);
    }

    public boolean getExcludeNotEdgeAlignedCoverDevices() {
        return this.getSubstrateBooleanValue(FLDNAME_EXCLUDE_NOT_EDGE_ALIGNED_COVER_DEVICES, true);
    }

    public boolean getExcludeNotEdgeAlignedBumpDevices() {
        return this.getSubstrateBooleanValue(FLDNAME_EXCLUDE_NOT_EDGE_ALIGNED_BUMP_DEVICES, true);
    }

    public static int getOrder(Device d) {
        Object o = d.getValue(FLDNAME_ORDER);
        return o == null ? 0 : (Integer)o;
    }

    public static void setOrder(Device d, int order) {
        d.setValue(FLDNAME_ORDER, (Object)order);
    }

    public static Device makeAnInterfaceByPersonalityAndDevice(DevicePath parentPath, String name, int side, boolean hard, boolean ignoreGrid) {
        return IOView.makeAnInterfaceByPersonalityAndDevice(parentPath, name, side, hard, ignoreGrid, 0L, 0L, 0L, 0L);
    }

    public static Device makeAnInterfaceByPersonalityAndDevice(DevicePath parentPath, String name, int side, boolean hard, boolean ignoreGrid, long gap, long inset, long marginLead, long marginTrail) {
        String persName = IOView.getPersonalityNameForInterface(parentPath, name);
        Personality devicePersonality = IOView.createInterfacePersonality(persName, side, hard, ignoreGrid, gap, inset, marginLead, marginTrail);
        if (devicePersonality == null) {
            String msg = String.format("Failed to createInterfacePersonality with parentPath:'%s' and name: '%s'", parentPath, persName);
            ALog.logError((String)msg);
            throw new IllegalArgumentException(msg);
        }
        return IOView.createInterfaceDevice(parentPath, devicePersonality, side, name);
    }

    private static Personality createInterfacePersonality(String name, int side, boolean hard, boolean ignoreGrid, long gap, long inset, long marginLead, long marginTrail) {
        Device die = theIOView.getRootDevicePath().getLast();
        name = Personality.getUniqueName((DeviceTemplate)die.getTemplate(), (Personality.Type)Personality.Type.DEVICE, (String)name, (String)"_");
        Personality devicePersonality = Personality.create((DeviceTemplate)die.getTemplate(), (Personality.Type)Personality.Type.DEVICE, (String)name).orElse(null);
        if (devicePersonality == null) {
            return null;
        }
        Color c = AUtil.colorFromString((String)Personality.nextColor());
        if (c != null) {
            devicePersonality.setColor(AUtil.makeTransparent((Color)c, (float)0.5f));
        }
        APair<String, Float> descriptorAndAngle = IOViewDlg.Side.getDescriptorAndAngle(side);
        IOViewBlock.setPersonalityFields(devicePersonality, (String)descriptorAndAngle.first, gap, inset, marginLead, marginTrail);
        Constraint.setConstraintValue((DbObject)devicePersonality, (Constraint.Descriptor)Constraint.HARD_PERSONALITY, (Object)false);
        Constraint.setConstraintValue((DbObject)devicePersonality, (Constraint.Descriptor)Constraint.DEVICE_MANAGED, (Object)true);
        if (hard) {
            Constraint.setConstraintValue((DbObject)devicePersonality, (Constraint.Descriptor)Constraint.HARD_PERSONALITY, (Object)true);
        } else {
            Constraint.setConstraintValue((DbObject)devicePersonality, (Constraint.Descriptor)Constraint.DEVICE_MANAGED, (Object)true);
        }
        Constraint.setConstraintValue((DbObject)devicePersonality, (Constraint.Descriptor)Constraint.IGNORE_GRID, (Object)ignoreGrid);
        return devicePersonality;
    }

    private static Device createInterfaceDevice(DevicePath parentPath, Personality devicePersonality, int side, String name) {
        Device parent = devicePersonality.createParent(parentPath, name);
        APair<String, Float> descriptorAndAngle = IOViewDlg.Side.getDescriptorAndAngle(side);
        parent.setRotate(((Float)descriptorAndAngle.second).floatValue());
        parent.setValue(FLDNAME_INTERFACE_SIDE, devicePersonality.getValue(FLDNAME_INTERFACE_SIDE));
        devicePersonality.arrangeDevicesInArea();
        devicePersonality.encompassChildDevices();
        return parent;
    }

    protected List<DevicePath> getIOViewInterfaces(DevicePath rootDevicePath) {
        List<DevicePath> intfs = rootDevicePath.getChildren().stream().filter(dp -> !dp.getLast().getIsSubstrate() && !dp.getDeviceTemplate().getType().equals((Object)DeviceTemplate.Type.DIE)).filter(dp -> dp.getDeviceTemplate().getType() == DeviceTemplate.Type.PERSONALITY).collect(Collectors.toList());
        List logicalCores = rootDevicePath.getChildren().stream().filter(dp -> dp.getDeviceTemplate().getType() == DeviceTemplate.Type.LOGICAL).collect(Collectors.toList());
        for (DevicePath lcore : logicalCores) {
            List<DevicePath> lowerLevelIntfs = this.getIOViewInterfaces(lcore);
            intfs.addAll(lowerLevelIntfs);
        }
        return intfs;
    }

    private static Device getOrCreatePersonalityDevice(DevicePath rootDevicePath, String name, int side, APoint2D interfaceLoc) {
        Device personalityDeviceParent;
        String persName = IOView.getPersonalityNameForInterface(rootDevicePath, name);
        Optional p = Personality.getPersonality((DeviceTemplate)rootDevicePath.getDeviceTemplate(), (Personality.Type)Personality.Type.DEVICE, (String)persName);
        if (!p.isPresent()) {
            personalityDeviceParent = IOView.makeAnInterfaceByPersonalityAndDevice(rootDevicePath, name, side, false, false);
            personalityDeviceParent.setLoc(interfaceLoc);
        } else {
            DevicePath path = ((Personality)p.get()).getParentDevicePath();
            if (path != null && !path.isEmpty()) {
                personalityDeviceParent = path.getLast();
            } else {
                personalityDeviceParent = Device.getADeviceByName((Db)rootDevicePath.getDb(), (String)name);
                if (personalityDeviceParent == null) {
                    personalityDeviceParent = IOView.makeAnInterfaceByPersonalityAndDevice(rootDevicePath, name, side, false, false);
                    personalityDeviceParent.setLoc(interfaceLoc);
                }
            }
        }
        return personalityDeviceParent;
    }

    private void insertParentToStoredPaths(Device iso, Device newParent, DbRelationDef mDbrdStoredPath2Device, List<DbRelationDef> ignoreRelations) {
        Map changes = AUtil.linkedList((Iterator)mDbrdStoredPath2Device.getRelated((DbObject)iso, false, StoredPath.class)).parallelStream().distinct().collect(Collectors.toMap(Function.identity(), sp -> sp.getAllRelated().distinct().filter(rel -> !ignoreRelations.contains(rel.getRel())).collect(Collectors.toList())));
        changes.entrySet().stream().forEach(e -> {
            StoredPath sp = (StoredPath)e.getKey();
            ((List)e.getValue()).stream().forEach(rel -> this.insertNewParent((DbObject.RelObj<?>)rel, sp, iso, newParent));
        });
    }

    private static Map<Integer, IOViewInterface> createSideInterfaces(DevicePath rootDevicePath, ARect dieRect) {
        return IntStream.range(0, 4).collect(HashMap::new, (m, side) -> {
            APair<String, APoint2D> synNameInterfaceLoc = IOViewDlg.Side.getSideInterfaceNameLoc(side, dieRect);
            Device d = IOView.getOrCreatePersonalityDevice(rootDevicePath, (String)synNameInterfaceLoc.first, side, (APoint2D)synNameInterfaceLoc.second);
            String persName = IOView.getPersonalityNameForInterface(rootDevicePath, (String)synNameInterfaceLoc.first);
            Personality p = Personality.getPersonality((DeviceTemplate)rootDevicePath.getDeviceTemplate(), (Personality.Type)Personality.Type.DEVICE, (String)persName).orElse(null);
            m.put(side, IOViewInterface.newIOViewInterface(p, d));
        }, Map::putAll);
    }

    private List<DeviceSideInfo> getDeviceSideInfo(List<Device> isolated, Map<Integer, IOViewInterface> topLevelInterfaces, DevicePath rootDevicePath, ToIntBiFunction<DevicePath, DevicePath> lambdaToDetermineQuadrant) {
        return isolated.parallelStream().map(iso -> {
            DevicePath childPath = new DevicePath(rootDevicePath, iso);
            int side = lambdaToDetermineQuadrant.applyAsInt(childPath, rootDevicePath);
            if (!IOViewDlg.Side.isEdge(side) || topLevelInterfaces.get(side) == null) {
                return null;
            }
            return new DeviceSideInfo((Device)iso, (IOViewInterface)topLevelInterfaces.get(side));
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private void updateStoredPathForSideInterface(DevicePath rootDevicePath, List<DeviceSideInfo> pts) {
        Db db = rootDevicePath.getDb();
        db.setListenersEnabled(false);
        LinkedList<DbRelationDef> ignoreRelations = new LinkedList<DbRelationDef>();
        ignoreRelations.add(db.getRelation("StoredPath-path"));
        ignoreRelations.add(db.getRelation("StoredPath-anchor"));
        DbRelationDef mDbrdStoredPath2Device = db.getRelation("StoredPath-path");
        pts.parallelStream().forEach(info -> {
            Device iso = info.device;
            iso.setSourceType(Device.SourceType.DIESPREADSHEET);
            if (info.sideInterface == null) {
                return;
            }
            Device sideInterface = info.sideInterface.device;
            if (sideInterface != null) {
                this.insertParentToStoredPaths(iso, sideInterface, mDbrdStoredPath2Device, ignoreRelations);
            } else {
                ALog.logError((String)"personalityDeviceParent can not be null. diePath:%s, Device:%s", (Object[])new Object[]{rootDevicePath, iso});
            }
        });
        db.setListenersEnabled(true);
    }

    private void rewireNetmapForSideInterface(List<DeviceSideInfo> pts) {
        pts.stream().forEach(info -> {
            Device iso = info.device;
            if (info.sideInterface == null) {
                return;
            }
            Device sideInterface = info.sideInterface.device;
            iso.setParent(sideInterface, true, false);
            ArrayList nms = AUtil.arrayList((Iterator)NetMap.getParentMappings((Device)iso));
            for (NetMap nm : nms) {
                Net oldParentNet = nm.getParentNet();
                DeviceTemplate dt = sideInterface.getTemplate();
                Net newParentNet = dt.getNet(oldParentNet.getName());
                if (newParentNet == null) {
                    newParentNet = Net.create((DeviceTemplate)dt, (String)oldParentNet.getName());
                }
                NetMap.mapChildNet((Device)iso, (Net)nm.getChildNet(), (Net)newParentNet);
                NetMap.mapChildNet((Device)sideInterface, (Net)newParentNet, (Net)oldParentNet);
            }
        });
    }

    private void updateTransformForReParent(List<DeviceSideInfo> pts) {
        pts.stream().forEach(info -> {
            Device iso = info.device;
            if (info.sideInterface == null) {
                return;
            }
            iso.setRotate(0.0f);
            float curRot = info.sideInterface.device.getRotate();
            float deltaRot = info.oldRot - curRot;
            if (deltaRot != 0.0f) {
                if (deltaRot < 0.0f) {
                    deltaRot += 360.0f;
                }
                iso.setRotate(deltaRot);
            }
            DevicePath newPath = new DevicePath(info.sideInterface.device);
            newPath.add(iso);
            AffineTransform t = newPath.getParent().getInverseTransform();
            APoint2D newP = info.oldPos.transform(t);
            iso.moveTo(newP);
        });
    }

    private boolean removeEmptyInterface(IOViewInterface intf) {
        Personality p = intf.personality;
        Device d = intf.device;
        if (d != null && !d.hasChildren()) {
            DeviceTemplate t = d.getTemplate();
            d.deleteFromDb();
            t.deleteFromDb();
            if (p != null) {
                p.deleteFromDb();
            }
            return true;
        }
        return false;
    }

    private Map<Integer, IOViewInterface> createSideInterfacesParentingUnmanaged(List<Device> isolated, ToIntBiFunction<DevicePath, DevicePath> lambdaToDetermineQuadrant) {
        DevicePath rootDevicePath = this.getRootDevicePath();
        ARect dieRect = this.getRootDevicePath().getDeviceTemplate().getBB();
        Map<Integer, IOViewInterface> topLevelInterfaces = IOView.createSideInterfaces(rootDevicePath, dieRect);
        List<DeviceSideInfo> dsi = this.getDeviceSideInfo(isolated, topLevelInterfaces, rootDevicePath, lambdaToDetermineQuadrant);
        this.updateStoredPathForSideInterface(rootDevicePath, dsi);
        this.rewireNetmapForSideInterface(dsi);
        this.updateTransformForReParent(dsi);
        dsi.stream().forEach(info -> {
            Device iso = info.device;
            iso.assignToPersonality(info.sideInterface.personality);
        });
        Map<Integer, IOViewInterface> nonEmptySideInterfaces = topLevelInterfaces.entrySet().stream().filter(e -> this.removeEmptyInterface((IOViewInterface)e.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return nonEmptySideInterfaces;
    }

    private List<Device> getUnmanagedDevices(Device rootDevice) {
        return rootDevice.getChildren().parallelStream().filter(child -> !child.getIsSubstrate() && !child.getTemplate().getType().equals((Object)DeviceTemplate.Type.DIE)).filter(child -> child.getTemplate().getType() != DeviceTemplate.Type.PERSONALITY && child.getTemplate().getType() != DeviceTemplate.Type.LOGICAL).sorted().collect(Collectors.toList());
    }

    private Optional<Personality> getPersonalityByDevicePath(DevicePath dp, Device rootDevice) {
        String psnName = IOView.getPersonalityNameForInterface(dp);
        return Personality.getPersonality((DeviceTemplate)rootDevice.getTemplate(), (Personality.Type)Personality.Type.DEVICE, (String)psnName);
    }

    private void resetInterfaceByAngle(List<DevicePath> interfaces) {
        Device rootDevice = this.getRootDevicePath().getLast();
        interfaces.stream().forEach(dp -> {
            Optional<Personality> p = this.getPersonalityByDevicePath((DevicePath)dp, rootDevice);
            Device d = dp.getDevice();
            float angle = d.getRotate();
            int side = IOViewDlg.Side.determineSide(angle);
            APair<String, Float> desc = IOViewDlg.Side.getDescriptorAndAngle(side);
            if (p.isPresent()) {
                IOViewBlock.setPersonalityFields(p.get(), (String)desc.first, 0L, 0L, 0L, 0L, 0L, 0L);
            }
            d.setSide((String)desc.first);
        });
    }

    private void dbgPushDeviceState(DevicePath dp, String comment) {
        if (!debugPlacementDetails) {
            return;
        }
        DeviceState deviceState = new DeviceState(dp, comment);
        this.mDeviceStateStack.add(deviceState);
    }

    private void dbgDiffDeviceStatesAndPopAll() {
        if (!debugPlacementDetails) {
            return;
        }
        DeviceState current = this.mDeviceStateStack.get(0);
        for (int i = 1; i < this.mDeviceStateStack.size(); ++i) {
            DeviceState next = this.mDeviceStateStack.get(i);
            this.dbgPrintDiff(current, next);
            current = next;
        }
        this.mDeviceStateStack.clear();
    }

    private void dbgPrintDiff(DeviceState s1, DeviceState s2) {
        if (!debugPlacementDetails) {
            return;
        }
        ALog.logInfo((String)"Diff Device:%s (%d) of %s and %s", (Object[])new Object[]{s1.devicePath, s1.state.size(), s1.comment, s2.comment});
        s1.state.entrySet().stream().forEach(e -> {
            Device d = (Device)e.getKey();
            ARect r1 = (ARect)e.getValue();
            ARect r2 = s2.state.get(d);
            if (r2 == null || !r1.equals((Object)r2)) {
                ALog.logInfo((String)"%s: %s <-> %s, (%d, %d)", (Object[])new Object[]{d, r1, r2, Math.abs(r1.getLL().getX() - r2.getLL().getX()), Math.abs(r1.getLL().getY() - r2.getLL().getY())});
            }
        });
    }

    private void dbgPushIOViewState(String comment) {
        if (!debugPlacementDetails) {
            return;
        }
        IOViewState iovState = new IOViewState(comment);
        for (int s = 0; s < 4; ++s) {
            List<IOViewBlock> blocks = this.getSideFlat(s);
            Map<DevicePath, ARect> dpAndBBs = blocks.stream().map(IOViewBlock::getDevicePath).collect(Collectors.toMap(Function.identity(), DevicePath::getBB));
            iovState.addState(s, dpAndBBs);
        }
        this.mIOViewStateStack.add(iovState);
    }

    private void dbgDiffIOViewStatesAndPopAll() {
        if (!debugPlacementDetails) {
            return;
        }
        IOViewState current = this.mIOViewStateStack.get(0);
        for (int i = 1; i < this.mIOViewStateStack.size(); ++i) {
            IOViewState next = this.mIOViewStateStack.get(i);
            this.dbgPrintDiff(current, next);
            current = next;
        }
        this.mIOViewStateStack.clear();
    }

    private void dbgPrintDiff(IOViewState s1, IOViewState s2) {
        if (!debugPlacementDetails) {
            return;
        }
        s1.state.entrySet().stream().forEach(state -> {
            Map m1 = (Map)state.getValue();
            Map<DevicePath, ARect> m2 = s2.state.get(state.getKey());
            ALog.logInfo((String)"Diff Side:%d (%d) of %s and %s", (Object[])new Object[]{state.getKey(), m1.size(), s1.comment, s2.comment});
            m1.entrySet().forEach(e -> {
                DevicePath dp = (DevicePath)e.getKey();
                ARect r1 = (ARect)e.getValue();
                ARect r2 = (ARect)m2.get(dp);
                if (r2 == null || !r1.equals((Object)r2)) {
                    ALog.logInfo((String)"%s: %s <-> %s", (Object[])new Object[]{dp, r1, r2});
                }
            });
        });
    }

    private void buildIOViewFromCanvasByIOCellRotationWithInterfaceReset() {
        this.clear();
        List<Device> unmanaged = this.getUnmanagedDevices(this.getRootDevicePath().getLast());
        if (!unmanaged.isEmpty()) {
            ALog.logInfo((String)("There are " + unmanaged.size() + " devices not in an interface. Appropriate interfaces have been created."));
        }
        Map<Integer, IOViewInterface> sideInterfaces = this.createSideInterfacesParentingUnmanaged(unmanaged, IOView::determineQuadrantByRotation);
        List<DevicePath> interfaces = this.getIOViewInterfaces(this.getRootDevicePath());
        this.resetInterfaceByAngle(interfaces);
        interfaces = this.createIOViewBlocksForManagedDevices(interfaces, IOView::determineQuadrantByRotation);
        this.ensureInterfacePersonality(interfaces);
        this.updateSideInterfaceBounds(sideInterfaces);
        this.buildGapsAndInsets();
        this.buildDefaultXForms();
        this.buildCovers();
        this.buildPinNetStuff();
        this.fireIOViewChanged();
    }

    protected void buildIOViewFromCanvas() {
        if (this.fromCanvasByIOCellRotationWithInterfaceReset) {
            this.buildIOViewFromCanvasByIOCellRotationWithInterfaceReset();
            this.fromCanvasByIOCellRotationWithInterfaceReset = false;
        } else {
            this.buildIOViewByIOCellLocationWithInterface();
        }
    }

    private void buildIOViewByIOCellLocationWithInterface() {
        this.clear();
        List<Device> unmanaged = this.getUnmanagedDevices(this.getRootDevicePath().getLast());
        if (!unmanaged.isEmpty()) {
            ALog.logInfo((String)("There are " + unmanaged.size() + " devices not in an interface. Appropriate interfaces have been created."));
        }
        Map<Integer, IOViewInterface> sideInterfaces = this.createSideInterfacesParentingUnmanaged(unmanaged, IOView::determineQuadrant);
        List<DevicePath> interfaces = this.getIOViewInterfaces(this.getRootDevicePath());
        interfaces = this.createIOViewBlocksForManagedDevices(interfaces, IOView::determineQuadrant);
        this.ensureInterfacePersonality(interfaces);
        this.restoreAttributesFromPersonalities();
        this.updateSideInterfaceBounds(sideInterfaces);
        this.buildGapsAndInsets();
        this.buildDefaultXForms();
        this.buildCovers();
        this.buildPinNetStuff();
        this.fireIOViewChanged();
    }

    private void ensureInterfacePersonality(List<DevicePath> intfPaths) {
        Device rootDevice = this.getRootDevicePath().getLast();
        intfPaths.stream().forEach(dp -> this.getPersonalityByDevicePath((DevicePath)dp, rootDevice).orElseGet(() -> {
            String psnName = IOView.getPersonalityNameForInterface(dp);
            IOViewBlock b = IOViewBlock.findBlockOfName(dp.toString());
            if (b == null) {
                ALog.logError((String)"Failed to find iovb for %s, psn:%s", (Object[])new Object[]{dp.toString(), psnName});
                return null;
            }
            return IOView.createInterfacePersonality(psnName, b.side, b.hard, b.ignoreGrid, b.gap, b.inset, b.marginLead, b.marginTrail);
        }));
    }

    private List<DevicePath> createIOViewBlocksForManagedDevices(List<DevicePath> interfaces, ToIntBiFunction<DevicePath, DevicePath> lambdaToDetermineQuadrant) {
        SideBlocks sb;
        LinkedList<DevicePath> validInterfaces = new LinkedList<DevicePath>();
        DevicePath rootDevicePath = this.getRootDevicePath();
        IOViewBlock rootDeviceBlock = new IOViewBlock(null, -1, null);
        rootDeviceBlock.devicePath = rootDevicePath;
        for (DevicePath anInterface : interfaces) {
            int quadrant;
            if (this.isInCPBuffer(anInterface) || (quadrant = lambdaToDetermineQuadrant.applyAsInt(anInterface, rootDevicePath)) == -1) continue;
            this.mBlocks.get(quadrant).add(new IOViewBlock(anInterface, quadrant, rootDeviceBlock));
            validInterfaces.add(anInterface);
        }
        for (Object i : (Object)IOViewDlg.Side.getOrdinals()) {
            sb = this.mBlocks.get((int)i);
            for (IOViewBlock b : sb) {
                this.recurseChildren(b);
            }
        }
        for (Object i : (Object)IOViewDlg.Side.getOrdinals()) {
            sb = this.mBlocks.get((int)i);
            this.sortBlocks(sb, (int)i);
        }
        return validInterfaces;
    }

    protected void buildDefaultXForms() {
        for (int side = 0; side < 5; ++side) {
            List sb = this.mBlocks.get(side);
            int theSide = side;
            for (IOViewBlock b : sb) {
                b.children.parallelStream().forEach(c -> {
                    DeviceTemplate.DefTransform o = this.setIOViewBlockXFormFromDevice(c.getDevicePath(), theSide);
                    c.setDefaultXForm(o);
                });
            }
        }
    }

    protected void collectChanges(DbObject.RelObj<?> r, StoredPath sp, LinkedList<Info> list) {
        Info info = new Info();
        info.rel = r;
        info.sp = sp;
        list.add(info);
    }

    protected void insertNewParent(DbObject.RelObj<?> r, StoredPath sp, Device d, Device newParent) {
        DevicePath oldDevicePath = sp.getDevicePath();
        int idx = oldDevicePath.indexOf(d);
        int idxNew = oldDevicePath.indexOf(newParent);
        if (idx < 0 || idxNew >= 0) {
            return;
        }
        oldDevicePath.add(idx, newParent);
        StoredPath newStoredPath = StoredPath.get((DevicePath)oldDevicePath);
        r.replaceRelated((DbObject)newStoredPath);
    }

    protected DeviceTemplate.DefTransform setIOViewBlockXFormFromDevice(DevicePath devicePath, int side) {
        DevicePath pathToDie = devicePath.getRelativePath(theIOView.getRootDevicePath().getDeviceTemplate());
        pathToDie.removeFirst();
        float rot = pathToDie.getRot();
        boolean m = pathToDie.getMirror();
        float angle = IOViewDlg.Side.getAngle(side);
        return IOView.createOrientForOrbit(rot - angle, m);
    }

    private void saveAttributeToPersonality(IOViewBlock b, Personality devicePersonality) {
        IOViewBlock firstChild;
        long firstChildGap = 0L;
        long firstChildInset = 0L;
        IOViewBlock iOViewBlock = firstChild = b.getChildren().isEmpty() ? null : b.getChildren().get(0);
        if (firstChild != null) {
            firstChildGap = firstChild.gap;
            firstChildInset = firstChild.inset;
        }
        b.setPersonalityFields(devicePersonality, firstChildGap, firstChildInset);
        Constraint.setConstraintValue((DbObject)devicePersonality, (Constraint.Descriptor)Constraint.IGNORE_GRID, (Object)b.ignoreGrid);
        Constraint.setConstraintValue((DbObject)devicePersonality, (Constraint.Descriptor)Constraint.HARD_PERSONALITY, (Object)b.hard);
    }

    private void saveAttributesToPersonalities() {
        for (int s = 0; s < 4; ++s) {
            List sideBlocks = IOView.theIOView.mBlocks.get(s);
            for (IOViewBlock b : sideBlocks) {
                if (!b.isInterface()) continue;
                Personality.getPersonality((DeviceTemplate)b.getDie().getTemplate(), (Personality.Type)Personality.Type.DEVICE, (String)IOView.getPersonalityNameForInterface(b.getDevicePath())).ifPresent(p -> this.saveAttributeToPersonality(b, (Personality)p));
            }
        }
    }

    private void resotreAttributesFromPersonality(IOViewBlock b, Personality devicePersonality) {
        b.gap = (Long)AUtil.getField((DbObject)devicePersonality, (String)FLDNAME_INTERFACE_GAP, (Object)b.gap);
        b.inset = (Long)AUtil.getField((DbObject)devicePersonality, (String)FLDNAME_INTERFACE_INSET, (Object)b.inset);
        b.marginLead = (Long)AUtil.getField((DbObject)devicePersonality, (String)FLDNAME_INTERFACE_MARGIN_LEAD, (Object)b.marginLead);
        b.marginTrail = (Long)AUtil.getField((DbObject)devicePersonality, (String)FLDNAME_INTERFACE_MARGIN_TRAIL, (Object)b.marginTrail);
        Db db = devicePersonality.getDb();
        b.ignoreGrid = IOView.getBooleanConstraint(db, (DbObject)devicePersonality, (Constraint.Descriptor<Boolean>)Constraint.IGNORE_GRID, b.ignoreGrid);
        b.hard = IOView.getBooleanConstraint(db, (DbObject)devicePersonality, (Constraint.Descriptor<Boolean>)Constraint.HARD_PERSONALITY, b.hard);
    }

    protected void restoreAttributesFromPersonalities() {
        for (int s = 0; s < 4; ++s) {
            List sideBlocks = IOView.theIOView.mBlocks.get(s);
            for (IOViewBlock b : sideBlocks) {
                if (!b.isInterface()) continue;
                Personality.getPersonality((DeviceTemplate)b.getDie().getTemplate(), (Personality.Type)Personality.Type.DEVICE, (String)IOView.getPersonalityNameForInterface(b.getDevicePath())).ifPresent(devicePersonality -> this.resotreAttributesFromPersonality(b, (Personality)devicePersonality));
            }
        }
    }

    private void addToFlatten(List<IOViewBlock> hierarchy, List<IOViewBlock> flat, boolean includePersonality) {
        for (IOViewBlock block : hierarchy) {
            if (block.children != null && !block.children.isEmpty()) {
                this.addToFlatten(block.children, flat, includePersonality);
            }
            if (block.isInterface() && !includePersonality) continue;
            flat.add(block);
        }
    }

    public List<IOViewBlock> getIOCells(int side) {
        return this.flattenSide(side, false);
    }

    public List<IOViewBlock> flattenSide(int side, boolean includePersonality) {
        ArrayList<IOViewBlock> list = new ArrayList<IOViewBlock>();
        List sideBlocks = IOView.theIOView.mBlocks.get(side);
        this.addToFlatten(sideBlocks, list, includePersonality);
        return list;
    }

    public List<DevicePath> getIOCells() {
        List<IOViewBlock> list = this.flattenAll();
        return list.stream().filter(b -> b.children == null || b.children.isEmpty()).map(b -> b.devicePath).collect(Collectors.toCollection(ArrayList::new));
    }

    protected List<IOViewBlock> flattenAll() {
        ArrayList<IOViewBlock> list = new ArrayList<IOViewBlock>();
        list.addAll(this.flattenSide(2, true));
        list.addAll(this.flattenSide(3, true));
        list.addAll(this.flattenSide(0, true));
        list.addAll(this.flattenSide(1, true));
        list.addAll(this.flattenSide(4, true));
        return list;
    }

    protected void buildPinNetStuff() {
        List<IOViewBlock> flat = this.flattenAll();
        for (IOViewBlock block : flat) {
            block.buildPinNetStuff();
        }
    }

    protected void updateNames() {
        List<IOViewBlock> flat = this.flattenAll();
        for (IOViewBlock block : flat) {
            if (block.getName().equals(block.devicePath.getLast().getName())) continue;
            DeviceTemplate dt = block.devicePath.getLast().getParent();
            String name = Device.getUniqueName((DeviceTemplate)dt, (String)block.getName());
            ALog.logInfo((String)("Renaming " + block.devicePath.getLast().getName() + " to " + name));
            block.devicePath.getLast().setName(name);
            block.updateName();
        }
    }

    List<IOViewBlock> getInterfacesAtSameLevel(IOViewBlock intf) {
        return this.mBlocks.get(intf.side).stream().filter(iovb -> iovb.isInterface() && !iovb.equals(intf)).collect(Collectors.toList());
    }

    List<String> getNamesOfInterfacesAtSameLevel(IOViewBlock intf) {
        return this.getInterfacesAtSameLevel(intf).stream().map(IOViewBlock::getDesiredName).collect(Collectors.toList());
    }

    protected List<IOViewBlock> getSideFlat(int s) {
        List side = this.mBlocks.get(s);
        ArrayList<IOViewBlock> flat = new ArrayList<IOViewBlock>();
        this.addToFlatten(side, flat, true);
        return flat;
    }

    protected ARect sideRect(int s) {
        List side = this.mBlocks.get(s);
        ArrayList<IOViewBlock> flat = new ArrayList<IOViewBlock>();
        this.addToFlatten(side, flat, true);
        ARect r = flat.parallelStream().map(b -> b.devicePath.getBB()).collect(ARect::createAFaultyRect, ARect::expand, ARect::expand);
        return r.isNormal() ? r : null;
    }

    private long getHorizontalExtent(int side, ARect r) {
        if (side == 0 || side == 2) {
            return r.width();
        }
        return r.height();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected long deriveRequiredGap(int side, boolean first, long l) {
        if (first) {
            IOViewBlock b = this.firstInterface(side);
            if (b == null) return 0L;
            List<IOViewBlock> s = this.getIOCells(side);
            ARect pR = b.rOfFirstInterface();
            if (pR == null) return 0L;
            ARect intersectedUnion = s.parallelStream().map(c -> c.devicePath.getBB()).filter(bb -> bb.intersects(pR)).collect(ARect::createAFaultyRect, ARect::expand, ARect::expand);
            ARect r = new ARect(pR);
            if (!intersectedUnion.isNormal()) return this.getHorizontalExtent(side, r);
            r.expand(intersectedUnion);
            return this.getHorizontalExtent(side, r);
        }
        IOViewBlock b = this.lastInterface(side);
        if (b == null) return 0L;
        List<IOViewBlock> s = this.getIOCells(side);
        ARect pR = b.rOfLastInterface();
        if (pR == null) return 0L;
        ARect intersectedUnion = s.parallelStream().map(c -> c.devicePath.getBB()).filter(bb -> bb.intersects(pR)).collect(ARect::createAFaultyRect, ARect::expand, ARect::expand);
        ARect r = new ARect(pR);
        if (!intersectedUnion.isNormal()) return this.getHorizontalExtent(side, r);
        r.expand(intersectedUnion);
        return this.getHorizontalExtent(side, r);
    }

    public static void removeAllGaps() {
        for (int side = 0; side < 4; ++side) {
            List sideBlocks = IOView.theIOView.mBlocks.get(side);
            sideBlocks.parallelStream().forEach(interfaceDevice -> {
                interfaceDevice.gap = 0L;
                interfaceDevice.inset = 0L;
            });
        }
        IOView.buildCanvasFromIOView(-1);
    }

    public static void removeAllIOCellGaps(String parentName, String name) {
        IOViewBlock b = IOViewBlock.findBlockOfName(parentName, name);
        if (b != null && b.isInterface()) {
            IOView.removeAllIOCellGapsAndInsets(b);
        }
    }

    private static void removeAllIOCellGapsAndInsets(IOViewBlock personality) {
        personality.children.stream().forEach(b -> {
            if (b.isInterface()) {
                IOView.removeAllIOCellGapsAndInsets(b);
            } else if (!b.isInPlacementGroup1()) {
                b.gap = 0L;
                b.inset = 0L;
            }
        });
    }

    public static void forceToGrid() {
        theIOView.snapIOCells();
        theIOView.buildIOViewFromCanvas();
    }

    public static void searchForMinumumDieSizeExhaustive() {
        LayoutManagerMinimumDieSizeClearIOCellGapPersonalityGap lm = new LayoutManagerMinimumDieSizeClearIOCellGapPersonalityGap();
        lm.reset(theIOView);
        lm.layout(false);
    }

    public static void resizeToFitGapsAndInsets() {
        LayoutManagerMinimumDieSize lm = new LayoutManagerMinimumDieSize();
        lm.reset(theIOView);
        lm.layout(false);
    }

    public static List<DevicePath> getDevicesInSequence() {
        List<IOViewBlock> flat = theIOView.flattenAll();
        return flat.stream().map(IOViewBlock::getDevicePath).collect(Collectors.toList());
    }

    public static List<IOViewBlock> getIOVIewBlocksInSequence() {
        List<IOViewBlock> sequence = new LinkedList<IOViewBlock>();
        if (theIOView == null) {
            return sequence;
        }
        sequence = theIOView.flattenAll().stream().collect(Collectors.toList());
        return sequence;
    }

    public static void resetCornersToZero() {
        for (int i = 0; i < 4; ++i) {
            IOViewBlock first = theIOView.firstInterface(i);
            if (first == null) continue;
            first.gap = 0L;
        }
        IOView.buildCanvasFromIOView(-1);
    }

    private static long getMaxHorizontalFromIntersection(ARect leftRect, List<ARect> rightRects) {
        return rightRects.parallelStream().filter(arg_0 -> ((ARect)leftRect).intersects(arg_0)).map(rightRect -> leftRect.right() - rightRect.left()).max(Long::compare).orElse(0L);
    }

    private static long getMaxVerticalFromIntersection(ARect bottomRect, List<ARect> topRects) {
        return topRects.parallelStream().filter(arg_0 -> ((ARect)bottomRect).intersects(arg_0)).map(topRect -> bottomRect.top() - topRect.bottom()).max(Long::compare).orElse(0L);
    }

    private static boolean avoidLowerLeftCornerOverlapByMovingBottomSide(List<IOViewBlock> leftSet, List<IOViewBlock> bottomSet) {
        List leftWorldBBs = leftSet.parallelStream().filter(s -> !s.isInPlacementGroup1()).map(s -> s.devicePath.getBB()).collect(Collectors.toList());
        List bottomWorldBBs = bottomSet.parallelStream().filter(s -> !s.isInPlacementGroup1()).map(s -> s.devicePath.getBB()).collect(Collectors.toList());
        long shift = leftWorldBBs.parallelStream().map(bb -> IOView.getMaxHorizontalFromIntersection(bb, bottomWorldBBs)).max(Long::compare).orElse(0L);
        if (shift != 0L) {
            IOViewBlock first = theIOView.firstInterface(3);
            first.gap += shift;
            IOView.buildCanvasFromIOView(3);
        }
        return shift != 0L;
    }

    private static boolean avoidLowerRightCornerOverlapByMovingRightSide(List<IOViewBlock> bottomSet, List<IOViewBlock> rightSet) {
        List rightWorldBBs = rightSet.parallelStream().filter(s -> !s.isInPlacementGroup1()).map(s -> s.devicePath.getBB()).collect(Collectors.toList());
        List bottomWorldBBs = bottomSet.parallelStream().filter(s -> !s.isInPlacementGroup1()).map(s -> s.devicePath.getBB()).collect(Collectors.toList());
        long shift = bottomWorldBBs.parallelStream().map(bb -> IOView.getMaxVerticalFromIntersection(bb, rightWorldBBs)).max(Long::compare).orElse(0L);
        if (shift != 0L) {
            IOViewBlock first = theIOView.firstInterface(0);
            first.gap += shift;
            IOView.buildCanvasFromIOView(0);
        }
        return shift != 0L;
    }

    private static boolean avoidTopRightCornerOverlapByMovingTopSide(List<IOViewBlock> rightSet, List<IOViewBlock> topSet) {
        List rightWorldBBs = rightSet.parallelStream().filter(s -> !s.isInPlacementGroup1()).map(s -> s.devicePath.getBB()).collect(Collectors.toList());
        List topWorldBBs = topSet.parallelStream().filter(s -> !s.isInPlacementGroup1()).map(s -> s.devicePath.getBB()).collect(Collectors.toList());
        long shift = topWorldBBs.parallelStream().map(bb -> IOView.getMaxHorizontalFromIntersection(bb, rightWorldBBs)).max(Long::compare).orElse(0L);
        if (shift != 0L) {
            IOViewBlock first = theIOView.firstInterface(1);
            first.gap += shift;
            IOView.buildCanvasFromIOView(1);
        }
        return shift != 0L;
    }

    private static boolean avoidTopLeftCornerOverlapByMovingLeftSide(List<IOViewBlock> topSet, List<IOViewBlock> leftSet) {
        List leftWorldBBs = leftSet.parallelStream().filter(s -> !s.isInPlacementGroup1()).map(s -> s.devicePath.getBB()).collect(Collectors.toList());
        List topWorldBBs = topSet.parallelStream().filter(s -> !s.isInPlacementGroup1()).map(s -> s.devicePath.getBB()).collect(Collectors.toList());
        long shift = leftWorldBBs.parallelStream().map(bb -> IOView.getMaxVerticalFromIntersection(bb, topWorldBBs)).max(Long::compare).orElse(0L);
        if (shift != 0L) {
            IOViewBlock first = theIOView.firstInterface(2);
            first.gap += shift;
            IOView.buildCanvasFromIOView(2);
        }
        return shift != 0L;
    }

    public static void avoidCornerOverlaps() {
        List<IOViewBlock> rightSet = theIOView.getSideFlat(0);
        List<IOViewBlock> topSet = theIOView.getSideFlat(1);
        List<IOViewBlock> leftSet = theIOView.getSideFlat(2);
        List<IOViewBlock> bottomSet = theIOView.getSideFlat(3);
        IOView.avoidLowerLeftCornerOverlapByMovingBottomSide(leftSet, bottomSet);
        IOView.avoidLowerRightCornerOverlapByMovingRightSide(bottomSet, rightSet);
        IOView.avoidTopRightCornerOverlapByMovingTopSide(rightSet, topSet);
        IOView.avoidTopLeftCornerOverlapByMovingLeftSide(topSet, leftSet);
    }

    protected IOViewBlock firstInterface(int side) {
        IOViewBlock ret = null;
        List sideBlocks = this.mBlocks.get(side);
        if (!sideBlocks.isEmpty()) {
            return (IOViewBlock)sideBlocks.get(0);
        }
        return ret;
    }

    protected IOViewBlock lastInterface(int side) {
        IOViewBlock ret = null;
        List sideBlocks = this.mBlocks.get(side);
        if (!sideBlocks.isEmpty()) {
            return (IOViewBlock)sideBlocks.get(sideBlocks.size() - 1);
        }
        return ret;
    }

    public static void padLimitDie() {
        LayoutManagerMinimumDieSizeClearIOCellGapPersonalityGap lm = new LayoutManagerMinimumDieSizeClearIOCellGapPersonalityGap();
        lm.reset(theIOView);
        lm.layout(true);
    }

    protected ARect deriveBoundingRect(int side) {
        ARect r = this.mBlocks.get(side).parallelStream().flatMap(b -> b.children.parallelStream()).map(bChild -> bChild.getDevicePath().getBB()).collect(ARect::createAFaultyRect, ARect::expand, ARect::expand);
        return r.isNormal() ? r : null;
    }

    protected long deriveMaxHeight(int side) {
        ARect r = this.deriveBoundingRect(side);
        if (r != null) {
            return r.height();
        }
        return 0L;
    }

    protected long deriveMaxWidth(int side) {
        ARect r = this.deriveBoundingRect(side);
        if (r != null) {
            return r.width();
        }
        return 0L;
    }

    protected long deriveMinOtherDimension(int side) {
        List sb = this.mBlocks.get(side);
        Long start = null;
        Long end = null;
        switch (side) {
            case 0: 
            case 2: {
                start = sb.parallelStream().flatMap(b -> b.children.parallelStream()).map(bChild -> bChild.getDevicePath().getBB().left()).reduce(Math::min).orElse(null);
                end = sb.parallelStream().flatMap(b -> b.children.parallelStream()).map(bChild -> bChild.getDevicePath().getBB().right()).reduce(Math::max).orElse(null);
                break;
            }
            case 1: 
            case 3: {
                start = sb.parallelStream().flatMap(b -> b.children.parallelStream()).map(bChild -> bChild.getDevicePath().getBB().bottom()).reduce(Math::min).orElse(null);
                end = sb.parallelStream().flatMap(b -> b.children.parallelStream()).map(bChild -> bChild.getDevicePath().getBB().top()).reduce(Math::max).orElse(null);
                break;
            }
            default: {
                String msg = String.format("Not a valid side:%d", side);
                ALog.logError((String)msg);
                throw new IllegalArgumentException(msg);
            }
        }
        if (start == null || end == null) {
            return 0L;
        }
        return Math.abs(start - end);
    }

    private void findAndMarkCovers(List<IOViewBlock> flat) {
        flat.parallelStream().forEach(block -> {
            DevicePath dp = block.getDevicePath();
            if (dp != null) {
                block.iAmACover = dp.getDeviceTemplate().getType() == DeviceTemplate.Type.COVER;
            }
        });
    }

    private void setSequenceNumber(List<IOViewBlock> covers) {
        int i = 0;
        for (IOViewBlock cover : covers) {
            cover.nthCover = i++;
        }
    }

    private List<IOViewBlock> getCovers(List<IOViewBlock> flat) {
        return flat.parallelStream().filter(IOViewBlock::isInPlacementGroup1).collect(Collectors.toList());
    }

    private void computeCoverOverlayAndIntersectons(IOViewBlock block, List<IOViewBlock> covers) {
        block.overlay = null;
        ARect dRect = block.getDevicePath().getBB();
        covers.stream().forEach(cover -> {
            ARect cRect = cover.getDevicePath().getBB();
            if (cRect.contains((AGeom)dRect)) {
                block.overlay = cover;
            }
            if (cRect.intersects(dRect)) {
                ++block.numCovers;
            }
        });
    }

    protected void buildCovers() {
        List<IOViewBlock> flat = this.flattenAll();
        this.findAndMarkCovers(flat);
        List<IOViewBlock> covers = this.getCovers(flat);
        flat.removeAll(covers);
        flat.stream().forEach(block -> {
            DevicePath dp = block.getDevicePath();
            DeviceTemplate t = dp.getDeviceTemplate();
            if (t.getType() == DeviceTemplate.Type.PERSONALITY || t.getType() == DeviceTemplate.Type.MACRO && t.getIsSynthesized()) {
                return;
            }
            this.computeCoverOverlayAndIntersectons((IOViewBlock)block, covers);
        });
        Collections.sort(covers, new BlockSorter());
        this.setSequenceNumber(covers);
    }

    protected void buildGapsAndInsets() {
        for (int s = 0; s < 4; ++s) {
            List sideBlocks = IOView.theIOView.mBlocks.get(s);
            theIOView.buildCanvasFromIOView(s, sideBlocks, true);
        }
    }

    protected IOViewBlock getBlock(DevicePath path) {
        for (int side = 0; side < 5; ++side) {
            Optional<IOViewBlock> found = this.mBlocks.get(side).parallelStream().map(child -> child.getBlock(path)).filter(Objects::nonNull).findAny();
            if (!found.isPresent()) continue;
            return found.get();
        }
        return this.cpBuffer.parallelStream().filter(b -> b.getDevicePath().equals((Object)path)).findAny().orElse(null);
    }

    protected void sortBlocks(ArrayList<IOViewBlock> blocks, int side) {
        Collections.sort(blocks, SideSorterFactory.getSideSorter(side, 0));
        blocks.parallelStream().forEach(childBlock -> Collections.sort(childBlock.children, SideSorterFactory.getSideSorter(side, 1)));
    }

    protected void recurseChildren(IOViewBlock block) {
        if (block.devicePath != null) {
            if (this.isInCPBuffer(block.devicePath)) {
                return;
            }
            for (Device d : block.devicePath.getDeviceTemplate().getChildren()) {
                DevicePath childPath;
                if (d.getIsSubstrate() || d.getType().equals((Object)DeviceTemplate.Type.DIE) || this.isInCPBuffer(childPath = new DevicePath(block.devicePath, d))) continue;
                IOViewBlock dblock = new IOViewBlock(childPath, block.side, block);
                block.children.add(dblock);
                DeviceTemplate dt = childPath.getDeviceTemplate();
                DeviceTemplate.Type type = dt.getType();
                if (type != DeviceTemplate.Type.LOGICAL && type != DeviceTemplate.Type.PERSONALITY) continue;
                this.recurseChildren(dblock);
            }
        }
    }

    public ArrayAndIndex findArrayAndIndex(IOViewBlock b) {
        ArrayAndIndex aai = new ArrayAndIndex();
        if (b.parent == null || b.parent.children.isEmpty()) {
            aai.array = this.mBlocks.get(b.side);
            aai.index = aai.array.indexOf(b);
        } else {
            aai.array = b.parent.children;
            aai.index = aai.array.indexOf(b);
        }
        return aai;
    }

    public void remove(IOViewBlock b) {
        if (b.parent == null || b.parent.children.isEmpty()) {
            this.mBlocks.get(b.side).remove(b);
        } else {
            b.parent.children.remove(b);
        }
        this.fireIOViewChanged();
    }

    protected boolean anyDescendentsAreIO(DevicePath parent) {
        return parent.getDescendants().parallelStream().anyMatch(desc -> desc.getDeviceTemplate().getType() == DeviceTemplate.Type.PAD);
    }

    private static IOViewDlg.Side determineQBottom(ARect dieRect, ARect ioRect, float ioAngle) {
        IOViewDlg.Side q = IOViewDlg.Side.Bottom;
        if (IOView.isRightAligned(dieRect, ioRect) && ioAngle == 270.0f) {
            q = IOViewDlg.Side.Right;
        } else if (IOView.isLeftAligned(dieRect, ioRect) && ioAngle == 90.0f) {
            q = IOViewDlg.Side.Left;
        }
        return q;
    }

    private static IOViewDlg.Side determineQRight(ARect dieRect, ARect ioRect, float ioAngle) {
        IOViewDlg.Side q = IOViewDlg.Side.Right;
        if (IOView.isTopAligned(dieRect, ioRect) && ioAngle == 180.0f) {
            q = IOViewDlg.Side.Top;
        } else if (IOView.isBottomAligned(dieRect, ioRect) && ioAngle == 0.0f) {
            q = IOViewDlg.Side.Bottom;
        }
        return q;
    }

    private static IOViewDlg.Side determineQTop(ARect dieRect, ARect ioRect, float ioAngle) {
        IOViewDlg.Side q = IOViewDlg.Side.Top;
        if (IOView.isRightAligned(dieRect, ioRect) && ioAngle == 270.0f) {
            q = IOViewDlg.Side.Right;
        } else if (IOView.isLeftAligned(dieRect, ioRect) && ioAngle == 90.0f) {
            q = IOViewDlg.Side.Left;
        }
        return q;
    }

    private static IOViewDlg.Side determineQLeft(ARect dieRect, ARect ioRect, float ioAngle) {
        IOViewDlg.Side q = IOViewDlg.Side.Left;
        if (IOView.isTopAligned(dieRect, ioRect) && ioAngle == 180.0f) {
            q = IOViewDlg.Side.Top;
        } else if (IOView.isBottomAligned(dieRect, ioRect) && ioAngle == 0.0f) {
            q = IOViewDlg.Side.Bottom;
        }
        return q;
    }

    private static int getIndexOfMin(long[] edgeDist) {
        return IntStream.range(0, edgeDist.length).boxed().min((i, j) -> Long.compare(edgeDist[i], edgeDist[j])).orElseThrow(() -> new IllegalArgumentException(String.format("getIndexOfMin failed to work on:'%s'", new Object[]{edgeDist})));
    }

    private static int determineQuadrantByRotation(DevicePath ioPath, DevicePath rootDevicePath) {
        Device d = ioPath.getLast();
        float angle = d.getRotate();
        return IOViewDlg.Side.determineSide(angle);
    }

    private static boolean isBottomAligned(ARect a, ARect b) {
        return a.bottom() == b.bottom();
    }

    private static boolean isTopAligned(ARect a, ARect b) {
        return a.top() == b.top();
    }

    private static boolean isLeftAligned(ARect a, ARect b) {
        return a.left() == b.left();
    }

    private static boolean isRightAligned(ARect a, ARect b) {
        return a.right() == b.right();
    }

    public static int determineQuadrant(DevicePath ioPath, DevicePath rootDevicePath) {
        Device d = ioPath.getLast();
        String side = (String)d.getValue(FLDNAME_INTERFACE_SIDE);
        if (side != null && !side.isEmpty()) {
            return IOViewDlg.Side.determineSide(side);
        }
        ARect dieRect = rootDevicePath.getDeviceTemplate().getBB();
        ARect ioRect = ioPath.getLocalBB();
        IOViewDlg.Side q = null;
        if (IOView.isBottomAligned(dieRect, ioRect)) {
            q = IOView.determineQBottom(dieRect, ioRect, ioPath.getRot());
        } else if (IOView.isRightAligned(dieRect, ioRect)) {
            q = IOView.determineQRight(dieRect, ioRect, ioPath.getRot());
        } else if (IOView.isTopAligned(dieRect, ioRect)) {
            q = IOView.determineQTop(dieRect, ioRect, ioPath.getRot());
        } else if (IOView.isLeftAligned(dieRect, ioRect)) {
            q = IOView.determineQLeft(dieRect, ioRect, ioPath.getRot());
        }
        if (q != null) {
            return q.getOrdinal();
        }
        DeviceTemplate.Type devType = ioPath.getDeviceTemplate().getType();
        if (theIOView != null && theIOView.getExcludeNotEdgeAlignedBumpDevices() && devType == DeviceTemplate.Type.BUMP) {
            return -1;
        }
        if (theIOView != null && theIOView.getExcludeNotEdgeAlignedCoverDevices() && devType == DeviceTemplate.Type.COVER) {
            return -1;
        }
        long[] edgeDist = new long[]{Math.abs(dieRect.right() - ioRect.right()), Math.abs(dieRect.top() - ioRect.top()), Math.abs(dieRect.left() - ioRect.left()), Math.abs(dieRect.bottom() - ioRect.bottom())};
        return IOView.getIndexOfMin(edgeDist);
    }

    private long adjustGapInsetBottom(IOViewBlock dblock, long dx, long dy, long gap) {
        dblock.gap = -dx;
        dblock.inset = -dy;
        return gap += -dx;
    }

    private long adjustGapInsetRight(IOViewBlock dblock, long dx, long dy, long gap) {
        dblock.gap = -dy;
        dblock.inset = dx;
        return gap += -dy;
    }

    private long adjustGapInsetTop(IOViewBlock dblock, long dx, long dy, long gap) {
        dblock.gap = dx;
        dblock.inset = dy;
        return gap += dx;
    }

    private long adjustGapInsetLeft(IOViewBlock dblock, long dx, long dy, long gap) {
        dblock.gap = dy;
        dblock.inset = -dx;
        return gap += dy;
    }

    private long adjustGapInsetBySide(IOViewBlock dblock, int side, int level, long gap, long dx, long dy) {
        if (dx != 0L || dy != 0L) {
            ALog.logInfo((String)"setting gap and inset for %d,%d", (Object[])new Object[]{dx, dy});
        }
        if (level != 0 || side == 3) {
            gap = this.adjustGapInsetBottom(dblock, dx, dy, gap);
        } else if (side == 0) {
            gap = this.adjustGapInsetRight(dblock, dx, dy, gap);
        } else if (side == 1) {
            gap = this.adjustGapInsetTop(dblock, dx, dy, gap);
        } else if (side == 2) {
            gap = this.adjustGapInsetLeft(dblock, dx, dy, gap);
        }
        return gap;
    }

    private Pair<Long, Long> getLLBySide(int side, IOViewBlock dblock, long start, long gap, long inset) {
        long x;
        long y;
        ARect dieRect = new ARect(this.getRootDevicePath().getDeviceTemplate().getBB());
        ALog.logInfo((String)"rePlaceBlock with die rect:%s, side:%d", (Object[])new Object[]{dieRect, side});
        if (side == 0) {
            y = dieRect.bottom();
            x = dieRect.right();
            y += start;
            y += gap;
            x -= inset;
            if (dblock.isInterface()) {
                y += dblock.marginLead;
            }
        } else if (side == 1) {
            y = dieRect.top();
            x = dieRect.right();
            x -= start;
            x -= gap;
            y -= inset;
            if (dblock.isInterface()) {
                x -= dblock.marginLead;
            }
        } else if (side == 2) {
            y = dieRect.top();
            x = dieRect.left();
            y -= start;
            y -= gap;
            x += inset;
            if (dblock.isInterface()) {
                y -= dblock.marginLead;
            }
        } else {
            y = dieRect.bottom();
            x = dieRect.left();
            x += start;
            x += gap;
            y += inset;
            if (dblock.isInterface()) {
                x += dblock.marginLead;
            }
        }
        return new Pair((Object)x, (Object)y);
    }

    protected RePlaceState rePlaceBlock(int level, int side, IOViewBlock dblock, RePlaceState state, boolean justAddGapInset) {
        APoint2D currenLL;
        long inset = dblock.inset;
        long gap = dblock.gap;
        long newLLx = 0L;
        long newLLy = 0L;
        Device dev = dblock.devicePath.getLast();
        long start = dev.getIsOverlay() ? state.lastCover : state.lastNonCover;
        if (level == 0) {
            Pair<Long, Long> ll = this.getLLBySide(side, dblock, start, gap, inset);
            newLLx = (Long)ll.getValue0();
            newLLy = (Long)ll.getValue1();
        } else if (level > 0) {
            newLLx = start;
            newLLx += gap;
            newLLy += inset;
            if (dblock.isInterface()) {
                newLLx += dblock.marginLead;
            }
        } else {
            ALog.logError((String)"Unexpected level:%d. Level should be larger than 0.", (Object[])new Object[]{level});
            throw new IllegalArgumentException();
        }
        if (level == 0) {
            ARect cRect = dev.getBB();
            currenLL = new APoint2D((APoint2D)IOViewDlg.Side.getSideInterfaceNameLoc((int)side, (ARect)cRect).second);
        } else {
            currenLL = new APoint2D(dev.getLocalBB().getLL());
        }
        if (currenLL.getX() != newLLx || currenLL.getY() != newLLy) {
            long dx = newLLx - currenLL.getX();
            long dy = newLLy - currenLL.getY();
            if (justAddGapInset) {
                gap = this.adjustGapInsetBySide(dblock, side, level, gap, dx, dy);
            } else if (!dev.getIsFixed()) {
                dev.moveBy(dx, dy);
            }
        }
        long myWidth = dblock.devicePath.getLast().getBB().width();
        if (dblock.isInterface()) {
            state.lastCover += gap + dblock.marginLead;
            state.lastNonCover += gap + dblock.marginLead;
        } else if (dev.getIsOverlay()) {
            state.lastCover += gap + myWidth;
        } else {
            state.lastNonCover += gap + myWidth;
        }
        RePlaceState newState = new RePlaceState();
        for (IOViewBlock childBlock : dblock.children) {
            if (level > 0) continue;
            newState = this.rePlaceBlock(level + 1, side, childBlock, newState, justAddGapInset);
        }
        state.lastCover = newState.lastCover + state.lastCover;
        state.lastNonCover = newState.lastNonCover + state.lastNonCover;
        return new RePlaceState(state);
    }

    private void assignInterface(Personality p, IOViewBlock fromBlock, Device fromDevice) {
        fromBlock.devicePath.getLast().assignToPersonality(p);
        fromDevice.setParent(p.getParentDevicePath().getLast(), true, true);
        fromDevice.assignToPersonality(p);
        fromBlock.devicePath = fromDevice.getADevicePath();
    }

    protected void insert(DevicePath from, DevicePath to, int index) {
        IOViewBlock fromBlock = this.getBlock(from);
        IOViewBlock toBlock = this.getBlock(to);
        if (!this.isInCPBuffer(from)) {
            ArrayAndIndex fromAAI = this.findArrayAndIndex(fromBlock);
            if (fromAAI.array.equals(toBlock.children) && fromAAI.index < index) {
                --index;
            }
            this.remove(fromBlock);
        } else {
            this.cpBuffer.remove(fromBlock);
        }
        if (index < 0) {
            toBlock.children.add(fromBlock);
        } else {
            toBlock.children.add(index, fromBlock);
        }
        fromBlock.parent = toBlock;
        fromBlock.side = toBlock.side;
        Device fromDevice = fromBlock.devicePath.getLast();
        if (!fromBlock.isInterface()) {
            Device d = toBlock.devicePath.getLast();
            if (toBlock.isInterface()) {
                DevicePath dp;
                fromBlock.buildPinNetStuff();
                Optional p = Personality.getPersonality((DeviceTemplate)toBlock.getDie().getTemplate(), (Personality.Type)Personality.Type.DEVICE, (String)IOView.getPersonalityNameForInterface(toBlock.getDevicePath()));
                fromDevice.setParent(toBlock.devicePath.getLast(), true, true);
                if (p.isPresent()) {
                    fromDevice.assignToPersonality((Personality)p.get());
                }
                fromBlock.devicePath = dp = to.withChild(fromDevice);
                fromBlock.remapPins();
            } else {
                this.assignInterface(d.getPersonality(), fromBlock, fromDevice);
            }
        }
        fromBlock.transformMe();
    }

    private void setSequence(IOViewBlock dblock) {
        int sequence = 0;
        for (IOViewBlock child : dblock.children) {
            child.setSequence(sequence);
            ++sequence;
        }
    }

    protected void buildCanvasFromIOView(int side, List<IOViewBlock> blocks, boolean justBuildGapAndInset) {
        if (blocks.isEmpty()) {
            return;
        }
        LayoutManager.deriveIOViewPlacement(blocks);
        for (IOViewBlock dblock : blocks) {
            if (!dblock.isInterface()) continue;
            this.setSequence(dblock);
        }
        ARect bounds = this.getRootDevicePath().getLast().getBB();
        ARect asParentBounds = new ARect(0L, 0L, bounds.width(), bounds.height());
        APair<String, APoint2D> np = IOViewDlg.Side.getSideInterfaceNameLoc(side, asParentBounds);
        if (justBuildGapAndInset) {
            this.deriveIOViewGapsInsetsMargins((APoint2D)np.second, side, blocks);
        } else {
            this.buildCanvasFromIOView((APoint2D)np.second, side, blocks);
        }
    }

    private void deriveIOViewGapsInsetsMargins(APoint2D origin, int side, List<IOViewBlock> blocks) {
        LayoutManager.buildGapInset(origin, side, blocks);
        this.debugOutputBuiltGapAndInset(blocks);
        this.debugOutputDevicesLoc(blocks, "");
    }

    private void buildCanvasFromIOView(APoint2D origin, int side, List<IOViewBlock> blocks) {
        LayoutManager.placement(origin, side, blocks);
        this.debugOutputDevicesLoc(blocks, "");
    }

    private void debugOutputDevicesLoc(List<IOViewBlock> blocks, String indent) {
        if (!debugPlacementDetails) {
            return;
        }
        for (IOViewBlock b : blocks) {
            if (b.isInPlacementGroup1()) continue;
            ALog.logInfo((String)(indent + "%s loc:%s"), (Object[])new Object[]{b.getDevicePath().getDevice().getName(), b.getDevicePath().getDevice().getLoc()});
            if (!b.isInterface()) continue;
            this.debugOutputDevicesLoc(b.children, indent + " ");
        }
    }

    private void debugOutputBuiltGapAndInset(List<IOViewBlock> blocks) {
        if (!debugPlacementDetails) {
            return;
        }
        for (IOViewBlock b : blocks) {
            if (b.isInPlacementGroup1() || !b.isInterface()) continue;
            this.debugOutputBuiltGapAndInset(b.children);
        }
    }

    public static void buildCanvasFromIOView(int side) {
        for (int s = 0; s < 4; ++s) {
            if (side != -1 && side != s) continue;
            List sideBlocks = IOView.theIOView.mBlocks.get(s);
            theIOView.buildCanvasFromIOView(s, sideBlocks, false);
        }
        theIOView.buildCovers();
        theIOView.updateNames();
    }

    public static void debugOutputPlacementDetails(String header) {
        if (!debugPlacementDetails) {
            return;
        }
        ALog.logInfo((String)("PLACEMENT DETAILS @ " + header));
        for (int s = 0; s < 4; ++s) {
            ALog.logInfo((String)"side %d", (Object[])new Object[]{s});
            List sideBlocks = IOView.theIOView.mBlocks.get(s);
            for (IOViewBlock b : sideBlocks) {
                IOView.debugOutputPlacementDetails(b);
            }
        }
    }

    private static void debugOutputPlacementDetails(IOViewBlock b) {
        ALog.logInfo((String)"%s, gap:%d, inset:%d, lead margin:%d, trail margin:%d", (Object[])new Object[]{b.getName(), b.gap, b.inset, b.marginLead, b.marginTrail});
        ALog.logInfo((String)" IOView placement:%s, %s", (Object[])new Object[]{b.ll, b.placementRect});
        ALog.logInfo((String)" Canvas placement:%s, %s,  %s", (Object[])new Object[]{b.getDevicePath().getLast().getLoc(), b.getDevicePath().getLoc(), b.getDevicePath().getLocalBB()});
        if (b.isInterface()) {
            for (IOViewBlock child : b.getChildren()) {
                IOView.debugOutputPlacementDetails(child);
            }
        }
    }

    private void normalizeInterfaceChildrenTransform(IOViewBlock b, Personality psn) {
        class TransformToDie {
            float rot;
            boolean mirror;

            public TransformToDie(boolean m, float r) {
                this.rot = r;
                this.mirror = m;
            }
        }
        TransformToDie t;
        HashMap<Device, TransformToDie> tToDie = new HashMap<Device, TransformToDie>();
        for (IOViewBlock child : b.children) {
            if (child.isInPlacementGroup1()) continue;
            DevicePath pathToDie = new DevicePath(child.devicePath);
            pathToDie.removeFirst();
            boolean m = pathToDie.getMirror();
            float r = pathToDie.getRot();
            t = new TransformToDie(m, r);
            tToDie.put(pathToDie.getLast(), t);
        }
        float interfaceAngle = ((Float)IOViewDlg.Side.getDescriptorAndAngle((int)b.side).second).floatValue();
        for (IOViewBlock child : b.children) {
            if (child.isInPlacementGroup1()) continue;
            DevicePath pathToDie = new DevicePath(child.devicePath);
            pathToDie.removeFirst();
            Device cDev = pathToDie.getLast();
            t = (TransformToDie)tToDie.get(cDev);
            cDev.setMirror(t.mirror);
            cDev.setRotate(t.rot - interfaceAngle);
        }
    }

    private void normalizeInterfaceLL(IOViewBlock b, Personality psn) {
        IOViewBlock firstChild = this.getFirstChildIOPad(b);
        if (firstChild == null) {
            return;
        }
        long firstChildGap = (Long)AUtil.getField((DbObject)psn, (String)FLDNAME_FIRST_CHILD_GAP, (Object)0L);
        long firstChildInset = (Long)AUtil.getField((DbObject)psn, (String)FLDNAME_FIRST_CHILD_INSET, (Object)0L);
        DevicePath intfPath = b.getDevicePath();
        DevicePath rel2Intf = intfPath.getRelativePath(firstChild.getDevicePath());
        ARect bb = rel2Intf.getLocalBB();
        APoint2D ll = bb.getLL();
        long xoff = ll.getX() - firstChildGap - b.marginLead;
        long yoff = ll.getY() - firstChildInset;
        if (xoff != 0L || yoff != 0L) {
            long ty;
            long tx;
            switch (b.side) {
                case 0: {
                    tx = -yoff;
                    ty = xoff;
                    break;
                }
                case 1: {
                    tx = -xoff;
                    ty = -yoff;
                    break;
                }
                case 2: {
                    tx = yoff;
                    ty = -xoff;
                    break;
                }
                case 3: {
                    tx = xoff;
                    ty = yoff;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            APoint2D t = new APoint2D(-tx, -ty);
            DevicePath dp = b.getDevicePath();
            dp.getDevice().moveBy(tx, ty);
            dp.getChildren().stream().forEach(child -> child.getDevice().moveBy(intfPath, t));
        }
    }

    private IOViewBlock getFirstChildIOPad(IOViewBlock intf) {
        return intf.getChildren().stream().filter(b -> !b.isInPlacementGroup1() && !b.isInterface()).findFirst().orElse(null);
    }

    private ARect getIOPadChildrenBoundsUnion(IOViewBlock intf) {
        DevicePath intfPath = intf.getDevicePath();
        ARect rc = intf.children.parallelStream().filter(child -> !child.isInPlacementGroup1()).map(child -> {
            DevicePath rel2Intf = intfPath.getRelativePath(child.getDevicePath());
            return rel2Intf.getBB();
        }).collect(ARect::createAFaultyRect, ARect::expand, ARect::expand);
        return !rc.isNormal() ? ARect.zero() : rc;
    }

    private ARect getMaxPlacementGroupBounds(IOViewBlock intf) {
        ARect group1 = this.getPlacementGroupBounds(intf, 0L);
        ARect group2 = this.getPlacementGroupBounds(intf, 1L);
        group1.expand(group2);
        return group1;
    }

    private ARect getPlacementGroupBounds(IOViewBlock intf, long group) {
        DevicePath intfPath = intf.getDevicePath();
        ARect rc = intf.children.parallelStream().filter(child -> child.getPlacementGroup() == group).map(child -> {
            DevicePath rel2Intf = intfPath.getRelativePath(child.getDevicePath());
            return rel2Intf.getBB();
        }).collect(ARect::createAFaultyRect, ARect::expand, ARect::expand);
        return !rc.isNormal() ? ARect.zero() : rc;
    }

    protected void normalizeInterfaceBounds(IOViewBlock b, Personality psn) {
        Device theInterface = b.getDevicePath().getLast();
        ARect rc = this.getMaxPlacementGroupBounds(b);
        this.addGapInsetMargins(rc, b, psn);
        ARect interfaceBounds = this.setInterfaceBySide(theInterface, rc, b.side);
        DeviceTemplate tplParent = theInterface.getTemplate();
        if (tplParent != null && !AUtil.equals((Object)tplParent.getBounds(), (Object)interfaceBounds)) {
            ALog.logInfo((String)"Normalize %s bounds from %s to %s", (Object[])new Object[]{tplParent.getName(), tplParent.getBounds(), interfaceBounds});
            tplParent.setBounds((AGeom)interfaceBounds);
        }
        if (psn != null) {
            Constraint.getOrCreate((DbObject)psn, (Constraint.Descriptor)Constraint.PLACE_AREA, (Object)rc);
        }
    }

    private void addGapInsetMargins(ARect rc, IOViewBlock intf, Personality psn) {
        long yExpand;
        long yOffset;
        assert (intf.marginLead >= 0L);
        assert (intf.marginTrail >= 0L);
        long firstChildGap = 0L;
        long firstChildInset = 0L;
        if (psn != null) {
            Long fcInset;
            Long fcGap = (Long)psn.getValue(FLDNAME_FIRST_CHILD_GAP);
            if (fcGap != null) {
                firstChildGap = fcGap;
            }
            if ((fcInset = (Long)psn.getValue(FLDNAME_FIRST_CHILD_INSET)) != null) {
                firstChildInset = fcInset;
            }
        }
        long front = intf.marginLead + firstChildGap;
        long back = intf.marginTrail;
        if (front == 0L && back == 0L && firstChildInset == 0L) {
            return;
        }
        long xOffset = front < 0L ? front : 0L;
        long l = yOffset = firstChildInset < 0L ? firstChildInset : 0L;
        if (xOffset != 0L || yOffset != 0L) {
            rc.moveBy(xOffset, yOffset);
        }
        long xExpand = front > 0L ? front + back : back;
        long l2 = yExpand = firstChildInset < 0L ? 0L : firstChildInset;
        if (xExpand != 0L || yExpand != 0L) {
            rc.expandBy(0L, 0L, xExpand, yExpand);
        }
    }

    private ARect setInterfaceBySide(Device theInterface, ARect rc, int side) {
        theInterface.setRotate(IOViewDlg.Side.getAngle(side));
        theInterface.setMirror(false);
        ARect newBounds = new ARect(0L, 0L, rc.width(), rc.height());
        return newBounds;
    }

    protected void updateSideInterfaceBounds(Map<?, IOViewInterface> sideInterfaces) {
        List intfs = sideInterfaces.entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toList());
        for (IOViewInterface intf : intfs) {
            IOViewBlock intfBlock = IOViewBlock.findBlock(intf.device);
            if (intfBlock == null) continue;
            this.normalizeInterfaceLL(intfBlock, intf.personality);
            this.normalizeInterfaceBounds(intfBlock, intf.personality);
        }
    }

    protected void updateInterfaceBoundsBACK(Map<?, IOViewInterface> sideInterfaces) {
        for (int s = 0; s < 4; ++s) {
            List sideBlocks = IOView.theIOView.mBlocks.get(s);
            List interfaces = sideBlocks.stream().filter(IOViewBlock::isInterface).map(this::getIOViewInterface).collect(Collectors.toList());
            for (APair intf : interfaces) {
                this.normalizeInterfaceLL((IOViewBlock)intf.first, (Personality)intf.second);
            }
            for (APair intf : interfaces) {
                this.normalizeInterfaceBounds((IOViewBlock)intf.first, (Personality)intf.second);
            }
        }
    }

    private APair<IOViewBlock, Personality> getIOViewInterface(IOViewBlock b) {
        Personality devicePersonality;
        String psnName = IOView.getPersonalityNameForInterface(b.getDevicePath());
        Optional p = Personality.getPersonality((DeviceTemplate)b.getDie().getTemplate(), (Personality.Type)Personality.Type.DEVICE, (String)psnName);
        if (!p.isPresent()) {
            devicePersonality = IOView.createInterfacePersonality(psnName, b.side, b.hard, b.ignoreGrid, b.gap, b.inset, b.marginLead, b.marginTrail);
            ALog.logInfo((String)"Create personality '%s' for IO interface '%s'", (Object[])new Object[]{devicePersonality.getName(), b.getName()});
        } else {
            devicePersonality = (Personality)p.get();
        }
        return new APair((Object)b, (Object)devicePersonality);
    }

    private void clearIOViewBlocks() {
        this.saveAttributesToPersonalities();
        this.mBlocks.clear();
    }

    public static void buildIOViewFromCanvasUser() {
        if (theIOView == null) {
            return;
        }
        if (IOView.theIOView.delayBuilding) {
            return;
        }
        theIOView.buildIOViewFromCanvas();
        IOView.debugOutputPlacementDetails("buildIOViewFromCanvasUser");
    }

    public static void createUniqueDeviceNames(String pathString) {
        DevicePath child = IOView.getDevicePathFromString(pathString);
        if (child == null) {
            ALog.logError((String)"%s is not a valid device path.", (Object[])new Object[]{pathString});
            return;
        }
        child.getDescendants().parallelStream().forEach(c -> {
            Device d = c.getLast();
            if (d.getIsSubstrate() || d.hasChildren()) {
                return;
            }
            String side = (String)d.getValue(FLDNAME_INTERFACE_SIDE);
            if (side == null) {
                side = "edge";
            }
            String baseName = d.getName();
            baseName = baseName.replace("edge_", "");
            baseName = baseName.replace("top_", "");
            baseName = baseName.replace("left_", "");
            baseName = baseName.replace("right_", "");
            String newName = side + "_" + (baseName = baseName.replace("bottom_", ""));
            if (!newName.equals(d.getName())) {
                d.setName(newName);
            }
        });
    }

    public static void removeBlockFromParent(String childPath, String parentPath) {
        DevicePath child = IOView.getDevicePathFromString(childPath);
        if (child == null) {
            ALog.logInfo((String)(childPath + " is not a device"));
            return;
        }
        DevicePath parent = IOView.getDevicePathFromString(parentPath);
        if (parent == null) {
            ALog.logInfo((String)(parentPath + " is not a device"));
            return;
        }
        IOViewBlock parentBlock = theIOView.getBlock(parent);
        IOViewBlock childBlock = theIOView.getBlock(child);
        parentBlock.children.remove(childBlock);
        child.getLast().deleteFromDb();
        theIOView.fireIOViewChanged();
    }

    public static void cutBlockFromParent(String childPath, String parentPath) {
        DevicePath child = IOView.getDevicePathFromString(childPath);
        if (child == null) {
            ALog.logInfo((String)(childPath + " is not a device"));
            return;
        }
        DevicePath parent = IOView.getDevicePathFromString(parentPath);
        if (parent == null) {
            ALog.logInfo((String)(parentPath + " is not a device"));
            return;
        }
        IOViewBlock parentBlock = theIOView.getBlock(parent);
        IOViewBlock childBlock = theIOView.getBlock(child);
        parentBlock.children.remove(childBlock);
        theIOView.fireIOViewChanged();
    }

    public static void buldCanvasAndIOView() {
        IOView.buildCanvasFromIOView(-1);
        IOView.buildIOViewFromCanvasUser();
    }

    public static void somethingChanged() {
        theIOView.fireIOViewChanged();
    }

    public static void removeBlockFromSide(String fromPath, int side) {
        SideBlocks sb = IOView.theIOView.mBlocks.get(side);
        DevicePath from = IOView.getDevicePathFromString(fromPath);
        if (from == null) {
            ALog.logInfo((String)(fromPath + " is not a device"));
            return;
        }
        IOViewBlock block = theIOView.getBlock(from);
        PersonalityUI.deletePersonalityOfDevTemp(block.getName(), Personality.Type.DEVICE, block.getDie().getTemplate().getKeyStr());
        block.children.stream().forEach(childBlock -> {
            Device child = childBlock.devicePath.getLast();
            child.deleteFromDb();
        });
        block.children.clear();
        sb.remove(block);
        Device interfaceD = block.devicePath.getLast();
        DeviceTemplate interfaceT = interfaceD.getTemplate();
        block.devicePath.getLast().deleteFromDb();
        interfaceT.deleteFromDb();
        theIOView.buildCanvasFromIOView(side, sb, false);
        IOView.buildIOViewFromCanvasUser();
    }

    public static void cutBlockFromSide(String fromPath, int side) {
        SideBlocks sb = IOView.theIOView.mBlocks.get(side);
        DevicePath from = IOView.getDevicePathFromString(fromPath);
        if (from == null) {
            ALog.logInfo((String)(fromPath + " is not a device"));
            return;
        }
        IOViewBlock block = theIOView.getBlock(from);
        sb.remove(block);
        theIOView.buildCanvasFromIOView(side, sb, false);
        IOView.buildIOViewFromCanvasUser();
    }

    public static void addBlockToSide(IOViewBlock block, int side, int index) {
        SideBlocks sb = IOView.theIOView.mBlocks.get(side);
        if (index == -1) {
            sb.add(block);
        } else {
            sb.add(index, block);
        }
        if (!IOView.theIOView.delayBuilding) {
            theIOView.buildCanvasFromIOView(side, sb, false);
            IOView.buildIOViewFromCanvasUser();
        }
    }

    public static void addDeviceToCPBuffer(String devicePath) {
        DevicePath from = IOView.getDevicePathFromString(devicePath);
        if (from == null) {
            ALog.logInfo((String)(devicePath + " is not a device"));
            return;
        }
        IOViewBlock fromBlock = theIOView.getBlock(from);
        IOView.theIOView.cpBuffer.add(fromBlock);
    }

    public static void addBlockToParent(IOViewBlock block, IOViewBlock parent, int index) {
        if (index == -1) {
            parent.children.add(block);
        } else {
            parent.children.add(index, block);
        }
        if (!IOView.theIOView.delayBuilding) {
            IOView.buildCanvasFromIOView(-1);
            IOView.buildIOViewFromCanvasUser();
        }
    }

    public static void addToSide(IOViewBlock block) {
        SideBlocks sb = IOView.theIOView.mBlocks.get(block.side);
        sb.add(block);
        theIOView.fireIOViewChanged();
    }

    public static void insertToSide(String fromPath, int side, int index) {
        DevicePath from = IOView.getDevicePathFromString(fromPath);
        if (from == null) {
            ALog.logInfo((String)(fromPath + " is not a device"));
            return;
        }
        IOViewBlock fromBlock = theIOView.getBlock(from);
        if (theIOView.isInCPBuffer(from)) {
            IOView.theIOView.cpBuffer.remove(fromBlock);
        } else {
            theIOView.remove(fromBlock);
        }
        if (index >= IOView.theIOView.mBlocks.get(side).size()) {
            IOView.theIOView.mBlocks.get(side).add(fromBlock);
        } else {
            IOView.theIOView.mBlocks.get(side).add(index, fromBlock);
        }
        fromBlock.side = side;
        fromBlock.children.parallelStream().forEach(c -> {
            c.side = side;
        });
        fromBlock.transformMe();
        IOView.buildCanvasFromIOView(-1);
        theIOView.fireIOViewChanged();
    }

    private static DevicePath merge(DevicePath parent, String child) {
        if (((String)child).startsWith("/")) {
            return DevicePath.fromString((Db)OrbitApp.getCurDb(), (String)child);
        }
        int depth = DevicePath.getDepth((DevicePath)parent);
        Object last = parent.getSubPath(depth - 1, depth).toString();
        if (!((String)last).startsWith(".")) {
            last = "." + (String)last;
        }
        if (((String)child).startsWith((String)last)) {
            child = ((String)child).substring(((String)last).length());
        }
        if (!((String)child).isEmpty()) {
            child = "." + (String)child;
            return parent.addPath((String)child);
        }
        return new DevicePath(parent);
    }

    public static DevicePath getDevicePathFromString(String pathString) {
        DevicePath parentPath = theIOView.getRootDevicePath();
        return IOView.merge(parentPath, pathString);
    }

    public static void insert(String fromPath, String toPath, int index) {
        DevicePath from = IOView.getDevicePathFromString(fromPath);
        if (from == null) {
            ALog.logError((String)"%s is not a valid device path", (Object[])new Object[]{fromPath});
            return;
        }
        DevicePath to = IOView.getDevicePathFromString(toPath);
        if (to == null) {
            ALog.logError((String)"%s is not a valid device path", (Object[])new Object[]{toPath});
            return;
        }
        theIOView.insert(from, to, index);
        IOView.buildCanvasFromIOView(-1);
        IOView.buildIOViewFromCanvasUser();
        theIOView.fireIOViewChanged();
    }

    static String getPersonalityNameForRouteGroup(DevicePath iovBlockDevicePath) {
        return "RG_" + iovBlockDevicePath.toString();
    }

    static String getPersonalityNameForInterface(DevicePath parentPath, String name) {
        return parentPath.toString() + "/" + name;
    }

    static String getPersonalityNameForInterface(DevicePath iovBlockDevicePath) {
        return iovBlockDevicePath.toString();
    }

    public static String getPersonalityNameForNet(String netName) {
        return String.format("Net_%s", netName);
    }

    @Deprecated
    public static void migratePersonalityName(String path) {
        DevicePath from = IOView.getDevicePathFromString(path);
        if (from == null) {
            ALog.logInfo((String)(path + " is not a device"));
            return;
        }
        IOViewBlock fromBlock = theIOView.getBlock(from);
        String psnName = IOView.getPersonalityNameForInterface(fromBlock.getDevicePath());
        Optional newp = Personality.getPersonality((DeviceTemplate)fromBlock.getDie().getTemplate(), (Personality.Type)Personality.Type.DEVICE, (String)psnName);
        String psnNameOld = fromBlock.getDesiredName();
        Optional oldp = Personality.getPersonality((DeviceTemplate)fromBlock.getDie().getTemplate(), (Personality.Type)Personality.Type.DEVICE, (String)psnNameOld);
        if (oldp.isPresent()) {
            if (newp.isPresent()) {
                ((Personality)newp.get()).deleteFromDb();
            }
            ((Personality)oldp.get()).setName(psnName);
        } else {
            ALog.logWarn((String)"No personality has the old-styled name:%s", (Object[])new Object[]{fromBlock.getDesiredName()});
        }
    }

    @Deprecated
    public static void migrateAllPersonalityNames() {
        List<IOViewBlock> flat = theIOView.flattenAll();
        for (IOViewBlock b : flat) {
            if (!b.isInterface()) continue;
            IOView.migratePersonalityName(b.devicePath.toString());
        }
    }

    private static boolean getBooleanConstraint(Db db, DbObject owner, Constraint.Descriptor<Boolean> constraintKey, boolean defaultValue) {
        Constraint constraint = Constraint.getConstraint((Db)db, (DbObject)owner, constraintKey);
        return constraint != null ? (Boolean)constraint.getValue() : defaultValue;
    }

    private static ProgramableTilePlacer createPTPWithClosestParent(DevicePath from, String rule) {
        int len = DevicePath.getDepth((DevicePath)from);
        for (int i = len - 1; i > 0; --i) {
            DevicePath dp = from.getSubPath(0, i);
            ProgramableTilePlacer ptp = new ProgramableTilePlacer(dp.getLast());
            if (ptp.getTileRule(rule) == null) continue;
            return ptp;
        }
        return null;
    }

    public static void decorate(String path, String rule) {
        Db db = OrbitApp.getCurDb();
        DevicePath from = IOView.getDevicePathFromString(path);
        if (from == null) {
            ALog.logInfo((String)(path + " is not a device"));
            return;
        }
        IOViewBlock fromBlock = theIOView.getBlock(from);
        ProgramableTilePlacer ptp = IOView.createPTPWithClosestParent(from, rule);
        if (ptp == null) {
            ALog.logInfo((String)"Could not find tile defintion:%s from %s", (Object[])new Object[]{rule, from});
            return;
        }
        if (ptp.alreadyDecorated(fromBlock)) {
            ALog.logInfo((String)(fromBlock.getName() + " is already decorated"));
            return;
        }
        List<IOViewBlock> newchildren = ptp.transform(fromBlock, rule);
        if (newchildren != null) {
            IOView.setPlacementGroup(newchildren);
            String persName = IOView.getPersonalityNameForInterface(fromBlock.getDevicePath());
            Optional p = Personality.getPersonality((DeviceTemplate)fromBlock.getDie().getTemplate(), (Personality.Type)Personality.Type.DEVICE, (String)persName);
            if (!p.isPresent()) {
                ALog.logError((String)"P should always be present");
            }
            assert (p.isPresent());
            Personality psn = (Personality)p.get();
            Constraint.getOrCreate((DbObject)psn, (Constraint.Descriptor)Constraint.DECORATION_NAME, (Object)rule);
            fromBlock.marginLead = (Long)AUtil.getField((DbObject)psn, (String)FLDNAME_INTERFACE_MARGIN_LEAD, (Object)fromBlock.marginLead);
            fromBlock.marginTrail = (Long)AUtil.getField((DbObject)psn, (String)FLDNAME_INTERFACE_MARGIN_TRAIL, (Object)fromBlock.marginTrail);
            fromBlock.gap = (Long)AUtil.getField((DbObject)psn, (String)FLDNAME_INTERFACE_GAP, (Object)fromBlock.gap);
            fromBlock.inset = (Long)AUtil.getField((DbObject)psn, (String)FLDNAME_INTERFACE_INSET, (Object)fromBlock.inset);
            theIOView.fireInterfaceDecorated(from);
            fromBlock.children = newchildren;
            IOView.buildCanvasFromIOView(fromBlock.side);
            IOView.buildIOViewFromCanvasUser();
            fromBlock.calcCRCAndSet();
        } else {
            DbHistory h = db.getHistory();
            h.undo();
            IOView.buildIOViewFromCanvasUser();
        }
    }

    private static void setPlacementGroup(List<IOViewBlock> iovbs) {
        iovbs.stream().forEach(iovb -> {
            Device d = iovb.getDevicePath().getDevice();
            if (d.getType() == DeviceTemplate.Type.COVER) {
                d.setPlacementGroup(1L);
            }
        });
    }

    public static void mirrorInterface(String path) {
        DevicePath from = IOView.getDevicePathFromString(path);
        if (from == null) {
            ALog.logError((String)"%s is not a valid device path");
            return;
        }
        IOViewBlock fromBlock = theIOView.getBlock(from);
        ArrayList<IOViewBlock> list = new ArrayList<IOViewBlock>();
        for (IOViewBlock c : fromBlock.children) {
            list.add(0, c);
            c.defaultXform = IOView.createOrientForOrbit(c.defaultXform.getRot(), !c.defaultXform.getMirror());
            c.setDeviceXFormFromIOViewBlock(c.devicePath.getLast());
        }
        fromBlock.children = list;
        IOView.buildCanvasFromIOView(-1);
        IOView.buildIOViewFromCanvasUser();
    }

    private static IOViewBlock newInterfaceBlock(IOViewBlock interfaceBlock, String interfaceName) {
        IOViewBlock interfaceClone = new IOViewBlock(interfaceName);
        IOView.copyDeviceBlock(interfaceClone, interfaceBlock);
        interfaceClone.marginLead = interfaceBlock.marginLead;
        interfaceClone.marginTrail = interfaceBlock.marginTrail;
        interfaceClone.parent = null;
        interfaceClone.devicePath = theIOView.getRootDevicePath().copy();
        interfaceClone.gap = 0L;
        return interfaceClone;
    }

    private static void copyDeviceBlock(IOViewBlock target, IOViewBlock source) {
        Objects.requireNonNull(target, "Clone target cannot be null value.");
        Objects.requireNonNull(source, "Clone source cannot be null value.");
        target.byTemplate = source.byTemplate;
        target.template = source.template;
        target.side = source.side;
        target.height = source.height;
        target.width = source.width;
        target.inset = source.inset;
        target.gap = source.gap;
        target.inset = source.inset;
        target.hard = source.hard;
        target.ignoreGrid = source.ignoreGrid;
        target.overlay = source.overlay;
        target.defaultXform = source.defaultXform;
    }

    public static void cloneInterface(String path, int copies) {
        theIOView.setDelayBuilding(true);
        DevicePath from = IOView.getDevicePathFromString(path);
        IOViewBlock interfaceB = theIOView.getBlock(from);
        String baseName = interfaceB.getName();
        ANameCloner anc = new ANameCloner();
        anc.setBaseName(baseName);
        SideBlocks sb = IOView.theIOView.mBlocks.get(interfaceB.side);
        int thisIndex = sb.indexOf(interfaceB);
        for (int i = 0; i < copies; ++i) {
            DevicePath myConstructedPath;
            String interfaceName = anc.getNextName();
            IOViewBlock interfaceClone = IOView.newInterfaceBlock(interfaceB, interfaceName);
            IOViewBlock.setWorkingBlock(null, interfaceClone);
            interfaceClone = IOViewBlock.workingBlock;
            Device interfaceDevice = interfaceClone.createDevicePersonality(interfaceName);
            interfaceClone.devicePath = myConstructedPath = from.getParent().withChild(interfaceDevice);
            String clonePersName = IOView.getPersonalityNameForInterface(from.getParent(), interfaceClone.getName());
            Optional clonePersonality = Personality.getPersonality((DeviceTemplate)interfaceB.getDie().getTemplate(), (Personality.Type)Personality.Type.DEVICE, (String)clonePersName);
            if (clonePersonality.isPresent()) {
                Personality p = (Personality)clonePersonality.get();
                interfaceClone.setPersonalityFields(p);
            } else {
                ALog.logError((String)"Failed to create clone interface, for device:%s", (Object[])new Object[]{interfaceClone.getDevicePath()});
                assert (false);
            }
            IOView.addBlockToSide(interfaceClone, interfaceClone.side, ++thisIndex);
            IOView.copyChildren(interfaceClone, interfaceB, baseName, interfaceName);
        }
        theIOView.setDelayBuilding(false);
        IOView.buildCanvasFromIOView(-1);
        IOView.buildIOViewFromCanvasUser();
    }

    private static void copyChildren(IOViewBlock targetInterface, IOViewBlock sourceInterface, String netNameChangeSrc, String netNameChangeTgt) {
        for (IOViewBlock baseBlock : sourceInterface.children) {
            IOViewBlock clone = new IOViewBlock(baseBlock.getName());
            Device baseDevice = baseBlock.devicePath.getLast();
            IOView.copyDeviceBlock(clone, baseBlock);
            clone.parent = targetInterface;
            clone.makeDbDevice();
            Device cloneDevice = clone.devicePath.getLast();
            cloneDevice.setSourceType(baseDevice.getSourceType());
            IOView.copyPlacementGroup(cloneDevice, baseDevice);
            targetInterface.children.add(clone);
            if (baseDevice.getValue(FLDNAME_MODE) != null) {
                cloneDevice.setValue(FLDNAME_MODE, baseDevice.getValue(FLDNAME_MODE));
            }
            IOView.duplicateNetMap(baseDevice, cloneDevice, clone.getDevicePath(), netNameChangeSrc, netNameChangeTgt);
        }
    }

    private static void copyPlacementGroup(Device target, Device source) {
        long g;
        try {
            g = source.getPlacementGroup();
        }
        catch (Exception e) {
            g = 0L;
        }
        target.setPlacementGroup(g);
    }

    private static void duplicateNetMap(Device baseDevice, Device cloneDevice, DevicePath cloneDevicePath, String netNameChangeSrc, String netNameChangeTgt) {
        PinInstance pad = null;
        for (PinInstance basePinInstance : baseDevice.getPins()) {
            PinTemplate dtp = basePinInstance.getPinTemplate();
            Net parentNet = NetMap.getParentNet((Device)baseDevice, (Net)basePinInstance.getNet());
            if (parentNet == null || (pad = cloneDevice.getPin(dtp)) == null) continue;
            String parentName = parentNet.getName();
            Object cloneName = parentName.contains(netNameChangeSrc) ? parentName.replace(netNameChangeSrc, netNameChangeTgt) : netNameChangeTgt + "_" + parentName;
            NetMap.mapThroughPath((DevicePath)cloneDevicePath, (PinInstance)pad, (String)cloneName);
        }
    }

    private static boolean isNonEmptyInterface(IOViewBlock b) {
        return b.children != null && !b.children.isEmpty() && b.children.get(0) != null;
    }

    public static String getDecorationName(IOViewBlock b) {
        Db db = OrbitApp.getCurDb();
        if (!IOView.isNonEmptyInterface(b)) {
            return null;
        }
        String persName = IOView.getPersonalityNameForInterface(b.getDevicePath());
        Optional p = Personality.getPersonality((DeviceTemplate)b.getDie().getTemplate(), (Personality.Type)Personality.Type.DEVICE, (String)persName);
        if (!p.isPresent()) {
            return null;
        }
        Constraint constraint = Constraint.getConstraint((Db)db, (DbObject)((DbObject)p.get()), (Constraint.Descriptor)Constraint.DECORATION_NAME);
        if (constraint == null) {
            return null;
        }
        return (String)constraint.getValue();
    }

    public static void setDecorationName(IOViewBlock b, String name) {
        if (!b.isInterface()) {
            return;
        }
        String persName = IOView.getPersonalityNameForInterface(b.getDevicePath());
        Optional p = Personality.getPersonality((DeviceTemplate)b.getDie().getTemplate(), (Personality.Type)Personality.Type.DEVICE, (String)persName);
        if (p.isPresent()) {
            Constraint.getOrCreate((DbObject)((DbObject)p.get()), (Constraint.Descriptor)Constraint.DECORATION_NAME, (Object)name);
        } else {
            ALog.logError((String)"Personality '%s' does not exist!", (Object[])new Object[]{persName});
        }
    }

    public static void changeDecorationAll(boolean decorate) {
        List<IOViewBlock> flat = theIOView.flattenAll();
        for (IOViewBlock b : flat) {
            if (!b.isInterface()) continue;
            String decorationName = IOView.getDecorationName(b);
            if (decorate) {
                if (decorationName == null || decorationName.isEmpty()) continue;
                ALog.logInfo((String)("Decorating " + b.devicePath.getString() + " with " + decorationName));
                IOView.decorate(b.devicePath.toString(), decorationName);
                continue;
            }
            IOView.unDecorate(b.devicePath.toString(), decorationName);
        }
    }

    public static void approveAll() {
        List<IOViewBlock> flat = theIOView.flattenAll();
        for (IOViewBlock b : flat) {
            if (!b.isInterface()) continue;
            b.calcCRCAndSet();
        }
    }

    public static boolean doIManage(DevicePath path) {
        return theIOView != null && theIOView.getBlock(path) != null;
    }

    private Pair<Long, Long> getSnapDS(String sideName, APoint2D p, AGrid grid) {
        long dx = 0L;
        long dy = 0L;
        if (sideName.equals("top")) {
            dx = AGridUtil.snapDS((long)p.getX(), (long)grid.getOrignX(), (long)grid.getDeltaX(), (boolean)false);
        } else if (sideName.equals("bottom")) {
            dx = AGridUtil.snapDS((long)p.getX(), (long)grid.getOrignX(), (long)grid.getDeltaX(), (boolean)true);
        } else if (sideName.equals("left")) {
            dy = AGridUtil.snapDS((long)p.getY(), (long)grid.getOrignY(), (long)grid.getDeltaY(), (boolean)false);
        } else if (sideName.equals("right")) {
            dy = AGridUtil.snapDS((long)p.getY(), (long)grid.getOrignY(), (long)grid.getDeltaY(), (boolean)true);
        }
        return new Pair((Object)dx, (Object)dy);
    }

    private HierPort getFirstPortOfBumpOrCoverDevice(IOViewBlock interfaceDevice) {
        HierPort sBump = null;
        for (IOViewBlock child : interfaceDevice.children) {
            PortTemplate portTemplate;
            Device d = child.devicePath.getLast();
            if (d.getTemplate().getType() != DeviceTemplate.Type.BUMP && d.getTemplate().getType() != DeviceTemplate.Type.COVER) continue;
            PinInstance pinInstance = d.getAnyPin();
            if (pinInstance == null || (portTemplate = pinInstance.getPinTemplate().getFirstPortTemplate()) == null) break;
            sBump = new HierPort(child.devicePath, portTemplate);
            break;
        }
        return sBump;
    }

    APoint2D getSnapForThisInterface(IOViewBlock interfaceDevice) {
        APoint2D snapDs = new APoint2D();
        AGrid grid = interfaceDevice.getGrid();
        if (grid == null) {
            return snapDs;
        }
        HierPort sBump = this.getFirstPortOfBumpOrCoverDevice(interfaceDevice);
        if (sBump == null) {
            return snapDs;
        }
        APoint2D p = sBump.getSubstrateLoc();
        Pair<Long, Long> ds = this.getSnapDS(interfaceDevice.getSideName(), p, grid);
        snapDs.setX(((Long)ds.getValue0()).longValue());
        snapDs.setY(((Long)ds.getValue1()).longValue());
        return snapDs;
    }

    protected void snapIOCells() {
        ALog.logInfo((String)"snapping phase 1");
        for (int side = 0; side < 4; ++side) {
            APoint2D addSnapDs = new APoint2D(0L, 0L);
            ArrayList sideBlocks = this.mBlocks.get(side);
            List flatList = sideBlocks.stream().flatMap(iDevice -> iDevice.children.stream()).collect(Collectors.toList());
            if (side == 1 || side == 2) {
                Collections.reverse(flatList);
            }
            for (IOViewBlock ioPad : flatList) {
                APoint2D thisSnapDs;
                APoint2D p;
                Substrate s = ioPad.devicePath.getSubstrate();
                NamedGrid ng = NamedGrid.get((Substrate)s, (String)"Manufacturing Grid");
                AGrid grid = null;
                if (ng != null) {
                    grid = ng.getGrid();
                }
                if (grid == null) continue;
                long dx = 0L;
                long dy = 0L;
                if (side == 0) {
                    ioPad.devicePath.getLast().moveBy(addSnapDs);
                    p = ioPad.getSubstrateLoc();
                    dy = AGridUtil.snapDS((long)p.getY(), (long)grid.getOrignY(), (long)grid.getDeltaY(), (boolean)true);
                    thisSnapDs = new APoint2D(dy, 0L);
                    if (thisSnapDs.getX() != 0L) {
                        ioPad.devicePath.getLast().moveBy(thisSnapDs);
                        ALog.logInfo((String)("Moving " + ioPad.devicePath.toString() + " by " + thisSnapDs.getX() + "," + thisSnapDs.getY()));
                    }
                    addSnapDs = addSnapDs.add(thisSnapDs);
                    continue;
                }
                if (side == 1) {
                    ioPad.devicePath.getLast().moveBy(addSnapDs);
                    p = ioPad.getSubstrateLoc();
                    dx = AGridUtil.snapDS((long)p.getX(), (long)grid.getOrignX(), (long)grid.getDeltaX(), (boolean)true);
                    thisSnapDs = new APoint2D(-dx, 0L);
                    if (thisSnapDs.getX() != 0L || thisSnapDs.getY() != 0L) {
                        ioPad.devicePath.getLast().moveBy(thisSnapDs);
                        p = ioPad.getSubstrateLoc();
                        dx = AGridUtil.snapDS((long)p.getX(), (long)grid.getOrignX(), (long)grid.getDeltaX(), (boolean)true);
                        ALog.logInfo((String)("Moving " + ioPad.devicePath.toString() + " by " + thisSnapDs.getX() + "," + thisSnapDs.getY()));
                    }
                    addSnapDs = addSnapDs.add(thisSnapDs);
                    continue;
                }
                if (side == 2) {
                    ioPad.devicePath.getLast().moveBy(addSnapDs);
                    p = ioPad.getSubstrateLoc();
                    dy = AGridUtil.snapDS((long)p.getY(), (long)grid.getOrignY(), (long)grid.getDeltaY(), (boolean)true);
                    thisSnapDs = new APoint2D(-dy, 0L);
                    if (thisSnapDs.getX() != 0L) {
                        ioPad.devicePath.getLast().moveBy(thisSnapDs);
                        p = ioPad.getSubstrateLoc();
                        dy = AGridUtil.snapDS((long)p.getY(), (long)grid.getOrignY(), (long)grid.getDeltaY(), (boolean)true);
                        ALog.logInfo((String)("Moving " + ioPad.devicePath.toString() + " by " + thisSnapDs.getX() + "," + thisSnapDs.getY()));
                    }
                    addSnapDs = addSnapDs.add(thisSnapDs);
                    continue;
                }
                ioPad.devicePath.getLast().moveBy(addSnapDs);
                p = ioPad.getSubstrateLoc();
                dx = AGridUtil.snapDS((long)p.getX(), (long)grid.getOrignX(), (long)grid.getDeltaX(), (boolean)true);
                thisSnapDs = new APoint2D(dx, 0L);
                if (thisSnapDs.getX() != 0L || thisSnapDs.getY() != 0L) {
                    ioPad.devicePath.getLast().moveBy(thisSnapDs);
                    ALog.logInfo((String)("Moving " + ioPad.devicePath.toString() + " by " + thisSnapDs.getX() + "," + thisSnapDs.getY()));
                }
                addSnapDs = addSnapDs.add(thisSnapDs);
            }
        }
    }

    protected void snapInterfaces() {
        for (int side = 0; side < 4; ++side) {
            APoint2D addSnapDs = new APoint2D(0L, 0L);
            ArrayList sideBlocks = this.mBlocks.get(side);
            for (IOViewBlock interfaceDevice : sideBlocks) {
                long dy;
                long dx;
                if (side == 0 || side == 2) {
                    dx = 0L;
                    dy = addSnapDs.getY();
                } else if (side == 1 || side == 3) {
                    dx = addSnapDs.getX();
                    dy = 0L;
                } else {
                    String msg = String.format("Unexpected side. Side can only be from 0 to 3. side:%d", side);
                    throw new IllegalArgumentException(msg);
                }
                interfaceDevice.devicePath.getLast().moveBy(dx, dy);
                APoint2D thisSnapDs = this.getSnapForThisInterface(interfaceDevice);
                interfaceDevice.devicePath.getLast().moveBy(thisSnapDs);
                addSnapDs = addSnapDs.add(thisSnapDs);
            }
        }
    }

    protected static void setup(IOView view) {
        db2view.put(view.getDb(), view);
        theIOView = view;
    }

    protected static void shutDown() {
        if (theIOView != null && theIOView.getDb() != null) {
            db2view.remove(theIOView.getDb());
        }
        theIOView = null;
    }

    public static void approveInterface(String path) {
        DevicePath from = IOView.getDevicePathFromString(path);
        if (from == null) {
            ALog.logError((String)"%s is not a valid device path", (Object[])new Object[]{path});
            return;
        }
        IOViewBlock fromBlock = theIOView.getBlock(from);
        fromBlock.calcCRCAndSet();
    }

    public static void unDecorate(String path, String rule) {
        DevicePath from = IOView.getDevicePathFromString(path);
        if (from == null) {
            ALog.logError((String)"%s is not a valid device path", (Object[])new Object[]{path});
            return;
        }
        IOViewBlock fromBlock = theIOView.getBlock(from);
        ProgramableTilePlacer ptp = new ProgramableTilePlacer(fromBlock.getDevicePath().getFirst());
        List<IOViewBlock> newchildren = ptp.untransform(fromBlock.children, rule);
        fromBlock.children = newchildren;
        IOView.buildCanvasFromIOView(-1);
        IOView.buildIOViewFromCanvasUser();
    }

    public static void markAsUndecorated(String path, String rule) {
        DevicePath from = IOView.getDevicePathFromString(path);
        if (from == null) {
            ALog.logError((String)"%s is not a valid device path", (Object[])new Object[]{path});
            return;
        }
        IOViewBlock fromBlock = theIOView.getBlock(from);
        ProgramableTilePlacer ptp = new ProgramableTilePlacer(fromBlock.getDevicePath().getFirst());
        List<IOViewBlock> newchildren = ptp.markAsUndecorated(fromBlock.children, rule);
        fromBlock.children = newchildren;
        IOView.buildCanvasFromIOView(-1);
        IOView.buildIOViewFromCanvasUser();
    }

    public static Long getCRC(Device device) {
        Object crc = device.getValue(FLDNAME_CRC);
        return crc != null ? (Long)crc : null;
    }

    public static void setCRC(Device device, Long crc) {
        if (crc == null) {
            ALog.logInfo((String)"");
        } else {
            device.setValue(FLDNAME_CRC, (Object)crc);
        }
    }

    public static String createDefaultNetNameForIOPAD(String interfaceName, String cellName, PinTemplate thisPort, List<PinTemplate> ioPorts) {
        String stmt = String.format("makeANetName(\"%s\", \"%s\", null, %b, \"%s\")", thisPort.getKeyStr(), cellName, true, interfaceName);
        Interpreter interpreter = Cp.getCp().getInterpreter();
        String netName = null;
        try {
            netName = (String)interpreter.eval(stmt);
        }
        catch (EvalError e) {
            ALog.logError((Throwable)e, (String)"Error executing makeANetName command for device '%s' pin '%s'.", (Object[])new Object[]{cellName, thisPort.getName()});
        }
        return netName;
    }

    public static void setNewGroup(String groupName) {
        interfacePathsToGroup.clear();
        newGroupName = groupName;
    }

    public static void addToGroup(String interfaceName) {
        interfacePathsToGroup.add(IOView.getDevicePathFromString(interfaceName));
    }

    private static int getSide(List<DevicePath> interfacePaths) {
        int side = -1;
        for (DevicePath interfacePath : interfacePaths) {
            IOViewBlock oldInterface = theIOView.getBlock(interfacePath);
            if (side == -1) {
                side = oldInterface.side;
                continue;
            }
            if (side == oldInterface.side) continue;
            return -1;
        }
        return side;
    }

    private static String getGroupName(String baseGroupName) {
        Object groupName = baseGroupName;
        int i = 1;
        while (Device.getChildDevice((DeviceTemplate)theIOView.getRootDevicePath().getDeviceTemplate(), (String)groupName) != null) {
            groupName = baseGroupName + i++;
        }
        return groupName;
    }

    private static IOViewBlock createInterfaceBlock(String name, int side) {
        IOViewBlock newInterface = new IOViewBlock(name);
        newInterface.setSide(side);
        newInterface.parent = null;
        newInterface.devicePath = new DevicePath(theIOView.getRootDevicePath());
        newInterface.gap = 0L;
        newInterface.inset = 0L;
        newInterface.hard = false;
        newInterface.ignoreGrid = false;
        newInterface.createDevicePersonality(name);
        newInterface.devicePath = IOView.getDevicePathFromString(newInterface.devicePath.toString());
        return newInterface;
    }

    private static void ungroupDevicesFromInterface(IOViewBlock intf, List<DevicePath> devicePool, Map<Device, APoint2D> deviceToLoc) {
        for (DevicePath dp : intf.getDevicePath().getChildren()) {
            dp.getLast().setName(intf.getName() + dp.getLast().getName());
            devicePool.add(dp);
            deviceToLoc.put(dp.getLast(), dp.getOrigin());
        }
        Device.unGroup((DevicePath)intf.devicePath);
    }

    private static Set<Personality> groupDevicesToInterface(List<DevicePath> devicePool, String groupName, IOViewBlock newInterface, Personality psn, Map<Device, APoint2D> deviceToLoc) {
        List devices = devicePool.stream().map(DevicePath::getLast).collect(Collectors.toList());
        Device.group(devices, (String)groupName, (Device)newInterface.devicePath.getLast());
        HashSet<Personality> oldPs = new HashSet<Personality>();
        for (DevicePath dp : devicePool) {
            Device d = dp.getLast();
            d.setRotate(0.0f);
            oldPs.add(d.getPersonality());
            if (psn != null) {
                d.assignToPersonality(psn);
            }
            APoint2D oldLoc = deviceToLoc.get(d);
            DevicePath dpInterface = dp.getLast().getADevicePath().getParent();
            Device.reparentPosition((String)d.getKeyStr(), (String)dpInterface.toString(), (long)oldLoc.getX(), (long)oldLoc.getY());
        }
        return oldPs;
    }

    public static void makeGroup() {
        int side = IOView.getSide(interfacePathsToGroup);
        if (side == -1) {
            ALog.logInfo((String)"Can not group interfaces on different sides");
            return;
        }
        String groupName = IOView.getGroupName(newGroupName);
        Collections.sort(interfacePathsToGroup, new PathSorter());
        IOViewBlock newInterface = IOView.createInterfaceBlock(groupName, side);
        String persName = IOView.getPersonalityNameForInterface(newInterface.devicePath, groupName);
        Optional p = Personality.getPersonality((DeviceTemplate)theIOView.getRootDevicePath().getDeviceTemplate(), (Personality.Type)Personality.Type.DEVICE, (String)persName);
        IOView.addBlockToSide(newInterface, side, 0);
        newInterface.devicePath.getLast().setLoc(interfacePathsToGroup.get(0).getLast().getLoc());
        ArrayList<DevicePath> newChildren = new ArrayList<DevicePath>();
        HashMap<Device, APoint2D> deviceToLoc = new HashMap<Device, APoint2D>();
        for (DevicePath interfacePath : interfacePathsToGroup) {
            IOViewBlock oldInterface = theIOView.getBlock(interfacePath);
            IOView.ungroupDevicesFromInterface(oldInterface, newChildren, deviceToLoc);
        }
        Set<Personality> oldPs = IOView.groupDevicesToInterface(newChildren, groupName, newInterface, p.isPresent() ? (Personality)p.get() : null, deviceToLoc);
        for (Personality oldP : oldPs) {
            if (oldP == null) continue;
            oldP.deleteFromDb();
        }
        IOView.buildIOViewFromCanvasUser();
    }

    public boolean addListener(Listener l) {
        if (this.mListeners.contains(l)) {
            return false;
        }
        return this.mListeners.add(l);
    }

    public boolean removeListener(Listener l) {
        if (l == null) {
            this.mListeners.clear();
            return true;
        }
        return this.mListeners.remove(l);
    }

    protected void fireIOViewChanged() {
        for (Listener l : this.mListeners) {
            l.ioViewChanged();
        }
    }

    public static AffineTransform getTransformIgnoringLogicalHierarchy(DevicePath path) {
        return null;
    }

    public boolean addListener(ExternalListener l) {
        if (this.mExternalListeners.contains(l)) {
            return false;
        }
        return this.mExternalListeners.add(l);
    }

    public boolean removeListener(ExternalListener l) {
        return this.mExternalListeners.remove(l);
    }

    protected void fireInterfaceChangedHierarchy(DevicePath intrface, DevicePath oldParent, DevicePath newParent) {
        for (ExternalListener l : AUtil.linkedList(this.mExternalListeners)) {
            l.interfaceChangedHierarchy(intrface, oldParent, newParent);
        }
    }

    protected void fireInterfaceDecorated(DevicePath path) {
        for (ExternalListener l : AUtil.linkedList(this.mExternalListeners)) {
            l.interfaceDecorated(path);
        }
    }

    private long compareDistanceToSideStartingPoint(int side, IOViewBlock o1, IOViewBlock o2) {
        long d = side == 0 ? o1.devicePath.getLocalBB().bottom() - o2.devicePath.getLocalBB().bottom() : (side == 1 ? o2.devicePath.getLocalBB().right() - o1.devicePath.getLocalBB().right() : (side == 2 ? o2.devicePath.getLocalBB().top() - o1.devicePath.getLocalBB().top() : o1.devicePath.getLocalBB().left() - o2.devicePath.getLocalBB().left()));
        return d;
    }

    public static void save() {
        if (theIOView != null) {
            theIOView.saveSessionInfo();
        }
    }

    private void saveSessionInfo() {
        for (int s = 0; s < 5; ++s) {
            APair<String, Float> da = IOViewDlg.Side.getDescriptorAndAngle(s);
            String sideStr = (String)da.first;
            SideBlocks sb = this.mBlocks.get(s);
            for (IOViewBlock intf : sb) {
                if (!intf.getDevicePath().isValid()) continue;
                String intfName = intf.getDevicePath().getRelativePathFromAnchor(this.mRootDevicePath.getDeviceTemplate()).toString();
                int seq = 0;
                for (IOViewBlock dev : intf.getChildren()) {
                    if (!dev.getDevicePath().isValid()) continue;
                    dev.setSequence(seq++);
                    dev.setParentInterfacePath(intfName);
                }
            }
        }
    }

    public static IOView restoreFromSessionInfo(DevicePath rootDevice) {
        Map<String, List<Device>> managedDevices = IOView.getIOViewManagedDevices(rootDevice);
        IOView.recoverInterfaces(rootDevice, managedDevices);
        return null;
    }

    private static Map<String, List<Device>> getIOViewManagedDevices(DevicePath rootDevice) {
        HashMap<String, List<Device>> managedDevices = new HashMap<String, List<Device>>();
        rootDevice.getDescendants(false).stream().forEach(dp -> {
            int seqno = (Integer)AUtil.getField((DbObject)dp.getDevice(), (String)FLDNAME_SEQ, (Object)Integer.MIN_VALUE);
            String interfacePath = (String)AUtil.getField((DbObject)dp.getDevice(), (String)FLDNAME_PARENT_INTERFACE, null);
            if (seqno != Integer.MIN_VALUE && interfacePath != null) {
                managedDevices.computeIfAbsent(interfacePath, k -> new LinkedList()).add(dp.getDevice());
            }
        });
        return managedDevices;
    }

    private static void recoverInterfaces(DevicePath rootDevicePath, Map<String, ?> interfacePaths) {
        interfacePaths.entrySet().forEach(entry -> {
            String intf = (String)entry.getKey();
            ALog.logInfo((String)"[INTERFACE] %s", (Object[])new Object[]{intf});
        });
    }

    static {
        isRegistered = false;
        theViewListener = null;
        theDbListener = null;
        db2view = new WeakHashMap();
        IOView.registerIOView();
        ALLOW_LOGICAL_CORE_DEVICES = true;
        debugPlacementDetails = false;
        interfacePathsToGroup = new ArrayList();
        newGroupName = "";
    }

    public static class AllowNetChangesInIOViewRegistry {
        protected static AllowNetChangesInIOView registry = null;

        public static void set(AllowNetChangesInIOView method) {
            registry = method;
        }

        protected static AllowNetChangesInIOView getCurrentMethod() {
            return registry;
        }
    }

    public static interface AllowNetChangesInIOView {
        public boolean allow(HierInst<PinTemplate> var1);

        public String description();
    }

    public static interface ExternalListener {
        public void interfaceChangedHierarchy(DevicePath var1, DevicePath var2, DevicePath var3);

        public void interfaceDecorated(DevicePath var1);
    }

    public static interface Listener {
        public void ioViewChanged();
    }

    static class PathSorter
    implements Comparator<DevicePath> {
        PathSorter() {
        }

        @Override
        public int compare(DevicePath o1, DevicePath o2) {
            IOViewBlock b1 = theIOView.getBlock(o1);
            IOViewBlock b2 = theIOView.getBlock(o2);
            ArrayAndIndex a1 = theIOView.findArrayAndIndex(b1);
            ArrayAndIndex a2 = theIOView.findArrayAndIndex(b2);
            return a1.index - a2.index;
        }
    }

    protected class RePlaceState {
        long lastCover;
        long lastNonCover;

        public RePlaceState() {
        }

        public RePlaceState(RePlaceState other) {
            this.lastCover = other.lastCover;
            this.lastNonCover = other.lastNonCover;
        }
    }

    private class ArrayAndIndex {
        List<IOViewBlock> array;
        int index;

        private ArrayAndIndex() {
        }
    }

    class SideSorter
    implements Comparator<IOViewBlock> {
        int side;
        int level;

        public SideSorter(int side, int level) {
            this.side = side;
            this.level = level;
        }

        private long compareSideDirectionExtent(int side, IOViewBlock o1, IOViewBlock o2) {
            long d = side == 0 ? o2.devicePath.getBB().left() - o1.devicePath.getBB().left() : (side == 1 ? o2.devicePath.getBB().top() - o1.devicePath.getBB().top() : (side == 2 ? o1.devicePath.getBB().left() - o2.devicePath.getBB().left() : o1.devicePath.getBB().bottom() - o2.devicePath.getBB().bottom()));
            return d;
        }

        @Override
        public int compare(IOViewBlock o1, IOViewBlock o2) {
            long d;
            if (this.level == 0) {
                d = IOView.this.compareDistanceToSideStartingPoint(this.side, o1, o2);
            } else {
                if (IOView.this.getShowByDefinitionOrder()) {
                    Integer seq1 = o1.getSequenceInParent();
                    Integer seq2 = o2.getSequenceInParent();
                    if (seq1 != null && seq2 != null) {
                        if (seq1 < seq2) {
                            return -1;
                        }
                        if (seq2 < seq1) {
                            return 1;
                        }
                    }
                }
                d = o1.devicePath.getLocalBB().left() - o2.devicePath.getLocalBB().left();
            }
            if (d < 0L) {
                return -1;
            }
            if (d > 0L) {
                return 1;
            }
            if (this.level == 0) {
                d = this.compareSideDirectionExtent(this.side, o1, o2);
                if (d < 0L) {
                    return -1;
                }
                if (d > 0L) {
                    return 1;
                }
            } else {
                if (o1.devicePath.getLocalBB().bottom() < o2.devicePath.getLocalBB().bottom()) {
                    return 1;
                }
                if (o2.devicePath.getLocalBB().bottom() < o1.devicePath.getLocalBB().bottom()) {
                    return -1;
                }
            }
            if (o1.devicePath.getLast().getIsOverlay() && !o2.devicePath.getLast().getIsOverlay()) {
                return -1;
            }
            if (!o1.devicePath.getLast().getIsOverlay() && o2.devicePath.getLast().getIsOverlay()) {
                return 1;
            }
            if (o1.devicePath.getLast().getIsOverlay() && o2.devicePath.getLast().getIsOverlay()) {
                return o2.devicePath.getLast().compareTo((DbObject)o1.devicePath.getLast());
            }
            if (o1.devicePath.getLast().getBounds().width() > o2.devicePath.getLast().getBounds().width()) {
                return -1;
            }
            if (o1.devicePath.getLast().getBounds().width() < o2.devicePath.getLast().getBounds().width()) {
                return 1;
            }
            return 0;
        }
    }

    static class SideSorterFactory {
        private SideSorterFactory() {
            throw new IllegalStateException("SideSorterFactory is a utility class");
        }

        static SideSorter getSideSorter(int side, int level) {
            IOView iOView = theIOView;
            Objects.requireNonNull(iOView);
            return iOView.new SideSorter(side, level);
        }
    }

    class BlockSorter
    implements Comparator<IOViewBlock> {
        BlockSorter() {
        }

        @Override
        public int compare(IOViewBlock o1, IOViewBlock o2) {
            int side1;
            int side0;
            if (IOView.this.getShowByDefinitionOrder()) {
                Integer seq1 = o1.getSequenceInParent();
                Integer seq2 = o2.getSequenceInParent();
                if (seq1 != null && seq2 != null) {
                    if (seq1 < seq2) {
                        return -1;
                    }
                    if (seq2 < seq1) {
                        return 1;
                    }
                }
            }
            if ((side0 = o1.side) < (side1 = o2.side)) {
                return -1;
            }
            if (side1 < side0) {
                return 1;
            }
            long d = IOView.this.compareDistanceToSideStartingPoint(side1, o1, o2);
            if (d < 0L) {
                return -1;
            }
            if (d > 0L) {
                return 1;
            }
            if (o1.devicePath.getLast().getBounds().width() > o2.devicePath.getLast().getBounds().width()) {
                return -1;
            }
            return 1;
        }
    }

    private class IOViewState {
        String comment;
        Map<Integer, Map<DevicePath, ARect>> state = new HashMap<Integer, Map<DevicePath, ARect>>();

        IOViewState(String comment) {
            this.comment = comment;
        }

        void addState(int side, Map<DevicePath, ARect> dpAndBBs) {
            this.state.put(side, dpAndBBs);
        }
    }

    private class DeviceState {
        String comment;
        DevicePath devicePath;
        Map<Device, ARect> state;

        DeviceState(DevicePath dp, String comment) {
            this.comment = comment;
            this.devicePath = dp;
            this.state = dp.getDescendants(true).stream().collect(Collectors.toMap(DevicePath::getLast, DevicePath::getBB, (k1, k2) -> k1));
        }
    }

    static class DeviceSideInfo {
        Device device;
        IOViewInterface sideInterface;
        APoint2D oldPos;
        float oldRot;

        public DeviceSideInfo(Device device, IOViewInterface intf) {
            this.device = device;
            this.sideInterface = intf;
            this.oldPos = device.getLoc();
            this.oldRot = device.getRotate();
        }
    }

    class Info {
        StoredPath sp;
        DbObject.RelObj<?> rel;

        Info() {
        }
    }

    class SideBlocks
    extends ArrayList<IOViewBlock> {
        SideBlocks() {
        }
    }
}

