/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.iov;

import com.sigrity.acl.ALog;
import com.sigrity.acl.ANameCloner;
import com.sigrity.acl.APair;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.NamedGrid;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.geom.AGrid;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierPin;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.automation.placement.DeviceReplace;
import com.sigrity.orbit.factory.PartFactory;
import com.sigrity.orbit.iov.IOView;
import com.sigrity.orbit.iov.IOViewDlg;
import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Element;

public class IOViewBlock {
    static IOViewBlock workingBlock;
    protected DevicePath devicePath;
    protected IOViewBlock parent = null;
    protected IOViewBlock overlay = null;
    protected boolean iAmACover = false;
    protected int nthCover = 0;
    protected int numCovers = 0;
    protected Element parentElement = null;
    protected List<IOViewBlock> children = new ArrayList<IOViewBlock>();
    protected List<PinAttribute> pinAttributes = new ArrayList<PinAttribute>();
    protected boolean byTemplate;
    protected DeviceTemplate template;
    protected long width;
    protected long height;
    protected long inset;
    protected long gap;
    protected long avoidGap;
    protected boolean hard;
    protected boolean ignoreGrid;
    protected long marginLead;
    protected long marginTrail;
    protected APoint2D ll = APoint2D.Zero();
    protected ARect placementRect = ARect.zero();
    protected APoint2D placementStart = APoint2D.Zero();
    protected String desiredName;
    protected String desiredPathName;
    protected int side = 0;
    protected String mMode;
    protected DeviceTemplate.DefTransform defaultXform;

    public static IOViewBlock getWorkingBlock() {
        return workingBlock;
    }

    public static void setWorkingBlock(IOViewBlock b) {
        workingBlock = b;
    }

    public static void newWorkingBlock(String name) {
        workingBlock = new IOViewBlock(name);
    }

    public Element getParentElement() {
        return this.parentElement;
    }

    public void setParentElement(Element parentElement) {
        this.parentElement = parentElement;
    }

    public IOViewBlock(String name) {
        this.desiredName = name;
        this.devicePath = null;
        this.defaultXform = DeviceTemplate.DefTransform.N;
    }

    public IOViewBlock(DevicePath devicePath, int side, IOViewBlock parent) {
        this.devicePath = devicePath;
        if (devicePath != null) {
            this.desiredName = devicePath.getLast().getName();
            this.template = devicePath.getDeviceTemplate();
            if (this.isDefinedBySizeByUser(devicePath.getLast())) {
                this.byTemplate = false;
                this.width = this.template.getBB().width();
                this.height = this.template.getBB().height();
            } else {
                this.byTemplate = true;
            }
        } else {
            this.desiredName = "New";
        }
        this.side = side;
        this.parent = parent;
        this.defaultXform = devicePath != null ? IOView.theIOView.setIOViewBlockXFormFromDevice(devicePath, side) : DeviceTemplate.DefTransform.N;
    }

    public DeviceTemplate getTemplate() {
        return this.template;
    }

    public void setTemplate(DeviceTemplate template) {
        this.template = template;
    }

    public long getWidth() {
        return this.width;
    }

    public void setWidth(long width) {
        this.width = width;
    }

    public long getHeight() {
        return this.height;
    }

    public void setHeight(long height) {
        this.height = height;
    }

    public long getInset() {
        return this.inset;
    }

    public void setInset(long inset) {
        this.inset = inset;
    }

    public long getGap() {
        return this.gap;
    }

    public void setGap(long gap) {
        this.gap = gap;
    }

    public String getName() {
        if (this.devicePath == null) {
            return this.desiredName;
        }
        return this.devicePath.getLast().getName();
    }

    public void updateName() {
        this.desiredName = this.devicePath.getLast().getName();
    }

    public void setDesiredName(String name) {
        this.desiredName = name;
    }

    public String getDesiredName() {
        return this.desiredName;
    }

    public void setPath(String path) {
        this.devicePath = IOView.getDevicePathFromString(path);
    }

    public void setParent(String parent) {
        this.parent = IOViewBlock.findBlockOfName(parent);
    }

    public void setByTemplate(boolean s) {
        this.byTemplate = s;
    }

    public void setDefaultXForm(DeviceTemplate.DefTransform o) {
        this.defaultXform = o;
    }

    public void setDefaultXForm(String os) {
        this.defaultXform = DeviceTemplate.DefTransform.valueOf((String)os);
    }

    public void setDesiredPathName(String desiredPathName) {
        this.desiredPathName = desiredPathName;
    }

    public void setTemplate(String name) {
        this.template = DeviceTemplate.getDeviceTemplate((Substrate)IOView.theIOView.getSubstrate(), (String)name);
        if (this.template == null) {
            ALog.logError((String)"Couldn't find template %s in %s", (Object[])new Object[]{name, IOView.theIOView.getSubstrate()});
        }
    }

    public void setGapInset(long g, long i) {
        this.gap = g;
        this.inset = i;
    }

    @Deprecated(forRemoval=true)
    public void setAttr(long w, long h, long g, long i, boolean hard) {
        this.setAttr(w, h, 0L, 0L, g, i, hard);
    }

    public void setAttr(long w, long h, long ml, long mt, long g, long i, boolean hard) {
        this.width = w;
        this.height = h;
        this.marginLead = ml;
        this.marginTrail = mt;
        this.gap = g;
        this.inset = i;
        this.hard = hard;
    }

    public void setIgnoreGrid(boolean ignoreGrid) {
        this.ignoreGrid = ignoreGrid;
    }

    public void setMode(String mode) {
        this.mMode = mode;
    }

    public void clearPins() {
        this.pinAttributes.clear();
    }

    public void addPinNet(String pinName, String netName) {
        PinAttribute pa = new PinAttribute();
        pa.netName = netName;
        pa.pinName = pinName;
        pa.changed = true;
        pa.locked = false;
        this.pinAttributes.add(pa);
    }

    public void addPinNet(String pinName, String netName, Boolean locked) {
        PinAttribute pa = new PinAttribute();
        pa.netName = netName;
        pa.pinName = pinName;
        pa.changed = true;
        pa.locked = locked;
        this.pinAttributes.add(pa);
    }

    public static void setWorkingBlock(IOViewBlock to, IOViewBlock from) {
        if (to == null) {
            Cp.exec(() -> IOViewBlock.newWorkingBlock(from.desiredName), (String)"IOViewBlock.newWorkingBlock (\"%s\");", (Object[])new Object[]{from.desiredName});
        } else {
            Cp.exec(() -> IOViewBlock.setWorkingBlock(IOViewBlock.findBlockOfName(to.devicePath.toString())), (String)"IOViewBlock.setWorkingBlock (IOViewBlock.findBlockOfName(\"%s\"));", (Object[])new Object[]{to.devicePath.toString()});
        }
        Cp.exec(() -> IOViewBlock.getWorkingBlock().setDesiredPathName(from.desiredPathName), (String)"IOViewBlock.getWorkingBlock().setDesiredPathName (\"%s\");", (Object[])new Object[]{from.desiredPathName});
        Cp.exec(() -> IOViewBlock.getWorkingBlock().setPath(from.devicePath.toString()), (String)"IOViewBlock.getWorkingBlock().setPath (\"%s\");", (Object[])new Object[]{from.devicePath.toString()});
        Cp.exec(() -> IOViewBlock.getWorkingBlock().setSide(from.side), (String)"IOViewBlock.getWorkingBlock().setSide (%d);", (Object[])new Object[]{from.side});
        Cp.exec(() -> IOViewBlock.getWorkingBlock().setAttr(from.width, from.height, from.marginLead, from.marginTrail, from.gap, from.inset, from.hard), (String)"IOViewBlock.getWorkingBlock().setAttr (%dL, %dL, %dL, %dL, %dL, %dL, %b);", (Object[])new Object[]{from.width, from.height, from.marginLead, from.marginTrail, from.gap, from.inset, from.hard});
        Cp.exec(() -> IOViewBlock.getWorkingBlock().setDefaultXForm(from.defaultXform.name()), (String)"IOViewBlock.getWorkingBlock().setDefaultXForm (\"%s\");", (Object[])new Object[]{from.defaultXform.name()});
        Cp.exec(() -> IOViewBlock.getWorkingBlock().setIgnoreGrid(from.ignoreGrid), (String)"IOViewBlock.getWorkingBlock().setIgnoreGrid (%b);", (Object[])new Object[]{from.ignoreGrid});
        Cp.exec(() -> IOViewBlock.getWorkingBlock().setByTemplate(from.byTemplate), (String)"IOViewBlock.getWorkingBlock().setByTemplate (%b);", (Object[])new Object[]{from.byTemplate});
        if (from.template != null) {
            Cp.exec(() -> IOViewBlock.getWorkingBlock().setTemplate(from.template.getName()), (String)"IOViewBlock.getWorkingBlock().setTemplate (\"%s\");", (Object[])new Object[]{from.template.getName()});
        } else {
            ALog.logWarn((String)"NO TEMPLATE from %s", (Object[])new Object[]{from});
        }
        if (from.parent != null) {
            Cp.exec(() -> IOViewBlock.getWorkingBlock().setParent(from.parent.devicePath.toString()), (String)"IOViewBlock.getWorkingBlock().setParent (\"%s\");", (Object[])new Object[]{from.parent.devicePath.toString()});
        }
        if (from.mMode != null && from.mMode.length() > 0) {
            Cp.exec(() -> IOViewBlock.getWorkingBlock().setMode(from.mMode), (String)"IOViewBlock.getWorkingBlock().setMode (\"%s\");", (Object[])new Object[]{from.mMode});
        }
        ArrayList<PinAttribute> newList = new ArrayList<PinAttribute>();
        for (PinAttribute pDef : from.pinAttributes) {
            if (!pDef.changed) continue;
            PinAttribute pa = new PinAttribute();
            pa.netName = pDef.netName;
            pa.pinName = pDef.pinName;
            pa.locked = pDef.locked;
            newList.add(pa);
        }
        for (PinAttribute pa : newList) {
            Cp.exec(() -> IOViewBlock.getWorkingBlock().addPinNet(pa.pinName, pa.netName, pa.locked), (String)"IOViewBlock.getWorkingBlock().addPinNet (\"%s\", \"%s\", %b);", (Object[])new Object[]{pa.pinName, pa.netName, pa.locked});
        }
    }

    public DevicePath getDevicePath() {
        return this.devicePath;
    }

    protected AGrid getGrid() {
        DeviceTemplate dt = this.getDie().getTemplate();
        if (dt == null) {
            return null;
        }
        if (this.ignoreGrid) {
            return null;
        }
        Substrate s = dt.getSubstrate();
        NamedGrid ng = NamedGrid.get((Substrate)s, (String)"Pin Grid");
        if (ng == null) {
            ng = NamedGrid.get((Substrate)s, (String)"Manufacturing Grid");
        }
        if (ng != null) {
            return ng.getGrid();
        }
        return null;
    }

    public void setPersonalityFields(Personality p, long firstChildGap, long firstChildInset) {
        IOViewBlock.setPersonalityFields(p, (String)IOViewDlg.Side.getDescriptorAndAngle((int)this.side).first, this.gap, this.inset, this.marginLead, this.marginTrail, firstChildGap, firstChildInset);
    }

    public void setPersonalityFields(Personality p) {
        this.setPersonalityFields(p, 0L, 0L);
    }

    public static void setPersonalityFields(Personality p, String side, long gap, long inset, long marginLead, long marginTrail) {
        IOViewBlock.setPersonalityFields(p, side, gap, inset, marginLead, marginTrail, 0L, 0L);
    }

    public static void setPersonalityFields(Personality p, String side, long gap, long inset, long marginLead, long marginTrail, long firstChildGap, long firstChildInset) {
        p.setValue("side", (Object)side);
        p.setValue("gap", (Object)gap);
        p.setValue("inset", (Object)inset);
        p.setValue("marginLead", (Object)marginLead);
        p.setValue("marginTrail", (Object)marginTrail);
        p.setValue("firstChildGap", (Object)firstChildGap);
        p.setValue("firstChildInset", (Object)firstChildInset);
    }

    public void setParent(IOViewBlock parent) {
        this.parent = parent;
    }

    public IOViewBlock getParent() {
        return this.parent;
    }

    public Device getDie() {
        return IOView.theIOView.getRootDevicePath().getLast();
    }

    public void setSide(int side) {
        this.side = side;
    }

    public IOViewBlock getBlock(DevicePath path) {
        if (this.devicePath.sameAs(path)) {
            return this;
        }
        for (IOViewBlock child : this.children) {
            IOViewBlock found = child.getBlock(path);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public Color getColor() {
        int sequence = this.getSequence();
        if (sequence == -1) {
            if (this.numCovers == 0) {
                return new Color(255, 255, 255);
            }
            return new Color(255, 128, 128, 128);
        }
        if (sequence == 0) {
            return new Color(52, 251, 152, 128);
        }
        return new Color(176, 224, 23, 128);
    }

    protected int getDecorationPass() {
        DevicePath dp = this.getDevicePath();
        if (dp == null) {
            return -1;
        }
        Device d = dp.getLast();
        if (d != null) {
            Integer pass = (Integer)d.getValue("IOView.DecorationPass");
            if (pass == null) {
                return -1;
            }
            return pass;
        }
        return -1;
    }

    protected Integer getSequenceInParent() {
        Device d = this.getDevicePath().getLast();
        if (d != null) {
            return (Integer)d.getValue("IOView.SeqNum");
        }
        return null;
    }

    protected void setSequence(int sequence) {
        Device d = this.getDevicePath().getLast();
        if (d != null) {
            d.setValue("IOView.SeqNum", (Object)sequence);
        }
    }

    protected void setParentInterfacePath(String intfName) {
        Device d = this.getDevicePath().getLast();
        if (d != null) {
            d.setValue("IOView.parentInterface", (Object)intfName);
        }
    }

    protected void setDecorationPass(int pass) {
        Device d = this.getDevicePath().getLast();
        if (d != null) {
            d.setValue("IOView.DecorationPass", (Object)pass);
        }
    }

    public String getTemplateName() {
        return this.getDevicePath().getDeviceTemplate().getName();
    }

    public int getSequence() {
        int sequence;
        assert (IOView.theIOView != null) : String.format("theIOView can not be null! %s", this.getDevicePath());
        if (IOView.theIOView.getColorByPass()) {
            int pass = this.getDecorationPass();
            if (pass == -1) {
                return -1;
            }
            return pass % 2;
        }
        if (this.iAmACover) {
            sequence = this.nthCover % 2;
        } else {
            IOViewBlock myOverlay = this.overlay;
            sequence = this.overlay != null ? myOverlay.nthCover % 2 : -1;
        }
        return sequence;
    }

    protected IOViewBlock getFirstIOPad() {
        return this.getChildren().stream().filter(b -> !b.isInPlacementGroup1()).findFirst().orElse(null);
    }

    private void replaceDevice(Device d, Device dNew) {
        DeviceReplace dr = DeviceReplace.create();
        dr.setRemoveOldDevice(true);
        dr.setMapOption(Device.PinMapOptions.BYPINCONNECTION);
        dr.setQuiet(true);
        dr.setDeleteTemplateIfUnused(false);
        dr.setDeleteSubstrateIfUnused(false);
        dr.replace(d, dNew);
    }

    private boolean shouldUpdateTemplate(Device d) {
        DeviceTemplate dt = d.getTemplate();
        boolean updateTemplate = false;
        if (this.byTemplate) {
            if (dt != this.template) {
                ALog.logInfo((String)("Updating template of " + d.getName() + " from " + dt.getName() + " to " + (this.template == null ? "null" : this.template.getName())));
                updateTemplate = true;
            }
        } else if (dt.getBB().width() != this.width || dt.getBB().height() != this.height) {
            ALog.logInfo((String)("Updating template of " + d.getName()));
            this.template = PartFactory.makeIOPadTemplate(this.getDie(), this.width, this.height, "PAD", true, null, true, null);
            updateTemplate = true;
        }
        return updateTemplate;
    }

    private void updateDeviceName(Device d) {
        if (!this.desiredName.equals(this.devicePath.getLast().getName())) {
            if (Device.getChildDevice((DeviceTemplate)this.parent.devicePath.getDeviceTemplate(), (String)this.desiredName) != null) {
                ALog.logInfo((String)("Can not rename " + this.devicePath.getLast().getName() + " to " + this.desiredName + " because it already exists"));
            } else {
                ALog.logInfo((String)("Renaming " + this.devicePath.getLast().getName() + " to " + this.desiredName));
                d.setName(this.desiredName);
            }
        }
    }

    private void updateNetSetterType(PinInstance port, PinAttribute pDef) {
        if (pDef.locked) {
            port.setNetSetterType(PinInstance.NetSetterType.INTERACTIVE_USER);
        } else {
            port.setNetSetterType(PinInstance.NetSetterType.IOVIEWSETTER);
        }
    }

    public void updateDbDevice() {
        Device d = this.devicePath.getLast();
        this.setDeviceXFormFromIOViewBlock(d);
        boolean updateTemplate = this.shouldUpdateTemplate(d);
        if (updateTemplate) {
            d.setName("beingchanged");
            Device dNew = this.makeDbDevice();
            if (d.getPersonality() != null) {
                dNew.assignToPersonality(d.getPersonality());
            }
            this.replaceDevice(d, dNew);
            d = dNew;
        }
        this.updateMode(d, this.mMode);
        this.updateDeviceName(d);
        for (PinAttribute pDef : this.pinAttributes) {
            String netName = pDef.netName;
            String pinName = pDef.pinName;
            PinInstance port = d.getPinByName(pinName);
            Net n = NetMap.getTopmostNet((Net)port.getPinTemplate().getNet(), (DevicePath)this.devicePath);
            boolean mapped = true;
            if (n.getDeviceTemplate() != this.devicePath.getFirst().getTemplate()) {
                mapped = false;
            }
            if (!mapped || !n.getName().equals(netName) && !netName.isEmpty()) {
                IOViewBlock.propagateNet(this.devicePath.toString(), pinName, netName);
            }
            this.updateNetSetterType(port, pDef);
        }
    }

    private static boolean shouldProcess(DeviceTemplate.Type type) {
        return DeviceTemplate.Type.BUMP.equals((Object)type) || DeviceTemplate.Type.COVER.equals((Object)type);
    }

    public static void propagateNet(String devicePathName, String portName, String netName) {
        DevicePath dp = IOView.getDevicePathFromString(devicePathName);
        if (dp == null) {
            ALog.logWarn((String)("There is no such device as " + devicePathName));
            return;
        }
        Device device = dp.getLast();
        DeviceTemplate dt = device.getTemplate();
        PinTemplate pinTemplate = dt.getPinByName(portName);
        if (pinTemplate == null) {
            ALog.logWarn((String)("There is no such pin called " + portName + "on template " + dt.getName()));
            return;
        }
        RefactorMaps rf = new RefactorMaps();
        rf.setParent(dp, pinTemplate);
        PinInstance pi = device.getAssociatedPinInstance(pinTemplate);
        HierPin dpp = new HierPin(dp, pi);
        APoint2D ioPadLoc = dpp.getSubstrateLoc();
        Net ioPadNet = dpp.getSubstrateNet();
        Device ioPadInterface = dp.getParent().getLast();
        int total = 0;
        int totalOnInterface = 0;
        HierPin best = null;
        long bestDist = 0L;
        if (pi.getNet() != pi.getDeviceTemplate().getNetUnused()) {
            for (HierPin others : NetMap.getConnectedDevicePathPorts((Net)pi.getNet(), (DevicePath)dp)) {
                ++total;
                if (!((DevicePath)others.first).getParent().getLast().equals(ioPadInterface) || !IOViewBlock.shouldProcess(((PinInstance)others.second).getDeviceTemplate().getType())) continue;
                ++totalOnInterface;
                if (best == null) {
                    best = others;
                    bestDist = ioPadLoc.distance(others.getSubstrateLoc());
                    continue;
                }
                long dist = ioPadLoc.distance(others.getSubstrateLoc());
                if (dist >= bestDist) continue;
                best = others;
                bestDist = dist;
            }
            ALog.logInfo((String)("There are a total of " + total + " pins on net " + ioPadNet.getName() + " " + totalOnInterface + " of these are on the interface " + ioPadInterface.getName()));
            if (best != null) {
                ALog.logInfo((String)("The closest bump is " + best.getPath().toString() + best.getPin().getName()));
            } else {
                ALog.logWarn((String)("There are no candidate pins found on net " + ioPadInterface.getName()));
            }
        }
        ALog.logInfo((String)("Setting net on " + dp.toString() + " pin " + pinTemplate.getName() + " to " + netName));
        Net oldIONet = NetMap.getTopmostNet((Net)pi.getNet(), (DevicePath)dp);
        DevicePath topOldPath = dp.pathTo(oldIONet.getDeviceTemplate());
        NetMap.mapThroughPath((DevicePath)dp, (PinInstance)pi, (String)netName);
        if (best != null) {
            ALog.logInfo((String)("Setting net on " + best.getPath().toString() + " pin " + best.getPin().getName() + " to " + netName));
            NetMap.mapThroughPath((DevicePath)best.getPath(), (PinInstance)best.getPin(), (String)netName);
        }
        if (!oldIONet.isUnused()) {
            if (!NetMap.isMaterial((Net)oldIONet, (DevicePath)topOldPath)) {
                ALog.logInfo((String)("Net " + oldIONet.getName() + " is no longer a material net and will be deleted"));
                NetMap.deleteAllConnected((Net)oldIONet, (DevicePath)topOldPath);
            } else {
                ALog.logInfo((String)("Net " + oldIONet.getName() + " is a material net and will not be deleted"));
            }
        }
    }

    public void remapPins() {
        Device d = this.devicePath.getLast();
        for (PinAttribute pDef : this.pinAttributes) {
            String netName = pDef.netName;
            String pinName = pDef.pinName;
            PinInstance port = d.getPinByName(pinName);
            if (port != null) {
                Net n = NetMap.getTopmostNet((Net)port.getPinTemplate().getNet(), (DevicePath)this.devicePath);
                if (!n.getName().equals(netName) && !netName.isEmpty()) {
                    ALog.logInfo((String)("Changing net on pin " + port.getPinTemplate().getName() + " from " + n.getName() + " to " + netName));
                    if ("NetUnused".equals(netName)) {
                        port.setNet(port.getDeviceTemplate().getNetUnused());
                    } else {
                        NetMap.mapThroughPath((DevicePath)this.devicePath, (PinInstance)port, (String)netName);
                    }
                }
                this.updateNetSetterType(port, pDef);
                continue;
            }
            ALog.logWarn((String)("There is no pin called " + pinName + " on " + d.getName()));
        }
    }

    public Device createDevicePersonality(String name) {
        this.devicePath = new DevicePath(IOView.theIOView.getRootDevicePath());
        Device d = IOView.makeAnInterfaceByPersonalityAndDevice(this.devicePath, name, this.side, this.hard, this.ignoreGrid, this.gap, this.inset, this.marginLead, this.marginTrail);
        if (d == null) {
            return null;
        }
        this.devicePath.add(d);
        this.template = d.getTemplate();
        return d;
    }

    protected static IOViewBlock findBlock(Device d) {
        IOView ioView = IOView.theIOView;
        return ioView.flattenAll().stream().filter(b -> b.devicePath.getDevice().equals(d)).findAny().orElse(null);
    }

    protected static IOViewBlock findBlockOfName(String parentName, String name) {
        IOView ioView = IOView.theIOView;
        return ioView.flattenAll().stream().filter(b -> b.getName().equals(name) && b.parent.getName().equals(parentName)).findAny().orElse(null);
    }

    public static IOViewBlock findBlockOfName(String devicePathName) {
        IOView ioView = IOView.theIOView;
        DeviceTemplate dieTemplate = ioView.getRootDevicePath().getDeviceTemplate();
        DevicePath lookingForPath = IOView.getDevicePathFromString(devicePathName);
        if (lookingForPath == null) {
            return null;
        }
        lookingForPath = lookingForPath.getRelativePath(dieTemplate);
        List<IOViewBlock> all = ioView.flattenAll();
        for (IOViewBlock b : all) {
            DevicePath relativePath;
            if (b.devicePath == null || !(relativePath = b.devicePath.getRelativePath(dieTemplate)).equals((Object)lookingForPath)) continue;
            return b;
        }
        return null;
    }

    protected void printMe() {
        ALog.logInfo((String)(this.devicePath.getString() + " " + this.defaultXform.name() + " " + this.devicePath.getLast().getRotate()));
    }

    public static void cloneMe(String parentName, String name, int copies) {
        try {
            IOViewBlock from = IOViewBlock.findBlockOfName(parentName, name);
            Device d = from.devicePath.getLast();
            ANameCloner anc = new ANameCloner();
            anc.setBaseName(name);
            String interfaceName = from.devicePath.getParent().getLast().getName();
            if (from != null) {
                for (int i = 0; i < copies; ++i) {
                    IOViewBlock clone = new IOViewBlock(anc.getNextName());
                    clone.parent = from.parent;
                    clone.side = from.side;
                    clone.byTemplate = from.byTemplate;
                    clone.height = from.height;
                    clone.width = from.width;
                    clone.template = from.template;
                    clone.defaultXform = from.defaultXform;
                    clone.makeDbDevice();
                    clone.devicePath.getLast().assignToPersonality(from.devicePath.getLast().getPersonality());
                    from.parent.children.add(clone);
                    if (d.getValue("IOView.Mode") != null) {
                        clone.devicePath.getLast().setValue("IOView.Mode", d.getValue("IOView.Mode"));
                    }
                    PinInstance pad = null;
                    String netName = "";
                    List ioList = from.template.getIOPorts();
                    for (PinTemplate dtp : ioList) {
                        pad = clone.devicePath.getLast().getPin(dtp);
                        netName = IOView.createDefaultNetNameForIOPAD(interfaceName, clone.getDesiredName(), dtp, ioList);
                        NetMap.mapThroughPath((DevicePath)clone.devicePath, (PinInstance)pad, (String)netName);
                    }
                    if (!IOView.theIOView.getCreateDefaultNetNames()) continue;
                    String smallPath = clone.devicePath.toString();
                    DevicePath fullPath = IOView.getDevicePathFromString(smallPath);
                    Cp.exec((String)"createDefaultNets(\"%s\")", (Object[])new Object[]{fullPath.toString()});
                }
                IOView.buildCanvasFromIOView(-1);
                IOView.buildIOViewFromCanvasUser();
            }
        }
        catch (Exception e) {
            ALog.logError((String)"Excpetion:%s. Continue running.", (Object[])new Object[]{e});
        }
    }

    protected void setDeviceXFormFromIOViewBlock(Device instance) {
        DeviceTemplate.DefTransform o = this.defaultXform;
        instance.setMirror(o.getMirror());
        instance.setRotate(o.getRot());
        APair<String, Float> descAndAngle = IOViewDlg.Side.getDescriptorAndAngle(this.side);
        instance.setValue("side", (Object)((String)descAndAngle.first));
    }

    private Device createAPadDevice() {
        Db db = OrbitIO.getCurDb();
        Device die = this.getDie();
        if (!this.byTemplate && this.template == null) {
            this.template = PartFactory.makeIOPadTemplate(die, this.width, this.height, "PAD", true, null, true, null);
        }
        DeviceTemplate parentTemplate = this.parent.template;
        this.desiredName = Device.getUniqueName((DeviceTemplate)parentTemplate, (String)this.desiredName);
        Device instance = new Device(this.desiredName, parentTemplate, this.template);
        db.add((DbObject)instance);
        return instance;
    }

    public Device makeDbDevice() {
        return this.makeDbDevice(null);
    }

    private void updateMode(Device d, String mode) {
        if (mode != null && mode.length() > 0) {
            if (!mode.equals(d.getValue("IOView.Mode"))) {
                d.setValue("IOView.Mode", (Object)mode);
            }
        } else if (d.hasSoftValue("IOView.Mode")) {
            d.unsetSoftValue("IOView.Mode");
        }
    }

    public Device makeDbDevice(Device instance) {
        if (instance == null) {
            instance = this.createAPadDevice();
        }
        instance.setSourceType(Device.SourceType.DIESPREADSHEET);
        this.devicePath = this.parent.devicePath.withChild(instance);
        this.setDeviceXFormFromIOViewBlock(instance);
        this.updateMode(instance, this.mMode);
        instance.moveTo(new APoint2D(0L, 0L));
        instance.addUnusedPins();
        DeviceTemplate t = instance.getTemplate();
        boolean hasExactlyOneOneDeviceInstance = t.hasExactlyOneDeviceInstance();
        for (PinAttribute pdef : this.pinAttributes) {
            PinTemplate pinTemplate;
            String pinName = pdef.pinName;
            String netName = pdef.netName;
            PinInstance port = instance.getPinByName(pinName);
            if (port == null) {
                ALog.logWarn((String)("Can not find a pin called " + pinName + " on device " + this.devicePath.toString()));
                pinTemplate = PartFactory.makeIOPadPinTemplate(t, pinName, true, netName, true);
                port = instance.getPin(pinTemplate);
            }
            if (port == null) continue;
            pinTemplate = port.getPinTemplate();
            RefactorMaps rf = new RefactorMaps();
            rf.setParent(this.devicePath, pinTemplate);
            if (hasExactlyOneOneDeviceInstance) {
                port.setNet(t.getNetUnused());
            }
            if (!netName.equals("NetUnused")) {
                NetMap.mapThroughPath((DevicePath)this.devicePath, (PinInstance)port, (String)netName);
            }
            rf.refactorChildren();
            this.updateNetSetterType(port, pdef);
        }
        return instance;
    }

    public void buildPinNetStuff() {
        Device d = this.getDevicePath().getLast();
        Device die = this.getDie();
        for (PinTemplate dtp : d.getTemplate().getPins()) {
            Net n = NetMap.getNetAt((Net)dtp.getNet(), (DevicePath)this.getDevicePath(), (DeviceTemplate)die.getTemplate());
            if (n == null || n.getDeviceTemplate() != die.getTemplate()) continue;
            String pinName = dtp.getName();
            String netName = n.getName();
            PinAttribute pdef = new PinAttribute();
            this.pinAttributes.add(pdef);
            pdef.netName = netName;
            pdef.pinName = pinName;
        }
        this.byTemplate = !this.isDefinedBySizeByUser(d);
    }

    protected boolean isDefinedBySizeByUser(Device d) {
        return d.getTemplate().getIsSynthesized() && d.getTemplate().getSourceType() != DeviceTemplate.SourceType.VERILOG;
    }

    public String getSideName() {
        return (String)IOViewDlg.Side.getDescriptorAndAngle((int)this.side).first;
    }

    public void transformMe() {
        APair<String, Float> da = IOViewDlg.Side.getDescriptorAndAngle(this.side);
        Device d = this.devicePath.getLast();
        d.setValue("side", (Object)((String)da.first));
        if (!this.isInterface()) {
            return;
        }
        this.devicePath.getChildren().stream().forEach(child -> child.getLast().setValue("side", (Object)((String)da.first)));
        d.setRotate(((Float)da.second).floatValue());
    }

    long getPlacementGroup() {
        try {
            return this.devicePath.getLast().getPlacementGroup();
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public boolean isInterface() {
        return this.isType(DeviceTemplate.Type.PERSONALITY);
    }

    public boolean iAmACover() {
        return this.isType(DeviceTemplate.Type.COVER);
    }

    boolean isInPlacementGroup1() {
        return this.isType(DeviceTemplate.Type.COVER) && this.devicePath.getLast().getSourceType() == Device.SourceType.DECORATOR || this.getPlacementGroup() == 1L;
    }

    private boolean isType(DeviceTemplate.Type type) {
        if (this.devicePath == null || this.devicePath.isEmpty()) {
            return false;
        }
        Device d = this.devicePath.getLast();
        if (d.getDb() == null || d.getTemplate() == null) {
            return false;
        }
        return d.getTemplate().getType() == type;
    }

    public List<IOViewBlock> getChildren() {
        return this.children;
    }

    public ARect rOfLastInterface() {
        if (!this.children.isEmpty()) {
            return this.children.get((int)(this.children.size() - 1)).devicePath.getBB();
        }
        return null;
    }

    public ARect rOfFirstInterface() {
        if (!this.children.isEmpty()) {
            return this.children.get((int)0).devicePath.getBB();
        }
        return null;
    }

    public Long calcCRCOfMeAndMyDescendents() {
        int i = 1;
        long crc = this.getDevicePath().getLast().calcCRC();
        for (IOViewBlock c : this.children) {
            crc += c.getDevicePath().getLast().calcCRC() * (long)i++;
        }
        return crc;
    }

    public Long calcCRCAndSet() {
        Long crc = this.calcCRCOfMeAndMyDescendents();
        IOView.setCRC(this.getDevicePath().getLast(), crc);
        for (IOViewBlock c : this.children) {
            c.calcCRCAndSet();
        }
        return crc;
    }

    public boolean crcDifferent() {
        return !this.sameCRC();
    }

    public boolean sameCRC() {
        Long crcOld = IOView.getCRC(this.getDevicePath().getLast());
        Long crcNow = this.calcCRCOfMeAndMyDescendents();
        if (crcOld == null) {
            return true;
        }
        if (crcNow == null) {
            return true;
        }
        return crcOld.equals(crcNow);
    }

    protected APoint2D getSubstrateLoc() {
        DevicePath dp = this.devicePath;
        DevicePath substratePath = dp.pathToSubstrate();
        substratePath = substratePath.getRelativePath(dp);
        return substratePath.getOrigin();
    }

    static class RefactorMaps {
        DevicePath parentPath;
        PinTemplate parentPin;
        List<ChildNet> childNetsThatMapToParent = new LinkedList<ChildNet>();

        RefactorMaps() {
        }

        public void setParent(DevicePath parentPath, PinTemplate pin) {
            this.parentPath = parentPath;
            this.parentPin = pin;
            Net oldParentNet = this.parentPin.getNet();
            for (DevicePath child : parentPath.getChildren()) {
                Device childDevice = child.getLast();
                DeviceTemplate childTemplate = childDevice.getTemplate();
                for (Net childNet : childTemplate.getNets()) {
                    if (!oldParentNet.equals(NetMap.getParentNet((Device)childDevice, (Net)childNet))) continue;
                    ChildNet cn = new ChildNet(child.getLast(), childNet);
                    this.childNetsThatMapToParent.add(cn);
                }
            }
        }

        public void refactorChildren() {
            Net newParentNet = this.parentPin.getNet();
            if (newParentNet.isUnused()) {
                return;
            }
            for (ChildNet cn : this.childNetsThatMapToParent) {
                NetMap.mapChildNet((Device)cn.child, (Net)cn.net, (Net)newParentNet);
            }
        }

        class ChildNet {
            Device child;
            Net net;

            public ChildNet(Device child, Net net) {
                this.child = child;
                this.net = net;
            }
        }
    }

    static class PinAttribute {
        String pinName;
        String netName;
        String parentNetName = "";
        boolean locked;
        boolean changed;

        PinAttribute() {
        }
    }
}

