/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.iov;

import com.sigrity.acl.ALog;
import com.sigrity.acl.app.AAppView;
import com.sigrity.acl.ui.ADialog;
import com.sigrity.acl.ui.AFieldValidator;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.iov.IOViewBlock;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.HeadlessException;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class IOViewCloneDlg
extends ADialog {
    protected AAppView mView;
    protected IOViewBlock mBlock = null;
    protected JTextField mNum;
    protected boolean mAccepted = false;
    protected ActionListener mOk = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!IOViewCloneDlg.this.validateUserInput()) {
                ALog.logInfo((String)"Please type in an number representing the number of new copies you would like");
                IOViewCloneDlg.this.mAccepted = false;
                UIUtil.closeWindow((Window)((Object)IOViewCloneDlg.this));
            } else {
                IOViewCloneDlg.this.mAccepted = true;
                UIUtil.closeWindow((Window)((Object)IOViewCloneDlg.this));
            }
        }
    };

    public static IOViewCloneDlg createDialog(Window owner, IOViewBlock block) {
        IOViewCloneDlg dlg = null;
        dlg = new IOViewCloneDlg(owner);
        dlg.init(block);
        return dlg;
    }

    public IOViewCloneDlg(Window owner) throws HeadlessException {
        super(owner);
    }

    public boolean getAccepted() {
        return this.mAccepted;
    }

    public int getCopies() {
        return Integer.parseInt(this.mNum.getText());
    }

    protected void init(IOViewBlock block) {
        this.mView = OrbitIO.getCurView();
        this.mBlock = block;
        this.setTitle("Clone " + this.mBlock.getName());
        this.setModal(true);
        GridBagManager l = new GridBagManager(this.getContentPane());
        l.add("How Many New Copies:");
        this.mNum = new JTextField(10);
        l.add((Component)this.mNum, (GridBagConstraints)GridBagManager.FILLX);
        l.newline();
        l.push((Container)new JPanel(), (GridBagConstraints)GridBagManager.RIGHT_REMAINX);
        JButton btnOk = new JButton("OK");
        l.add((Component)btnOk, (GridBagConstraints)GridBagManager.RIGHT);
        btnOk.addActionListener(this.mOk);
        JButton btnClose = new JButton("Cancel");
        l.add((Component)btnClose, (GridBagConstraints)GridBagManager.RIGHT);
        l.pop();
        UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnClose, (JButton)btnOk);
        this.pack();
        this.setMinimumSize(this.getPreferredSize());
        UIUtil.center((Component)((Object)this));
    }

    protected boolean validateUserInput() {
        try {
            AFieldValidator.validateInt((JTextField)this.mNum);
        }
        catch (AFieldValidator.AFieldValidationException ve) {
            return false;
        }
        return true;
    }
}

