/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.iov;

import com.sigrity.acl.ALog;
import com.sigrity.acl.Unit;
import com.sigrity.acl.app.AAppView;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.ui.AButtonGroup;
import com.sigrity.acl.ui.ADialog;
import com.sigrity.acl.ui.AFieldValidator;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.factory.CoreFactory;
import com.sigrity.orbit.iov.IOView;
import com.sigrity.orbit.iov.IOViewBlock;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.HeadlessException;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;

public class IOViewCreatePersonalityDlg
extends ADialog {
    protected AAppView mView;
    protected IOViewBlock mBlock = null;
    protected JTextField mGapDistance;
    protected JTextField mInsetDistance;
    private JTextField mLeadMarginDistance;
    private JTextField mTrailMarginDistance;
    private List<String> mInvalidNames;
    private Color mValidNameColor;
    protected JTextField mIOCellName;
    protected JCheckBox mIgnoreGrid;
    protected JRadioButton mTopLevel;
    protected JRadioButton mCoreLevel;
    protected JLabel mDecoratorName;
    protected boolean mAccepted = false;
    protected ActionListener mOk = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            IOViewCreatePersonalityDlg.this.createBlockFromDialog();
            IOViewCreatePersonalityDlg.this.mAccepted = true;
            UIUtil.closeWindow((Window)((Object)IOViewCreatePersonalityDlg.this));
        }
    };

    public static IOViewCreatePersonalityDlg createDialog(Window owner, IOViewBlock block, boolean create, List<String> invalidNames) {
        IOViewCreatePersonalityDlg dlg = null;
        dlg = new IOViewCreatePersonalityDlg(owner);
        dlg.init(block, create, invalidNames);
        return dlg;
    }

    public IOViewCreatePersonalityDlg(Window owner) throws HeadlessException {
        super(owner);
    }

    public boolean getAccepted() {
        return this.mAccepted;
    }

    protected void init(IOViewBlock block, boolean create, List<String> invalidNames) {
        this.mInvalidNames = invalidNames;
        this.mView = OrbitIO.getCurView();
        this.setTitle("Edit Interface ");
        this.setModal(true);
        GridBagManager l = new GridBagManager(this.getContentPane());
        l.pushFill();
        l.add("Name:");
        this.mIOCellName = new JTextField(10);
        l.add((Component)this.mIOCellName, (GridBagConstraints)GridBagManager.FILLX_REMAINX);
        l.newline();
        this.mValidNameColor = this.mIOCellName.getForeground();
        AbstractDocument document = (AbstractDocument)this.mIOCellName.getDocument();
        document.setDocumentFilter(new DocumentFilter(){

            @Override
            public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
                String autoConvertSpaceToUnderline = string.replace(" ", "_");
                fb.insertString(offset, autoConvertSpaceToUnderline, attr);
            }

            @Override
            public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
                String autoConvertSpaceToUnderline = text.replace(" ", "_");
                fb.replace(offset, length, autoConvertSpaceToUnderline, attrs);
            }
        });
        this.mIOCellName.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.setTextColor(IOViewCreatePersonalityDlg.this.mIOCellName.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.setTextColor(IOViewCreatePersonalityDlg.this.mIOCellName.getText());
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.setTextColor(IOViewCreatePersonalityDlg.this.mIOCellName.getText());
            }

            public void setTextColor(String name) {
                boolean invalid = IOViewCreatePersonalityDlg.this.mInvalidNames.contains(name);
                IOViewCreatePersonalityDlg.this.mIOCellName.setForeground(invalid ? Color.red : IOViewCreatePersonalityDlg.this.mValidNameColor);
            }
        });
        l.add("Gap:");
        this.mGapDistance = new JTextField(10);
        l.add((Component)this.mGapDistance, (GridBagConstraints)GridBagManager.FILLX_REMAINX);
        l.newline();
        l.add("Inset:");
        this.mInsetDistance = new JTextField(10);
        l.add((Component)this.mInsetDistance, (GridBagConstraints)GridBagManager.FILLX_REMAINX);
        l.newline();
        l.add("Lead Margin:");
        this.mLeadMarginDistance = new JTextField(10);
        l.add((Component)this.mLeadMarginDistance, (GridBagConstraints)GridBagManager.FILLX_REMAINX);
        l.newline();
        l.add("Trail Margin:");
        this.mTrailMarginDistance = new JTextField(10);
        l.add((Component)this.mTrailMarginDistance, (GridBagConstraints)GridBagManager.FILLX_REMAINX);
        l.newline();
        this.mIgnoreGrid = new JCheckBox("Ignore Bump Grid");
        l.add((Component)this.mIgnoreGrid, (GridBagConstraints)GridBagManager.FILLX);
        l.newline();
        this.mDecoratorName = new JLabel("Decorator:");
        l.add((Component)this.mDecoratorName);
        l.pop();
        l.newline();
        AButtonGroup mParent = new AButtonGroup();
        l.pushFillAllRemainX("Parent of Interface");
        this.mTopLevel = new JRadioButton("Top Level");
        l.add((Component)this.mTopLevel, (GridBagConstraints)GridBagManager.FILLX_REMAINX);
        l.newline();
        this.mCoreLevel = new JRadioButton("Core");
        l.add((Component)this.mCoreLevel, (GridBagConstraints)GridBagManager.FILLX_REMAINX);
        mParent.add(this.mTopLevel);
        mParent.add(this.mCoreLevel);
        l.pop();
        l.newline();
        l.push((Container)new JPanel(), (GridBagConstraints)GridBagManager.RIGHT_REMAINX);
        JButton btnOk = new JButton("OK");
        l.add((Component)btnOk, (GridBagConstraints)GridBagManager.RIGHT);
        btnOk.addActionListener(this.mOk);
        JButton btnClose = new JButton("Cancel");
        l.add((Component)btnClose, (GridBagConstraints)GridBagManager.RIGHT);
        l.pop();
        UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnClose, (JButton)btnOk);
        this.pack();
        this.setMinimumSize(this.getPreferredSize());
        this.updateUI(block);
        UIUtil.center((Component)((Object)this));
    }

    private String makeValid(String name) {
        while (this.mInvalidNames.contains(name)) {
            name = (String)name + "_1";
        }
        return name;
    }

    protected void updateUI(IOViewBlock block) {
        this.mBlock = block;
        Db db = OrbitIO.getCurDb();
        Unit unit = Design.getUnit((Db)db);
        String name = block.getDesiredName();
        String inset = unit.toUserStr(block.inset);
        String gap = unit.toUserStr(block.gap);
        String marginLead = unit.toUserStr(block.marginLead);
        String marginTrail = unit.toUserStr(block.marginTrail);
        boolean ignoreGrid = block.ignoreGrid;
        this.mIOCellName.setText(name);
        this.mGapDistance.setText(gap);
        this.mInsetDistance.setText(inset);
        this.mLeadMarginDistance.setText(marginLead);
        this.mTrailMarginDistance.setText(marginTrail);
        Device theDie = IOView.theIOView.getRootDevicePath().getLast();
        DevicePath path = theDie.getADevicePath();
        DevicePath corePath = CoreFactory.getCoreDevicePath(path);
        this.mTopLevel.setText(theDie.getName());
        this.mTopLevel.setSelected(true);
        this.mCoreLevel.setEnabled(false);
        if (corePath != null) {
            DevicePath constructed = new DevicePath(theDie);
            constructed.add(corePath.getLast());
            this.mCoreLevel.setText(constructed.toString());
            this.mCoreLevel.setEnabled(true);
            Device interfce = block.devicePath.getLast();
            DeviceTemplate parent = interfce.getParent();
            if (corePath.getDeviceTemplate().equals(parent)) {
                this.mCoreLevel.setSelected(true);
            }
        }
        this.mIgnoreGrid.setSelected(ignoreGrid);
        String decorationName = IOView.getDecorationName(block);
        if (decorationName == null) {
            decorationName = "";
        }
        this.mDecoratorName.setText("Decorator: " + decorationName);
    }

    protected void createBlockFromDialog() {
        Db db = OrbitIO.getCurDb();
        Unit unit = Design.getUnit((Db)db);
        long g = 0L;
        long i = 0L;
        long leadMargin = 0L;
        long trailMargin = 0L;
        if (!this.mGapDistance.getText().isEmpty()) {
            try {
                AFieldValidator.validateDouble((JTextField)this.mGapDistance);
            }
            catch (AFieldValidator.AFieldValidationException ve) {
                return;
            }
            g = unit.fromUser(Double.parseDouble(this.mGapDistance.getText().replace(",", "")));
        }
        if (!this.mInsetDistance.getText().isEmpty()) {
            try {
                AFieldValidator.validateDouble((JTextField)this.mInsetDistance);
            }
            catch (AFieldValidator.AFieldValidationException ve) {
                return;
            }
            i = unit.fromUser(Double.parseDouble(this.mInsetDistance.getText().replace(",", "")));
        }
        if (!this.mLeadMarginDistance.getText().isEmpty()) {
            try {
                AFieldValidator.validateDouble((JTextField)this.mLeadMarginDistance);
            }
            catch (AFieldValidator.AFieldValidationException ve) {
                return;
            }
            leadMargin = unit.fromUser(Double.parseDouble(this.mLeadMarginDistance.getText().replace(",", "")));
        }
        if (!this.mTrailMarginDistance.getText().isEmpty()) {
            try {
                AFieldValidator.validateDouble((JTextField)this.mTrailMarginDistance);
            }
            catch (AFieldValidator.AFieldValidationException ve) {
                return;
            }
            trailMargin = unit.fromUser(Double.parseDouble(this.mTrailMarginDistance.getText().replace(",", "")));
        }
        this.mBlock.ignoreGrid = this.mIgnoreGrid.isSelected();
        this.mBlock.gap = g;
        this.mBlock.inset = i;
        this.mBlock.marginLead = leadMargin;
        this.mBlock.marginTrail = trailMargin;
        this.mBlock.pinAttributes.clear();
        String name = this.mIOCellName.getText();
        this.mBlock.setDesiredName(this.makeValid(name));
        this.mBlock.ignoreGrid = this.mIgnoreGrid.isSelected();
        Device dieDevice = IOView.theIOView.getRootDevicePath().getLast();
        DevicePath aPath = dieDevice.getADevicePath();
        Object constructed = "/";
        constructed = (String)constructed + dieDevice.getName();
        constructed = (String)constructed + "/";
        if (this.mCoreLevel.isSelected()) {
            DevicePath corePath = CoreFactory.getCoreDevicePath(aPath);
            if (corePath != null) {
                constructed = (String)constructed + corePath.getLast().getName();
            }
            constructed = (String)constructed + "/";
        }
        this.mBlock.desiredPathName = constructed = (String)constructed + this.mBlock.getDesiredName();
    }

    public class DomainChooser
    extends JPanel {
        protected DeviceTemplate mDT;
        protected JComboBox<DeviceTemplate> mCboDomains;
        protected DefaultComboBoxModel<DeviceTemplate> mDomains;
        protected KeyListener mKeyListener = new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                super.keyTyped(e);
                char key = e.getKeyChar();
                if (key == '\n') {
                    String domainName = (String)DomainChooser.this.mCboDomains.getSelectedItem();
                    if (domainName != null) {
                        domainName = domainName.trim();
                    }
                    if (domainName == null || domainName.length() == 0) {
                        return;
                    }
                    int idx = DomainChooser.this.mDomains.getIndexOf(domainName);
                    if (idx >= 0) {
                        DomainChooser.this.mDomains.removeElementAt(idx);
                    }
                    DomainChooser.this.mDomains.setSelectedItem(null);
                    ALog.logInfo((String)"Executing user command '%s'.", (Object[])new Object[]{domainName});
                }
            }
        };

        public DomainChooser(DeviceTemplate dt) {
            this.mDT = dt;
            this.setBorder(null);
            this.setLayout(new BorderLayout());
            this.mCboDomains = new JComboBox();
            this.mCboDomains.setEditable(true);
            this.add(this.mCboDomains);
            Dimension ps = this.mCboDomains.getPreferredSize();
            this.mCboDomains.setMinimumSize(new Dimension(ps.height, 20));
            this.mCboDomains.getEditor().getEditorComponent().addKeyListener(this.mKeyListener);
            this.mDomains = (DefaultComboBoxModel)this.mCboDomains.getModel();
            this.populateControl();
            this.mCboDomains.setSelectedIndex(-1);
            this.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    DomainChooser.this.mCboDomains.requestFocusInWindow();
                }
            });
        }

        protected void populateControl() {
        }
    }
}

