/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.iov;

import com.sigrity.acl.ALog;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.orbit.iov.IOView;
import com.sigrity.orbit.iov.IOViewBlock;
import java.util.ArrayList;
import java.util.List;

public abstract class IOViewDecorator {
    protected List<IOViewBlock> input = new ArrayList<IOViewBlock>();
    private List<IOViewBlock> output = new ArrayList<IOViewBlock>();
    protected IOViewBlock parent = null;

    public abstract void decorate();

    public void setParent(IOViewBlock parent) {
        this.parent = parent;
        this.input = parent.children;
    }

    public IOViewBlock getParent() {
        return this.parent;
    }

    public List<IOViewBlock> getOutput() {
        return this.output;
    }

    protected void copyToOutput(IOViewBlock b) {
        this.output.add(b);
    }

    protected IOViewBlock makeBlock(String name, String templateName) {
        IOViewBlock bp = new IOViewBlock(name);
        bp.byTemplate = true;
        bp.template = DeviceTemplate.getDeviceTemplate((Substrate)IOView.theIOView.getSubstrate(), (String)templateName);
        if (bp.template == null) {
            ALog.logError((String)("Can not find a template named " + templateName));
        }
        bp.side = this.parent.side;
        bp.parent = this.parent;
        bp.makeDbDevice();
        bp.devicePath.getLast().setRotate(0.0f);
        bp.devicePath.getLast().assignToPersonality(this.parent.devicePath.getLast().getPersonality());
        bp.devicePath.getLast().setSourceType(Device.SourceType.DECORATOR);
        return bp;
    }

    protected IOViewBlock addToOutput(String name, String templateName) {
        return this.addToOutput(name, templateName, 0.0f);
    }

    protected IOViewBlock addToOutput(String name, String templateName, float rot) {
        IOViewBlock bp = new IOViewBlock(name);
        bp.byTemplate = true;
        bp.template = DeviceTemplate.getDeviceTemplate((Substrate)IOView.theIOView.getSubstrate(), (String)templateName);
        if (bp.template == null) {
            ALog.logError((String)("Can not find a template named " + templateName));
            return null;
        }
        bp.side = this.parent.side;
        bp.parent = this.parent;
        bp.makeDbDevice();
        bp.devicePath.getLast().setRotate(rot);
        bp.devicePath.getLast().assignToPersonality(this.parent.devicePath.getLast().getPersonality());
        bp.devicePath.getLast().setSourceType(Device.SourceType.DECORATOR);
        this.output.add(bp);
        return bp;
    }

    protected void addToOutput(Device d, String name, String templateName, long gap, long inset) {
        IOViewBlock bp = new IOViewBlock(name);
        bp.byTemplate = true;
        bp.template = DeviceTemplate.getDeviceTemplate((Substrate)d.getSubstrate(), (String)templateName);
        if (bp.template == null) {
            ALog.logError((String)("Can not find a template named " + templateName));
        }
        bp.side = this.parent.side;
        bp.parent = this.parent;
        bp.makeDbDevice(d);
        bp.devicePath.getLast().setRotate(0.0f);
        bp.devicePath.getLast().assignToPersonality(this.parent.devicePath.getLast().getPersonality());
        bp.devicePath.getLast().setSourceType(Device.SourceType.DECORATOR);
        bp.gap = gap;
        bp.inset = inset;
        this.output.add(bp);
    }
}

