/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.iov;

import com.sigrity.acl.AFileFilter;
import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.app.AAppView;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbClass;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Constraint;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.ui.AColorIcon;
import com.sigrity.acl.ui.AFileChooser;
import com.sigrity.acl.ui.DbDialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.RegexFilterField;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.acl.ui.atree.ALazyTreeNode;
import com.sigrity.acl.ui.atree.ATreeCellRenderer;
import com.sigrity.acl.ui.atree.ATreeModel;
import com.sigrity.acl.ui.atree.ATreeNode;
import com.sigrity.decorators.DieDecorator;
import com.sigrity.lic.LSession;
import com.sigrity.orbit.DbObjectHighlighter;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ShowMeTheWay;
import com.sigrity.orbit.automation.BumpFactoryData;
import com.sigrity.orbit.drc.BumpDRCDlg;
import com.sigrity.orbit.export.BgaDieTxtIO;
import com.sigrity.orbit.factory.CoreFactory;
import com.sigrity.orbit.iov.ExportIOCSVDlg;
import com.sigrity.orbit.iov.IOConnectionUtil;
import com.sigrity.orbit.iov.IOView;
import com.sigrity.orbit.iov.IOViewBlock;
import com.sigrity.orbit.iov.IOViewCloneDlg;
import com.sigrity.orbit.iov.IOViewConnectionFactory;
import com.sigrity.orbit.iov.IOViewCreatePersonalityDlg;
import com.sigrity.orbit.iov.IOViewDieDecorator;
import com.sigrity.orbit.iov.IOViewDieDecoratorRegistry;
import com.sigrity.orbit.iov.IOViewEditBlockDlg;
import com.sigrity.orbit.iov.IOViewOptionsDlg;
import com.sigrity.orbit.iov.IOViewSerializer;
import com.sigrity.orbit.iov.IOViewTreeUI;
import com.sigrity.orbit.iov.ImportIOCSVDlg;
import com.sigrity.orbit.iov.PinDefinition;
import com.sigrity.orbit.iov.ProgramableTilePlacer;
import com.sigrity.orbit.iov.PtilesMgmt;
import com.sigrity.orbit.ui.DeviceTemplateUI;
import com.sigrity.orbit.ui.ExportVerilogUI2;
import com.sigrity.orbit.ui.ExternalDeviceUpdateListener;
import com.sigrity.orbit.ui.HelpButton;
import com.sigrity.orbit.ui.OrbitIcons;
import com.sigrity.orbit.ui.OrbitLibrarySerializerUI;
import com.sigrity.orbit.ui.PatternPlacementUI;
import com.sigrity.orbit.ui.VerilogUI;
import com.sigrity.orbit.ui.canvas_modes.EditDeviceBoundsMode;
import com.sigrity.orbit.ui.core.DesignView2D;
import com.sigrity.orbit.ui.wb_route.WbFcFeasibilityUI;
import com.sigrity.tools.dbexplorer.DBEResources;
import com.sigrity.tools.dbexplorer.DbExplorerPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.Autoscroll;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.DropMode;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.TransferHandler;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.ColorUIResource;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class IOViewDlg
extends DbDialog {
    IOView mIOView;
    Device dDevice;
    public static final DataFlavor DeviceBlockDataFlavor = new DataFlavor(IOViewBlock.class, "DeviceBlock");
    static DevicePath lastDevicePath = null;
    protected AAppView mView;
    protected Design mDesign;
    protected IOViewTree ioViewTree;
    protected ArrayList<String> lastExpandedSet = new ArrayList();
    protected HistoryListener mHL = null;
    protected DbClass.DbObjectListener mDTL = null;
    protected DbClass.DbObjectListener mDL = null;
    protected IOViewListener mRefreshListener = null;
    protected TreePath lastEditedPath;
    protected int lastEditedRow;
    protected IOViewBlock focusBlock = null;
    protected Device dieDevice;
    protected boolean refreshPending = false;
    protected boolean pendingBuildingIOView = false;
    protected TreeSearcher treeSearcher;
    JMenuItem makeLogicalCoreMenuItem = null;
    JScrollPane sp;
    RegexFilterField findField;
    JLabel findResults;
    protected static IOViewDlg mLastDlg;
    protected static ExternalAddInfo externalAddState;
    protected static ExternalDeviceUpdateListener.ListenerInterface TheUpdateListener;
    protected DbClass.DbObjectListener mDbObjectsListener = new DbClass.DbObjectAdapter(){

        public void removedObject(DbClass.ObjectRemove e) {
        }

        public boolean removingObject(DbClass.ObjectRemove e) {
            return true;
        }

        public void changedObject(DbClass.ObjectChange e) {
            IOViewDlg.this.queueRebuildOfIOView();
        }

        public void addedObject(DbClass.ObjectAdd e) {
        }
    };
    protected RegexFilterField.FilterListener mFilterListener = pattern -> {
        if (pattern != null) {
            if (this.treeSearcher.getLastPattern() == null || !this.treeSearcher.getLastPattern().pattern().equals(pattern.pattern())) {
                this.treeSearcher.searchFor(pattern);
            } else {
                this.treeSearcher.next();
            }
        }
    };
    protected IOViewTree.PopupMenuHandler mTreePopupMenuHandler = new IOViewTree.PopupMenuHandler(){

        @Override
        public void handlePopup(int x, int y) {
            TreePath[] treePaths = IOViewDlg.this.ioViewTree.getSelectionPaths();
            if (treePaths != null && treePaths.length > 1) {
                IOViewDlg.this.mIOTreePopupMenuForMultiple.show(IOViewDlg.this.ioViewTree, x, y);
            } else {
                int row = IOViewDlg.this.ioViewTree.getRowForLocation(x, y);
                IOViewDlg.this.ioViewTree.setSelectionRow(row);
                TreePath treePath = IOViewDlg.this.ioViewTree.getSelectionPath();
                if (treePath == null) {
                    return;
                }
                if (treePath.getLastPathComponent().getClass().equals(RootNode.class)) {
                    IOViewDlg.this.mIOTreePopupMenuForRoot.show(IOViewDlg.this.ioViewTree, x, y);
                } else if (treePath.getLastPathComponent().getClass().equals(DeviceNode.class)) {
                    DeviceNode dn = (DeviceNode)((Object)treePath.getLastPathComponent());
                    if (dn.dblock.isInterface()) {
                        IOViewDlg.this.mIOTreePopupMenuForPersonality.show(IOViewDlg.this.ioViewTree, x, y);
                    } else {
                        IOViewDlg.this.mIOTreePopupMenuForIOCell.show(IOViewDlg.this.ioViewTree, x, y);
                    }
                } else if (treePath.getLastPathComponent().getClass().equals(SideNode.class)) {
                    IOViewDlg.this.mIOTreePopupMenuForSide.show(IOViewDlg.this.ioViewTree, x, y);
                }
            }
        }
    };
    protected ActionListener mNextResultAction = e -> this.treeSearcher.next();
    protected ActionListener mPrevResultAction = e -> this.treeSearcher.back();
    protected ActionListener mEditCell = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath treePath = IOViewDlg.this.ioViewTree.getSelectionPath();
            if (treePath.getLastPathComponent().getClass().equals(DeviceNode.class)) {
                DeviceNode dn = (DeviceNode)((Object)treePath.getLastPathComponent());
                if (!dn.dblock.isInterface()) {
                    try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)IOViewDlg.this.mDb, (String)"Edit IOCell");){
                        IOViewDlg.this.editIOCell(dn);
                    }
                }
            }
        }
    };
    protected ActionListener mPasteSelectedActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath treePath = IOViewDlg.this.ioViewTree.getSelectionPath();
            IOViewDlg.this.pasteBuffer(IOView.theIOView.getCPBuffer(), treePath);
        }
    };
    protected ActionListener mRescheduleSelectedActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath[] treePaths;
            ArrayList<DeviceNode> froms = new ArrayList<DeviceNode>();
            for (TreePath tp : treePaths = IOViewDlg.this.ioViewTree.getSelectionPaths()) {
                if (!tp.getLastPathComponent().getClass().equals(DeviceNode.class)) continue;
                DeviceNode fromNode = (DeviceNode)((Object)tp.getLastPathComponent());
                froms.add(fromNode);
            }
            IOViewConnectionFactory cf = new IOViewConnectionFactory();
            cf.setOutsideSubstrate(IOView.theIOView.getHideOutsideSubstrate());
            for (DeviceNode dn : froms) {
                cf.addInterface(dn.dblock.getDevicePath().getLast().getADevicePath());
            }
            cf.go();
            OrbitIO.getApp().refreshCurrentView(false);
        }
    };
    protected ActionListener mGroupSelectedActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            ArrayList<DeviceNode> froms = new ArrayList<DeviceNode>();
            TreePath[] treePaths = IOViewDlg.this.ioViewTree.getSelectionPaths();
            for (TreePath tp : treePaths) {
                if (!tp.getLastPathComponent().getClass().equals(DeviceNode.class)) continue;
                DeviceNode fromNode = (DeviceNode)((Object)tp.getLastPathComponent());
                froms.add(fromNode);
            }
            Cp.exec(() -> IOView.setNewGroup("group"), (String)"IOView.setNewGroup (\"group\")", (Object[])new Object[0]);
            for (DeviceNode dn : froms) {
                IOViewBlock interfaceBlock = dn.dblock;
                Cp.exec(() -> IOView.addToGroup(interfaceBlock.devicePath.toString()), (String)"IOView.addToGroup(\"%s\");", (Object[])new Object[]{interfaceBlock.devicePath.toString()});
            }
            Cp.exec(IOView::makeGroup, (String)"IOView.makeGroup();", (Object[])new Object[0]);
            OrbitIO.getApp().refreshCurrentView(false);
        }
    };
    protected ActionListener mCutSelectedActionListener = new ActionListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath[] treePaths = IOViewDlg.this.ioViewTree.getSelectionPaths();
            ArrayList<DeviceNode> froms = new ArrayList<DeviceNode>();
            for (TreePath tp : treePaths) {
                DeviceNode fromNode;
                if (tp.getLastPathComponent().getClass().equals(DeviceNode.class)) {
                    fromNode = (DeviceNode)((Object)tp.getLastPathComponent());
                    IOViewBlock from = fromNode.dblock;
                    if (from.devicePath.getLast().getIsFixed()) {
                        ALog.logWarn((String)"Can not cut fixed devices");
                        return;
                    }
                } else {
                    ALog.logWarn((String)"Can only cut devices");
                    return;
                }
                froms.add(fromNode);
            }
            try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)IOViewDlg.this.mDb, (String)"Cut Selected IOCells");){
                for (DeviceNode dn : froms) {
                    IOViewBlock parent;
                    IOViewBlock child = dn.dblock;
                    IOViewDlg.this.focusBlock = parent = child.parent;
                    Cp.exec(() -> IOView.addDeviceToCPBuffer(child.devicePath.toString()), (String)"IOView.addDeviceToCPBuffer (\"%s\")", (Object[])new Object[]{child.devicePath.toString()});
                    Cp.exec(() -> IOView.cutBlockFromParent(child.devicePath.toString(), parent.devicePath.toString()), (String)"IOView.cutBlockFromParent (\"%s\", \"%s\")", (Object[])new Object[]{child.devicePath.toString(), parent.devicePath.toString()});
                }
            }
            finally {
                Cp.exec(IOView::buldCanvasAndIOView, (String)"IOView.buldCanvasAndIOView()", (Object[])new Object[0]);
                OrbitIO.getApp().refreshCurrentView(false);
            }
        }
    };
    protected ActionListener mDeleteSelectedActionListener = new ActionListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath[] treePaths = IOViewDlg.this.ioViewTree.getSelectionPaths();
            ArrayList<DeviceNode> froms = new ArrayList<DeviceNode>();
            for (TreePath tp : treePaths) {
                DeviceNode fromNode;
                if (tp.getLastPathComponent().getClass().equals(DeviceNode.class)) {
                    fromNode = (DeviceNode)((Object)tp.getLastPathComponent());
                    IOViewBlock from = fromNode.dblock;
                    if (from.devicePath.getLast().getIsFixed()) {
                        ALog.logWarn((String)"Can not delete fixed devices");
                        return;
                    }
                } else {
                    ALog.logWarn((String)"Can only delete devices");
                    return;
                }
                froms.add(fromNode);
            }
            try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)IOViewDlg.this.mDb, (String)"Delete Selected");){
                for (DeviceNode dn : froms) {
                    IOViewBlock parent;
                    IOViewBlock child = dn.dblock;
                    IOViewDlg.this.focusBlock = parent = child.parent;
                    if (dn.getParent().getClass().equals(SideNode.class)) {
                        SideNode sn = (SideNode)dn.getParent();
                        int side = sn.getSide();
                        Cp.exec(() -> IOView.removeBlockFromSide(child.devicePath.toString(), side), (String)"com.sigrity.orbit.iov.IOView.removeBlockFromSide (\"%s\", %d)", (Object[])new Object[]{child.devicePath.toString(), side});
                        continue;
                    }
                    Cp.exec(() -> IOView.removeBlockFromParent(child.devicePath.toString(), parent.devicePath.toString()), (String)"IOView.removeBlockFromParent (\"%s\", \"%s\")", (Object[])new Object[]{child.devicePath.toString(), parent.devicePath.toString()});
                }
            }
            finally {
                Cp.exec(IOView::buldCanvasAndIOView, (String)"IOView.buldCanvasAndIOView()", (Object[])new Object[0]);
                OrbitIO.getApp().refreshCurrentView(false);
            }
        }
    };
    protected ActionListener mCloneIOCellActionListner = new ActionListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath treePath = IOViewDlg.this.ioViewTree.getSelectionPath();
            if (treePath.getLastPathComponent().getClass().equals(DeviceNode.class)) {
                DeviceNode dn = (DeviceNode)((Object)treePath.getLastPathComponent());
                IOViewCloneDlg dlg = IOViewCloneDlg.createDialog((Window)((Object)IOViewDlg.this), dn.dblock);
                dlg.setVisible(true);
                if (dlg.getAccepted()) {
                    IOViewBlock b;
                    int copies = dlg.getCopies();
                    if (copies <= 0) {
                        return;
                    }
                    OrbitIO.getApp().refreshCurrentView(false);
                    IOViewDlg.this.focusBlock = b = dn.dblock;
                    try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)IOViewDlg.this.mDb, (String)("Clone " + b.getName() + " " + copies + " times"));){
                        Cp.exec(() -> IOViewBlock.cloneMe(b.parent.getName(), b.getName(), copies), (String)"IOViewBlock.cloneMe (\"%s\",\"%s\",  %d);", (Object[])new Object[]{b.parent.getName(), b.getName(), copies});
                        Cp.exec(IOView::somethingChanged, (String)"com.sigrity.orbit.iov.IOView.somethingChanged();", (Object[])new Object[0]);
                    }
                    finally {
                        IOViewDlg.this.refreshTree();
                        OrbitIO.getApp().refreshCurrentView(false);
                    }
                }
                UIUtil.closeWindow((Window)((Object)dlg));
            }
        }
    };
    protected ActionListener mEditInterfaceActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath treePath = IOViewDlg.this.ioViewTree.getSelectionPath();
            DeviceNode dn = (DeviceNode)((Object)treePath.getLastPathComponent());
            IOViewDlg.this.editInterface(dn);
        }
    };
    protected ActionListener mCutInterfaceActionListener = new ActionListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath[] treePaths = IOViewDlg.this.ioViewTree.getSelectionPaths();
            ArrayList<DeviceNode> froms = new ArrayList<DeviceNode>();
            for (TreePath tp : treePaths) {
                if (tp.getLastPathComponent().getClass().equals(DeviceNode.class)) {
                    DeviceNode fromNode = (DeviceNode)((Object)tp.getLastPathComponent());
                    IOViewBlock from = fromNode.dblock;
                    if (!from.isInterface()) {
                        ALog.logWarn((String)"Can only cut interfaces");
                        continue;
                    }
                    froms.add(fromNode);
                    continue;
                }
                ALog.logWarn((String)"Can only cut interfaces");
                return;
            }
            try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)IOViewDlg.this.mDb, (String)"Cut Interfaces");){
                for (DeviceNode dn : froms) {
                    IOViewBlock inter = dn.dblock;
                    Cp.exec(() -> IOView.addDeviceToCPBuffer(inter.devicePath.toString()), (String)"IOView.addDeviceToCPBuffer (\"%s\")", (Object[])new Object[]{inter.devicePath.toString()});
                    int side = inter.side;
                    Cp.exec(() -> IOView.cutBlockFromSide(inter.devicePath.toString(), side), (String)"com.sigrity.orbit.iov.IOView.cutBlockFromSide (\"%s\", %d)", (Object[])new Object[]{inter.devicePath.toString(), side});
                }
            }
            finally {
                OrbitIO.getApp().refreshCurrentView(false);
            }
        }
    };
    protected ActionListener mApproveInterface = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath treePath = IOViewDlg.this.ioViewTree.getSelectionPath();
            DeviceNode dn = (DeviceNode)((Object)treePath.getLastPathComponent());
            Cp.exec(() -> IOView.approveInterface(dn.dblock.devicePath.toString()), (String)"com.sigrity.orbit.iov.IOView.approveInterface (\"%s\")", (Object[])new Object[]{dn.dblock.devicePath.toString()});
            Cp.exec(IOView::somethingChanged, (String)"com.sigrity.orbit.iov.IOView.somethingChanged();", (Object[])new Object[0]);
            OrbitIO.getApp().refreshCurrentView(false);
        }
    };
    protected ActionListener mDeleteInterfaceActionListener = new ActionListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath treePath = IOViewDlg.this.ioViewTree.getSelectionPath();
            DeviceNode dn = (DeviceNode)((Object)treePath.getLastPathComponent());
            IOViewBlock block = dn.dblock;
            int side = 0;
            if (dn.getParent().getClass().equals(SideNode.class)) {
                SideNode sn = (SideNode)dn.getParent();
                side = sn.getSide();
            }
            try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)IOViewDlg.this.mDb, (String)("Delete Interface " + block.devicePath.toString()));){
                int side_ = side;
                Cp.exec(() -> IOView.removeBlockFromSide(block.devicePath.toString(), side_), (String)"com.sigrity.orbit.iov.IOView.removeBlockFromSide (\"%s\", %d)", (Object[])new Object[]{block.devicePath.toString(), side});
            }
            finally {
                OrbitIO.getApp().refreshCurrentView(false);
            }
        }
    };
    private ActionListener mRemoveAllIOCellGaps = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath treePath = IOViewDlg.this.ioViewTree.getSelectionPath();
            DeviceNode dn = (DeviceNode)((Object)treePath.getLastPathComponent());
            IOViewBlock b = dn.dblock;
            if (b.isInterface()) {
                Cp.exec(() -> IOView.removeAllIOCellGaps(b.parent.getName(), b.getName()), (String)"com.sigrity.orbit.iov.IOView.removeAllIOCellGaps (\"%s\",\"%s\")", (Object[])new Object[]{b.parent.getName(), b.getName()});
                Cp.exec(IOView::somethingChanged, (String)"com.sigrity.orbit.iov.IOView.somethingChanged();", (Object[])new Object[0]);
            } else {
                ALog.logWarn((String)"This only works on interface");
            }
        }
    };
    protected ActionListener mCreateRouteGroup = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath treePath = IOViewDlg.this.ioViewTree.getSelectionPath();
            DeviceNode dn = (DeviceNode)((Object)treePath.getLastPathComponent());
            IOViewBlock block = dn.dblock;
            DeviceTemplate devTemp = IOViewDlg.this.dieDevice.getTemplate();
            String pName = IOView.getPersonalityNameForRouteGroup(block.getDevicePath());
            try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)IOViewDlg.this.mDb, (String)"Create Route Group");){
                Cp.exec(() -> WbFcFeasibilityUI.addRDLRouteGroupDefintionForDevTemp(devTemp.getKeyStr(), pName), (String)"com.sigrity.orbit.ui.wb_route.WbFcFeasibilityUI.addRDLRouteGroupDefintionForDevTemp (\"%s\",\"%s\");", (Object[])new Object[]{devTemp.getKeyStr(), pName});
                Optional p = Personality.getPersonality((DeviceTemplate)devTemp, (Personality.Type)Personality.Type.RDL, (String)pName);
                int count = 0;
                for (DevicePath d : block.devicePath.getDescendants()) {
                    for (PinInstance dp : d.getLast().getPins()) {
                        if (dp.getPinTemplate().getType() != PinTemplate.Type.IOPAD) continue;
                        if (p.isPresent()) {
                            dp.assignToRouteDefinition((Personality)p.get());
                        }
                        ++count;
                    }
                }
                if (p.isPresent()) {
                    ALog.logInfo((String)(count + " IO Pads assigned to " + ((Personality)p.get()).getName()));
                }
            }
        }
    };
    protected ActionListener mAddIOCellActionListener = new ActionListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath treePath = IOViewDlg.this.ioViewTree.getSelectionPath();
            int index = 0;
            IOViewBlock parentBlock = null;
            Device d = null;
            DeviceNode parent = null;
            if (!treePath.getLastPathComponent().getClass().equals(DeviceNode.class)) {
                return;
            }
            DeviceNode dn = (DeviceNode)((Object)treePath.getLastPathComponent());
            d = dn.dblock.devicePath.getLast();
            int side = dn.dblock.side;
            ArrayList<DeviceNode> children = dn.childDevices;
            index = children.size();
            parentBlock = dn.dblock;
            parent = dn;
            String uniqueName = "New";
            uniqueName = Device.getUniqueName((DeviceTemplate)parentBlock.devicePath.getLast().getTemplate(), (String)uniqueName);
            IOViewBlock block = new IOViewBlock(uniqueName);
            block.setSide(side);
            DevicePath path = new DevicePath(IOViewDlg.this.dieDevice);
            path.add(d);
            block.devicePath = path;
            block.parent = parent.dblock;
            IOViewEditBlockDlg dlg = IOViewEditBlockDlg.createDialog((Window)((Object)IOViewDlg.this), IOViewDlg.this.mDb, block, true);
            dlg.setVisible(true);
            if (dlg.getAccepted()) {
                IOViewBlock.setWorkingBlock(null, block);
                try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)IOViewDlg.this.mDb, (String)"Add IOCell to Interface");){
                    IOViewBlock parentBlock_ = parentBlock;
                    int index_ = index;
                    Cp.exec(() -> IOViewDlg.makeDeviceOnInterface(IOViewBlock.getWorkingBlock(), parentBlock_.getDevicePath().toString(), index_), (String)"IOViewDlg.makeDeviceOnInterface (IOViewBlock.getWorkingBlock (), \"%s\", %d);", (Object[])new Object[]{parentBlock.getDevicePath().toString(), index});
                    IOViewDlg.this.ioViewTree.expandPath(treePath);
                    IOViewDlg.this.lastEditedRow = IOViewDlg.this.ioViewTree.getRowForPath(treePath);
                    IOViewDlg.this.focusBlock = block;
                }
                finally {
                    Cp.exec(IOView::somethingChanged, (String)"com.sigrity.orbit.iov.IOView.somethingChanged();", (Object[])new Object[0]);
                    OrbitIO.getApp().refreshCurrentView(false);
                }
            }
            UIUtil.closeWindow((Window)((Object)dlg));
        }
    };
    protected ActionListener mCloneInterface = new ActionListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath treePath = IOViewDlg.this.ioViewTree.getSelectionPath();
            DeviceNode dn = (DeviceNode)((Object)treePath.getLastPathComponent());
            IOViewCloneDlg dlg = IOViewCloneDlg.createDialog((Window)((Object)IOViewDlg.this), dn.dblock);
            dlg.setVisible(true);
            if (dlg.getAccepted()) {
                String marker = "Clone Interface " + dn.dblock.devicePath.toString() + " " + dlg.getCopies() + " times";
                int copies = dlg.getCopies();
                try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)IOViewDlg.this.mDb, (String)marker);){
                    Cp.exec(() -> IOView.cloneInterface(dn.dblock.devicePath.toString(), copies), (String)"IOView.cloneInterface (\"%s\", %d);", (Object[])new Object[]{dn.dblock.devicePath.toString(), copies});
                    Cp.exec(IOView::somethingChanged, (String)"com.sigrity.orbit.iov.IOView.somethingChanged();", (Object[])new Object[0]);
                }
                finally {
                    OrbitIO.getApp().refreshCurrentView(false);
                }
            }
        }
    };
    protected ActionListener mMirrorInterface = new ActionListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath treePath = IOViewDlg.this.ioViewTree.getSelectionPath();
            DeviceNode dn = (DeviceNode)((Object)treePath.getLastPathComponent());
            try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)IOViewDlg.this.mDb, (String)"Mirror Interface");){
                Cp.exec(() -> IOView.mirrorInterface(dn.dblock.devicePath.toString()), (String)"IOView.mirrorInterface (\"%s\");", (Object[])new Object[]{dn.dblock.devicePath.toString()});
                Cp.exec(IOView::somethingChanged, (String)"com.sigrity.orbit.iov.IOView.somethingChanged();", (Object[])new Object[0]);
            }
            finally {
                OrbitIO.getApp().refreshCurrentView(false);
            }
        }
    };
    protected ActionListener mUnDecorateListener = new ActionListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath treePath = IOViewDlg.this.ioViewTree.getSelectionPath();
            DeviceNode dn = (DeviceNode)((Object)treePath.getLastPathComponent());
            try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)IOViewDlg.this.mDb, (String)"Undecorate Interface");){
                String myName = "";
                Cp.exec(() -> IOView.unDecorate(dn.dblock.devicePath.toString(), myName), (String)"IOView.unDecorate (\"%s\", \"%s\");", (Object[])new Object[]{dn.dblock.devicePath.toString(), myName});
                Cp.exec(IOView::somethingChanged, (String)"com.sigrity.orbit.iov.IOView.somethingChanged();", (Object[])new Object[0]);
            }
            finally {
                OrbitIO.getApp().refreshCurrentView(false);
            }
        }
    };
    protected ActionListener mCreateNewRatioDriven = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            BumpFactoryData bfd;
            DevicePath theInterface;
            TreePath treePath = IOViewDlg.this.ioViewTree.getSelectionPath();
            DeviceNode dn = (DeviceNode)((Object)treePath.getLastPathComponent());
            IOViewDlg.externalAddState.acceptingInterface = theInterface = dn.dblock.devicePath;
            Db db = OrbitIO.getCurDb();
            BumpFactoryData abfd = null;
            for (Object bfdi : db.getObjects(BumpFactoryData.class)) {
                if (!bfdi.getFactoryType().equals((Object)BumpFactoryData.BumpFactoryType.RATIO_DRIVEN) || bfdi.getBumpTemplate() == null || !bfdi.getBumpTemplate().getSubstrate().equals((Object)theInterface.getSubstrate())) continue;
                abfd = bfdi;
                break;
            }
            if (abfd == null) {
                bfd = new BumpFactoryData();
                bfd.setFactoryType(BumpFactoryData.BumpFactoryType.RATIO_DRIVEN);
            } else {
                bfd = new BumpFactoryData();
                bfd.setFactoryType(BumpFactoryData.BumpFactoryType.RATIO_DRIVEN);
                bfd.setBumpBaseName(abfd.getBumpBaseName());
                bfd.setBumpTemplate(abfd.getBumpTemplate());
                bfd.setBumpNameIsScript(abfd.getBumpNameIsScript());
                bfd.setCornerKeepoutX(abfd.getCornerKeepoutX());
                bfd.setCornerKeepoutY(abfd.getCornerKeepoutY());
                bfd.setMinPitch(abfd.getMinPitch());
                bfd.setRatioInstructions(abfd.getRatioInstructions());
            }
            bfd.setWidth(theInterface.getLast().getTemplate().getExtent().width());
            bfd.setHeight(theInterface.getLast().getTemplate().getExtent().height());
            int numIO = 0;
            for (DevicePath candidate : theInterface.getChildren()) {
                Device c = candidate.getLast();
                DeviceTemplate dt = c.getTemplate();
                HashSet ioPorts = new HashSet(dt.getIOPorts());
                for (PinInstance pi : c.getPins()) {
                    PinTemplate thisPinTemplate = pi.getPinTemplate();
                    if (!ioPorts.contains(thisPinTemplate)) continue;
                    ++numIO;
                }
            }
            bfd.setNumIO(numIO);
            IOViewDlg.externalAddState.state = ExternalAddState.Waiting;
            PatternPlacementUI ui = PatternPlacementUI.create(OrbitIO.getMainWindow(), dn.dblock.devicePath.getLast().getTemplate());
            ui.load(bfd);
            ui.setVisible(true);
            Cp.exec(IOView::somethingChanged, (String)"com.sigrity.orbit.iov.IOView.somethingChanged();", (Object[])new Object[0]);
            OrbitIO.getApp().refreshCurrentView(false);
        }
    };
    protected ActionListener mManageRatioDriven = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            PatternPlacementUI ui;
            TreePath treePath = IOViewDlg.this.ioViewTree.getSelectionPath();
            DeviceNode dn = (DeviceNode)((Object)treePath.getLastPathComponent());
            Device d = dn.dblock.getDevicePath().getLast();
            BumpFactoryData abfd = null;
            for (BumpFactoryData bfdi : IOViewDlg.this.mDb.getObjects(BumpFactoryData.class)) {
                if (!bfdi.getFactoryType().equals((Object)BumpFactoryData.BumpFactoryType.RATIO_DRIVEN) || bfdi.getBumpTemplate() == null || !bfdi.getBumpTemplate().getSubstrate().equals((Object)d.getSubstrate())) continue;
                abfd = bfdi;
                break;
            }
            if ((ui = PatternPlacementUI.create(OrbitIO.getMainWindow(), d.getTemplate())) != null) {
                if (abfd != null) {
                    ui.load(abfd);
                }
                ui.setVisible(true);
            }
            Cp.exec(IOView::somethingChanged, (String)"com.sigrity.orbit.iov.IOView.somethingChanged();", (Object[])new Object[0]);
            OrbitIO.getApp().refreshCurrentView(false);
        }
    };
    protected ActionListener mMarkAsUndecorated = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath treePath = IOViewDlg.this.ioViewTree.getSelectionPath();
            DeviceNode dn = (DeviceNode)((Object)treePath.getLastPathComponent());
            String myName = "";
            Cp.exec(() -> IOView.markAsUndecorated(dn.dblock.devicePath.toString(), myName), (String)"IOView.markAsUndecorated (\"%s\", \"%s\");", (Object[])new Object[]{dn.dblock.devicePath.toString(), myName});
            Cp.exec(IOView::somethingChanged, (String)"com.sigrity.orbit.iov.IOView.somethingChanged();", (Object[])new Object[0]);
            OrbitIO.getApp().refreshCurrentView(false);
        }
    };
    protected ActionListener mAddPersonalityToSide = new ActionListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath treePath = IOViewDlg.this.ioViewTree.getSelectionPath();
            if (treePath == null) {
                return;
            }
            IOViewDlg.this.lastEditedRow = IOViewDlg.this.ioViewTree.getRowForPath(treePath);
            if (treePath.getLastPathComponent().getClass().equals(SideNode.class)) {
                SideNode sn = (SideNode)((Object)treePath.getLastPathComponent());
                int side = sn.getSide();
                IOViewBlock block = new IOViewBlock("New Interface");
                block.setSide(side);
                block.parent = null;
                block.devicePath = new DevicePath(IOViewDlg.this.dieDevice);
                block.gap = 0L;
                block.inset = 0L;
                block.hard = false;
                block.ignoreGrid = false;
                List<String> otherIntfNames = IOViewDlg.this.mIOView.getNamesOfInterfacesAtSameLevel(block);
                IOViewCreatePersonalityDlg dlg = IOViewCreatePersonalityDlg.createDialog((Window)((Object)IOViewDlg.this), block, false, otherIntfNames);
                dlg.setVisible(true);
                if (dlg.getAccepted()) {
                    try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)IOViewDlg.this.mDb, (String)"Add Interface");){
                        IOViewBlock.setWorkingBlock(null, block);
                        IOViewBlock block_ = block = IOViewBlock.workingBlock;
                        Cp.exec(() -> IOViewBlock.getWorkingBlock().createDevicePersonality(block_.getDesiredName()), (String)"IOViewBlock.getWorkingBlock().createDevicePersonality (\"%s\")", (Object[])new Object[]{block.getDesiredName()});
                        Cp.exec(() -> IOView.addBlockToSide(IOViewBlock.getWorkingBlock(), block_.side, -1), (String)"IOView.addBlockToSide (IOViewBlock.getWorkingBlock (), %d, -1)", (Object[])new Object[]{block.side});
                        Cp.exec(() -> IOView.buildCanvasFromIOView(-1), (String)"IOView.buildCanvasFromIOView(%d);", (Object[])new Object[]{-1});
                        Cp.exec(IOView::somethingChanged, (String)"com.sigrity.orbit.iov.IOView.somethingChanged();", (Object[])new Object[0]);
                    }
                    finally {
                        OrbitIO.getApp().refreshCurrentView(false);
                    }
                }
                UIUtil.closeWindow((Window)((Object)dlg));
            }
        }
    };
    protected ActionListener mOpenCSV = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            String csvFile = IOViewDlg.this.dieDevice.getTemplate().getSourceFile();
            if (csvFile != null && !csvFile.isEmpty()) {
                UIUtil.openLocalEditor((String)"EditorCSV", (String)csvFile);
            }
        }
    };
    protected ActionListener mSaveActionListener = e -> ExportIOCSVDlg.showMe();
    protected ActionListener mReplacePTiles = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            AFileChooser fc = new AFileChooser();
            AFileFilter filter = new AFileFilter("xml", "ptile files");
            fc.setFileFilter((FileFilter)filter);
            if (fc.showOpenDialog((Component)OrbitIO.getMainWindow()) != 0) {
                return;
            }
            File f = fc.getSelectedFile();
            Object path = f.getPath();
            if (fc.getFileFilter() == filter && !f.getName().contains(".")) {
                path = (String)path + ".xml";
            }
            try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)IOViewDlg.this.mDb, (String)"Replace PTiles");){
                Object path_ = path;
                Cp.exec(() -> this.lambda$actionPerformed$0((String)path_), (String)"com.sigrity.orbit.iov.PtilesMgmt.replacePTilesXML(%s, \"%s\");", (Object[])new Object[]{Cp.getFileAsArgument((String)path), IOViewDlg.this.dieDevice.getSubstrate().getName()});
                IOViewDlg.this.mIOTreePopupMenuForPersonality = new PersonalityPopupMenu();
            }
        }

        private /* synthetic */ void lambda$actionPerformed$0(String path_) {
            PtilesMgmt.replacePTilesXML(path_, IOViewDlg.this.dieDevice.getSubstrate().getName());
        }
    };
    protected ActionListener mReReadPtilesFile = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)IOViewDlg.this.mDb, (String)"ReImport PTiles");){
                Cp.exec(() -> PtilesMgmt.reImportPTilesXML(IOViewDlg.this.dieDevice.getSubstrate().getName()), (String)"com.sigrity.orbit.iov.PtilesMgmt.reImportPTilesXML (\"%s\");", (Object[])new Object[]{IOViewDlg.this.dieDevice.getSubstrate().getName()});
                IOViewDlg.this.mIOTreePopupMenuForPersonality = new PersonalityPopupMenu();
            }
        }
    };
    protected ActionListener mExportPinDefinitions = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            AFileChooser fc = new AFileChooser();
            AFileFilter filter = new AFileFilter("xml", "pin definintion");
            fc.setFileFilter((FileFilter)filter);
            if (fc.showSaveDialog((Component)OrbitIO.getMainWindow()) != 0) {
                return;
            }
            File f = fc.getSelectedFile();
            Object path = f.getPath();
            if (fc.getFileFilter() == filter && !f.getName().contains(".")) {
                path = (String)path + ".xml";
            }
            String path_ = path;
            Cp.exec(() -> PinDefinition.writeXML(path_), (String)"com.sigrity.orbit.iov.PinDefinition.writeXML(%s)", (Object[])new Object[]{Cp.getFileAsArgument((String)path)});
        }
    };
    protected ActionListener mImportPinDefinitions = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            AFileChooser fc = new AFileChooser();
            AFileFilter filter = new AFileFilter("xml", "pin definitions");
            fc.setFileFilter((FileFilter)filter);
            if (fc.showOpenDialog((Component)OrbitIO.getMainWindow()) != 0) {
                return;
            }
            File f = fc.getSelectedFile();
            Object path = f.getPath();
            if (fc.getFileFilter() == filter && !f.getName().contains(".")) {
                path = (String)path + ".xml";
            }
            String path_ = path;
            try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)IOViewDlg.this.mDb, (String)"Import Pin Definitions");){
                Cp.exec(() -> PinDefinition.readXML(path_), (String)"com.sigrity.orbit.iov.PinDefinition.readXML(%s);", (Object[])new Object[]{Cp.getFileAsArgument((String)path)});
            }
        }
    };
    protected ActionListener mReplaceActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            DevicePath diePath = IOViewDlg.this.dieDevice.getADevicePath();
            String path = ImportIOCSVDlg.showMe(diePath);
            if (path != null) {
                try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)IOViewDlg.this.mDb, (String)"Replace IOView with csv");){
                    IOViewDlg.this.clearTree();
                    Cp.exec(() -> DeviceTemplateUI.deleteIODevices(diePath.toString(), false, false), (String)"com.sigrity.orbit.ui.DeviceTemplateUI.deleteIODevices(\"%s\", false, false);", (Object[])new Object[]{diePath.toString()});
                    Cp.exec(() -> {
                        IOViewSerializer ios = new IOViewSerializer();
                        ios.importCSV(diePath.toString(), path);
                    }, (String)"com.sigrity.orbit.iov.IOViewSerializer ios = new com.sigrity.orbit.iov.IOViewSerializer ()", (Object[])new Object[0]);
                    Cp.exec((String)"ios.importCSV (\"%s\", \"%s\");", (Object[])new Object[]{diePath.toString(), path});
                    IOView.buildIOViewFromCanvasUser();
                    IOViewDlg.this.expandHierLevels();
                }
            }
        }
    };
    protected ActionListener mReplaceSideActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath treePath = IOViewDlg.this.ioViewTree.getSelectionPath();
            if (treePath.getLastPathComponent().getClass().equals(SideNode.class)) {
                SideNode sn = (SideNode)((Object)treePath.getLastPathComponent());
                Cp.exec(() -> IOView.buildCanvasFromIOView(sn.getSide()), (String)"com.sigrity.orbit.iov.IOView.buildCanvasFromIOView(%d);", (Object[])new Object[]{sn.getSide()});
                OrbitIO.getApp().refreshCurrentView(false);
            }
        }
    };
    protected ActionListener mCreateLogicalCore = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            DevicePath dPath = IOViewDlg.this.dieDevice.getADevicePath();
            Cp.exec((String)"com.sigrity.orbit.factory.CoreFactory cf = new com.sigrity.orbit.factory.CoreFactory(\"%s\");", (Object[])new Object[]{dPath.toString()});
            Cp.exec((String)"cf.makeCore();", (Object[])new Object[0]);
        }
    };
    protected ActionListener mEditDieSizeActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            DevicePath dPath = IOViewDlg.this.dieDevice.getADevicePath();
            if (dPath != null) {
                EditDeviceBoundsMode.create(OrbitIO.getMainWindow(), dPath);
            }
        }
    };
    protected ActionListener mDRCBumpsActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            DevicePath dPath = IOViewDlg.this.dieDevice.getADevicePath();
            BumpDRCDlg.create(OrbitIO.getMainWindow(), OrbitIO.getCurView(), dPath);
        }
    };
    protected ActionListener mGenerateDefaultNetNames = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            DevicePath dPath = IOViewDlg.this.dieDevice.getADevicePath();
            Cp.exec((String)"createDefaultNets(\"%s\")", (Object[])new Object[]{dPath.toString()});
        }
    };
    protected ActionListener mGenerateDefaultNetNamesOnIOPads = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            DevicePath dPath = IOViewDlg.this.dieDevice.getADevicePath();
            Cp.exec((String)"createDefaultNets(\"%s\", true)", (Object[])new Object[]{dPath.toString()});
        }
    };
    protected ActionListener mConnectBumpsToIOPads = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath treePath = IOViewDlg.this.ioViewTree.getSelectionPath();
            DeviceNode dn = (DeviceNode)((Object)treePath.getLastPathComponent());
            DevicePath dPath = dn.dblock.devicePath.getLast().getADevicePath();
            Cp.exec(() -> IOConnectionUtil.mapIOPinsToCoverCell(OrbitIO.getCurDb(), dPath.toString()), (String)"com.sigrity.orbit.iov.IOConnectionUtil.mapIOPinsToCoverCell(curDb(), \"%s\")", (Object[])new Object[]{dPath.toString()});
            OrbitIO.getApp().refreshCurrentView(false);
        }
    };
    protected ActionListener mReschedule = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath treePath = IOViewDlg.this.ioViewTree.getSelectionPath();
            DeviceNode dn = (DeviceNode)((Object)treePath.getLastPathComponent());
            DevicePath dPath = dn.dblock.devicePath.getLast().getADevicePath();
            IOViewConnectionFactory cf = new IOViewConnectionFactory();
            cf.setOutsideSubstrate(IOView.theIOView.getHideOutsideSubstrate());
            cf.addInterface(dPath);
            cf.go();
            OrbitIO.getApp().refreshCurrentView(false);
        }
    };
    protected ActionListener mGenerateUniqueDeviceNames = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            DevicePath dPath = new DevicePath(IOViewDlg.this.dieDevice);
            Cp.exec(() -> IOView.createUniqueDeviceNames(dPath.toString()), (String)"com.sigrity.orbit.iov.IOView.createUniqueDeviceNames(\"%s\")", (Object[])new Object[]{dPath.toString()});
            OrbitIO.getApp().refreshCurrentView(false);
        }
    };
    protected ActionListener mImportVerilog = e -> VerilogUI.showDialog(OrbitIO.getMainWindow(), this.getDb());
    protected ActionListener mExportDieTextFile = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            DevicePath diePath = IOViewDlg.this.dieDevice.getADevicePath();
            BgaDieTxtIO.showExportUI(OrbitIO.getCurDb(), diePath.toString());
        }
    };
    protected ActionListener mIOPreferences = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            IOViewOptionsDlg dlg = IOViewOptionsDlg.createDialog((Window)((Object)IOViewDlg.this), IOView.theIOView);
            dlg.setVisible(true);
            IOViewDlg.this.refreshTree();
            IOViewDlg.this.setMinimumSize(IOViewDlg.this.getPreferredSize());
        }
    };
    protected ActionListener mUndecorateAll = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Cp.exec(() -> IOView.changeDecorationAll(false), (String)"com.sigrity.orbit.iov.IOView.changeDecorationAll(false);", (Object[])new Object[0]);
            Cp.exec(IOView::somethingChanged, (String)"com.sigrity.orbit.iov.IOView.somethingChanged();", (Object[])new Object[0]);
            OrbitIO.getApp().refreshCurrentView(false);
        }
    };
    protected Action gotoTop = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath retPath = IOViewDlg.this.getPathOfSide(1);
            IOViewDlg.this.showMe(retPath);
        }
    };
    protected Action gotoBot = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath retPath = IOViewDlg.this.getPathOfSide(3);
            IOViewDlg.this.showMe(retPath);
        }
    };
    protected Action gotoLeft = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath retPath = IOViewDlg.this.getPathOfSide(2);
            IOViewDlg.this.showMe(retPath);
        }
    };
    protected Action gotoRight = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath retPath = IOViewDlg.this.getPathOfSide(0);
            IOViewDlg.this.showMe(retPath);
        }
    };
    protected Action collapseAll = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            IOViewDlg.this.setExpansion(IOViewDlg.this.ioViewTree, 3);
        }
    };
    protected Action focusFind = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            IOViewDlg.this.findField.requestFocus();
        }
    };
    protected ActionListener mDecorateAll = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Cp.exec(() -> IOView.changeDecorationAll(true), (String)"com.sigrity.orbit.iov.IOView.changeDecorationAll(true);", (Object[])new Object[0]);
            if (IOView.theIOView.getAutoSize()) {
                Cp.exec(IOView::padLimitDie, (String)"com.sigrity.orbit.iov.IOView.padLimitDie();", (Object[])new Object[0]);
            }
            Cp.exec(IOView::somethingChanged, (String)"com.sigrity.orbit.iov.IOView.somethingChanged();", (Object[])new Object[0]);
            OrbitIO.getApp().refreshCurrentView(false);
        }
    };
    protected ActionListener mApproveAll = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Cp.exec(IOView::approveAll, (String)"com.sigrity.orbit.iov.IOView.approveAll();", (Object[])new Object[0]);
            Cp.exec(IOView::somethingChanged, (String)"com.sigrity.orbit.iov.IOView.somethingChanged();", (Object[])new Object[0]);
            OrbitIO.getApp().refreshCurrentView(false);
        }
    };
    protected ActionListener mAvoidOverlap = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Cp.exec(IOView::avoidCornerOverlaps, (String)"com.sigrity.orbit.iov.IOView.avoidCornerOverlaps ();", (Object[])new Object[0]);
            Cp.exec(IOView::somethingChanged, (String)"com.sigrity.orbit.iov.IOView.somethingChanged();", (Object[])new Object[0]);
            OrbitIO.getApp().refreshCurrentView(false);
        }
    };
    protected ActionListener mResizeDieToPadLimitedSize = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (IOView.theIOView.getAvoidOverlap()) {
                Cp.exec(IOView::searchForMinumumDieSizeExhaustive, (String)"com.sigrity.orbit.iov.IOView.searchForMinumumDieSizeExhaustive ();", (Object[])new Object[0]);
            } else {
                Cp.exec(IOView::padLimitDie, (String)"com.sigrity.orbit.iov.IOView.padLimitDie ();", (Object[])new Object[0]);
            }
            Cp.exec(IOView::somethingChanged, (String)"com.sigrity.orbit.iov.IOView.somethingChanged();", (Object[])new Object[0]);
            OrbitIO.getApp().refreshCurrentView(false);
        }
    };
    protected ActionListener mResizeDieToGapsAndInsets = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Cp.exec(IOView::resizeToFitGapsAndInsets, (String)"com.sigrity.orbit.iov.IOView.resizeToFitGapsAndInsets ();", (Object[])new Object[0]);
            Cp.exec(IOView::somethingChanged, (String)"com.sigrity.orbit.iov.IOView.somethingChanged();", (Object[])new Object[0]);
            OrbitIO.getApp().refreshCurrentView(false);
        }
    };
    protected ActionListener mExportVerilog = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            DevicePath dPath = new DevicePath(IOViewDlg.this.dieDevice);
            dPath = dPath.getLast().getADevicePath();
            ExportVerilogUI2.show(OrbitIO.getMainWindow(), dPath);
        }
    };
    protected ActionListener mReplaceAllSidesActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath treePath = IOViewDlg.this.ioViewTree.getSelectionPath();
            if (treePath.getLastPathComponent().getClass().equals(RootNode.class)) {
                Cp.exec(() -> IOView.buildCanvasFromIOView(-1), (String)"com.sigrity.orbit.iov.IOView.buildCanvasFromIOView(-1);", (Object[])new Object[0]);
                OrbitIO.getApp().refreshCurrentView(false);
            }
        }
    };
    protected ActionListener mRemoveAllInterfaceGaps = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath treePath = IOViewDlg.this.ioViewTree.getSelectionPath();
            if (treePath.getLastPathComponent().getClass().equals(RootNode.class)) {
                Cp.exec(IOView::removeAllGaps, (String)"com.sigrity.orbit.iov.IOView.removeAllGaps();", (Object[])new Object[0]);
                OrbitIO.getApp().refreshCurrentView(false);
            }
        }
    };
    protected ActionListener mForceToGrid = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath treePath = IOViewDlg.this.ioViewTree.getSelectionPath();
            if (treePath.getLastPathComponent().getClass().equals(RootNode.class)) {
                Cp.exec(IOView::forceToGrid, (String)"com.sigrity.orbit.iov.IOView.forceToGrid();", (Object[])new Object[0]);
                OrbitIO.getApp().refreshCurrentView(false);
            }
        }
    };
    protected ActionListener mBuildIOViewActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath treePath = IOViewDlg.this.ioViewTree.getSelectionPath();
            if (treePath.getLastPathComponent().getClass().equals(RootNode.class)) {
                Cp.exec(IOView::buildIOViewFromCanvasUser, (String)"com.sigrity.orbit.iov.IOView.buildIOViewFromCanvasUser();", (Object[])new Object[0]);
                OrbitIO.getApp().refreshCurrentView(false);
                IOViewDlg.this.refreshTree();
            }
        }
    };
    protected ActionListener mShowMeActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath treePath = IOViewDlg.this.ioViewTree.getSelectionPath();
            if (treePath.getLastPathComponent().getClass().equals(DeviceNode.class)) {
                DeviceNode dn = (DeviceNode)((Object)treePath.getLastPathComponent());
                DevicePath p = dn.dblock.devicePath.getLast().getADevicePath();
                ShowMeTheWay.addDevicePath(p);
            }
        }
    };
    protected ActionListener mDeleteIOCellActionListener = new ActionListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath treePath = IOViewDlg.this.ioViewTree.getSelectionPath();
            if (treePath.getLastPathComponent().getClass().equals(DeviceNode.class)) {
                DeviceNode dn = (DeviceNode)((Object)treePath.getLastPathComponent());
                IOViewBlock child = dn.dblock;
                IOViewBlock parent = child.parent;
                try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)IOViewDlg.this.mDb, (String)("Delete Cell " + child.devicePath.toString()));){
                    Cp.exec(() -> IOView.removeBlockFromParent(child.devicePath.toString(), parent.devicePath.toString()), (String)"com.sigrity.orbit.iov.IOView.removeBlockFromParent (\"%s\", \"%s\")", (Object[])new Object[]{child.devicePath.toString(), parent.devicePath.toString()});
                    Cp.exec(IOView::buldCanvasAndIOView, (String)"com.sigrity.orbit.iov.IOView.buldCanvasAndIOView ()", (Object[])new Object[0]);
                }
                finally {
                    IOViewDlg.this.refreshTree();
                    OrbitIO.getApp().refreshCurrentView(false);
                }
            }
        }
    };
    protected ActionListener mImportTemplates = e -> {};
    protected ActionListener mRefreshActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath treePath = IOViewDlg.this.ioViewTree.getSelectionPath();
            if (treePath.getLastPathComponent().getClass().equals(RootNode.class)) {
                IOViewDlg.this.refreshTree();
            }
        }
    };
    PersonalityPopupMenu mIOTreePopupMenuForPersonality = new PersonalityPopupMenu();
    JPopupMenu mIOTreePopupMenuForRoot = new JPopupMenu(){
        {
            this.add("Save IOView to .csv", IOViewDlg.this.mSaveActionListener);
            this.add("Replace IOView with .csv", IOViewDlg.this.mReplaceActionListener);
            String csvFile = lastDevicePath.getLast().getTemplate().getSourceFile();
            if (csvFile != null && !csvFile.isEmpty()) {
                this.add("Edit IOView .csv", IOViewDlg.this.mOpenCSV, csvFile);
            }
            this.addSeparator();
            this.add("IOView Preferences", IOViewDlg.this.mIOPreferences, null, DBEResources.ICON_COG_EDIT);
            this.addSeparator();
            this.add("Import new Programable Tile Definitions", IOViewDlg.this.mReplacePTiles);
            this.add("Re-Import Current Programable Tile Definitions", IOViewDlg.this.mReReadPtilesFile);
            this.addSeparator();
            this.add("Export Current Pin Definitions", IOViewDlg.this.mExportPinDefinitions);
            this.add("Import Current Pin Definitions", IOViewDlg.this.mImportPinDefinitions);
            this.addSeparator();
            IOViewDlg.this.makeLogicalCoreMenuItem = this.add("Create Logical Core", IOViewDlg.this.mCreateLogicalCore, null, null);
            this.add("Edit Die Size", IOViewDlg.this.mEditDieSizeActionListener);
            this.add("DRC Bumps", IOViewDlg.this.mDRCBumpsActionListener);
            this.add("Generate Default Net Names", IOViewDlg.this.mGenerateDefaultNetNames);
            this.add("Generate Default Net Names (Only IOPADS)", IOViewDlg.this.mGenerateDefaultNetNamesOnIOPads);
            this.addSeparator();
            this.add("Undecorate all Interfaces", IOViewDlg.this.mUndecorateAll);
            this.add("Decorate all Interfaces", IOViewDlg.this.mDecorateAll);
            this.add("Approve all Interfaces", IOViewDlg.this.mApproveAll);
            this.addSeparator();
            this.add("Resize Die to Pad Limited Size", IOViewDlg.this.mResizeDieToPadLimitedSize);
            this.add("Resize Die to Gaps and Insets", IOViewDlg.this.mResizeDieToGapsAndInsets);
            this.add("Adjust Corner Interfaces to Avoid Overlap", IOViewDlg.this.mAvoidOverlap);
            this.addSeparator();
            this.add("Export Verilog", IOViewDlg.this.mExportVerilog);
            this.add("Import Verilog", IOViewDlg.this.mImportVerilog);
            this.addSeparator();
            this.add("Export Bumps to Die Text File", IOViewDlg.this.mExportDieTextFile);
            this.addSeparator();
            this.add("Remove All Gaps and Insets from Interfaces", IOViewDlg.this.mRemoveAllInterfaceGaps);
            this.add("Force Adjust to Grid", IOViewDlg.this.mForceToGrid);
            this.addSeparator();
            this.add("Build Canvas From IOView", IOViewDlg.this.mReplaceAllSidesActionListener);
            this.add("Build IOView from Canvas", IOViewDlg.this.mBuildIOViewActionListener);
            this.add("Refresh Tree", IOViewDlg.this.mRefreshActionListener);
            this.addSeparator();
            this.add("Import directory of templates", new ImportDirectory(), "read all .oios in a directory ", null);
            JMenu decorate = new JMenu("Decorate Die With");
            this.add(decorate);
            for (IOViewDieDecorator cvd : IOViewDieDecoratorRegistry.getDecorators()) {
                JMenuItem p1 = new JMenuItem(cvd.name());
                p1.setToolTipText(cvd.toolTip());
                p1.addActionListener(new DoDieDecorationCommand(cvd));
                decorate.add(p1);
            }
        }

        protected void add(String text, ActionListener listener) {
            this.add(text, listener, null, null);
        }

        protected void add(String text, ActionListener listener, String toolTip) {
            this.add(text, listener, toolTip, null);
        }

        protected JMenuItem add(String text, ActionListener listener, String toolTip, Icon icon) {
            JMenuItem jmi = this.add(new JMenuItem(text));
            jmi.addActionListener(listener);
            if (toolTip != null) {
                jmi.setToolTipText(toolTip);
            }
            if (icon != null) {
                jmi.setIcon(icon);
            }
            return jmi;
        }
    };
    JPopupMenu mIOTreePopupMenuForSide = new JPopupMenu(){
        protected Action mAddPersonalityAction;
        String menuString = "Add Interface to Side";
        protected Action paste;
        {
            this.mAddPersonalityAction = this.add(this.menuString, IOViewDlg.this.mAddPersonalityToSide);
            this.paste = this.add("Paste", IOViewDlg.this.mPasteSelectedActionListener);
        }

        protected Action add(String text, final ActionListener listener) {
            AbstractAction a = new AbstractAction(text){
                protected ActionListener mListener;
                {
                    super(arg0);
                    this.mListener = listener;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.mListener.actionPerformed(e);
                }
            };
            this.add(a);
            return a;
        }

        @Override
        public void show(Component invoker, int x, int y) {
            this.prepare(x, y);
            super.show(invoker, x, y);
        }

        protected void prepare(int x, int y) {
            TreePath treePath = IOViewDlg.this.ioViewTree.getSelectionPath();
            if (treePath == null) {
                return;
            }
            this.mAddPersonalityAction.setEnabled(true);
            if (!IOView.theIOView.getCPBuffer().isEmpty()) {
                this.paste.setEnabled(true);
            } else {
                this.paste.setEnabled(false);
            }
        }
    };
    JPopupMenu mIOTreePopupMenuForMultiple = new JPopupMenu(){
        protected Action mDeleteSelected;
        protected Action mCutSelected;
        protected Action mGroupSelected;
        protected Action mRescheduleSelected;
        {
            this.mDeleteSelected = this.add("Delete Selected", IOViewDlg.this.mDeleteSelectedActionListener);
            this.mCutSelected = this.add("Cut Selected", IOViewDlg.this.mCutSelectedActionListener);
            this.mGroupSelected = this.add("Group Selected", IOViewDlg.this.mGroupSelectedActionListener);
            this.mRescheduleSelected = this.add("Show Connections on Selected", IOViewDlg.this.mRescheduleSelectedActionListener);
        }

        protected Action add(String text, final ActionListener listener) {
            AbstractAction a = new AbstractAction(text){
                protected ActionListener mListener;
                {
                    super(arg0);
                    this.mListener = listener;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.mListener.actionPerformed(e);
                }
            };
            this.add(a);
            return a;
        }

        @Override
        public void show(Component invoker, int x, int y) {
            this.prepare(x, y);
            super.show(invoker, x, y);
        }

        protected void prepare(int x, int y) {
            this.mDeleteSelected.setEnabled(true);
            this.mCutSelected.setEnabled(true);
            this.mGroupSelected.setEnabled(true);
            this.mRescheduleSelected.setEnabled(true);
            TreePath[] treePaths = IOViewDlg.this.ioViewTree.getSelectionPaths();
            if (treePaths == null) {
                return;
            }
            if (treePaths.length < 2) {
                return;
            }
            for (TreePath tp : treePaths) {
                if (tp.getLastPathComponent().getClass().equals(DeviceNode.class)) {
                    DeviceNode fromNode = (DeviceNode)((Object)tp.getLastPathComponent());
                    IOViewBlock from = fromNode.dblock;
                    if (from.devicePath.getLast().getIsFixed()) {
                        this.mDeleteSelected.setEnabled(false);
                        this.mCutSelected.setEnabled(false);
                    }
                    if (from.isInterface()) {
                        this.mCutSelected.setEnabled(false);
                        continue;
                    }
                    this.mGroupSelected.setEnabled(false);
                    continue;
                }
                this.mDeleteSelected.setEnabled(false);
                this.mCutSelected.setEnabled(false);
                this.mGroupSelected.setEnabled(false);
                return;
            }
        }
    };
    JPopupMenu mIOTreePopupMenuForIOCell = new JPopupMenu(){
        protected Action mShowMeAction;
        protected Action mEditMeAction;
        protected Action mPasteAction;
        protected Action mEditRatioDriven;
        protected Action mCloneIOCellAction;
        {
            this.mEditMeAction = this.add("Edit", IOViewDlg.this.mEditCell);
            this.addSeparator();
            this.mCloneIOCellAction = this.add("Clone IO Cell", IOViewDlg.this.mCloneIOCellActionListner);
            this.addSeparator();
            this.mShowMeAction = this.add("Show Me", IOViewDlg.this.mShowMeActionListener);
            this.addSeparator();
            this.mShowMeAction = this.add("Delete", IOViewDlg.this.mDeleteIOCellActionListener);
            this.add("Cut", IOViewDlg.this.mCutSelectedActionListener);
            this.mPasteAction = this.add("Paste", IOViewDlg.this.mPasteSelectedActionListener);
            this.mEditRatioDriven = this.add("Edit Ratio Driven", IOViewDlg.this.mManageRatioDriven);
            this.add("Show Connections", IOViewDlg.this.mReschedule);
        }

        protected Action add(String text, final ActionListener listener) {
            AbstractAction a = new AbstractAction(text){
                protected ActionListener mListener;
                {
                    super(arg0);
                    this.mListener = listener;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.mListener.actionPerformed(e);
                }
            };
            this.add(a);
            return a;
        }

        @Override
        public void show(Component invoker, int x, int y) {
            this.prepare(x, y);
            super.show(invoker, x, y);
        }

        protected void prepare(int x, int y) {
            TreePath tp;
            TreePath[] treePaths = IOViewDlg.this.ioViewTree.getSelectionPaths();
            if (treePaths == null) {
                return;
            }
            this.mEditRatioDriven.setEnabled(false);
            if (treePaths.length == 1 && (tp = treePaths[0]).getLastPathComponent().getClass().equals(DeviceNode.class)) {
                DeviceNode fromNode = (DeviceNode)((Object)tp.getLastPathComponent());
                Device d = fromNode.dblock.devicePath.getLast();
                DeviceTemplate dt = d.getTemplate();
                for (BumpFactoryData bfdi : IOViewDlg.this.mDb.getObjects(BumpFactoryData.class)) {
                    if (!bfdi.getFactoryType().equals((Object)BumpFactoryData.BumpFactoryType.RATIO_DRIVEN) || bfdi.getBumpTemplate() == null || !bfdi.getTemplate().equals(dt)) continue;
                    this.mEditRatioDriven.setEnabled(true);
                    break;
                }
            }
            this.mShowMeAction.setEnabled(true);
            this.mEditMeAction.setEnabled(true);
            this.mCloneIOCellAction.setEnabled(true);
            this.mPasteAction.setEnabled(!IOView.theIOView.getCPBuffer().isEmpty());
        }
    };
    private final DataFlavor[] SupportedDataFlavors = new DataFlavor[]{DeviceBlockDataFlavor};

    protected static void synchToNewIOView(IOView ioview) {
        if (mLastDlg != null) {
            IOViewDlg.mLastDlg.mIOView = ioview;
            ioview.addListener(IOViewDlg.mLastDlg.mRefreshListener);
        }
    }

    public static IOViewDlg create(Window owner, AAppView view, String dPathString) {
        return IOViewDlg.create(owner, view, dPathString, false);
    }

    public static IOViewDlg create(Window owner, AAppView view, String dPathString, boolean fromCanvas) {
        IOViewDlg ioViewDlg;
        DevicePath dPath = DevicePath.fromString((Db)OrbitIO.getCurDb(), (String)dPathString);
        if (dPath == null) {
            ALog.logError((String)"%s is not a valid device path", (Object[])new Object[]{dPathString});
            return null;
        }
        if (IOView.theIOView != null && mLastDlg != null) {
            mLastDlg.removeNotify();
        }
        lastDevicePath = dPath;
        try {
            ioViewDlg = new IOViewDlg(view, owner, dPath, fromCanvas);
        }
        catch (LSession.NoLicenseException e) {
            return null;
        }
        catch (Exception e) {
            ALog.logError((Throwable)e, (String)"Error creating IOViewDlg.", (Object[])new Object[0]);
            Object ioViewDlg2 = null;
            if (IOView.theIOView != null) {
                IOView.shutDown();
            }
            return null;
        }
        ioViewDlg.setVisible(true);
        mLastDlg = ioViewDlg;
        return ioViewDlg;
    }

    protected IOViewDlg(AAppView view, Component owner, DevicePath dPath, boolean fromCanvas) throws LSession.NoLicenseException {
        super(view.getDb(), owner);
        try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)this.mDb, (String)"Initialize IOView");){
            Cp.exec((String)"import com.sigrity.orbit.iov.*;", (Object[])new Object[0]);
            this.dieDevice = dPath.getLast();
            this.mIOView = new IOView(dPath);
            this.mIOView.setFromCanvasByRotation(fromCanvas);
            IOView.buildIOViewFromCanvasUser();
            this.init();
            OrbitIO.getApp().refreshCurrentView(false);
        }
    }

    protected void init() {
        this.setTitle("IOView");
        Personality.resetColor();
        GridBagManager l = new GridBagManager(this.getContentPane());
        l.push("IO View", (GridBagConstraints)GridBagManager.FILLALL);
        l.pushFillX();
        l.add("Find: ");
        this.findField = (RegexFilterField)l.add((Component)new RegexFilterField(this.mFilterListener), (GridBagConstraints)GridBagManager.FILLX.noInsets());
        JButton nextResult = new JButton();
        nextResult.setIcon(OrbitIcons.SRCH_NEXT);
        nextResult.setMargin(new Insets(0, 0, 0, 0));
        nextResult.addActionListener(this.mNextResultAction);
        l.add((Component)nextResult);
        JButton prevResult = new JButton();
        prevResult.setIcon(OrbitIcons.SRCH_PREV);
        prevResult.setMargin(new Insets(0, 0, 0, 0));
        prevResult.addActionListener(this.mPrevResultAction);
        l.add((Component)prevResult);
        this.findResults = new JLabel("");
        l.add((Component)this.findResults);
        l.popNl();
        ATreeModel tm = new ATreeModel();
        this.ioViewTree = new IOViewTree(tm, this);
        RootNode rn = new RootNode(tm, this.mDb, new DevicePath(this.dieDevice));
        tm.setRoot((TreeNode)((Object)rn));
        this.ioViewTree.requestFocusInWindow();
        this.ioViewTree.setDragEnabled(true);
        this.ioViewTree.setTransferHandler(new MyTransferHandler(this.ioViewTree));
        this.ioViewTree.setDropMode(DropMode.ON);
        this.ioViewTree.getSelectionModel().setSelectionMode(4);
        this.ioViewTree.setPopupMenuHandler(this.mTreePopupMenuHandler);
        this.ioViewTree.setCellRenderer((TreeCellRenderer)((Object)new IOViewRenderer()));
        this.ioViewTree.setRootVisible(true);
        this.ioViewTree.setShowsRootHandles(true);
        this.ioViewTree.setUI(new IOViewTreeUI(this.ioViewTree));
        this.ioViewTree.setOpaque(false);
        this.ioViewTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                DesignView2D v2d;
                AAppView view = OrbitIO.getCurView();
                DesignView2D designView2D = v2d = view instanceof DesignView2D ? (DesignView2D)view : null;
                if (v2d == null) {
                    return;
                }
                DbObjectHighlighter.clear(v2d);
                TreePath[] paths = IOViewDlg.this.ioViewTree.getSelectionPaths();
                if (paths == null || paths.length == 0) {
                    return;
                }
                for (TreePath path : paths) {
                    Object item = path.getLastPathComponent();
                    if (item.getClass().equals(DeviceNode.class)) {
                        IOViewDlg.this.highlight(v2d, (DeviceNode)((Object)item));
                        continue;
                    }
                    if (!item.getClass().equals(SideNode.class)) continue;
                    SideNode sn = (SideNode)((Object)item);
                    for (DeviceNode dn : sn.myBlocks) {
                        IOViewDlg.this.highlight(v2d, dn);
                    }
                    IOViewDlg.this.highlightInterface(v2d, sn.s);
                }
            }
        });
        ToolTipManager.sharedInstance().registerComponent(this.ioViewTree);
        this.treeSearcher = new TreeSearcher(this.ioViewTree);
        this.sp = new JScrollPane(this.ioViewTree);
        l.add((Component)this.sp, (GridBagConstraints)GridBagManager.FILLALL);
        l.newline();
        l.pop();
        l.newline();
        l.newline();
        l.push((Container)new JPanel(), (GridBagConstraints)GridBagManager.RIGHT_REMAINX);
        HelpButton helpButton = new HelpButton("../OrbitIO_UserGuide.pdf");
        l.add((Component)helpButton, (GridBagConstraints)GridBagManager.LEFT);
        JButton btnClose = new JButton("Close");
        l.add((Component)btnClose, (GridBagConstraints)GridBagManager.RIGHT_REMAINX);
        l.pop();
        UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnClose, null);
        this.setExpansion(this.ioViewTree, 3);
        this.setMinimumSize(this.getPreferredSize());
        this.pack();
        UIUtil.center((Component)((Object)this));
        this.createKeyBindings();
        this.makeLogicalCoreMenuItem.setEnabled(CoreFactory.getCoreDevicePath(this.dieDevice.getADevicePath()) == null);
        DbClass.DbObjectEventType[] events = new DbClass.DbObjectEventType[]{DbClass.DbObjectEventType.CHANGED};
        Db db = OrbitIO.getCurDb();
        DbClass dbc = db.getDbClass(Device.class);
        if (dbc == null) {
            dbc = db.addDbClass(Device.class);
        }
        dbc.addObjectListener(this.mDbObjectsListener, events);
    }

    private void highlight(DesignView2D v2d, DeviceNode node) {
        DevicePath dp = node.dblock.devicePath;
        Device dbo = node.dblock.devicePath.getLast();
        DbObjectHighlighter.highlight(v2d, dp, (DbObject)dbo);
        ALog.logInfo((String)"Highlight DeviceNode:%s", (Object[])new Object[]{dp});
    }

    private void highlightInterface(DesignView2D v2d, Side side) {
        ARect r = this.dieDevice.getTemplate().getBB();
        DevicePath dp = this.mIOView.getRootDevicePath();
        if (side.equals((Object)Side.Top)) {
            DbObjectHighlighter.highlight(v2d, dp, (AGeom)r.topPart(10));
        } else if (side.equals((Object)Side.Left)) {
            DbObjectHighlighter.highlight(v2d, dp, (AGeom)r.leftPart(10));
        } else if (side.equals((Object)Side.Right)) {
            DbObjectHighlighter.highlight(v2d, dp, (AGeom)r.rightPart(10));
        } else if (side.equals((Object)Side.Bottom)) {
            DbObjectHighlighter.highlight(v2d, dp, (AGeom)r.botPart(10));
        }
        ALog.logInfo((String)"Highlight RootDevicePath:%s", (Object[])new Object[]{dp});
    }

    protected void createKeyBindings() {
        this.ioViewTree.getActionMap().put("TOP", this.gotoTop);
        this.bindKey("T", "TOP");
        this.ioViewTree.getActionMap().put("BOT", this.gotoBot);
        this.bindKey("B", "BOT");
        this.ioViewTree.getActionMap().put("LEFT", this.gotoLeft);
        this.bindKey("L", "LEFT");
        this.ioViewTree.getActionMap().put("RIGHT", this.gotoRight);
        this.bindKey("R", "RIGHT");
        this.ioViewTree.getActionMap().put("C1", this.collapseAll);
        this.bindKey("C", "C1");
        this.ioViewTree.getActionMap().put("FIND", this.focusFind);
        this.bindKey("control F", "FIND");
        this.ioViewTree.requestFocus();
    }

    public void bindKey(String key, String action) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(key);
        if (keyStroke == null) {
            ALog.logWarn((String)"Invalid key stroke '%s' specified while attempting to bind key stroketo action '%s'.", (Object[])new Object[]{key, action});
            return;
        }
        InputMap inputMap = this.ioViewTree.getInputMap(1);
        inputMap.put(keyStroke, action);
    }

    public void addNotify() {
        super.addNotify();
        if (this.mHL != null) {
            return;
        }
        DbHistory h = this.mDb.getHistory();
        this.mHL = new HistoryListener();
        h.addListener((DbHistory.Listener)this.mHL);
        this.mDTL = new TemplateListener();
        DbClass clazz = this.mDb.getDbClass(DeviceTemplate.class);
        clazz.addObjectListener(this.mDTL, DbClass.DbObjectEventType.getUpdated());
        this.mDL = new InstanceListener();
        DbClass clazz1 = this.mDb.getDbClass(Device.class);
        clazz1.addObjectListener(this.mDL, DbClass.DbObjectEventType.getUpdated());
        this.mRefreshListener = new IOViewListener();
        this.mIOView.addListener(this.mRefreshListener);
        TheUpdateListener = new RatioDrivenListener();
        ExternalDeviceUpdateListener.addListener(TheUpdateListener);
    }

    public void removeNotify() {
        Cp.exec(IOView::save, (String)"IOView.save();", (Object[])new Object[0]);
        mLastDlg = null;
        super.removeNotify();
        if (IOView.theIOView != null) {
            IOView.theIOView.removeListener(this.mRefreshListener);
        }
        IOView.shutDown();
        if (this.mDb != null) {
            DbClass clazz1;
            DbClass clazz;
            DbHistory h = this.mDb.getHistory();
            if (h != null) {
                h.removeListener((DbHistory.Listener)this.mHL);
            }
            if ((clazz = this.mDb.getDbClass(DeviceTemplate.class)) != null) {
                clazz.removeObjectListener(this.mDTL, DbClass.DbObjectEventType.getUpdated());
            }
            if ((clazz1 = this.mDb.getDbClass(Device.class)) != null) {
                clazz1.removeObjectListener(this.mDL, DbClass.DbObjectEventType.getUpdated());
                clazz1.removeObjectListener(this.mDbObjectsListener, new DbClass.DbObjectEventType[]{DbClass.DbObjectEventType.CHANGED});
            }
        }
        ExternalDeviceUpdateListener.removeListener(TheUpdateListener);
    }

    protected void buildIOViewBecauseOfUser() {
        Cp.exec(IOView::buildIOViewFromCanvasUser, (String)"com.sigrity.orbit.iov.IOView.buildIOViewFromCanvasUser();", (Object[])new Object[0]);
        this.refreshTree();
        this.pendingBuildingIOView = false;
    }

    protected void queueRebuildOfIOView() {
        if (this.pendingBuildingIOView) {
            return;
        }
        this.pendingBuildingIOView = true;
        EventQueue.invokeLater(() -> {
            if (this.mDb != null && !this.mDb.closed()) {
                this.buildIOViewBecauseOfUser();
                this.pendingBuildingIOView = false;
            }
        });
    }

    public void restoreExpansion(JTree tree) {
        if (IOView.theIOView == null) {
            this.refreshPending = false;
            return;
        }
        TreeModel tm = this.ioViewTree.getModel();
        RootNode rn = (RootNode)((Object)tm.getRoot());
        rn.invalidateChildren();
        this.restoreExpansion(tree, new TreePath((Object)rn));
        TreePath treePath = null;
        if (this.focusBlock != null && this.focusBlock.getDevicePath().getLast().getDb() != null) {
            treePath = this.findTreePath(this.focusBlock);
        }
        if (treePath != null) {
            this.ioViewTree.scrollPathToVisible(treePath);
        }
        this.refreshPending = false;
    }

    protected void restoreExpansion(JTree tree, TreePath tp) {
        TreeNode node = (TreeNode)tp.getLastPathComponent();
        if (node.getChildCount() > 0) {
            if (node.getClass().equals(DeviceNode.class)) {
                DeviceNode dn = (DeviceNode)((Object)node);
                if (!this.lastExpandedSet.contains(dn.dblock.devicePath.toString())) {
                    return;
                }
            }
            Enumeration<? extends TreeNode> e = node.children();
            while (e != null && e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = tp.pathByAddingChild(n);
                this.restoreExpansion(tree, path);
            }
            tree.expandPath(tp);
        } else {
            tree.collapsePath(tp);
        }
    }

    public void refreshTree() {
        if (this.refreshPending) {
            return;
        }
        this.refreshPending = true;
        this.treeSearcher.invalidate();
        this.saveCurrentExpansion();
        TreeModel tm = this.ioViewTree.getModel();
        RootNode rn = (RootNode)((Object)tm.getRoot());
        rn.invalidateChildren();
        EventQueue.invokeLater(() -> {
            if (this.mDb != null && !this.mDb.closed()) {
                this.restoreExpansion(this.ioViewTree);
            }
        });
    }

    protected void saveCurrentExpansion(JTree tree, TreePath tp) {
        Enumeration<TreePath> expanded = tree.getExpandedDescendants(tp);
        if (expanded != null) {
            if (tp.getLastPathComponent().getClass().equals(DeviceNode.class)) {
                DeviceNode dn = (DeviceNode)((Object)tp.getLastPathComponent());
                this.lastExpandedSet.add(dn.dblock.devicePath.toString());
            }
            for (TreePath p : AUtil.getIterable(expanded)) {
                this.saveCurrentExpansion(tree, p);
            }
        }
    }

    protected void saveCurrentExpansion() {
        this.lastExpandedSet = new ArrayList();
        TreePath rootPath = new TreePath(this.ioViewTree.getModel().getRoot());
        this.saveCurrentExpansion(this.ioViewTree, rootPath);
    }

    protected void clearTree() {
        this.lastExpandedSet.clear();
        this.focusBlock = null;
        ATreeModel tm = (ATreeModel)this.ioViewTree.getModel();
        RootNode rn = (RootNode)((Object)tm.getRoot());
        rn.invalidateChildren();
    }

    protected void expandHierLevels() {
        ATreeModel tm = (ATreeModel)this.ioViewTree.getModel();
        RootNode rn = (RootNode)((Object)tm.getRoot());
        rn.invalidateChildren();
        this.expandAll(this.ioViewTree, true, 5);
        this.ioViewTree.scrollPathToVisible(this.ioViewTree.getSelectionPath());
    }

    protected void editIOCell(DeviceNode dn) {
        IOViewEditBlockDlg dlg = IOViewEditBlockDlg.createDialog((Window)((Object)this), this.mDb, dn.dblock, false);
        dlg.setVisible(true);
        if (dlg.getAccepted()) {
            IOViewBlock b = dn.dblock;
            IOViewBlock.setWorkingBlock(b, b);
            this.focusBlock = dn.dblock;
            Cp.exec(() -> IOViewBlock.getWorkingBlock().updateDbDevice(), (String)"IOViewBlock.getWorkingBlock().updateDbDevice();", (Object[])new Object[0]);
            Cp.exec(() -> IOViewBlock.getWorkingBlock().updateDbDevice(), (String)"IOViewBlock.getWorkingBlock().updateDbDevice();", (Object[])new Object[0]);
            Cp.exec(() -> IOView.buildCanvasFromIOView(-1), (String)"com.sigrity.orbit.iov.IOView.buildCanvasFromIOView(%d);", (Object[])new Object[]{-1});
            Cp.exec(IOView::somethingChanged, (String)"com.sigrity.orbit.iov.IOView.somethingChanged();", (Object[])new Object[0]);
            OrbitIO.getApp().refreshCurrentView(false);
        }
        UIUtil.closeWindow((Window)((Object)dlg));
    }

    protected void editInterface(DeviceNode dn) {
        IOViewBlock block = dn.dblock;
        String oldName = dn.dblock.getName();
        List<String> otherIntfNames = this.mIOView.getNamesOfInterfacesAtSameLevel(block);
        IOViewCreatePersonalityDlg dlg = IOViewCreatePersonalityDlg.createDialog((Window)((Object)this), block, true, otherIntfNames);
        dlg.setVisible(true);
        if (dlg.getAccepted()) {
            String newName = block.getDesiredName();
            IOViewBlock.setWorkingBlock(block, block);
            this.focusBlock = dn.dblock;
            DevicePath dPath = new DevicePath(this.dieDevice);
            Cp.exec(() -> IOViewDlg.updateInterface(block.devicePath.toString(), dPath.toString(), oldName, newName), (String)"IOViewDlg.updateInterface(\"%s\", \"%s\", \"%s\", \"%s\");", (Object[])new Object[]{block.devicePath.toString(), dPath.toString(), oldName, newName});
            OrbitIO.getApp().refreshCurrentView(false);
        }
        UIUtil.closeWindow((Window)((Object)dlg));
    }

    private static void reNetmapToNewParent(Set<APair<String, String>> oldMap, Device newParent, Device device) {
        DeviceTemplate rootDeviceTemplate = IOView.theIOView.getRootDevicePath().getDeviceTemplate();
        DeviceTemplate newParentTemplate = newParent.getTemplate();
        DeviceTemplate deviceTemplate = device.getTemplate();
        for (APair<String, String> map : oldMap) {
            String childNet = (String)map.first;
            String parentNet = (String)map.second;
            Net coreNet = newParentTemplate.getNet(parentNet);
            if (coreNet == null) {
                coreNet = Net.create((DeviceTemplate)newParentTemplate, (String)parentNet);
            }
            NetMap.mapChildNet((Device)device, (Net)deviceTemplate.getNet(childNet), (Net)coreNet);
            NetMap.mapChildNet((Device)newParent, (Net)coreNet, (Net)rootDeviceTemplate.getNet(parentNet));
        }
    }

    private static void reNetmapToRootDevice(Set<APair<String, String>> oldMap, Device device) {
        DeviceTemplate rootDeviceTemplate = IOView.theIOView.getRootDevicePath().getDeviceTemplate();
        DeviceTemplate deviceTemplate = device.getTemplate();
        for (APair<String, String> map : oldMap) {
            String childNet = (String)map.first;
            String parentNet = (String)map.second;
            Net dieNet = rootDeviceTemplate.getNet(parentNet);
            if (dieNet == null) {
                dieNet = Net.create((DeviceTemplate)rootDeviceTemplate, (String)parentNet);
            }
            NetMap.mapChildNet((Device)device, (Net)deviceTemplate.getNet(childNet), (Net)dieNet);
        }
    }

    private static boolean didChangeToOrFromLogicalCore(IOViewBlock block, DevicePath corePath) {
        String oldPath = block.devicePath.toString();
        while (oldPath.startsWith(".") || oldPath.startsWith("/")) {
            oldPath = oldPath.substring(1);
        }
        String newPath = block.desiredPathName;
        while (newPath.startsWith(".") || newPath.startsWith("/")) {
            newPath = newPath.substring(1);
        }
        return !oldPath.endsWith(newPath) && corePath != null;
    }

    private static String renameInterfaceDevice(IOViewBlock block, String newName) {
        Device d = block.devicePath.getLast();
        d.setName(newName);
        block.devicePath = IOView.theIOView.getRootDevicePath().getParent();
        block.devicePath.add(d);
        block.updateName();
        return IOView.getPersonalityNameForInterface(block.getDevicePath());
    }

    private static Optional<Personality> renameInterfacePersonality(IOViewBlock block, String oldPersName, String newPersName) {
        Optional p = Personality.getPersonality((DeviceTemplate)block.getDevicePath().getRoot(), (Personality.Type)Personality.Type.DEVICE, (String)oldPersName);
        if (!p.isPresent()) {
            ALog.logError((String)("Interface " + oldPersName + " does not exist!"));
            assert (false);
        } else {
            ((Personality)p.get()).setName(newPersName);
            ALog.logInfo((String)("Interface " + oldPersName + " renamed to " + newPersName));
        }
        return p;
    }

    public static String renameInterface(IOViewBlock block, String newName) {
        String oldPersName = IOView.getPersonalityNameForInterface(block.getDevicePath());
        String newPersName = IOViewDlg.renameInterfaceDevice(block, newName);
        IOViewDlg.renameInterfacePersonality(block, oldPersName, newPersName);
        return newPersName;
    }

    public static void updateInterface(String blockPath, String dPathString, String oldName, String newName) {
        IOViewBlock block = IOViewBlock.findBlockOfName(blockPath);
        DevicePath dPath = IOView.getDevicePathFromString(dPathString);
        String persName = !oldName.equals(newName) ? IOViewDlg.renameInterface(block, newName) : IOView.getPersonalityNameForInterface(block.getDevicePath());
        Optional p = Personality.getPersonality((DeviceTemplate)dPath.getLast().getTemplate(), (Personality.Type)Personality.Type.DEVICE, (String)persName);
        if (p.isPresent()) {
            Constraint.setConstraintValue((DbObject)((DbObject)p.get()), (Constraint.Descriptor)Constraint.HARD_PERSONALITY, (Object)block.hard);
            Constraint.setConstraintValue((DbObject)((DbObject)p.get()), (Constraint.Descriptor)Constraint.IGNORE_GRID, (Object)block.ignoreGrid);
            block.setPersonalityFields((Personality)p.get());
        } else {
            ALog.logError((String)("Interface " + persName + " does not exist!"));
            assert (false);
        }
        DevicePath diePath = IOView.theIOView.getRootDevicePath();
        DevicePath corePath = CoreFactory.getCoreDevicePath(diePath);
        if (IOViewDlg.didChangeToOrFromLogicalCore(block, corePath)) {
            Object newPath;
            Device interfce = block.devicePath.getLast();
            Set<APair<String, String>> oldMap = interfce.getNets().stream().filter(childNet -> !childNet.isUnused()).filter(childNet -> NetMap.getParentNet((Device)interfce, (Net)childNet) != null).map(childNet -> new APair((Object)childNet.getName(), (Object)NetMap.getParentNet((Device)interfce, (Net)childNet).getName())).collect(Collectors.toSet());
            NetmapPrescription oldNetmap = new NetmapPrescription(oldMap);
            DevicePath interfaceDP = block.getDevicePath();
            Device logicalCore = corePath.getLast();
            if (block.desiredPathName.contains(corePath.getLast().getName())) {
                ALog.logInfo((String)("Moving " + interfce.getName() + " to " + corePath.getLast().getName()));
                block.devicePath.getLast().setParent(corePath.getLast(), true, true);
                IOViewDlg.reNetmapToNewParent(oldNetmap.getMappingSet(), logicalCore, interfce);
                newPath = new DevicePath(IOView.theIOView.getRootDevicePath());
                newPath.add(corePath.getLast());
                newPath.add(block.devicePath.getLast());
                block.devicePath = newPath;
                IOView.theIOView.fireInterfaceChangedHierarchy(interfaceDP, IOView.theIOView.getRootDevicePath(), corePath);
            } else {
                ALog.logInfo((String)("Moving " + interfce.getName() + " to " + IOView.theIOView.getRootDevicePath().toString()));
                block.devicePath.getLast().setParent(IOView.theIOView.getRootDevicePath().getLast(), true, true);
                IOViewDlg.reNetmapToRootDevice(oldNetmap.getMappingSet(), interfce);
                IOViewDlg.deleteChildlessNets(corePath);
                IOView.theIOView.fireInterfaceChangedHierarchy(interfaceDP, corePath, IOView.theIOView.getRootDevicePath());
            }
            for (IOViewBlock childBlock : block.getChildren()) {
                DevicePath childPath;
                childBlock.devicePath = childPath = block.devicePath.withChild(childBlock.devicePath.getLast());
            }
            newPath = new DevicePath(IOView.theIOView.getRootDevicePath());
            block.devicePath = DevicePath.glue((DevicePath)newPath, (DevicePath)block.devicePath);
            IOView.buildIOViewFromCanvasUser();
        }
        IOView.buildCanvasFromIOView(-1);
        IOView.debugOutputPlacementDetails("in IOView::updateInterface, after finishing buildCanvasFromIOView(-1)");
        IOView.somethingChanged();
    }

    private static void deleteChildlessNets(DevicePath corePath) {
        Set toBeDeleted = corePath.getLast().getTemplate().getNets().stream().filter(candidate -> !NetMap.getChildNets((Net)candidate).hasNext()).collect(Collectors.toSet());
        for (Net n : toBeDeleted) {
            n.deleteFromDb();
        }
    }

    public void expandAll(JTree tree, boolean expand, int stopDepth) {
        TreeNode root = (TreeNode)tree.getModel().getRoot();
        this.expandAll(tree, new TreePath(root), expand, 0, stopDepth);
    }

    public void setExpansion(JTree tree, int stopDepth) {
        TreeNode root = (TreeNode)tree.getModel().getRoot();
        this.setExpansion(tree, new TreePath(root), 0, stopDepth);
    }

    private void setExpansion(JTree tree, TreePath parent, int depth, int stopDepth) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e != null && e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                this.setExpansion(tree, path, depth + 1, stopDepth);
            }
        }
        if (depth < stopDepth) {
            tree.expandPath(parent);
        } else {
            tree.collapsePath(parent);
        }
    }

    private void expandAll(JTree tree, TreePath parent, boolean expand, int depth, int stopDepth) {
        if (depth >= stopDepth) {
            return;
        }
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e != null && e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                this.expandAll(tree, path, expand, depth + 1, stopDepth);
            }
        }
        if (expand) {
            tree.expandPath(parent);
        } else {
            tree.collapsePath(parent);
        }
    }

    protected boolean pasteBuffer(List<IOViewBlock> fromBlocks, TreePath treePath) {
        int saveLastEditedRow = this.lastEditedRow;
        Collections.reverse(fromBlocks);
        for (IOViewBlock fromBlock : fromBlocks) {
            boolean fromIsAnInterface = fromBlock.isInterface();
            ++this.lastEditedRow;
            Object dropOnObject = treePath.getLastPathComponent();
            int sideToAddToFirst = 0;
            int index = 0;
            if (dropOnObject.getClass().equals(DeviceNode.class)) {
                IOViewBlock toBlock;
                int index_;
                DeviceNode to = (DeviceNode)((Object)dropOnObject);
                boolean toIsAnInterface = to.dblock.isInterface();
                if (fromIsAnInterface && toIsAnInterface) {
                    sideToAddToFirst = to.dblock.side;
                    if (treePath.getParentPath().getLastPathComponent().getClass().equals(SideNode.class)) {
                        SideNode sn = (SideNode)((Object)treePath.getParentPath().getLastPathComponent());
                        index = sn.myBlocks.indexOf((Object)to);
                    }
                    this.focusBlock = fromBlock;
                    int sideToAddToFirst_ = sideToAddToFirst;
                    index_ = ++index;
                    Cp.exec(() -> IOView.insertToSide(fromBlock.devicePath.toString(), sideToAddToFirst_, index_), (String)"com.sigrity.orbit.iov.IOView.insertToSide(\"%s\",%d, %d);", (Object[])new Object[]{fromBlock.devicePath.toString(), sideToAddToFirst, index});
                    continue;
                }
                if (toIsAnInterface) {
                    toBlock = to.dblock;
                    index = 0;
                } else {
                    toBlock = to.dblock.parent;
                    index = toBlock.children.indexOf(to.dblock);
                    if (++index == -1) {
                        return false;
                    }
                    if (index >= toBlock.children.size()) {
                        index = -1;
                    }
                }
                this.focusBlock = fromBlock;
                IOViewBlock toBlock_ = toBlock;
                index_ = index;
                Cp.exec(() -> IOView.insert(fromBlock.devicePath.toString(), toBlock_.devicePath.toString(), index_), (String)"com.sigrity.orbit.iov.IOView.insert(\"%s\", \"%s\", %d);", (Object[])new Object[]{fromBlock.devicePath.toString(), toBlock.devicePath.toString(), index});
                continue;
            }
            if (dropOnObject.getClass().equals(SideNode.class)) {
                if (!fromIsAnInterface) {
                    ALog.logWarn((String)"Can only add an Interface to a side");
                    this.lastEditedRow = saveLastEditedRow;
                    return false;
                }
                SideNode sn = (SideNode)((Object)dropOnObject);
                sideToAddToFirst = sn.getSide();
                this.focusBlock = fromBlock;
                int sideToAddToFirst_ = sideToAddToFirst;
                Cp.exec(() -> IOView.insertToSide(fromBlock.devicePath.toString(), sideToAddToFirst_, 0), (String)"com.sigrity.orbit.iov.IOView.insertToSide(\"%s\",%d, 0);", (Object[])new Object[]{fromBlock.devicePath.toString(), sideToAddToFirst});
                continue;
            }
            ALog.logInfo((String)"Can only drop on sides or Devices");
            return false;
        }
        OrbitIO.getApp().refreshCurrentView(false);
        return true;
    }

    protected TreePath findTreePath(IOViewBlock block) {
        RootNode rn = (RootNode)((Object)this.ioViewTree.getModel().getRoot());
        TreePath retPath = new TreePath((Object)rn);
        if (block != null && block.side < 4) {
            RingNode ring = (RingNode)rn.mRingNodes.get(0);
            retPath = retPath.pathByAddingChild((Object)ring);
            int side = block.side;
            side += 2;
            SideNode sn = ring.sideNodes.get(side %= 4);
            retPath = retPath.pathByAddingChild((Object)sn);
            if (block.isInterface()) {
                int index = sn.getIndexOf(block.getDevicePath());
                if (index >= 0) {
                    retPath = retPath.pathByAddingChild((Object)sn.myBlocks.get(index));
                }
            } else {
                DevicePath aPath = new DevicePath(block.getDevicePath());
                DevicePath parentPath = block.getDevicePath().getParent();
                int index = sn.getIndexOf(parentPath);
                if (index >= 0) {
                    DeviceNode interfaceNode = sn.myBlocks.get(index);
                    retPath = retPath.pathByAddingChild((Object)interfaceNode);
                    index = interfaceNode.getIndexOf(aPath.toString());
                    if (index >= 0) {
                        retPath = retPath.pathByAddingChild((Object)interfaceNode.childDevices.get(index));
                    }
                }
            }
        }
        return retPath;
    }

    public static void makeDeviceOnInterface(IOViewBlock block, String parentPathName, int index) {
        block.makeDbDevice();
        IOViewBlock parentBlock = IOViewBlock.findBlockOfName(parentPathName);
        DeviceTemplate dieTemplate = parentBlock.devicePath.pathToLowestDie().getLast().getTemplate();
        Optional p = Personality.getPersonality((DeviceTemplate)dieTemplate, (Personality.Type)Personality.Type.DEVICE, (String)IOView.getPersonalityNameForInterface(parentBlock.getDevicePath()));
        if (p.isPresent()) {
            block.devicePath.getLast().assignToPersonality((Personality)p.get());
        }
        IOView.addBlockToParent(block, parentBlock, index);
    }

    protected TreePath getPathOfSide(int side) {
        RootNode rn = (RootNode)((Object)this.ioViewTree.getModel().getRoot());
        TreePath retPath = new TreePath((Object)rn);
        RingNode ring = (RingNode)rn.mRingNodes.get(0);
        retPath = retPath.pathByAddingChild((Object)ring);
        if ((side += 2) > 3) {
            side -= 4;
        }
        SideNode sn = ring.sideNodes.get(side);
        retPath = retPath.pathByAddingChild((Object)sn);
        return retPath;
    }

    protected void showMe(TreePath path) {
        if (path == null) {
            return;
        }
        Rectangle r1 = this.ioViewTree.getParent().getBounds();
        if (this.ioViewTree.getPathBounds(path) != null) {
            Rectangle r2 = new Rectangle(this.ioViewTree.getPathBounds(path));
            r2.setSize(r1.width, r1.height);
            this.ioViewTree.scrollRectToVisible(r2);
        }
    }

    public static void cDoDecoration(String decorationCommand) {
        IOViewDieDecorator dd = IOViewDieDecoratorRegistry.get(decorationCommand);
        dd.decorate();
    }

    public static void moveBlock(IOViewBlock from, IOViewBlock to) {
    }

    static {
        DieDecorator.registerSpecialNetlistCommand();
        externalAddState = new ExternalAddInfo();
    }

    class ImportDirectory
    implements ActionListener {
        ImportDirectory() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AFileChooser fc = new AFileChooser();
            fc.setFileSelectionMode(1);
            fc.setMultiSelectionEnabled(false);
            if (fc.showOpenDialog((Component)OrbitIO.getMainWindow()) != 0) {
                return;
            }
            File f = fc.getSelectedFile();
            if (f == null) {
                return;
            }
            DevicePath path = lastDevicePath;
            if (path == null) {
                return;
            }
            DeviceTemplate dt = path.getDeviceTemplate();
            if (dt == null) {
                return;
            }
            OrbitLibrarySerializerUI.readDirectoryOfTemplates(f.getPath(), dt.getKeyStr());
        }
    }

    public class IOViewRenderer
    extends ATreeCellRenderer {
        public void setBackground(Color color) {
            if (color instanceof ColorUIResource) {
                color = null;
            }
            super.setBackground(color);
        }

        public Color getBackgroundNonSelectionColor() {
            return null;
        }

        public Color getBackground() {
            return null;
        }

        private String getDeviceNodeText(DevicePath devicePath) {
            Object text = "";
            if (IOView.theIOView.getShowDeviceNames()) {
                text = (String)text + devicePath.getLast().getName();
            }
            if (IOView.theIOView.getShowDeviceNames() && IOView.theIOView.getShowTemplateNames()) {
                text = (String)text + " ";
            }
            if (IOView.theIOView.getShowTemplateNames()) {
                text = (String)text + devicePath.getLast().getTemplate().getName();
            }
            return text;
        }

        private boolean isInCore(IOViewBlock dblock) {
            boolean inCore = false;
            DevicePath corePath = CoreFactory.getCoreDevicePath(IOViewDlg.this.dieDevice.getADevicePath());
            if (corePath != null) {
                Device interfce = dblock.devicePath.getLast();
                DeviceTemplate parent = interfce.getParent();
                if (corePath.getLast().getTemplate().equals(parent)) {
                    inCore = true;
                }
            }
            return inCore;
        }

        private void setInterfaceDeviceNodeIconTooltip(IOViewBlock dblock) {
            Optional p;
            boolean alreadyDecorated = ProgramableTilePlacer.alreadyDecorated(dblock.children);
            String persName = IOView.getPersonalityNameForInterface(dblock.getDevicePath());
            Optional optional = p = IOViewDlg.this.dieDevice.getTemplate() != null ? Personality.getPersonality((DeviceTemplate)IOViewDlg.this.dieDevice.getTemplate(), (Personality.Type)Personality.Type.DEVICE, (String)persName) : Optional.empty();
            if (p.isPresent()) {
                boolean inCore = this.isInCore(dblock);
                if (alreadyDecorated && dblock.crcDifferent()) {
                    this.setIcon(OrbitIcons.EXCLAMATION);
                } else if (inCore) {
                    this.setIcon(CoreFactory.getIcon(((Personality)p.get()).getColor()));
                } else {
                    this.setIcon((Icon)new AColorIcon(16, 16, ((Personality)p.get()).getColor()));
                }
                String decorationName = IOView.getDecorationName(dblock);
                if (decorationName == null) {
                    decorationName = "";
                }
                Object tooltip = "<html>";
                if (dblock.template != null) {
                    tooltip = (String)tooltip + "Template = " + dblock.template.getName() + "<br>";
                }
                tooltip = (String)tooltip + "Device = " + dblock.getDevicePath().getLast().getName() + "<br>Decorator = " + decorationName + "<br>Path =  " + dblock.devicePath.toString() + "</html>";
                this.setToolTipText((String)tooltip);
            }
        }

        private void setDeviceNodeIconTooltip(IOViewBlock dblock) {
            this.setToolTipText("");
            if (dblock.isInterface()) {
                this.setInterfaceDeviceNodeIconTooltip(dblock);
            } else {
                IOViewBlock parent = dblock.parent;
                Icon icon = DbExplorerPanel.getIconForDevice(dblock.devicePath.getLast());
                if (parent.isInterface()) {
                    boolean alreadyDecorated = ProgramableTilePlacer.alreadyDecorated(parent.children);
                    String persName = IOView.getPersonalityNameForInterface(parent.getDevicePath());
                    Optional p = Personality.getPersonality((DeviceTemplate)IOViewDlg.this.dieDevice.getTemplate(), (Personality.Type)Personality.Type.DEVICE, (String)persName);
                    if (p.isPresent() && alreadyDecorated && dblock.crcDifferent()) {
                        icon = OrbitIcons.EXCLAMATION;
                    }
                }
                this.setIcon(icon);
                DevicePath dp = new DevicePath(dblock.devicePath);
                dp.removeFirst();
                float rot = dp.getRot();
                boolean mirror = dp.getMirror();
                DeviceTemplate.DefTransform devOrient = IOView.createOrientForOrbit(rot, mirror);
                String rotString = devOrient.toString();
                this.setToolTipText("<html>Template = " + dblock.template.getName() + "<br>Device = " + dblock.getDevicePath().getLast().getName() + "<br> Path =  " + dblock.devicePath.toString() + "<br>Die Rotation:" + rotString + "</html>");
            }
        }

        private void renderDeviceNode(IOViewBlock dblock) {
            try {
                DevicePath devicePath = dblock.getDevicePath();
                this.setText(this.getDeviceNodeText(devicePath));
                Color fcolor = Color.blue;
                this.setForeground(fcolor);
                int fontStyle = devicePath.getLast().getSourceType() != Device.SourceType.DECORATOR ? 1 : 0;
                this.setFont(this.getFont().deriveFont(fontStyle));
                if (devicePath.getLast().getIsFixed()) {
                    this.setForeground(Color.red);
                } else {
                    this.setForeground(fcolor);
                }
                this.setDeviceNodeIconTooltip(dblock);
            }
            catch (Exception e) {
                ALog.logError((String)"'%s' on '%s'", (Object[])new Object[]{e.getMessage(), dblock});
                ALog.logError((String)"SHOULD NOT CONTINUE!");
            }
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component c = super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            this.setOpaque(false);
            if (value.getClass().equals(SideNode.class)) {
                Side s = ((SideNode)((Object)value)).s;
                this.setText(s.name());
                this.setIcon(DbExplorerPanel.getFolderIcon());
            } else if (value.getClass().equals(DeviceNode.class)) {
                this.renderDeviceNode(((DeviceNode)((Object)value)).dblock);
            } else if (value.getClass().equals(RingNode.class)) {
                int r = ((RingNode)((Object)value)).ring;
                this.setIcon(DbExplorerPanel.getFolderIcon());
                this.setText("Ring " + Integer.toString(r));
            } else if (value.getClass().equals(RootNode.class)) {
                RootNode rn = (RootNode)((Object)value);
                this.setIcon(DbExplorerPanel.getIconForDevice(rn.dPath.getLast()));
                this.setText(rn.dPath.getLast().getName());
            }
            return c;
        }
    }

    class PersonalityPopupMenu
    extends JPopupMenu {
        JMenu decorate;
        JMenuItem undecorate;
        JMenuItem markAsUndecorated;
        JMenuItem paste;
        JMenuItem cut;
        JMenuItem cloneInterface;

        PersonalityPopupMenu() {
            this.addSeparator();
            this.decorate = new JMenu("Decorate Interface With");
            this.add(this.decorate);
            Device d = IOViewDlg.this.dieDevice == null ? lastDevicePath.getLast() : IOViewDlg.this.dieDevice;
            ProgramableTilePlacer ptp = new ProgramableTilePlacer(d);
            List<String> names = ptp.getProgramableTileNames();
            for (String name : names) {
                JMenuItem p1 = new JMenuItem(name);
                p1.setToolTipText(ptp.getDescriptionOfProgramableTile(name));
                p1.addActionListener(new DoDecorationCommand(name));
                this.decorate.add(p1);
            }
            this.undecorate = this.add("UnDecorate Interface", IOViewDlg.this.mUnDecorateListener);
            this.markAsUndecorated = this.add("Mark Interface as Undecorated", IOViewDlg.this.mMarkAsUndecorated);
            this.addSeparator();
            this.add("Add New Ratio Driven Cover Cell", IOViewDlg.this.mCreateNewRatioDriven);
            this.add("Edit Interface", IOViewDlg.this.mEditInterfaceActionListener);
            this.add("Delete Interface (and children)", IOViewDlg.this.mDeleteInterfaceActionListener);
            this.add("Remove All Gaps and Insets from IO cells", IOViewDlg.this.mRemoveAllIOCellGaps);
            this.addSeparator();
            this.add("Approve Interface", IOViewDlg.this.mApproveInterface);
            this.cut = this.add("Cut ", IOViewDlg.this.mCutInterfaceActionListener);
            this.paste = this.add("Paste", IOViewDlg.this.mPasteSelectedActionListener);
            this.addSeparator();
            this.add("Mirror Interface", IOViewDlg.this.mMirrorInterface);
            this.cloneInterface = this.add("Clone Interface", IOViewDlg.this.mCloneInterface);
            this.addSeparator();
            this.add("Connect Bumps to IO Pads", IOViewDlg.this.mConnectBumpsToIOPads);
            this.addSeparator();
            this.add("Show Connections", IOViewDlg.this.mReschedule);
            this.addSeparator();
            this.add("Add New IO Cell to Interface", IOViewDlg.this.mAddIOCellActionListener);
        }

        protected JMenuItem add(String text, ActionListener listener) {
            JMenuItem jmi = this.add(new JMenuItem(text));
            jmi.addActionListener(listener);
            return jmi;
        }

        public void enableControls() {
            TreePath treePath = IOViewDlg.this.ioViewTree.getSelectionPath();
            DeviceNode dn = (DeviceNode)((Object)treePath.getLastPathComponent());
            IOViewBlock block = dn.dblock;
            boolean alreadyDecorated = false;
            String decorationName = IOView.getDecorationName(block);
            if (decorationName == null) {
                decorationName = "";
            }
            if (!block.children.isEmpty()) {
                alreadyDecorated = ProgramableTilePlacer.alreadyDecorated(block.children);
            }
            for (int i = 0; i < this.decorate.getMenuComponentCount(); ++i) {
                JMenuItem jmi = (JMenuItem)this.decorate.getMenuComponent(i);
                String thisName = jmi.getText();
                if (thisName == null || !thisName.equals(decorationName)) {
                    this.decorate.getMenuComponent(i).setBackground(Color.LIGHT_GRAY);
                    continue;
                }
                this.decorate.getMenuComponent(i).setBackground(Color.WHITE);
            }
            this.decorate.setEnabled(true);
            this.undecorate.setEnabled(true);
            this.markAsUndecorated.setEnabled(true);
            if (alreadyDecorated) {
                this.decorate.setEnabled(false);
            } else {
                this.undecorate.setEnabled(false);
                this.markAsUndecorated.setEnabled(false);
            }
            this.paste.setEnabled(!IOView.theIOView.getCPBuffer().isEmpty());
            this.cloneInterface.setEnabled(true);
        }

        @Override
        public void show(Component invoker, int x, int y) {
            this.enableControls();
            super.show(invoker, x, y);
        }
    }

    class DoDieDecorationCommand
    implements ActionListener {
        IOViewDieDecorator dd;

        public DoDieDecorationCommand(IOViewDieDecorator dd) {
            this.dd = dd;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            String decorationCommand = this.dd.name();
            try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)IOViewDlg.this.mDb, (String)decorationCommand);){
                Cp.exec(() -> IOViewDlg.cDoDecoration(decorationCommand), (String)"com.sigrity.orbit.iov.IOViewDlg.cDoDecoration (\"%s\");", (Object[])new Object[]{decorationCommand});
            }
            finally {
                OrbitIO.getApp().refreshCurrentView(false);
                DbExplorerPanel.refreshAll();
                IOViewDlg.this.refreshTree();
            }
        }
    }

    private class RatioDrivenListener
    implements ExternalDeviceUpdateListener.ListenerInterface {
        private RatioDrivenListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void updated(Device d) {
            if (IOViewDlg.externalAddState.state.equals((Object)ExternalAddState.Waiting)) {
                IOViewDlg.externalAddState.state = ExternalAddState.NotWaiting;
                try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)IOViewDlg.this.mDb, (String)"Add IOCell to Interface");){
                    Personality p = Personality.getPersonality((DeviceTemplate)IOViewDlg.this.dieDevice.getTemplate(), (Personality.Type)Personality.Type.DEVICE, (String)IOViewDlg.externalAddState.acceptingInterface.getLast().getName()).orElse(null);
                    if (p != null) {
                        d.assignToPersonality(p);
                    }
                }
                finally {
                    IOView.buildIOViewFromCanvasUser();
                }
            }
        }
    }

    public class DoDecorationCommand
    implements ActionListener {
        String myName;

        public DoDecorationCommand(String rule) {
            this.myName = rule;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath treePath = IOViewDlg.this.ioViewTree.getSelectionPath();
            if (treePath == null) {
                ALog.logError((String)"Unexpected null SelectionPath, from '%s'", (Object[])new Object[]{IOViewDlg.this.ioViewTree});
                return;
            }
            DeviceNode dn = (DeviceNode)((Object)treePath.getLastPathComponent());
            try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)IOViewDlg.this.mDb, (String)("Decorate " + dn.dblock.devicePath.toString()));){
                String persName = IOView.getPersonalityNameForInterface(dn.dblock.getDevicePath());
                Optional p = Personality.getPersonality((DeviceTemplate)IOViewDlg.this.dieDevice.getTemplate(), (Personality.Type)Personality.Type.DEVICE, (String)persName);
                if (!p.isPresent()) {
                    return;
                }
                IOViewDlg.this.lastEditedRow = IOViewDlg.this.ioViewTree.getRowForPath(treePath);
                IOViewDlg.this.focusBlock = dn.dblock;
                Cp.exec(() -> IOView.decorate(dn.dblock.devicePath.toString(), this.myName), (String)"IOView.decorate(\"%s\", \"%s\");", (Object[])new Object[]{dn.dblock.devicePath.toString(), this.myName});
                Cp.exec(IOView::somethingChanged, (String)"com.sigrity.orbit.iov.IOView.somethingChanged();", (Object[])new Object[0]);
            }
            finally {
                OrbitIO.getApp().refreshCurrentView(false);
            }
        }
    }

    public class MyTransferHandler
    extends TransferHandler {
        JTree tree;

        public MyTransferHandler(JTree tree) {
            this.tree = tree;
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            TreePath[] treePaths = this.tree.getSelectionPaths();
            if (treePaths == null) {
                return null;
            }
            final ArrayList<IOViewBlock> froms = new ArrayList<IOViewBlock>();
            DevicePath commonParent = null;
            for (TreePath tp : treePaths) {
                IOViewBlock from;
                if (tp.getLastPathComponent().getClass().equals(DeviceNode.class)) {
                    DeviceNode fromNode = (DeviceNode)((Object)tp.getLastPathComponent());
                    from = fromNode.dblock;
                    if (from.devicePath.getLast().getIsFixed()) {
                        ALog.logWarn((String)"Can not move fixed devices");
                        return null;
                    }
                    if (commonParent == null) {
                        commonParent = from.devicePath.parentPath();
                    } else if (!commonParent.equals((Object)from.devicePath.parentPath())) {
                        ALog.logWarn((String)"Can only moved items that have the same parent");
                        return null;
                    }
                } else {
                    ALog.logWarn((String)"Can only move interfaces or devices");
                    return null;
                }
                froms.add(from);
            }
            return new Transferable(){

                @Override
                public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
                    if (flavor == DeviceBlockDataFlavor) {
                        return froms;
                    }
                    throw new UnsupportedFlavorException(flavor);
                }

                @Override
                public DataFlavor[] getTransferDataFlavors() {
                    return IOViewDlg.this.SupportedDataFlavors;
                }

                @Override
                public boolean isDataFlavorSupported(DataFlavor flavor) {
                    return AUtil.find((Object)flavor, (Object[])IOViewDlg.this.SupportedDataFlavors) >= 0;
                }
            };
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 2;
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            if (!support.isDataFlavorSupported(DeviceBlockDataFlavor)) {
                return false;
            }
            JTree.DropLocation dropLoc = (JTree.DropLocation)support.getDropLocation();
            int insertAt = dropLoc.getChildIndex();
            if (insertAt == -1) {
                // empty if block
            }
            return true;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            ArrayList fromBlocks;
            if (!support.isDrop()) {
                return false;
            }
            JTree.DropLocation dropLoc = (JTree.DropLocation)support.getDropLocation();
            TreePath treePath = dropLoc.getPath();
            if (treePath == null) {
                return false;
            }
            try {
                fromBlocks = (ArrayList)support.getTransferable().getTransferData(DeviceBlockDataFlavor);
            }
            catch (Exception e) {
                ALog.logError((Throwable)e, (String)"Error dropping.", (Object[])new Object[0]);
                return false;
            }
            return IOViewDlg.this.pasteBuffer(fromBlocks, treePath);
        }
    }

    protected class TreeSearcher {
        JTree tree;
        Pattern lastPattern;
        int nth = 1;
        ArrayList<TreePath> matchNodes = new ArrayList();

        public TreeSearcher(JTree tree) {
            this.tree = tree;
        }

        public void searchFor(Pattern pattern) {
            this.matchNodes.clear();
            this.nth = 1;
            TreeNode root = (TreeNode)this.tree.getModel().getRoot();
            this.findNodesThatMatch(new TreePath(root), this.matchNodes, pattern);
            this.showSearchResults(1);
            this.lastPattern = pattern;
        }

        public void next() {
            ++this.nth;
            if (this.nth - 1 >= this.matchNodes.size()) {
                this.nth = 1;
            }
            this.showSearchResults(this.nth);
        }

        public void back() {
            --this.nth;
            if (this.nth <= 0) {
                this.nth = this.matchNodes.size();
            }
            this.showSearchResults(this.nth);
        }

        protected Pattern getLastPattern() {
            return this.lastPattern;
        }

        protected void invalidate() {
            this.lastPattern = null;
        }

        private void showSearchResults(int nth) {
            int arrayIndex = nth - 1;
            if (arrayIndex >= 0 && this.matchNodes.size() > arrayIndex) {
                this.tree.setSelectionPath(this.matchNodes.get(arrayIndex));
                this.tree.makeVisible(this.matchNodes.get(arrayIndex));
                IOViewDlg.this.showMe(this.matchNodes.get(arrayIndex));
                IOViewDlg.this.findResults.setText(nth + " of " + this.matchNodes.size());
                IOViewDlg.this.findResults.paintImmediately(IOViewDlg.this.findResults.getVisibleRect());
            } else {
                this.tree.clearSelection();
                IOViewDlg.this.findResults.setText("0 of 0");
                IOViewDlg.this.findResults.paintImmediately(IOViewDlg.this.findResults.getVisibleRect());
            }
        }

        private void findNodesThatMatch(TreePath parent, ArrayList<TreePath> matchNodes, Pattern pattern) {
            TreeNode node = (TreeNode)parent.getLastPathComponent();
            String thisName = null;
            if (parent.getLastPathComponent().getClass().equals(DeviceNode.class)) {
                DeviceNode fromNode = (DeviceNode)((Object)parent.getLastPathComponent());
                IOViewBlock from = fromNode.dblock;
                thisName = from.desiredName;
                if (thisName != null && pattern.matcher(from.desiredName).matches()) {
                    matchNodes.add(parent);
                }
            }
            if (node.getChildCount() >= 0) {
                Enumeration<? extends TreeNode> e = node.children();
                while (e != null && e.hasMoreElements()) {
                    TreeNode n = e.nextElement();
                    TreePath path = parent.pathByAddingChild(n);
                    this.findNodesThatMatch(path, matchNodes, pattern);
                }
            }
        }
    }

    protected static class IOViewTree
    extends JTree
    implements Autoscroll {
        protected ATreeModel mDbTreeModel;
        protected PopupMenuHandler mPopupMenuHandler = null;
        protected IOViewDlg owner = null;
        TreeSearcher ts;
        protected MouseListener mMouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.popupMenu(e);
                } else if (e.getButton() == 1 && e.getClickCount() == 2) {
                    this.editBlock(e);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.popupMenu(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.popupMenu(e);
                }
            }
        };

        public IOViewTree(ATreeModel tm, IOViewDlg owner) {
            super((TreeModel)tm);
            this.owner = owner;
            this.mDbTreeModel = tm;
            this.addMouseListener(this.mMouseListener);
        }

        public void setPopupMenuHandler(PopupMenuHandler h) {
            this.mPopupMenuHandler = h;
        }

        protected void editBlock(MouseEvent e) {
            int row = this.getRowForLocation(e.getX(), e.getY());
            this.setSelectionRow(row);
            if (this.getSelectionPath() == null) {
                return;
            }
            if (this.getSelectionPath().getLastPathComponent().getClass().equals(DeviceNode.class)) {
                DeviceNode dn = (DeviceNode)((Object)this.getSelectionPath().getLastPathComponent());
                if (!dn.dblock.isInterface()) {
                    this.owner.editIOCell(dn);
                } else {
                    this.owner.editInterface(dn);
                }
            }
        }

        protected void popupMenu(MouseEvent e) {
            if (this.mPopupMenuHandler != null) {
                this.mPopupMenuHandler.handlePopup(e.getX(), e.getY());
            }
        }

        @Override
        public Insets getAutoscrollInsets() {
            return new Insets(20, 20, 20, 20);
        }

        @Override
        public void autoscroll(Point cursorLocation) {
            Insets insets = this.getAutoscrollInsets();
            Rectangle outer = this.getVisibleRect();
            Rectangle inner = new Rectangle(outer.x + insets.left, outer.y + insets.top, outer.width - (insets.left + insets.right), outer.height - (insets.top + insets.bottom));
            if (!inner.contains(cursorLocation)) {
                Rectangle scrollRect = new Rectangle(cursorLocation.x - insets.left, cursorLocation.y - insets.top, insets.left + insets.right, insets.top + insets.bottom);
                this.scrollRectToVisible(scrollRect);
            }
        }

        static interface PopupMenuHandler {
            public void handlePopup(int var1, int var2);
        }
    }

    private static class NetmapPrescription {
        final Set<APair<String, String>> setChildNet2ParentNet;

        NetmapPrescription(Set<APair<String, String>> mapping) {
            this.setChildNet2ParentNet = mapping;
        }

        Set<APair<String, String>> getMappingSet() {
            return this.setChildNet2ParentNet;
        }
    }

    protected class RootNode
    extends ALazyTreeNode {
        protected ArrayList<ALazyTreeNode> mRingNodes;
        protected DevicePath dPath;

        public RootNode(ATreeModel m, Db db, DevicePath dPath) {
            super(m);
            this.dPath = dPath;
        }

        public ArrayList<ALazyTreeNode> populateChildren() {
            this.mRingNodes = new ArrayList();
            this.mRingNodes.add(new RingNode((ATreeNode)this, 1));
            return this.mRingNodes;
        }

        public String getText() {
            return "";
        }
    }

    protected class SideNode
    extends ALazyTreeNode {
        Side s;
        ArrayList<DeviceNode> myBlocks;

        public SideNode(ATreeNode m, Side s) {
            super(m);
            this.myBlocks = new ArrayList();
            this.s = s;
            this.mSortChildren = false;
        }

        public ArrayList<DeviceNode> populateChildren() {
            if (IOViewDlg.this.mIOView.mBlocks == null) {
                return null;
            }
            this.myBlocks.clear();
            List thisSide = IOViewDlg.this.mIOView.mBlocks.get(this.getSide());
            for (IOViewBlock d : thisSide) {
                this.myBlocks.add(new DeviceNode((ATreeNode)this, d));
            }
            return this.myBlocks;
        }

        public String getText() {
            return "\t";
        }

        public int getSide() {
            return this.s.getOrdinal();
        }

        public int getIndexOf(String pathName) {
            int i = 0;
            DevicePath dp = DevicePath.fromString((Db)IOViewDlg.this.mDb, (String)pathName);
            if (dp == null) {
                return -1;
            }
            for (DeviceNode dn : this.myBlocks) {
                if (dn.dblock.devicePath.getLast().equals(dp.getLast())) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        public int getIndexOf(DevicePath path) {
            Optional<DeviceNode> found = this.myBlocks.stream().filter(dn -> dn.dblock.devicePath.getLast().equals(path.getLast())).findAny();
            if (found.isPresent()) {
                return this.myBlocks.indexOf((Object)found.get());
            }
            return -1;
        }

        public DeviceNode getNthChild(int nth) {
            return this.myBlocks.get(nth);
        }
    }

    protected class RingNode
    extends ALazyTreeNode {
        ArrayList<SideNode> sideNodes;
        int ring;

        public RingNode(ATreeNode m, int r) {
            super(m);
            this.sideNodes = new ArrayList();
            this.ring = r;
            this.mSortChildren = false;
        }

        public ArrayList<SideNode> populateChildren() {
            if (IOViewDlg.this.mIOView.mBlocks == null) {
                return null;
            }
            this.sideNodes.clear();
            this.sideNodes.add(new SideNode((ATreeNode)this, Side.Left));
            this.sideNodes.add(new SideNode((ATreeNode)this, Side.Bottom));
            this.sideNodes.add(new SideNode((ATreeNode)this, Side.Right));
            this.sideNodes.add(new SideNode((ATreeNode)this, Side.Top));
            return this.sideNodes;
        }

        public String getText() {
            return Integer.toString(this.ring);
        }
    }

    protected class DeviceNode
    extends ALazyTreeNode {
        IOViewBlock dblock;
        ArrayList<DeviceNode> childDevices;

        public DeviceNode(ATreeNode m, IOViewBlock dblock) {
            super(m);
            this.childDevices = new ArrayList();
            this.dblock = dblock;
            this.mSortChildren = false;
        }

        public ArrayList<? extends ATreeNode> populateChildren() {
            this.childDevices.clear();
            if (this.dblock.isInterface()) {
                for (IOViewBlock db : this.dblock.children) {
                    this.childDevices.add(new DeviceNode((ATreeNode)this, db));
                }
            }
            return this.childDevices;
        }

        public String getText() {
            return this.dblock.toString();
        }

        public boolean isLeaf() {
            return this.childDevices.isEmpty();
        }

        public int getIndexOf(String pathName) {
            int i = 0;
            for (DeviceNode dn : this.childDevices) {
                if (dn.dblock.devicePath.toString().equals(pathName)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }
    }

    protected class HistoryListener
    extends DbHistory.ListenerAdapter {
        protected HistoryListener() {
        }

        public void endUndoRedo(boolean isRedo) {
            IOView.buildIOViewFromCanvasUser();
            IOViewDlg.this.refreshTree();
        }
    }

    protected class TemplateListener
    implements DbClass.DbObjectListener {
        protected TemplateListener() {
        }

        public boolean addingObject(DbClass.ObjectAdd add) {
            return false;
        }

        public boolean changingObject(DbClass.ObjectChange change) {
            return false;
        }

        public boolean removingObject(DbClass.ObjectRemove remove) {
            return false;
        }

        public void addedObject(DbClass.ObjectAdd add) {
        }

        public void changedObject(DbClass.ObjectChange change) {
            if (IOViewDlg.this.dieDevice == null) {
                return;
            }
            if (change.getObject() == IOViewDlg.this.dieDevice.getTemplate()) {
                String fieldName = change.getField().getName();
                if (fieldName != null) {
                    switch (fieldName) {
                        case "extent": {
                            return;
                        }
                        case "bounds": {
                            DevicePath corePath = CoreFactory.getCoreDevicePath(IOViewDlg.this.dieDevice.getADevicePath());
                            if (corePath == null) break;
                            corePath.getDeviceTemplate().setBounds((AGeom)IOViewDlg.this.dieDevice.getTemplate().getBB());
                        }
                    }
                }
                IOView.buildCanvasFromIOView(-1);
            }
            IOViewDlg.this.refreshTree();
        }

        public void removedObject(DbClass.ObjectRemove remove) {
        }
    }

    protected class InstanceListener
    implements DbClass.DbObjectListener {
        protected InstanceListener() {
        }

        public boolean addingObject(DbClass.ObjectAdd add) {
            return false;
        }

        public boolean changingObject(DbClass.ObjectChange change) {
            return false;
        }

        public boolean removingObject(DbClass.ObjectRemove remove) {
            return false;
        }

        public void addedObject(DbClass.ObjectAdd add) {
        }

        public void changedObject(DbClass.ObjectChange change) {
        }

        public void removedObject(DbClass.ObjectRemove remove) {
            if (IOViewDlg.this.dieDevice == null) {
                return;
            }
            IOViewDlg.this.queueRebuildOfIOView();
        }
    }

    protected class IOViewListener
    implements IOView.Listener {
        protected IOViewListener() {
        }

        @Override
        public void ioViewChanged() {
            IOViewDlg.this.refreshTree();
        }
    }

    static interface PopupMenuHandler {
        public void handlePopup(int var1, int var2);
    }

    static class ExternalAddInfo {
        ExternalAddState state = ExternalAddState.NotWaiting;
        DevicePath acceptingInterface;

        ExternalAddInfo() {
        }
    }

    static enum ExternalAddState {
        NotWaiting,
        Waiting;

    }

    public static enum Side {
        Bottom("Bottom", 3, 0.0f),
        Right("Right", 0, 270.0f),
        Top("Top", 1, 180.0f),
        Left("Left", 2, 90.0f),
        Core("Core", 4, 0.0f);

        static final String SYN_RIGHT = "SynRight";
        static final String SYN_TOP = "SynTop";
        static final String SYN_LEFT = "SynLeft";
        static final String SYN_BOTTOM = "SynBottom";
        private String longDescriptor;
        private int ordinal;
        private float angle;

        private Side(String ld, int ord, float angle) {
            this.longDescriptor = ld;
            this.ordinal = ord;
            this.angle = angle;
        }

        public String toString() {
            return this.longDescriptor;
        }

        public int getOrdinal() {
            return this.ordinal;
        }

        public static int[] getOrdinals() {
            int[] ordinals = new int[Side.values().length];
            int i = 0;
            for (Side s : Side.values()) {
                ordinals[i++] = s.ordinal;
            }
            return ordinals;
        }

        public static int determineSide(String side) {
            side = side.toLowerCase();
            for (Side s : Side.values()) {
                if (!side.contains(s.longDescriptor.toLowerCase())) continue;
                return s.ordinal;
            }
            return -1;
        }

        public static int determineSide(float angle) {
            for (Side s : Side.values()) {
                if (s.angle != angle) continue;
                return s.ordinal;
            }
            return -1;
        }

        public static APair<String, APoint2D> getSideInterfaceNameLoc(int side, ARect dieRect) {
            APoint2D interfaceLoc;
            String synName;
            switch (side) {
                case 0: {
                    synName = SYN_RIGHT;
                    interfaceLoc = dieRect.getLR();
                    break;
                }
                case 1: {
                    synName = SYN_TOP;
                    interfaceLoc = dieRect.getUR();
                    break;
                }
                case 2: {
                    synName = SYN_LEFT;
                    interfaceLoc = dieRect.getUL();
                    break;
                }
                case 3: {
                    synName = SYN_BOTTOM;
                    interfaceLoc = dieRect.getLL();
                    break;
                }
                default: {
                    return null;
                }
            }
            return new APair((Object)synName, (Object)interfaceLoc);
        }

        public static APair<String, Float> getDescriptorAndAngle(int side) {
            for (Side s : Side.values()) {
                if (side != s.ordinal) continue;
                return new APair((Object)s.longDescriptor.toLowerCase(), (Object)Float.valueOf(s.angle));
            }
            return null;
        }

        public static float getAngle(int side) {
            for (Side s : Side.values()) {
                if (side != s.ordinal) continue;
                return s.angle;
            }
            return -1.0f;
        }

        public static boolean isEdge(int side) {
            return side != Side.Core.ordinal;
        }
    }
}

