/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.iov;

import bsh.EvalError;
import bsh.Interpreter;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.sigrity.acl.AAlphaNumComp;
import com.sigrity.acl.AColor;
import com.sigrity.acl.ALog;
import com.sigrity.acl.Unit;
import com.sigrity.acl.app.AAppView;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.dbui.render.TemplateListRenderer;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.ui.AButtonGroup;
import com.sigrity.acl.ui.AColorIcon;
import com.sigrity.acl.ui.ADialog;
import com.sigrity.acl.ui.AFieldValidator;
import com.sigrity.acl.ui.AFloatWindow;
import com.sigrity.acl.ui.AList;
import com.sigrity.acl.ui.AListModel;
import com.sigrity.acl.ui.DbDialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.RegexFilterField;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.flowman.ui.FlowNodeTreeCellRenderer;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.NetGraphPanel;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.iov.IOView;
import com.sigrity.orbit.iov.IOViewBlock;
import com.sigrity.orbit.iov.PinDefinition;
import com.sigrity.orbit.ui.OrbitIcons;
import com.sigrity.tools.dbexplorer.DBEResources;
import com.sigrity.tools.dbexplorer.DbExplorerPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.AbstractCellEditor;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class IOViewEditBlockDlg
extends DbDialog {
    public static boolean allowBumpsToBeUnlocked = false;
    protected Icon ICON_CONNECTED = UIUtil.getIcon(FlowNodeTreeCellRenderer.class, (String)"res/iconCheck.png");
    protected Icon ICON_MAP = OrbitIcons.NETMAP;
    protected AAppView mView;
    protected IOViewBlock mBlock = null;
    protected JTextField mGapDistance;
    protected JTextField mInsetDistance;
    protected JTextField mIOCellName;
    protected JComboBox<DeviceTemplate> mCboTemplate;
    protected JComboBox<PinTemplate> mPinList;
    protected JTextField mDiffPairName;
    protected JTextField mNetName;
    protected ButtonGroup mGrpCreateBy = new AButtonGroup();
    protected JRadioButton mRbCreateByTemplate;
    protected JRadioButton mRbCreateBySize;
    protected JTextField mWidth;
    protected JTextField mHeight;
    protected boolean create = false;
    protected JRadioButton mHard;
    protected JRadioButton mCorner;
    protected JRadioButton mFixed;
    protected JPanel mPnlMode;
    protected JComboBox<String> mCboModes;
    protected JTable mPinNetTable;
    protected boolean mAccepted = false;
    protected PinNetModel mPinNetModel;
    protected JButton mSetDefaultNets;
    protected JLabel mRuleName;
    protected JButton mLockAll;
    protected JButton mUnLockAll;
    protected JComboBox<DeviceTemplate.DefTransform> mSouthTransform;
    protected TableCellRenderer tcr;
    static final int pinTypeColumm = 0;
    static final int connectedColumn = 1;
    static final int lockColumn = 2;
    static final int pinNameColumn = 3;
    static final int netNameColumn = 4;
    private Map<DeviceTemplate, DeviceTemplate.DefTransform> mTemplate2Transform = new HashMap<DeviceTemplate, DeviceTemplate.DefTransform>();
    protected ActionListener mCreateByChangeListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean byTemplate = IOViewEditBlockDlg.this.mRbCreateByTemplate.isSelected();
            IOViewEditBlockDlg.this.mCboTemplate.setEnabled(byTemplate);
            IOViewEditBlockDlg.this.mWidth.setEnabled(!byTemplate);
            IOViewEditBlockDlg.this.mHeight.setEnabled(!byTemplate);
            IOViewEditBlockDlg.this.mTemplateChangeListener.actionPerformed(null);
        }
    };
    protected ActionListener mTemplateChangeListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            HashSet modes;
            boolean byTemplate = IOViewEditBlockDlg.this.mRbCreateByTemplate.isSelected();
            DeviceTemplate dt = !byTemplate ? null : (DeviceTemplate)IOViewEditBlockDlg.this.mCboTemplate.getSelectedItem();
            HashSet hashSet = modes = dt == null ? null : (HashSet)dt.getValue("IOView.Modes");
            if (modes == null) {
                IOViewEditBlockDlg.this.mPnlMode.setVisible(false);
            } else {
                IOViewEditBlockDlg.this.mCboModes.removeAllItems();
                IOViewEditBlockDlg.this.mCboModes.addItem("");
                for (String mode : modes) {
                    IOViewEditBlockDlg.this.mCboModes.addItem(mode);
                }
                IOViewEditBlockDlg.this.mPnlMode.setVisible(true);
                DevicePath dp = IOViewEditBlockDlg.this.mBlock.getDevicePath();
                if (dp != null) {
                    Device device = dp.getLast();
                    String mode = "" + device.getValue("IOView.Mode");
                    IOViewEditBlockDlg.this.mCboModes.setSelectedItem(mode);
                }
                IOViewEditBlockDlg.this.mPnlMode.setVisible(true);
            }
            IOViewEditBlockDlg.this.pack();
        }
    };
    protected ActionListener mOk = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            IOViewEditBlockDlg.this.mAccepted = IOViewEditBlockDlg.this.createBlockFromDialog();
            if (IOViewEditBlockDlg.this.mAccepted) {
                UIUtil.closeWindow((Window)((Object)IOViewEditBlockDlg.this));
            }
        }
    };
    protected ActionListener mPinListChanged = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            PinTemplate dtp = (PinTemplate)IOViewEditBlockDlg.this.mPinList.getSelectedItem();
            if (dtp != null && dtp.getDeviceTemplate() == IOViewEditBlockDlg.this.mBlock.getDevicePath().getLast().getTemplate()) {
                IOViewEditBlockDlg.this.mNetName.setText(NetMap.getTopmostNet((Net)dtp.getNet(), (DevicePath)IOViewEditBlockDlg.this.mBlock.getDevicePath()).getName());
            }
        }
    };
    protected ActionListener mDoSelectTemplateDlg = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            SelectTemplateDialog dlg = new SelectTemplateDialog();
            if (dlg.doModal()) {
                IOViewEditBlockDlg.this.mCboTemplate.setSelectedItem(dlg.getSelectedTemplate());
            }
        }
    };

    public static IOViewEditBlockDlg createDialog(Window owner, Db db, IOViewBlock block, boolean create) {
        IOViewEditBlockDlg dlg = null;
        dlg = new IOViewEditBlockDlg(db, owner);
        dlg.init(block, create);
        return dlg;
    }

    public IOViewEditBlockDlg(Db db, Window owner) throws HeadlessException {
        super(db, (Component)owner);
    }

    public boolean getAccepted() {
        return this.mAccepted;
    }

    protected void init(IOViewBlock block, boolean create) {
        this.mView = OrbitIO.getCurView();
        this.mBlock = block;
        this.create = create;
        if (create) {
            this.setTitle("Edit " + this.mBlock.getDesiredName());
        } else {
            this.setTitle("Edit " + this.mBlock.getName());
        }
        this.setModal(true);
        GridBagManager l = new GridBagManager(this.getContentPane());
        l.pushFillX();
        l.add("IO Instance Name:");
        this.mIOCellName = new JTextField(10);
        l.add((Component)this.mIOCellName, (GridBagConstraints)GridBagManager.FILLX);
        l.popNl();
        l.pushFillX();
        l.pushFillX();
        this.mRbCreateByTemplate = new JRadioButton("By .lef Template");
        l.add((Component)this.mRbCreateByTemplate);
        this.mCboTemplate = (JComboBox)l.add(new JComboBox(), (GridBagConstraints)GridBagManager.FILLX);
        this.mCboTemplate.setRenderer(new TemplateListRenderer());
        JButton btnSearchLefTemplate = (JButton)l.add((Component)new JButton("Search..."));
        Font btnFont = btnSearchLefTemplate.getFont();
        btnSearchLefTemplate.setFont(btnFont.deriveFont((float)btnFont.getSize() - 2.0f));
        btnSearchLefTemplate.setMargin(new Insets(2, 2, 2, 2));
        btnSearchLefTemplate.addActionListener(this.mDoSelectTemplateDlg);
        l.pop();
        l.newline();
        l.pushNoFill();
        this.mRbCreateBySize = new JRadioButton("By Size:");
        l.add((Component)this.mRbCreateBySize, (GridBagConstraints)GridBagManager.LEFT);
        l.add("Width:");
        this.mWidth = new JTextField(10);
        l.add((Component)this.mWidth);
        l.add("Height:");
        this.mHeight = new JTextField(10);
        l.add((Component)this.mHeight);
        l.pop();
        this.mGrpCreateBy.add(this.mRbCreateByTemplate);
        this.mGrpCreateBy.add(this.mRbCreateBySize);
        l.pop();
        l.newline();
        l.push("Spacing", (GridBagConstraints)GridBagManager.FILLX);
        l.add("Gap:");
        this.mGapDistance = new JTextField(6);
        l.add((Component)this.mGapDistance, (GridBagConstraints)GridBagManager.FILLX);
        l.add("Inset:");
        this.mInsetDistance = new JTextField(6);
        l.add((Component)this.mInsetDistance, (GridBagConstraints)GridBagManager.FILLX);
        l.pop();
        l.newline();
        l.push("Attribute", (GridBagConstraints)GridBagManager.LEFT);
        JLabel orientation = l.add("Bottom Orientation");
        Object toolTip = "<html>By default all devices will be oriented 0 degrees and not mirrored (North) on the Bottom Side";
        toolTip = (String)toolTip + "<br>The device will be rotated counter clockwise 90 degrees on the right side.";
        toolTip = (String)toolTip + "<br>This process continues counter clockwise around the die.";
        toolTip = (String)toolTip + "<br>Changing the default orientation on the bottom of the die will change subsequent sides.";
        toolTip = (String)toolTip + "</html>";
        orientation.setToolTipText((String)toolTip);
        this.mSouthTransform = new JComboBox();
        this.mSouthTransform.setRenderer(new TransformRenderer());
        this.mSouthTransform.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.mTemplate2Transform.put((DeviceTemplate)this.mCboTemplate.getSelectedItem(), (DeviceTemplate.DefTransform)this.mSouthTransform.getSelectedItem());
            }
        });
        l.addNl(this.mSouthTransform);
        this.mCorner = new JRadioButton("Corner");
        l.add((Component)this.mCorner);
        this.mHard = new JRadioButton("Hard Macro");
        l.add((Component)this.mHard);
        this.mFixed = new JRadioButton("Fixed in Slot");
        l.add((Component)this.mFixed);
        l.pop();
        l.newline();
        this.mPnlMode = l.pushNoFill();
        JLabel modeLabel = new JLabel("Mode:", OrbitIcons.WRENCH, 0);
        l.add((Component)modeLabel);
        this.mCboModes = (JComboBox)l.add(new JComboBox());
        this.mCboModes.setEditable(false);
        this.mPnlMode.setVisible(false);
        l.popNl();
        l.push("Net List", (GridBagConstraints)GridBagManager.FILLALL);
        this.mRuleName = new JLabel(IOViewEditBlockDlg.getNetRuleName());
        this.mRuleName.setForeground(Color.RED);
        Font f = this.mRuleName.getFont();
        this.mRuleName.setFont(f.deriveFont((float)f.getSize() - 2.0f));
        l.add((Component)this.mRuleName);
        l.newline();
        l.pushNoFill();
        this.mSetDefaultNets = new JButton("Set Default Nets");
        l.add((Component)this.mSetDefaultNets);
        this.mLockAll = new JButton("Lock All Nets");
        l.add((Component)this.mLockAll);
        this.mUnLockAll = new JButton("Unlock All Nets");
        l.add((Component)this.mUnLockAll);
        l.newline();
        l.popNl();
        this.mPinNetTable = new JTable();
        int desireWidth = 480;
        int desiredHeight = 200;
        this.mPinNetTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.mPinNetTable.setPreferredScrollableViewportSize(new Dimension(desireWidth, desiredHeight));
        this.mPinNetTable.setFillsViewportHeight(true);
        this.mPinNetTable.setRowSelectionAllowed(false);
        this.mPinNetModel = new PinNetModel(block);
        this.mPinNetTable.setModel(this.mPinNetModel);
        JTableHeader jth = this.mPinNetTable.getTableHeader();
        this.tcr = jth.getDefaultRenderer();
        if (this.tcr != null) {
            // empty if block
        }
        this.mPinNetTable.addMouseListener(new TableButtonMouseListener(this.mPinNetTable));
        this.mPinNetTable.addMouseMotionListener(new TableMouseMotionListener(this.mPinNetTable));
        this.mPinNetTable.getTableHeader().setPreferredSize(new Dimension(desireWidth, 20));
        ColumnHeaderRender chr = new ColumnHeaderRender();
        TableColumn col = this.mPinNetTable.getColumnModel().getColumn(4);
        col.setCellEditor(new NetNameEditor());
        col.setHeaderRenderer(chr);
        col = this.mPinNetTable.getColumnModel().getColumn(0);
        col.setPreferredWidth(0);
        col.setHeaderRenderer(chr);
        col = this.mPinNetTable.getColumnModel().getColumn(1);
        col.setPreferredWidth(0);
        col.setHeaderRenderer(chr);
        col = this.mPinNetTable.getColumnModel().getColumn(2);
        col.setPreferredWidth(0);
        col.setHeaderRenderer(chr);
        col = this.mPinNetTable.getColumnModel().getColumn(3);
        col.setPreferredWidth((desireWidth - 32 - 32 - 32) / 2);
        col.setHeaderRenderer(chr);
        col = this.mPinNetTable.getColumnModel().getColumn(4);
        col.setPreferredWidth((desireWidth - 32 - 32 - 32) / 2);
        col.setHeaderRenderer(chr);
        this.mPinNetTable.setRowHeight(this.mPinNetTable.getRowHeight() + 4);
        this.mPinNetTable.setDefaultRenderer(Object.class, new MyTableRenderer());
        this.mPinNetTable.setAutoResizeMode(3);
        JScrollPane scrollPane = new JScrollPane(this.mPinNetTable);
        l.add((Component)scrollPane, (GridBagConstraints)GridBagManager.FILLALL);
        l.pop();
        l.newline();
        l.push((Container)new JPanel(), (GridBagConstraints)GridBagManager.RIGHT_REMAINX);
        JButton btnOk = new JButton("OK");
        l.add((Component)btnOk, (GridBagConstraints)GridBagManager.RIGHT);
        btnOk.addActionListener(this.mOk);
        JButton btnClose = new JButton("Cancel");
        l.add((Component)btnClose, (GridBagConstraints)GridBagManager.RIGHT);
        l.pop();
        this.mSetDefaultNets.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IOViewEditBlockDlg.this.setDefaultNets();
            }
        });
        this.mLockAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (int i = 0; i < IOViewEditBlockDlg.this.mPinNetModel.getRowCount(); ++i) {
                    IOViewEditBlockDlg.this.mPinNetModel.setLocked(i, true);
                }
                IOViewEditBlockDlg.this.mPinNetTable.repaint();
            }
        });
        this.mUnLockAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (int i = 0; i < IOViewEditBlockDlg.this.mPinNetModel.getRowCount(); ++i) {
                    PinTemplate pt = IOViewEditBlockDlg.this.mPinNetModel.pinNetNames.get((int)i).pt;
                    HierInst hierPinTemplate = new HierInst(IOViewEditBlockDlg.this.mBlock.devicePath, (DbObject)pt);
                    if (!IOViewEditBlockDlg.canNetsBeChangedOnThisPin((HierInst<PinTemplate>)hierPinTemplate)) continue;
                    IOViewEditBlockDlg.this.mPinNetModel.setLocked(i, false);
                }
                IOViewEditBlockDlg.this.mPinNetTable.repaint();
            }
        });
        this.mIOCellName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IOViewEditBlockDlg.this.updateCellName();
                IOViewEditBlockDlg.this.mPinNetTable.repaint();
            }
        });
        this.mCboTemplate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IOViewEditBlockDlg.this.updateDefaultTransformFromTemplate();
                IOViewEditBlockDlg.this.updatePinNetTable();
                IOViewEditBlockDlg.this.mPinNetTable.repaint();
            }
        });
        this.mRbCreateByTemplate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IOViewEditBlockDlg.this.updatePinNetTable();
            }
        });
        this.mRbCreateBySize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IOViewEditBlockDlg.this.updatePinNetTable();
                IOViewEditBlockDlg.this.mPinNetTable.repaint();
            }
        });
        this.mRbCreateByTemplate.addActionListener(this.mCreateByChangeListener);
        this.mRbCreateBySize.addActionListener(this.mCreateByChangeListener);
        this.mCboTemplate.addActionListener(this.mTemplateChangeListener);
        this.updateUI();
        this.mCreateByChangeListener.actionPerformed(null);
        UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnClose, (JButton)btnOk);
        this.pack();
        this.setMinimumSize(this.getPreferredSize());
        UIUtil.center((Component)((Object)this));
    }

    public void addNotify() {
        super.addNotify();
        this.updatePinNetTable();
    }

    protected static String getNetRuleName() {
        String base = "Net Editing Rule: ";
        IOView.AllowNetChangesInIOView method = IOView.AllowNetChangesInIOViewRegistry.getCurrentMethod();
        if (method == null) {
            return base + "None defined";
        }
        String name = method.description();
        if (name == null) {
            return base + "No description supplied";
        }
        return base + name;
    }

    protected static boolean canNetsBeChangedOnThisPin(HierInst<PinTemplate> hierPinTemplate) {
        IOView.AllowNetChangesInIOView method = IOView.AllowNetChangesInIOViewRegistry.getCurrentMethod();
        if (method == null) {
            PinTemplate.Type t = ((PinTemplate)hierPinTemplate.second).getType();
            return t != PinTemplate.Type.BUMPPAD || t == PinTemplate.Type.BUMPPAD && allowBumpsToBeUnlocked;
        }
        return method.allow(hierPinTemplate);
    }

    public static void DisconnectAction(String deviceKey, String pinTemplateKey) {
        PinTemplate pinTemplate;
        Db db = OrbitIO.getCurDb();
        Device device = (Device)db.getByKeyStr(Device.class, deviceKey);
        Net parentNet = NetMap.getParentNet((Device)device, (Net)(pinTemplate = (PinTemplate)db.getByKeyStr(PinTemplate.class, pinTemplateKey)).getNet());
        if (parentNet != null && NetMap.unmap((Device)device, (Net)pinTemplate.getNet(), (Net)parentNet)) {
            ALog.logWarn((String)("Disconnecting pin " + pinTemplate.getName() + "on device " + device.getName()));
        }
    }

    public static DeviceTemplate makeDummyDevice(String substrateName) {
        Substrate s = Substrate.getSubstrate((Db)OrbitIO.getCurDb(), (String)substrateName);
        DeviceTemplate dt = DeviceTemplate.create((Substrate)s, (String)"dummyLefTemplate", (boolean)false);
        PinTemplate pt = PinTemplate.create((Net)dt.getNetUnused(), (String)"PAD");
        pt.setType(PinTemplate.Type.IOPAD);
        return dt;
    }

    public static int comparePinTemplate(PinTemplate p0, PinTemplate p1) {
        if (p0.getType() == p1.getType()) {
            AAlphaNumComp c = AAlphaNumComp.get();
            return c.compare((Object)p0.getName(), (Object)p1.getName());
        }
        if (p0.getType() == PinTemplate.Type.IOPAD) {
            return -1;
        }
        if (p0.getType() == PinTemplate.Type.BUMPPAD && p1.getType() == PinTemplate.Type.IOPAD) {
            return 1;
        }
        if (p0.getType() == PinTemplate.Type.BUMPPAD && p1.getType() != PinTemplate.Type.IOPAD) {
            return -1;
        }
        return 1;
    }

    protected void updateCellName() {
        this.mPinNetModel.load();
    }

    protected void updatePinNetTable() {
        this.mPinNetModel.load();
    }

    protected void updateDefaultTransformFromTemplate() {
        DeviceTemplate dt = (DeviceTemplate)this.mCboTemplate.getSelectedItem();
        if (dt == null) {
            return;
        }
        DeviceTemplate.DefTransform defaultTransform = this.mTemplate2Transform.get(dt);
        if (defaultTransform == null) {
            defaultTransform = (DeviceTemplate.DefTransform)dt.getValue("tech.default_transform");
            if (defaultTransform == null) {
                defaultTransform = DeviceTemplate.DefTransform.N;
            }
            this.mTemplate2Transform.put(dt, defaultTransform);
        }
        this.mSouthTransform.setSelectedItem(defaultTransform);
    }

    protected void setDefaultNets() {
        DeviceTemplate dt = (DeviceTemplate)this.mCboTemplate.getSelectedItem();
        if (dt == null) {
            return;
        }
        for (PinTemplate dtp : dt.getPins()) {
            if (this.mPinNetModel.getNetNameLocked(dtp.getName())) continue;
            boolean justDeviceName = false;
            if (this.mPinNetModel.getPinType(dtp.getName()).equals((Object)PinTemplate.Type.IOPAD)) {
                justDeviceName = true;
            }
            String interfaceName = this.mBlock.parent.getName();
            String stmt = String.format("makeANetName(\"%s\", \"%s\", \"%s\", %b, \"%s\")", dtp.getKeyStr(), this.getValidCellName(), this.mCboModes.getSelectedItem(), justDeviceName, interfaceName);
            Interpreter interpreter = Cp.getCp().getInterpreter();
            String netName = null;
            try {
                netName = (String)interpreter.eval(stmt);
            }
            catch (EvalError e) {
                ALog.logError((Throwable)e, (String)"Error executing makeANetName command for device '%s' pin '%s'.", (Object[])new Object[]{this.mBlock.devicePath, dtp.getKeyStr()});
            }
            if (netName == null) continue;
            this.mPinNetModel.setNetName(dtp.getName(), netName);
        }
        this.mPinNetTable.repaint();
    }

    protected String getValidCellName() {
        return this.mIOCellName.getText().replace(" ", "-");
    }

    /*
     * WARNING - void declaration
     */
    protected void updateUI() {
        Unit unit = Design.getUnit((Db)this.mDb);
        this.mGapDistance.setText(unit.toUserStr(this.mBlock.gap));
        this.mInsetDistance.setText(unit.toUserStr(this.mBlock.inset));
        if (this.create) {
            this.mIOCellName.setText(this.mBlock.getDesiredName());
        } else {
            this.mIOCellName.setText(this.mBlock.getName());
        }
        this.mSetDefaultNets.setEnabled(true);
        this.mSouthTransform.removeAllItems();
        for (DeviceTemplate.DefTransform defTransform : DeviceTemplate.DefTransform.values()) {
            this.mSouthTransform.addItem(defTransform);
        }
        this.mSouthTransform.setSelectedItem(this.mBlock.defaultXform);
        this.mCboTemplate.removeAllItems();
        int numMembers = 0;
        List<DeviceTemplate> list = this.getValidTemplates();
        for (DeviceTemplate deviceTemplate : list) {
            this.mCboTemplate.addItem(deviceTemplate);
            ++numMembers;
        }
        boolean isByTemplate = false;
        Object var5_12 = null;
        if (this.create) {
            if (numMembers > 0) {
                this.mCboTemplate.setSelectedIndex(0);
            } else {
                ALog.logWarn((String)"There does not seem to be any Device Template defined in the substrate");
            }
        } else {
            if (this.mBlock.getDevicePath() == null) {
                return;
            }
            DeviceTemplate deviceTemplate = this.mBlock.getDevicePath().getLast().getTemplate();
            if (deviceTemplate == null) {
                return;
            }
            int index = this.getIndexFor(this.mCboTemplate, deviceTemplate);
            if (index >= 0) {
                this.mTemplate2Transform.put(deviceTemplate, this.mBlock.defaultXform);
                this.mCboTemplate.setSelectedIndex(index);
                isByTemplate = true;
            }
        }
        if (isByTemplate) {
            this.mRbCreateByTemplate.setSelected(true);
        } else {
            this.mRbCreateBySize.setSelected(true);
        }
        this.mCreateByChangeListener.actionPerformed(null);
        if (this.create) {
            this.mRbCreateByTemplate.setSelected(true);
            this.mRbCreateBySize.setSelected(false);
        } else {
            void var5_14;
            ARect r = var5_14.getBB();
            if (isByTemplate) {
                this.mWidth.setText(unit.toUserStr(r.width()));
                this.mHeight.setText(unit.toUserStr(r.height()));
            } else {
                this.mWidth.setText(unit.toUserStr(this.mBlock.width));
                this.mHeight.setText(unit.toUserStr(this.mBlock.height));
            }
        }
    }

    private int getIndexFor(JComboBox<?> cb, DeviceTemplate myT) {
        assert (myT != null);
        for (int i = 0; i < cb.getItemCount(); ++i) {
            if (cb.getItemAt(i) != myT) continue;
            return i;
        }
        return -1;
    }

    protected List<DeviceTemplate> getValidTemplates() {
        Substrate s = this.mBlock.getDie().getSubstrate();
        List<DeviceTemplate> sortedList = this.mDb.getObjects(DeviceTemplate.class).stream().filter(t -> {
            Substrate sub = t.getSubstrate();
            return sub == null || sub.equals((Object)s);
        }).filter(t -> t.getType() != DeviceTemplate.Type.DIE && t.getType() != DeviceTemplate.Type.PACKAGE && t.getType() != DeviceTemplate.Type.BOARD && t.getType() != DeviceTemplate.Type.PERSONALITY && t.getType() != DeviceTemplate.Type.PACKAGEDDIE).filter(t -> t.getType() != DeviceTemplate.Type.PERSONALITY && !Design.getIsDesign((DeviceTemplate)t)).sorted(new TemplateSorter()).collect(Collectors.toList());
        return sortedList;
    }

    protected boolean createBlockFromDialog() {
        long i;
        long g;
        Unit unit = Design.getUnit((Db)this.mDb);
        try {
            AFieldValidator.validateDouble((JTextField)this.mGapDistance);
            AFieldValidator.validateDouble((JTextField)this.mInsetDistance);
        }
        catch (AFieldValidator.AFieldValidationException ve) {
            return false;
        }
        this.mBlock.gap = g = unit.fromUser(Double.parseDouble(this.mGapDistance.getText().replace(",", "")));
        this.mBlock.inset = i = unit.fromUser(Double.parseDouble(this.mInsetDistance.getText().replace(",", "")));
        if (this.mRbCreateBySize.isSelected()) {
            long h;
            long w;
            try {
                AFieldValidator.validateDouble((JTextField)this.mWidth);
                AFieldValidator.validateDouble((JTextField)this.mHeight);
            }
            catch (AFieldValidator.AFieldValidationException ve) {
                return false;
            }
            this.mBlock.width = w = unit.fromUser(Double.parseDouble(this.mWidth.getText().replace(",", "")));
            this.mBlock.height = h = unit.fromUser(Double.parseDouble(this.mHeight.getText().replace(",", "")));
            if (this.create) {
                this.mBlock.byTemplate = false;
            }
        } else {
            this.mBlock.template = (DeviceTemplate)this.mCboTemplate.getSelectedItem();
            this.mBlock.byTemplate = true;
            this.mBlock.mMode = this.mCboModes.isEnabled() ? "" + this.mCboModes.getSelectedItem() : null;
        }
        this.mBlock.pinAttributes.clear();
        ArrayList<String> pinNames = this.mPinNetModel.getPins();
        ArrayList<String> netNames = this.mPinNetModel.getNets();
        int ith = 0;
        for (String netName : netNames) {
            PinTemplate pt;
            if (!netName.equals("NetUnused")) {
                if (!netName.isEmpty()) {
                    IOViewBlock.PinAttribute pdef = new IOViewBlock.PinAttribute();
                    this.mBlock.pinAttributes.add(pdef);
                    pdef.pinName = pinNames.get(ith);
                    pdef.netName = netName;
                    pdef.changed = true;
                    pdef.locked = this.mPinNetModel.getNetNameLocked(pdef.pinName);
                }
                pt = this.mPinNetModel.getPinTemplate(pinNames.get(ith));
                pt.setType(this.mPinNetModel.getPinType(pinNames.get(ith)));
            }
            if ((pt = this.mPinNetModel.getPinTemplate(pinNames.get(ith))).getType() != this.mPinNetModel.getPinType(pinNames.get(ith))) {
                pt.setType(this.mPinNetModel.getPinType(pinNames.get(ith)));
            }
            ++ith;
        }
        this.mBlock.setDesiredName(this.getValidCellName());
        this.mBlock.setDefaultXForm((DeviceTemplate.DefTransform)this.mSouthTransform.getSelectedItem());
        return true;
    }

    protected class SelectTemplateDialog
    extends ADialog {
        protected JRadioButton mRbHighlight;
        protected JRadioButton mRbFilter;
        protected RegexFilterField mFilterField;
        protected BiMap<DeviceTemplate.Type, JCheckBox> mTemplateTypeCheckBoxes;
        protected AList<DeviceTemplate> mLstTemplates;
        protected AListModel<DeviceTemplate> mLstModelTemplates;
        protected List<DeviceTemplate> mAllTemplates;
        protected LinkedHashSet<DeviceTemplate> mSelectedTemplates;
        protected boolean mOK;
        protected Color mHighlightColor;
        protected ActionListener mOkListener;
        protected RegexFilterField.FilterListener mFilterListener;
        ActionListener mFilterHighlightChanged;

        public SelectTemplateDialog() {
            super(IOViewEditBlockDlg.this.mCboTemplate);
            this.mTemplateTypeCheckBoxes = HashBiMap.create();
            this.mAllTemplates = IOViewEditBlockDlg.this.getValidTemplates();
            this.mOK = false;
            this.mHighlightColor = new Color(0x77FF77);
            this.mOkListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SelectTemplateDialog.this.mOK = true;
                    UIUtil.closeWindow((Window)((Object)SelectTemplateDialog.this));
                }
            };
            this.mFilterListener = new RegexFilterField.FilterListener(){

                public void filter(Pattern pattern) {
                    int oldSel = SelectTemplateDialog.this.mLstTemplates.getSelectedIndex();
                    LinkedList<DeviceTemplate> included = new LinkedList<DeviceTemplate>();
                    SelectTemplateDialog.this.mSelectedTemplates = new LinkedHashSet();
                    for (DeviceTemplate t : SelectTemplateDialog.this.mAllTemplates) {
                        if (!SelectTemplateDialog.this.includeByType(t) || !SelectTemplateDialog.this.includeByPattern(pattern, t)) continue;
                        included.add(t);
                    }
                    SelectTemplateDialog.this.mLstModelTemplates.setContents(included);
                    if (oldSel >= included.size()) {
                        oldSel = -1;
                    }
                    if (!SelectTemplateDialog.this.mRbHighlight.isSelected()) {
                        SelectTemplateDialog.this.mSelectedTemplates = null;
                        if (oldSel < 0 && SelectTemplateDialog.this.mLstModelTemplates.getSize() > 0) {
                            SelectTemplateDialog.this.mLstTemplates.setSelectedIndex(0);
                            SelectTemplateDialog.this.mLstTemplates.ensureIndexIsVisible(0);
                        }
                    } else {
                        for (DeviceTemplate t : included) {
                            if (pattern != null && !pattern.matcher(t.getName()).matches()) continue;
                            SelectTemplateDialog.this.mSelectedTemplates.add(t);
                        }
                        if (!(SelectTemplateDialog.this.mSelectedTemplates.size() <= 0 || oldSel > 0 && SelectTemplateDialog.this.mSelectedTemplates.contains(included.get(oldSel)))) {
                            DeviceTemplate firstSel = (DeviceTemplate)SelectTemplateDialog.this.mSelectedTemplates.iterator().next();
                            int i = SelectTemplateDialog.this.mLstModelTemplates.indexOf(firstSel);
                            SelectTemplateDialog.this.mLstTemplates.setSelectedIndex(i);
                            SelectTemplateDialog.this.mLstTemplates.ensureIndexIsVisible(i);
                        }
                        SelectTemplateDialog.this.repaint();
                    }
                }
            };
            this.mFilterHighlightChanged = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SelectTemplateDialog.this.mFilterField.updateFilteredData();
                    SelectTemplateDialog.this.mLstTemplates.repaint();
                }
            };
            this.setModal(true);
            this.setTitle("Select Template");
            GridBagManager l = GridBagManager.layout((JDialog)((Object)this));
            Insets indentInsets = new Insets(0, 12, 0, 0);
            l.push("Search Options", (GridBagConstraints)GridBagManager.FILLX_REMAINX.noInsets());
            l.add("Show types:");
            l.newline();
            l.push((GridBagConstraints)GridBagManager.LEFT_REMAINX.insets(indentInsets));
            Insets in = new Insets(0, 0, 0, 0);
            GridBagManager.GridBagConstraintsEx cs = GridBagManager.LEFT.insets(in);
            l.add((Component)this.createTemplateTypeCheckBox(DeviceTemplate.Type.COVER), (GridBagConstraints)cs);
            l.add((Component)this.createTemplateTypeCheckBox(DeviceTemplate.Type.RING), (GridBagConstraints)cs);
            l.add((Component)this.createTemplateTypeCheckBox(DeviceTemplate.Type.BLOCK), (GridBagConstraints)cs);
            l.add((Component)this.createTemplateTypeCheckBox(DeviceTemplate.Type.PAD), (GridBagConstraints)cs);
            l.newline();
            l.add((Component)this.createTemplateTypeCheckBox(DeviceTemplate.Type.ENDCAP), (GridBagConstraints)cs);
            l.add((Component)this.createTemplateTypeCheckBox(DeviceTemplate.Type.CORE), (GridBagConstraints)cs);
            l.add((Component)this.createTemplateTypeCheckBox(DeviceTemplate.Type.BUMP), (GridBagConstraints)cs);
            l.add((Component)this.createTemplateTypeCheckBox(DeviceTemplate.Type.MACRO), (GridBagConstraints)cs);
            l.newline();
            l.add((Component)this.createTemplateTypeCheckBox(DeviceTemplate.Type.STDCELL), (GridBagConstraints)cs);
            l.pop();
            l.addFillX();
            l.newline();
            l.push((GridBagConstraints)GridBagManager.FILLX_REMAINX.noInsets());
            l.add("Pattern:");
            this.mFilterField = (RegexFilterField)l.add((Component)new RegexFilterField(this.mFilterListener), (GridBagConstraints)GridBagManager.FILLX.noInsets());
            l.newline();
            l.push((GridBagConstraints)GridBagManager.LEFT_REMAINX.insets(indentInsets));
            l.add("Use pattern to: ");
            this.mRbFilter = (JRadioButton)l.add((Component)new JRadioButton("Filter"), (GridBagConstraints)GridBagManager.LEFT.noInsets());
            this.mRbHighlight = (JRadioButton)l.add((Component)new JRadioButton("Highlight"), (GridBagConstraints)GridBagManager.LEFT.noInsets());
            UIUtil.groupButtons((AbstractButton[])new AbstractButton[]{this.mRbFilter, this.mRbHighlight});
            this.mRbFilter.addActionListener(this.mFilterHighlightChanged);
            this.mRbHighlight.addActionListener(this.mFilterHighlightChanged);
            this.mRbFilter.setSelected(true);
            l.pop();
            l.pop();
            l.popNl();
            l.addNl("Select Template:");
            this.mLstTemplates = new AList();
            l.add((Component)new JScrollPane(this.mLstTemplates), (GridBagConstraints)GridBagManager.FILLALL_REMAINX);
            this.mLstModelTemplates = new AListModel<DeviceTemplate>(this.mAllTemplates);
            this.mLstTemplates.setModel(this.mLstModelTemplates);
            this.mLstTemplates.setSelectionMode(0);
            this.mLstTemplates.setCellRenderer(new TemplateListRenderer(){

                @Override
                public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    Component c = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                    if (SelectTemplateDialog.this.mRbHighlight.isSelected() && (SelectTemplateDialog.this.mSelectedTemplates == null || SelectTemplateDialog.this.mSelectedTemplates.contains(value))) {
                        Color bg = AColor.mix((Color)c.getBackground(), (Color)SelectTemplateDialog.this.mHighlightColor, (float)0.66f);
                        c.setBackground(bg);
                    }
                    return c;
                }
            });
            this.mLstTemplates.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getButton() == 1 && e.getClickCount() == 2) {
                        SelectTemplateDialog.this.mOkListener.actionPerformed(new ActionEvent(e.getSource(), 1001, "DoubleClick", e.getWhen(), e.getModifiers()));
                    }
                }
            });
            l.newline();
            l.pushFillXRemainX();
            l.addFillX();
            JButton btnOK = (JButton)l.add((Component)new JButton("OK"));
            JButton btnCancel = (JButton)l.add((Component)new JButton("Cancel"));
            l.pop();
            UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnCancel, (JButton)btnOK);
            this.pack();
            UIUtil.center((Component)((Object)this));
            btnOK.addActionListener(this.mOkListener);
        }

        public void addNotify() {
            super.addNotify();
            this.mFilterField.requestFocus();
        }

        public boolean doModal() {
            this.mLstTemplates.setSelectedValue(IOViewEditBlockDlg.this.mCboTemplate.getSelectedItem(), true);
            this.setVisible(true);
            return this.mOK;
        }

        public DeviceTemplate getSelectedTemplate() {
            if (!this.mOK) {
                return null;
            }
            return (DeviceTemplate)this.mLstTemplates.getSelectedValue();
        }

        protected JCheckBox createTemplateTypeCheckBox(DeviceTemplate.Type dtt) {
            JCheckBox cb = new JCheckBox(dtt.name(), true);
            cb.addActionListener(this.mFilterHighlightChanged);
            this.mTemplateTypeCheckBoxes.put((Object)dtt, (Object)cb);
            return cb;
        }

        protected boolean includeByType(DeviceTemplate t) {
            JCheckBox cb = (JCheckBox)this.mTemplateTypeCheckBoxes.get((Object)t.getType());
            if (cb == null) {
                return false;
            }
            return cb.isSelected();
        }

        protected boolean includeByPattern(Pattern pattern, DeviceTemplate t) {
            if (!this.mRbFilter.isSelected()) {
                return true;
            }
            return pattern == null || pattern.matcher(t.getName()).matches();
        }
    }

    public static class TransformRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent(list, (Object)null, index, isSelected, cellHasFocus);
            DeviceTemplate.DefTransform t = (DeviceTemplate.DefTransform)value;
            if (t == null) {
                t = DeviceTemplate.DefTransform.N;
            }
            this.setText(t.shortDescriptor());
            this.setIcon(OrbitIcons.getDefTransformIcon(t));
            return this;
        }
    }

    public static class TemplateSorter
    implements Comparator<DeviceTemplate> {
        @Override
        public int compare(DeviceTemplate dt0, DeviceTemplate dt1) {
            int usage1;
            int usage0 = dt0.getDeviceInstanceCount();
            if (usage0 > (usage1 = dt1.getDeviceInstanceCount())) {
                return -1;
            }
            if (usage1 > usage0) {
                return 1;
            }
            int c = dt0.getType().compareTo((Enum)dt1.getType());
            if (c == 0) {
                c = dt0.getName().compareTo(dt1.getName());
            }
            return c;
        }
    }

    public static class IOViewPinTemplateSorter
    implements Comparator<PinTemplate> {
        @Override
        public int compare(PinTemplate p0, PinTemplate p1) {
            return IOViewEditBlockDlg.comparePinTemplate(p0, p1);
        }
    }

    public static class IOViewTechnologyFileSorter
    implements Comparator<PinDescriptor> {
        @Override
        public int compare(PinDescriptor p0, PinDescriptor p1) {
            return PinDefinition.compareByTechnologyFileOrder(p0.pt, p1.pt);
        }
    }

    public static class IOViewPinDescSorter
    implements Comparator<PinDescriptor> {
        @Override
        public int compare(PinDescriptor p0, PinDescriptor p1) {
            return IOViewEditBlockDlg.comparePinTemplate(p0.pt, p1.pt);
        }
    }

    public static class IOViewPinAttrSorter
    implements Comparator<IOViewBlock.PinAttribute> {
        DeviceTemplate dt;

        public IOViewPinAttrSorter(DeviceTemplate dt) {
            this.dt = dt;
        }

        @Override
        public int compare(IOViewBlock.PinAttribute p0, IOViewBlock.PinAttribute p1) {
            int result = p1.parentNetName.compareTo(p0.parentNetName);
            if (result == 0) {
                PinTemplate pt0 = this.dt.getPinByName(p0.pinName);
                PinTemplate pt1 = this.dt.getPinByName(p1.pinName);
                return IOViewEditBlockDlg.comparePinTemplate(pt0, pt1);
            }
            return result;
        }
    }

    class PinNetModel
    extends AbstractTableModel {
        protected IOViewBlock block;
        ArrayList<PinDescriptor> pinNetNames = new ArrayList();
        private String[] columnNames = new String[]{"", "", "", "Pin", "Net Name"};

        public PinNetModel(IOViewBlock block) {
            this.block = block;
        }

        public void load() {
            this.pinNetNames.clear();
            DeviceTemplate dt = null;
            HashSet<PinTemplate> ioPorts = new HashSet<PinTemplate>();
            if (IOViewEditBlockDlg.this.mRbCreateBySize.isSelected()) {
                dt = DeviceTemplate.getDeviceTemplate((Substrate)IOViewEditBlockDlg.this.mBlock.getDie().getSubstrate(), (String)"dummyLefTemplate");
                if (dt == null) {
                    dt = (DeviceTemplate)Cp.exec(() -> IOViewEditBlockDlg.makeDummyDevice(IOViewEditBlockDlg.this.mBlock.getDevicePath().getLast().getSubstrate().getName()), (String)"com.sigrity.orbit.iov.IOViewEditBlockDlg.makeDummyDevice(\"%s\")", (Object[])new Object[]{IOViewEditBlockDlg.this.mBlock.getDevicePath().getLast().getSubstrate().getName()});
                }
                PinDescriptor pnn = new PinDescriptor();
                pnn.pt = dt.getPinByName("PAD");
                pnn.pinName = pnn.pt.getName();
                this.pinNetNames.add(pnn);
                pnn.type = pnn.pt.getType();
                ioPorts.add(pnn.pt);
            } else {
                dt = (DeviceTemplate)IOViewEditBlockDlg.this.mCboTemplate.getSelectedItem();
                if (dt == null) {
                    return;
                }
                ioPorts.addAll(dt.getIOPorts());
                for (PinTemplate dtp : dt.getPins()) {
                    PinDescriptor pnn = new PinDescriptor();
                    pnn.pinName = dtp.getName();
                    this.pinNetNames.add(pnn);
                    HashMap mode2net = (HashMap)dtp.getValue("IOView.Modes");
                    pnn.modeControlled = mode2net != null;
                    pnn.pt = dtp;
                    pnn.type = dtp.getType();
                    if (!ioPorts.contains(dtp)) continue;
                    pnn.type = PinTemplate.Type.IOPAD;
                }
            }
            if (IOView.theIOView.getDisplayInTechnologyOrder()) {
                Collections.sort(this.pinNetNames, new IOViewTechnologyFileSorter());
            } else {
                Collections.sort(this.pinNetNames, new IOViewPinDescSorter());
            }
            for (PinDescriptor pnn : this.pinNetNames) {
                String pinName = pnn.pinName;
                pnn.locked = false;
                PinTemplate dtp = dt.getPinByName(pinName);
                if (!IOViewEditBlockDlg.this.create && dt.equals(this.block.devicePath.getLast().getTemplate())) {
                    int num;
                    Device d = IOViewEditBlockDlg.this.mBlock.getDevicePath().getLast();
                    PinInstance dp = d.getPin(dtp);
                    PinInstance.NetSetterType t = dp.getNetSetterType();
                    if (t != null && t == PinInstance.NetSetterType.INTERACTIVE_USER) {
                        pnn.locked = true;
                    }
                    if (dtp.getType() == PinTemplate.Type.BUMPPAD) {
                        pnn.locked = true;
                    }
                    Net topNet = NetMap.getNetAt((Net)dtp.getNet(), (DevicePath)IOViewEditBlockDlg.this.mBlock.getDevicePath(), (DeviceTemplate)IOViewEditBlockDlg.this.mBlock.getDevicePath().getFirst().getTemplate());
                    pnn.netName = topNet.getName();
                    pnn.connectedCount = num = dtp.getNet().isUnused() ? 0 : NetMap.getConnectedDevicePathPortsCount((Net)dtp.getNet(), (DevicePath)IOViewEditBlockDlg.this.mBlock.getDevicePath(), (int)2);
                    pnn.topNet = pnn.connectedCount > 0 ? topNet : null;
                    pnn.edited = false;
                    if (topNet.getDeviceTemplate() == IOViewEditBlockDlg.this.mBlock.getDevicePath().getFirst().getTemplate()) continue;
                    pnn.netName = "NetUnused";
                    pnn.topNet = topNet;
                    continue;
                }
                String netName = "NetUnused";
                String currentCellName = IOViewEditBlockDlg.this.getValidCellName();
                if (ioPorts.contains(dtp)) {
                    netName = IOView.createDefaultNetNameForIOPAD(IOViewEditBlockDlg.this.mBlock.parent.getName(), currentCellName, dtp, new LinkedList<PinTemplate>(ioPorts));
                }
                pnn.locked = false;
                pnn.netName = netName;
            }
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public Class<?> getRowClass(int r) {
            return this.getValueAt(r, 4).getClass();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 4;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (col == 4) {
                String newValue = (String)value;
                boolean changed = !this.pinNetNames.get((int)row).netName.equals(newValue = newValue.replace(" ", ""));
                this.pinNetNames.get((int)row).netName = newValue;
                if (changed) {
                    this.pinNetNames.get((int)row).locked = true;
                }
                if (changed) {
                    this.pinNetNames.get((int)row).edited = true;
                }
            } else if (col == 2) {
                // empty if block
            }
        }

        @Override
        public int getRowCount() {
            return this.pinNetNames.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 3) {
                return this.pinNetNames.get((int)rowIndex).pinName;
            }
            return this.pinNetNames.get((int)rowIndex).netName;
        }

        protected PinDescriptor getByPinName(String pinName) {
            for (PinDescriptor pnn : this.pinNetNames) {
                if (!pnn.pinName.equals(pinName)) continue;
                return pnn;
            }
            return null;
        }

        public ArrayList<String> getPins() {
            ArrayList<String> pinNames = new ArrayList<String>();
            for (PinDescriptor pnn : this.pinNetNames) {
                pinNames.add(pnn.pinName);
            }
            return pinNames;
        }

        public ArrayList<String> getNets() {
            ArrayList<String> netNames = new ArrayList<String>();
            for (PinDescriptor pnn : this.pinNetNames) {
                netNames.add(pnn.netName);
            }
            return netNames;
        }

        public void setNetName(String pinName, String netName) {
            PinDescriptor pnn = this.getByPinName(pinName);
            pnn.netName = netName;
        }

        public boolean getLocked(int row) {
            return this.pinNetNames.get((int)row).locked;
        }

        public void setLocked(int row, boolean v) {
            this.pinNetNames.get((int)row).locked = v;
        }

        public PinTemplate getPinTemplate(String name) {
            return this.getByPinName((String)name).pt;
        }

        public PinTemplate.Type getPinType(int row) {
            return this.pinNetNames.get((int)row).type;
        }

        public void setPinType(int row, PinTemplate.Type t) {
            this.pinNetNames.get((int)row).type = t;
        }

        public boolean getNetNameLocked(String pinName) {
            return this.getByPinName((String)pinName).locked;
        }

        public PinTemplate.Type getPinType(String pinName) {
            return this.getByPinName((String)pinName).type;
        }

        public boolean getPinModeControlled(String pinName) {
            return this.getByPinName((String)pinName).modeControlled;
        }

        public int getConnectedCount(String pinName) {
            return this.getByPinName((String)pinName).connectedCount;
        }

        public boolean getNetNameLocked(int row) {
            return this.pinNetNames.get((int)row).locked;
        }

        public int getConnectedCount(int row) {
            return this.pinNetNames.get((int)row).connectedCount;
        }

        public Net getTopNet(String pinName) {
            return this.getByPinName((String)pinName).topNet;
        }

        public Net getTopNet(int row) {
            return this.pinNetNames.get((int)row).topNet;
        }

        public boolean getEdited(int row) {
            return this.pinNetNames.get((int)row).edited;
        }
    }

    public class PinDescriptor {
        PinTemplate pt;
        PinTemplate.Type type;
        String pinName;
        String netName;
        boolean modeControlled;
        boolean locked;
        boolean edited = false;
        int connectedCount = 0;
        Net topNet = null;
    }

    class DisconnectActionListener
    implements ActionListener {
        int row;

        public DisconnectActionListener(int row) {
            this.row = row;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Device d = IOViewEditBlockDlg.this.mBlock.getDevicePath().getLast();
            PinDescriptor pd = IOViewEditBlockDlg.this.mPinNetModel.pinNetNames.get(this.row);
            PinTemplate pt = pd.pt;
            String deviceKey = d.getKeyStr();
            String pinTemplateKey = pt.getKeyStr();
            Cp.exec(() -> IOViewEditBlockDlg.DisconnectAction(deviceKey, pinTemplateKey), (String)"com.sigrity.orbit.iov.IOViewEditBlockDlg.DisconnectAction(\"%s\", \"%s\");", (Object[])new Object[]{deviceKey, pinTemplateKey});
            IOViewEditBlockDlg.this.updateUI();
            OrbitIO.getApp().refreshCurrentView(false);
        }
    }

    class TableButtonMouseListener
    extends MouseAdapter {
        protected JTable table;
        JPopupMenu popup;

        public TableButtonMouseListener(JTable table) {
            this.table = table;
        }

        protected void showPopup(MouseEvent e) {
            int row = e.getY() / this.table.getRowHeight();
            if (row >= this.table.getRowCount()) {
                return;
            }
            this.popup = new JPopupMenu();
            PinTemplate pt = IOViewEditBlockDlg.this.mPinNetModel.pinNetNames.get((int)row).pt;
            JMenuItem disconnectMenuItem = new JMenuItem("Disconnect " + pt.getName());
            disconnectMenuItem.addActionListener(new DisconnectActionListener(row));
            this.popup.add(disconnectMenuItem);
            this.popup.show(e.getComponent(), e.getX(), e.getY());
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.showPopup(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.showPopup(e);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.showPopup(e);
            } else {
                TableColumnModel columnModel = this.table.getColumnModel();
                int column = columnModel.getColumnIndexAtX(e.getX());
                int row = e.getY() / this.table.getRowHeight();
                if (column == 2) {
                    if (row >= 0 && row < IOViewEditBlockDlg.this.mPinNetModel.getRowCount()) {
                        PinTemplate pt = IOViewEditBlockDlg.this.mPinNetModel.pinNetNames.get((int)row).pt;
                        HierInst hierPinTemplate = new HierInst(IOViewEditBlockDlg.this.mBlock.devicePath, (DbObject)pt);
                        if (IOViewEditBlockDlg.canNetsBeChangedOnThisPin((HierInst<PinTemplate>)hierPinTemplate)) {
                            IOViewEditBlockDlg.this.mPinNetModel.setLocked(row, !IOViewEditBlockDlg.this.mPinNetModel.getLocked(row));
                        }
                        IOViewEditBlockDlg.this.mPinNetTable.repaint();
                    }
                } else if (column == 0) {
                    if (row >= 0 && row < IOViewEditBlockDlg.this.mPinNetModel.getRowCount()) {
                        PinTemplate.Type t = IOViewEditBlockDlg.this.mPinNetModel.getPinType(row);
                        if (t == PinTemplate.Type.TSV) {
                            IOViewEditBlockDlg.this.mPinNetModel.setPinType(row, PinTemplate.Type.UNKNOWN);
                        } else if (t == PinTemplate.Type.IOPAD) {
                            IOViewEditBlockDlg.this.mPinNetModel.setPinType(row, PinTemplate.Type.BUMPPAD);
                        } else if (t == PinTemplate.Type.BUMPPAD) {
                            IOViewEditBlockDlg.this.mPinNetModel.setPinType(row, PinTemplate.Type.TSV);
                        } else {
                            IOViewEditBlockDlg.this.mPinNetModel.setPinType(row, PinTemplate.Type.IOPAD);
                        }
                        IOViewEditBlockDlg.this.mPinNetTable.repaint();
                    }
                } else if (column == 1 && IOViewEditBlockDlg.this.mPinNetModel.getConnectedCount(row) > 1) {
                    Net topNet = IOViewEditBlockDlg.this.mPinNetModel.getTopNet(row);
                    AFloatWindow dlg = new AFloatWindow((Window)((Object)IOViewEditBlockDlg.this), topNet.getName() + " Net Graph", Dialog.ModalityType.MODELESS);
                    NetGraphPanel ngp = new NetGraphPanel(topNet, IOViewEditBlockDlg.this.mBlock.getDevicePath());
                    GridBagManager l = new GridBagManager(dlg.getContentPane());
                    l.add((Component)ngp, (GridBagConstraints)GridBagManager.FILLALL);
                    dlg.pack();
                    UIUtil.center((Component)((Object)dlg));
                    dlg.setVisible(true);
                }
            }
        }
    }

    class TableMouseMotionListener
    implements MouseMotionListener {
        protected JTable table;

        public TableMouseMotionListener(JTable table) {
            this.table = table;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            TableColumnModel columnModel = this.table.getColumnModel();
            int column = columnModel.getColumnIndexAtX(e.getX());
            int row = e.getY() / this.table.getRowHeight();
            if (row >= IOViewEditBlockDlg.this.mPinNetModel.getRowCount()) {
                return;
            }
            IOViewEditBlockDlg.this.setCursor(Cursor.getPredefinedCursor(0));
            if (column == 2) {
                IOViewEditBlockDlg.this.setCursor(Cursor.getPredefinedCursor(12));
            } else if (column == 0) {
                IOViewEditBlockDlg.this.setCursor(Cursor.getPredefinedCursor(12));
            } else if (column == 1) {
                if (IOViewEditBlockDlg.this.mPinNetModel.getConnectedCount(row) > 1) {
                    IOViewEditBlockDlg.this.setCursor(Cursor.getPredefinedCursor(12));
                }
            } else if (column == 4) {
                IOViewEditBlockDlg.this.setCursor(Cursor.getPredefinedCursor(12));
            }
        }
    }

    class EditorBorder
    extends AbstractBorder {
        protected Insets editorBorderInsets = new Insets(4, 2, 4, 0);

        EditorBorder() {
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            g.translate(x, y);
            g.setColor(MetalLookAndFeel.getControlDarkShadow());
            g.drawLine(0, 0, w - 1, 0);
            g.drawLine(0, 0, 0, h - 2);
            g.drawLine(0, h - 2, w - 1, h - 2);
            g.setColor(MetalLookAndFeel.getControlHighlight());
            g.drawLine(1, 1, w - 1, 1);
            g.drawLine(1, 1, 1, h - 1);
            g.drawLine(1, h - 1, w - 1, h - 1);
            g.setColor(MetalLookAndFeel.getControl());
            g.drawLine(1, h - 2, 1, h - 2);
            g.translate(-x, -y);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.editorBorderInsets;
        }
    }

    public class MyTableRenderer
    extends JLabel
    implements TableCellRenderer {
        protected DeviceTemplate lastDT = null;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object o, boolean isSelected, boolean hasFocus, int row, int column) {
            DeviceTemplate dt;
            String pinName = IOViewEditBlockDlg.this.mPinNetModel.getPins().get(row);
            this.setForeground(Color.BLACK);
            this.setFont(this.getFont().deriveFont(0));
            this.setToolTipText("");
            DeviceTemplate deviceTemplate = dt = !IOViewEditBlockDlg.this.mRbCreateBySize.isSelected() ? (DeviceTemplate)IOViewEditBlockDlg.this.mCboTemplate.getSelectedItem() : DeviceTemplate.getDeviceTemplate((Substrate)IOViewEditBlockDlg.this.mBlock.getDie().getSubstrate(), (String)"dummyLefTemplate");
            if (dt == null) {
                return this;
            }
            if (column == 0) {
                PinTemplate.Type pinType = IOViewEditBlockDlg.this.mPinNetModel.getPinType(pinName);
                if (pinType == PinTemplate.Type.BUMPPAD) {
                    this.setIcon(DBEResources.ICON_BUMP);
                } else if (pinType == PinTemplate.Type.IOPAD) {
                    this.setIcon(DBEResources.ICON_PAD);
                } else if (pinType == PinTemplate.Type.TSV) {
                    this.setIcon(DBEResources.ICON_TSV);
                } else {
                    this.setIcon(OrbitIcons.BLANK16x16);
                }
                this.setText("");
            } else if (column == 3) {
                boolean pinModeControlled = IOViewEditBlockDlg.this.mPinNetModel.getPinModeControlled(pinName);
                if (pinModeControlled) {
                    this.setIcon(OrbitIcons.WRENCH);
                } else {
                    this.setIcon((Icon)new AColorIcon(16, 16, Color.white, Color.white));
                    String userFunction = dt.getPinByName(pinName).getUserFunction();
                    if (userFunction != null && !userFunction.isEmpty()) {
                        PinTemplate.Direction dirEnum = dt.getPinByName(pinName).getDirection();
                        String direction = "inout";
                        if (dirEnum.equals((Object)PinTemplate.Direction.IN)) {
                            direction = "input";
                        } else if (dirEnum.equals((Object)PinTemplate.Direction.OUT)) {
                            direction = "output";
                        }
                        String toolTip = "<html>Name: " + pinName + "<br>Function: " + userFunction + "<br>Direction: " + direction + "</html>";
                        this.setToolTipText(toolTip);
                    }
                }
                this.setText(pinName);
            } else if (column == 4) {
                boolean locked;
                Net topNet;
                this.setIcon(null);
                this.setText((String)o);
                if (IOView.theIOView.getShowTopLevelNetIcon() && (topNet = IOViewEditBlockDlg.this.mPinNetModel.getTopNet(pinName)) != null) {
                    if (topNet.getDeviceTemplate().equals(dt)) {
                        this.setText("NetUnused");
                    } else {
                        DeviceTemplate thisDt = topNet.getDeviceTemplate();
                        this.setIcon(DbExplorerPanel.getIconForTemplate(thisDt));
                        if (IOViewEditBlockDlg.this.mPinNetModel.getEdited(row)) {
                            this.setFont(this.getFont().deriveFont(2));
                            this.setText((String)o);
                        } else {
                            this.setFont(this.getFont().deriveFont(0));
                            this.setText(topNet.getName());
                        }
                    }
                }
                if (locked = IOViewEditBlockDlg.this.mPinNetModel.getNetNameLocked(pinName)) {
                    this.setForeground(Color.GRAY);
                } else {
                    this.setForeground(Color.BLACK);
                }
            } else if (column == 2) {
                this.setIcon((Icon)new AColorIcon(16, 16, Color.white, Color.white));
                this.setText("");
                boolean locked = IOViewEditBlockDlg.this.mPinNetModel.getNetNameLocked(pinName);
                if (locked) {
                    this.setIcon(OrbitIcons.LOCK);
                }
            } else if (column == 1) {
                int connectedCount = IOViewEditBlockDlg.this.mPinNetModel.getConnectedCount(pinName);
                this.setText("");
                if (connectedCount >= 2) {
                    this.setIcon(IOViewEditBlockDlg.this.ICON_CONNECTED);
                    Cursor.getPredefinedCursor(12);
                } else {
                    this.setIcon(null);
                }
                this.setToolTipText("There are " + connectedCount + " pins connected to this net");
            }
            return this;
        }
    }

    public class NetNameEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        JComponent component = new JTextField();

        public NetNameEditor() {
            JTextField ftf = (JTextField)this.component;
            ftf.setBorder(new EditorBorder());
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int rowIndex, int vColIndex) {
            ((JTextField)this.component).setText((String)value);
            boolean locked = IOViewEditBlockDlg.this.mPinNetModel.getNetNameLocked(rowIndex);
            if (locked) {
                ((JTextField)this.component).setEditable(false);
                ((JTextField)this.component).setBorder(null);
            } else {
                ((JTextField)this.component).setEditable(true);
                ((JTextField)this.component).setBorder(new EditorBorder());
            }
            return this.component;
        }

        @Override
        public Object getCellEditorValue() {
            return ((JTextField)this.component).getText();
        }
    }

    public class ColumnHeaderRender
    implements TableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (IOViewEditBlockDlg.this.tcr == null) {
                return null;
            }
            Component component = IOViewEditBlockDlg.this.tcr.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            JLabel label = null;
            if (!(component instanceof JLabel)) {
                return null;
            }
            label = (JLabel)component;
            if (column == 0) {
                label.setText("");
                label.setIcon(OrbitIcons.PIN);
                label.setToolTipText("The Type of pin either PIN, BUMP, or something else. Clicking in the cell cycles the type ");
            } else if (column == 1) {
                label.setText("");
                label.setIcon(IOViewEditBlockDlg.this.ICON_MAP);
                label.setToolTipText("If checked this pin is connected elsewhere");
            } else if (column == 2) {
                label.setText("");
                label.setIcon(OrbitIcons.LOCK);
                label.setToolTipText("If locked, the net can not be changed by setting default net names, nor can one be typed in. Other processes may set the net though.");
            } else if (column == 3) {
                label.setIcon(null);
                label.setText("Pin Name");
                label.setToolTipText("The name of the pin as defined by the .lef macro");
            } else {
                label.setIcon(null);
                label.setText("Net Name");
                label.setToolTipText("The name of the net connected to this pin at the die level");
            }
            return component;
        }
    }
}

