/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.iov;

import com.sigrity.acl.Unit;
import com.sigrity.acl.app.AAppView;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.NamedGrid;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.ui.ADialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.iov.IOView;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.HeadlessException;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class IOViewOptionsDlg
extends ADialog {
    protected AAppView mView;
    protected IOView mIOView = null;
    protected JRadioButton mPeripheralIO;
    protected JCheckBox mAutoResizeDie;
    protected JCheckBox mAvoidOverlap;
    protected JCheckBox mManageCoreDeviceLocation;
    protected JCheckBox mShowTemplateNames;
    protected JCheckBox mShowInstanceNames;
    protected JCheckBox mColorByPass;
    protected JCheckBox mShowByDefinitionOrder;
    protected JCheckBox mDisplayPinsInTechnologyOrder;
    protected JCheckBox mShowTopLevelNetIcon;
    protected JCheckBox mCreateDefaultNN;
    protected JCheckBox mAddInterfaceNames;
    protected JCheckBox mHideOutsideSubstrate;
    private JCheckBox mExcludeNotEdgeAlignedCoverDevices;
    private JCheckBox mExcludeNotEdgeAlignedBumpDevices;
    protected GridPanel mGridPanel;
    protected JButton btnClose;
    protected JButton btnOk;
    protected ActionListener mOk = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            IOViewOptionsDlg.this.mGridPanel.saveGrid();
            Substrate s = IOViewOptionsDlg.this.mIOView.getSubstrate();
            s.setValue("IOView.AutoSize", (Object)IOViewOptionsDlg.this.mAutoResizeDie.isSelected());
            s.setValue("IOView.AvoidOverlaps", (Object)IOViewOptionsDlg.this.mAvoidOverlap.isSelected());
            s.setValue("IOView.ShowDeviceNames", (Object)IOViewOptionsDlg.this.mShowInstanceNames.isSelected());
            s.setValue("IOView.ShowTemplateNames", (Object)IOViewOptionsDlg.this.mShowTemplateNames.isSelected());
            s.setValue("IOView.CreateDefaultNets", (Object)IOViewOptionsDlg.this.mCreateDefaultNN.isSelected());
            s.setValue("IOView.AddInterfaceNames", (Object)IOViewOptionsDlg.this.mAddInterfaceNames.isSelected());
            s.setValue("IOView.ColorByPass", (Object)IOViewOptionsDlg.this.mColorByPass.isSelected());
            s.setValue("IOView.ShowByDefinitionOrder", (Object)IOViewOptionsDlg.this.mShowByDefinitionOrder.isSelected());
            s.setValue("IOView.DisplayPinsInTechnologyOrder", (Object)IOViewOptionsDlg.this.mDisplayPinsInTechnologyOrder.isSelected());
            s.setValue("IOView.ShowTopLevelNetIcon", (Object)IOViewOptionsDlg.this.mShowTopLevelNetIcon.isSelected());
            s.setValue("IOView.HideConnectionsOutside", (Object)IOViewOptionsDlg.this.mHideOutsideSubstrate.isSelected());
            s.setValue("IOView.ExcludeNotEdgeAlignedCoverDevices", (Object)IOViewOptionsDlg.this.mExcludeNotEdgeAlignedCoverDevices.isSelected());
            s.setValue("IOView.ExcludeNotEdgeAlignedBumpDevices", (Object)IOViewOptionsDlg.this.mExcludeNotEdgeAlignedBumpDevices.isSelected());
            UIUtil.closeWindow((Window)((Object)IOViewOptionsDlg.this));
        }
    };

    public static IOViewOptionsDlg createDialog(Window owner, IOView ioView) {
        IOViewOptionsDlg dlg = null;
        dlg = new IOViewOptionsDlg(owner);
        dlg.init(ioView);
        return dlg;
    }

    public IOViewOptionsDlg(Window owner) throws HeadlessException {
        super(owner);
    }

    protected void init(IOView ioView) {
        this.mView = OrbitIO.getCurView();
        this.mIOView = ioView;
        this.setTitle("IOView Preferences");
        this.setModal(true);
        GridBagManager l = new GridBagManager(this.getContentPane());
        l.push("Tree Look", (GridBagConstraints)GridBagManager.LEFT);
        this.mShowTemplateNames = new JCheckBox("Show Template Names");
        l.add((Component)this.mShowTemplateNames);
        l.newline();
        this.mShowInstanceNames = new JCheckBox("Show Instance Names");
        l.add((Component)this.mShowInstanceNames);
        l.newline();
        this.mColorByPass = new JCheckBox("Color Devices By Decoration Pass");
        l.add((Component)this.mColorByPass);
        l.newline();
        this.mShowByDefinitionOrder = new JCheckBox("Display Devices In Definition Order");
        l.add((Component)this.mShowByDefinitionOrder);
        l.newline();
        this.mDisplayPinsInTechnologyOrder = new JCheckBox("Display Pins In Technology File Order");
        l.add((Component)this.mDisplayPinsInTechnologyOrder);
        l.newline();
        this.mShowTopLevelNetIcon = new JCheckBox("Show Top Level Net Name Template Icon");
        l.add((Component)this.mShowTopLevelNetIcon);
        l.popNl();
        l.push("Automation", (GridBagConstraints)GridBagManager.LEFT);
        this.mAutoResizeDie = new JCheckBox("Auto Resize Die After Each Decorate All");
        l.add((Component)this.mAutoResizeDie);
        l.newline();
        this.mAvoidOverlap = new JCheckBox("Adjust Interfaces to Avoid Corner Overlap When Resizing Die");
        l.add((Component)this.mAvoidOverlap);
        l.newline();
        this.mCreateDefaultNN = new JCheckBox("Create Default Names When Cloning Devices");
        l.add((Component)this.mCreateDefaultNN);
        l.newline();
        this.mAddInterfaceNames = new JCheckBox("Add Interface Name When Creating Default Net Name");
        l.add((Component)this.mAddInterfaceNames);
        l.newline();
        this.mHideOutsideSubstrate = new JCheckBox("Hide Connections Going To Other Substrates");
        l.addNl((Component)this.mHideOutsideSubstrate);
        this.mExcludeNotEdgeAlignedCoverDevices = new JCheckBox("Hide Not Edge Aligned Cover Devices");
        l.addNl((Component)this.mExcludeNotEdgeAlignedCoverDevices);
        this.mExcludeNotEdgeAlignedBumpDevices = new JCheckBox("Hide Not Edge Aligned Bump Devices");
        l.addNl((Component)this.mExcludeNotEdgeAlignedBumpDevices);
        l.popNl();
        this.mGridPanel = new GridPanel();
        l.add((Component)this.mGridPanel);
        l.newline();
        l.push((Container)new JPanel(), (GridBagConstraints)GridBagManager.RIGHT_REMAINX);
        JButton btnOk = new JButton("OK");
        l.add((Component)btnOk, (GridBagConstraints)GridBagManager.RIGHT);
        btnOk.addActionListener(this.mOk);
        JButton btnClose = new JButton("Cancel");
        l.add((Component)btnClose, (GridBagConstraints)GridBagManager.RIGHT);
        l.pop();
        this.updateUI();
        UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnClose, (JButton)btnOk);
        this.pack();
        this.setMinimumSize(this.getPreferredSize());
        UIUtil.center((Component)((Object)this));
    }

    protected void updateUI() {
        boolean autoResize = IOView.theIOView.getAutoSize();
        boolean avoidOverlap = IOView.theIOView.getAvoidOverlap();
        boolean showTemplateNames = IOView.theIOView.getShowTemplateNames();
        boolean showDeviceNames = IOView.theIOView.getShowDeviceNames();
        boolean createDefault = IOView.theIOView.getCreateDefaultNetNames();
        boolean addInterfaceNames = IOView.theIOView.getAddInterfaceNames();
        boolean colorByPass = IOView.theIOView.getColorByPass();
        boolean hideOutsideSubstrate = IOView.theIOView.getHideOutsideSubstrate();
        boolean excludeNotEdgeAlignedCoverDevices = IOView.theIOView.getExcludeNotEdgeAlignedCoverDevices();
        boolean excludeNotEdgeAlignedBumpDevices = IOView.theIOView.getExcludeNotEdgeAlignedBumpDevices();
        boolean showByDefinitionOrder = IOView.theIOView.getShowByDefinitionOrder();
        boolean displayInTechnologyOrder = IOView.theIOView.getDisplayInTechnologyOrder();
        boolean showTopLevelNetIcon = IOView.theIOView.getShowTopLevelNetIcon();
        this.mAutoResizeDie.setSelected(autoResize);
        this.mAvoidOverlap.setSelected(avoidOverlap);
        this.mShowInstanceNames.setSelected(showDeviceNames);
        this.mShowTemplateNames.setSelected(showTemplateNames);
        this.mCreateDefaultNN.setSelected(createDefault);
        this.mAddInterfaceNames.setSelected(addInterfaceNames);
        this.mColorByPass.setSelected(colorByPass);
        this.mHideOutsideSubstrate.setSelected(hideOutsideSubstrate);
        this.mExcludeNotEdgeAlignedCoverDevices.setSelected(excludeNotEdgeAlignedCoverDevices);
        this.mExcludeNotEdgeAlignedBumpDevices.setSelected(excludeNotEdgeAlignedBumpDevices);
        this.mShowByDefinitionOrder.setSelected(showByDefinitionOrder);
        this.mDisplayPinsInTechnologyOrder.setSelected(displayInTechnologyOrder);
        this.mShowTopLevelNetIcon.setSelected(showTopLevelNetIcon);
    }

    protected class GridPanel
    extends JPanel {
        protected JTextField mGridDx;
        protected JTextField mGridDy;
        protected JTextField mGridOx;
        protected JTextField mGridOy;
        protected JTextField mMajorGrid;

        protected GridPanel() {
            GridBagManager l = new GridBagManager((Container)this);
            l.pushFillX("Bump Grid for Die Substrate");
            l.add((Component)new JLabel("X Space:"), (GridBagConstraints)GridBagManager.LEFT);
            this.mGridDx = new JTextField("0", 4);
            l.add((Component)this.mGridDx, (GridBagConstraints)GridBagManager.LEFT);
            l.add((Component)new JLabel("Y Space:"), (GridBagConstraints)GridBagManager.LEFT);
            this.mGridDy = new JTextField("0", 4);
            l.add((Component)this.mGridDy, (GridBagConstraints)GridBagManager.LEFT);
            l.newline();
            l.add((Component)new JLabel("X Offset:"), (GridBagConstraints)GridBagManager.LEFT);
            this.mGridOx = new JTextField("0", 4);
            l.add((Component)this.mGridOx, (GridBagConstraints)GridBagManager.LEFT);
            l.add((Component)new JLabel("Y Offset:"), (GridBagConstraints)GridBagManager.LEFT);
            this.mGridOy = new JTextField("0", 4);
            l.add((Component)this.mGridOy, (GridBagConstraints)GridBagManager.LEFT);
            l.newline();
            l.add((Component)new JLabel("Major Grid "), (GridBagConstraints)GridBagManager.LEFT);
            this.mMajorGrid = new JTextField("0", 4);
            l.add((Component)this.mMajorGrid, (GridBagConstraints)GridBagManager.LEFT);
            l.newline();
            l.pushFillXRemainX();
            l.addFillX();
            l.pop();
            l.pop();
            l.newline();
            this.updateGrids();
        }

        public void saveGrid() {
            DevicePath dp = IOViewOptionsDlg.this.mIOView.getRootDevicePath();
            String cmd = String.format("NamedGrid.create (\"%s\", \"%s\", %f, %f, %f, %f, %d)", dp.toString(), "Pin Grid", Double.parseDouble(this.mGridDx.getText().replace(",", "")), Double.parseDouble(this.mGridDy.getText().replace(",", "")), Double.parseDouble(this.mGridOx.getText().replace(",", "")), Double.parseDouble(this.mGridOy.getText().replace(",", "")), Integer.parseInt(this.mMajorGrid.getText()));
            Cp.exec(() -> NamedGrid.create((String)dp.toString(), (String)"Pin Grid", (double)Double.parseDouble(this.mGridDx.getText().replace(",", "")), (double)Double.parseDouble(this.mGridDy.getText().replace(",", "")), (double)Double.parseDouble(this.mGridOx.getText().replace(",", "")), (double)Double.parseDouble(this.mGridOy.getText().replace(",", "")), (int)Integer.parseInt(this.mMajorGrid.getText())), (String)cmd, (Object[])new Object[0]);
        }

        protected void updateGrids() {
            DeviceTemplate dt = IOViewOptionsDlg.this.mIOView.getRootDevicePath().getDeviceTemplate();
            if (dt == null) {
                return;
            }
            Db db = OrbitIO.getCurDb();
            Unit unit = Design.getUnit((Db)db);
            Substrate s = dt.getSubstrate();
            NamedGrid ng = NamedGrid.get((Substrate)s, (String)"Pin Grid");
            if (ng == null) {
                ng = NamedGrid.get((Substrate)s, (String)"Manufacturing Grid");
            }
            if (ng != null) {
                String f = unit.formatUser(unit.toUser(ng.getGrid().getDeltaX()));
                this.mGridDx.setText(f);
                f = unit.formatUser(unit.toUser(ng.getGrid().getDeltaY()));
                this.mGridDy.setText(f);
                f = unit.formatUser(unit.toUser(ng.getGrid().getOrignX()));
                this.mGridOx.setText(f);
                f = unit.formatUser(unit.toUser(ng.getGrid().getOrignY()));
                this.mGridOy.setText(f);
                f = Integer.toString(ng.getMajor());
                this.mMajorGrid.setText(f);
            }
        }

        class saveGridButtonAction
        implements ActionListener {
            saveGridButtonAction() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                GridPanel.this.saveGrid();
            }
        }
    }
}

