/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.iov;

import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.iov.IOView;
import com.sigrity.orbit.iov.IOViewEditBlockDlg;

public class IOViewRegistry {
    public static void testAddIOViewEditNetMethod() {
        IOView.AllowNetChangesInIOViewRegistry.set(new myEditNetMethod());
    }

    public static class myEditNetMethod
    implements IOView.AllowNetChangesInIOView {
        @Override
        public boolean allow(HierInst<PinTemplate> hierPinTemplate) {
            Device device = ((DevicePath)hierPinTemplate.first).getLast();
            DeviceTemplate dt = device.getTemplate();
            PinTemplate pt = (PinTemplate)hierPinTemplate.second;
            PinTemplate.Type ptType = pt.getType();
            PinInstance pinInstance = device.getPin(pt);
            if (pinInstance.fixed()) {
                return false;
            }
            if (dt.getName().toLowerCase().contains("pm20")) {
                return true;
            }
            if (ptType != PinTemplate.Type.BUMPPAD) {
                return true;
            }
            return IOViewEditBlockDlg.allowBumpsToBeUnlocked;
        }

        @Override
        public String description() {
            return "Anything but a bump...";
        }
    }

    public static class AllowNetChangesInIOViewRegistry {
        protected static AllowNetChangesInIOView registry = null;

        public static void set(AllowNetChangesInIOView method) {
            registry = method;
        }

        protected static AllowNetChangesInIOView getCurrentMethod() {
            return registry;
        }
    }

    public static interface AllowNetChangesInIOView {
        public boolean allow(HierInst<PinTemplate> var1);

        public String description();
    }
}

